--
-- PostgreSQL database dump
--

SET statement_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = off;
SET check_function_bodies = false;
SET client_min_messages = warning;
SET escape_string_warning = off;

--
-- Name: plpgsql; Type: PROCEDURAL LANGUAGE; Schema: -; Owner: -
--

CREATE OR REPLACE PROCEDURAL LANGUAGE plpgsql;


SET search_path = public, pg_catalog;

--
-- Name: pg_file_length(text); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION pg_file_length(text) RETURNS bigint
    LANGUAGE sql STRICT
    AS $_$SELECT len FROM pg_file_stat($1) AS s(len int8, c timestamp, a timestamp, m timestamp, i bool)$_$;


--
-- Name: pg_file_rename(text, text); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION pg_file_rename(text, text) RETURNS boolean
    LANGUAGE sql STRICT
    AS $_$SELECT pg_file_rename($1, $2, NULL); $_$;


--
-- Name: sem_acento(text); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION sem_acento(text) RETURNS text
    LANGUAGE sql IMMUTABLE STRICT
    AS $_$

select

translate($1,'áàâãäéèêëíìïóòôõöúùûüÁÀÂÃÄÉÈÊËÍÌÏÓÒÔÕÖÚÙÛÜçÇ','aaaaaeeeeiiiooooouuuuAAAAAEEEEIIIOOOOOUUUUcC');

$_$;


--
-- Name: utf8_to_ascii(text); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION utf8_to_ascii(text) RETURNS text
    LANGUAGE sql IMMUTABLE STRICT
    AS $_$

select

to_ascii(convert($1, 'UTF8', 'LATIN1'), 'LATIN1');

$_$;


SET default_tablespace = '';

SET default_with_oids = false;

--
-- Name: agenda_telefones; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE agenda_telefones (
    id integer NOT NULL,
    nome character varying,
    telefone character varying,
    celular character varying,
    fixo character varying,
    observacao character varying,
    apelido character varying
);


--
-- Name: agenda_telefones_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE agenda_telefones_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: agenda_telefones_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE agenda_telefones_id_seq OWNED BY agenda_telefones.id;


--
-- Name: agenda_telefones_id_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('agenda_telefones_id_seq', 3, true);


--
-- Name: andamento_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE andamento_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: andamento_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('andamento_seq', 1, false);


SET default_with_oids = true;

--
-- Name: cd_admmunicipal; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE cd_admmunicipal (
    adm_id integer NOT NULL,
    cod_cidade integer NOT NULL,
    pessoa_id integer,
    cargo character varying(30),
    nome character varying(80),
    partido character varying(30)
);


--
-- Name: cd_admmunicipal_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE cd_admmunicipal_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: cd_admmunicipal_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('cd_admmunicipal_seq', 68, true);


--
-- Name: cd_andamento; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE cd_andamento (
    codigo integer NOT NULL,
    codigo_prontuario integer,
    data character varying,
    situacao text,
    inc_user character varying(15),
    alt_user character varying(15)
);


--
-- Name: cd_andamento_mr; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE cd_andamento_mr (
    codigo integer NOT NULL,
    codigo_prontuario integer,
    data character varying,
    situacao text,
    inc_user character varying(15),
    alt_user character varying(15)
);


--
-- Name: cd_andamento_mr_codigo_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE cd_andamento_mr_codigo_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: cd_andamento_mr_codigo_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE cd_andamento_mr_codigo_seq OWNED BY cd_andamento_mr.codigo;


--
-- Name: cd_andamento_mr_codigo_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('cd_andamento_mr_codigo_seq', 1, false);


--
-- Name: cd_andamento_mr_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE cd_andamento_mr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: cd_andamento_mr_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('cd_andamento_mr_seq', 1, true);


--
-- Name: cd_andamento_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE cd_andamento_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: cd_andamento_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('cd_andamento_seq', 3, true);


--
-- Name: cd_areas; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE cd_areas (
    area character varying(20) NOT NULL,
    descricao character varying(50) NOT NULL,
    inc_user character varying(10),
    alt_user character varying(10)
);


--
-- Name: cd_bairros; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE cd_bairros (
    cod_cidade integer NOT NULL,
    bairro character varying(50) NOT NULL,
    inc_user character varying(10),
    alt_user character varying(10)
);


--
-- Name: cd_cargos; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE cd_cargos (
    cargo character varying(30) NOT NULL,
    inc_user character varying(10),
    alt_user character varying(10)
);


--
-- Name: cd_cep_br; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE cd_cep_br (
    cep character varying(50) NOT NULL,
    cod_cidade character(9),
    endereco character varying(50),
    bairro character varying(50)
);


--
-- Name: cd_cidades; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE cd_cidades (
    cod_cidade integer NOT NULL,
    cidade character varying(50) NOT NULL,
    pais character varying(2) DEFAULT 'BR'::character varying NOT NULL,
    uf character varying(2),
    regiao character varying(20),
    aniversario character varying(15),
    cidadealvo character varying,
    historico character varying,
    no_habitantes integer,
    no_eleitores integer,
    inc_user character varying(10),
    alt_user character varying(10),
    psb_local text
);


--
-- Name: cd_cidades_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE cd_cidades_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    MAXVALUE 9999999
    CACHE 1;


--
-- Name: cd_cidades_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('cd_cidades_seq', 5766, true);


SET default_with_oids = false;

--
-- Name: cd_custom; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE cd_custom (
    id integer NOT NULL,
    descricao text,
    status character(1)
);


--
-- Name: cd_custom_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE cd_custom_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: cd_custom_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE cd_custom_id_seq OWNED BY cd_custom.id;


--
-- Name: cd_custom_id_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('cd_custom_id_seq', 1, false);


--
-- Name: rownum1; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE rownum1
    START WITH 1
    INCREMENT BY 1
    MINVALUE 0
    NO MAXVALUE
    CACHE 1;


--
-- Name: rownum1; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('rownum1', 13, true);


--
-- Name: cd_emendas; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE cd_emendas (
    numero integer NOT NULL,
    data date,
    ementa character varying(250),
    inc_user character varying(10),
    alt_user character varying(10),
    resultado character varying(60),
    status character(1),
    identificador integer DEFAULT nextval('rownum1'::regclass),
    evento integer
);


--
-- Name: cd_emendas_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE cd_emendas_seq
    START WITH 1
    INCREMENT BY 1
    MINVALUE 0
    NO MAXVALUE
    CACHE 1;


--
-- Name: cd_emendas_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('cd_emendas_seq', 0, true);


SET default_with_oids = true;

--
-- Name: cd_firmas; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE cd_firmas (
    firma integer NOT NULL,
    nome character varying(100) NOT NULL,
    endereco character varying(100),
    complemento character varying(100),
    cod_cidade integer,
    bairro character varying(100),
    uf character varying(3),
    pais character varying(3),
    cep character varying(30),
    area character varying(20),
    regiao character varying(20),
    email character varying(150),
    sexo character(1) DEFAULT 'N'::character varying,
    _nascto character varying(12),
    uf_civil character(1) DEFAULT 'N'::character varying,
    status character(1) DEFAULT 'A'::character varying,
    fone1 character varying(30),
    fone2 character varying(30),
    apelido character varying(50),
    celular character varying(30),
    tipo_pes character(1) DEFAULT 'F'::character varying,
    titulo character varying(20),
    email2 character varying(50),
    profissao character varying(100),
    observacoes text,
    inc_user character varying,
    alt_user character varying,
    instituicao character varying(50),
    cargo character varying(150),
    numero character varying(50),
    nascto date,
    origem character varying DEFAULT 'indefinido'::character varying NOT NULL,
    historico character varying(12) DEFAULT 'indefinido'::character varying NOT NULL,
    obs text,
    classificacao integer DEFAULT 1,
    filhos character varying,
    inc_data timestamp without time zone,
    alt_data timestamp without time zone,
    latitude character varying,
    longitude character varying,
    status_geocode character varying,
    foto character varying,
    time1 character varying,
    time2 character varying,
    animal_estimacao character varying,
    qual_animal character varying,
    cod_ant character varying,
    rg character varying,
    cpf character varying,
    cartao_sus character varying,
    data_contato character varying,
    cod_cidade_bkp integer,
    email_enviado character varying(1),
    titulo_eleit character varying,
    zona_eleit character varying,
    sess_eleit character varying,
    whatsapp character varying,
    CONSTRAINT cd_firmas_ck1 CHECK ((((sexo = 'M'::bpchar) OR (sexo = 'F'::bpchar)) OR (sexo = 'N'::bpchar))),
    CONSTRAINT cd_firmas_ck3 CHECK (((((status = 'S'::bpchar) OR (status = 'N'::bpchar)) OR (status = 'A'::bpchar)) OR (status = 'F'::bpchar)))
);


--
-- Name: cd_firmas_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE cd_firmas_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    MAXVALUE 9999999
    CACHE 1;


--
-- Name: cd_firmas_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('cd_firmas_seq', 72459, true);


SET default_with_oids = false;

--
-- Name: cd_indicacoes; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE cd_indicacoes (
    numero integer NOT NULL,
    data date,
    ementa character varying(250),
    cmrp character(10),
    resultado character varying(60),
    inc_user character varying(10),
    alt_user character varying(10),
    status character(1),
    identificador integer DEFAULT nextval('rownum1'::regclass),
    evento integer
);


--
-- Name: cd_indicacoes_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE cd_indicacoes_seq
    START WITH 1
    INCREMENT BY 1
    MINVALUE 0
    NO MAXVALUE
    CACHE 1;


--
-- Name: cd_indicacoes_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('cd_indicacoes_seq', 0, true);


SET default_with_oids = true;

--
-- Name: cd_instituicoes; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE cd_instituicoes (
    instituicoes integer NOT NULL,
    nome character varying(50) NOT NULL,
    endereco character varying(50),
    complemento character varying(50),
    cod_cidade integer,
    bairro character varying(50),
    uf character varying(3),
    cep character varying(30),
    email character varying(50),
    status character(1),
    fone1 character varying(30),
    fax character varying(30),
    site character varying,
    dirigente character varying(50),
    cargo_dirigente character varying(50),
    _atualizacao timestamp without time zone,
    atualizacao date,
    obs text,
    numero character varying,
    inc_user character varying,
    alt_user character varying,
    inc_data timestamp without time zone,
    alt_data timestamp without time zone,
    CONSTRAINT cd_firmas_ck3 CHECK (((((status = 'S'::bpchar) OR (status = 'N'::bpchar)) OR (status = 'A'::bpchar)) OR (status = 'F'::bpchar)))
);


--
-- Name: cd_instituicoes_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE cd_instituicoes_seq
    START WITH 1
    INCREMENT BY 1
    MINVALUE 0
    NO MAXVALUE
    CACHE 1;


--
-- Name: cd_instituicoes_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('cd_instituicoes_seq', 0, true);


--
-- Name: cd_oficios; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE cd_oficios (
    ano numeric(4,0),
    data date,
    destinatario character varying(50),
    assunto character varying(250),
    sigla character varying(10),
    responsavel character varying(15),
    sequencia integer NOT NULL,
    tratamento character varying,
    cargo character varying(250),
    cep character varying(250),
    endereco character varying(250),
    cidade character varying(250),
    uf character varying(2),
    status character(1),
    identificador integer DEFAULT nextval('rownum1'::regclass),
    evento integer
);


SET default_with_oids = false;

--
-- Name: cd_oficios_arquivo; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE cd_oficios_arquivo (
    idarquivo integer NOT NULL,
    idoficio integer NOT NULL,
    legenda character varying(80),
    arquivo character varying(50),
    mime character varying(50),
    tipo character varying(50),
    texto text,
    status character(1)
);


--
-- Name: cd_oficios_arquivo_idarquivo_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE cd_oficios_arquivo_idarquivo_seq
    START WITH 1
    INCREMENT BY 1
    MINVALUE 0
    NO MAXVALUE
    CACHE 1;


--
-- Name: cd_oficios_arquivo_idarquivo_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE cd_oficios_arquivo_idarquivo_seq OWNED BY cd_oficios_arquivo.idarquivo;


--
-- Name: cd_oficios_arquivo_idarquivo_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('cd_oficios_arquivo_idarquivo_seq', 0, true);


SET default_with_oids = true;

--
-- Name: cd_oficios_circulares; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE cd_oficios_circulares (
    ano numeric(4,0),
    data date,
    destinatario character varying(50),
    assunto character varying(250),
    sigla character varying(10),
    responsavel character varying(15),
    sequencia integer NOT NULL,
    status character(1),
    identificador integer DEFAULT nextval('rownum1'::regclass),
    evento integer
);


SET default_with_oids = false;

--
-- Name: cd_oficios_circulares_arquivo; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE cd_oficios_circulares_arquivo (
    idarquivo integer NOT NULL,
    idoficio integer NOT NULL,
    legenda character varying(80),
    arquivo character varying(50),
    mime character varying(50),
    tipo character varying(50),
    texto text,
    status character(1)
);


--
-- Name: cd_oficios_circulares_arquivo_idarquivo_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE cd_oficios_circulares_arquivo_idarquivo_seq
    START WITH 1
    INCREMENT BY 1
    MINVALUE 0
    NO MAXVALUE
    CACHE 1;


--
-- Name: cd_oficios_circulares_arquivo_idarquivo_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE cd_oficios_circulares_arquivo_idarquivo_seq OWNED BY cd_oficios_circulares_arquivo.idarquivo;


--
-- Name: cd_oficios_circulares_arquivo_idarquivo_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('cd_oficios_circulares_arquivo_idarquivo_seq', 0, true);


--
-- Name: cd_oficios_circulares_sequencia_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE cd_oficios_circulares_sequencia_seq
    START WITH 1
    INCREMENT BY 1
    MINVALUE 0
    NO MAXVALUE
    CACHE 1;


--
-- Name: cd_oficios_circulares_sequencia_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE cd_oficios_circulares_sequencia_seq OWNED BY cd_oficios_circulares.sequencia;


--
-- Name: cd_oficios_circulares_sequencia_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('cd_oficios_circulares_sequencia_seq', 0, true);


--
-- Name: cd_oficios_prontuario_arquivo; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE cd_oficios_prontuario_arquivo (
    idarquivo integer NOT NULL,
    idoficio integer NOT NULL,
    legenda character varying(80),
    arquivo character varying(50),
    mime character varying(50),
    tipo character varying(50),
    texto text,
    status character(1)
);


--
-- Name: cd_oficios_prontuario_arquivo_idarquivo_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE cd_oficios_prontuario_arquivo_idarquivo_seq
    START WITH 1
    INCREMENT BY 1
    MINVALUE 0
    NO MAXVALUE
    CACHE 1;


--
-- Name: cd_oficios_prontuario_arquivo_idarquivo_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE cd_oficios_prontuario_arquivo_idarquivo_seq OWNED BY cd_oficios_prontuario_arquivo.idarquivo;


--
-- Name: cd_oficios_prontuario_arquivo_idarquivo_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('cd_oficios_prontuario_arquivo_idarquivo_seq', 0, true);


--
-- Name: cd_oficios_prontuario_mr_arquivo; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE cd_oficios_prontuario_mr_arquivo (
    idarquivo integer NOT NULL,
    idoficio integer NOT NULL,
    legenda character varying(80),
    arquivo character varying(50),
    mime character varying(50),
    tipo character varying(50),
    texto text,
    status character(1)
);


--
-- Name: cd_oficios_prontuario_mr_arquivo_idarquivo_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE cd_oficios_prontuario_mr_arquivo_idarquivo_seq
    START WITH 1
    INCREMENT BY 1
    MINVALUE 0
    NO MAXVALUE
    CACHE 1;


--
-- Name: cd_oficios_prontuario_mr_arquivo_idarquivo_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE cd_oficios_prontuario_mr_arquivo_idarquivo_seq OWNED BY cd_oficios_prontuario_mr_arquivo.idarquivo;


--
-- Name: cd_oficios_prontuario_mr_arquivo_idarquivo_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('cd_oficios_prontuario_mr_arquivo_idarquivo_seq', 0, true);


--
-- Name: cd_oficios_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE cd_oficios_seq
    START WITH 1
    INCREMENT BY 1
    MINVALUE 0
    NO MAXVALUE
    CACHE 1;


--
-- Name: cd_oficios_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('cd_oficios_seq', 0, true);


--
-- Name: cd_oficios_sequencia_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE cd_oficios_sequencia_seq
    START WITH 1
    INCREMENT BY 1
    MINVALUE 0
    NO MAXVALUE
    CACHE 1;


--
-- Name: cd_oficios_sequencia_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE cd_oficios_sequencia_seq OWNED BY cd_oficios.sequencia;


--
-- Name: cd_oficios_sequencia_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('cd_oficios_sequencia_seq', 0, true);


SET default_with_oids = true;

--
-- Name: cd_paises; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE cd_paises (
    pais character varying(2) NOT NULL,
    nome character varying(50) NOT NULL,
    masc_cep character varying(20),
    inc_user character varying(10),
    alt_user character varying(10)
);


--
-- Name: cd_pessoaspublicas; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE cd_pessoaspublicas (
    pepub_id integer NOT NULL,
    cod_cidade integer,
    cargo character varying(30),
    pessoa character varying NOT NULL,
    partido character varying(30),
    inc_user character varying(10),
    alt_user character varying(10),
    instituicao character varying(50)
);


--
-- Name: cd_pessoaspublicas_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE cd_pessoaspublicas_seq
    START WITH 1
    INCREMENT BY 1
    MINVALUE 0
    NO MAXVALUE
    CACHE 1;


--
-- Name: cd_pessoaspublicas_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('cd_pessoaspublicas_seq', 0, true);


--
-- Name: cd_pleitos; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE cd_pleitos (
    pleito_id integer NOT NULL,
    cod_cidade integer,
    ano integer,
    votos integer,
    inc_user character varying(10),
    alt_user character varying(10)
);


--
-- Name: cd_pleitos_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE cd_pleitos_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: cd_pleitos_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('cd_pleitos_seq', 216, true);


--
-- Name: cd_prgen; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE cd_prgen (
    "MASC_AREA" character varying(20),
    "MASC_REGIAO" character varying(20),
    cid_padrao integer
);


SET default_with_oids = false;

--
-- Name: cd_projeto_declegislativo; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE cd_projeto_declegislativo (
    numero integer NOT NULL,
    categoria character varying(4),
    ementa character varying(250),
    cmrp character(10),
    resultado character varying(60),
    inc_user character varying(10),
    alt_user character varying(10),
    data date,
    status character(1),
    identificador integer DEFAULT nextval('rownum1'::regclass),
    evento integer
);


--
-- Name: cd_projeto_declegislativo_arquivo; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE cd_projeto_declegislativo_arquivo (
    idarquivo integer NOT NULL,
    idprojeto integer NOT NULL,
    legenda character varying(80),
    arquivo character varying(50),
    mime character varying(50),
    tipo character varying(50),
    texto text,
    status character(1)
);


--
-- Name: cd_projeto_declegislativo_arquivo_idarquivo_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE cd_projeto_declegislativo_arquivo_idarquivo_seq
    START WITH 1
    INCREMENT BY 1
    MINVALUE 0
    NO MAXVALUE
    CACHE 1;


--
-- Name: cd_projeto_declegislativo_arquivo_idarquivo_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE cd_projeto_declegislativo_arquivo_idarquivo_seq OWNED BY cd_projeto_declegislativo_arquivo.idarquivo;


--
-- Name: cd_projeto_declegislativo_arquivo_idarquivo_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('cd_projeto_declegislativo_arquivo_idarquivo_seq', 0, true);


--
-- Name: cd_projeto_declegislativo_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE cd_projeto_declegislativo_seq
    START WITH 1
    INCREMENT BY 1
    MINVALUE 0
    NO MAXVALUE
    CACHE 1;


--
-- Name: cd_projeto_declegislativo_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('cd_projeto_declegislativo_seq', 0, true);


--
-- Name: cd_projeto_emendas_arquivo; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE cd_projeto_emendas_arquivo (
    idarquivo integer NOT NULL,
    idprojeto integer NOT NULL,
    legenda character varying(80),
    arquivo character varying(50),
    mime character varying(50),
    tipo character varying(50),
    texto text,
    status character(1)
);


--
-- Name: cd_projeto_emendas_arquivo_idarquivo_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE cd_projeto_emendas_arquivo_idarquivo_seq
    START WITH 1
    INCREMENT BY 1
    MINVALUE 0
    NO MAXVALUE
    CACHE 1;


--
-- Name: cd_projeto_emendas_arquivo_idarquivo_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE cd_projeto_emendas_arquivo_idarquivo_seq OWNED BY cd_projeto_emendas_arquivo.idarquivo;


--
-- Name: cd_projeto_emendas_arquivo_idarquivo_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('cd_projeto_emendas_arquivo_idarquivo_seq', 0, true);


--
-- Name: cd_projeto_indicacoes_arquivo; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE cd_projeto_indicacoes_arquivo (
    idarquivo integer NOT NULL,
    idprojeto integer NOT NULL,
    legenda character varying(80),
    arquivo character varying(50),
    mime character varying(50),
    tipo character varying(50),
    texto text,
    status character(1)
);


--
-- Name: cd_projeto_indicacoes_arquivo_idarquivo_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE cd_projeto_indicacoes_arquivo_idarquivo_seq
    START WITH 1
    INCREMENT BY 1
    MINVALUE 0
    NO MAXVALUE
    CACHE 1;


--
-- Name: cd_projeto_indicacoes_arquivo_idarquivo_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE cd_projeto_indicacoes_arquivo_idarquivo_seq OWNED BY cd_projeto_indicacoes_arquivo.idarquivo;


--
-- Name: cd_projeto_indicacoes_arquivo_idarquivo_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('cd_projeto_indicacoes_arquivo_idarquivo_seq', 0, true);


--
-- Name: cd_projeto_leicomp; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE cd_projeto_leicomp (
    numero integer NOT NULL,
    categoria character varying(4),
    ementa character varying(250),
    cmrp character(10),
    resultado character varying(60),
    inc_user character varying(10),
    alt_user character varying(10),
    data date,
    status character(1),
    identificador integer DEFAULT nextval('rownum1'::regclass),
    evento integer
);


--
-- Name: cd_projeto_leicomp_arquivo; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE cd_projeto_leicomp_arquivo (
    idarquivo integer NOT NULL,
    idprojeto integer NOT NULL,
    legenda character varying(80),
    arquivo character varying(50),
    mime character varying(50),
    tipo character varying(50),
    texto text,
    status character(1)
);


--
-- Name: cd_projeto_leicomp_arquivo_idarquivo_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE cd_projeto_leicomp_arquivo_idarquivo_seq
    START WITH 1
    INCREMENT BY 1
    MINVALUE 0
    NO MAXVALUE
    CACHE 1;


--
-- Name: cd_projeto_leicomp_arquivo_idarquivo_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE cd_projeto_leicomp_arquivo_idarquivo_seq OWNED BY cd_projeto_leicomp_arquivo.idarquivo;


--
-- Name: cd_projeto_leicomp_arquivo_idarquivo_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('cd_projeto_leicomp_arquivo_idarquivo_seq', 0, true);


--
-- Name: cd_projeto_leicomp_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE cd_projeto_leicomp_seq
    START WITH 1
    INCREMENT BY 1
    MINVALUE 0
    NO MAXVALUE
    CACHE 1;


--
-- Name: cd_projeto_leicomp_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('cd_projeto_leicomp_seq', 0, true);


--
-- Name: cd_projeto_leis; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE cd_projeto_leis (
    numero integer NOT NULL,
    categoria character varying(4),
    ementa character varying(250),
    cmrp character(10),
    resultado character varying(60),
    inc_user character varying(50),
    alt_user character varying(50),
    data date,
    status character(1),
    identificador integer DEFAULT nextval('rownum1'::regclass),
    evento integer
);


--
-- Name: cd_projeto_leis_arquivo; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE cd_projeto_leis_arquivo (
    idarquivo integer NOT NULL,
    idprojeto integer NOT NULL,
    legenda character varying(80),
    arquivo character varying(50),
    mime character varying(50),
    tipo character varying(50),
    texto text,
    status character(1)
);


--
-- Name: cd_projeto_leis_arquivo_idarquivo_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE cd_projeto_leis_arquivo_idarquivo_seq
    START WITH 1
    INCREMENT BY 1
    MINVALUE 0
    NO MAXVALUE
    CACHE 1;


--
-- Name: cd_projeto_leis_arquivo_idarquivo_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE cd_projeto_leis_arquivo_idarquivo_seq OWNED BY cd_projeto_leis_arquivo.idarquivo;


--
-- Name: cd_projeto_leis_arquivo_idarquivo_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('cd_projeto_leis_arquivo_idarquivo_seq', 0, true);


--
-- Name: cd_projeto_leis_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE cd_projeto_leis_seq
    START WITH 1
    INCREMENT BY 1
    MINVALUE 0
    NO MAXVALUE
    CACHE 1;


--
-- Name: cd_projeto_leis_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('cd_projeto_leis_seq', 0, true);


--
-- Name: cd_projeto_requerimento_arquivo; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE cd_projeto_requerimento_arquivo (
    idarquivo integer NOT NULL,
    idprojeto integer NOT NULL,
    legenda character varying(80),
    arquivo character varying(50),
    mime character varying(50),
    tipo character varying(50),
    texto text,
    status character(1)
);


--
-- Name: cd_projeto_requerimento_arquivo_idarquivo_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE cd_projeto_requerimento_arquivo_idarquivo_seq
    START WITH 1
    INCREMENT BY 1
    MINVALUE 0
    NO MAXVALUE
    CACHE 1;


--
-- Name: cd_projeto_requerimento_arquivo_idarquivo_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE cd_projeto_requerimento_arquivo_idarquivo_seq OWNED BY cd_projeto_requerimento_arquivo.idarquivo;


--
-- Name: cd_projeto_requerimento_arquivo_idarquivo_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('cd_projeto_requerimento_arquivo_idarquivo_seq', 8, true);


--
-- Name: cd_projeto_resolucao; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE cd_projeto_resolucao (
    numero integer NOT NULL,
    categoria character varying(4),
    ementa character varying(250),
    cmrp character(10),
    resultado character varying(60),
    inc_user character varying(10),
    alt_user character varying(10),
    data date,
    status character(1),
    identificador integer DEFAULT nextval('rownum1'::regclass),
    evento integer
);


--
-- Name: cd_projeto_resolucao_arquivo; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE cd_projeto_resolucao_arquivo (
    idarquivo integer NOT NULL,
    idprojeto integer NOT NULL,
    legenda character varying(80),
    arquivo character varying(50),
    mime character varying(50),
    tipo character varying(50),
    texto text,
    status character(1)
);


--
-- Name: cd_projeto_resolucao_arquivo_idarquivo_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE cd_projeto_resolucao_arquivo_idarquivo_seq
    START WITH 1
    INCREMENT BY 1
    MINVALUE 0
    NO MAXVALUE
    CACHE 1;


--
-- Name: cd_projeto_resolucao_arquivo_idarquivo_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE cd_projeto_resolucao_arquivo_idarquivo_seq OWNED BY cd_projeto_resolucao_arquivo.idarquivo;


--
-- Name: cd_projeto_resolucao_arquivo_idarquivo_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('cd_projeto_resolucao_arquivo_idarquivo_seq', 0, true);


--
-- Name: cd_projeto_resolucao_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE cd_projeto_resolucao_seq
    START WITH 1
    INCREMENT BY 1
    MINVALUE 0
    NO MAXVALUE
    CACHE 1;


--
-- Name: cd_projeto_resolucao_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('cd_projeto_resolucao_seq', 0, true);


SET default_with_oids = true;

--
-- Name: cd_prontuario; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE cd_prontuario (
    codigo integer NOT NULL,
    _data character varying,
    assunto character varying,
    instituicao character varying,
    pessoa character varying,
    observacoes character varying,
    status character(1),
    prontfisico character(1),
    inc_user character varying(10),
    alt_user character varying(10),
    solicitante character varying,
    data timestamp without time zone
);


--
-- Name: cd_prontuario_mr; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE cd_prontuario_mr (
    codigo integer NOT NULL,
    _data character varying,
    assunto character varying,
    instituicao character varying,
    pessoa character varying,
    observacoes character varying,
    status character(1),
    prontfisico character(1),
    inc_user character varying(10),
    alt_user character varying(10),
    solicitante character varying,
    data timestamp without time zone
);


--
-- Name: cd_prontuario_mr_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE cd_prontuario_mr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: cd_prontuario_mr_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('cd_prontuario_mr_seq', 5, true);


--
-- Name: cd_prontuario_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE cd_prontuario_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: cd_prontuario_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('cd_prontuario_seq', 10, true);


--
-- Name: cd_regioes; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE cd_regioes (
    regiao character varying(20) NOT NULL,
    descricao character varying(50) NOT NULL,
    inc_user character varying(10),
    alt_user character varying(10)
);


SET default_with_oids = false;

--
-- Name: cd_requerimento; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE cd_requerimento (
    numero integer NOT NULL,
    categoria character varying(4),
    ementa character varying(250),
    cmrp character(10),
    historico character varying(50),
    inc_user character varying(10),
    alt_user character varying(10),
    data date,
    status character(1),
    identificador integer DEFAULT nextval('rownum1'::regclass),
    evento integer
);


--
-- Name: cd_requerimento_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE cd_requerimento_seq
    START WITH 1
    INCREMENT BY 1
    MINVALUE 0
    NO MAXVALUE
    CACHE 1;


--
-- Name: cd_requerimento_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('cd_requerimento_seq', 11, true);


--
-- Name: cd_secoes; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE cd_secoes (
    secao_id integer NOT NULL,
    pleito_id integer NOT NULL,
    secao character varying(3),
    local character varying(75),
    zona character varying(3),
    votos integer
);


--
-- Name: cd_secoes_secao_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE cd_secoes_secao_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: cd_secoes_secao_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE cd_secoes_secao_id_seq OWNED BY cd_secoes.secao_id;


--
-- Name: cd_secoes_secao_id_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('cd_secoes_secao_id_seq', 935, true);


SET default_with_oids = true;

--
-- Name: cd_uf; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE cd_uf (
    pais character varying(2) NOT NULL,
    uf character varying(2) NOT NULL,
    nome character varying(50) NOT NULL,
    inc_user character varying(10),
    alt_user character varying(10)
);


SET default_with_oids = false;

--
-- Name: classificacao_pessoas; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE classificacao_pessoas (
    id integer NOT NULL,
    descricao character varying,
    cor character varying
);


--
-- Name: classificacao_pessoas_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE classificacao_pessoas_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: classificacao_pessoas_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE classificacao_pessoas_id_seq OWNED BY classificacao_pessoas.id;


--
-- Name: classificacao_pessoas_id_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('classificacao_pessoas_id_seq', 50, true);


SET default_with_oids = true;

--
-- Name: clipping; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE clipping (
    id integer NOT NULL,
    categoria character varying(300),
    assunto character varying(300),
    palavra_chave character varying(300),
    data timestamp without time zone,
    veiculo character varying(100),
    pagina character varying(6)
);


SET default_with_oids = false;

--
-- Name: clipping_arquivo; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE clipping_arquivo (
    idarquivo integer NOT NULL,
    idclipping integer NOT NULL,
    legenda character varying(80),
    arquivo character varying(50),
    mime character varying(50),
    tipo character varying(50),
    texto text,
    status character(1)
);


--
-- Name: clipping_arquivo_idarquivo_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE clipping_arquivo_idarquivo_seq
    START WITH 1
    INCREMENT BY 1
    MINVALUE 0
    NO MAXVALUE
    CACHE 1;


--
-- Name: clipping_arquivo_idarquivo_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE clipping_arquivo_idarquivo_seq OWNED BY clipping_arquivo.idarquivo;


--
-- Name: clipping_arquivo_idarquivo_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('clipping_arquivo_idarquivo_seq', 2, true);


--
-- Name: clipping_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE clipping_id_seq
    START WITH 1
    INCREMENT BY 1
    MINVALUE 0
    NO MAXVALUE
    CACHE 1;


--
-- Name: clipping_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE clipping_id_seq OWNED BY clipping.id;


--
-- Name: clipping_id_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('clipping_id_seq', 2, true);


--
-- Name: comissoes; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE comissoes (
    id_comissoes integer NOT NULL,
    ato character varying(300),
    nome character varying(300),
    vigencia character varying(300),
    observacoes character varying(300),
    data timestamp without time zone
);


--
-- Name: comissoes_arquivo; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE comissoes_arquivo (
    idarquivo integer NOT NULL,
    id_comissoes integer NOT NULL,
    legenda character varying(80),
    arquivo character varying(50),
    mime character varying(50),
    tipo character varying(50),
    texto text,
    status character(1)
);


--
-- Name: comissoes_arquivo_idarquivo_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE comissoes_arquivo_idarquivo_seq
    START WITH 1
    INCREMENT BY 1
    MINVALUE 0
    NO MAXVALUE
    CACHE 1;


--
-- Name: comissoes_arquivo_idarquivo_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE comissoes_arquivo_idarquivo_seq OWNED BY comissoes_arquivo.idarquivo;


--
-- Name: comissoes_arquivo_idarquivo_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('comissoes_arquivo_idarquivo_seq', 0, true);


--
-- Name: comissoes_id_comissoes_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE comissoes_id_comissoes_seq
    START WITH 1
    INCREMENT BY 1
    MINVALUE 0
    NO MAXVALUE
    CACHE 1;


--
-- Name: comissoes_id_comissoes_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE comissoes_id_comissoes_seq OWNED BY comissoes.id_comissoes;


--
-- Name: comissoes_id_comissoes_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('comissoes_id_comissoes_seq', 0, true);


--
-- Name: conf_arquivo; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE conf_arquivo (
    idarquivo integer NOT NULL,
    legenda character varying(80),
    arquivo character varying(50),
    mime character varying(50),
    tipo character varying(50),
    texto text,
    status character(1)
);


--
-- Name: conf_arquivo_idarquivo_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE conf_arquivo_idarquivo_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: conf_arquivo_idarquivo_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE conf_arquivo_idarquivo_seq OWNED BY conf_arquivo.idarquivo;


--
-- Name: conf_arquivo_idarquivo_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('conf_arquivo_idarquivo_seq', 6, true);


--
-- Name: conf_emails_saael; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE conf_emails_saael (
    id integer NOT NULL,
    email character varying,
    status character varying
);


--
-- Name: conf_emails_saael_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE conf_emails_saael_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: conf_emails_saael_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE conf_emails_saael_id_seq OWNED BY conf_emails_saael.id;


--
-- Name: conf_emails_saael_id_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('conf_emails_saael_id_seq', 4, true);


--
-- Name: conf_saael; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE conf_saael (
    id integer NOT NULL,
    nome_politico character varying,
    slogan character varying,
    email_contato character varying,
    endereco_acesso character varying
);


--
-- Name: conf_saael_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE conf_saael_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: conf_saael_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE conf_saael_id_seq OWNED BY conf_saael.id;


--
-- Name: conf_saael_id_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('conf_saael_id_seq', 1, true);


--
-- Name: controle_partido; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE controle_partido (
    status character varying(1) DEFAULT 0,
    id integer NOT NULL,
    diretorio character varying,
    uf character varying,
    caixa_alta character varying
);


--
-- Name: controle_partido_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE controle_partido_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: controle_partido_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE controle_partido_id_seq OWNED BY controle_partido.id;


--
-- Name: controle_partido_id_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('controle_partido_id_seq', 1, true);


--
-- Name: designacoes; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE designacoes (
    id integer NOT NULL,
    denominacao character varying,
    tipo character varying,
    participacao character varying,
    ato_tipo character varying,
    ato_nro character varying,
    ato_de character varying,
    ato_outros character varying,
    publicacao_tipo character varying,
    publicacao_nro character varying,
    publicacao_de character varying,
    publicacao_outros character varying,
    periodo_atuacao character varying,
    observacoes character varying,
    status character varying(1)
);


--
-- Name: designacoes_arquivo; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE designacoes_arquivo (
    idarquivo integer NOT NULL,
    sequencia integer NOT NULL,
    legenda character varying(80),
    arquivo character varying(50),
    mime character varying(50),
    tipo character varying(50),
    texto text,
    status character(1)
);


--
-- Name: designacoes_arquivo_idarquivo_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE designacoes_arquivo_idarquivo_seq
    START WITH 1
    INCREMENT BY 1
    MINVALUE 0
    NO MAXVALUE
    CACHE 1;


--
-- Name: designacoes_arquivo_idarquivo_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE designacoes_arquivo_idarquivo_seq OWNED BY designacoes_arquivo.idarquivo;


--
-- Name: designacoes_arquivo_idarquivo_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('designacoes_arquivo_idarquivo_seq', 0, true);


--
-- Name: designacoes_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE designacoes_id_seq
    START WITH 1
    INCREMENT BY 1
    MINVALUE 0
    NO MAXVALUE
    CACHE 1;


--
-- Name: designacoes_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE designacoes_id_seq OWNED BY designacoes.id;


--
-- Name: designacoes_id_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('designacoes_id_seq', 4, true);


--
-- Name: doc_partido; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE doc_partido (
    sequencia integer NOT NULL,
    tipo_documento character varying,
    observacoes text,
    data date
);


--
-- Name: doc_partido_arquivo; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE doc_partido_arquivo (
    idarquivo integer NOT NULL,
    sequencia integer NOT NULL,
    legenda character varying(80),
    arquivo character varying(50),
    mime character varying(50),
    tipo character varying(50),
    texto text,
    status character(1)
);


--
-- Name: doc_partido_arquivo_idarquivo_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE doc_partido_arquivo_idarquivo_seq
    START WITH 1
    INCREMENT BY 1
    MINVALUE 0
    NO MAXVALUE
    CACHE 1;


--
-- Name: doc_partido_arquivo_idarquivo_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE doc_partido_arquivo_idarquivo_seq OWNED BY doc_partido_arquivo.idarquivo;


--
-- Name: doc_partido_arquivo_idarquivo_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('doc_partido_arquivo_idarquivo_seq', 0, true);


--
-- Name: doc_partido_sequencia_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE doc_partido_sequencia_seq
    START WITH 1
    INCREMENT BY 1
    MINVALUE 0
    NO MAXVALUE
    CACHE 1;


--
-- Name: doc_partido_sequencia_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE doc_partido_sequencia_seq OWNED BY doc_partido.sequencia;


--
-- Name: doc_partido_sequencia_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('doc_partido_sequencia_seq', 0, true);


--
-- Name: eventos; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE eventos (
    id integer NOT NULL,
    descricao text,
    firma integer NOT NULL,
    data timestamp without time zone,
    assunto integer,
    providencia text,
    definicao integer,
    status character varying
);


--
-- Name: eventos_arquivo; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE eventos_arquivo (
    idarquivo integer NOT NULL,
    id integer NOT NULL,
    legenda character varying(80),
    arquivo character varying(50),
    mime character varying(50),
    tipo character varying(50),
    texto text,
    status character(1)
);


--
-- Name: eventos_arquivo_idarquivo_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE eventos_arquivo_idarquivo_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: eventos_arquivo_idarquivo_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE eventos_arquivo_idarquivo_seq OWNED BY eventos_arquivo.idarquivo;


--
-- Name: eventos_arquivo_idarquivo_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('eventos_arquivo_idarquivo_seq', 1, true);


--
-- Name: eventos_assunto; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE eventos_assunto (
    id_assunto integer NOT NULL,
    descricao text
);


--
-- Name: eventos_assunto_id_assunto_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE eventos_assunto_id_assunto_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: eventos_assunto_id_assunto_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE eventos_assunto_id_assunto_seq OWNED BY eventos_assunto.id_assunto;


--
-- Name: eventos_assunto_id_assunto_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('eventos_assunto_id_assunto_seq', 1, false);


--
-- Name: eventos_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE eventos_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: eventos_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE eventos_id_seq OWNED BY eventos.id;


--
-- Name: eventos_id_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('eventos_id_seq', 12, true);


--
-- Name: forum; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE forum (
    id_forum integer NOT NULL,
    ato character varying(300),
    nome character varying(300),
    vigencia character varying(300),
    observacoes character varying(300),
    data timestamp without time zone
);


--
-- Name: forum_arquivo; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE forum_arquivo (
    idarquivo integer NOT NULL,
    id_forum integer NOT NULL,
    legenda character varying(80),
    arquivo character varying(50),
    mime character varying(50),
    tipo character varying(50),
    texto text,
    status character(1)
);


--
-- Name: forum_arquivo_idarquivo_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE forum_arquivo_idarquivo_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: forum_arquivo_idarquivo_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE forum_arquivo_idarquivo_seq OWNED BY forum_arquivo.idarquivo;


--
-- Name: forum_arquivo_idarquivo_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('forum_arquivo_idarquivo_seq', 1, false);


--
-- Name: forum_id_forum_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE forum_id_forum_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: forum_id_forum_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE forum_id_forum_seq OWNED BY forum.id_forum;


--
-- Name: forum_id_forum_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('forum_id_forum_seq', 1, true);


--
-- Name: grp_instituicao; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE grp_instituicao (
    grupo character varying NOT NULL,
    descricao character varying,
    instituicoes character varying
);


--
-- Name: grp_pessoas; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE grp_pessoas (
    grupo character varying NOT NULL,
    descricao character varying,
    firma character varying
);


--
-- Name: grupo_instituicao; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE grupo_instituicao (
    instituicoes character varying,
    grupo character varying
);


--
-- Name: grupo_pessoas; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE grupo_pessoas (
    firma character varying,
    grupo character varying
);


--
-- Name: hip_aula_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE hip_aula_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    MAXVALUE 9999999999
    CACHE 1;


--
-- Name: hip_aula_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('hip_aula_seq', 10, false);


--
-- Name: hip_cavalo_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE hip_cavalo_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    MAXVALUE 9999999999
    CACHE 1;


--
-- Name: hip_cavalo_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('hip_cavalo_seq', 10, false);


--
-- Name: imprensa; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE imprensa (
    id_imprensa integer NOT NULL,
    imprensa character varying(300),
    status character varying(300),
    atualizacao character varying(300) DEFAULT now(),
    tipo character varying(300),
    periodicidade character varying(300),
    email1 character varying(300),
    email2 character varying(300),
    email3 character varying(300),
    site character varying(300),
    telefone character varying(300),
    fax character varying(300),
    cep character varying(300),
    endereco character varying(300),
    complemento character varying(300),
    bairro character varying(300),
    cod_cidade character varying(300),
    uf character varying(3),
    obs text
);


--
-- Name: imprensa_id_imprensa_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE imprensa_id_imprensa_seq
    START WITH 1
    INCREMENT BY 1
    MINVALUE 0
    NO MAXVALUE
    CACHE 1;


--
-- Name: imprensa_id_imprensa_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE imprensa_id_imprensa_seq OWNED BY imprensa.id_imprensa;


--
-- Name: imprensa_id_imprensa_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('imprensa_id_imprensa_seq', 6, true);


SET default_with_oids = true;

--
-- Name: nw_acs; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE nw_acs (
    id integer NOT NULL,
    aplic character varying(30) NOT NULL,
    bloco character varying(30) NOT NULL,
    usr character varying(20)
);


--
-- Name: nw_acs_pkey; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE nw_acs_pkey
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    MAXVALUE 9999999999
    CACHE 1;


--
-- Name: nw_acs_pkey; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('nw_acs_pkey', 10, false);


--
-- Name: nw_acs_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE nw_acs_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    MAXVALUE 9999999
    CACHE 1;


--
-- Name: nw_acs_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('nw_acs_seq', 844, true);


--
-- Name: nw_apl; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE nw_apl (
    aplic character varying(30) NOT NULL,
    titulo character varying(100) NOT NULL,
    autor character varying(100) NOT NULL,
    copyr character varying(100) NOT NULL,
    keyw character varying(100) NOT NULL,
    descricao character varying(100) NOT NULL,
    estilo character varying(30) NOT NULL,
    mensagem character varying(30),
    rodape character varying(30),
    cabec character varying(30)
);


--
-- Name: nw_area; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE nw_area (
    id_area integer NOT NULL,
    diretorio character varying(255),
    arquivo character varying(255),
    titulo character varying(255),
    texto text,
    id_arquivo integer,
    id_nw_mnu character varying(80) NOT NULL,
    ordem integer
);


--
-- Name: nw_area_ling; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE nw_area_ling (
    linguas_id integer NOT NULL,
    id_area integer NOT NULL,
    titulo character varying(255),
    texto text
);


--
-- Name: nw_area_mnu; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE nw_area_mnu (
    id_area integer NOT NULL,
    id_mnu integer NOT NULL
);


--
-- Name: nw_area_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE nw_area_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    MAXVALUE 99999999999
    CACHE 1;


--
-- Name: nw_area_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('nw_area_seq', 10, true);


--
-- Name: nw_bloco; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE nw_bloco (
    arquivo character(20) NOT NULL,
    aplic character varying(30) NOT NULL,
    descricao character varying(80) NOT NULL,
    vercao character(20) NOT NULL,
    obs text,
    dt_cadastro timestamp without time zone NOT NULL
);


--
-- Name: COLUMN nw_bloco.arquivo; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN nw_bloco.arquivo IS 'nome dos arquivos de blocos';


--
-- Name: COLUMN nw_bloco.aplic; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN nw_bloco.aplic IS 'id do aplicativo';


--
-- Name: COLUMN nw_bloco.descricao; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN nw_bloco.descricao IS 'descriÃ§Ã£o do bloco';


--
-- Name: COLUMN nw_bloco.vercao; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN nw_bloco.vercao IS 'verÃ§Ã£o do bloco';


--
-- Name: COLUMN nw_bloco.obs; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN nw_bloco.obs IS 'observaÃ§Ãµes sobre o bloco';


--
-- Name: nw_etl; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE nw_etl (
    estilo character varying(30) NOT NULL,
    descricao character varying(100) NOT NULL
);


--
-- Name: nw_fix; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE nw_fix (
    id integer NOT NULL,
    aplic character varying(30) NOT NULL,
    aba integer NOT NULL,
    cln integer NOT NULL,
    seq integer NOT NULL,
    bloco character varying(30) NOT NULL
);


--
-- Name: nw_grp; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE nw_grp (
    grupo character varying(20) NOT NULL,
    descricao character varying(100) NOT NULL
);


--
-- Name: nw_mbr; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE nw_mbr (
    usr character varying(20) NOT NULL,
    grupo character varying(20) NOT NULL
);


--
-- Name: nw_mnu; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE nw_mnu (
    id integer NOT NULL,
    aplic character varying(30) NOT NULL,
    texto character varying(200) NOT NULL,
    destino character varying(200),
    pai integer,
    descricao character varying(100),
    bloco character varying(30),
    cln integer,
    seq integer,
    sta integer,
    col0 character varying(30),
    col1 character varying(30),
    col2 character varying(30),
    col3 character varying(30),
    col4 character varying(30),
    targ character varying(30),
    img character varying(100),
    imgx character varying(100),
    sequencia integer,
    nivel_acs integer
);


--
-- Name: nw_mnu_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE nw_mnu_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    MAXVALUE 9999999
    CACHE 1;


--
-- Name: nw_mnu_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('nw_mnu_seq', 7726, true);


--
-- Name: nw_modulo_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE nw_modulo_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    MAXVALUE 9999999999
    CACHE 1;


--
-- Name: nw_modulo_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('nw_modulo_seq', 10, false);


--
-- Name: nw_sess; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE nw_sess (
    sesskey character varying(32) NOT NULL,
    expiry integer NOT NULL,
    expireref character varying(64),
    sessdata text
);


SET default_with_oids = false;

--
-- Name: nw_tarefas; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE nw_tarefas (
    id_usr character varying(20) NOT NULL,
    id_tar integer NOT NULL,
    dt_tar date NOT NULL,
    hora character varying(5),
    descricao character varying(4000),
    id_sit integer NOT NULL,
    email integer NOT NULL,
    ds_ant integer,
    hr_ant integer,
    recursividade character(1) DEFAULT 0 NOT NULL,
    local character varying,
    dados character varying,
    obs character varying,
    teste character varying,
    latitude character varying,
    longitude character varying,
    CONSTRAINT nw_tarefas_email_check CHECK (((email = 0) OR (email = 1))),
    CONSTRAINT nw_tarefas_id_sit_check CHECK ((((id_sit = 0) OR (id_sit = 1)) OR (id_sit = 2)))
);


--
-- Name: nw_tarefas2; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE nw_tarefas2 (
    id_usr character varying(20) NOT NULL,
    id_tar integer NOT NULL,
    dt_tar date NOT NULL,
    hora character varying(5),
    descricao character varying(4000),
    id_sit integer NOT NULL,
    email integer NOT NULL,
    ds_ant integer,
    hr_ant integer,
    recursividade character(1) DEFAULT 0 NOT NULL,
    CONSTRAINT nw_tarefas2_email_check CHECK (((email = 0) OR (email = 1))),
    CONSTRAINT nw_tarefas2_id_sit_check CHECK ((((id_sit = 0) OR (id_sit = 1)) OR (id_sit = 2)))
);


--
-- Name: nw_tarefas2_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE nw_tarefas2_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: nw_tarefas2_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('nw_tarefas2_seq', 14, true);


--
-- Name: nw_tarefas3; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE nw_tarefas3 (
    id_usr character varying(20) NOT NULL,
    id_tar integer NOT NULL,
    dt_tar date NOT NULL,
    hora character varying(5),
    descricao character varying(4000),
    id_sit integer NOT NULL,
    email integer NOT NULL,
    ds_ant integer,
    hr_ant integer,
    recursividade character(1) DEFAULT 0 NOT NULL,
    CONSTRAINT nw_tarefas3_email_check CHECK (((email = 0) OR (email = 1))),
    CONSTRAINT nw_tarefas3_id_sit_check CHECK ((((id_sit = 0) OR (id_sit = 1)) OR (id_sit = 2)))
);


--
-- Name: nw_tarefas3_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE nw_tarefas3_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: nw_tarefas3_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('nw_tarefas3_seq', 3, true);


--
-- Name: nw_tarefas_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE nw_tarefas_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: nw_tarefas_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('nw_tarefas_seq', 115, true);


SET default_with_oids = true;

--
-- Name: nw_usr; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE nw_usr (
    usr character varying(20) NOT NULL,
    nome character varying(100) NOT NULL,
    senha character varying(100) NOT NULL,
    email character varying(50),
    adm integer DEFAULT 0 NOT NULL,
    uex integer DEFAULT 0 NOT NULL,
    inc character varying DEFAULT 0,
    exc character varying DEFAULT 0,
    alt character varying DEFAULT 0,
    filtrar integer DEFAULT 0 NOT NULL,
    exibir_email character varying DEFAULT 0
);


SET default_with_oids = false;

--
-- Name: oficios_modelo; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE oficios_modelo (
    nro_oficio integer NOT NULL,
    data date,
    pessoa character varying(250),
    cargo character varying(250),
    endereco character varying(250),
    cep character varying(250),
    cod_cidade character varying(250),
    uf character varying(2),
    texto text DEFAULT 'Acuso o recebimento do convite desse LOCAL, convidando-me para ????, no próximo dia ??.<br>					Tendo em vista compromissos anteriormente assumidos nesse dia, estou impossibilitado de comparecer. Desejo sucesso para o evento. <br>'::text,
    tratamento character varying,
    sequencia_oficio integer
);


--
-- Name: oficios_modelo_nro_oficio_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE oficios_modelo_nro_oficio_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: oficios_modelo_nro_oficio_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE oficios_modelo_nro_oficio_seq OWNED BY oficios_modelo.nro_oficio;


--
-- Name: oficios_modelo_nro_oficio_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('oficios_modelo_nro_oficio_seq', 20, true);


--
-- Name: parametros_partido; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE parametros_partido (
    gravar_firma character(1) DEFAULT 'N'::bpchar NOT NULL,
    id integer NOT NULL
);


--
-- Name: parametros_partido_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE parametros_partido_id_seq
    START WITH 1
    INCREMENT BY 1
    MINVALUE 0
    NO MAXVALUE
    CACHE 1;


--
-- Name: parametros_partido_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE parametros_partido_id_seq OWNED BY parametros_partido.id;


--
-- Name: parametros_partido_id_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('parametros_partido_id_seq', 1, true);


--
-- Name: parametros_pessoas; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE parametros_pessoas (
    id integer NOT NULL,
    tipo character varying,
    status character varying
);


--
-- Name: parametros_pessoas_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE parametros_pessoas_id_seq
    START WITH 1
    INCREMENT BY 1
    MINVALUE 0
    NO MAXVALUE
    CACHE 1;


--
-- Name: parametros_pessoas_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE parametros_pessoas_id_seq OWNED BY parametros_pessoas.id;


--
-- Name: parametros_pessoas_id_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('parametros_pessoas_id_seq', 1, true);


--
-- Name: partido; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE partido (
    sequencia integer NOT NULL,
    diretorio character varying,
    uf_diretorio character varying,
    nome character varying,
    nascimento timestamp without time zone,
    endereco character varying,
    nro character varying,
    bairro character varying,
    cep character varying,
    cidade character varying,
    uf_endereco character varying,
    local_trabalho character varying,
    tel_trabalho character varying,
    cpf character varying,
    rg character varying,
    tel_residencial character varying,
    profissao character varying,
    nro_titulo character varying,
    zona character varying,
    secao character varying,
    aprovada timestamp without time zone,
    local character varying,
    abonada character varying,
    email character varying,
    data timestamp without time zone,
    cod_cidade character varying,
    nro_registro character varying,
    celular character varying,
    obs text,
    complemento character varying
);


--
-- Name: partido_arquivo; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE partido_arquivo (
    idarquivo integer NOT NULL,
    idprojeto integer NOT NULL,
    legenda character varying(80),
    arquivo character varying(50),
    mime character varying(50),
    tipo character varying(50),
    texto text,
    status character(1)
);


--
-- Name: partido_arquivo_idarquivo_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE partido_arquivo_idarquivo_seq
    START WITH 1
    INCREMENT BY 1
    MINVALUE 0
    NO MAXVALUE
    CACHE 1;


--
-- Name: partido_arquivo_idarquivo_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE partido_arquivo_idarquivo_seq OWNED BY partido_arquivo.idarquivo;


--
-- Name: partido_arquivo_idarquivo_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('partido_arquivo_idarquivo_seq', 0, true);


--
-- Name: partido_sequencia_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE partido_sequencia_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: partido_sequencia_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE partido_sequencia_seq OWNED BY partido.sequencia;


--
-- Name: partido_sequencia_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('partido_sequencia_seq', 1, true);


--
-- Name: pessoais; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE pessoais (
    sequencia integer NOT NULL,
    tipo_documento character varying,
    observacoes text,
    data date
);


--
-- Name: pessoais_arquivo; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE pessoais_arquivo (
    idarquivo integer NOT NULL,
    sequencia integer NOT NULL,
    legenda character varying(80),
    arquivo character varying(50),
    mime character varying(50),
    tipo character varying(50),
    texto text,
    status character(1)
);


--
-- Name: pessoais_arquivo_idarquivo_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE pessoais_arquivo_idarquivo_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: pessoais_arquivo_idarquivo_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE pessoais_arquivo_idarquivo_seq OWNED BY pessoais_arquivo.idarquivo;


--
-- Name: pessoais_arquivo_idarquivo_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('pessoais_arquivo_idarquivo_seq', 1, false);


--
-- Name: pessoais_sequencia_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE pessoais_sequencia_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: pessoais_sequencia_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE pessoais_sequencia_seq OWNED BY pessoais.sequencia;


--
-- Name: pessoais_sequencia_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('pessoais_sequencia_seq', 2, true);


--
-- Name: proposicoes_oficios; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW proposicoes_oficios AS
    (((((((SELECT 'Oficio' AS tipo, (SELECT count(cd_oficios_arquivo.idarquivo) AS count FROM cd_oficios_arquivo WHERE (cd_oficios_arquivo.idoficio = cd_oficios.sequencia)) AS arq, cd_oficios.identificador, NULL::unknown AS alt_user, cd_oficios.ano, cd_oficios.assunto AS ementa_assunto, cd_oficios.cargo, NULL::unknown AS categoria, cd_oficios.cep, cd_oficios.cidade, NULL::unknown AS cmrp, cd_oficios.data, cd_oficios.destinatario, cd_oficios.endereco, NULL::unknown AS historico, NULL::unknown AS inc_user, NULL::unknown AS numero, cd_oficios.responsavel, NULL::unknown AS resultado, cd_oficios.sequencia, cd_oficios.sigla, cd_oficios.tratamento, cd_oficios.uf, cd_oficios.status FROM cd_oficios UNION SELECT 'Requerimento' AS tipo, (SELECT count(cd_projeto_requerimento_arquivo.idarquivo) AS arq FROM cd_projeto_requerimento_arquivo WHERE (cd_projeto_requerimento_arquivo.idprojeto = cd_requerimento.numero)) AS arq, cd_requerimento.identificador, cd_requerimento.alt_user, NULL::unknown AS ano, cd_requerimento.ementa AS ementa_assunto, NULL::unknown AS cargo, cd_requerimento.categoria, NULL::unknown AS cep, NULL::unknown AS cidade, cd_requerimento.cmrp, cd_requerimento.data, NULL::unknown AS destinatario, NULL::unknown AS endereco, cd_requerimento.historico, cd_requerimento.inc_user, cd_requerimento.numero, NULL::unknown AS responsavel, NULL::unknown AS resultado, NULL::unknown AS sequencia, NULL::unknown AS sigla, NULL::unknown AS tratamento, NULL::unknown AS uf, cd_requerimento.status FROM cd_requerimento) UNION SELECT 'Decreto Legislativo' AS tipo, (SELECT count(cd_projeto_declegislativo_arquivo.idarquivo) AS count FROM cd_projeto_declegislativo_arquivo WHERE (cd_projeto_declegislativo_arquivo.idprojeto = cd_projeto_declegislativo.numero)) AS arq, cd_projeto_declegislativo.identificador, cd_projeto_declegislativo.alt_user, NULL::unknown AS ano, cd_projeto_declegislativo.ementa AS ementa_assunto, NULL::unknown AS cargo, cd_projeto_declegislativo.categoria, NULL::unknown AS cep, NULL::unknown AS cidade, cd_projeto_declegislativo.cmrp, cd_projeto_declegislativo.data, NULL::unknown AS destinatario, NULL::unknown AS endereco, NULL::unknown AS historico, cd_projeto_declegislativo.inc_user, cd_projeto_declegislativo.numero, NULL::unknown AS responsavel, cd_projeto_declegislativo.resultado, NULL::unknown AS sequencia, NULL::unknown AS sigla, NULL::unknown AS tratamento, NULL::unknown AS uf, cd_projeto_declegislativo.status FROM cd_projeto_declegislativo) UNION SELECT 'Resolução' AS tipo, (SELECT count(cd_projeto_resolucao_arquivo.idarquivo) AS count FROM cd_projeto_resolucao_arquivo WHERE (cd_projeto_resolucao_arquivo.idprojeto = cd_projeto_resolucao.numero)) AS arq, cd_projeto_resolucao.identificador, cd_projeto_resolucao.alt_user, NULL::unknown AS ano, cd_projeto_resolucao.ementa AS ementa_assunto, cd_projeto_resolucao.categoria AS cargo, NULL::unknown AS categoria, NULL::unknown AS cep, NULL::unknown AS cidade, cd_projeto_resolucao.cmrp, cd_projeto_resolucao.data, NULL::unknown AS destinatario, NULL::unknown AS endereco, NULL::unknown AS historico, cd_projeto_resolucao.inc_user, cd_projeto_resolucao.numero, NULL::unknown AS responsavel, cd_projeto_resolucao.resultado, NULL::unknown AS sequencia, NULL::unknown AS sigla, NULL::unknown AS tratamento, NULL::unknown AS uf, cd_projeto_resolucao.status FROM cd_projeto_resolucao) UNION SELECT 'Lei Complementar' AS tipo, (SELECT count(cd_projeto_leicomp_arquivo.idarquivo) AS count FROM cd_projeto_leicomp_arquivo WHERE (cd_projeto_leicomp_arquivo.idprojeto = cd_projeto_leicomp.numero)) AS arq, cd_projeto_leicomp.identificador, cd_projeto_leicomp.alt_user, NULL::unknown AS ano, cd_projeto_leicomp.ementa AS ementa_assunto, cd_projeto_leicomp.categoria AS cargo, NULL::unknown AS categoria, NULL::unknown AS cep, NULL::unknown AS cidade, cd_projeto_leicomp.cmrp, cd_projeto_leicomp.data, NULL::unknown AS destinatario, NULL::unknown AS endereco, NULL::unknown AS historico, cd_projeto_leicomp.inc_user, cd_projeto_leicomp.numero, NULL::unknown AS responsavel, cd_projeto_leicomp.resultado, NULL::unknown AS sequencia, NULL::unknown AS sigla, NULL::unknown AS tratamento, NULL::unknown AS uf, cd_projeto_leicomp.status FROM cd_projeto_leicomp) UNION SELECT 'Lei' AS tipo, (SELECT count(cd_projeto_leis_arquivo.idarquivo) AS count FROM cd_projeto_leis_arquivo WHERE (cd_projeto_leis_arquivo.idprojeto = cd_projeto_leis.numero)) AS arq, cd_projeto_leis.identificador, cd_projeto_leis.alt_user, NULL::unknown AS ano, cd_projeto_leis.ementa AS ementa_assunto, cd_projeto_leis.categoria AS cargo, NULL::unknown AS categoria, NULL::unknown AS cep, NULL::unknown AS cidade, cd_projeto_leis.cmrp, cd_projeto_leis.data, NULL::unknown AS destinatario, NULL::unknown AS endereco, NULL::unknown AS historico, cd_projeto_leis.inc_user, cd_projeto_leis.numero, NULL::unknown AS responsavel, cd_projeto_leis.resultado, NULL::unknown AS sequencia, NULL::unknown AS sigla, NULL::unknown AS tratamento, NULL::unknown AS uf, cd_projeto_leis.status FROM cd_projeto_leis) UNION SELECT 'Oficio Circular' AS tipo, (SELECT count(cd_oficios_circulares_arquivo.idarquivo) AS count FROM cd_oficios_circulares_arquivo WHERE (cd_oficios_circulares_arquivo.idoficio = cd_oficios_circulares.sequencia)) AS arq, cd_oficios_circulares.identificador, NULL::unknown AS alt_user, cd_oficios_circulares.ano, cd_oficios_circulares.assunto AS ementa_assunto, NULL::unknown AS cargo, NULL::unknown AS categoria, NULL::unknown AS cep, NULL::unknown AS cidade, NULL::unknown AS cmrp, cd_oficios_circulares.data, cd_oficios_circulares.destinatario, NULL::unknown AS endereco, NULL::unknown AS historico, NULL::unknown AS inc_user, NULL::unknown AS numero, cd_oficios_circulares.responsavel, NULL::unknown AS resultado, cd_oficios_circulares.sequencia, cd_oficios_circulares.sigla, NULL::unknown AS tratamento, NULL::unknown AS uf, cd_oficios_circulares.status FROM cd_oficios_circulares) UNION SELECT 'Indicações' AS tipo, (SELECT count(cd_projeto_indicacoes_arquivo.idarquivo) AS count FROM cd_projeto_indicacoes_arquivo WHERE (cd_projeto_indicacoes_arquivo.idprojeto = cd_indicacoes.numero)) AS arq, cd_indicacoes.identificador, cd_indicacoes.alt_user, NULL::unknown AS ano, cd_indicacoes.ementa AS ementa_assunto, NULL::unknown AS cargo, NULL::unknown AS categoria, NULL::unknown AS cep, NULL::unknown AS cidade, cd_indicacoes.cmrp, cd_indicacoes.data, NULL::unknown AS destinatario, NULL::unknown AS endereco, NULL::unknown AS historico, cd_indicacoes.inc_user, cd_indicacoes.numero, NULL::unknown AS responsavel, cd_indicacoes.resultado, NULL::unknown AS sequencia, NULL::unknown AS sigla, NULL::unknown AS tratamento, NULL::unknown AS uf, cd_indicacoes.status FROM cd_indicacoes) UNION SELECT 'Emendas' AS tipo, (SELECT count(cd_projeto_emendas_arquivo.idarquivo) AS count FROM cd_projeto_emendas_arquivo WHERE (cd_projeto_emendas_arquivo.idprojeto = cd_emendas.numero)) AS arq, cd_emendas.identificador, cd_emendas.alt_user, NULL::unknown AS ano, cd_emendas.ementa AS ementa_assunto, NULL::unknown AS cargo, NULL::unknown AS categoria, NULL::unknown AS cep, NULL::unknown AS cidade, NULL::unknown AS cmrp, cd_emendas.data, NULL::unknown AS destinatario, NULL::unknown AS endereco, NULL::unknown AS historico, cd_emendas.inc_user, cd_emendas.numero, NULL::unknown AS responsavel, cd_emendas.resultado, NULL::unknown AS sequencia, NULL::unknown AS sigla, NULL::unknown AS tratamento, NULL::unknown AS uf, cd_emendas.status FROM cd_emendas;


--
-- Name: sequence1; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE sequence1
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: sequence1; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('sequence1', 1, false);


--
-- Name: solicitacoes; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE solicitacoes (
    numero integer NOT NULL,
    solicitacao character varying(100),
    solicitante character varying(250),
    data date,
    responsavel character varying(250),
    observacao text,
    status character varying(10)
);


--
-- Name: solicitacoes_numero_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE solicitacoes_numero_seq
    START WITH 1
    INCREMENT BY 1
    MINVALUE 0
    NO MAXVALUE
    CACHE 1;


--
-- Name: solicitacoes_numero_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE solicitacoes_numero_seq OWNED BY solicitacoes.numero;


--
-- Name: solicitacoes_numero_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('solicitacoes_numero_seq', 0, true);


--
-- Name: telefones; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW telefones AS
    SELECT cd_firmas.oid, cd_firmas.firma AS id, cd_firmas.nome, cd_firmas.fone1, cd_firmas.fone2, cd_firmas.celular, '' AS fax, cd_firmas.email, cd_firmas.email2, cd_firmas.apelido FROM cd_firmas UNION SELECT cd_instituicoes.oid, cd_instituicoes.instituicoes AS id, cd_instituicoes.nome, cd_instituicoes.fone1, '' AS fone2, '' AS celular, cd_instituicoes.fax, cd_instituicoes.email, '' AS email2, NULL::unknown AS apelido FROM cd_instituicoes;


--
-- Name: web_modulo_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE web_modulo_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    MAXVALUE 9999999999
    CACHE 1;


--
-- Name: web_modulo_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('web_modulo_seq', 10, false);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY agenda_telefones ALTER COLUMN id SET DEFAULT nextval('agenda_telefones_id_seq'::regclass);


--
-- Name: codigo; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY cd_andamento_mr ALTER COLUMN codigo SET DEFAULT nextval('cd_andamento_mr_codigo_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY cd_custom ALTER COLUMN id SET DEFAULT nextval('cd_custom_id_seq'::regclass);


--
-- Name: sequencia; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY cd_oficios ALTER COLUMN sequencia SET DEFAULT nextval('cd_oficios_sequencia_seq'::regclass);


--
-- Name: idarquivo; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY cd_oficios_arquivo ALTER COLUMN idarquivo SET DEFAULT nextval('cd_oficios_arquivo_idarquivo_seq'::regclass);


--
-- Name: sequencia; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY cd_oficios_circulares ALTER COLUMN sequencia SET DEFAULT nextval('cd_oficios_circulares_sequencia_seq'::regclass);


--
-- Name: idarquivo; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY cd_oficios_circulares_arquivo ALTER COLUMN idarquivo SET DEFAULT nextval('cd_oficios_circulares_arquivo_idarquivo_seq'::regclass);


--
-- Name: idarquivo; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY cd_oficios_prontuario_arquivo ALTER COLUMN idarquivo SET DEFAULT nextval('cd_oficios_prontuario_arquivo_idarquivo_seq'::regclass);


--
-- Name: idarquivo; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY cd_oficios_prontuario_mr_arquivo ALTER COLUMN idarquivo SET DEFAULT nextval('cd_oficios_prontuario_mr_arquivo_idarquivo_seq'::regclass);


--
-- Name: idarquivo; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY cd_projeto_declegislativo_arquivo ALTER COLUMN idarquivo SET DEFAULT nextval('cd_projeto_declegislativo_arquivo_idarquivo_seq'::regclass);


--
-- Name: idarquivo; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY cd_projeto_emendas_arquivo ALTER COLUMN idarquivo SET DEFAULT nextval('cd_projeto_emendas_arquivo_idarquivo_seq'::regclass);


--
-- Name: idarquivo; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY cd_projeto_indicacoes_arquivo ALTER COLUMN idarquivo SET DEFAULT nextval('cd_projeto_indicacoes_arquivo_idarquivo_seq'::regclass);


--
-- Name: idarquivo; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY cd_projeto_leicomp_arquivo ALTER COLUMN idarquivo SET DEFAULT nextval('cd_projeto_leicomp_arquivo_idarquivo_seq'::regclass);


--
-- Name: idarquivo; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY cd_projeto_leis_arquivo ALTER COLUMN idarquivo SET DEFAULT nextval('cd_projeto_leis_arquivo_idarquivo_seq'::regclass);


--
-- Name: idarquivo; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY cd_projeto_requerimento_arquivo ALTER COLUMN idarquivo SET DEFAULT nextval('cd_projeto_requerimento_arquivo_idarquivo_seq'::regclass);


--
-- Name: idarquivo; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY cd_projeto_resolucao_arquivo ALTER COLUMN idarquivo SET DEFAULT nextval('cd_projeto_resolucao_arquivo_idarquivo_seq'::regclass);


--
-- Name: secao_id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY cd_secoes ALTER COLUMN secao_id SET DEFAULT nextval('cd_secoes_secao_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY classificacao_pessoas ALTER COLUMN id SET DEFAULT nextval('classificacao_pessoas_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY clipping ALTER COLUMN id SET DEFAULT nextval('clipping_id_seq'::regclass);


--
-- Name: idarquivo; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY clipping_arquivo ALTER COLUMN idarquivo SET DEFAULT nextval('clipping_arquivo_idarquivo_seq'::regclass);


--
-- Name: id_comissoes; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY comissoes ALTER COLUMN id_comissoes SET DEFAULT nextval('comissoes_id_comissoes_seq'::regclass);


--
-- Name: idarquivo; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY comissoes_arquivo ALTER COLUMN idarquivo SET DEFAULT nextval('comissoes_arquivo_idarquivo_seq'::regclass);


--
-- Name: idarquivo; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY conf_arquivo ALTER COLUMN idarquivo SET DEFAULT nextval('conf_arquivo_idarquivo_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY conf_emails_saael ALTER COLUMN id SET DEFAULT nextval('conf_emails_saael_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY conf_saael ALTER COLUMN id SET DEFAULT nextval('conf_saael_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY controle_partido ALTER COLUMN id SET DEFAULT nextval('controle_partido_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY designacoes ALTER COLUMN id SET DEFAULT nextval('designacoes_id_seq'::regclass);


--
-- Name: idarquivo; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY designacoes_arquivo ALTER COLUMN idarquivo SET DEFAULT nextval('designacoes_arquivo_idarquivo_seq'::regclass);


--
-- Name: sequencia; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY doc_partido ALTER COLUMN sequencia SET DEFAULT nextval('doc_partido_sequencia_seq'::regclass);


--
-- Name: idarquivo; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY doc_partido_arquivo ALTER COLUMN idarquivo SET DEFAULT nextval('doc_partido_arquivo_idarquivo_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY eventos ALTER COLUMN id SET DEFAULT nextval('eventos_id_seq'::regclass);


--
-- Name: idarquivo; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY eventos_arquivo ALTER COLUMN idarquivo SET DEFAULT nextval('eventos_arquivo_idarquivo_seq'::regclass);


--
-- Name: id_assunto; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY eventos_assunto ALTER COLUMN id_assunto SET DEFAULT nextval('eventos_assunto_id_assunto_seq'::regclass);


--
-- Name: id_forum; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY forum ALTER COLUMN id_forum SET DEFAULT nextval('forum_id_forum_seq'::regclass);


--
-- Name: idarquivo; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY forum_arquivo ALTER COLUMN idarquivo SET DEFAULT nextval('forum_arquivo_idarquivo_seq'::regclass);


--
-- Name: id_imprensa; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY imprensa ALTER COLUMN id_imprensa SET DEFAULT nextval('imprensa_id_imprensa_seq'::regclass);


--
-- Name: nro_oficio; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY oficios_modelo ALTER COLUMN nro_oficio SET DEFAULT nextval('oficios_modelo_nro_oficio_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY parametros_partido ALTER COLUMN id SET DEFAULT nextval('parametros_partido_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY parametros_pessoas ALTER COLUMN id SET DEFAULT nextval('parametros_pessoas_id_seq'::regclass);


--
-- Name: sequencia; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY partido ALTER COLUMN sequencia SET DEFAULT nextval('partido_sequencia_seq'::regclass);


--
-- Name: idarquivo; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY partido_arquivo ALTER COLUMN idarquivo SET DEFAULT nextval('partido_arquivo_idarquivo_seq'::regclass);


--
-- Name: sequencia; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY pessoais ALTER COLUMN sequencia SET DEFAULT nextval('pessoais_sequencia_seq'::regclass);


--
-- Name: idarquivo; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY pessoais_arquivo ALTER COLUMN idarquivo SET DEFAULT nextval('pessoais_arquivo_idarquivo_seq'::regclass);


--
-- Name: numero; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY solicitacoes ALTER COLUMN numero SET DEFAULT nextval('solicitacoes_numero_seq'::regclass);


--
-- Data for Name: agenda_telefones; Type: TABLE DATA; Schema: public; Owner: -
--

INSERT INTO agenda_telefones VALUES (3, 'Helder', '(16) 3442-2905', '(19) 9367-2407', '', '', '');


--
-- Data for Name: cd_admmunicipal; Type: TABLE DATA; Schema: public; Owner: -
--

INSERT INTO cd_admmunicipal VALUES (50, 2100, 19, '', '', '');
INSERT INTO cd_admmunicipal VALUES (52, 2100, 19, '', '', '');
INSERT INTO cd_admmunicipal VALUES (53, 2100, 19, '', '', '');
INSERT INTO cd_admmunicipal VALUES (54, 2100, 19, '', '', '');
INSERT INTO cd_admmunicipal VALUES (63, 2100, 19, 'Prefeito', 'teste', 'DDD');
INSERT INTO cd_admmunicipal VALUES (66, 2100, 21, 'Prefeito', 'teste', 'dsfds');
INSERT INTO cd_admmunicipal VALUES (67, 2100, 17, 'rrdd', 'rrdd', 'rrdd');
INSERT INTO cd_admmunicipal VALUES (68, 5126, NULL, 'Prefeita', 'Darci Vera', 'DEM');


--
-- Data for Name: cd_andamento; Type: TABLE DATA; Schema: public; Owner: -
--

INSERT INTO cd_andamento VALUES (1, 1, '07/10/2009', 'Andamento 1', 'ADMIN', NULL);
INSERT INTO cd_andamento VALUES (2, 1, '09/10/2009', 'Andamento 2', 'ADMIN', NULL);
INSERT INTO cd_andamento VALUES (3, 3, '01/02/2010', 'teste', 'ADMIN', NULL);


--
-- Data for Name: cd_andamento_mr; Type: TABLE DATA; Schema: public; Owner: -
--

INSERT INTO cd_andamento_mr VALUES (1, 5, '28/08/2010', 'teste', 'ADMIN', NULL);


--
-- Data for Name: cd_areas; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- Data for Name: cd_bairros; Type: TABLE DATA; Schema: public; Owner: -
--

INSERT INTO cd_bairros VALUES (6, 'tttt', NULL, NULL);
INSERT INTO cd_bairros VALUES (5, 'vvvvv', NULL, NULL);
INSERT INTO cd_bairros VALUES (7, 'aaaa', NULL, 'ADMIN');


--
-- Data for Name: cd_cargos; Type: TABLE DATA; Schema: public; Owner: -
--

INSERT INTO cd_cargos VALUES ('Prefeito', 'ADMIN', NULL);
INSERT INTO cd_cargos VALUES ('Vereador', 'ADMIN', NULL);
INSERT INTO cd_cargos VALUES ('Deputado Federal', 'ADMIN', NULL);
INSERT INTO cd_cargos VALUES ('Deputado Estadual', 'ADMIN', NULL);
INSERT INTO cd_cargos VALUES ('Vice-Prefeito', 'GILBERTO', NULL);
INSERT INTO cd_cargos VALUES ('Superintendente', 'GILBERTO', NULL);
INSERT INTO cd_cargos VALUES ('Diretor Superintendente', 'GILBERTO', NULL);
INSERT INTO cd_cargos VALUES ('Diretor', 'GILBERTO', NULL);
INSERT INTO cd_cargos VALUES ('Governador', 'GILBERTO', NULL);
INSERT INTO cd_cargos VALUES ('Vice-Governador', 'GILBERTO', NULL);
INSERT INTO cd_cargos VALUES ('Secretário de Estado', 'GILBERTO', NULL);
INSERT INTO cd_cargos VALUES ('Ministro de Estado', 'GILBERTO', NULL);
INSERT INTO cd_cargos VALUES ('Coordenador', 'GILBERTO', 'GILBERTO');
INSERT INTO cd_cargos VALUES ('Comandante', 'GILBERTO', NULL);
INSERT INTO cd_cargos VALUES ('Senador', 'GILBERTO', NULL);
INSERT INTO cd_cargos VALUES ('Presidente', 'GILBERTO', NULL);
INSERT INTO cd_cargos VALUES ('Secretário Municipal', 'GILBERTO', NULL);
INSERT INTO cd_cargos VALUES ('Diretor de Departamento', 'GILBERTO', NULL);
INSERT INTO cd_cargos VALUES ('Coordenadora', 'GILBERTO', NULL);
INSERT INTO cd_cargos VALUES ('Deputada Federal', 'GILBERTO', NULL);
INSERT INTO cd_cargos VALUES ('Deputada Estadual', 'GILBERTO', NULL);
INSERT INTO cd_cargos VALUES ('Diretora', 'GILBERTO', NULL);
INSERT INTO cd_cargos VALUES ('Diretora de Departamento', 'GILBERTO', NULL);
INSERT INTO cd_cargos VALUES ('Diretora Superintendente', 'GILBERTO', NULL);
INSERT INTO cd_cargos VALUES ('Governadora', 'GILBERTO', NULL);
INSERT INTO cd_cargos VALUES ('Ministra de Estado', 'GILBERTO', NULL);
INSERT INTO cd_cargos VALUES ('Prefeita', 'GILBERTO', NULL);
INSERT INTO cd_cargos VALUES ('Secretária de Estado', 'GILBERTO', NULL);
INSERT INTO cd_cargos VALUES ('Secretária Municipal', 'GILBERTO', NULL);
INSERT INTO cd_cargos VALUES ('Senadora', 'GILBERTO', NULL);
INSERT INTO cd_cargos VALUES ('Vereadora', 'GILBERTO', NULL);
INSERT INTO cd_cargos VALUES ('Vice-Governadora', 'GILBERTO', NULL);
INSERT INTO cd_cargos VALUES ('Vice-Prefeita', 'GILBERTO', NULL);
INSERT INTO cd_cargos VALUES ('Assessor', 'GILBERTO', NULL);
INSERT INTO cd_cargos VALUES ('Assessora', 'GILBERTO', NULL);
INSERT INTO cd_cargos VALUES ('Assistente', 'GILBERTO', NULL);
INSERT INTO cd_cargos VALUES ('Secretário Geral', 'GILBERTO', NULL);


--
-- Data for Name: cd_cep_br; Type: TABLE DATA; Schema: public; Owner: -
--

INSERT INTO cd_cep_br VALUES ('57.302-420', '23       ', 'R PROFESSOR JOSE PAULO MOURA', 'N ESPERANCA                   ');
INSERT INTO cd_cep_br VALUES ('57.301-170', '23       ', 'R PROFESSOR JOVINO CAVALCANTE', 'O PRETO                       ');
INSERT INTO cd_cep_br VALUES ('57.307-610', '23       ', 'R RAIMUNDO DOS SANTOS', 'JD ESPERANCA                  ');
INSERT INTO cd_cep_br VALUES ('57.307-490', '23       ', 'R RAIMUNDO XAVIER NASCIMENTO', 'JD ESPERANCA                  ');
INSERT INTO cd_cep_br VALUES ('57.308-640', '23       ', 'AV REJANE MARIA CAMELO', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('57.310-190', '23       ', 'R RICARDO ALEXANDRE NUNES MAGALHAES', 'CAPIATA                       ');
INSERT INTO cd_cep_br VALUES ('57.300-190', '23       ', 'AV RIO BRANCO- ATE 475/574', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.304-730', '23       ', 'AV RIO BRANCO- DE 477/576 AO FIM', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.300-420', '23       ', 'R RIO DE JANEIRO', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.308-230', '23       ', 'R RIO LARGO', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('57.310-390', '23       ', 'R RITA LEAO DE MELO', 'CANAFISTULA                   ');
INSERT INTO cd_cep_br VALUES ('57.308-650', '23       ', 'R RIVALDO JOSE DA SILVA', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('57.306-600', '23       ', 'R ROMUALDO OLIVEIRA LIMA', 'CAVACO                        ');
INSERT INTO cd_cep_br VALUES ('57.311-480', '23       ', 'R ROSA HOULY', 'CAITITUS                      ');
INSERT INTO cd_cep_br VALUES ('57.304-110', '23       ', 'PC ROSENDO LIMA', 'PRIMAVERA                     ');
INSERT INTO cd_cep_br VALUES ('57.310-020', '23       ', 'R ROSENDO MAIA', 'BRASILIANA                    ');
INSERT INTO cd_cep_br VALUES ('57.312-040', '23       ', 'R ROTEIRO', 'S ESMERALDA                   ');
INSERT INTO cd_cep_br VALUES ('57.304-500', '23       ', 'PC ROZENDO VIEIRA LIMA', 'CACIMBAS                      ');
INSERT INTO cd_cep_br VALUES ('57.313-190', '23       ', 'R RUBENS PEDRO DA SILVA', 'BRASILIA                      ');
INSERT INTO cd_cep_br VALUES ('57.300-500', '23       ', 'R RUI BARBOSA', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.306-590', '23       ', 'R SALUSTIANO JOSE DOS SANTOS', 'CAVACO                        ');
INSERT INTO cd_cep_br VALUES ('57.311-270', '23       ', 'R SALUSTIANO JOSE DOS SANTOS', 'CAITITUS                      ');
INSERT INTO cd_cep_br VALUES ('57.303-370', '23       ', 'R SALVELINA MARIA DA CONCEICAO', 'V CAMPOS                      ');
INSERT INTO cd_cep_br VALUES ('57.311-180', '23       ', 'R SAMARITANA', 'S T VILELA                    ');
INSERT INTO cd_cep_br VALUES ('57.312-380', '23       ', 'R SAMUEL DE OLIVEIRA SANTOS', 'AT CRUZEIRO                   ');
INSERT INTO cd_cep_br VALUES ('57.304-720', '23       ', 'PC PAULO FERREIRA FONTES', 'CACIMBAS                      ');
INSERT INTO cd_cep_br VALUES ('57.308-480', '23       ', 'R PAULO JACINTO', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('57.304-180', '23       ', 'R PAULO VI', 'PRIMAVERA                     ');
INSERT INTO cd_cep_br VALUES ('57.306-510', '23       ', 'R PEDRO ALEXANDRE', 'CAVACO                        ');
INSERT INTO cd_cep_br VALUES ('57.304-070', '23       ', 'R PEDRO ALVARES CABRAL', 'PRIMAVERA                     ');
INSERT INTO cd_cep_br VALUES ('57.302-360', '23       ', 'R PEDRO AMANCIO VITAL', 'N ESPERANCA                   ');
INSERT INTO cd_cep_br VALUES ('57.311-440', '23       ', 'R PEDRO BARBOSA DA SILVA', 'CAITITUS                      ');
INSERT INTO cd_cep_br VALUES ('57.311-430', '23       ', 'R PEDRO CORREIA DAS GRACAS', 'CAITITUS                      ');
INSERT INTO cd_cep_br VALUES ('57.310-310', '23       ', 'PC PEDRO DE LIMA SILVA', 'R CRUZ                        ');
INSERT INTO cd_cep_br VALUES ('57.307-720', '23       ', 'R PEDRO FERREIRA DE ALBUQUERUQE', 'JD ESPERANCA                  ');
INSERT INTO cd_cep_br VALUES ('57.300-180', '23       ', 'AV PEDRO LEAO- ATE 235/292', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.305-330', '23       ', 'AV PEDRO LEAO- DE 237/294 AO FIM', 'BAIXAO                        ');
INSERT INTO cd_cep_br VALUES ('57.307-520', '23       ', 'R PEDRO LIVINO', 'JD ESPERANCA                  ');
INSERT INTO cd_cep_br VALUES ('57.303-070', '23       ', 'R PEDRO LOPES DA SILVA', 'S LUIZ                        ');
INSERT INTO cd_cep_br VALUES ('57.303-220', '23       ', 'PC PEDRO MARINHO MUNIZ SURUAGY', 'B VISTA                       ');
INSERT INTO cd_cep_br VALUES ('57.300-550', '23       ', 'R PEDRO NUNES DE ALBUQUERQUE', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.313-350', '23       ', 'R PEDRO OLIVEIRA', 'BRASILIA                      ');
INSERT INTO cd_cep_br VALUES ('57.311-080', '23       ', 'R PEDRO PROTENCIANO', 'AT CRUZEIRO                   ');
INSERT INTO cd_cep_br VALUES ('57.307-140', '23       ', 'R PEDRO ROMUALDO SILVA', 'BX GRANDE                     ');
INSERT INTO cd_cep_br VALUES ('57.303-300', '23       ', 'R PEDRO SIMAO', 'B VISTA                       ');
INSERT INTO cd_cep_br VALUES ('57.305-260', '23       ', 'R PEDRO ZUMBA', 'M TELES                       ');
INSERT INTO cd_cep_br VALUES ('57.308-630', '23       ', 'R PENEDO', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('57.304-525', '23       ', 'PC PEREIRA MAGALHAES', 'CACIMBAS                      ');
INSERT INTO cd_cep_br VALUES ('57.311-300', '23       ', 'R PETROLINA', 'CAITITUS                      ');
INSERT INTO cd_cep_br VALUES ('57.303-670', '23       ', 'R PETROPOLIS', 'GUARIBAS                      ');
INSERT INTO cd_cep_br VALUES ('57.308-360', '23       ', 'R PIACABUCU', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('57.304-170', '23       ', 'R PIO DECIMO', 'PRIMAVERA                     ');
INSERT INTO cd_cep_br VALUES ('57.308-050', '23       ', 'AV PIO DOZE', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('57.303-280', '23       ', 'R VICENTE LINO DA SILVA', 'B VISTA                       ');
INSERT INTO cd_cep_br VALUES ('57.311-250', '23       ', 'AV VICENTE NUNES DE ALBUQUERQUE', 'CAITITUS                      ');
INSERT INTO cd_cep_br VALUES ('57.308-460', '23       ', 'R VICOSA', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('57.308-080', '23       ', 'R VIGARIO RODRIGUES SILVA', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('57.311-120', '23       ', 'R SAO PAULO', 'AT CRUZEIRO                   ');
INSERT INTO cd_cep_br VALUES ('57.311-040', '23       ', 'R SAO PEDRO', 'AT CRUZEIRO                   ');
INSERT INTO cd_cep_br VALUES ('57.301-460', '23       ', 'R SAO ROQUE', 'JD TROPICAL                   ');
INSERT INTO cd_cep_br VALUES ('57.303-140', '23       ', 'R SAO SALVADOR', 'V CAMPOS                      ');
INSERT INTO cd_cep_br VALUES ('57.308-200', '23       ', 'R SAO SEBASTIAO', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('57.305-380', '23       ', 'R SAO TOME', 'BAIXAO                        ');
INSERT INTO cd_cep_br VALUES ('57.300-450', '23       ', 'R SAO VICENTE', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.312-750', '23       ', 'R SARGENTO FABIO ROBERTO ALBUQUERQUE QUEIROZ', 'N HORIZONTE                   ');
INSERT INTO cd_cep_br VALUES ('57.312-210', '23       ', 'R SARGENTO FABIO ROBERTO QUEIROZ', 'S ESMERALDA                   ');
INSERT INTO cd_cep_br VALUES ('57.304-690', '23       ', 'R SARGENTO OTAVIO LOURENCO DE SOUZA', 'CACIMBAS                      ');
INSERT INTO cd_cep_br VALUES ('57.313-450', '23       ', 'R SAUDADE, DA', 'JD TROPICAL                   ');
INSERT INTO cd_cep_br VALUES ('57.303-010', '23       ', 'R SAYNARA QUEIROZ MARQUES LEMOS', 'S LUIZ                        ');
INSERT INTO cd_cep_br VALUES ('57.303-090', '23       ', 'R SEBASTIAO LUIZ PEREIRA', 'S LUIZ                        ');
INSERT INTO cd_cep_br VALUES ('57.312-170', '23       ', 'R SEBASTIAO RIBEIRO', 'AT CRUZEIRO                   ');
INSERT INTO cd_cep_br VALUES ('57.311-230', '23       ', 'R SEBASTIAO SEVERINO DOS SANTOS', 'CAITITUS                      ');
INSERT INTO cd_cep_br VALUES ('57.313-070', '23       ', 'R SENADOR RUI PALMEIRA', 'BRASILIA                      ');
INSERT INTO cd_cep_br VALUES ('57.300-200', '23       ', 'PC SENHOR DO BOMFIM', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.301-050', '23       ', 'R SENHOR DO BONFIM', 'O PRETO                       ');
INSERT INTO cd_cep_br VALUES ('57.301-040', '23       ', 'R SENHOR DOS POBRES', 'O PRETO                       ');
INSERT INTO cd_cep_br VALUES ('57.314-170', '23       ', 'PC SERESTEIRO ALTEMAR DUTRA', 'ITAPOA                        ');
INSERT INTO cd_cep_br VALUES ('57.313-200', '23       ', 'R SERTANEJO ALAGOANO', 'BRASILIA                      ');
INSERT INTO cd_cep_br VALUES ('57.300-480', '23       ', 'R SETE DE SETEMBRO', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.307-480', '23       ', 'R SEVERINA DE ALBUQUERQUE SILVA', 'JD ESPERANCA                  ');
INSERT INTO cd_cep_br VALUES ('57.305-320', '23       ', 'R SEVERINO BORGES', 'BAIXAO                        ');
INSERT INTO cd_cep_br VALUES ('57.308-390', '23       ', 'R SEVERINO CANDIDO DA SILVA', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('57.307-200', '23       ', 'R SEVERINO CATANHO', 'BX GRANDE                     ');
INSERT INTO cd_cep_br VALUES ('57.305-590', '23       ', 'R SEVERINO GOMES DE SOUZA', 'BAIXAO                        ');
INSERT INTO cd_cep_br VALUES ('57.301-270', '23       ', 'R SINESIO FERREIRA LIMA', 'S LUIZ                        ');
INSERT INTO cd_cep_br VALUES ('57.304-660', '23       ', 'R SIQUEIRA CAMPOS', 'CACIMBAS                      ');
INSERT INTO cd_cep_br VALUES ('57.300-210', '23       ', 'R SOL, DO', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.301-240', '23       ', 'R SUELY LOPES DA SILVA', 'O PRETO                       ');
INSERT INTO cd_cep_br VALUES ('57.312-010', '23       ', 'R TANCREDO DE ALMEIDA NEVES', 'AT CRUZEIRO                   ');
INSERT INTO cd_cep_br VALUES ('57.305-160', '23       ', 'R TAQUARANA', 'M TELES                       ');
INSERT INTO cd_cep_br VALUES ('57.306-020', '23       ', 'R TAVARES BASTO', 'BAIXAO                        ');
INSERT INTO cd_cep_br VALUES ('57.300-220', '23       ', 'R TEODORICO COSTA', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.310-170', '23       ', 'R TEODORO PEREIRA', 'CAPIATA                       ');
INSERT INTO cd_cep_br VALUES ('57.303-550', '23       ', 'R TEOFILO PEREIRA LIMA', 'GUARIBAS                      ');
INSERT INTO cd_cep_br VALUES ('57.307-320', '23       ', 'R TEOTONIO VENTURA DE FARIAS', 'JD ESPERANCA                  ');
INSERT INTO cd_cep_br VALUES ('57.304-490', '23       ', 'R SANTA ANA', 'PRIMAVERA                     ');
INSERT INTO cd_cep_br VALUES ('57.304-360', '23       ', 'R SANTA CATARINA', 'PRIMAVERA                     ');
INSERT INTO cd_cep_br VALUES ('57.311-070', '23       ', 'PC SANTA CRUZ', 'AT CRUZEIRO                   ');
INSERT INTO cd_cep_br VALUES ('57.313-080', '23       ', 'R SANTA EFIGENIA', 'BRASILIA                      ');
INSERT INTO cd_cep_br VALUES ('57.302-050', '23       ', 'R SANTA EMILIA', 'CANAFISTULA                   ');
INSERT INTO cd_cep_br VALUES ('57.313-630', '23       ', 'R SANTA ESMERALDA', 'BRASILIA                      ');
INSERT INTO cd_cep_br VALUES ('57.313-410', '23       ', 'R SANTA FELICIDADE', 'JD TROPICAL                   ');
INSERT INTO cd_cep_br VALUES ('57.060-800', '54       ', 'R GUBALDO NOBRE DE CASTRO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.043-540', '54       ', 'R GALBA PIMENTEL MENDONCA', 'FEITOSA                       ');
INSERT INTO cd_cep_br VALUES ('69.028-412', '156      ', 'R 13 (CJ SUBTEN SRG P MILITAR)', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('69.055-753', '156      ', 'R 13 (CJ TROPICAL)', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.077-140', '156      ', 'R 13 (CJ 31 DE MARCO I)', 'JAPIIM                        ');
INSERT INTO cd_cep_br VALUES ('69.093-269', '156      ', 'R 13 (M SINAI)', 'COL S ANTONIO                 ');
INSERT INTO cd_cep_br VALUES ('69.090-562', '156      ', 'TV 13 (NUCLEO 1)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.094-130', '156      ', 'R 13 (NUCLEO 3)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.040-619', '156      ', 'R 13 (PRQ ARIPUANA)', 'D PEDRO                       ');
INSERT INTO cd_cep_br VALUES ('69.043-210', '156      ', 'R 13 ATE 131/132', 'ALVORADA                      ');
INSERT INTO cd_cep_br VALUES ('69.096-610', '156      ', 'R 130 (NUCLEO 10)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.096-581', '156      ', 'R 131 (NUCLEO 10)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.096-420', '156      ', 'R 111 (NUCLEO 12)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.096-430', '156      ', 'R 112 (NUCLEO 12)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.096-440', '156      ', 'R 113 (NUCLEO 12)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.096-450', '156      ', 'R 114 (NUCLEO 12)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.096-460', '156      ', 'R 115 (NUCLEO 11)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.096-470', '156      ', 'R 116 (NUCLEO 11)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.096-480', '156      ', 'R 117 (NUCLEO 11)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.096-490', '156      ', 'R 118 (NUCLEO 11)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.096-500', '156      ', 'R 119 (NUCLEO 11)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.086-130', '156      ', 'R 12', 'S J OPERARIO                  ');
INSERT INTO cd_cep_br VALUES ('69.038-283', '156      ', 'R 12', 'L VALE                        ');
INSERT INTO cd_cep_br VALUES ('69.042-100', '156      ', 'R 12- DE 152/155 AO FIM', 'ALVORADA                      ');
INSERT INTO cd_cep_br VALUES ('69.098-660', '156      ', 'R 12 (A MENDES)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.038-390', '156      ', 'R 12 (CJ A MONTENEGRO)', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('69.055-300', '156      ', 'R 12 (CJ C BRANCO)', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.083-550', '156      ', 'R 12 (CJ C DO ALEIXO)', 'S J OPERARIO                  ');
INSERT INTO cd_cep_br VALUES ('69.086-510', '156      ', 'R 12 (CJ CASTANHEIRA)', 'S J OPERARIO                  ');
INSERT INTO cd_cep_br VALUES ('69.068-400', '156      ', 'R 12 (CJ COSTA E SILVA)', 'RAIZ                          ');
INSERT INTO cd_cep_br VALUES ('69.049-280', '156      ', 'R 12 (CJ HILEIA I )', 'REDENCAO                      ');
INSERT INTO cd_cep_br VALUES ('69.049-460', '156      ', 'R 12 (CJ HILEIA II)', 'REDENCAO                      ');
INSERT INTO cd_cep_br VALUES ('69.067-160', '156      ', 'R 12 (CJ JD PETROPOLIS)', 'PETROPOLIS                    ');
INSERT INTO cd_cep_br VALUES ('69.044-590', '156      ', 'R 12 (CJ JD VERSALLES)', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('69.093-510', '156      ', 'R 12 (CJ MANOA)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.090-460', '156      ', 'R 12 (CJ MUNDO NOVO)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.095-812', '156      ', 'R 12 (CJ O FROTA I)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.028-313', '156      ', 'R 12 (CJ R MARACANA)', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('69.090-710', '156      ', 'R 12 (CJ R S PINTO I)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.036-470', '156      ', 'R 12 (CJ R XINGU)', 'COMPENSA                      ');
INSERT INTO cd_cep_br VALUES ('69.028-411', '156      ', 'R 12 (CJ SUBTEN SRG P MILITAR)', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('69.055-752', '156      ', 'R 12 (CJ TROPICAL)', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.083-431', '156      ', 'R 12 (CJ V CAMARA)', 'ALEIXO                        ');
INSERT INTO cd_cep_br VALUES ('69.077-130', '156      ', 'R 12 (CJ 31 DE MARCO I)', 'JAPIIM                        ');
INSERT INTO cd_cep_br VALUES ('69.093-274', '156      ', 'R 12 (M SINAI)', 'COL S ANTONIO                 ');
INSERT INTO cd_cep_br VALUES ('69.094-120', '156      ', 'R 12 (NUCLEO 2)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.040-618', '156      ', 'R 12 (PRQ ARIPUANA)', 'D PEDRO                       ');
INSERT INTO cd_cep_br VALUES ('69.086-131', '156      ', 'R 12 A', 'S J OPERARIO                  ');
INSERT INTO cd_cep_br VALUES ('69.043-200', '156      ', 'R 12 ATE 150/153', 'ALVORADA                      ');
INSERT INTO cd_cep_br VALUES ('69.055-301', '156      ', 'R 12A (CJ C BRANCO)', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.096-330', '156      ', 'R 102 (NUCLEO 12)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.096-340', '156      ', 'R 103 (NUCLEO 12)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.096-350', '156      ', 'R 104 (NUCLEO 12)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.096-360', '156      ', 'R 105 (NUCLEO 12)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.096-370', '156      ', 'R 106 (NUCLEO 12)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.096-380', '156      ', 'R 107 (NUCLEO 12)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.096-390', '156      ', 'R 108 (NUCLEO 12)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.096-400', '156      ', 'R 109 (NUCLEO 12)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.086-120', '156      ', 'R 11', 'S J OPERARIO                  ');
INSERT INTO cd_cep_br VALUES ('69.033-351', '156      ', 'BC 11', 'S JORGE                       ');
INSERT INTO cd_cep_br VALUES ('69.038-282', '156      ', 'R 11', 'L VALE                        ');
INSERT INTO cd_cep_br VALUES ('69.042-110', '156      ', 'R 11- DE 63/72 AO FIM', 'ALVORADA                      ');
INSERT INTO cd_cep_br VALUES ('69.099-060', '156      ', 'R 11 (A MENDES)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.038-380', '156      ', 'R 11 (CJ A MONTENEGRO)', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('69.028-324', '156      ', 'R 11 (CJ B FLOR I)', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('69.055-290', '156      ', 'R 11 (CJ C BRANCO)', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.083-540', '156      ', 'R 11 (CJ C DO ALEIXO)', 'S J OPERARIO                  ');
INSERT INTO cd_cep_br VALUES ('69.097-060', '156      ', 'R 11 (CJ CANARANAS)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.086-500', '156      ', 'R 11 (CJ CASTANHEIRA)', 'S J OPERARIO                  ');
INSERT INTO cd_cep_br VALUES ('69.068-390', '156      ', 'R 11 (CJ COSTA E SILVA', 'RAIZ                          ');
INSERT INTO cd_cep_br VALUES ('69.049-270', '156      ', 'R 11 (CJ HILEIA I )', 'REDENCAO                      ');
INSERT INTO cd_cep_br VALUES ('69.049-450', '156      ', 'R 11 (CJ HILEIA II)', 'REDENCAO                      ');
INSERT INTO cd_cep_br VALUES ('69.067-150', '156      ', 'R 11 (CJ JD PETROPOLIS)', 'PETROPOLIS                    ');
INSERT INTO cd_cep_br VALUES ('69.044-580', '156      ', 'R 11 (CJ JD VERSALLES)', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('69.093-500', '156      ', 'R 11 (CJ MANOA)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.090-450', '156      ', 'R 11 (CJ MUNDO NOVO)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.028-312', '156      ', 'R 11 (CJ R MARACANA)', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('69.090-700', '156      ', 'R 11 (CJ R S PINTO I)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.036-460', '156      ', 'R 11 (CJ R XINGU)', 'COMPENSA                      ');
INSERT INTO cd_cep_br VALUES ('69.028-410', '156      ', 'R 11 (CJ SUBTEN SRG P MILITAR)', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('69.055-751', '156      ', 'R 11 (CJ TROPICAL)', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.077-120', '156      ', 'R 11 (CJ 31 DE MARCO I)', 'JAPIIM                        ');
INSERT INTO cd_cep_br VALUES ('69.093-268', '156      ', 'R 11 (M SINAI)', 'COL S ANTONIO                 ');
INSERT INTO cd_cep_br VALUES ('69.094-110', '156      ', 'R 11 (NUCLEO 2)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.040-622', '156      ', 'R 11 (PRQ ARIPUANA)', 'D PEDRO                       ');
INSERT INTO cd_cep_br VALUES ('69.043-230', '156      ', 'R 11 ATE 61/70', 'ALVORADA                      ');
INSERT INTO cd_cep_br VALUES ('69.086-121', '156      ', 'R 11 K', 'S J OPERARIO                  ');
INSERT INTO cd_cep_br VALUES ('12.914-830', '4897     ', 'AV PROJETADA', 'JD PALMEIRAS                  ');
INSERT INTO cd_cep_br VALUES ('69.096-410', '156      ', 'R 110 (NUCLEO 12)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.054-740', '156      ', 'R 09 (SHANGRILA IV)', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.043-220', '156      ', 'R 09 ATE 116/125', 'ALVORADA                      ');
INSERT INTO cd_cep_br VALUES ('69.067-482', '156      ', 'BC 1', 'PETROPOLIS                    ');
INSERT INTO cd_cep_br VALUES ('69.060-096', '156      ', 'BC 1', 'ALEIXO                        ');
INSERT INTO cd_cep_br VALUES ('69.099-010', '156      ', 'R 1 (A MENDES)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.048-360', '156      ', 'R 1 (CJ CANAA)', 'ALVORADA                      ');
INSERT INTO cd_cep_br VALUES ('69.086-110', '156      ', 'R 10', 'S J OPERARIO                  ');
INSERT INTO cd_cep_br VALUES ('69.038-281', '156      ', 'R 10', 'L VALE                        ');
INSERT INTO cd_cep_br VALUES ('69.077-110', '156      ', 'R 10(CJ 31 DE MARCO I)', 'JAPIIM                        ');
INSERT INTO cd_cep_br VALUES ('69.057-781', '156      ', 'BC 10(CJ. V.MUNICIPAL)', 'ADRIANOPOLIS                  ');
INSERT INTO cd_cep_br VALUES ('69.042-090', '156      ', 'R 10- DE 116/853 AO FIM', 'ALVORADA                      ');
INSERT INTO cd_cep_br VALUES ('69.098-650', '156      ', 'R 10 (A MENDES)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.038-370', '156      ', 'R 10 (CJ A MONTENEGRO)', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('69.028-336', '156      ', 'R 10 (CJ B FLOR II)', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('69.055-280', '156      ', 'R 10 (CJ C BRANCO)', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.083-530', '156      ', 'R 10 (CJ C DO ALEIXO)', 'S J OPERARIO                  ');
INSERT INTO cd_cep_br VALUES ('69.086-490', '156      ', 'R 10 (CJ CASTANHEIRA)', 'S J OPERARIO                  ');
INSERT INTO cd_cep_br VALUES ('57.307-300', '23       ', 'R HELENA FERNANDES DE SOUZA', 'JD ESPERANCA                  ');
INSERT INTO cd_cep_br VALUES ('69.153-250', '161      ', 'AV PAULO TEIXEIRA', 'S R CASSIA                    ');
INSERT INTO cd_cep_br VALUES ('69.151-450', '161      ', 'AV PEDRO GONCALVES', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('69.152-600', '161      ', 'R PICHITA COHEN (CJ SHAM)', 'S F ASSIS                     ');
INSERT INTO cd_cep_br VALUES ('69.152-690', '161      ', 'R PIQUIA (CJ MACURANI)', 'S F ASSIS                     ');
INSERT INTO cd_cep_br VALUES ('69.151-630', '161      ', 'R PROFESSOR PENA RIBEIRO', 'S CLARA                       ');
INSERT INTO cd_cep_br VALUES ('69.151-181', '161      ', 'PC QUATORZE DE MAIO', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('69.151-620', '161      ', 'BC QUINTA DA BOA VISTA', 'S CLARA                       ');
INSERT INTO cd_cep_br VALUES ('69.151-610', '161      ', 'R QUINTA DA BOA VISTA', 'S CLARA                       ');
INSERT INTO cd_cep_br VALUES ('69.152-230', '161      ', 'R RAIMUNDO ALMADA', 'J ESTEVES                     ');
INSERT INTO cd_cep_br VALUES ('69.153-230', '161      ', 'R RAIMUNDO BENTES JESUS', 'S R CASSIA                    ');
INSERT INTO cd_cep_br VALUES ('69.151-360', '161      ', 'R RAIMUNDO LUIZ DE MENEZES', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('69.153-090', '161      ', 'R RAUL GOES', 'PALMARES                      ');
INSERT INTO cd_cep_br VALUES ('69.153-450', '161      ', 'R RECIFE', 'S VICENTE                     ');
INSERT INTO cd_cep_br VALUES ('69.152-640', '161      ', 'AV RENATO BATISTA (CJ SHAM)', 'S F ASSIS                     ');
INSERT INTO cd_cep_br VALUES ('69.152-130', '161      ', 'R RUI ARAUJO', 'S JOSE                        ');
INSERT INTO cd_cep_br VALUES ('69.151-260', '161      ', 'R RUY BARBOSA', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('69.151-220', '161      ', 'AV SA PEIXOTO', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('69.151-470', '161      ', 'BC SAAE', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('69.151-291', '161      ', 'PC SAGRADO CORACAO', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('69.152-220', '161      ', 'R J. A. AZEVEDO', 'J ESTEVES                     ');
INSERT INTO cd_cep_br VALUES ('69.151-600', '161      ', 'BC JOAO MEIRELES', 'S CLARA                       ');
INSERT INTO cd_cep_br VALUES ('69.153-120', '161      ', 'R JOAO MEIRELES', 'PALMARES                      ');
INSERT INTO cd_cep_br VALUES ('69.151-110', '161      ', 'AV JOAO MEIRELES', 'S CLARA                       ');
INSERT INTO cd_cep_br VALUES ('69.151-020', '161      ', 'AV JOAO MELO', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('69.153-220', '161      ', 'R JOAQUIM FREITAS VIEIRA', 'S R CASSIA                    ');
INSERT INTO cd_cep_br VALUES ('69.153-300', '161      ', 'R JOAQUIM GOES', 'S R CASSIA                    ');
INSERT INTO cd_cep_br VALUES ('69.151-100', '161      ', 'R JOAQUIM PRESTES AZEDO', 'S CLARA                       ');
INSERT INTO cd_cep_br VALUES ('69.151-030', '161      ', 'AV JONATHAS PEDROSA', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('69.151-190', '161      ', 'R JOSE LUIZ DE MENEZES', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('69.151-350', '161      ', 'BC JOSE LUIZ MENEZES', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('69.152-560', '161      ', 'R JOSE PRESTES ( CJ SHAM)', 'S F ASSIS                     ');
INSERT INTO cd_cep_br VALUES ('69.151-311', '161      ', 'PC JUDITH PRESTES', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('69.151-410', '161      ', 'BC JULIO BELEM', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('69.151-150', '161      ', 'R JULIO BELEM- ATE 3011/3012', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('69.152-020', '161      ', 'R JULIO BELEM- DE 3013/3014 AO FIM', 'S BENEDITO                    ');
INSERT INTO cd_cep_br VALUES ('69.153-190', '161      ', 'R JURITY', 'PALMARES                      ');
INSERT INTO cd_cep_br VALUES ('69.152-390', '161      ', 'Q K (CJ J NOVO)', 'D VIEIRA                      ');
INSERT INTO cd_cep_br VALUES ('69.152-400', '161      ', 'Q L (CJ J NOVO)', 'D VIEIRA                      ');
INSERT INTO cd_cep_br VALUES ('69.153-280', '161      ', 'R LINDOLFO MONTEVERDE', 'S R CASSIA                    ');
INSERT INTO cd_cep_br VALUES ('69.152-210', '161      ', 'R LISTER ACHAO', 'J ESTEVES                     ');
INSERT INTO cd_cep_br VALUES ('69.151-700', '161      ', 'R LUIZ GONZAGA', 'S CLARA                       ');
INSERT INTO cd_cep_br VALUES ('69.152-410', '161      ', 'Q M (CJ J NOVO)', 'D VIEIRA                      ');
INSERT INTO cd_cep_br VALUES ('69.152-450', '161      ', 'EST MACURANI, DO', 'D VIEIRA                      ');
INSERT INTO cd_cep_br VALUES ('69.152-440', '161      ', 'R MACURANY', 'D VIEIRA                      ');
INSERT INTO cd_cep_br VALUES ('57.308-710', '23       ', 'R ALONSO DE ABREU PEREIRA FILHO', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('57.312-580', '23       ', 'R ALVES PORTO', 'N HORIZONTE                   ');
INSERT INTO cd_cep_br VALUES ('57.314-090', '23       ', 'R ALVINA NUNES DA SILVA', 'ITAPOA                        ');
INSERT INTO cd_cep_br VALUES ('57.307-640', '23       ', 'R AMALIA GONZAGA LIMA', 'BX GRANDE                     ');
INSERT INTO cd_cep_br VALUES ('57.314-290', '23       ', 'R AMANCIO MATIAS DA SILVA', 'ITAPOA                        ');
INSERT INTO cd_cep_br VALUES ('57.303-150', '23       ', 'R AMAZONAS', 'V CAMPOS                      ');
INSERT INTO cd_cep_br VALUES ('57.308-720', '23       ', 'R AMELIA NUNES CORREIA', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('57.306-300', '23       ', 'R AMERINO PORTUGAL', 'ELDORADO                      ');
INSERT INTO cd_cep_br VALUES ('57.304-060', '23       ', 'R ANA BEATRIZ', 'PRIMAVERA                     ');
INSERT INTO cd_cep_br VALUES ('57.301-230', '23       ', 'R ANA LUCIA ANDRADE NEVES', 'S LUIZ                        ');
INSERT INTO cd_cep_br VALUES ('57.304-740', '23       ', 'R ANA MARIA MENDES LIRA', 'PRIMAVERA                     ');
INSERT INTO cd_cep_br VALUES ('57.305-210', '23       ', 'R ABDIAS FRANCISCO DOS SANTOS', 'M TELES                       ');
INSERT INTO cd_cep_br VALUES ('57.305-270', '23       ', 'R ABEL MONTEIRO DE MAIA', 'M TELES                       ');
INSERT INTO cd_cep_br VALUES ('57.307-630', '23       ', 'R ABILIO LEITE', 'JD ESPERANCA                  ');
INSERT INTO cd_cep_br VALUES ('57.306-490', '23       ', 'R ABRAAO DE OLIVEIRA', 'CAVACO                        ');
INSERT INTO cd_cep_br VALUES ('57.310-340', '23       ', 'R ACINDINO DE OLIVEIRA NUNES', 'R CRUZ                        ');
INSERT INTO cd_cep_br VALUES ('57.303-470', '23       ', 'R ADALGISA FERNANDES CAVALCANTE', 'GUARIBAS                      ');
INSERT INTO cd_cep_br VALUES ('57.302-290', '23       ', 'R ADEILDO NEPOMUCENO MARQUES', 'N ESPERANCA                   ');
INSERT INTO cd_cep_br VALUES ('57.313-660', '23       ', 'R ADELIA GOMES SIQUEIRA', 'BRASILIA                      ');
INSERT INTO cd_cep_br VALUES ('57.308-100', '23       ', 'R ADEMAR MEDEIROS', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('57.312-190', '23       ', 'R ADEMARIO JOSE MENDES LIRA', 'AT CRUZEIRO                   ');
INSERT INTO cd_cep_br VALUES ('57.314-260', '23       ', 'R ADERVAL INACIO DA SILVA', 'BRASILIA                      ');
INSERT INTO cd_cep_br VALUES ('57.313-700', '23       ', 'R ADILSON TORRES DE MELO', 'BRASILIA                      ');
INSERT INTO cd_cep_br VALUES ('57.303-250', '23       ', 'R ADJALMA SILVA', 'B VISTA                       ');
INSERT INTO cd_cep_br VALUES ('57.313-480', '23       ', 'R ADRIAO HENRIQUE SILVA', 'JD TROPICAL                   ');
INSERT INTO cd_cep_br VALUES ('57.303-030', '23       ', 'R ADVOGADO MARIO CORREIA MACEDO', 'S LUIZ                        ');
INSERT INTO cd_cep_br VALUES ('57.305-310', '23       ', 'R AFONSO PENA', 'BAIXAO                        ');
INSERT INTO cd_cep_br VALUES ('57.301-190', '23       ', 'R AFRA ALBUQUERQUE LIMA', 'S LUIZ                        ');
INSERT INTO cd_cep_br VALUES ('57.303-110', '23       ', 'R AFRA CORREIA', 'S LUIZ                        ');
INSERT INTO cd_cep_br VALUES ('57.313-390', '23       ', 'PC AFRANIO SALGADO LAGES', 'JD TROPICAL                   ');
INSERT INTO cd_cep_br VALUES ('57.304-080', '23       ', 'R AGAPITO MAGALHAES', 'PRIMAVERA                     ');
INSERT INTO cd_cep_br VALUES ('57.305-520', '23       ', 'R AGNELO LEITE', 'BAIXAO                        ');
INSERT INTO cd_cep_br VALUES ('57.305-240', '23       ', 'R AGOSTINHO SEVERINO DOS SANTOS', 'BAIXAO                        ');
INSERT INTO cd_cep_br VALUES ('57.307-130', '23       ', 'R AGRIPINO DAMASCENO RIBEIRO', 'BX GRANDE                     ');
INSERT INTO cd_cep_br VALUES ('57.308-000', '23       ', 'ROD AL-220- DO KM 6 AO KM 8', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('57.312-220', '23       ', 'R ALAN KARDEC', 'S ESMERALDA                   ');
INSERT INTO cd_cep_br VALUES ('57.305-500', '23       ', 'R ALOISIO BORGES', 'P FRIO                        ');
INSERT INTO cd_cep_br VALUES ('69.151-340', '161      ', 'R 1 DE JANEIRO', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('69.151-180', '161      ', 'BVD 14 DE MAIO', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('69.153-200', '161      ', 'R 15 DE OUTUBRO', 'PALMARES                      ');
INSERT INTO cd_cep_br VALUES ('69.153-500', '161      ', 'BC 2', 'S VICENTE                     ');
INSERT INTO cd_cep_br VALUES ('69.151-250', '161      ', 'R 31 DE MARCO', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('69.153-040', '161      ', 'R 7 DE SETEMBRO', 'PALMARES                      ');
INSERT INTO cd_cep_br VALUES ('69.153-260', '161      ', 'R SALVADOR DE MOURA', 'S R CASSIA                    ');
INSERT INTO cd_cep_br VALUES ('69.152-050', '161      ', 'R SAO BENEDITO', 'S BENEDITO                    ');
INSERT INTO cd_cep_br VALUES ('69.152-070', '161      ', 'BC SAO BENEDITO', 'S BENEDITO                    ');
INSERT INTO cd_cep_br VALUES ('69.152-001', '161      ', 'PC SAO BENEDITO', 'S BENEDITO                    ');
INSERT INTO cd_cep_br VALUES ('69.152-160', '161      ', 'BC SAO JOSE', 'S JOSE                        ');
INSERT INTO cd_cep_br VALUES ('69.152-760', '161      ', 'PC SAO JOSE', 'S JOSE                        ');
INSERT INTO cd_cep_br VALUES ('69.151-230', '161      ', 'R SENADOR ALVARO BOTELHO MAIA', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('69.151-210', '161      ', 'AV SENADOR JOSE ESTEVES- ATE 839/840', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('69.153-150', '161      ', 'AV SENADOR JOSE ESTEVES- DE 841/842 AO FIM', 'PALMARES                      ');
INSERT INTO cd_cep_br VALUES ('69.152-150', '161      ', 'R SILVA CAMPOS', 'S JOSE                        ');
INSERT INTO cd_cep_br VALUES ('69.151-590', '161      ', 'R SILVA CAMPOS', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.050-410', '54       ', 'R CORONEL MURILO OTAVIO DE BARROS', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.070-110', '54       ', 'PC CORONEL OTHON BEZERRA DE MELO', 'F VELHO                       ');
INSERT INTO cd_cep_br VALUES ('57.050-040', '54       ', 'R CORONEL PACHECO RAMALHO', 'PITANGUINHA                   ');
INSERT INTO cd_cep_br VALUES ('69.054-030', '156      ', 'R 02 (CJ N FRIBURGO)', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.028-302', '156      ', 'R 02 (CJ R MARACANA)', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('69.090-610', '156      ', 'R 02 (CJ R S PINTO I)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.036-370', '156      ', 'R 02 (CJ R XINGU)', 'COMPENSA                      ');
INSERT INTO cd_cep_br VALUES ('69.028-401', '156      ', 'R 02 (CJ SUBTEN SRG P MILITAR)', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('69.055-741', '156      ', 'R 02 (CJ TROPICAL)', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.038-740', '156      ', 'R 02 (CJ V BELA)', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('69.083-360', '156      ', 'R 02 (CJ V CAMARA)', 'ALEIXO                        ');
INSERT INTO cd_cep_br VALUES ('69.057-700', '156      ', 'R 02 (CJ V MUNICIPAL)', 'ADRIANOPOLIS                  ');
INSERT INTO cd_cep_br VALUES ('69.077-030', '156      ', 'R 02 (CJ 31 DE MARCO I)', 'JAPIIM                        ');
INSERT INTO cd_cep_br VALUES ('69.093-286', '156      ', 'R 02 (M SINAI)', 'COL S ANTONIO                 ');
INSERT INTO cd_cep_br VALUES ('69.028-320', '156      ', 'R 01 (CJ B FLOR I)', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('69.050-570', '156      ', 'R 01 (CJ BEVERLY HILLS)', 'CHAPADA                       ');
INSERT INTO cd_cep_br VALUES ('69.055-190', '156      ', 'R 01 (CJ C BRANCO)', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.083-440', '156      ', 'R 01 (CJ C DO ALEIXO)', 'S J OPERARIO                  ');
INSERT INTO cd_cep_br VALUES ('69.048-610', '156      ', 'R 01 (CJ CANAA)', 'ALVORADA                      ');
INSERT INTO cd_cep_br VALUES ('69.097-010', '156      ', 'R 01 (CJ CANARANAS)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.086-400', '156      ', 'R 01 (CJ CASTANHEIRA)', 'S J OPERARIO                  ');
INSERT INTO cd_cep_br VALUES ('69.068-290', '156      ', 'R 01 (CJ COSTA E SILVA)', 'RAIZ                          ');
INSERT INTO cd_cep_br VALUES ('69.060-201', '156      ', 'R 01 (CJ H ANGELIN)', 'ALEIXO                        ');
INSERT INTO cd_cep_br VALUES ('69.049-170', '156      ', 'R 01 (CJ HILEIA I)', 'REDENCAO                      ');
INSERT INTO cd_cep_br VALUES ('69.049-640', '156      ', 'R 01 (CJ HILEIA II)', 'REDENCAO                      ');
INSERT INTO cd_cep_br VALUES ('69.050-590', '156      ', 'R 01 (CJ JD HAIDEA I)', 'CHAPADA                       ');
INSERT INTO cd_cep_br VALUES ('69.067-110', '156      ', 'R 01 (CJ JD PETROPOLIS)', 'PETROPOLIS                    ');
INSERT INTO cd_cep_br VALUES ('69.054-220', '156      ', 'R 01 (CJ JD PRIMAVERA)', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.044-480', '156      ', 'R 01 (CJ JD VERSALLES)', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('69.093-400', '156      ', 'R 01 (CJ MANOA)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.090-350', '156      ', 'R 01 (CJ MUNDO NOVO)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.054-020', '156      ', 'R 01 (CJ N FRIBURGO)', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.095-504', '156      ', 'R 01 (CJ O FROTA I)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.028-301', '156      ', 'R 01 (CJ R MARACANA)', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('69.090-600', '156      ', 'R 01 (CJ R S PINTO I)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.036-360', '156      ', 'R 01 (CJ R XINGU)', 'COMPENSA                      ');
INSERT INTO cd_cep_br VALUES ('69.028-400', '156      ', 'R 01 (CJ SUBTEN SRG P MILITAR)', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('69.055-740', '156      ', 'R 01 (CJ TROPICAL', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.038-730', '156      ', 'R 01 (CJ V BELA )', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('69.083-350', '156      ', 'R 01 (CJ V CAMARA)', 'ALEIXO                        ');
INSERT INTO cd_cep_br VALUES ('69.057-690', '156      ', 'R 01 (CJ V MUNICIPAL)', 'ADRIANOPOLIS                  ');
INSERT INTO cd_cep_br VALUES ('69.077-020', '156      ', 'R 01 (CJ 31 DE MARCO I)', 'JAPIIM                        ');
INSERT INTO cd_cep_br VALUES ('69.093-263', '156      ', 'R 01 (M SINAI)', 'COL S ANTONIO                 ');
INSERT INTO cd_cep_br VALUES ('69.090-550', '156      ', 'R 01 (NUCLEO 1)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.040-610', '156      ', 'R 01 (PRQ ARIPUANA)', 'D PEDRO                       ');
INSERT INTO cd_cep_br VALUES ('69.035-791', '156      ', 'R 01 (VL MARINHO)', 'COMPENSA                      ');
INSERT INTO cd_cep_br VALUES ('69.043-110', '156      ', 'R 01 ATE 361/362', 'ALVORADA                      ');
INSERT INTO cd_cep_br VALUES ('69.054-370', '156      ', 'R 01(CJ B BELA)', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.057-550', '156      ', 'R 01(CJ I PARAIBA)', 'ADRIANOPOLIS                  ');
INSERT INTO cd_cep_br VALUES ('69.086-030', '156      ', 'R 02', 'S J OPERARIO                  ');
INSERT INTO cd_cep_br VALUES ('69.040-090', '156      ', 'R 02', 'D PEDRO                       ');
INSERT INTO cd_cep_br VALUES ('69.039-721', '156      ', 'R 02', 'N ISRAEL                      ');
INSERT INTO cd_cep_br VALUES ('69.025-390', '156      ', 'R WALTER RAYOL', 'P VARGAS                      ');
INSERT INTO cd_cep_br VALUES ('69.020-020', '156      ', 'R WALTER RAYOL (IGARAPE DE MANAUS)', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('69.063-700', '156      ', 'R WALTER ZUANI', 'S FRANCISCO                   ');
INSERT INTO cd_cep_br VALUES ('69.044-350', '156      ', 'R WANDERLEI FARIAS (CJ BELVEDERE)', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('57.046-420', '54       ', 'R PROGRESSO', 'B DURO                        ');
INSERT INTO cd_cep_br VALUES ('69.044-450', '156      ', 'R WANDERLEI NORMANDO (CJ BELVEDERE)', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('69.093-189', '156      ', 'R WARUETE(T.NOVA II)', 'COL T NOVA                    ');
INSERT INTO cd_cep_br VALUES ('69.063-410', '156      ', 'BC WASHINGTON LUIS', 'PETROPOLIS                    ');
INSERT INTO cd_cep_br VALUES ('69.040-210', '156      ', 'R WASHINGTON LUIS (CJ D PEDRO I)', 'D PEDRO                       ');
INSERT INTO cd_cep_br VALUES ('69.074-340', '156      ', 'R WAUPES (VL MILITAR PONTA PELADA)', 'S LAZARO                      ');
INSERT INTO cd_cep_br VALUES ('69.010-420', '156      ', 'R WILKENS DE MATOS', 'APARECIDA                     ');
INSERT INTO cd_cep_br VALUES ('69.082-551', '156      ', 'R WOLFANDO NOGUEIRA(CJ O VERDE)', 'COROADO                       ');
INSERT INTO cd_cep_br VALUES ('69.042-330', '156      ', 'AV X', 'ALVORADA                      ');
INSERT INTO cd_cep_br VALUES ('69.043-520', '156      ', 'R X (CJ DE FLORES II)', 'ALVORADA                      ');
INSERT INTO cd_cep_br VALUES ('69.050-370', '156      ', 'R X (CJ ELDORADO)', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.095-771', '156      ', 'R X (CJ R S PINTO II)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.093-074', '156      ', 'R XAVANTE(T. NOVA II)', 'COL T NOVA                    ');
INSERT INTO cd_cep_br VALUES ('69.067-461', '156      ', 'BC XAVIER (S SEBASTIAO)', 'PETROPOLIS                    ');
INSERT INTO cd_cep_br VALUES ('69.010-430', '156      ', 'R XAVIER DE MENDONCA', 'APARECIDA                     ');
INSERT INTO cd_cep_br VALUES ('69.090-740', '156      ', 'R XINGU (CJ C NOVA)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.042-421', '156      ', 'R Y', 'ALVORADA                      ');
INSERT INTO cd_cep_br VALUES ('69.048-328', '156      ', 'R YANOMANI (CJ JURUA)', 'ALVORADA                      ');
INSERT INTO cd_cep_br VALUES ('69.028-350', '156      ', 'R YARA', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('69.089-310', '156      ', 'R Z', 'A MENDES                      ');
INSERT INTO cd_cep_br VALUES ('69.042-340', '156      ', 'AV Z', 'ALVORADA                      ');
INSERT INTO cd_cep_br VALUES ('69.043-530', '156      ', 'R Z (CJ DE FLORES II)', 'ALVORADA                      ');
INSERT INTO cd_cep_br VALUES ('69.050-380', '156      ', 'R Z (CJ ELDORADO)', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.029-570', '156      ', 'R ZAP', 'S ANTONIO                     ');
INSERT INTO cd_cep_br VALUES ('69.054-393', '156      ', 'R ZERO(CJ. JD. PRIMAVERA)', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.089-074', '156      ', 'AV ZUMBI', 'A MENDES                      ');
INSERT INTO cd_cep_br VALUES ('69.086-020', '156      ', 'R 01', 'S J OPERARIO                  ');
INSERT INTO cd_cep_br VALUES ('69.040-080', '156      ', 'R 01', 'D PEDRO                       ');
INSERT INTO cd_cep_br VALUES ('69.039-720', '156      ', 'R 01', 'N ISRAEL                      ');
INSERT INTO cd_cep_br VALUES ('69.093-381', '156      ', 'R 01', 'COL S ANTONIO                 ');
INSERT INTO cd_cep_br VALUES ('69.028-328', '156      ', 'TV 01', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('69.028-347', '156      ', 'R 01', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('69.038-271', '156      ', 'R 01', 'L VALE                        ');
INSERT INTO cd_cep_br VALUES ('69.042-130', '156      ', 'R 01- DE 363/364 AO FIM', 'ALVORADA                      ');
INSERT INTO cd_cep_br VALUES ('69.038-280', '156      ', 'R 01 (CJ A MONTENEGRO)', 'L VALE                        ');
INSERT INTO cd_cep_br VALUES ('69.080-700', '156      ', 'BC VITORIA', 'COROADO                       ');
INSERT INTO cd_cep_br VALUES ('69.080-690', '156      ', 'R VITORIA', 'COROADO                       ');
INSERT INTO cd_cep_br VALUES ('69.027-731', '156      ', 'R VITORIA', 'GLORIA                        ');
INSERT INTO cd_cep_br VALUES ('69.038-030', '156      ', 'R VITORIA', 'L VALE                        ');
INSERT INTO cd_cep_br VALUES ('69.068-210', '156      ', 'BC VITORIA', 'RAIZ                          ');
INSERT INTO cd_cep_br VALUES ('69.054-571', '156      ', 'TV VITORIA', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('69.027-732', '156      ', 'BC VITORIA', 'GLORIA                        ');
INSERT INTO cd_cep_br VALUES ('69.059-291', '156      ', 'BC VITORIA', 'S ETELVINA                    ');
INSERT INTO cd_cep_br VALUES ('69.093-152', '156      ', 'R VITORIA(M.OLIVEIRAS)', 'MTE OLIVEIRAS                 ');
INSERT INTO cd_cep_br VALUES ('69.058-340', '156      ', 'R VITORIA (PRQ LARANJEIRAS)', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('69.093-412', '156      ', 'BC VITORIA I, DA(T NOVA I)', 'COL T NOVA                    ');
INSERT INTO cd_cep_br VALUES ('69.093-414', '156      ', 'R VITORIA II, DA(T NOVA I)', 'COL T NOVA                    ');
INSERT INTO cd_cep_br VALUES ('69.065-260', '156      ', 'BC VITORIA REGIA', 'CACHOEIRINHA                  ');
INSERT INTO cd_cep_br VALUES ('69.082-400', '156      ', 'R VITORIA REGIA', 'COROADO                       ');
INSERT INTO cd_cep_br VALUES ('69.038-130', '156      ', 'R VITORIA REGIA', 'L VALE                        ');
INSERT INTO cd_cep_br VALUES ('69.033-260', '156      ', 'R VITORIA REGIA', 'S JORGE                       ');
INSERT INTO cd_cep_br VALUES ('57.300-540', '23       ', 'R QUINZE DE AGOSTO', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.300-340', '23       ', 'R QUINZE DE NOVEMBRO', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.018-355', '54       ', 'TV PREFEITO JOATAS MALTA DE ALENCAR', 'C JAQUEIRA                    ');
INSERT INTO cd_cep_br VALUES ('57.084-450', '54       ', 'R PRESB. MANOEL MOACIR TENORIO MASCARENHAS(RUA 3', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.045-130', '54       ', 'R PRESCILIANO SARMENTO', 'B DURO                        ');
INSERT INTO cd_cep_br VALUES ('57.031-240', '54       ', 'R PRESIDENTE AGOSTINHO DA SILVA NEVES', 'POCO                          ');
INSERT INTO cd_cep_br VALUES ('57.036-340', '54       ', 'AV PRESIDENTE CASTELO BRANCO', 'JATIUCA                       ');
INSERT INTO cd_cep_br VALUES ('57.045-140', '54       ', 'AV PRESIDENTE GETULIO VARGAS', 'B DURO                        ');
INSERT INTO cd_cep_br VALUES ('57.045-145', '54       ', 'TV PRESIDENTE GETULIO VARGAS', 'B DURO                        ');
INSERT INTO cd_cep_br VALUES ('57.037-410', '54       ', 'JD PRESIDENTE JUSCELINO KUBISTSCHEK DE OLIVEIRA', 'JATIUCA                       ');
INSERT INTO cd_cep_br VALUES ('57.070-420', '54       ', 'JD PRESIDENTE JUSCELINO KUBITSCHEK DE OLIVEIRA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.011-130', '54       ', 'R PRESIDENTE MEDICI', 'T BARRA                       ');
INSERT INTO cd_cep_br VALUES ('57.015-750', '54       ', 'R PRESIDENTE PRUDENTE DE MORAES', 'LEVADA                        ');
INSERT INTO cd_cep_br VALUES ('57.045-150', '54       ', 'AV PRESIDENTE ROOSEVELT', 'B DURO                        ');
INSERT INTO cd_cep_br VALUES ('57.046-410', '54       ', 'TV PRESIDENTE ROOSEVELT', 'SERRARIA                      ');
INSERT INTO cd_cep_br VALUES ('57.036-400', '54       ', 'AV PRETESTATO FERREIRA MACHADO', 'JATIUCA                       ');
INSERT INTO cd_cep_br VALUES ('57.035-300', '54       ', 'TV PRIMAVERA', 'P VERDE                       ');
INSERT INTO cd_cep_br VALUES ('57.011-370', '54       ', 'R PRIMEIRO DE MAIO', 'PRADO                         ');
INSERT INTO cd_cep_br VALUES ('57.041-240', '54       ', 'R PRIMEIRO DE MARCO', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.051-520', '54       ', 'R PRINCESA ISABEL', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.045-850', '54       ', 'R PRINCESA ISABEL', 'B DURO                        ');
INSERT INTO cd_cep_br VALUES ('57.082-380', '54       ', 'R PROFESSOR ALCOFORADO DE PEREIRA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.010-540', '54       ', 'R PROFESSOR ALMEIDA LEITE', 'T BARRA                       ');
INSERT INTO cd_cep_br VALUES ('57.051-530', '54       ', 'R PROFESSOR ANGELO NETO', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.036-700', '54       ', 'R PROFESSOR ANTONIO CARLOS DE MOURA GAMA', 'MANGABEIRAS                   ');
INSERT INTO cd_cep_br VALUES ('57.055-140', '54       ', 'R PROFESSOR ANTONIO MARIO MAFRA', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.080-420', '54       ', 'R PROFESSOR ANTONIO NEMESIO DE ALBUQUERQUE', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.022-100', '54       ', 'PC PROFESSOR ARTUR RAMOS', 'JARAGUA                       ');
INSERT INTO cd_cep_br VALUES ('57.051-540', '54       ', 'R PROFESSOR AURINO MACIEL', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.018-150', '54       ', 'LD PROFESSOR BENEDITO SILVA', 'BEBEDOURO                     ');
INSERT INTO cd_cep_br VALUES ('57.072-440', '54       ', 'PC PEDRO TENORIO RAPOSO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.017-460', '54       ', 'R PEDRO VIANA', 'BEBEDOURO                     ');
INSERT INTO cd_cep_br VALUES ('57.082-330', '54       ', 'R PEDROSA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.038-420', '54       ', 'AV PENEDO', 'C ALMAS                       ');
INSERT INTO cd_cep_br VALUES ('57.043-350', '54       ', 'TV PENEDO', 'FEITOSA                       ');
INSERT INTO cd_cep_br VALUES ('57.055-840', '54       ', 'R PENEDO', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.017-470', '54       ', 'R PENHA, DA', 'BEBEDOURO                     ');
INSERT INTO cd_cep_br VALUES ('57.025-350', '54       ', 'R PERNAMBUCO', 'POCO                          ');
INSERT INTO cd_cep_br VALUES ('57.052-510', '54       ', 'R PEROBAS, DAS', 'G LOURDES                     ');
INSERT INTO cd_cep_br VALUES ('57.061-680', '54       ', 'R PETRUCIO FERREIRA LOPES (CJ MORADA DOS PALMARE', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.071-200', '54       ', 'R PHILADELPHO COUTINHO DE ARAUJO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.080-030', '54       ', 'R PIACABUCU', 'CANAA                         ');
INSERT INTO cd_cep_br VALUES ('57.011-230', '54       ', 'R PIAUI', 'PRADO                         ');
INSERT INTO cd_cep_br VALUES ('57.045-620', '54       ', 'R PIERRE MARQUES BARBOSA', 'O PRETO                       ');
INSERT INTO cd_cep_br VALUES ('57.038-430', '54       ', 'AV PILAR', 'C ALMAS                       ');
INSERT INTO cd_cep_br VALUES ('57.038-440', '54       ', 'PC PINDORAMA', 'C ALMAS                       ');
INSERT INTO cd_cep_br VALUES ('57.074-070', '54       ', 'R PINHAIS (LOT PARQUE DAS ARVORES)', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.074-120', '54       ', 'R PINHEIRO (LOT PARQUE DAS ARVORES)', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.084-310', '54       ', 'R PINTOR MIGUEL TORRES DE OLIVEIRA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.082-250', '54       ', 'R RAUL BRITO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.025-290', '54       ', 'PC RAUL RAMOS', 'POCO                          ');
INSERT INTO cd_cep_br VALUES ('57.030-820', '54       ', 'CJ RECANTO DA GAVEA', 'POCO                          ');
INSERT INTO cd_cep_br VALUES ('57.071-110', '54       ', 'R RECANTO DO SOL', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.025-380', '54       ', 'PC RECIFE', 'POCO                          ');
INSERT INTO cd_cep_br VALUES ('57.030-400', '54       ', 'R REGENTE FEIJO', 'P TERRA                       ');
INSERT INTO cd_cep_br VALUES ('57.052-210', '54       ', 'R REGINA CORDEIRO LINS', 'G LOURDES                     ');
INSERT INTO cd_cep_br VALUES ('57.050-340', '54       ', 'R REGINALDO, DO', 'PITANGUINHA                   ');
INSERT INTO cd_cep_br VALUES ('57.073-440', '54       ', 'R REINALDO COSTA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.062-370', '54       ', 'AL REJANE MARIA CAMELO ALVES LIMA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.046-170', '54       ', 'R REMY MAIA', 'SERRARIA                      ');
INSERT INTO cd_cep_br VALUES ('57.083-480', '54       ', 'R RENATO LISBOA CALHEIROS', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.030-610', '54       ', 'CJ REPOUSO DA GAVEA', 'POCO                          ');
INSERT INTO cd_cep_br VALUES ('57.071-410', '54       ', 'R PROFESSOR OMENA CAMPELO', 'A S DUMONT                    ');
INSERT INTO cd_cep_br VALUES ('57.084-500', '54       ', 'R PROFESSOR ORDENER CERQUEIRA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.018-680', '54       ', 'R PROFESSOR ORLANDO LINS', 'C JAQUEIRA                    ');
INSERT INTO cd_cep_br VALUES ('57.014-360', '54       ', 'R PROFESSOR PAULO SENOULLET', 'P GROSSA                      ');
INSERT INTO cd_cep_br VALUES ('57.036-350', '54       ', 'R PROFESSOR PEDRO BUARQUE WANDERLEY', 'JATIUCA                       ');
INSERT INTO cd_cep_br VALUES ('57.046-680', '54       ', 'R PROFESSOR ROBSON GERALDO COSTA', 'SERRARIA                      ');
INSERT INTO cd_cep_br VALUES ('57.045-630', '54       ', 'R PROFESSOR RUI DAN SAMPAIO', 'B DURO                        ');
INSERT INTO cd_cep_br VALUES ('57.035-230', '54       ', 'R PROFESSOR SANDOVAL ARROXELAS', 'P VERDE                       ');
INSERT INTO cd_cep_br VALUES ('57.040-370', '54       ', 'R PROFESSOR SIDRONIO', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.040-375', '54       ', 'TV PROFESSOR SIDRONIO', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.036-740', '54       ', 'R PROFESSOR SILVIO MACEDO', 'JATIUCA                       ');
INSERT INTO cd_cep_br VALUES ('57.052-630', '54       ', 'R PROFESSOR SINVAL GAMA FILHO', 'G LOURDES                     ');
INSERT INTO cd_cep_br VALUES ('57.010-320', '54       ', 'R PROFESSOR TEONILO GAMA', 'T BARRA                       ');
INSERT INTO cd_cep_br VALUES ('57.014-220', '54       ', 'R PROFESSOR VIRGILIO GUEDES', 'P GROSSA                      ');
INSERT INTO cd_cep_br VALUES ('57.035-570', '54       ', 'AV PROFESSOR VITAL BARBOSA', 'P VERDE                       ');
INSERT INTO cd_cep_br VALUES ('57.062-340', '54       ', 'AL PROFESSORA ALZIRA ROCHA DE LIMA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.072-030', '54       ', 'R PROFESSORA CELIA MACEDO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.036-750', '54       ', 'R PROFESSORA EDITH BRANDAO NOGUEIRA', 'JATIUCA                       ');
INSERT INTO cd_cep_br VALUES ('57.055-800', '54       ', 'R PROFESSORA EUNICE LOBAO', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.035-140', '54       ', 'R PROFESSORA HIGIA VASCONCELOS', 'P VERDE                       ');
INSERT INTO cd_cep_br VALUES ('57.041-260', '54       ', 'R PROFESSORA INEZ', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.083-200', '54       ', 'R PROFESSORA JUDITH  SERPA SANTA MARIA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.072-620', '54       ', 'R PROFESSORA MARIA DE LOURDES ROCHA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.036-840', '54       ', 'R PROFESSORA MARIA ESTER DA COSTA BARROS', 'JATIUCA                       ');
INSERT INTO cd_cep_br VALUES ('57.011-260', '54       ', 'R PROFESSORA MARIA JOSE LOUREIRO LIMA', 'PRADO                         ');
INSERT INTO cd_cep_br VALUES ('57.072-450', '54       ', 'R PROFESSORA MARIA LUIZA GUSMAO DE MORAES', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.036-760', '54       ', 'R PROFESSORA NADYR MAIA GOMES REGO', 'JATIUCA                       ');
INSERT INTO cd_cep_br VALUES ('57.039-150', '54       ', 'R PROFESSORA NOEMIA GAMA RAMALHO', 'JACARECICA                    ');
INSERT INTO cd_cep_br VALUES ('57.072-170', '54       ', 'R PROFESSORA OLINDINA PEREIRA DA SILVA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.040-380', '54       ', 'R PROGRESSO', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.055-735', '54       ', 'TV PROGRESSO', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.040-075', '54       ', 'R PROJETADA A (LOT JUCARA II)', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.040-085', '54       ', 'R PROJETADA B (LOT JUCARA II)', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('69.036-480', '156      ', 'R 13 (CJ R XINGU)', 'COMPENSA                      ');
INSERT INTO cd_cep_br VALUES ('57.312-310', '23       ', 'R MANOEL PROCOPIO DE OLIVEIRA', 'S A MELO                      ');
INSERT INTO cd_cep_br VALUES ('57.312-340', '23       ', 'R MANOEL PROTASIO', 'AT CRUZEIRO                   ');
INSERT INTO cd_cep_br VALUES ('57.304-480', '23       ', 'R MANOEL ROSENDO DE MAGALHAES', 'PRIMAVERA                     ');
INSERT INTO cd_cep_br VALUES ('57.303-320', '23       ', 'R MANOEL SATURNINO DE ALMEIDA', 'B VISTA                       ');
INSERT INTO cd_cep_br VALUES ('57.306-680', '23       ', 'R MANOEL SIRES NUNES', 'CAVACO                        ');
INSERT INTO cd_cep_br VALUES ('57.305-030', '23       ', 'R MANOEL TELES', 'M TELES                       ');
INSERT INTO cd_cep_br VALUES ('57.305-710', '23       ', 'R MANOEL TEODORO DOS SANTOS', 'P FRIO                        ');
INSERT INTO cd_cep_br VALUES ('57.300-610', '23       ', 'R PIO MATOS DE MELO', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.305-720', '23       ', 'R PORTO CALVO', 'M TELES                       ');
INSERT INTO cd_cep_br VALUES ('57.308-510', '23       ', 'R PORTO DE PEDRAS', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('57.311-340', '23       ', 'R PORTO REAL DO COLEGIO', 'CAITITUS                      ');
INSERT INTO cd_cep_br VALUES ('57.310-100', '23       ', 'R POSSIDONIO NUNES', 'CAPIATA                       ');
INSERT INTO cd_cep_br VALUES ('57.306-720', '23       ', 'R PREGENTINA BALBINA DE LIMA', 'CAVACO                        ');
INSERT INTO cd_cep_br VALUES ('57.304-040', '23       ', 'R PRESIDENTE CAFE FILHO', 'PRIMAVERA                     ');
INSERT INTO cd_cep_br VALUES ('57.311-090', '23       ', 'R PRESIDENTE DUTRA', 'AT CRUZEIRO                   ');
INSERT INTO cd_cep_br VALUES ('57.314-050', '23       ', 'R PRESIDENTE GETULIO VARGAS', 'ITAPOA                        ');
INSERT INTO cd_cep_br VALUES ('57.312-450', '23       ', 'R PRESIDENTE MEDICI', 'AT CRUZEIRO                   ');
INSERT INTO cd_cep_br VALUES ('57.314-210', '23       ', 'R NOSSA SENHORA DO ROSARIO', 'BRASILIA                      ');
INSERT INTO cd_cep_br VALUES ('57.302-280', '23       ', 'AV NOVO NORDESTE', 'S LUIZ                        ');
INSERT INTO cd_cep_br VALUES ('57.301-280', '23       ', 'R ODILON ARAUJO AMORIM', 'S LUIZ                        ');
INSERT INTO cd_cep_br VALUES ('57.301-210', '23       ', 'R ODILON AUTO', 'O PRETO                       ');
INSERT INTO cd_cep_br VALUES ('57.306-270', '23       ', 'R OFICIAL DE JUSTICA DANDAO', 'ELDORADO                      ');
INSERT INTO cd_cep_br VALUES ('57.300-390', '23       ', 'R OLAVO BILAC', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.308-070', '23       ', 'R OLEGARIO LEITE', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('57.308-410', '23       ', 'R OLHO D AGUA DAS FLORES', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('57.304-420', '23       ', 'R OLINDA', 'PRIMAVERA                     ');
INSERT INTO cd_cep_br VALUES ('57.308-280', '23       ', 'R OLIVENCA', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('57.306-210', '23       ', 'R OSEAS JOSE DOS SANTOS', 'ELDORADO                      ');
INSERT INTO cd_cep_br VALUES ('57.301-200', '23       ', 'R OSMAN LOUREIRO', 'S LUIZ                        ');
INSERT INTO cd_cep_br VALUES ('57.306-560', '23       ', 'PC OTACILIO BENEDITO DOS SANTOS', 'CAVACO                        ');
INSERT INTO cd_cep_br VALUES ('57.304-820', '23       ', 'R OTAVIO LOURENCO DE SOUZA', 'CACIMBAS                      ');
INSERT INTO cd_cep_br VALUES ('57.306-280', '23       ', 'R OTILIA VIEIRA SILVA', 'ELDORADO                      ');
INSERT INTO cd_cep_br VALUES ('57.312-020', '23       ', 'R OURO BRANCO', 'S ESMERALDA                   ');
INSERT INTO cd_cep_br VALUES ('57.305-370', '23       ', 'R PADRE AMERICO', 'BAIXAO                        ');
INSERT INTO cd_cep_br VALUES ('57.301-020', '23       ', 'R PADRE ANCHIETA', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.313-430', '23       ', 'R PADRE ANTONIO LIMA NETO', 'JD TROPICAL                   ');
INSERT INTO cd_cep_br VALUES ('57.306-030', '23       ', 'PC PADRE CICERO', 'ELDORADO                      ');
INSERT INTO cd_cep_br VALUES ('57.300-040', '23       ', 'R PADRE CICERO', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.304-320', '23       ', 'R PADRE CIRILO', 'PRIMAVERA                     ');
INSERT INTO cd_cep_br VALUES ('57.306-120', '23       ', 'R PADRE DANIEL', 'ELDORADO                      ');
INSERT INTO cd_cep_br VALUES ('57.312-480', '23       ', 'R PADRE JEFFERSON DE CARVALHO', 'AT CRUZEIRO                   ');
INSERT INTO cd_cep_br VALUES ('57.304-460', '23       ', 'R PADRE MAURICIO RODRIGUES', 'CACIMBAS                      ');
INSERT INTO cd_cep_br VALUES ('57.310-240', '23       ', 'R PAJUCARA', 'CAPIATA                       ');
INSERT INTO cd_cep_br VALUES ('57.308-400', '23       ', 'R PALESTINA', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('57.311-320', '23       ', 'R PALMARES', 'CAITITUS                      ');
INSERT INTO cd_cep_br VALUES ('57.308-370', '23       ', 'AV PAO DE ACUCAR', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('57.303-160', '23       ', 'R PARANA', 'V CAMPOS                      ');
INSERT INTO cd_cep_br VALUES ('57.308-620', '23       ', 'R PASSO DE CAMARAGIBE', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('57.303-580', '23       ', 'R PASTOR CICERO FARIAS', 'GUARIBAS                      ');
INSERT INTO cd_cep_br VALUES ('57.311-420', '23       ', 'R PASTOR JOSE ALVES', 'CAITITUS                      ');
INSERT INTO cd_cep_br VALUES ('57.307-440', '23       ', 'R PASTOR JOSE CICERO DE FARIAS', 'JD ESPERANCA                  ');
INSERT INTO cd_cep_br VALUES ('57.313-490', '23       ', 'R PATROCINIO JOSE', 'JD TROPICAL                   ');
INSERT INTO cd_cep_br VALUES ('57.302-130', '23       ', 'R PAULA CAMPOS', 'CANAFISTULA                   ');
INSERT INTO cd_cep_br VALUES ('57.301-260', '23       ', 'R PAULA MAGALHAES', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.304-000', '23       ', 'R PAULO AFONSO', 'PRIMAVERA                     ');
INSERT INTO cd_cep_br VALUES ('57.310-010', '23       ', 'R MAURICIO PEREIRA- DE 1669/1736 AO FIM', 'BRASILIANA                    ');
INSERT INTO cd_cep_br VALUES ('57.304-050', '23       ', 'R MAYR GUEDES DO AMARAL', 'PRIMAVERA                     ');
INSERT INTO cd_cep_br VALUES ('57.301-090', '23       ', 'R MEDIUM JOSE ARIGO', 'O PRETO                       ');
INSERT INTO cd_cep_br VALUES ('57.301-340', '23       ', 'R MENINO ALEXANDRE', 'S LUIZ                        ');
INSERT INTO cd_cep_br VALUES ('57.312-080', '23       ', 'PC MENINO JESUS', 'S ESMERALDA                   ');
INSERT INTO cd_cep_br VALUES ('57.307-260', '23       ', 'PC MENINO LUNI CARLOS LIMA', 'JD ESPERANCA                  ');
INSERT INTO cd_cep_br VALUES ('57.306-710', '23       ', 'R MESSIAS BERNARDINO DOS SANTOS', 'CAVACO                        ');
INSERT INTO cd_cep_br VALUES ('57.312-250', '23       ', 'R MESTRE GERALDO', 'S A MELO                      ');
INSERT INTO cd_cep_br VALUES ('57.306-080', '23       ', 'R MESTRE TOTO', 'ELDORADO                      ');
INSERT INTO cd_cep_br VALUES ('57.305-000', '23       ', 'AV MIGUEL CORREIA AMORIM', 'BAIXAO                        ');
INSERT INTO cd_cep_br VALUES ('57.313-110', '23       ', 'R MIGUEL LEITE', 'BRASILIA                      ');
INSERT INTO cd_cep_br VALUES ('57.310-060', '23       ', 'R MIGUEL OLIVEIRA', 'BRASILIANA                    ');
INSERT INTO cd_cep_br VALUES ('57.308-120', '23       ', 'R MIGUEL PEDRO LIMA', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('57.305-550', '23       ', 'R MIGUEL TEODORO DOS SANTOS', 'BAIXAO                        ');
INSERT INTO cd_cep_br VALUES ('57.305-610', '23       ', 'R MIGUEL TERTULIANO DA SILVA', 'BAIXAO                        ');
INSERT INTO cd_cep_br VALUES ('57.304-230', '23       ', 'R MILTON FERREIRA DE MELO', 'PRIMAVERA                     ');
INSERT INTO cd_cep_br VALUES ('57.312-620', '23       ', 'AV MINERVINA FRANCISCA DA CONCEICAO', 'N HORIZONTE                   ');
INSERT INTO cd_cep_br VALUES ('57.310-230', '23       ', 'AV MINISTRO PETRONIO PORTELA', 'CAPIATA                       ');
INSERT INTO cd_cep_br VALUES ('57.304-620', '23       ', 'R MINTERIO DANDAO', 'CACIMBAS                      ');
INSERT INTO cd_cep_br VALUES ('57.300-370', '23       ', 'R MONSENHOR MACEDO', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.306-170', '23       ', 'R MONTE CASTELO', 'ELDORADO                      ');
INSERT INTO cd_cep_br VALUES ('57.308-290', '23       ', 'PC MONTEIRO LOBATO', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('57.308-180', '23       ', 'R MONTEIROPOLIS', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('57.303-000', '23       ', 'AV MUNIZ FALCAO', 'GUARIBAS                      ');
INSERT INTO cd_cep_br VALUES ('57.308-470', '23       ', 'R MURICI', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('57.308-320', '23       ', 'R SAO JOSE DA LAGE', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('57.314-190', '23       ', 'R SAO JUDAS TADEU', 'BRASILIA                      ');
INSERT INTO cd_cep_br VALUES ('57.301-140', '23       ', 'R SAO LUIZ', 'O PRETO                       ');
INSERT INTO cd_cep_br VALUES ('57.308-600', '23       ', 'R SAO LUIZ DO QUITUNDE', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('57.300-170', '23       ', 'R SAO MIGUEL', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.312-050', '23       ', 'R SAO MIGUEL DOS CAMPOS', 'AT CRUZEIRO                   ');
INSERT INTO cd_cep_br VALUES ('57.313-090', '23       ', 'R SAO NICOLAU', 'BRASILIA                      ');
INSERT INTO cd_cep_br VALUES ('57.304-210', '23       ', 'R PRIMAVERA', 'PRIMAVERA                     ');
INSERT INTO cd_cep_br VALUES ('57.300-050', '23       ', 'R PROFESSOR DOMINGOS CORREIA- ATE 521/576', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.301-070', '23       ', 'R PROFESSOR DOMINGOS CORREIA- DE 523/578 AO FIM', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.300-470', '23       ', 'R PROFESSOR DOMINGOS RODRIGUES', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.304-380', '23       ', 'R PROFESSOR GUEDES DE MIRANDA', 'PRIMAVERA                     ');
INSERT INTO cd_cep_br VALUES ('57.312-120', '23       ', 'R PROFESSOR HIGINO VITAL', 'S ESMERALDA                   ');
INSERT INTO cd_cep_br VALUES ('57.306-220', '23       ', 'PC PROFESSOR PEDRO REIS', 'ELDORADO                      ');
INSERT INTO cd_cep_br VALUES ('57.305-410', '23       ', 'R PROFESSOR PEDRO REIS', 'BAIXAO                        ');
INSERT INTO cd_cep_br VALUES ('57.300-260', '23       ', 'R PROFESSORA AMALIA FRAGOSO', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.310-030', '23       ', 'R PROFESSORA BRANCA LEITE', 'BRASILIANA                    ');
INSERT INTO cd_cep_br VALUES ('57.310-040', '23       ', 'R PROFESSORA NIREIDE BRITO SILVA', 'R CRUZ                        ');
INSERT INTO cd_cep_br VALUES ('57.038-090', '54       ', 'R LEOPOLDO ARAUJO AMORIM', 'MANGABEIRAS                   ');
INSERT INTO cd_cep_br VALUES ('57.040-000', '54       ', 'R CORONEL PARANHOS', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.040-005', '54       ', 'TV CORONEL PARANHOS', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.022-220', '54       ', 'R CORONEL PEDRO LIMA', 'JARAGUA                       ');
INSERT INTO cd_cep_br VALUES ('57.022-225', '54       ', 'TV CORONEL PEDRO LIMA', 'JARAGUA                       ');
INSERT INTO cd_cep_br VALUES ('57.082-150', '54       ', 'R CORONEL PEDRO PIERRE BRAGA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.057-310', '54       ', 'R CORONEL RUI FERREIRA OLIVEIRA', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.045-060', '54       ', 'AV CORONEL SALUSTIANO SARMENTO', 'B DURO                        ');
INSERT INTO cd_cep_br VALUES ('57.010-290', '54       ', 'R CORONEL SERAFIM DUTRA CAVALCANTE', 'T BARRA                       ');
INSERT INTO cd_cep_br VALUES ('57.020-370', '54       ', 'R CORONEL VIEIRA PEIXOTO', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.080-470', '54       ', 'R CORURIPE', 'CANAA                         ');
INSERT INTO cd_cep_br VALUES ('57.020-540', '54       ', 'R COSTA LEITE', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.073-540', '54       ', 'AV COSTA NABAL', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.017-580', '54       ', 'R COSTA REGO', 'BEBEDOURO                     ');
INSERT INTO cd_cep_br VALUES ('57.063-010', '54       ', 'LOT COSTA REGO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.014-010', '54       ', 'R CRAVEIRO COSTA', 'P GROSSA                      ');
INSERT INTO cd_cep_br VALUES ('57.070-205', '54       ', 'TV CRAVO, DO', 'R NOVO                        ');
INSERT INTO cd_cep_br VALUES ('57.061-040', '54       ', 'R CRAVO, DO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.022-030', '54       ', 'R CRISTOVAO COLOMBO', 'JARAGUA                       ');
INSERT INTO cd_cep_br VALUES ('57.022-035', '54       ', 'TV CRISTOVAO COLOMBO', 'JARAGUA                       ');
INSERT INTO cd_cep_br VALUES ('57.038-040', '54       ', 'AV CRUZ DAS ALMAS', 'C ALMAS                       ');
INSERT INTO cd_cep_br VALUES ('57.015-260', '54       ', 'AV CRUZEIRO DO SUL', 'V LAGO                        ');
INSERT INTO cd_cep_br VALUES ('57.011-180', '54       ', 'R COMENDADOR TEIXEIRA BASTOS- DE 151/152 AO FIM', 'PRADO                         ');
INSERT INTO cd_cep_br VALUES ('57.015-660', '54       ', 'AV COMENDADOR TERCIO WANDERLEY', 'LEVADA                        ');
INSERT INTO cd_cep_br VALUES ('57.070-070', '54       ', 'R COMENDADOR VASCONCELOS', 'F VELHO                       ');
INSERT INTO cd_cep_br VALUES ('57.061-590', '54       ', 'R COMERCIANTE WILSON ARAUJO VASCONCELOS', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.020-000', '54       ', 'R COMERCIO, DO', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.030-150', '54       ', 'R CONDE IRAJA', 'PAJUCARA                      ');
INSERT INTO cd_cep_br VALUES ('57.036-470', '54       ', 'R CONEGO ANTONIO FIRMINO DE VASCONCELOS', 'JATIUCA                       ');
INSERT INTO cd_cep_br VALUES ('57.055-720', '54       ', 'R CONEGO CAVALCANTE DE OLIVEIRA', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.017-550', '54       ', 'R CONEGO COSTA', 'BEBEDOURO                     ');
INSERT INTO cd_cep_br VALUES ('57.010-280', '54       ', 'R CONEGO FERNANDO LYRA', 'T BARRA                       ');
INSERT INTO cd_cep_br VALUES ('57.071-815', '54       ', 'PC CONEGO HELIO LESSA', 'A S DUMONT                    ');
INSERT INTO cd_cep_br VALUES ('57.063-160', '54       ', 'R CONEGO HELIO LESSA SOUZA(LOT CIPESA)', 'S AMELIA                      ');
INSERT INTO cd_cep_br VALUES ('57.055-640', '54       ', 'R CONEGO JOAO DE BARROS PINHO', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.017-565', '54       ', 'TV CONEGO JOSE BELARMINO BARBOSA', 'BEBEDOURO                     ');
INSERT INTO cd_cep_br VALUES ('57.051-160', '54       ', 'R CONEGO MACHADO', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.039-570', '54       ', 'R CONEGO MACHADO', 'SAUDE                         ');
INSERT INTO cd_cep_br VALUES ('57.050-170', '54       ', 'R CONEGO TOBIAS', 'PITANGUINHA                   ');
INSERT INTO cd_cep_br VALUES ('57.050-180', '54       ', 'R CONEGO VALENTE', 'PITANGUINHA                   ');
INSERT INTO cd_cep_br VALUES ('57.011-360', '54       ', 'TV CONFIDENTES, DOS', 'PRADO                         ');
INSERT INTO cd_cep_br VALUES ('57.071-600', '54       ', 'R CONJUNTO UNIVERSITARIO', 'A S DUMONT                    ');
INSERT INTO cd_cep_br VALUES ('57.011-020', '54       ', 'R CONSELHEIRO FRANCISCO VIEIRA', 'PRADO                         ');
INSERT INTO cd_cep_br VALUES ('57.015-680', '54       ', 'R CONSELHEIRO JOAO ALFREDO', 'LEVADA                        ');
INSERT INTO cd_cep_br VALUES ('57.038-020', '54       ', 'R CONSTANT PACHECO', 'C ALMAS                       ');
INSERT INTO cd_cep_br VALUES ('57.018-700', '54       ', 'TV DJALMA', 'C JAQUEIRA                    ');
INSERT INTO cd_cep_br VALUES ('57.057-510', '54       ', 'R DJALMA BARRETO DE MENEZES', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.062-730', '54       ', 'R DJALMA FRAGOSO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.062-440', '54       ', 'AL DJALMA GAMA BREDA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.081-380', '54       ', 'R DJALMA LOPES CAHET', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.050-580', '54       ', 'R DJALMA MENDONCA', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.039-580', '54       ', 'R DJANIRA BEZERRA DE OMENA', 'F PEIXOTO                     ');
INSERT INTO cd_cep_br VALUES ('57.020-120', '54       ', 'R DOIS DE DEZEMBRO', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.071-610', '54       ', 'R DOIS DE DEZEMBRO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.071-160', '54       ', 'R DEPUTADO JOAO DIONISIO DE GOIS', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.031-090', '54       ', 'R DEPUTADO JOAO MALTA TAVARES', 'POCO                          ');
INSERT INTO cd_cep_br VALUES ('57.035-330', '54       ', 'R DEPUTADO JOSE LAGES', 'P VERDE                       ');
INSERT INTO cd_cep_br VALUES ('57.062-080', '54       ', 'AL DEPUTADO JOSE LOPES DUARTE', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.046-660', '54       ', 'R DEPUTADO JOSE SAMPAIO', 'SERRARIA                      ');
INSERT INTO cd_cep_br VALUES ('57.031-100', '54       ', 'PC DEPUTADO LIBERATO MITCHEL', 'POCO                          ');
INSERT INTO cd_cep_br VALUES ('57.031-490', '54       ', 'R DEPUTADO LOPES DE FARIAS', 'MANGABEIRAS                   ');
INSERT INTO cd_cep_br VALUES ('57.036-110', '54       ', 'R DEPUTADO LUIZ GONZAGA COUTINHO', 'JATIUCA                       ');
INSERT INTO cd_cep_br VALUES ('57.080-290', '54       ', 'R DEPUTADO MARIO GOMES DE BARROS', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.039-350', '54       ', 'R DEPUTADO MENDONCA BRAGA', 'R DOCE                        ');
INSERT INTO cd_cep_br VALUES ('57.057-060', '54       ', 'R DEPUTADO RUBENS CANUTO', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.035-200', '54       ', 'R DEPUTADO RUBENS CANUTO', 'P VERDE                       ');
INSERT INTO cd_cep_br VALUES ('57.071-230', '54       ', 'AV DEPUTADO SEZERDELO DE BARROS CORREIA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.050-690', '54       ', 'R DEPUTADO SILOE TAVARES', 'G LOURDES                     ');
INSERT INTO cd_cep_br VALUES ('57.036-490', '54       ', 'R DESEMBARGADOR ALFREDO GASPAR DE MENDONCA', 'JATIUCA                       ');
INSERT INTO cd_cep_br VALUES ('57.030-160', '54       ', 'R DESEMBARGADOR ALMEIDA GUIMARAES', 'PAJUCARA                      ');
INSERT INTO cd_cep_br VALUES ('57.051-180', '54       ', 'R DESEMBARGADOR AMORIM LIMA', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.020-640', '54       ', 'R DESEMBARGADOR ARTUR JUCA', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.020-645', '54       ', 'TV DESEMBARGADOR ARTUR JUCA', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.052-320', '54       ', 'R DESEMBARGADOR BARRETO CARDOSO', 'G LOURDES                     ');
INSERT INTO cd_cep_br VALUES ('57.082-300', '54       ', 'EST DESEMBARGADOR CARLOS DE GUSMAO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.084-180', '54       ', 'R DESEMBARGADOR EDUARDO DE SANTA RITA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.043-040', '54       ', 'R DESEMBARGADOR HELIO CABRAL', 'FEITOSA                       ');
INSERT INTO cd_cep_br VALUES ('57.043-045', '54       ', 'TV DESEMBARGADOR HELIO CABRAL', 'FEITOSA                       ');
INSERT INTO cd_cep_br VALUES ('57.061-200', '54       ', 'R DESEMBARGADOR HELVECIO SOUZA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.050-420', '54       ', 'R DESEMBARGADOR HERMANN SOARES TORRES', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.011-030', '54       ', 'R DESEMBARGADOR INOCENCIO LINS', 'PRADO                         ');
INSERT INTO cd_cep_br VALUES ('57.052-070', '54       ', 'R DESEMBARGADOR JOSE FAUSTINO DE MIRANDA', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.042-710', '54       ', 'R DESEMBARGADOR JOSE PANTALEAO NETO', 'B VISTA                       ');
INSERT INTO cd_cep_br VALUES ('57.050-700', '54       ', 'R DESEMBARGADOR MANOEL LOPES FERREIRA PINTO', 'G LOURDES                     ');
INSERT INTO cd_cep_br VALUES ('57.030-670', '54       ', 'R DESEMBARGADOR MARIO GUIMARAES', 'POCO                          ');
INSERT INTO cd_cep_br VALUES ('57.050-210', '54       ', 'R DESEMBARGADOR PEREIRA DO CARMO', 'PITANGUINHA                   ');
INSERT INTO cd_cep_br VALUES ('57.050-050', '54       ', 'R DESEMBARGADOR TENORIO', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.037-030', '54       ', 'AV DESEMBARGADOR VALENTE DE LIMA', 'MANGABEIRAS                   ');
INSERT INTO cd_cep_br VALUES ('57.037-035', '54       ', 'TV DESEMBARGADOR VALENTE DE LIMA', 'MANGABEIRAS                   ');
INSERT INTO cd_cep_br VALUES ('57.083-290', '54       ', 'R DESEMBARGADOR ZEFERINO LAVENERES MACHADO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.080-380', '54       ', 'R DESPACHANTE JERONIMO MACIEIRA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.025-470', '54       ', 'R DESPACHANTE JOAO JAMBO', 'POCO                          ');
INSERT INTO cd_cep_br VALUES ('57.075-070', '54       ', 'CJ CRUZEIRO DO SUL', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.051-660', '54       ', 'AV JOAO PAULO II', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.052-660', '54       ', 'R JOAO PAULO II', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.037-250', '54       ', 'R JOAO PAULO PELENGRINO', 'MANGABEIRAS                   ');
INSERT INTO cd_cep_br VALUES ('57.081-270', '54       ', 'R ARAGUAIA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.043-440', '54       ', 'R ARAGUAIA', 'FEITOSA                       ');
INSERT INTO cd_cep_br VALUES ('57.018-010', '54       ', 'R ARAME, DO', 'BEBEDOURO                     ');
INSERT INTO cd_cep_br VALUES ('57.018-015', '54       ', 'TV ARAME, DO', 'BEBEDOURO                     ');
INSERT INTO cd_cep_br VALUES ('57.040-030', '54       ', 'TV ARAME, DO', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.055-380', '54       ', 'R ARAME, DO', 'PINHEIRO                      ');
INSERT INTO cd_cep_br VALUES ('57.055-385', '54       ', 'TV ARAME, DO', 'PINHEIRO                      ');
INSERT INTO cd_cep_br VALUES ('57.018-505', '54       ', 'TV ARAME, DO', 'C JAQUEIRA                    ');
INSERT INTO cd_cep_br VALUES ('57.038-190', '54       ', 'R ARAPIRACA', 'C ALMAS                       ');
INSERT INTO cd_cep_br VALUES ('57.042-760', '54       ', 'LOT ARAPUA', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.030-030', '54       ', 'R ARAUJO BIVAR', 'PAJUCARA                      ');
INSERT INTO cd_cep_br VALUES ('57.081-580', '54       ', 'AV ANTONIO ALVES', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.082-630', '54       ', 'R ANTONIO ALVES', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.082-610', '54       ', 'R ANTONIO ANDRADE', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.072-510', '54       ', 'R ANTONIO AUGUSTO DE BARROS', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.040-770', '54       ', 'R ANTONIO AUGUSTO DE BARROS', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.043-030', '54       ', 'R BANCARIO GERALDO GONCALVES', 'FEITOSA                       ');
INSERT INTO cd_cep_br VALUES ('57.036-440', '54       ', 'R BANCARIO JOSE FARIAS DE ALMEIDA', 'JATIUCA                       ');
INSERT INTO cd_cep_br VALUES ('57.072-530', '54       ', 'R BANCARIO LYDIO ROSSITER', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.036-080', '54       ', 'R BANCARIO RADY GUSMAO DO NASCIMENTO', 'JATIUCA                       ');
INSERT INTO cd_cep_br VALUES ('57.051-120', '54       ', 'R BANDEIRANTES, DOS', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.050-560', '54       ', 'R BANHEIRO, DO', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.020-210', '54       ', 'R BARAO DE ALAGOAS', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.020-630', '54       ', 'R BARAO DE ANADIA', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.020-515', '54       ', 'PRQ BARAO DE ATALAIA', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.020-510', '54       ', 'R BARAO DE ATALAIA', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.070-080', '54       ', 'R BARAO DE JARAGUA', 'F VELHO                       ');
INSERT INTO cd_cep_br VALUES ('57.022-140', '54       ', 'R BARAO DE JARAGUA', 'JARAGUA                       ');
INSERT INTO cd_cep_br VALUES ('57.020-360', '54       ', 'R BARAO DE MACEIO', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.020-340', '54       ', 'R BARAO DE PENEDO', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.055-160', '54       ', 'R BARAO JOSE MIGUEL', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.042-780', '54       ', 'LOT BARILOCHE', 'B DURO                        ');
INSERT INTO cd_cep_br VALUES ('57.075-200', '54       ', 'R BARTOLOMEU LINS FILHO(RUA 20 CJ OSMAN LOUREIRO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.057-480', '54       ', 'R BASILEU DE MEIRA BARBOSA(ANTIGA ALAMEDA GUAPOR', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.030-050', '54       ', 'R BASILEU MENDES', 'PAJUCARA                      ');
INSERT INTO cd_cep_br VALUES ('57.081-130', '54       ', 'R BASILIANO APRIGIO DE OLIVEIRA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.038-220', '54       ', 'R BATALHA', 'C ALMAS                       ');
INSERT INTO cd_cep_br VALUES ('57.022-010', '54       ', 'R BATISTA ACIOLI', 'JARAGUA                       ');
INSERT INTO cd_cep_br VALUES ('57.017-150', '54       ', 'R BELA VISTA', 'B PARTO                       ');
INSERT INTO cd_cep_br VALUES ('57.070-010', '54       ', 'R BELA VISTA', 'F VELHO                       ');
INSERT INTO cd_cep_br VALUES ('57.041-050', '54       ', 'R BELA VISTA', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.055-290', '54       ', 'R BELA VISTA', 'PINHEIRO                      ');
INSERT INTO cd_cep_br VALUES ('57.025-590', '54       ', 'R BELA VISTA', 'POCO                          ');
INSERT INTO cd_cep_br VALUES ('57.046-040', '54       ', 'CJ ARVOREDO', 'B DURO                        ');
INSERT INTO cd_cep_br VALUES ('57.071-520', '54       ', 'R ARVOREDO, DO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.010-250', '54       ', 'R ARY PITOMBO', 'T BARRA                       ');
INSERT INTO cd_cep_br VALUES ('12.924-530', '4897     ', 'R PATURI', 'COND JD PALMEIRAS             ');
INSERT INTO cd_cep_br VALUES ('57.052-580', '54       ', 'AV ARYOSVALDO PEREIRA CINTRA', 'G LOURDES                     ');
INSERT INTO cd_cep_br VALUES ('57.051-100', '54       ', 'R ASCANIO CASADO', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.020-500', '54       ', 'AV ASPIRANTE ALBERTO MELO DA COSTA', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.071-780', '54       ', 'R ASSEMBLEIA, DA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.010-070', '54       ', 'AV ASSIS CHATEAUBRIAND', 'PRADO                         ');
INSERT INTO cd_cep_br VALUES ('57.038-200', '54       ', 'R ATALAIA', 'C ALMAS                       ');
INSERT INTO cd_cep_br VALUES ('57.045-020', '54       ', 'R ATALAIA', 'B DURO                        ');
INSERT INTO cd_cep_br VALUES ('57.050-540', '54       ', 'R ATERRO, DO', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.073-400', '54       ', 'AV ATOR MARQUES JUNIOR', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.048-120', '54       ', 'R AUDALIO LOPES DA SILVA', 'SERRARIA                      ');
INSERT INTO cd_cep_br VALUES ('57.051-110', '54       ', 'R AUDEIR LIMA AGUIAR PEIXOTO', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.050-400', '54       ', 'R AUDIFAX ALMEIDA', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.040-200', '54       ', 'R AUGUSTA', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.040-205', '54       ', 'TV AUGUSTA', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.020-010', '54       ', 'R AUGUSTA', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.072-070', '54       ', 'R AUGUSTA MATIAS DO NASCIMENTO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.017-530', '54       ', 'R AUGUSTO BARRETO', 'BEBEDOURO                     ');
INSERT INTO cd_cep_br VALUES ('57.017-535', '54       ', 'TV AUGUSTO BARRETO', 'BEBEDOURO                     ');
INSERT INTO cd_cep_br VALUES ('57.043-240', '54       ', 'R AUGUSTO CALHEIROS', 'FEITOSA                       ');
INSERT INTO cd_cep_br VALUES ('57.057-470', '54       ', 'R AUGUSTO CALHEIROS', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.037-390', '54       ', 'R AUGUSTO CARDOSO', 'JATIUCA                       ');
INSERT INTO cd_cep_br VALUES ('57.050-680', '54       ', 'R AUGUSTO DIAS CARDOSO', 'G LOURDES                     ');
INSERT INTO cd_cep_br VALUES ('57.082-350', '54       ', 'R AUGUSTO QUINTELA CAVALCANTE', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.040-560', '54       ', 'R AUGUSTO TENORIO', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.014-030', '54       ', 'TV AUREA BELTRAO DE CASTRO', 'P GROSSA                      ');
INSERT INTO cd_cep_br VALUES ('57.040-470', '54       ', 'R AURELIANO DUARTE', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.036-430', '54       ', 'R AURELIANO TEIXEIRA DE VASCONCELOS', 'JATIUCA                       ');
INSERT INTO cd_cep_br VALUES ('57.030-740', '54       ', 'R AURELINA LIMA DA SILVA', 'POCO                          ');
INSERT INTO cd_cep_br VALUES ('57.062-450', '54       ', 'AL AURELIO BUARQUE DE HOLANDA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.050-550', '54       ', 'R AURELIO CAVALCANTE', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.015-430', '54       ', 'R AURELIO LAGES', 'P GROSSA                      ');
INSERT INTO cd_cep_br VALUES ('57.040-210', '54       ', 'R AURORA', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.040-215', '54       ', 'TV AURORA', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.072-100', '54       ', 'R AURORA LEITE PESSOA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.052-270', '54       ', 'R AZARIAS DE CARVALHO GAMA', 'G LOURDES                     ');
INSERT INTO cd_cep_br VALUES ('57.030-035', '54       ', 'TV ARAUJO BIVAR', 'PAJUCARA                      ');
INSERT INTO cd_cep_br VALUES ('57.030-040', '54       ', 'R ARAUJO GOES', 'PAJUCARA                      ');
INSERT INTO cd_cep_br VALUES ('57.070-180', '54       ', 'R AREIA, DA', 'R NOVO                        ');
INSERT INTO cd_cep_br VALUES ('57.042-190', '54       ', 'R ARENY TENORIO MAYA', 'FEITOSA                       ');
INSERT INTO cd_cep_br VALUES ('57.060-770', '54       ', 'R ARESTIDES ALVES CORDEIRO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.017-520', '54       ', 'R ARGEMIRO DE MORAIS', 'BEBEDOURO                     ');
INSERT INTO cd_cep_br VALUES ('57.045-840', '54       ', 'R SAO JORGE', 'B DURO                        ');
INSERT INTO cd_cep_br VALUES ('57.075-190', '54       ', 'R ARHUR MEYER LEITERUA 6 CJ OSMAN LOUREIRO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.075-180', '54       ', 'R ARI ALVES DE OLIVEIRA(CONJUNTO OSMAN LOUREIRO)', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.039-560', '54       ', 'R BOA VISTA', 'F PEIXOTO                     ');
INSERT INTO cd_cep_br VALUES ('57.040-050', '54       ', 'AT BOA VISTA', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.040-040', '54       ', 'R BOA VISTA', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.040-045', '54       ', 'TV BOA VISTA', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.014-280', '54       ', 'R BOA VISTA', 'P GROSSA                      ');
INSERT INTO cd_cep_br VALUES ('57.039-190', '54       ', 'R BOA VISTA', 'R DOCE                        ');
INSERT INTO cd_cep_br VALUES ('57.070-190', '54       ', 'R BOA VISTA', 'R NOVO                        ');
INSERT INTO cd_cep_br VALUES ('57.020-110', '54       ', 'R BOA VISTA', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.043-580', '54       ', 'R BOA VISTA', 'FEITOSA                       ');
INSERT INTO cd_cep_br VALUES ('57.017-160', '54       ', 'R BOA VONTADE', 'B PARTO                       ');
INSERT INTO cd_cep_br VALUES ('57.017-165', '54       ', 'TV BOA VONTADE', 'B PARTO                       ');
INSERT INTO cd_cep_br VALUES ('57.039-200', '54       ', 'R BOCA DO RIO', 'R DOCE                        ');
INSERT INTO cd_cep_br VALUES ('57.045-730', '54       ', 'R BOM CONSELHO', 'B DURO                        ');
INSERT INTO cd_cep_br VALUES ('57.045-260', '54       ', 'R BOM DESTINO', 'B DURO                        ');
INSERT INTO cd_cep_br VALUES ('57.046-445', '54       ', 'TV SAO CARLOS', 'B DURO                        ');
INSERT INTO cd_cep_br VALUES ('57.061-470', '54       ', 'R SAO CARLOS', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.300-230', '23       ', 'R DOM VITAL', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.312-520', '23       ', 'R DOMINGOS BARBOSA DA SILVA', 'AT CRUZEIRO                   ');
INSERT INTO cd_cep_br VALUES ('57.305-050', '23       ', 'R DOMINGOS EVANGELISTA', 'M TELES                       ');
INSERT INTO cd_cep_br VALUES ('57.307-770', '23       ', 'R DOMINGOS HONORIO DA SILVA', 'BX GRANDE                     ');
INSERT INTO cd_cep_br VALUES ('57.302-150', '23       ', 'R DOMINGOS LOPES', 'CANAFISTULA                   ');
INSERT INTO cd_cep_br VALUES ('57.300-530', '23       ', 'R DOMINGOS MOTA ACIOLI', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.313-620', '23       ', 'R DORACY FONSECA', 'BRASILIA                      ');
INSERT INTO cd_cep_br VALUES ('57.305-510', '23       ', 'R DORALICE FERNANDES DOS SANTOS', 'BAIXAO                        ');
INSERT INTO cd_cep_br VALUES ('57.300-400', '23       ', 'R DOUTOR PEDRO CORREIA', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.304-010', '23       ', 'R DUARTE COELHO', 'PRIMAVERA                     ');
INSERT INTO cd_cep_br VALUES ('57.301-000', '23       ', 'R DUQUE DE CAXIAS', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.302-320', '23       ', 'R DURVAL DE BRITO', 'S LUIZ                        ');
INSERT INTO cd_cep_br VALUES ('57.313-670', '23       ', 'R DURVAL PEREIRA MOCO', 'BRASILIA                      ');
INSERT INTO cd_cep_br VALUES ('57.302-250', '23       ', 'PC EDMILSON BARBOSA', 'N ESPERANCA                   ');
INSERT INTO cd_cep_br VALUES ('57.313-360', '23       ', 'PC EDMUNDO FELIX DA SILVA', 'BRASILIA                      ');
INSERT INTO cd_cep_br VALUES ('57.301-290', '23       ', 'R EDSON JOSE DE MORAIS', 'S LUIZ                        ');
INSERT INTO cd_cep_br VALUES ('57.302-370', '23       ', 'R ELISIO BARBOSA', 'S LUIZ                        ');
INSERT INTO cd_cep_br VALUES ('57.307-390', '23       ', 'AV ELISIO NUNES SILVA', 'JD ESPERANCA                  ');
INSERT INTO cd_cep_br VALUES ('57.308-030', '23       ', 'R ELIZABETH UMBELINA DA SILVA', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('57.306-390', '23       ', 'R ELOI CORREIA BERNADINO', 'ELDORADO                      ');
INSERT INTO cd_cep_br VALUES ('57.312-680', '23       ', 'AV ELVIRA BARBOSA LOPES', 'N HORIZONTE                   ');
INSERT INTO cd_cep_br VALUES ('57.308-570', '23       ', 'R ELVIRA HENRIQUE DA SILVA', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('57.306-290', '23       ', 'R ELVIRA LUCIO DE ALBUQUERQUE', 'ELDORADO                      ');
INSERT INTO cd_cep_br VALUES ('57.304-240', '23       ', 'R ENGENHEIRO CAMILO COLLIER', 'PRIMAVERA                     ');
INSERT INTO cd_cep_br VALUES ('57.300-100', '23       ', 'R ENGENHEIRO GODILHO DE CASTRO', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.307-680', '23       ', 'R ENOQUE LEITE', 'JD ESPERANCA                  ');
INSERT INTO cd_cep_br VALUES ('57.314-200', '23       ', 'R ERCILIA MARIA DE SOUZA', 'BRASILIA                      ');
INSERT INTO cd_cep_br VALUES ('57.306-380', '23       ', 'R ERNESTO FIRMINO DOS SANTOS', 'CAVACO                        ');
INSERT INTO cd_cep_br VALUES ('57.312-740', '23       ', 'R ERNESTO RODRIGUES DE SOUZA', 'S ESMERALDA                   ');
INSERT INTO cd_cep_br VALUES ('57.302-540', '23       ', 'R CICERO ANTONIO DA SILVA', 'CANAFISTULA                   ');
INSERT INTO cd_cep_br VALUES ('57.308-110', '23       ', 'R CICERO BARBOSA E SILVA', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('57.307-070', '23       ', 'R CICERO ROMAO BATISTA', 'BX GRANDE                     ');
INSERT INTO cd_cep_br VALUES ('57.312-640', '23       ', 'R CICERO ROMAO DA SILVA', 'N HORIZONTE                   ');
INSERT INTO cd_cep_br VALUES ('57.305-290', '23       ', 'PC CICERO SALES BRASIL', 'M TELES                       ');
INSERT INTO cd_cep_br VALUES ('57.313-170', '23       ', 'R CICERO TORRES', 'BRASILIA                      ');
INSERT INTO cd_cep_br VALUES ('57.303-200', '23       ', 'R CIRILO JOSE', 'B VISTA                       ');
INSERT INTO cd_cep_br VALUES ('57.305-560', '23       ', 'R IZABEL TEODORO DOS SANTOS', 'BAIXAO                        ');
INSERT INTO cd_cep_br VALUES ('57.304-470', '23       ', 'R IZAU LUCIO DA SILVA', 'PRIMAVERA                     ');
INSERT INTO cd_cep_br VALUES ('57.308-270', '23       ', 'R JACARE DOS HOMENS', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('57.312-180', '23       ', 'PC JANETE CLAIR', 'AT CRUZEIRO                   ');
INSERT INTO cd_cep_br VALUES ('57.303-540', '23       ', 'R JANUARIO ANDRE NETO', 'GUARIBAS                      ');
INSERT INTO cd_cep_br VALUES ('57.308-310', '23       ', 'AV JANY CAMELO LIMA', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('57.313-580', '23       ', 'R JAPARATINGA', 'JD TROPICAL                   ');
INSERT INTO cd_cep_br VALUES ('57.308-340', '23       ', 'R JARAMATAIA', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('57.307-110', '23       ', 'PC JASSOM LEAO BARBOSA', 'BX GRANDE                     ');
INSERT INTO cd_cep_br VALUES ('57.307-590', '23       ', 'PC JEOVA CAETANO', 'JD ESPERANCA                  ');
INSERT INTO cd_cep_br VALUES ('57.314-280', '23       ', 'R JOANA D ARC', 'ITAPOA                        ');
INSERT INTO cd_cep_br VALUES ('57.306-320', '23       ', 'R JOANA FELIX', 'CAVACO                        ');
INSERT INTO cd_cep_br VALUES ('57.313-150', '23       ', 'R JOANA LEAO DE MELO', 'BRASILIA                      ');
INSERT INTO cd_cep_br VALUES ('57.306-570', '23       ', 'R JOANA LEITE', 'CAVACO                        ');
INSERT INTO cd_cep_br VALUES ('57.310-120', '23       ', 'R JOANA PEREIRA AZEVEDO', 'CAPIATA                       ');
INSERT INTO cd_cep_br VALUES ('57.305-700', '23       ', 'R JOAO ALEXANDRE DOS SANTOS', 'P FRIO                        ');
INSERT INTO cd_cep_br VALUES ('57.307-750', '23       ', 'R JOAO ALEXANDRE DOS SANTOS', 'BX GRANDE                     ');
INSERT INTO cd_cep_br VALUES ('57.314-140', '23       ', 'R JOAO ANTONIO DA SILVA', 'ITAPOA                        ');
INSERT INTO cd_cep_br VALUES ('57.308-670', '23       ', 'R JOAO AURELIANO', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('57.310-290', '23       ', 'R JOAO BATISTA DA SILVA', 'R CRUZ                        ');
INSERT INTO cd_cep_br VALUES ('57.305-280', '23       ', 'R JOAO CAPRISTANO CORREIA', 'M TELES                       ');
INSERT INTO cd_cep_br VALUES ('57.307-210', '23       ', 'R JOAO DO BEIJO', 'BX GRANDE                     ');
INSERT INTO cd_cep_br VALUES ('57.305-020', '23       ', 'R JOAO DOCA', 'M TELES                       ');
INSERT INTO cd_cep_br VALUES ('57.302-030', '23       ', 'R JOAO DONATO NETO', 'CANAFISTULA                   ');
INSERT INTO cd_cep_br VALUES ('57.301-320', '23       ', 'R JOAO FAZIO', 'S LUIZ                        ');
INSERT INTO cd_cep_br VALUES ('57.306-400', '23       ', 'R FRANCISCA EMILIANA DE LIRA', 'CAVACO                        ');
INSERT INTO cd_cep_br VALUES ('57.314-130', '23       ', 'R FRANCISCA GOMES FARIAS', 'ITAPOA                        ');
INSERT INTO cd_cep_br VALUES ('57.307-220', '23       ', 'R FRANCISCO ALEXANDRE', 'BX GRANDE                     ');
INSERT INTO cd_cep_br VALUES ('57.304-090', '23       ', 'R FRANCISCO CAVALCANTE', 'PRIMAVERA                     ');
INSERT INTO cd_cep_br VALUES ('57.312-490', '23       ', 'R FRANCISCO CHAGAS', 'AT CRUZEIRO                   ');
INSERT INTO cd_cep_br VALUES ('57.304-140', '23       ', 'R FRANCISCO DE PAULA MAGALHAES', 'PRIMAVERA                     ');
INSERT INTO cd_cep_br VALUES ('57.302-260', '23       ', 'R FRANCISCO FIRMINO DE OLIVEIRA', 'N ESPERANCA                   ');
INSERT INTO cd_cep_br VALUES ('57.307-060', '23       ', 'R FRANCISCO OTILIO DOS SANTOS', 'BX GRANDE                     ');
INSERT INTO cd_cep_br VALUES ('57.311-280', '23       ', 'R FRANCISCO PEREIRA DE ALBUQUERQUE', 'CAITITUS                      ');
INSERT INTO cd_cep_br VALUES ('57.307-570', '23       ', 'R FRANCISCO RIBEIRO', 'JD ESPERANCA                  ');
INSERT INTO cd_cep_br VALUES ('57.303-240', '23       ', 'R FREI DAMIAO DE BOZZANO', 'B VISTA                       ');
INSERT INTO cd_cep_br VALUES ('57.304-020', '23       ', 'R FREI HENRIQUE DE COIMBRA', 'PRIMAVERA                     ');
INSERT INTO cd_cep_br VALUES ('57.300-440', '23       ', 'PC GABINO BESOURO', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.307-030', '23       ', 'R GASPAR RIBEIRO WERCELONE', 'BX GRANDE                     ');
INSERT INTO cd_cep_br VALUES ('57.313-020', '23       ', 'R GAZETA DE ALAGOAS', 'BRASILIA                      ');
INSERT INTO cd_cep_br VALUES ('57.301-440', '23       ', 'R GENESIO RODRIGUES', 'JD TROPICAL                   ');
INSERT INTO cd_cep_br VALUES ('57.304-440', '23       ', 'PC GENUINO ANTONIO DA SILVA', 'PRIMAVERA                     ');
INSERT INTO cd_cep_br VALUES ('57.313-320', '23       ', 'R GERALDO ALEXANDRE DOS SANTOS', 'BRASILIA                      ');
INSERT INTO cd_cep_br VALUES ('57.300-090', '23       ', 'R GERALDO BARBOSA LIMA', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.307-550', '23       ', 'R GERALDO CAVALCANTE DE SOUZA', 'JD ESPERANCA                  ');
INSERT INTO cd_cep_br VALUES ('57.307-050', '23       ', 'R GERALDO DAMASCENO FERREIRA', 'BX GRANDE                     ');
INSERT INTO cd_cep_br VALUES ('57.313-640', '23       ', 'R GERONIMO ROCHA LIMA', 'JD TROPICAL                   ');
INSERT INTO cd_cep_br VALUES ('57.312-630', '23       ', 'R GERVASIO DE OLIVEIRA LIMA', 'N HORIZONTE                   ');
INSERT INTO cd_cep_br VALUES ('57.308-170', '23       ', 'PC GETULIO VARGAS', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('57.312-300', '23       ', 'R GILBERTO FELIX DE MENEZES', 'S A MELO                      ');
INSERT INTO cd_cep_br VALUES ('57.305-250', '23       ', 'PC GILVAN FERREIRA LEAO', 'M TELES                       ');
INSERT INTO cd_cep_br VALUES ('57.311-490', '23       ', 'R GIVALDO FERREIRA DA SILVA', 'CAITITUS                      ');
INSERT INTO cd_cep_br VALUES ('57.312-370', '23       ', 'R GIVANILDO VITAL SILVA', 'AT CRUZEIRO                   ');
INSERT INTO cd_cep_br VALUES ('57.306-070', '23       ', 'R GODIM RODRIGUES DE MELO', 'ELDORADO                      ');
INSERT INTO cd_cep_br VALUES ('57.301-450', '23       ', 'AV GOVERNADOR ANTONIO SIMEAO LAMENHA FILHO', 'JD TROPICAL                   ');
INSERT INTO cd_cep_br VALUES ('57.312-000', '23       ', 'R GOVERNADOR LUIZ CAVALCANTE', 'AT CRUZEIRO                   ');
INSERT INTO cd_cep_br VALUES ('57.313-400', '23       ', 'R GOVERNADOR SILVESTRE PERICLES', 'JD TROPICAL                   ');
INSERT INTO cd_cep_br VALUES ('57.305-150', '23       ', 'R GRACILIANO RAMOS', 'BAIXAO                        ');
INSERT INTO cd_cep_br VALUES ('57.300-560', '23       ', 'R GUANABARA', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.304-300', '23       ', 'R GUIGUI', 'O D CAZUZINHOS                ');
INSERT INTO cd_cep_br VALUES ('57.311-460', '23       ', 'R GUILHERME ALCIDES MOREIRA', 'CAITITUS                      ');
INSERT INTO cd_cep_br VALUES ('57.071-270', '54       ', 'PRQ DIVALDO SURUAGY', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.055-650', '54       ', 'CJ DIVALDO SURUAGY', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('69.049-210', '156      ', 'R 05 (CJ HILEIA I )', 'REDENCAO                      ');
INSERT INTO cd_cep_br VALUES ('69.049-390', '156      ', 'R 05 (CJ HILEIA II)', 'REDENCAO                      ');
INSERT INTO cd_cep_br VALUES ('69.054-260', '156      ', 'R 05 (CJ JD PRIMAVERA)', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.044-520', '156      ', 'R 05 (CJ JD VERSALLES)', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('69.036-380', '156      ', 'R 03 (CJ R XINGU)', 'COMPENSA                      ');
INSERT INTO cd_cep_br VALUES ('69.028-402', '156      ', 'R 03 (CJ SUBTEN SRG P MILITAR)', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('69.055-742', '156      ', 'R 03 (CJ TROPICAL)', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.038-750', '156      ', 'R 03 (CJ V BELA)', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('69.083-370', '156      ', 'R 03 (CJ V CAMARA)', 'ALEIXO                        ');
INSERT INTO cd_cep_br VALUES ('69.057-710', '156      ', 'R 03 (CJ V MUNICIPAL)', 'ADRIANOPOLIS                  ');
INSERT INTO cd_cep_br VALUES ('69.077-040', '156      ', 'R 03 (CJ 31 DE MARCO I)', 'JAPIIM                        ');
INSERT INTO cd_cep_br VALUES ('69.093-264', '156      ', 'R 03 (M SINAI)', 'COL S ANTONIO                 ');
INSERT INTO cd_cep_br VALUES ('69.090-570', '156      ', 'R 03 (NUCLEO 1)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.040-612', '156      ', 'R 03 (PRQ ARIPUANA)', 'D PEDRO                       ');
INSERT INTO cd_cep_br VALUES ('69.054-734', '156      ', 'R 03 (SHANGRILA IV)', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.035-793', '156      ', 'R 03 (VL MARINHO)', 'COMPENSA                      ');
INSERT INTO cd_cep_br VALUES ('69.043-180', '156      ', 'R 03 ATE 362/375', 'ALVORADA                      ');
INSERT INTO cd_cep_br VALUES ('69.086-050', '156      ', 'R 04', 'S J OPERARIO                  ');
INSERT INTO cd_cep_br VALUES ('69.040-110', '156      ', 'R 04', 'D PEDRO                       ');
INSERT INTO cd_cep_br VALUES ('69.039-723', '156      ', 'R 04', 'N ISRAEL                      ');
INSERT INTO cd_cep_br VALUES ('69.093-384', '156      ', 'R 04', 'COL S ANTONIO                 ');
INSERT INTO cd_cep_br VALUES ('69.048-382', '156      ', 'R 04', 'PAZ                           ');
INSERT INTO cd_cep_br VALUES ('69.028-327', '156      ', 'R 04', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('69.028-342', '156      ', 'TV 04', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('69.038-274', '156      ', 'R 04', 'L VALE                        ');
INSERT INTO cd_cep_br VALUES ('69.042-020', '156      ', 'R 04- DE 421/422 AO FIM', 'ALVORADA                      ');
INSERT INTO cd_cep_br VALUES ('69.038-310', '156      ', 'R 04 (CJ A MONTENEGRO)', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('69.054-400', '156      ', 'R 04 (CJ B BELA)', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.028-323', '156      ', 'R 04 (CJ B FLOR I)', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('69.028-332', '156      ', 'R 04 (CJ B FLOR II)', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('69.055-220', '156      ', 'R 04 (CJ C BRANCO)', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.083-470', '156      ', 'R 04 (CJ C DO ALEIXO)', 'S J OPERARIO                  ');
INSERT INTO cd_cep_br VALUES ('69.048-640', '156      ', 'R 04 (CJ CANAA)', 'ALVORADA                      ');
INSERT INTO cd_cep_br VALUES ('69.086-430', '156      ', 'R 04 (CJ CASTANHEIRA)', 'S J OPERARIO                  ');
INSERT INTO cd_cep_br VALUES ('69.068-320', '156      ', 'R 04 (CJ COSTA E SILVA)', 'RAIZ                          ');
INSERT INTO cd_cep_br VALUES ('69.097-771', '156      ', 'R 04 (CJ F MENDES I)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.060-230', '156      ', 'R 04 (CJ H ANGELIN)', 'ALEIXO                        ');
INSERT INTO cd_cep_br VALUES ('69.049-200', '156      ', 'R 04 (CJ HILEIA I)', 'REDENCAO                      ');
INSERT INTO cd_cep_br VALUES ('69.049-380', '156      ', 'R 04 (CJ HILEIA II)', 'REDENCAO                      ');
INSERT INTO cd_cep_br VALUES ('69.057-580', '156      ', 'R 04 (CJ I PARAIBA)', 'ADRIANOPOLIS                  ');
INSERT INTO cd_cep_br VALUES ('69.067-140', '156      ', 'R 04 (CJ JD PETROPOLIS)', 'PETROPOLIS                    ');
INSERT INTO cd_cep_br VALUES ('69.054-250', '156      ', 'R 04 (CJ JD PRIMAVERA)', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.090-560', '156      ', 'R 02 (NUCLEO 1)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.040-611', '156      ', 'R 02 (PRQ ARIPUANA)', 'D PEDRO                       ');
INSERT INTO cd_cep_br VALUES ('69.054-729', '156      ', 'R 02 (SHANGRILA IV)', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.035-792', '156      ', 'R 02 (VL MARINHO)', 'COMPENSA                      ');
INSERT INTO cd_cep_br VALUES ('69.043-120', '156      ', 'R 02 ATE 365/377', 'ALVORADA                      ');
INSERT INTO cd_cep_br VALUES ('69.086-040', '156      ', 'R 03', 'S J OPERARIO                  ');
INSERT INTO cd_cep_br VALUES ('69.040-100', '156      ', 'R 03', 'D PEDRO                       ');
INSERT INTO cd_cep_br VALUES ('69.039-722', '156      ', 'R 03', 'N ISRAEL                      ');
INSERT INTO cd_cep_br VALUES ('69.093-383', '156      ', 'R 03', 'COL S ANTONIO                 ');
INSERT INTO cd_cep_br VALUES ('69.048-381', '156      ', 'R 03', 'PAZ                           ');
INSERT INTO cd_cep_br VALUES ('69.028-326', '156      ', 'R 03', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('69.028-341', '156      ', 'TV 03', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('69.038-273', '156      ', 'R 03', 'L VALE                        ');
INSERT INTO cd_cep_br VALUES ('69.042-030', '156      ', 'R 03- DE 364/377 AO FIM', 'ALVORADA                      ');
INSERT INTO cd_cep_br VALUES ('69.038-300', '156      ', 'R 03 (CJ A MONTENEGRO)', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('69.054-391', '156      ', 'R 03 (CJ B BELA)', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.028-322', '156      ', 'R 03 (CJ B FLOR I)', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('69.028-331', '156      ', 'R 03 (CJ B FLOR II)', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('69.055-210', '156      ', 'R 03 (CJ C BRANCO)', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.083-460', '156      ', 'R 03 (CJ C DO ALEIXO)', 'S J OPERARIO                  ');
INSERT INTO cd_cep_br VALUES ('69.048-630', '156      ', 'R 03 (CJ CANAA)', 'ALVORADA                      ');
INSERT INTO cd_cep_br VALUES ('69.097-020', '156      ', 'R 03 (CJ CANARANAS)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.086-420', '156      ', 'R 03 (CJ CASTANHEIRA)', 'S J OPERARIO                  ');
INSERT INTO cd_cep_br VALUES ('69.068-310', '156      ', 'R 03 (CJ COSTA E SILVA)', 'RAIZ                          ');
INSERT INTO cd_cep_br VALUES ('69.060-220', '156      ', 'R 03 (CJ H ANGELIN)', 'ALEIXO                        ');
INSERT INTO cd_cep_br VALUES ('69.049-190', '156      ', 'R 03 (CJ HILEIA I)', 'REDENCAO                      ');
INSERT INTO cd_cep_br VALUES ('69.049-370', '156      ', 'R 03 (CJ HILEIA II)', 'REDENCAO                      ');
INSERT INTO cd_cep_br VALUES ('69.057-570', '156      ', 'R 03 (CJ I PARAIBA)', 'ADRIANOPOLIS                  ');
INSERT INTO cd_cep_br VALUES ('69.050-610', '156      ', 'R 03 (CJ JD HAIDEA I)', 'CHAPADA                       ');
INSERT INTO cd_cep_br VALUES ('69.067-130', '156      ', 'R 03 (CJ JD PETROPOLIS)', 'PETROPOLIS                    ');
INSERT INTO cd_cep_br VALUES ('69.054-240', '156      ', 'R 03 (CJ JD PRIMAVERA)', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.044-500', '156      ', 'R 03 (CJ JD VERSALLES)', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('69.093-420', '156      ', 'R 03 (CJ MANOA)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.090-370', '156      ', 'R 03 (CJ MUNDO NOVO)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.054-040', '156      ', 'R 03 (CJ N FRIBURGO)', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.095-810', '156      ', 'R 03 (CJ O FROTA I)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.028-303', '156      ', 'R 03 (CJ R MARACANA)', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('69.090-620', '156      ', 'R 03 (CJ R S PINTO I)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.093-382', '156      ', 'R 02', 'COL S ANTONIO                 ');
INSERT INTO cd_cep_br VALUES ('69.048-380', '156      ', 'R 02', 'PAZ                           ');
INSERT INTO cd_cep_br VALUES ('69.028-329', '156      ', 'TV 02', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('69.028-325', '156      ', 'R 02', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('69.038-272', '156      ', 'R 02', 'L VALE                        ');
INSERT INTO cd_cep_br VALUES ('69.042-080', '156      ', 'R 02- DE 367/378 AO FIM', 'ALVORADA                      ');
INSERT INTO cd_cep_br VALUES ('69.038-290', '156      ', 'R 02 (CJ A MONTENEGRO)', 'L VALE                        ');
INSERT INTO cd_cep_br VALUES ('69.054-380', '156      ', 'R 02 (CJ B BELA)', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.028-321', '156      ', 'R 02 (CJ B FLOR I)', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('69.028-330', '156      ', 'R 02 (CJ B FLOR II)', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('69.050-580', '156      ', 'R 02 (CJ BEVERLY HILLS)', 'CHAPADA                       ');
INSERT INTO cd_cep_br VALUES ('69.055-200', '156      ', 'R 02 (CJ C BRANCO)', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.083-450', '156      ', 'R 02 (CJ C DO ALEIXO)', 'S J OPERARIO                  ');
INSERT INTO cd_cep_br VALUES ('69.048-620', '156      ', 'R 02 (CJ CANAA)', 'ALVORADA                      ');
INSERT INTO cd_cep_br VALUES ('69.086-410', '156      ', 'R 02 (CJ CASTANHEIRA)', 'S J OPERARIO                  ');
INSERT INTO cd_cep_br VALUES ('69.068-300', '156      ', 'R 02 (CJ COSTA E SILVA)', 'RAIZ                          ');
INSERT INTO cd_cep_br VALUES ('69.097-770', '156      ', 'R 02 (CJ F MENDES I)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.060-210', '156      ', 'R 02 (CJ H ANGELIN)', 'ALEIXO                        ');
INSERT INTO cd_cep_br VALUES ('69.049-180', '156      ', 'R 02 (CJ HILEIA I)', 'REDENCAO                      ');
INSERT INTO cd_cep_br VALUES ('69.049-360', '156      ', 'R 02 (CJ HILEIA II)', 'REDENCAO                      ');
INSERT INTO cd_cep_br VALUES ('69.057-560', '156      ', 'R 02 (CJ I PARAIBA)', 'ADRIANOPOLIS                  ');
INSERT INTO cd_cep_br VALUES ('69.050-600', '156      ', 'R 02 (CJ JD HAIDEA I)', 'CHAPADA                       ');
INSERT INTO cd_cep_br VALUES ('69.067-120', '156      ', 'R 02 (CJ JD PETROPOLIS)', 'PETROPOLIS                    ');
INSERT INTO cd_cep_br VALUES ('69.054-230', '156      ', 'R 02 (CJ JD PRIMAVERA)', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.038-072', '156      ', 'BC STA LUZIA', 'L VALE                        ');
INSERT INTO cd_cep_br VALUES ('57.303-510', '23       ', 'R MANOEL PEREIRA DOS SANTOS', 'GUARIBAS                      ');
INSERT INTO cd_cep_br VALUES ('69.086-250', '156      ', 'R 24', 'S J OPERARIO                  ');
INSERT INTO cd_cep_br VALUES ('69.099-430', '156      ', 'R 24 (A MENDES)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.038-510', '156      ', 'R 24 (CJ A MONTENEGRO)', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('69.055-420', '156      ', 'R 24 (CJ C BRANCO)', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.049-580', '156      ', 'R 24 (CJ HILEIA II)', 'REDENCAO                      ');
INSERT INTO cd_cep_br VALUES ('69.044-710', '156      ', 'R 24 (CJ JD VERSALLES)', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('69.093-630', '156      ', 'R 24 (CJ MANOA)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.095-507', '156      ', 'R 24 (CJ O FROTA I)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.077-250', '156      ', 'R 24 (CJ 31 DE MARCO I)', 'JAPIIM                        ');
INSERT INTO cd_cep_br VALUES ('69.094-240', '156      ', 'R 24 (NUCLEO 3)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.098-530', '156      ', 'R 240 (NUCLEO 24)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.098-540', '156      ', 'R 241 (NUCLEO 24)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.098-550', '156      ', 'R 242 (NUCLEO 24)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.098-560', '156      ', 'R 243 (NUCLEO 24)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.033-141', '156      ', 'BC 244', 'S JORGE                       ');
INSERT INTO cd_cep_br VALUES ('69.098-570', '156      ', 'R 244 (NUCLEO 24)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.098-580', '156      ', 'R 245 (NUCLEO 24)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.098-590', '156      ', 'R 246 (NUCLEO 24)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.098-600', '156      ', 'R 247 (NUCLEO 24)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.044-680', '156      ', 'R 21 (CJ JD VERSALLES)', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('69.093-600', '156      ', 'R 21 (CJ MANOA)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.077-220', '156      ', 'R 21 (CJ 31 DE MARCO I)', 'JAPIIM                        ');
INSERT INTO cd_cep_br VALUES ('69.094-210', '156      ', 'R 21 (NUCLEO 3)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.098-400', '156      ', 'R 210 (NUCLEO 16)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.098-410', '156      ', 'R 211 (NUCLEO 16)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.098-420', '156      ', 'R 212 (NUCLEO 16)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.098-430', '156      ', 'R 213 (NUCLEO 16)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.098-440', '156      ', 'R 214 (NUCLEO 16)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.098-450', '156      ', 'R 215 (NUCLEO 16)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.098-460', '156      ', 'R 216 (NUCLEO 16)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.098-470', '156      ', 'R 217 (NUCLEO 16)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.098-480', '156      ', 'R 218 (NUCLEO 16)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.098-490', '156      ', 'R 219 (NUCLEO 16)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.086-230', '156      ', 'R 22', 'S J OPERARIO                  ');
INSERT INTO cd_cep_br VALUES ('69.099-420', '156      ', 'R 22 (A MENDES)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.038-490', '156      ', 'R 22 (CJ A MONTENEGRO)', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('69.055-400', '156      ', 'R 22 (CJ C BRANCO)', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.083-650', '156      ', 'R 22 (CJ C DO ALEIXO)', 'S J OPERARIO                  ');
INSERT INTO cd_cep_br VALUES ('69.049-560', '156      ', 'R 22 (CJ HILEIA II)', 'REDENCAO                      ');
INSERT INTO cd_cep_br VALUES ('69.044-690', '156      ', 'R 22 (CJ JD VERSALLES)', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('69.093-610', '156      ', 'R 22 (CJ MANOA)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.095-506', '156      ', 'R 22 (CJ O FROTA I)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.077-230', '156      ', 'R 22 (CJ 31 DE MARCO I)', 'JAPIIM                        ');
INSERT INTO cd_cep_br VALUES ('69.094-220', '156      ', 'R 22 (NUCLEO 3)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.086-231', '156      ', 'R 22-A', 'S J OPERARIO                  ');
INSERT INTO cd_cep_br VALUES ('69.096-650', '156      ', 'R 220 (NUCLEO 22)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.096-660', '156      ', 'R 221 (NUCLEO 22)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.096-670', '156      ', 'R 222 (NUCLEO 22)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.096-680', '156      ', 'R 223 (NUCLEO 22)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.096-690', '156      ', 'R 224 (NUCLEO 22)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.096-700', '156      ', 'R 225 (NUCLEO 21)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.096-710', '156      ', 'R 226 (NUCLEO 21)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.096-720', '156      ', 'R 227 (NUCLEO 21)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.096-730', '156      ', 'R 228 (NUCLEO 21)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.096-740', '156      ', 'R 229 (NUCLEO 21)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.086-240', '156      ', 'R 23', 'S J OPERARIO                  ');
INSERT INTO cd_cep_br VALUES ('69.099-100', '156      ', 'R 23 (A MENDES)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.098-610', '156      ', 'R 2 (A MENDES)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.099-771', '156      ', 'R 2 A (A MENDES', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.099-775', '156      ', 'R 2 B (A MENDES)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.099-772', '156      ', 'R 2 C (A MENDES)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.086-210', '156      ', 'R 20', 'S J OPERARIO                  ');
INSERT INTO cd_cep_br VALUES ('69.038-292', '156      ', 'R 20', 'L VALE                        ');
INSERT INTO cd_cep_br VALUES ('69.095-505', '156      ', 'R 20(CJ O FROTA I)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.099-410', '156      ', 'R 20 (A MENDES)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.038-470', '156      ', 'R 20 (CJ A MONTENEGRO)', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('69.055-380', '156      ', 'R 20 (CJ C BRANCO)', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.083-630', '156      ', 'R 20 (CJ C DO ALEIXO)', 'S J OPERARIO                  ');
INSERT INTO cd_cep_br VALUES ('69.068-480', '156      ', 'R 20 (CJ COSTA E SILVA)', 'RAIZ                          ');
INSERT INTO cd_cep_br VALUES ('57.045-210', '54       ', 'R SAO JOSE', 'B DURO                        ');
INSERT INTO cd_cep_br VALUES ('69.049-540', '156      ', 'R 20 (CJ HILEIA II)', 'REDENCAO                      ');
INSERT INTO cd_cep_br VALUES ('69.044-670', '156      ', 'R 20 (CJ JD VERSALLES)', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('69.093-590', '156      ', 'R 20 (CJ MANOA)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.090-540', '156      ', 'R 20 (CJ MUNDO NOVO)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.077-210', '156      ', 'R 20 (CJ 31 DE MARCO I)', 'JAPIIM                        ');
INSERT INTO cd_cep_br VALUES ('69.094-200', '156      ', 'R 20 (NUCLEO 3)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.095-163', '156      ', 'TV 20 (RIACHO DOCE)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.098-300', '156      ', 'R 200 (NUCLEO 16)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.098-310', '156      ', 'R 201 (NUCLEO 16)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.098-320', '156      ', 'R 202 (NUCLEO 16)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.098-330', '156      ', 'R 203 (NUCLEO 16)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.098-340', '156      ', 'R 204 (NUCLEO 16)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.098-350', '156      ', 'R 205 (NUCLEO 16)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.098-360', '156      ', 'R 206 (NUCLEO 16)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.098-370', '156      ', 'R 207 (NUCLEO 16)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.098-380', '156      ', 'R 208 (NUCLEO 16)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.098-390', '156      ', 'R 209 (NUCLEO 16)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.086-220', '156      ', 'R 21', 'S J OPERARIO                  ');
INSERT INTO cd_cep_br VALUES ('69.038-293', '156      ', 'R 21', 'L VALE                        ');
INSERT INTO cd_cep_br VALUES ('69.099-090', '156      ', 'R 21 (A MENDES)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.097-753', '156      ', 'R 21 (CJ A MEDEIROS)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.038-480', '156      ', 'R 21 (CJ A MONTENEGRO)', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('69.055-390', '156      ', 'R 21 (CJ C BRANCO)', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.083-640', '156      ', 'R 21 (CJ C DO ALEIXO)', 'S J OPERARIO                  ');
INSERT INTO cd_cep_br VALUES ('69.068-490', '156      ', 'R 21 (CJ COSTA E SILVA)', 'RAIZ                          ');
INSERT INTO cd_cep_br VALUES ('69.049-550', '156      ', 'R 21 (CJ HILEIA II)', 'REDENCAO                      ');
INSERT INTO cd_cep_br VALUES ('69.098-120', '156      ', 'R 181 (NUCLEO 15)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.098-130', '156      ', 'R 182 (NUCLEO 15)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.098-140', '156      ', 'R 183 (NUCLEO 15)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.098-150', '156      ', 'R 184 (NUCLEO 15)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.098-160', '156      ', 'R 185 (NUCLEO 15)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.098-170', '156      ', 'R 186 (NUCLEO 15)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('57.083-130', '54       ', 'R SUZANA LOUREIRO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('69.153-010', '161      ', 'R PARAIBA- ATE 2428/2429', 'PALMARES                      ');
INSERT INTO cd_cep_br VALUES ('69.153-350', '161      ', 'R PARAIBA- DE 2430/2431 AO FIM', 'E MOREIRA                     ');
INSERT INTO cd_cep_br VALUES ('69.152-500', '161      ', 'R PARAISO', 'D VIEIRA                      ');
INSERT INTO cd_cep_br VALUES ('57.046-440', '54       ', 'R SAO CARLOS', 'B DURO                        ');
INSERT INTO cd_cep_br VALUES ('57.042-680', '54       ', 'R SAO CRISTOVAO', 'B VISTA                       ');
INSERT INTO cd_cep_br VALUES ('57.041-275', '54       ', 'TV SAO MIGUEL', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.035-500', '54       ', 'TV SAO MIGUEL', 'JATIUCA                       ');
INSERT INTO cd_cep_br VALUES ('57.035-320', '54       ', 'R SAO MIGUEL', 'P VERDE                       ');
INSERT INTO cd_cep_br VALUES ('57.017-830', '54       ', 'R SAO MIGUEL', 'B PARTO                       ');
INSERT INTO cd_cep_br VALUES ('57.043-390', '54       ', 'R SAO PAULO', 'FEITOSA                       ');
INSERT INTO cd_cep_br VALUES ('57.043-395', '54       ', 'TV SAO PAULO', 'FEITOSA                       ');
INSERT INTO cd_cep_br VALUES ('57.061-130', '54       ', 'R SAO PAULO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.045-650', '54       ', 'R SAO PAULO', 'B DURO                        ');
INSERT INTO cd_cep_br VALUES ('57.062-720', '54       ', 'R SAO PEDRO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.040-170', '54       ', 'R SAO PEDRO', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.015-790', '54       ', 'LRG SAO PEDRO', 'P GROSSA                      ');
INSERT INTO cd_cep_br VALUES ('57.039-330', '54       ', 'R SAO PEDRO', 'R DOCE                        ');
INSERT INTO cd_cep_br VALUES ('57.011-350', '54       ', 'R SAO PEDRO', 'T BARRA                       ');
INSERT INTO cd_cep_br VALUES ('57.061-400', '54       ', 'TV SAO PEDRO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.015-810', '54       ', 'TV SAO PEDRO', 'V LAGO                        ');
INSERT INTO cd_cep_br VALUES ('57.018-650', '54       ', 'TV SAO PEDRO', 'C JAQUEIRA                    ');
INSERT INTO cd_cep_br VALUES ('57.046-750', '54       ', 'R SAO PEDRO', 'B DURO                        ');
INSERT INTO cd_cep_br VALUES ('57.085-170', '54       ', 'R SAO PEDRO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.073-550', '54       ', 'AV SAO PEDRO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.015-220', '54       ', 'R SAO ROQUE', 'P GROSSA                      ');
INSERT INTO cd_cep_br VALUES ('57.017-140', '54       ', 'R SAO SALVADOR', 'B PARTO                       ');
INSERT INTO cd_cep_br VALUES ('57.043-190', '54       ', 'R SAO SEBASTIAO', 'FEITOSA                       ');
INSERT INTO cd_cep_br VALUES ('57.040-710', '54       ', 'R SAO SEBASTIAO', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.010-460', '54       ', 'PC SAO SEBASTIAO', 'P BARRA                       ');
INSERT INTO cd_cep_br VALUES ('57.017-270', '54       ', 'R SAO SEBASTIAO', 'B PARTO                       ');
INSERT INTO cd_cep_br VALUES ('57.055-780', '54       ', 'R SAO SEBASTIAO', 'PINHEIRO                      ');
INSERT INTO cd_cep_br VALUES ('57.071-315', '54       ', 'R SAO SEBASTIAO', 'A S DUMONT                    ');
INSERT INTO cd_cep_br VALUES ('57.018-338', '54       ', 'VL SAO VICENTE', 'BEBEDOURO                     ');
INSERT INTO cd_cep_br VALUES ('57.017-280', '54       ', 'R SAO VICENTE', 'B PARTO                       ');
INSERT INTO cd_cep_br VALUES ('57.020-420', '54       ', 'PC SAO VICENTE', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.040-450', '54       ', 'R SAO VICENTE', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.040-455', '54       ', 'TV SAO VICENTE', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.022-270', '54       ', 'TV SAO VICENTE', 'JARAGUA                       ');
INSERT INTO cd_cep_br VALUES ('57.015-400', '54       ', 'R SAO VICENTE', 'V LAGO                        ');
INSERT INTO cd_cep_br VALUES ('57.052-550', '54       ', 'R SAPUCAIA', 'G LOURDES                     ');
INSERT INTO cd_cep_br VALUES ('57.031-260', '54       ', 'R SARGENTO ALBERTO MELO COSTA', 'POCO                          ');
INSERT INTO cd_cep_br VALUES ('57.081-450', '54       ', 'R SAO JORGE', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.018-190', '54       ', 'R SAO JOSE', 'BEBEDOURO                     ');
INSERT INTO cd_cep_br VALUES ('57.018-195', '54       ', 'TV SAO JOSE', 'BEBEDOURO                     ');
INSERT INTO cd_cep_br VALUES ('57.039-650', '54       ', 'R SAO JOSE', 'F PEIXOTO                     ');
INSERT INTO cd_cep_br VALUES ('57.070-120', '54       ', 'PC SAO JOSE', 'F VELHO                       ');
INSERT INTO cd_cep_br VALUES ('57.043-370', '54       ', 'R SAO JOSE', 'FEITOSA                       ');
INSERT INTO cd_cep_br VALUES ('57.040-510', '54       ', 'R SAO JOSE', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.040-515', '54       ', 'TV SAO JOSE', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.015-780', '54       ', 'R SAO JOSE', 'P GROSSA                      ');
INSERT INTO cd_cep_br VALUES ('57.014-380', '54       ', 'TV SAO JOSE', 'P GROSSA                      ');
INSERT INTO cd_cep_br VALUES ('57.055-340', '54       ', 'R SAO JOSE', 'PINHEIRO                      ');
INSERT INTO cd_cep_br VALUES ('57.015-390', '54       ', 'TV SAO JOSE', 'V LAGO                        ');
INSERT INTO cd_cep_br VALUES ('57.020-200', '54       ', 'BC SAO JOSE', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.060-360', '54       ', 'TV SAO JOSE', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.062-770', '54       ', 'R SAO JOSE', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.050-360', '54       ', 'R SAO JOSE', 'PITANGUINHA                   ');
INSERT INTO cd_cep_br VALUES ('57.043-375', '54       ', 'TV SAO JOSE', 'FEITOSA                       ');
INSERT INTO cd_cep_br VALUES ('57.043-380', '54       ', 'R SAO JUDAS TADEU', 'FEITOSA                       ');
INSERT INTO cd_cep_br VALUES ('57.011-340', '54       ', 'R SAO LUCAS', 'T BARRA                       ');
INSERT INTO cd_cep_br VALUES ('57.055-040', '54       ', 'R SAO LUIZ', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.055-045', '54       ', 'TV SAO LUIZ', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.042-140', '54       ', 'R SAO LUIZ', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.014-250', '54       ', 'R SAO LUIZ', 'P GROSSA                      ');
INSERT INTO cd_cep_br VALUES ('57.039-320', '54       ', 'R SAO LUIZ', 'R DOCE                        ');
INSERT INTO cd_cep_br VALUES ('57.070-290', '54       ', 'R SAO LUIZ', 'R NOVO                        ');
INSERT INTO cd_cep_br VALUES ('57.060-260', '54       ', 'R SAO LUIZ', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.055-015', '54       ', 'VL SAO LUIZ', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.062-760', '54       ', 'R SAO LUIZ', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.042-145', '54       ', 'TV SAO LUIZ', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.045-770', '54       ', 'R SAO LUIZ', 'B DURO                        ');
INSERT INTO cd_cep_br VALUES ('57.038-490', '54       ', 'R SAO LUIZ DO QUITUNDE', 'C ALMAS                       ');
INSERT INTO cd_cep_br VALUES ('57.040-440', '54       ', 'R SAO MALAQUIAS', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.061-445', '54       ', 'TV SAO MANOEL', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.061-440', '54       ', 'R SAO MANOEL', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.071-360', '54       ', 'R SAO MARCOS', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.043-200', '54       ', 'R SENADOR RUI PALMEIRA', 'FEITOSA                       ');
INSERT INTO cd_cep_br VALUES ('57.035-250', '54       ', 'R SENADOR RUI PALMEIRA', 'P VERDE                       ');
INSERT INTO cd_cep_br VALUES ('57.046-340', '54       ', 'CJ SENADOR RUI PALMEIRA', 'SERRARIA                      ');
INSERT INTO cd_cep_br VALUES ('57.010-480', '54       ', 'AV SENADOR RUI PALMEIRA', 'T BARRA                       ');
INSERT INTO cd_cep_br VALUES ('57.018-160', '54       ', 'PC SENADOR RUI PALMEIRA', 'BEBEDOURO                     ');
INSERT INTO cd_cep_br VALUES ('57.043-205', '54       ', 'TV SENADOR RUI PALMEIRA', 'FEITOSA                       ');
INSERT INTO cd_cep_br VALUES ('57.030-640', '54       ', 'R SENADOR TEOTONIO VILELA', 'POCO                          ');
INSERT INTO cd_cep_br VALUES ('57.084-020', '54       ', 'AV SENADOR TEOTONIO VILELA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.018-660', '54       ', 'R SENHOR DO BONFIM', 'C JAQUEIRA                    ');
INSERT INTO cd_cep_br VALUES ('57.018-665', '54       ', 'TV SENHOR DO BONFIM', 'C JAQUEIRA                    ');
INSERT INTO cd_cep_br VALUES ('57.025-608', '54       ', 'VL SENHOR DO BONFIM', 'POCO                          ');
INSERT INTO cd_cep_br VALUES ('57.071-800', '54       ', 'R SENHOR DO BONFIM', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.050-500', '54       ', 'R SERAFIM COSTA', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.050-505', '54       ', 'TV SERAFIM COSTA', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.025-320', '54       ', 'R SERAFINA DE BARROS LEITE', 'POCO                          ');
INSERT INTO cd_cep_br VALUES ('57.041-190', '54       ', 'R SERGIO ALVES DA SILVA', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.048-240', '54       ', 'AV SERGIO LUIS PESSOA BRAGA', 'SERRARIA                      ');
INSERT INTO cd_cep_br VALUES ('57.051-630', '54       ', 'PC SERGIPE', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.045-790', '54       ', 'R SERGIPE', 'O PRETO                       ');
INSERT INTO cd_cep_br VALUES ('57.048-150', '54       ', 'LOT SERRARIA', 'SERRARIA                      ');
INSERT INTO cd_cep_br VALUES ('57.020-700', '54       ', 'R SETE DE SETEMBRO', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.020-705', '54       ', 'TV SETE DE SETEMBRO', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.061-140', '54       ', 'R SETE DE SETEMBRO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.030-650', '54       ', 'R SILVA SAMPAIO', 'POCO                          ');
INSERT INTO cd_cep_br VALUES ('57.022-110', '54       ', 'R SILVERIO JORGE- ATE 399/400', 'JARAGUA                       ');
INSERT INTO cd_cep_br VALUES ('57.020-710', '54       ', 'R SILVERIO JORGE- DE 401/402 AO FIM', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.048-110', '54       ', 'R SILVIA DE GOIS OLIVEIRA', 'SERRARIA                      ');
INSERT INTO cd_cep_br VALUES ('57.051-700', '54       ', 'PC SILVIO VIANA', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.052-230', '54       ', 'R SINVAL GAMA FILHO', 'G LOURDES                     ');
INSERT INTO cd_cep_br VALUES ('57.040-460', '54       ', 'R SIQUEIRA CAMPOS', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.010-000', '54       ', 'AV SIQUEIRA CAMPOS- ATE 1029 - LADO IMPAR', 'PRADO                         ');
INSERT INTO cd_cep_br VALUES ('57.011-000', '54       ', 'AV SIQUEIRA CAMPOS- ATE 1030 - LADO PAR', 'PRADO                         ');
INSERT INTO cd_cep_br VALUES ('69.093-410', '156      ', 'R 02 (CJ MANOA)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.090-360', '156      ', 'R 02 (CJ MUNDO NOVO)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('57.040-780', '54       ', 'R DIVISORIA', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.040-290', '54       ', 'R DOUTOR JOSE FONTES LIMA', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.046-070', '54       ', 'R DOUTOR JOSE GERBASE', 'SERRARIA                      ');
INSERT INTO cd_cep_br VALUES ('57.041-410', '54       ', 'R DOUTOR JOSE JACINTO', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.015-470', '54       ', 'R DOUTOR BENON MAIA GOMES', 'P GROSSA                      ');
INSERT INTO cd_cep_br VALUES ('57.010-360', '54       ', 'PC DOUTOR CAIO AGUIAR PORTO', 'P BARRA                       ');
INSERT INTO cd_cep_br VALUES ('57.080-620', '54       ', 'R DOUTOR CAMELO JUNIOR', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.072-160', '54       ', 'R DOUTOR CARLOS BREDA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.030-480', '54       ', 'R DOUTOR CARLOS DE MIRANDA', 'POCO                          ');
INSERT INTO cd_cep_br VALUES ('57.084-410', '54       ', 'R DOUTOR CARLOS GERALDO DAMASCO SAMPAIO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.043-050', '54       ', 'R DOUTOR CARLOS GOMES DE BARROS', 'FEITOSA                       ');
INSERT INTO cd_cep_br VALUES ('57.037-150', '54       ', 'R DOUTOR CARLOS LOBO', 'JATIUCA                       ');
INSERT INTO cd_cep_br VALUES ('57.072-260', '54       ', 'AV DOUTOR CELESTINO CHAGAS DA SILVA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.072-680', '54       ', 'R DOUTOR CESAR NILSON JUNIOR CARVALHO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.051-230', '54       ', 'R DOUTOR CIRIDIAO DURVAL', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.055-690', '54       ', 'AL DOUTOR CLAUDENOR DE ALBUQUERQUE SAMPAIO', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.030-680', '54       ', 'R DOUTOR CLETO MARQUES LUZ', 'POCO                          ');
INSERT INTO cd_cep_br VALUES ('57.014-590', '54       ', 'R DOUTOR DJALMA COSTA', 'P GROSSA                      ');
INSERT INTO cd_cep_br VALUES ('57.014-595', '54       ', 'TV DOUTOR DJALMA COSTA', 'P GROSSA                      ');
INSERT INTO cd_cep_br VALUES ('57.050-060', '54       ', 'R DOUTOR DJALMA LINS BUARQUE', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.062-050', '54       ', 'AL DOUTOR DORIVAL DE LEMOS FRANCA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.063-140', '54       ', 'R DOUTOR DURVAL BRAGA(LOT CIPESA)', 'S AMELIA                      ');
INSERT INTO cd_cep_br VALUES ('57.055-510', '54       ', 'AL DOUTOR DURVAL DA ROCHA CORTEZ', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.060-620', '54       ', 'R DOUTOR EDUARDO JORGE LESSA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.070-340', '54       ', 'R DOUTOR EDVALDO CRISPIM', 'F VELHO                       ');
INSERT INTO cd_cep_br VALUES ('57.084-340', '54       ', 'R DOUTOR ERICO FONTES LIMA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.057-100', '54       ', 'R DOUTOR ERNEST GILMAN', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.083-500', '54       ', 'R DOUTOR ESTACIO DE LIMA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.061-050', '54       ', 'R DOUTOR EURICO AYRES', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.045-380', '54       ', 'R DOUTOR EVERALDO OLIVEIRA CASTRO', 'B DURO                        ');
INSERT INTO cd_cep_br VALUES ('57.031-245', '54       ', 'PC DOUTOR FABIO CALHEIROS JUNIOR', 'POCO                          ');
INSERT INTO cd_cep_br VALUES ('57.072-760', '54       ', 'AV DOUTOR FABIO WANDERLEY(CJ EUSTAQUIO GOMES DE M', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.041-400', '54       ', 'R DOUTOR FARIAS COSTA', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.073-030', '54       ', 'AV DOUTOR FERNANDO DO COUTO MALTA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.055-010', '54       ', 'R DOUTOR FLORIANO IVO', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.042-270', '54       ', 'R DOUTOR FRANCISCO GAZANEO', 'FEITOSA                       ');
INSERT INTO cd_cep_br VALUES ('57.061-220', '54       ', 'R DOUTOR GABRIEL DE FREITAS SOARES', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.018-540', '54       ', 'R DOUTOR GABRIEL DE FREITAS SOARES', 'C JAQUEIRA                    ');
INSERT INTO cd_cep_br VALUES ('57.073-430', '54       ', 'R DOUTOR GASTAO MACHADO PONTES DE MIRANDA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.037-160', '54       ', 'PC DOUTOR GENESIO MARQUES DE CARVALHO', 'JATIUCA                       ');
INSERT INTO cd_cep_br VALUES ('57.046-060', '54       ', 'R DOUTOR GEORGE ARROXELAS', 'B DURO                        ');
INSERT INTO cd_cep_br VALUES ('57.025-665', '54       ', 'TV DOUTOR GERALDO MELO DOS SANTOS', 'POCO                          ');
INSERT INTO cd_cep_br VALUES ('57.010-130', '54       ', 'R DONA ROSA DA FONSECA', 'PRADO                         ');
INSERT INTO cd_cep_br VALUES ('57.010-135', '54       ', 'TV DONA ROSA DA FONSECA', 'PRADO                         ');
INSERT INTO cd_cep_br VALUES ('57.020-750', '54       ', 'LRG DONA ROSA DA FONSECA', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.022-040', '54       ', 'R DONA ROSA FREIRE WANDERLEY', 'JARAGUA                       ');
INSERT INTO cd_cep_br VALUES ('57.061-540', '54       ', 'R DOUTOR ABELARDO GOMES CALHEIROS', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.052-240', '54       ', 'R DOUTOR ABELARDO PONTES LIMA', 'G LOURDES                     ');
INSERT INTO cd_cep_br VALUES ('57.015-010', '54       ', 'AV DOUTOR ABELARDO PONTES LIMA', 'V LAGO                        ');
INSERT INTO cd_cep_br VALUES ('57.015-015', '54       ', 'TV DOUTOR ABELARDO PONTES LIMA', 'V LAGO                        ');
INSERT INTO cd_cep_br VALUES ('57.051-210', '54       ', 'R DOUTOR ADALBERTO MARROQUIM', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.051-220', '54       ', 'R DOUTOR ADAUCTO DE PEREIRA', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.045-490', '54       ', 'R DOUTOR ADERSON ALMEIDA VASCONCELOS', 'B DURO                        ');
INSERT INTO cd_cep_br VALUES ('57.072-560', '54       ', 'R DOUTOR AGRICOLA GUERRA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.080-240', '54       ', 'R DOUTOR ALBERT BRUCE SABIM', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.070-000', '54       ', 'AV DOUTOR ALBERTO', 'F VELHO                       ');
INSERT INTO cd_cep_br VALUES ('57.050-080', '54       ', 'R DOUTOR ALBINO MAGALHAES', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.063-130', '54       ', 'R DOUTOR ALCIDES ANDRADE(LOT CIPESA)', 'S AMELIA                      ');
INSERT INTO cd_cep_br VALUES ('57.075-260', '54       ', 'AV DOUTOR ALDO CARDOSO(AV C CJ OSMAN LOUREIRO)', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.017-030', '54       ', 'R DOUTOR ALFREDO LOBO', 'B PARTO                       ');
INSERT INTO cd_cep_br VALUES ('57.050-230', '54       ', 'R DOUTOR ALFREDO OITICICA', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.084-330', '54       ', 'R DOUTOR ALOISIO DO COUTO MALTA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.045-370', '54       ', 'R DOUTOR ANDERSON ALMEIDA VASCONCELOS', 'B DURO                        ');
INSERT INTO cd_cep_br VALUES ('57.052-340', '54       ', 'R DOUTOR ANTONIO ARECIPO', 'G LOURDES                     ');
INSERT INTO cd_cep_br VALUES ('57.035-190', '54       ', 'R DOUTOR ANTONIO CANSANCAO', 'P VERDE                       ');
INSERT INTO cd_cep_br VALUES ('57.011-040', '54       ', 'R DOUTOR ANTONIO CARLOS', 'T BARRA                       ');
INSERT INTO cd_cep_br VALUES ('57.031-470', '54       ', 'R DOUTOR ANTONIO DE GOES BARBOSA', 'MANGABEIRAS                   ');
INSERT INTO cd_cep_br VALUES ('57.036-000', '54       ', 'AV DOUTOR ANTONIO GOMES DE BARROS', 'JATIUCA                       ');
INSERT INTO cd_cep_br VALUES ('57.030-170', '54       ', 'AV DOUTOR ANTONIO GOUVEIA', 'PAJUCARA                      ');
INSERT INTO cd_cep_br VALUES ('57.030-175', '54       ', 'TV DOUTOR ANTONIO GOUVEIA', 'PAJUCARA                      ');
INSERT INTO cd_cep_br VALUES ('57.083-010', '54       ', 'R DOUTOR ANTONIO MACHADO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.072-220', '54       ', 'R DOUTOR ANTONIO MARIO MAFRA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.017-590', '54       ', 'R DOUTOR ANTONIO NUNES LEITE', 'BEBEDOURO                     ');
INSERT INTO cd_cep_br VALUES ('57.030-070', '54       ', 'R DOUTOR ANTONIO PEDRO DE MENDONCA', 'PAJUCARA                      ');
INSERT INTO cd_cep_br VALUES ('57.040-090', '54       ', 'R DOUTOR JOSE JOAQUIM DE ARAUJO', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.040-095', '54       ', 'TV DOUTOR JOSE JOAQUIM DE ARAUJO', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.063-080', '54       ', 'R DOUTOR JOSE LAGES FILHO(LOT CIPESA)', 'S AMELIA                      ');
INSERT INTO cd_cep_br VALUES ('57.051-270', '54       ', 'R DOUTOR JOSE MARIA CORREIA DAS NEVES', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.051-275', '54       ', 'TV DOUTOR JOSE MARIA CORREIA DAS NEVES', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.017-600', '54       ', 'R DOUTOR JOSE MARTINS NETO', 'BEBEDOURO                     ');
INSERT INTO cd_cep_br VALUES ('57.030-690', '54       ', 'R DOUTOR JOSE MILTON CORREIA', 'POCO                          ');
INSERT INTO cd_cep_br VALUES ('57.030-695', '54       ', 'TV DOUTOR JOSE MILTON CORREIA', 'POCO                          ');
INSERT INTO cd_cep_br VALUES ('57.048-060', '54       ', 'R DOUTOR JOSE OSCAR DE MELO', 'SERRARIA                      ');
INSERT INTO cd_cep_br VALUES ('57.015-480', '54       ', 'R DOUTOR JOSE PAULINO ALBUQUERQUE SARMENTO- ATE', 'P GROSSA                      ');
INSERT INTO cd_cep_br VALUES ('57.014-310', '54       ', 'R DOUTOR JOSE PAULINO ALBUQUERQUE SARMENTO- DE 1', 'P GROSSA                      ');
INSERT INTO cd_cep_br VALUES ('57.061-670', '54       ', 'R DOUTOR JOSE PEREIRA DE LUCENA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.084-110', '54       ', 'R DOUTOR JOSE PONTES DE MORAES', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.080-640', '54       ', 'R DOUTOR JOSE REIS CALMON', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.035-260', '54       ', 'AV DOUTOR JOSE SAMPAIO LUZ', 'P VERDE                       ');
INSERT INTO cd_cep_br VALUES ('57.018-350', '54       ', 'R PREFEITO JOATAS MALTA DE ALENCAR', 'C JAQUEIRA                    ');
INSERT INTO cd_cep_br VALUES ('57.061-380', '54       ', 'R SANTO ANTONIO', 'CANAA                         ');
INSERT INTO cd_cep_br VALUES ('57.055-580', '54       ', 'R SANTO ANTONIO', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.043-170', '54       ', 'R SANTO ANTONIO', 'FEITOSA                       ');
INSERT INTO cd_cep_br VALUES ('57.043-175', '54       ', 'TV SANTO ANTONIO', 'FEITOSA                       ');
INSERT INTO cd_cep_br VALUES ('57.040-500', '54       ', 'R SANTO ANTONIO', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.040-505', '54       ', 'TV SANTO ANTONIO', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.015-460', '54       ', 'PC SANTO ANTONIO', 'P GROSSA                      ');
INSERT INTO cd_cep_br VALUES ('57.015-000', '54       ', 'R SANTO ANTONIO', 'P GROSSA                      ');
INSERT INTO cd_cep_br VALUES ('57.050-150', '54       ', 'R SANTO ANTONIO', 'PITANGUINHA                   ');
INSERT INTO cd_cep_br VALUES ('57.060-340', '54       ', 'R SANTO ANTONIO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.082-560', '54       ', 'LOT SANTA LUCIA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.071-575', '54       ', 'R SANTA LUIZA', 'A S DUMONT                    ');
INSERT INTO cd_cep_br VALUES ('57.055-740', '54       ', 'R SANTA LUZIA', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.057-270', '54       ', 'TV SANTA LUZIA', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.040-400', '54       ', 'R SANTA LUZIA', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.040-405', '54       ', 'TV SANTA LUZIA', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.060-150', '54       ', 'R SANTA LUZIA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.017-650', '54       ', 'TV SANTA LUZIA', 'BEBEDOURO                     ');
INSERT INTO cd_cep_br VALUES ('57.045-835', '54       ', 'TV SANTA LUZIA', 'B DURO                        ');
INSERT INTO cd_cep_br VALUES ('57.045-830', '54       ', 'R SANTA LUZIA', 'B DURO                        ');
INSERT INTO cd_cep_br VALUES ('57.073-500', '54       ', 'AV SANTA LUZIA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.042-830', '54       ', 'LOT SANTA MADALENA', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.043-160', '54       ', 'R SANTA MARGARIDA', 'FEITOSA                       ');
INSERT INTO cd_cep_br VALUES ('57.043-165', '54       ', 'TV SANTA MARGARIDA', 'FEITOSA                       ');
INSERT INTO cd_cep_br VALUES ('57.040-410', '54       ', 'R SANTA MARGARIDA', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.014-130', '54       ', 'R SANTA MARGARIDA', 'P GROSSA                      ');
INSERT INTO cd_cep_br VALUES ('57.014-135', '54       ', 'TV SANTA MARGARIDA', 'P GROSSA                      ');
INSERT INTO cd_cep_br VALUES ('57.018-370', '54       ', 'R SANTA MARIA', 'C JAQUEIRA                    ');
INSERT INTO cd_cep_br VALUES ('57.015-170', '54       ', 'R SANTA MARIA', 'P GROSSA                      ');
INSERT INTO cd_cep_br VALUES ('57.015-175', '54       ', 'TV SANTA MARIA', 'P GROSSA                      ');
INSERT INTO cd_cep_br VALUES ('57.039-300', '54       ', 'R SANTA MARIA', 'R DOCE                        ');
INSERT INTO cd_cep_br VALUES ('57.018-375', '54       ', 'TV SANTA MARIA', 'C JAQUEIRA                    ');
INSERT INTO cd_cep_br VALUES ('57.061-490', '54       ', 'R SANTA MARIA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.015-005', '54       ', 'VL SANTA MARIA', 'P GROSSA                      ');
INSERT INTO cd_cep_br VALUES ('57.071-490', '54       ', 'CJ SANTA MARIA', 'A S DUMONT                    ');
INSERT INTO cd_cep_br VALUES ('57.071-675', '54       ', 'TV SANTA MARIA', 'A S DUMONT                    ');
INSERT INTO cd_cep_br VALUES ('57.045-170', '54       ', 'R SANTA MARIA MADALENA', 'B DURO                        ');
INSERT INTO cd_cep_br VALUES ('57.062-790', '54       ', 'R SANTA MARTA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.030-420', '54       ', 'R SANTA NAZARE', 'P TERRA                       ');
INSERT INTO cd_cep_br VALUES ('57.030-425', '54       ', 'TV SANTA NAZARE', 'P TERRA                       ');
INSERT INTO cd_cep_br VALUES ('57.030-430', '54       ', 'R SANTA QUITERIA', 'P TERRA                       ');
INSERT INTO cd_cep_br VALUES ('57.041-760', '54       ', 'R SAO MARCOS', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.040-715', '54       ', 'LD SAO DOMINGOS', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.015-200', '54       ', 'R SAO FELIX', 'V LAGO                        ');
INSERT INTO cd_cep_br VALUES ('57.015-205', '54       ', 'TV SAO FELIX', 'V LAGO                        ');
INSERT INTO cd_cep_br VALUES ('57.061-480', '54       ', 'R SAO FLORISVAL', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.038-170', '54       ', 'R SAO FRANCISCO', 'C ALMAS                       ');
INSERT INTO cd_cep_br VALUES ('57.017-130', '54       ', 'R SAO FRANCISCO', 'B PARTO                       ');
INSERT INTO cd_cep_br VALUES ('57.061-390', '54       ', 'R SAO FRANCISCO', 'CANAA                         ');
INSERT INTO cd_cep_br VALUES ('57.045-640', '54       ', 'R SAO FRANCISCO', 'O PRETO                       ');
INSERT INTO cd_cep_br VALUES ('57.011-190', '54       ', 'R SAO FRANCISCO', 'PRADO                         ');
INSERT INTO cd_cep_br VALUES ('57.015-380', '54       ', 'R SAO FRANCISCO', 'V LAGO                        ');
INSERT INTO cd_cep_br VALUES ('57.015-385', '54       ', 'TV SAO FRANCISCO', 'V LAGO                        ');
INSERT INTO cd_cep_br VALUES ('57.018-180', '54       ', 'TV SAO FRANCISCO', 'C JAQUEIRA                    ');
INSERT INTO cd_cep_br VALUES ('57.055-770', '54       ', 'AL SAO FRANCISCO', 'PINHEIRO                      ');
INSERT INTO cd_cep_br VALUES ('57.071-670', '54       ', 'R SAO FRANCISCO', 'A S DUMONT                    ');
INSERT INTO cd_cep_br VALUES ('57.017-815', '54       ', 'TV SAO FRANCISCO', 'B PARTO                       ');
INSERT INTO cd_cep_br VALUES ('57.035-400', '54       ', 'R SAO FRANCISCO DE ASSIS', 'JATIUCA                       ');
INSERT INTO cd_cep_br VALUES ('57.045-690', '54       ', 'R SAO FRANCISCO DE ASSIS', 'B DURO                        ');
INSERT INTO cd_cep_br VALUES ('57.040-420', '54       ', 'R SAO FRANCISCO DE ASSIS', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.018-410', '54       ', 'R SAO FRANCISCO DE ASSIS', 'C JAQUEIRA                    ');
INSERT INTO cd_cep_br VALUES ('57.060-190', '54       ', 'R SAO GERALDO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.063-020', '54       ', 'LOT SAO GERALDO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.018-420', '54       ', 'R SAO GONCALO', 'C JAQUEIRA                    ');
INSERT INTO cd_cep_br VALUES ('57.018-620', '54       ', 'R SAO JOAO', 'C JAQUEIRA                    ');
INSERT INTO cd_cep_br VALUES ('57.018-625', '54       ', 'TV SAO JOAO', 'C JAQUEIRA                    ');
INSERT INTO cd_cep_br VALUES ('57.017-260', '54       ', 'R SAO JOAO', 'B PARTO                       ');
INSERT INTO cd_cep_br VALUES ('57.043-180', '54       ', 'R SAO JOAO', 'FEITOSA                       ');
INSERT INTO cd_cep_br VALUES ('57.043-185', '54       ', 'TV SAO JOAO', 'FEITOSA                       ');
INSERT INTO cd_cep_br VALUES ('57.040-160', '54       ', 'R SAO JOAO', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.060-200', '54       ', 'R SAO JOAO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.015-210', '54       ', 'R SAO JOAO', 'V LAGO                        ');
INSERT INTO cd_cep_br VALUES ('57.015-215', '54       ', 'TV SAO JOAO', 'V LAGO                        ');
INSERT INTO cd_cep_br VALUES ('57.017-490', '54       ', 'R SAO JOAO', 'BEBEDOURO                     ');
INSERT INTO cd_cep_br VALUES ('57.017-265', '54       ', 'TV SAO JOAO', 'B PARTO                       ');
INSERT INTO cd_cep_br VALUES ('57.045-780', '54       ', 'R SAO JOAO', 'B DURO                        ');
INSERT INTO cd_cep_br VALUES ('57.040-430', '54       ', 'R SAO JORGE', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.040-435', '54       ', 'TV SAO JORGE', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.055-490', '54       ', 'R SAO JORGE', 'PINHEIRO                      ');
INSERT INTO cd_cep_br VALUES ('57.045-200', '54       ', 'SIT SAO JORGE', 'B DURO                        ');
INSERT INTO cd_cep_br VALUES ('57.060-350', '54       ', 'TV SANTO ANTONIO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.017-240', '54       ', 'R SANTO ANTONIO', 'B PARTO                       ');
INSERT INTO cd_cep_br VALUES ('57.071-500', '54       ', 'CJ SANTO ANTONIO', 'A S DUMONT                    ');
INSERT INTO cd_cep_br VALUES ('57.060-730', '54       ', 'LOT SANTO ANTONIO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.030-730', '54       ', 'CJ SANTO EDUARDO', 'POCO                          ');
INSERT INTO cd_cep_br VALUES ('57.035-040', '54       ', 'R SANTO INACIO DE LOYOLA', 'P VERDE                       ');
INSERT INTO cd_cep_br VALUES ('57.014-240', '54       ', 'R SANTOS DUMONT', 'P GROSSA                      ');
INSERT INTO cd_cep_br VALUES ('57.045-330', '54       ', 'R SANTOS DUMONT', 'B DURO                        ');
INSERT INTO cd_cep_br VALUES ('57.071-640', '54       ', 'R SANTOS DUMONT', 'A S DUMONT                    ');
INSERT INTO cd_cep_br VALUES ('57.071-820', '54       ', 'LOT SANTOS DUMONT', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.071-645', '54       ', 'TV SANTOS DUMONT', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.071-665', '54       ', 'TV SANTOS DUMONT', 'A S DUMONT                    ');
INSERT INTO cd_cep_br VALUES ('57.030-630', '54       ', 'R SANTOS FERRAZ', 'POCO                          ');
INSERT INTO cd_cep_br VALUES ('57.020-290', '54       ', 'R SANTOS PACHECO', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.018-610', '54       ', 'R SAO BENEDITO', 'C JAQUEIRA                    ');
INSERT INTO cd_cep_br VALUES ('57.055-600', '54       ', 'AL SAO BENEDITO', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.042-130', '54       ', 'R SAO BENEDITO', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.042-135', '54       ', 'TV SAO BENEDITO', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.055-590', '54       ', 'R SAO BENEDITO', 'PINHEIRO                      ');
INSERT INTO cd_cep_br VALUES ('57.039-310', '54       ', 'R SAO BENEDITO', 'R DOCE                        ');
INSERT INTO cd_cep_br VALUES ('57.015-190', '54       ', 'TV SAO BENEDITO', 'V LAGO                        ');
INSERT INTO cd_cep_br VALUES ('57.055-860', '54       ', 'TV SAO BENEDITO', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.070-380', '54       ', 'R SAO BENEDITO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.071-855', '54       ', 'R SAO BENEDITO', 'A S DUMONT                    ');
INSERT INTO cd_cep_br VALUES ('57.040-150', '54       ', 'R SAO BENTO', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.040-155', '54       ', 'TV SAO BENTO', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.060-610', '54       ', 'R SAO BENTO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.015-370', '54       ', 'R SAO BENTO', 'V LAGO                        ');
INSERT INTO cd_cep_br VALUES ('57.606-008', '40       ', 'R JOSE PEREIRA', 'EUCALIPTOS                    ');
INSERT INTO cd_cep_br VALUES ('69.060-240', '156      ', 'R 05 (CJ H ANGELIN)', 'ALEIXO                        ');
INSERT INTO cd_cep_br VALUES ('69.152-510', '161      ', 'R PARANANEMA', 'D VIEIRA                      ');
INSERT INTO cd_cep_br VALUES ('57.308-580', '23       ', 'R HELENO CASTRO ALVES', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('57.314-270', '23       ', 'R ERONDINO TAVARES DA SILVA', 'AT CRUZEIRO                   ');
INSERT INTO cd_cep_br VALUES ('57.305-660', '23       ', 'R ERONILDES NASCIMENTO DOS SANTOS', 'M TELES                       ');
INSERT INTO cd_cep_br VALUES ('57.303-650', '23       ', 'R ESPEDITO DANTAS', 'V CAMPOS                      ');
INSERT INTO cd_cep_br VALUES ('57.300-060', '23       ', 'R ESPERIDIAO RODRIGUES', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.304-330', '23       ', 'R ESTACAO, DA', 'PRIMAVERA                     ');
INSERT INTO cd_cep_br VALUES ('57.311-400', '23       ', 'R ESTELITA DE MACEDO', 'CAITITUS                      ');
INSERT INTO cd_cep_br VALUES ('57.303-260', '23       ', 'R ESTUDANTE DIONE NUNES FERREIRA', 'B VISTA                       ');
INSERT INTO cd_cep_br VALUES ('57.303-360', '23       ', 'R ESTUDANTE GIVANILDO BARBOSA LOPES', 'V CAMPOS                      ');
INSERT INTO cd_cep_br VALUES ('57.304-190', '23       ', 'R ESTUDANTE JOSE ACACIO', 'PRIMAVERA                     ');
INSERT INTO cd_cep_br VALUES ('57.302-490', '23       ', 'R ESTUDANTE JOSE ACACIO DE SANTANA', 'N ESPERANCA                   ');
INSERT INTO cd_cep_br VALUES ('57.308-440', '23       ', 'R JOSE ELEOTERIO SOBRINHO', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('57.304-630', '23       ', 'R JOSE ELVIO HIGINO DA SILVA', 'CACIMBAS                      ');
INSERT INTO cd_cep_br VALUES ('57.307-000', '23       ', 'AV JOSE EMIDIO DE LIMA', 'JD ESPERANCA                  ');
INSERT INTO cd_cep_br VALUES ('57.306-350', '23       ', 'R JOSE ESEQUIEL SANTOS', 'CAVACO                        ');
INSERT INTO cd_cep_br VALUES ('57.314-060', '23       ', 'R JOSE F. SANTOS', 'ITAPOA                        ');
INSERT INTO cd_cep_br VALUES ('57.302-010', '23       ', 'R JOSE FERNANDES LOPES', 'CANAFISTULA                   ');
INSERT INTO cd_cep_br VALUES ('13.015-010', '4802     ', 'R CORONEL RODOVALHO', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.313-260', '23       ', 'R JOSE FERREIRA BARBOSA', 'BRASILIA                      ');
INSERT INTO cd_cep_br VALUES ('57.314-300', '23       ', 'R JOSE FERREIRA DA SILVA', 'ITAPOA                        ');
INSERT INTO cd_cep_br VALUES ('57.606-006', '40       ', 'R DIREITA', 'EUCALIPTOS                    ');
INSERT INTO cd_cep_br VALUES ('57.311-240', '23       ', 'R JOSE FRANCELINO DE ALBUQUERQUE', 'CAITITUS                      ');
INSERT INTO cd_cep_br VALUES ('57.304-610', '23       ', 'R JOSE FRANCISCO OLIVEIRA', 'CACIMBAS                      ');
INSERT INTO cd_cep_br VALUES ('57.307-540', '23       ', 'R JOSE FRANCISCO VIANA', 'JD ESPERANCA                  ');
INSERT INTO cd_cep_br VALUES ('57.307-580', '23       ', 'R JOSE GEREMIAS DA SILVA', 'JD ESPERANCA                  ');
INSERT INTO cd_cep_br VALUES ('57.300-120', '23       ', 'R JOSE GOMES DA SILVA', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.304-390', '23       ', 'R JOSE HONORATO', 'PRIMAVERA                     ');
INSERT INTO cd_cep_br VALUES ('57.307-170', '23       ', 'R JOSE HONORIO', 'BX GRANDE                     ');
INSERT INTO cd_cep_br VALUES ('57.307-310', '23       ', 'PC JOSE ISIANO DE LIMA', 'JD ESPERANCA                  ');
INSERT INTO cd_cep_br VALUES ('57.302-550', '23       ', 'R JOSE JAIME ALVES DOS SANTOS', 'CANAFISTULA                   ');
INSERT INTO cd_cep_br VALUES ('57.313-420', '23       ', 'R JOSE LAELSON DE MELO', 'JD TROPICAL                   ');
INSERT INTO cd_cep_br VALUES ('57.303-500', '23       ', 'R JOSE LEAO DE OLIVEIRA', 'GUARIBAS                      ');
INSERT INTO cd_cep_br VALUES ('57.310-400', '23       ', 'R JOSE LEITE BEZERRA', 'R CRUZ                        ');
INSERT INTO cd_cep_br VALUES ('57.303-330', '23       ', 'R JOSE LIMA MOURA', 'CANAFISTULA                   ');
INSERT INTO cd_cep_br VALUES ('57.302-090', '23       ', 'R JOSE LINS LOPES DA SILVA', 'CANAFISTULA                   ');
INSERT INTO cd_cep_br VALUES ('57.310-270', '23       ', 'R JOAO FERREIRA DE ALBUQUERQUE', 'R CRUZ                        ');
INSERT INTO cd_cep_br VALUES ('57.314-310', '23       ', 'R JOAO FRANCISCO DE ALMEIDA', 'ITAPOA                        ');
INSERT INTO cd_cep_br VALUES ('57.306-730', '23       ', 'R JOAO FRANCISCO DE SOUZA', 'CAVACO                        ');
INSERT INTO cd_cep_br VALUES ('57.314-070', '23       ', 'R JOAO FRANCISCO NASCIMENTO', 'ITAPOA                        ');
INSERT INTO cd_cep_br VALUES ('57.305-650', '23       ', 'R JOAO INGRACO DA SILVA', 'M TELES                       ');
INSERT INTO cd_cep_br VALUES ('57.304-760', '23       ', 'R JOAO JONAS RIOS', 'CACIMBAS                      ');
INSERT INTO cd_cep_br VALUES ('57.303-380', '23       ', 'R JOAO JORGE', 'V CAMPOS                      ');
INSERT INTO cd_cep_br VALUES ('57.304-310', '23       ', 'LRG JOAO JOSE DA SILVA', 'O D CAZUZINHOS                ');
INSERT INTO cd_cep_br VALUES ('57.310-050', '23       ', 'R JOAO MEDEIROS LIMA', 'BRASILIANA                    ');
INSERT INTO cd_cep_br VALUES ('57.314-110', '23       ', 'R JOAO NUNES BARBOSA', 'ITAPOA                        ');
INSERT INTO cd_cep_br VALUES ('57.312-320', '23       ', 'R JOAO PAULO II', 'AT CRUZEIRO                   ');
INSERT INTO cd_cep_br VALUES ('57.304-450', '23       ', 'PC JOAO PEDRO DE ARAGAO', 'PRIMAVERA                     ');
INSERT INTO cd_cep_br VALUES ('57.300-300', '23       ', 'R JOAO RIBEIRO LIMA', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.302-120', '23       ', 'R JOAO RODRIGUES BARROS', 'CANAFISTULA                   ');
INSERT INTO cd_cep_br VALUES ('57.301-410', '23       ', 'R JOAO SOARES DA SILVA', 'JD TROPICAL                   ');
INSERT INTO cd_cep_br VALUES ('57.307-690', '23       ', 'R JOAQUIM BEZERRA PEREIRA', 'JD ESPERANCA                  ');
INSERT INTO cd_cep_br VALUES ('57.308-300', '23       ', 'R JOAQUIM GOMES', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('57.307-380', '23       ', 'R JOAQUIM MOREIRA DA COSTA', 'JD ESPERANCA                  ');
INSERT INTO cd_cep_br VALUES ('57.303-420', '23       ', 'R JOAQUIM PEIXOTO DA SILVA', 'GUARIBAS                      ');
INSERT INTO cd_cep_br VALUES ('57.312-270', '23       ', 'R JOAQUIM PEREIRA GOMES', 'S A MELO                      ');
INSERT INTO cd_cep_br VALUES ('57.306-650', '23       ', 'R JOEL LINDOLFO DE OLIVEIRA', 'CAVACO                        ');
INSERT INTO cd_cep_br VALUES ('57.310-140', '23       ', 'R JORGE DE MACENA', 'CAPIATA                       ');
INSERT INTO cd_cep_br VALUES ('57.302-330', '23       ', 'PC JORNALISTA FRANCISCO GUILHERME TOBIAS GRANJA', 'N ESPERANCA                   ');
INSERT INTO cd_cep_br VALUES ('57.300-520', '23       ', 'R JORNALISTA JOSE OLAVO BISPO', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.313-290', '23       ', 'R JOSE AFONSO MARANHAO', 'BRASILIA                      ');
INSERT INTO cd_cep_br VALUES ('57.305-400', '23       ', 'R JOSE ALEXANDRE', 'BAIXAO                        ');
INSERT INTO cd_cep_br VALUES ('57.311-260', '23       ', 'R JOSE ANTONIO DE ALBUQUERQUE', 'CAITITUS                      ');
INSERT INTO cd_cep_br VALUES ('57.307-420', '23       ', 'R JOSE ANTONIO DOS SANTOS', 'JD ESPERANCA                  ');
INSERT INTO cd_cep_br VALUES ('57.312-550', '23       ', 'R JOSE ARANDA VALERIANO', 'N HORIZONTE                   ');
INSERT INTO cd_cep_br VALUES ('57.312-260', '23       ', 'R JOSE ARISTIDES DA SILVA', 'S A MELO                      ');
INSERT INTO cd_cep_br VALUES ('57.312-110', '23       ', 'R JOSE AUGUSTO PEREIRA', 'S ESMERALDA                   ');
INSERT INTO cd_cep_br VALUES ('57.302-350', '23       ', 'R JOSE AUGUSTO VITAL', 'N ESPERANCA                   ');
INSERT INTO cd_cep_br VALUES ('57.303-660', '23       ', 'R JOSE AURELIANO BARBOSA', 'B VISTA                       ');
INSERT INTO cd_cep_br VALUES ('57.311-220', '23       ', 'R JOSE AVELINO NETO', 'CAITITUS                      ');
INSERT INTO cd_cep_br VALUES ('57.302-500', '23       ', 'R JOSE BARBOSA DE MELO', 'CANAFISTULA                   ');
INSERT INTO cd_cep_br VALUES ('57.304-120', '23       ', 'R JOSE BARBOSA LEAO', 'PRIMAVERA                     ');
INSERT INTO cd_cep_br VALUES ('57.302-380', '23       ', 'R JOSE BARROS MELO', 'S LUIZ                        ');
INSERT INTO cd_cep_br VALUES ('57.303-040', '23       ', 'R JOSE BASTOS FILHO', 'S LUIZ                        ');
INSERT INTO cd_cep_br VALUES ('57.302-230', '23       ', 'PC HIGINO VITAL', 'CANAFISTULA                   ');
INSERT INTO cd_cep_br VALUES ('57.305-530', '23       ', 'R HILDA MATEUS DE ABREU', 'BAIXAO                        ');
INSERT INTO cd_cep_br VALUES ('57.306-540', '23       ', 'R HONORIO NUNES', 'CAVACO                        ');
INSERT INTO cd_cep_br VALUES ('57.306-230', '23       ', 'R HORACIO ALEXANDRE DOS SANTOS', 'ELDORADO                      ');
INSERT INTO cd_cep_br VALUES ('57.308-350', '23       ', 'AV IBATEGUARA', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('57.305-110', '23       ', 'R IGACI', 'M TELES                       ');
INSERT INTO cd_cep_br VALUES ('57.308-220', '23       ', 'R IGREJA NOVA', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('57.305-090', '23       ', 'R IPIRANGA', 'M TELES                       ');
INSERT INTO cd_cep_br VALUES ('57.304-550', '23       ', 'R IRINEU VALERIANO MAGALHAES', 'CACIMBAS                      ');
INSERT INTO cd_cep_br VALUES ('57.307-530', '23       ', 'R ISABEL DE OLIVEIRA LIMA', 'JD ESPERANCA                  ');
INSERT INTO cd_cep_br VALUES ('57.311-010', '23       ', 'R ISAIAS FERREIRA', 'AT CRUZEIRO                   ');
INSERT INTO cd_cep_br VALUES ('57.312-090', '23       ', 'R ISMAEL MAXIMIANO DA SILVA', 'S ESMERALDA                   ');
INSERT INTO cd_cep_br VALUES ('57.307-470', '23       ', 'PC IVONE DE OLIVEIRA', 'JD ESPERANCA                  ');
INSERT INTO cd_cep_br VALUES ('57.312-130', '23       ', 'R LAURO MACEDO', 'S ESMERALDA                   ');
INSERT INTO cd_cep_br VALUES ('57.313-030', '23       ', 'R LEITE IRMAO', 'BRASILIA                      ');
INSERT INTO cd_cep_br VALUES ('57.304-520', '23       ', 'R LEITE NETO', 'CACIMBAS                      ');
INSERT INTO cd_cep_br VALUES ('57.301-030', '23       ', 'R LEOCADIO PINHEIRO', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.303-230', '23       ', 'R LEONCIO SALU', 'B VISTA                       ');
INSERT INTO cd_cep_br VALUES ('57.307-120', '23       ', 'R LEONIDIO CORREIA', 'BX GRANDE                     ');
INSERT INTO cd_cep_br VALUES ('57.312-230', '23       ', 'R LIBERDADE, DA', 'S ESMERALDA                   ');
INSERT INTO cd_cep_br VALUES ('57.312-730', '23       ', 'R LIGIA FERREIRA SILVA', 'S A MELO                      ');
INSERT INTO cd_cep_br VALUES ('57.307-230', '23       ', 'R LINDORA ARAUJO', 'BX GRANDE                     ');
INSERT INTO cd_cep_br VALUES ('57.300-150', '23       ', 'R LINDUARTE DE OLIVEIRA BARROS', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.307-240', '23       ', 'R LINO BARBOSA', 'JD ESPERANCA                  ');
INSERT INTO cd_cep_br VALUES ('57.304-580', '23       ', 'R LINO DE PAULA MAGALHAES', 'CACIMBAS                      ');
INSERT INTO cd_cep_br VALUES ('57.310-320', '23       ', 'R LINO ROBERTO', 'R CRUZ                        ');
INSERT INTO cd_cep_br VALUES ('57.304-340', '23       ', 'R LINO RODRIGUES', 'PRIMAVERA                     ');
INSERT INTO cd_cep_br VALUES ('57.313-610', '23       ', 'PC LIONS', 'AT CRUZEIRO                   ');
INSERT INTO cd_cep_br VALUES ('57.072-640', '54       ', 'R DOUTOR JOSE TEIXEIRA NETO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.603-020', '40       ', 'R JOSE SAMPAIO', 'S CRISTOVAO                   ');
INSERT INTO cd_cep_br VALUES ('57.603-260', '40       ', 'R JOSE SAMPAIO (LOT JUCA SAMPAIO)', 'J SAMPAIO                     ');
INSERT INTO cd_cep_br VALUES ('57.601-260', '40       ', 'R JOSE TAVARES ROCHA', 'S CRISTOVAO                   ');
INSERT INTO cd_cep_br VALUES ('57.602-120', '40       ', 'R JOSE TOBIAS DA COSTA FILHO', 'PARAISO                       ');
INSERT INTO cd_cep_br VALUES ('57.603-060', '40       ', 'R JOTA CANUTO', 'S CRISTOVAO                   ');
INSERT INTO cd_cep_br VALUES ('57.601-020', '40       ', 'R JULIAO PAULO SILVA', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.601-180', '40       ', 'PC KENNEDY', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.600-220', '40       ', 'R LAURO DE ALMEIDA', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.605-050', '40       ', 'R LEOBINO MOTA', 'S FRANCISCO                   ');
INSERT INTO cd_cep_br VALUES ('57.600-280', '40       ', 'R LEOPOLDO DUARTE', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.607-340', '40       ', 'R LUIZ AMORIM', 'S CRISTOVAO                   ');
INSERT INTO cd_cep_br VALUES ('57.601-230', '40       ', 'R LUIZ MOTA DOS SANTOS', 'S CRISTOVAO                   ');
INSERT INTO cd_cep_br VALUES ('57.600-200', '40       ', 'R LUIZ PINTO DE ANDRADE', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.601-250', '40       ', 'R LUIZ SILVEIRA', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.607-200', '40       ', 'R MAJOR AZARIAS', 'S CRISTOVAO                   ');
INSERT INTO cd_cep_br VALUES ('57.600-050', '40       ', 'R MAJOR CICERO DE GOIS MONTEIRO', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.603-140', '40       ', 'R MANOEL AFONSO DE MELO', 'S CRISTOVAO                   ');
INSERT INTO cd_cep_br VALUES ('57.603-120', '40       ', 'R MANOEL ALVES BARBOSA', 'S CRISTOVAO                   ');
INSERT INTO cd_cep_br VALUES ('57.603-170', '40       ', 'R MANOEL ALVES CARDOSO', 'S CRISTOVAO                   ');
INSERT INTO cd_cep_br VALUES ('57.601-160', '40       ', 'R MANOEL AUGUSTO DOS SANTOS', 'S CRISTOVAO                   ');
INSERT INTO cd_cep_br VALUES ('57.607-295', '40       ', 'TV FRANCISCO FERREIRA BARBOSA', 'S CRISTOVAO                   ');
INSERT INTO cd_cep_br VALUES ('57.601-430', '40       ', 'AV FRANCISCO GOMES', 'P FORA                        ');
INSERT INTO cd_cep_br VALUES ('57.600-620', '40       ', 'R FRANCISCO MANOEL PINTO', 'VL NOVA                       ');
INSERT INTO cd_cep_br VALUES ('57.602-230', '40       ', 'R FRANCISCO MOURA', 'S FRANCISCO                   ');
INSERT INTO cd_cep_br VALUES ('57.602-360', '40       ', 'R FRANCISCO TENORIO CAVALCANTERUA PROJETADA LOT', 'S FRANCISCO                   ');
INSERT INTO cd_cep_br VALUES ('57.601-400', '40       ', 'R FREDERICO OSANA', 'VL JOAO XXIII                 ');
INSERT INTO cd_cep_br VALUES ('57.605-080', '40       ', 'R FREDOVINO MAIA', 'S FRANCISCO                   ');
INSERT INTO cd_cep_br VALUES ('57.600-210', '40       ', 'R FREI DOMINGOS', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.600-460', '40       ', 'R GABINO BESOURO', 'T CAVALCANTE                  ');
INSERT INTO cd_cep_br VALUES ('57.602-270', '40       ', 'R GENESIO MOREIRA', 'S FRANCISCO                   ');
INSERT INTO cd_cep_br VALUES ('57.603-010', '40       ', 'R GEORGE SAMPAIO', 'S CRISTOVAO                   ');
INSERT INTO cd_cep_br VALUES ('57.603-250', '40       ', 'R GEORGE SAMPAIO (LOT JUCA SAMPAIO)', 'J SAMPAIO                     ');
INSERT INTO cd_cep_br VALUES ('57.601-580', '40       ', 'PC GERALDO REBEIRO LIMA', 'S CRISTOVAO                   ');
INSERT INTO cd_cep_br VALUES ('57.601-470', '40       ', 'R GETULIO VARGAS- ATE 675/676', 'S CRISTOVAO                   ');
INSERT INTO cd_cep_br VALUES ('57.607-550', '40       ', 'R GETULIO VARGAS- DE 677/678 AO FIM', 'S CRISTOVAO                   ');
INSERT INTO cd_cep_br VALUES ('57.605-040', '40       ', 'R GLAUDENCIO MOURA', 'S FRANCISCO                   ');
INSERT INTO cd_cep_br VALUES ('57.607-170', '40       ', 'R GOIAS', 'JD BRASIL                     ');
INSERT INTO cd_cep_br VALUES ('57.602-130', '40       ', 'AV GRACILIANO RAMOS', 'PARAISO                       ');
INSERT INTO cd_cep_br VALUES ('57.600-560', '40       ', 'PC HELIO TEIXEIRA', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.601-570', '40       ', 'PC HELOISA COSTA SAMPAIO (CJ RES PEDRO SURUAGY)', 'P FORA                        ');
INSERT INTO cd_cep_br VALUES ('57.602-020', '40       ', 'AV HERMELINDA BARBOSA', 'PARAISO                       ');
INSERT INTO cd_cep_br VALUES ('57.601-290', '40       ', 'AV HOLANDA', 'S CRISTOVAO                   ');
INSERT INTO cd_cep_br VALUES ('57.600-190', '40       ', 'PC HUMBERTO MENDES', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.605-160', '40       ', 'R IDALINO DE ARAUJO', 'S FRANCISCO                   ');
INSERT INTO cd_cep_br VALUES ('57.600-010', '40       ', 'PC INDEPENDENCIA, DA', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.602-040', '40       ', 'R INTENDENTE BELARMINO TEIXEIRA CAVALCANTE', 'PARAISO                       ');
INSERT INTO cd_cep_br VALUES ('57.606-003', '40       ', 'R IRMAOS BARBOSA', 'EUCALIPTOS                    ');
INSERT INTO cd_cep_br VALUES ('57.607-480', '40       ', 'R IRMAS HOLANDESAS', 'S CRISTOVAO                   ');
INSERT INTO cd_cep_br VALUES ('57.607-440', '40       ', 'R ISRAEL TEIXEIRA', 'S CRISTOVAO                   ');
INSERT INTO cd_cep_br VALUES ('57.607-445', '40       ', 'TV ISRAEL TEIXEIRA', 'S CRISTOVAO                   ');
INSERT INTO cd_cep_br VALUES ('57.607-500', '40       ', 'TV JARDIM DAS FLORES', 'S CRISTOVAO                   ');
INSERT INTO cd_cep_br VALUES ('57.607-300', '40       ', 'LOT JARDIM DAS FLORES', 'S CRISTOVAO                   ');
INSERT INTO cd_cep_br VALUES ('57.601-320', '40       ', 'R JOAO CABOCLO', 'S CRISTOVAO                   ');
INSERT INTO cd_cep_br VALUES ('57.607-280', '40       ', 'R JOAO PINTO', 'VL MARIA                      ');
INSERT INTO cd_cep_br VALUES ('57.602-160', '40       ', 'R JOAO ROQUE', 'PARAISO                       ');
INSERT INTO cd_cep_br VALUES ('57.602-200', '40       ', 'R JOAO TAVARES SILVA', 'S FRANCISCO                   ');
INSERT INTO cd_cep_br VALUES ('57.600-160', '40       ', 'R JOAO VALERIO', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.600-270', '40       ', 'R JOAO VINTE E TRES', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.603-240', '40       ', 'PC DESPORTISTA ALDEMIR ARAUJO FERREIRA(LOT JUCA S', 'J SAMPAIO                     ');
INSERT INTO cd_cep_br VALUES ('57.603-070', '40       ', 'R DESPORTISTA ALOISIO GUIMARAES DE ALBUQUE', 'S CRISTOVAO                   ');
INSERT INTO cd_cep_br VALUES ('57.600-330', '40       ', 'R DESSESSEIS DE SETEMBRO', 'AT CRUZEIRO                   ');
INSERT INTO cd_cep_br VALUES ('57.600-350', '40       ', 'R DEZ DE ABRIL', 'AT CRUZEIRO                   ');
INSERT INTO cd_cep_br VALUES ('57.600-470', '40       ', 'R DOM ARMANDO LOMBARDI', 'T CAVALCANTE                  ');
INSERT INTO cd_cep_br VALUES ('57.600-390', '40       ', 'R DOM BOSCO', 'AT CRUZEIRO                   ');
INSERT INTO cd_cep_br VALUES ('57.600-395', '40       ', 'TV DOM BOSCO', 'AT CRUZEIRO                   ');
INSERT INTO cd_cep_br VALUES ('57.600-570', '40       ', 'R DOM OTAVIO AGUIAR', 'RIBEIRA                       ');
INSERT INTO cd_cep_br VALUES ('57.602-170', '40       ', 'R DOMINGOS ROQUE', 'S FRANCISCO                   ');
INSERT INTO cd_cep_br VALUES ('57.603-050', '40       ', 'R DONA LOURDES GALINDO PIMENTEL', 'S CRISTOVAO                   ');
INSERT INTO cd_cep_br VALUES ('57.607-610', '40       ', 'R DONA MOCA', 'VL MARIA                      ');
INSERT INTO cd_cep_br VALUES ('57.602-310', '40       ', 'R DONDON TOBIAS', 'S FRANCISCO                   ');
INSERT INTO cd_cep_br VALUES ('57.606-007', '40       ', 'R DOS EUCALIPTOS', 'EUCALIPTOS                    ');
INSERT INTO cd_cep_br VALUES ('57.602-000', '40       ', 'R DOUTOR ARISTEU ARRUDA', 'PARAISO                       ');
INSERT INTO cd_cep_br VALUES ('57.600-480', '40       ', 'R DOUTOR FERNANDES DE BARROS', 'T CAVALCANTE                  ');
INSERT INTO cd_cep_br VALUES ('57.601-560', '40       ', 'PC DOUTOR JOSE VALDOMIRO MOTA', 'S CRISTOVAO                   ');
INSERT INTO cd_cep_br VALUES ('57.605-030', '40       ', 'R DOUTOR MIGUEL LOPES', 'S FRANCISCO                   ');
INSERT INTO cd_cep_br VALUES ('57.603-030', '40       ', 'R DOUTOR RUBENS CAVALCANTE AMORIM', 'S CRISTOVAO                   ');
INSERT INTO cd_cep_br VALUES ('57.601-380', '40       ', 'R DOUTORA ALINE ANA LEAL', 'VL JOAO XXIII                 ');
INSERT INTO cd_cep_br VALUES ('57.600-040', '40       ', 'R DUQUE DE CAXIAS', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.603-210', '40       ', 'R ELOI SOARES DA COSTA', 'J SAMPAIO                     ');
INSERT INTO cd_cep_br VALUES ('57.605-120', '40       ', 'R EMERENTINO COSTA', 'S FRANCISCO                   ');
INSERT INTO cd_cep_br VALUES ('57.605-200', '40       ', 'R ENGENHEIRO JOSE DA ROCHA LEITE', 'S FRANCISCO                   ');
INSERT INTO cd_cep_br VALUES ('57.607-520', '40       ', 'R ESPERANCA', 'S CRISTOVAO                   ');
INSERT INTO cd_cep_br VALUES ('57.600-180', '40       ', 'R ESPERIDIAO SAMPAIO', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.607-140', '40       ', 'R ESPIRITO SANTO', 'JD BRASIL                     ');
INSERT INTO cd_cep_br VALUES ('57.601-370', '40       ', 'R ESTUDANTE ERALDO MALTA', 'S CRISTOVAO                   ');
INSERT INTO cd_cep_br VALUES ('57.601-490', '40       ', 'R ESTUDANTE MARCIO EMMANOEL GOMES DA SILVA', 'S CRISTOVAO                   ');
INSERT INTO cd_cep_br VALUES ('57.603-100', '40       ', 'R EXPEDICIONARIO JOSE VIANA DA SILVA', 'S CRISTOVAO                   ');
INSERT INTO cd_cep_br VALUES ('57.607-430', '40       ', 'R EZEQUIEL PEREIRA', 'S CRISTOVAO                   ');
INSERT INTO cd_cep_br VALUES ('57.600-120', '40       ', 'R FERNANDES LIMA', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.601-410', '40       ', 'R FISCAL JOSE MIGUEL PEREIRA', 'S CRISTOVAO                   ');
INSERT INTO cd_cep_br VALUES ('57.607-210', '40       ', 'R FISCAL MURITIBA', 'S CRISTOVAO                   ');
INSERT INTO cd_cep_br VALUES ('57.605-060', '40       ', 'R FISCAL PEDRO LEITAO', 'S FRANCISCO                   ');
INSERT INTO cd_cep_br VALUES ('57.600-005', '40       ', 'R FLORIANO PEIXOTO', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.600-170', '40       ', 'PC FRANCISCO CAVALCANTE', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.607-290', '40       ', 'R FRANCISCO FERREIRA BARBOSA', 'S CRISTOVAO                   ');
INSERT INTO cd_cep_br VALUES ('57.601-500', '40       ', 'R ARY ALVES DOS SANTOS', 'S CRISTOVAO                   ');
INSERT INTO cd_cep_br VALUES ('57.605-190', '40       ', 'R AVELINO BALBINO DA SILVA', 'S FRANCISCO                   ');
INSERT INTO cd_cep_br VALUES ('57.600-690', '40       ', 'PC AVELINO BALBINO DA SILVA', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('69.093-147', '156      ', 'R SUCUBA(M.OLIVEIRAS)', 'MTE OLIVEIRAS                 ');
INSERT INTO cd_cep_br VALUES ('57.020-690', '54       ', 'R SARGENTO BENEVIDES', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.031-270', '54       ', 'R SARGENTO BENEVIDES MONTE', 'POCO                          ');
INSERT INTO cd_cep_br VALUES ('57.043-400', '54       ', 'R SARGENTO GONCALVES', 'FEITOSA                       ');
INSERT INTO cd_cep_br VALUES ('57.051-610', '54       ', 'PC SARGENTO HERCILIO MARQUES', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.010-200', '54       ', 'R SARGENTO JAYME PANTALEAO', 'PRADO                         ');
INSERT INTO cd_cep_br VALUES ('57.050-490', '54       ', 'TV SARGENTO JOSE ALFREDO', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.050-770', '54       ', 'R SARGENTO NELMONT', 'G LOURDES                     ');
INSERT INTO cd_cep_br VALUES ('57.017-670', '54       ', 'R SARGENTO OSEAS COSTA', 'BEBEDOURO                     ');
INSERT INTO cd_cep_br VALUES ('57.017-675', '54       ', 'TV SARGENTO OSEAS COSTA', 'BEBEDOURO                     ');
INSERT INTO cd_cep_br VALUES ('57.062-500', '54       ', 'R SARMENTO JOSE PEDRO DOS SANTOS', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.080-020', '54       ', 'R SATUBA', 'CANAA                         ');
INSERT INTO cd_cep_br VALUES ('57.042-110', '54       ', 'R SAUDADE, DA', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.071-870', '54       ', 'R SAUDADE, DA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.071-875', '54       ', 'TV SAUDADE, DA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.072-150', '54       ', 'R SEBASTIAO ANTONIO DAS NEVES', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.011-460', '54       ', 'R SEBASTIAO BERNARDO CALDAS', 'T BARRA                       ');
INSERT INTO cd_cep_br VALUES ('57.061-410', '54       ', 'R SEBASTIAO CORREIA DA ROCHA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.050-780', '54       ', 'R SEBASTIAO DA HORA', 'G LOURDES                     ');
INSERT INTO cd_cep_br VALUES ('57.050-810', '54       ', 'TV SEBASTIAO DA HORA', 'G LOURDES                     ');
INSERT INTO cd_cep_br VALUES ('57.081-390', '54       ', 'R SEBASTIAO DA ROCHA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.082-440', '54       ', 'R SEBASTIAO DA ROCHA BARROS', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.051-620', '54       ', 'R SEBASTIAO GRANJEIRO', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.035-150', '54       ', 'PC SEBASTIAO MARINHO MUNIZ FALCAO', 'P VERDE                       ');
INSERT INTO cd_cep_br VALUES ('57.010-520', '54       ', 'R SEBASTIAO VASCONCELOS', 'T BARRA                       ');
INSERT INTO cd_cep_br VALUES ('57.072-270', '54       ', 'R SEBASTIAO VICENTE DA SILVA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.045-700', '54       ', 'R SEMENTEIRA, DA', 'B DURO                        ');
INSERT INTO cd_cep_br VALUES ('57.014-110', '54       ', 'R SEMENTEIRA, DA', 'P GROSSA                      ');
INSERT INTO cd_cep_br VALUES ('57.055-358', '54       ', 'PC SENADOR ARNON DE MELO', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.055-350', '54       ', 'R SENADOR ARNON DE MELO', 'PINHEIRO                      ');
INSERT INTO cd_cep_br VALUES ('57.055-355', '54       ', 'TV SENADOR ARNON DE MELO', 'PINHEIRO                      ');
INSERT INTO cd_cep_br VALUES ('57.030-720', '54       ', 'CJ SENADOR ARNON DE MELO', 'POCO                          ');
INSERT INTO cd_cep_br VALUES ('57.010-580', '54       ', 'AV SENADOR ARNON DE MELO', 'T BARRA                       ');
INSERT INTO cd_cep_br VALUES ('57.022-280', '54       ', 'R SENADOR BARROS LEITE', 'JARAGUA                       ');
INSERT INTO cd_cep_br VALUES ('57.017-680', '54       ', 'R SENADOR BERNARDO MENDONCA', 'BEBEDOURO                     ');
INSERT INTO cd_cep_br VALUES ('57.025-560', '54       ', 'R SENADOR BERNARDO SOBRINHO', 'POCO                          ');
INSERT INTO cd_cep_br VALUES ('57.025-565', '54       ', 'TV SENADOR BERNARDO SOBRINHO', 'POCO                          ');
INSERT INTO cd_cep_br VALUES ('57.038-500', '54       ', 'R SENADOR EZECHIAS DA ROCHA', 'C ALMAS                       ');
INSERT INTO cd_cep_br VALUES ('57.039-660', '54       ', 'R SAO MIGUEL', 'F PEIXOTO                     ');
INSERT INTO cd_cep_br VALUES ('57.041-270', '54       ', 'R SAO MIGUEL', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.083-070', '54       ', 'R TENENTE AUREO DE AZEVEDO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.040-720', '54       ', 'R TENENTE BRASIL', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.040-725', '54       ', 'TV TENENTE BRASIL', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.031-300', '54       ', 'R TENENTE DARCY BARBOSA DA SILVA', 'POCO                          ');
INSERT INTO cd_cep_br VALUES ('57.041-650', '54       ', 'R TENENTE DOMINGOS RODAS', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.014-570', '54       ', 'R TENENTE FRANCISCO DE OLIVEIRA DA SILVA', 'P GROSSA                      ');
INSERT INTO cd_cep_br VALUES ('57.057-220', '54       ', 'R TENENTE FRANCISCO OLIVEIRA DA SILVA', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.061-740', '54       ', 'R TENENTE JOAO VIEIRA DA COSTA(LOT LAGOA AZUL)', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.050-370', '54       ', 'R TENENTE JOSE FERREIRA DE SOUZA', 'PITANGUINHA                   ');
INSERT INTO cd_cep_br VALUES ('57.031-310', '54       ', 'R TENENTE JOSE FERREIRA DE SOUZA', 'POCO                          ');
INSERT INTO cd_cep_br VALUES ('57.043-210', '54       ', 'R TENENTE JOSE GONCALVES', 'FEITOSA                       ');
INSERT INTO cd_cep_br VALUES ('57.071-400', '54       ', 'R TENENTE JULIVAL CASADO COSTA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.075-380', '54       ', 'R TENENTE MADALENA(RUA 03 CJ OSMAN LOUREIRO)', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.015-050', '54       ', 'PC TENENTE MOYSES SILVA FILHO', 'V LAGO                        ');
INSERT INTO cd_cep_br VALUES ('57.042-700', '54       ', 'R TENENTE RUBER IVO', 'FEITOSA                       ');
INSERT INTO cd_cep_br VALUES ('57.063-150', '54       ', 'R TEODOMIRO DEODATO SANTOS(LOT CIPESA)', 'S AMELIA                      ');
INSERT INTO cd_cep_br VALUES ('57.057-430', '54       ', 'R TEOFILO DE BARROS', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.030-210', '54       ', 'R TEOFILO OTONI', 'P TERRA                       ');
INSERT INTO cd_cep_br VALUES ('57.073-530', '54       ', 'AV TEOTONIO VILELA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.039-050', '54       ', 'R TERELETE', 'R DOCE                        ');
INSERT INTO cd_cep_br VALUES ('57.057-570', '54       ', 'R TEREZA DE AZEVEDO- ATE 451/452', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.052-600', '54       ', 'R TEREZA DE AZEVEDO- DE 453/454 AO FIM', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.062-000', '54       ', 'AV TEREZA LUCENA QUINTELA CAVALCANTE', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.080-560', '54       ', 'R TEREZINHA DE JESUS NUNES WANDERLEY', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('13.032-430', '4802     ', 'R CORONEL JOAQUIM MONTEIRO', 'VL DUTRA                      ');
INSERT INTO cd_cep_br VALUES ('57.084-280', '54       ', 'R TEREZINHA MOTTA LISBOA DA FONSECA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.084-510', '54       ', 'TER TERMINAL JOAO SARMENTO FERREIRA', 'BENEDITO BENTES               ');
INSERT INTO cd_cep_br VALUES ('57.048-160', '54       ', 'LOT TERRA DE ANTARES I', 'SERRARIA                      ');
INSERT INTO cd_cep_br VALUES ('57.048-170', '54       ', 'LOT TERRA DE ANTARES II', 'SERRARIA                      ');
INSERT INTO cd_cep_br VALUES ('57.051-640', '54       ', 'R TERTULIANO DE BARROS', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.057-600', '54       ', 'R THEOTONIO DE SANTA CRUZ', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.011-001', '54       ', 'AV SIQUEIRA CAMPOS- DE 1032 AO FIM - LADO PAR', 'PRADO                         ');
INSERT INTO cd_cep_br VALUES ('57.062-350', '54       ', 'AL SISINO BORGES', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.055-830', '54       ', 'R SOARES NETO', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.017-290', '54       ', 'R SOL NASCENTE', 'B PARTO                       ');
INSERT INTO cd_cep_br VALUES ('57.040-595', '54       ', 'R SOL NASCENTE', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.039-670', '54       ', 'R SOL, DO', 'SAUDE                         ');
INSERT INTO cd_cep_br VALUES ('57.020-070', '54       ', 'R SOL, DO', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.062-680', '54       ', 'R SOL, DO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.076-010', '54       ', 'R SOLDADO ADRIAO JOSE DA SILVA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.031-280', '54       ', 'R SOLDADO EDUARDO SANTOS', 'POCO                          ');
INSERT INTO cd_cep_br VALUES ('57.031-290', '54       ', 'R SOLDADO JOSE GUILHERME DA SILVA', 'POCO                          ');
INSERT INTO cd_cep_br VALUES ('57.081-050', '54       ', 'R SOLIMOES', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.043-530', '54       ', 'R SOLIMOES', 'FEITOSA                       ');
INSERT INTO cd_cep_br VALUES ('57.083-030', '54       ', 'R SOMAIR SAFFADY', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.063-050', '54       ', 'LOT SOMBRA DOS EUCALIPTOS', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.082-520', '54       ', 'CJ SONIA SAMPAIO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.038-580', '54       ', 'R SORAYA RAMIRES ALMEIDA(RUA A LOT VILA RICA)', 'C ALMAS                       ');
INSERT INTO cd_cep_br VALUES ('57.057-420', '54       ', 'R SOSSEGO, DO', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.041-280', '54       ', 'R SOSSEGO, DO', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.071-865', '54       ', 'R SOSSEGO, DO', 'A S DUMONT                    ');
INSERT INTO cd_cep_br VALUES ('57.062-380', '54       ', 'AL STELA BRAGA COSTA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.060-210', '54       ', 'R STELA MOREIRA MAGALHAES', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.036-300', '54       ', 'LOT STELLA MARIS', 'JATIUCA                       ');
INSERT INTO cd_cep_br VALUES ('57.050-510', '54       ', 'TV SUBTENENTE EXPEDITO FERRAZ', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.052-560', '54       ', 'R SUCUPIRA', 'G LOURDES                     ');
INSERT INTO cd_cep_br VALUES ('57.014-100', '54       ', 'PC NOSSA SENHORA DAS GRACAS', 'LEVADA                        ');
INSERT INTO cd_cep_br VALUES ('69.075-500', '156      ', 'R VITORIA REGIA', 'MAUAZINHO                     ');
INSERT INTO cd_cep_br VALUES ('69.087-261', '156      ', 'TV VITORIA REGIA', 'T NEVES                       ');
INSERT INTO cd_cep_br VALUES ('57.057-520', '54       ', 'R DOUTOR JOVINO LOPES LYRA', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.083-460', '54       ', 'AV DOUTOR JULIO CEZAR MENDONCA UCHOA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.072-040', '54       ', 'R DOUTOR JURACY PEREIRA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.057-640', '54       ', 'R DOUTOR JUVINO AYRA', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.038-320', '54       ', 'R DOUTOR LAURO MACHADO COSTA', 'C ALMAS                       ');
INSERT INTO cd_cep_br VALUES ('57.017-040', '54       ', 'R DOUTOR LEITE JUNIOR', 'B PARTO                       ');
INSERT INTO cd_cep_br VALUES ('57.017-045', '54       ', 'TV DOUTOR LEITE JUNIOR', 'B PARTO                       ');
INSERT INTO cd_cep_br VALUES ('57.030-180', '54       ', 'R DOUTOR LESSA DE AZEVEDO', 'PAJUCARA                      ');
INSERT INTO cd_cep_br VALUES ('57.015-070', '54       ', 'R DOUTOR LUIZ DE BARROS', 'V LAGO                        ');
INSERT INTO cd_cep_br VALUES ('57.055-030', '54       ', 'R DOUTOR LUIZ DE MASCARENHAS', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.017-050', '54       ', 'R DOUTOR LUIZ EUGENIO', 'B PARTO                       ');
INSERT INTO cd_cep_br VALUES ('57.020-140', '54       ', 'R DOUTOR LUIZ PONTES DE MIRANDA', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.060-400', '54       ', 'R DOUTOR LUIZ RAMALHO DE AZEVEDO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.017-060', '54       ', 'R DOUTOR LUIZ ZAGALO', 'B PARTO                       ');
INSERT INTO cd_cep_br VALUES ('57.073-040', '54       ', 'R DOUTOR MACHADO PONTES DE MIRANDA NOGUEIRA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.063-180', '54       ', 'R DOUTOR MANOEL ESTEVAO UZEDA LUNA FILHO(LOT CIP', 'S AMELIA                      ');
INSERT INTO cd_cep_br VALUES ('57.070-020', '54       ', 'R DOUTOR MANOEL MACHADO', 'F VELHO                       ');
INSERT INTO cd_cep_br VALUES ('57.072-710', '54       ', 'R DOUTOR MANOEL NORMANDO LIMA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.020-550', '54       ', 'R DOUTOR MANOEL RODRIGUES DA SILVA CALHEIROS', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.073-380', '54       ', 'PC DOUTOR MANOEL VALENTE DE LIMA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.073-060', '54       ', 'R DOUTOR MARENCIO DA COSTA BARROS', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.020-565', '54       ', 'R DOUTOR MARINHO DE GUSMAO', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.051-240', '54       ', 'LD DOUTOR GERALDO MELO DOS SANTOS- ATE 272/273', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.025-660', '54       ', 'LD DOUTOR GERALDO MELO DOS SANTOS- DE 274/275 AO', 'POCO                          ');
INSERT INTO cd_cep_br VALUES ('57.051-250', '54       ', 'PC DOUTOR GERBASE FILHO', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.038-060', '54       ', 'R DOUTOR GERSON WANDERLEY DE OLIVEIRA', 'MANGABEIRAS                   ');
INSERT INTO cd_cep_br VALUES ('57.014-300', '54       ', 'PC DOUTOR GETULIO VARGAS', 'P GROSSA                      ');
INSERT INTO cd_cep_br VALUES ('57.036-130', '54       ', 'R DOUTOR HEBEL QUINTELA', 'JATIUCA                       ');
INSERT INTO cd_cep_br VALUES ('57.038-270', '54       ', 'R DOUTOR HENRIQUE EQUELMAN', 'C ALMAS                       ');
INSERT INTO cd_cep_br VALUES ('57.030-280', '54       ', 'R DOUTOR HERMINIO BARROCA', 'PAJUCARA                      ');
INSERT INTO cd_cep_br VALUES ('57.071-210', '54       ', 'R DOUTOR HILDEBRANDO FALCAO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.017-760', '54       ', 'R DOUTOR HILTON PAULO OMENA DUARTE', 'BEBEDOURO                     ');
INSERT INTO cd_cep_br VALUES ('57.082-270', '54       ', 'R DOUTOR HOMERO GALVAO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.030-060', '54       ', 'PC DOUTOR HOMERO GALVAO', 'PAJUCARA                      ');
INSERT INTO cd_cep_br VALUES ('57.050-590', '54       ', 'R DOUTOR ISAIAS FRANCISCO DE ANDRADE', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.018-080', '54       ', 'R DOUTOR JEFERSON DE LIMA ARAUJO', 'BEBEDOURO                     ');
INSERT INTO cd_cep_br VALUES ('57.061-230', '54       ', 'R DOUTOR JOAO BARTOLOMEU DE NOVAES', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.038-560', '54       ', 'R DOUTOR JOAO CABRAL TOLEDO', 'C ALMAS                       ');
INSERT INTO cd_cep_br VALUES ('57.084-210', '54       ', 'R DOUTOR JOAO CLIMACO DA SILVA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.071-240', '54       ', 'R DOUTOR JOAO CRISOSTOMO DE FARIAS', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.057-080', '54       ', 'R DOUTOR JOAO DE AZEVEDO FILHO', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.011-050', '54       ', 'R DOUTOR JOAO EULALIO', 'PRADO                         ');
INSERT INTO cd_cep_br VALUES ('57.052-610', '54       ', 'R DOUTOR JOAO TEIXEIRA CAVALCANTE(ANTIGA RUA VIN', 'G LOURDES                     ');
INSERT INTO cd_cep_br VALUES ('57.082-100', '54       ', 'R DOUTOR JONES CASTRO LISBOA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.010-300', '54       ', 'R DOUTOR JORGE DE LIMA', 'T BARRA                       ');
INSERT INTO cd_cep_br VALUES ('57.036-510', '54       ', 'R DOUTOR JOSE AFONSO DE MELO', 'JATIUCA                       ');
INSERT INTO cd_cep_br VALUES ('57.036-520', '54       ', 'R DOUTOR JOSE ALFREDO DE MELLO', 'MANGABEIRAS                   ');
INSERT INTO cd_cep_br VALUES ('57.051-260', '54       ', 'R DOUTOR JOSE BENTO JUNIOR', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.036-140', '54       ', 'R DOUTOR JOSE BERNADINO CARVALHO LEITE', 'JATIUCA                       ');
INSERT INTO cd_cep_br VALUES ('57.084-250', '54       ', 'R DOUTOR JOSE BRAGA LYRA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.080-400', '54       ', 'R DOUTOR JOSE CALMON REIS', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.080-450', '54       ', 'R DOUTOR JOSE CAMELO JUNIOR', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.010-370', '54       ', 'R DOUTOR JOSE CARNEIRO', 'P BARRA                       ');
INSERT INTO cd_cep_br VALUES ('57.055-020', '54       ', 'R DOUTOR JOSE DE ALBUQUERQUE PORCIUNCULAS', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.063-110', '54       ', 'R DOUTOR JOSE DE ALMEIDA ALBUQUERQUE(LOT CIPESA)', 'S AMELIA                      ');
INSERT INTO cd_cep_br VALUES ('57.050-240', '54       ', 'R DOUTOR JOSE DE CASTRO AZEVEDO', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.035-340', '54       ', 'R DOUTOR JOSE DE MEDEIROS SARMENTO', 'P VERDE                       ');
INSERT INTO cd_cep_br VALUES ('57.060-380', '54       ', 'R DOUTORA ALZIRA SAMPAIO ALMEIDA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.045-390', '54       ', 'R DOUTORA DAYSE LINS BREDA', 'B DURO                        ');
INSERT INTO cd_cep_br VALUES ('57.063-090', '54       ', 'R DOUTORA IVANY SCHWARTZ(LOT CIPESA)', 'S AMELIA                      ');
INSERT INTO cd_cep_br VALUES ('57.063-100', '54       ', 'R DOUTORA IVANY SCHWARTZ(LOT CIPESA)', 'S AMELIA                      ');
INSERT INTO cd_cep_br VALUES ('57.084-260', '54       ', 'R DOUTORA MARIA DA GRACA PACHECO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.047-040', '54       ', 'R DOUTORA MARIA VITORIAS SANTOS LIMA', 'SERRARIA                      ');
INSERT INTO cd_cep_br VALUES ('57.036-530', '54       ', 'R DOUTORA ROSA CABUS', 'JATIUCA                       ');
INSERT INTO cd_cep_br VALUES ('57.011-250', '54       ', 'R DOZE DE OUTUBRO', 'T BARRA                       ');
INSERT INTO cd_cep_br VALUES ('57.030-390', '54       ', 'LOT DUAS IRMAS', 'POCO                          ');
INSERT INTO cd_cep_br VALUES ('57.072-600', '54       ', 'R DULCE CAVALCANTE DE AZEVEDO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.031-410', '54       ', 'R DULCE DANTAS LOUREIRO', 'POCO                          ');
INSERT INTO cd_cep_br VALUES ('57.083-470', '54       ', 'R DURVAL ALMEIDA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.055-210', '54       ', 'R DURVAL COELHO NORMANDE', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.061-000', '54       ', 'AV DURVAL DE GOES MONTEIRODO KM 0 AO KM 12 - LADO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.080-000', '54       ', 'AV DURVAL DE GOES MONTEIRODO KM 0 AO KM 12 - LADO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.052-080', '54       ', 'R DURVAL GOMES DE MELO', 'G LOURDES                     ');
INSERT INTO cd_cep_br VALUES ('57.035-060', '54       ', 'R DURVAL GUIMARAES', 'P VERDE                       ');
INSERT INTO cd_cep_br VALUES ('57.040-840', '54       ', 'R DURVAL GUIMARAES', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.075-270', '54       ', 'R DURVAL GUIMARAES NETO(RUA A8 CJ OSMAN LOUREIRO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.010-140', '54       ', 'R EDGAR DE GOES MONTEIRO', 'PRADO                         ');
INSERT INTO cd_cep_br VALUES ('57.071-425', '54       ', 'R EDILANE', 'A S DUMONT                    ');
INSERT INTO cd_cep_br VALUES ('57.062-040', '54       ', 'AL EDILSON DE ALCANTARA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.083-240', '54       ', 'R EDITH BILU BRITO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.075-280', '54       ', 'R EDMILSON SALES DO NASCIMENTO(RUA 02 CJ OSMAN L', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.073-410', '54       ', 'R EDNARDO COSTA CABRAL', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.039-230', '54       ', 'R EDSON DE CARVALHO', 'R DOCE                        ');
INSERT INTO cd_cep_br VALUES ('57.041-700', '54       ', 'R EDSON FERREIRA DOS SANTOS', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.075-290', '54       ', 'R EDSON FRAZAO(RUA 26 CJ OSMAN LOUREIRO)', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.055-410', '54       ', 'R EDUARDO CAMPOS CERQUEIRA', 'PINHEIRO                      ');
INSERT INTO cd_cep_br VALUES ('57.071-060', '54       ', 'R EDUARDO JORGE LOPES NOVAES', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.082-080', '54       ', 'R EDUARDO PINHEIRO LOBO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.070-050', '54       ', 'PC EDUARDO SANTOS', 'F VELHO                       ');
INSERT INTO cd_cep_br VALUES ('69.098-044', '156      ', 'R JABOTICATUBAS(A. CLARAS)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.053-680', '156      ', 'BC SUCUPIRA', 'N S GRACAS                    ');
INSERT INTO cd_cep_br VALUES ('57.084-540', '54       ', 'R TABULEIRO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.082-570', '54       ', 'LOT TABULEIRO NOVO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.046-520', '54       ', 'CJ TANCREDO NEVES', 'SERRARIA                      ');
INSERT INTO cd_cep_br VALUES ('57.071-550', '54       ', 'AV TANCREDO NEVES', 'A S DUMONT                    ');
INSERT INTO cd_cep_br VALUES ('57.039-470', '54       ', 'R TANCREDO NEVES', 'R DOCE                        ');
INSERT INTO cd_cep_br VALUES ('57.071-845', '54       ', 'TV TANCREDO NEVES', 'A S DUMONT                    ');
INSERT INTO cd_cep_br VALUES ('57.043-510', '54       ', 'R TAPAJOS', 'FEITOSA                       ');
INSERT INTO cd_cep_br VALUES ('57.046-450', '54       ', 'R TAPUIAS', 'SERRARIA                      ');
INSERT INTO cd_cep_br VALUES ('57.080-040', '54       ', 'R TAQUARANA', 'CANAA                         ');
INSERT INTO cd_cep_br VALUES ('57.030-290', '54       ', 'R SENADOR FIRMINO DE VASCONCELOS', 'PAJUCARA                      ');
INSERT INTO cd_cep_br VALUES ('57.030-295', '54       ', 'TV SENADOR FIRMINO DE VASCONCELOS', 'PAJUCARA                      ');
INSERT INTO cd_cep_br VALUES ('57.084-360', '54       ', 'R SENADOR JOAO LUCIO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.020-450', '54       ', 'R SENADOR LUIZ TORRES', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.035-160', '54       ', 'AV SENADOR ROBERT KENNEDY', 'P VERDE                       ');
INSERT INTO cd_cep_br VALUES ('57.055-850', '54       ', 'LD VERDE, DO', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.038-030', '54       ', 'R VEREADOR ANTONIO CAVALCANTE LINS', 'MANGABEIRAS                   ');
INSERT INTO cd_cep_br VALUES ('57.017-700', '54       ', 'R VEREADOR BRUNO FERRARI', 'BEBEDOURO                     ');
INSERT INTO cd_cep_br VALUES ('57.018-050', '54       ', 'CJ VEREADOR BRUNO FERRARI', 'BEBEDOURO                     ');
INSERT INTO cd_cep_br VALUES ('57.082-015', '54       ', 'R VEREADOR DARIO MARSIGLIA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.030-140', '54       ', 'PC VEREADOR FELICIO NAPOLEAO DOS SANTOS', 'PAJUCARA                      ');
INSERT INTO cd_cep_br VALUES ('57.070-200', '54       ', 'R VEREADOR HERMINIO CARDOSO(ANTIGA RUA DO CRAVO)', 'R NOVO                        ');
INSERT INTO cd_cep_br VALUES ('57.084-640', '54       ', 'R VEREADOR JOAO TEIXEIRA COSTA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.061-420', '54       ', 'R VEREADOR JORGE OMENA', 'CANAA                         ');
INSERT INTO cd_cep_br VALUES ('57.018-760', '54       ', 'LD VEREADOR JORGE OMENA', 'C JAQUEIRA                    ');
INSERT INTO cd_cep_br VALUES ('57.015-590', '54       ', 'R VEREADOR JOSE DE CALDAS', 'P GROSSA                      ');
INSERT INTO cd_cep_br VALUES ('57.015-595', '54       ', 'TV VEREADOR JOSE DE CALDAS', 'P GROSSA                      ');
INSERT INTO cd_cep_br VALUES ('57.018-460', '54       ', 'R VEREADOR JOSE LUNA', 'C JAQUEIRA                    ');
INSERT INTO cd_cep_br VALUES ('57.084-440', '54       ', 'R VEREADOR JOSE RAIMUNDO DOS SANTOS(RUA 2 CJ RES', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.042-320', '54       ', 'R VEREADOR JOSE RIBEIRO BARBOSA', 'B VISTA                       ');
INSERT INTO cd_cep_br VALUES ('57.084-100', '54       ', 'R VEREADOR MANOEL AURELIANO REIS', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.037-340', '54       ', 'R VEREADOR MIRONILDES VIEIRA(ANTIGA RUA JOSE CAR', 'JATIUCA                       ');
INSERT INTO cd_cep_br VALUES ('57.036-360', '54       ', 'R VEREADOR PEDRO MOURA', 'JATIUCA                       ');
INSERT INTO cd_cep_br VALUES ('57.017-840', '54       ', 'R VEREADOR PEDRO MOURA', 'B PARTO                       ');
INSERT INTO cd_cep_br VALUES ('57.082-025', '54       ', 'TV VEREADOR SERGIO QUITELLA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.060-790', '54       ', 'R VESPERTINO LIMA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.081-560', '54       ', 'R VICENTE CELESTINO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.017-710', '54       ', 'R VICENTE DE CARVALHO FREITAS', 'BEBEDOURO                     ');
INSERT INTO cd_cep_br VALUES ('57.050-840', '54       ', 'R VICENTE DE PAULA COSTA', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.082-670', '54       ', 'LOT VIDA NOVA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.020-300', '54       ', 'AV VIEIRA PERDIGAO', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.020-305', '54       ', 'VL VIEIRA PERDIGAO', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.014-390', '54       ', 'R TIRADENTES', 'P GROSSA                      ');
INSERT INTO cd_cep_br VALUES ('57.045-740', '54       ', 'R TIRADENTES', 'B DURO                        ');
INSERT INTO cd_cep_br VALUES ('57.025-700', '54       ', 'R TITO DE BARROS', 'POCO                          ');
INSERT INTO cd_cep_br VALUES ('57.017-690', '54       ', 'R TOBIAS BARRETO', 'BEBEDOURO                     ');
INSERT INTO cd_cep_br VALUES ('57.017-695', '54       ', 'TV TOBIAS BARRETO', 'BEBEDOURO                     ');
INSERT INTO cd_cep_br VALUES ('57.017-135', '54       ', 'VL TOCANTINS', 'B PARTO                       ');
INSERT INTO cd_cep_br VALUES ('57.043-500', '54       ', 'R TOCANTINS', 'FEITOSA                       ');
INSERT INTO cd_cep_br VALUES ('57.051-000', '54       ', 'AV TOMAS ESPINDOLA', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.010-210', '54       ', 'R TOME DA ROCHA SOUZA LEAO', 'PRADO                         ');
INSERT INTO cd_cep_br VALUES ('57.030-108', '54       ', 'TV TOME DE SOUZA', 'PAJUCARA                      ');
INSERT INTO cd_cep_br VALUES ('57.080-060', '54       ', 'R TRAIPU', 'CANAA                         ');
INSERT INTO cd_cep_br VALUES ('57.018-820', '54       ', 'R TRES DE AGOSTO', 'C JAQUEIRA                    ');
INSERT INTO cd_cep_br VALUES ('57.014-400', '54       ', 'R TRES DE MAIO', 'P GROSSA                      ');
INSERT INTO cd_cep_br VALUES ('57.014-405', '54       ', 'TV TRES DE MAIO', 'P GROSSA                      ');
INSERT INTO cd_cep_br VALUES ('57.025-420', '54       ', 'PC TREZE DE MAIO', 'POCO                          ');
INSERT INTO cd_cep_br VALUES ('57.025-410', '54       ', 'R TREZE DE MAIO', 'POCO                          ');
INSERT INTO cd_cep_br VALUES ('57.025-415', '54       ', 'TV TREZE DE MAIO', 'POCO                          ');
INSERT INTO cd_cep_br VALUES ('57.043-220', '54       ', 'R TREZE DE NOVEMBRO', 'FEITOSA                       ');
INSERT INTO cd_cep_br VALUES ('57.041-720', '54       ', 'R TRINTA E UM DE MARCO', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.040-180', '54       ', 'R TRIUNFO, DO', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.040-185', '54       ', 'TV TRIUNFO, DO', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.015-800', '54       ', 'R TUPINAMBAS', 'P GROSSA                      ');
INSERT INTO cd_cep_br VALUES ('57.046-460', '54       ', 'R TUPINAMBAS', 'SERRARIA                      ');
INSERT INTO cd_cep_br VALUES ('57.046-470', '54       ', 'R TUPIS, DOS', 'SERRARIA                      ');
INSERT INTO cd_cep_br VALUES ('57.035-630', '54       ', 'PC TURISTA, DO', 'P VERDE                       ');
INSERT INTO cd_cep_br VALUES ('57.081-100', '54       ', 'R UBERABA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.036-780', '54       ', 'R UBIRACI COSTA FERREIRA', 'JATIUCA                       ');
INSERT INTO cd_cep_br VALUES ('57.036-790', '54       ', 'R UBIRACY NOBERTO JOAZEIRO DE FARIAS COSTA', 'JATIUCA                       ');
INSERT INTO cd_cep_br VALUES ('57.011-400', '54       ', 'R UBIRAJARA', 'T BARRA                       ');
INSERT INTO cd_cep_br VALUES ('57.050-530', '54       ', 'R ULISSES BRAGA JUNIOR', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.072-650', '54       ', 'R ULISSES CERQUEIRA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.030-450', '54       ', 'R ULISSES SOUZA BANDEIRA', 'P TERRA                       ');
INSERT INTO cd_cep_br VALUES ('57.038-510', '54       ', 'R UNIAO DOS PALMARES', 'C ALMAS                       ');
INSERT INTO cd_cep_br VALUES ('57.025-568', '54       ', 'PC UNIDOS DO POCO', 'POCO                          ');
INSERT INTO cd_cep_br VALUES ('57.022-120', '54       ', 'R URUGUAI, DO', 'JARAGUA                       ');
INSERT INTO cd_cep_br VALUES ('57.025-625', '54       ', 'TV VALDEMAR BASTOS', 'POCO                          ');
INSERT INTO cd_cep_br VALUES ('57.041-290', '54       ', 'R VALDEMAR FERREIRA', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.031-440', '54       ', 'R VALDEMAR LOUREIRO BERNARDES', 'MANGABEIRAS                   ');
INSERT INTO cd_cep_br VALUES ('57.052-570', '54       ', 'R TATAJUBA', 'G LOURDES                     ');
INSERT INTO cd_cep_br VALUES ('57.055-680', '54       ', 'R TAVARES BASTOS', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.071-460', '54       ', 'CJ TAXISTAS, DOS', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.040-520', '54       ', 'R TELEGRAFO, DO', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.081-160', '54       ', 'R TELMA LEAO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.050-660', '54       ', 'R TELMO LESSA LOBO', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.046-200', '54       ', 'R TEMISTOCLES DE FREITAS MACHADO', 'SERRARIA                      ');
INSERT INTO cd_cep_br VALUES ('57.055-360', '54       ', 'R TENENTE ANTONIO OLIVEIRA', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.603-130', '40       ', 'PC ABDON GRANJA', 'S CRISTOVAO                   ');
INSERT INTO cd_cep_br VALUES ('57.603-230', '40       ', 'PC ABDON GRANJA (LOT JUCA SAMPAIO)', 'J SAMPAIO                     ');
INSERT INTO cd_cep_br VALUES ('57.600-550', '40       ', 'R ABILIO BALBINO', 'RIBEIRA                       ');
INSERT INTO cd_cep_br VALUES ('57.607-050', '40       ', 'R ACRE', 'JD BRASIL                     ');
INSERT INTO cd_cep_br VALUES ('57.601-030', '40       ', 'R ADOLFO PINTO', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.601-220', '40       ', 'AV ALAGOAS- ATE 109/110', 'S CRISTOVAO                   ');
INSERT INTO cd_cep_br VALUES ('57.607-020', '40       ', 'AV ALAGOAS- DE 111/112 AO FIM', 'S CRISTOVAO                   ');
INSERT INTO cd_cep_br VALUES ('57.603-110', '40       ', 'R ALDEMIR FERREIRA', 'S CRISTOVAO                   ');
INSERT INTO cd_cep_br VALUES ('57.601-300', '40       ', 'AV ALEMANHA', 'S CRISTOVAO                   ');
INSERT INTO cd_cep_br VALUES ('57.600-670', '40       ', 'PC AMABILIA WANDERLEY', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.607-030', '40       ', 'R AMAZONAS', 'JD BRASIL                     ');
INSERT INTO cd_cep_br VALUES ('57.602-180', '40       ', 'R ANA ADELAIDE DUARTE', 'S FRANCISCO                   ');
INSERT INTO cd_cep_br VALUES ('69.097-762', '156      ', 'R 52 (CJ F MENDES II)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.077-530', '156      ', 'R 52 (CJ 31 DE MARCO I)', 'JAPIIM                        ');
INSERT INTO cd_cep_br VALUES ('69.095-400', '156      ', 'R 52 (NUCLEO 5)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('57.073-580', '54       ', 'LOT JOAO PAULO VI', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.018-830', '54       ', 'CJ JOAO PEREIRA DA SILVA', 'C JAQUEIRA                    ');
INSERT INTO cd_cep_br VALUES ('57.050-270', '54       ', 'R JOAO REIS RAMALHO', 'PITANGUINHA                   ');
INSERT INTO cd_cep_br VALUES ('57.046-130', '54       ', 'R JOAO RODRIGUES SAMPAIO', 'B DURO                        ');
INSERT INTO cd_cep_br VALUES ('57.055-060', '54       ', 'LD JOAO SAMPAIO', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.062-630', '54       ', 'CJ JOAO SAMPAIO I', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.084-420', '54       ', 'CJ JOAO SAMPAIO II', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.080-600', '54       ', 'AL JASMELINA BARROS GONCALVES', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.035-430', '54       ', 'TV JATIUCA', 'JATIUCA                       ');
INSERT INTO cd_cep_br VALUES ('57.082-030', '54       ', 'LOT JATOBA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.080-080', '54       ', 'R JEQUIA', 'CANAA                         ');
INSERT INTO cd_cep_br VALUES ('57.052-440', '54       ', 'R JEQUITIBA', 'G LOURDES                     ');
INSERT INTO cd_cep_br VALUES ('57.074-060', '54       ', 'R JEQUITIBA (LOT PARQUE DAS ARVORES)', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.043-110', '54       ', 'R JERUSALEM', 'FEITOSA                       ');
INSERT INTO cd_cep_br VALUES ('57.043-115', '54       ', 'TV JERUSALEM', 'FEITOSA                       ');
INSERT INTO cd_cep_br VALUES ('57.071-090', '54       ', 'R JERUSALEM', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.040-620', '54       ', 'R JESUALDO RIBEIRO', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.039-740', '54       ', 'LOT JEUNNE VILLE', 'SAUDE                         ');
INSERT INTO cd_cep_br VALUES ('57.084-530', '54       ', 'R JIRITUBA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.052-450', '54       ', 'R JITAI', 'G LOURDES                     ');
INSERT INTO cd_cep_br VALUES ('57.050-800', '54       ', 'TV JOANA D ARC', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.082-360', '54       ', 'R JOANA DA SILVA LIMA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.041-510', '54       ', 'R JOANA PONTES LIMA', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.042-340', '54       ', 'R JOANA PONTES LINS', 'FEITOSA                       ');
INSERT INTO cd_cep_br VALUES ('57.040-130', '54       ', 'R JOANA RODRIGUES DA SILVA', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.041-110', '54       ', 'R JOANINHA MACARIO', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.015-310', '54       ', 'CJ JOANISIO OMENA', 'V LAGO                        ');
INSERT INTO cd_cep_br VALUES ('57.072-280', '54       ', 'R JOAO BARROSO DA SILVA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.061-660', '54       ', 'R JOAO BATISTA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.014-490', '54       ', 'R JOAO BATISTA DOS SANTOS', 'V LAGO                        ');
INSERT INTO cd_cep_br VALUES ('57.015-730', '54       ', 'R JOAO BEDA MAIA GOMES', 'P GROSSA                      ');
INSERT INTO cd_cep_br VALUES ('57.072-750', '54       ', 'R JOAO BERNARDINO DE OLIVEIRA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.084-220', '54       ', 'R JOAO BEZERRA COSTA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.061-690', '54       ', 'R JOAO CALHEIROS', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.014-090', '54       ', 'R JOAO CALHEIROS GATO', 'P GROSSA                      ');
INSERT INTO cd_cep_br VALUES ('57.030-120', '54       ', 'R JOAO CAMERINO', 'PAJUCARA                      ');
INSERT INTO cd_cep_br VALUES ('57.038-300', '54       ', 'R JOAO CANUTO DA SILVA', 'C ALMAS                       ');
INSERT INTO cd_cep_br VALUES ('57.046-740', '54       ', 'R JOAO CARVALHO GAMA', 'B DURO                        ');
INSERT INTO cd_cep_br VALUES ('57.080-630', '54       ', 'R JOAO CARVALHO PEDROSA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.046-810', '54       ', 'R JOAO CORREIA COSTA', 'SERRARIA                      ');
INSERT INTO cd_cep_br VALUES ('57.050-450', '54       ', 'R JOAO DANTAS BARRETO', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.037-000', '54       ', 'AV JOAO DAVINO', 'JATIUCA                       ');
INSERT INTO cd_cep_br VALUES ('57.037-010', '54       ', 'TV JOAO DAVINO', 'MANGABEIRAS                   ');
INSERT INTO cd_cep_br VALUES ('57.080-440', '54       ', 'R JOAO DE CARVALHO PEDROSA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.072-060', '54       ', 'R JOAO DE OLIVEIRA MELO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.082-140', '54       ', 'R JACI MELO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.025-645', '54       ', 'LD JACINTO DE ATAIDE', 'POCO                          ');
INSERT INTO cd_cep_br VALUES ('57.062-130', '54       ', 'AL JACINTO JOSE SANTANA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.084-200', '54       ', 'R JACIRA ROCHA CAVALCANTI MONTENEGRO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.036-610', '54       ', 'R JADER IZIDIO MALTA DE ARAUJO', 'JATIUCA                       ');
INSERT INTO cd_cep_br VALUES ('57.040-330', '54       ', 'R JAIME FRAGOSO', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.041-220', '54       ', 'R JAIME XAVIER', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.082-310', '54       ', 'R JAIRO MARQUES LUZ', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.030-000', '54       ', 'R JANGADEIROS ALAGOANOS', 'PAJUCARA                      ');
INSERT INTO cd_cep_br VALUES ('57.052-690', '54       ', 'R JAPSON ALMEIDA(RUA C LOT EVANDRO P MIRANDA)', 'G LOURDES                     ');
INSERT INTO cd_cep_br VALUES ('57.081-060', '54       ', 'R JAPURA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.084-680', '54       ', 'R JAQUEIRA (LOT PARQUE DAS ARVORES)', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.075-110', '54       ', 'R JAQUELINE SEVERO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.041-500', '54       ', 'R JARBAS DE ANDRADE CABRAL', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.057-665', '54       ', 'TV JARDIM ALAGOAS', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.057-660', '54       ', 'R JARDIM ALAGOAS', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.046-790', '54       ', 'LOT JARDIM ARISTIDES', 'SERRARIA                      ');
INSERT INTO cd_cep_br VALUES ('57.038-330', '54       ', 'CJ JARDIM BEIRA MAR', 'C ALMAS                       ');
INSERT INTO cd_cep_br VALUES ('57.046-490', '54       ', 'SIT JARDIM CAMELOPOLIS', 'SERRARIA                      ');
INSERT INTO cd_cep_br VALUES ('57.055-820', '54       ', 'CJ JARDIM DAS ACACIAS', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.015-530', '54       ', 'CJ JARDIM ESPERANCA', 'V LAGO                        ');
INSERT INTO cd_cep_br VALUES ('57.057-160', '54       ', 'R JOSE BARBOSA GOMES', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.057-170', '54       ', 'R JOSE BARRETO', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.057-175', '54       ', 'TV JOSE BARRETO', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.052-150', '54       ', 'PC JOSE BARRETO', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.072-790', '54       ', 'R JOSE BARROS DA SILVA (CJ CIDADE UNIVERSITARIA)', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.015-620', '54       ', 'R JOSE BERNARDO DE LIMA(ANTIGA RUA VENCESLAU LIN', 'LEVADA                        ');
INSERT INTO cd_cep_br VALUES ('57.055-200', '54       ', 'R JOSE BEZERRA CALHEIROS(ANTIGA RUA PROGRESSO/DE', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.020-080', '54       ', 'R JOSE BONIFACIO', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.083-090', '54       ', 'R JOSE BRITO LISBOA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.080-610', '54       ', 'R JOSE CALHEIROS', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.014-530', '54       ', 'R JOSE CAMELO DE FREITAS', 'V LAGO                        ');
INSERT INTO cd_cep_br VALUES ('57.020-170', '54       ', 'R JOAO SEVERIANO', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.045-480', '54       ', 'R JOAO SORIANO DO BONFIM', 'B DURO                        ');
INSERT INTO cd_cep_br VALUES ('57.031-130', '54       ', 'PC JOAO TEIXEIRA VASCONCELOS', 'POCO                          ');
INSERT INTO cd_cep_br VALUES ('57.084-490', '54       ', 'R JOAO TORRES DANTAS', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.038-310', '54       ', 'R JOAO ULISSES MOREIRA', 'C ALMAS                       ');
INSERT INTO cd_cep_br VALUES ('57.042-350', '54       ', 'R JOAO XAVIER DE ARAUJO', 'B VISTA                       ');
INSERT INTO cd_cep_br VALUES ('57.025-310', '54       ', 'PC JOAO XXIII', 'POCO                          ');
INSERT INTO cd_cep_br VALUES ('57.020-770', '54       ', 'R JOAQUIM ANTONIO DE CASTRO', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.017-560', '54       ', 'R JOAQUIM FERREIRA DE BARROS', 'BEBEDOURO                     ');
INSERT INTO cd_cep_br VALUES ('57.040-640', '54       ', 'R JOAQUIM JERONIMO', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.014-510', '54       ', 'CJ JOAQUIM LEAO', 'P GROSSA                      ');
INSERT INTO cd_cep_br VALUES ('57.057-320', '54       ', 'PC JOAQUIM MARQUES LUZ', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.037-070', '54       ', 'R JOAQUIM MARQUES LUZ', 'MANGABEIRAS                   ');
INSERT INTO cd_cep_br VALUES ('57.051-410', '54       ', 'R JOAQUIM NABUCO', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.051-415', '54       ', 'TV JOAQUIM NABUCO', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.025-680', '54       ', 'R JOAQUIM PEDRO DOS SANTOS', 'POCO                          ');
INSERT INTO cd_cep_br VALUES ('57.045-710', '54       ', 'R JOAQUIM PERCIANO', 'B DURO                        ');
INSERT INTO cd_cep_br VALUES ('57.030-830', '54       ', 'TV JOATAN', 'POCO                          ');
INSERT INTO cd_cep_br VALUES ('57.061-080', '54       ', 'R JOAZEIRO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.042-610', '54       ', 'R JOEL VIEIRA DOS ANJOS(LOTEAMENTO BARILOCHE)', 'FEITOSA                       ');
INSERT INTO cd_cep_br VALUES ('57.036-220', '54       ', 'R JOFRE SAINT-YVES SIMON', 'JATIUCA                       ');
INSERT INTO cd_cep_br VALUES ('57.046-190', '54       ', 'R SUZI NOGUEIRA', 'B DURO                        ');
INSERT INTO cd_cep_br VALUES ('57.025-400', '54       ', 'R TABAJARAS', 'POCO                          ');
INSERT INTO cd_cep_br VALUES ('57.011-160', '54       ', 'R TABELIAO EURICLES PROTASIO', 'T BARRA                       ');
INSERT INTO cd_cep_br VALUES ('57.055-430', '54       ', 'R GALDINO RAMOS VASCONCELOS', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.072-740', '54       ', 'CJ GAMA LINS', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.039-770', '54       ', 'LOT GAMELEIRA', 'F PEIXOTO                     ');
INSERT INTO cd_cep_br VALUES ('57.039-760', '54       ', 'R GAMELEIRA', 'F PEIXOTO                     ');
INSERT INTO cd_cep_br VALUES ('57.039-780', '54       ', 'TV GAMELEIRA MIRIM', 'F PEIXOTO                     ');
INSERT INTO cd_cep_br VALUES ('57.084-610', '54       ', 'AV GARCA TORTA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.035-100', '54       ', 'R GASPAR FERRARI', 'P VERDE                       ');
INSERT INTO cd_cep_br VALUES ('57.080-130', '54       ', 'R GAZETA DE ALAGOAS', 'CANAA                         ');
INSERT INTO cd_cep_br VALUES ('57.014-640', '54       ', 'AV GENERAL ALCIR WERNER', 'V LAGO                        ');
INSERT INTO cd_cep_br VALUES ('57.039-000', '54       ', 'AV GENERAL FRANCA ALBUQUERQUE', 'JACARECICA                    ');
INSERT INTO cd_cep_br VALUES ('57.017-000', '54       ', 'R GENERAL HERMES', 'B PARTO                       ');
INSERT INTO cd_cep_br VALUES ('57.047-030', '54       ', 'R GENERAL JOAO JOSE BATISTA TUBINO', 'SERRARIA                      ');
INSERT INTO cd_cep_br VALUES ('57.035-210', '54       ', 'R GENERAL JOAO SALEIRO PITAO', 'P VERDE                       ');
INSERT INTO cd_cep_br VALUES ('57.036-190', '54       ', 'R GENERAL JOSE PORTUGAL RAMALHO', 'JATIUCA                       ');
INSERT INTO cd_cep_br VALUES ('57.045-460', '54       ', 'R GENERAL MARIO CARVALHO LIMA', 'B DURO                        ');
INSERT INTO cd_cep_br VALUES ('57.014-470', '54       ', 'AV GENERAL MARIO LIMA', 'V LAGO                        ');
INSERT INTO cd_cep_br VALUES ('57.036-580', '54       ', 'R GENERAL NEWTON DE ANDRADE CAVALCANTE', 'JATIUCA                       ');
INSERT INTO cd_cep_br VALUES ('57.055-310', '54       ', 'R GENERAL PORTUGAL RAMALHO', 'PINHEIRO                      ');
INSERT INTO cd_cep_br VALUES ('57.036-880', '54       ', 'R GENERAL PORTUGAL RAMALHO', 'JATIUCA                       ');
INSERT INTO cd_cep_br VALUES ('57.017-770', '54       ', 'R GENESIO BARBOSA CARNAUBA', 'BEBEDOURO                     ');
INSERT INTO cd_cep_br VALUES ('57.071-480', '54       ', 'CJ GENTIL MALTA', 'A S DUMONT                    ');
INSERT INTO cd_cep_br VALUES ('57.085-060', '54       ', 'AV GERALDO BULHOES', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.060-090', '54       ', 'R GERALDO FERREIRA DOS SANTOS', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.060-660', '54       ', 'R GERALDO NOVAES CASTRO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.055-050', '54       ', 'R GERCINO MOREIRA', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.051-320', '54       ', 'R GEREMIAS PORCIUNCULA', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.052-100', '54       ', 'R GERMANO LOPES CORDEIRO', 'G LOURDES                     ');
INSERT INTO cd_cep_br VALUES ('57.057-130', '54       ', 'PRQ GERTRUDES DE AMORIM LEAO', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.039-680', '54       ', 'R GERUSA RODRIGUES BASTOS', 'F PEIXOTO                     ');
INSERT INTO cd_cep_br VALUES ('57.082-740', '54       ', 'AV GETSEMANE', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.015-340', '54       ', 'R GETULIO CORREIA LIMA', 'V LAGO                        ');
INSERT INTO cd_cep_br VALUES ('57.075-310', '54       ', 'R GILBERTO MARINHO(QUADRA B5/B6 CJ OSMAN LOUREIR', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.048-260', '54       ', 'AV GILBERTO SOARES PINTO(LOT TERRA DE ANTARES I)', 'ANTARES                       ');
INSERT INTO cd_cep_br VALUES ('57.060-100', '54       ', 'R GILBERTO VIEIRA LEITE', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.042-050', '54       ', 'LOT GIRASSOL', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.082-750', '54       ', 'R GLEIDE PEREIRA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.020-570', '54       ', 'R GODOFREDO FERRO', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.061-730', '54       ', 'R FOTOGRAFO PEDRO FARIAS(LOT LAGOA AZUL)', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.020-560', '54       ', 'R FRANCA MOREL', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.073-170', '54       ', 'R FRANCISCA AMELIA DE SANTANA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('12.929-360', '4897     ', 'R PROJETADA', 'JD PATURI                     ');
INSERT INTO cd_cep_br VALUES ('57.081-370', '54       ', 'AV FRANCISCO AFONSO DE MELO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.045-450', '54       ', 'R FRANCISCO AGUIRRE CAMARGO', 'B DURO                        ');
INSERT INTO cd_cep_br VALUES ('57.081-140', '54       ', 'R FRANCISCO ALVES', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.036-180', '54       ', 'R FRANCISCO ALVES MATTA', 'JATIUCA                       ');
INSERT INTO cd_cep_br VALUES ('57.030-510', '54       ', 'TV FRANCISCO ARAUJO', 'POCO                          ');
INSERT INTO cd_cep_br VALUES ('57.017-790', '54       ', 'R FRANCISCO BRAGA QUINTELA CAVALCANTI', 'B PARTO                       ');
INSERT INTO cd_cep_br VALUES ('57.055-520', '54       ', 'PC FRANCISCO DE GOES', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.017-085', '54       ', 'TV FRANCISCO DE MENEZES', 'B PARTO                       ');
INSERT INTO cd_cep_br VALUES ('57.017-075', '54       ', 'AV FRANCISCO DE MENEZES- ATE 610/611', 'LEVADA                        ');
INSERT INTO cd_cep_br VALUES ('57.039-060', '54       ', 'R IGESSY MARINHO ROCHA', 'JACARECICA                    ');
INSERT INTO cd_cep_br VALUES ('57.039-530', '54       ', 'R IGREJA, DA', 'F PEIXOTO                     ');
INSERT INTO cd_cep_br VALUES ('57.070-220', '54       ', 'R IGREJA, DA', 'R NOVO                        ');
INSERT INTO cd_cep_br VALUES ('57.042-060', '54       ', 'LOT IGUACU', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.041-480', '54       ', 'R ILDEFONSO PEREIRA DE MELO', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.052-410', '54       ', 'R IMBUIA', 'G LOURDES                     ');
INSERT INTO cd_cep_br VALUES ('57.052-420', '54       ', 'R IMBURANA', 'G LOURDES                     ');
INSERT INTO cd_cep_br VALUES ('57.070-320', '54       ', 'R IMIDIA BARBOSA', 'F VELHO                       ');
INSERT INTO cd_cep_br VALUES ('57.020-670', '54       ', 'R IMPERADOR, DO', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.025-490', '54       ', 'R INACIO CALMON', 'POCO                          ');
INSERT INTO cd_cep_br VALUES ('57.030-520', '54       ', 'R INACIO GRACINDO', 'POCO                          ');
INSERT INTO cd_cep_br VALUES ('57.041-490', '54       ', 'R INACIO VESPASIANO FERREIRA', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.062-650', '54       ', 'R INAH TORRES ASSUNCAO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.071-680', '54       ', 'AV INAILDA FELIX DE OLIVEIRA SANTOS', 'A S DUMONT                    ');
INSERT INTO cd_cep_br VALUES ('57.020-410', '54       ', 'PC INDEPENDENCIA, DA', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.040-165', '54       ', 'R INDIANA', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.080-260', '54       ', 'R INDUSTRIAL ALOISIO NOGUEIRA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.046-280', '54       ', 'PC INDUSTRIAL ANTONIO CORREIA DA SILVA', 'B DURO                        ');
INSERT INTO cd_cep_br VALUES ('57.036-210', '54       ', 'R INDUSTRIAL BRENO LINS CANSANCAO', 'JATIUCA                       ');
INSERT INTO cd_cep_br VALUES ('57.036-590', '54       ', 'R INDUSTRIAL CLIMERIO SARMENTO', 'JATIUCA                       ');
INSERT INTO cd_cep_br VALUES ('57.017-820', '54       ', 'R GUEDES', 'B PARTO                       ');
INSERT INTO cd_cep_br VALUES ('57.020-260', '54       ', 'R GUEDES GONDIM', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.030-110', '54       ', 'R GUEDES LINS', 'PAJUCARA                      ');
INSERT INTO cd_cep_br VALUES ('57.014-320', '54       ', 'PC GUEDES MIRANDA', 'P GROSSA                      ');
INSERT INTO cd_cep_br VALUES ('57.020-400', '54       ', 'R GUIDO DUARTE', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.041-450', '54       ', 'R GUILHERME ROGATO', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.010-400', '54       ', 'R GUILHERME ROGATO', 'T BARRA                       ');
INSERT INTO cd_cep_br VALUES ('57.025-480', '54       ', 'PC GUIMARAES PASSOS', 'POCO                          ');
INSERT INTO cd_cep_br VALUES ('57.041-460', '54       ', 'R GUIMARAES ROSAS', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.073-290', '54       ', 'R GUIOMAR CUNHA LOU MENEZES', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.062-570', '54       ', 'AL GUIOMAR OMENA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.061-720', '54       ', 'R GUIOMAR PACHECO PONTES AMORIM(LOT LAGOA AZUL)', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.039-240', '54       ', 'LOT GURGURI', 'R DOCE                        ');
INSERT INTO cd_cep_br VALUES ('57.075-020', '54       ', 'CJ GURGURY', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.075-030', '54       ', 'CJ GURIATA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.031-120', '54       ', 'R HAIDAN GOULART', 'POCO                          ');
INSERT INTO cd_cep_br VALUES ('57.035-410', '54       ', 'R HAMILTON DE BARROS SOUTINHO(ANTIGA RUA SANTO A', 'JATIUCA                       ');
INSERT INTO cd_cep_br VALUES ('57.072-380', '54       ', 'CJ HAMILTON DE CARVALHO MORAES', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.082-230', '54       ', 'R HAMILTON MORAIS', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.051-350', '54       ', 'R HARMONIA, DA', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.071-030', '54       ', 'R HAROLDO DE AZEVEDO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.071-035', '54       ', 'TV HAROLDO DE AZEVEDO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.041-470', '54       ', 'R HAROLDO JOSE COSTA', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.038-290', '54       ', 'R HAVAI', 'C ALMAS                       ');
INSERT INTO cd_cep_br VALUES ('57.082-180', '54       ', 'R HECKEL TAVARES', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.081-110', '54       ', 'R HELIO BASILIO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.072-520', '54       ', 'R HELIO DA SILVA WANDERLEY', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.080-480', '54       ', 'AV HELIO DE CASTRO VASCONCELOS', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.010-001', '54       ', 'AV SIQUEIRA CAMPOS- DE 1031 AO FIM - LADO IMPAR', 'PRADO                         ');
INSERT INTO cd_cep_br VALUES ('57.055-390', '54       ', 'R SARGENTO ALDO ALMEIDA', 'PINHEIRO                      ');
INSERT INTO cd_cep_br VALUES ('57.063-190', '54       ', 'R LIBERALINO RIBEIRO DE ALMEIDA(LOT CIPESA)', 'S AMELIA                      ');
INSERT INTO cd_cep_br VALUES ('57.083-140', '54       ', 'AV LIBERATO MITCHEL', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.042-090', '54       ', 'R LIBERDADE, DA', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.062-780', '54       ', 'R LIBERDADE, DA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.030-310', '54       ', 'PC LIONS', 'P TERRA                       ');
INSERT INTO cd_cep_br VALUES ('57.041-570', '54       ', 'R LIONS CLUB', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.017-420', '54       ', 'R LIRA, DA', 'BEBEDOURO                     ');
INSERT INTO cd_cep_br VALUES ('57.017-425', '54       ', 'TV LIRA, DA', 'BEBEDOURO                     ');
INSERT INTO cd_cep_br VALUES ('57.043-590', '54       ', 'LOT LISBOA', 'FEITOSA                       ');
INSERT INTO cd_cep_br VALUES ('57.039-080', '54       ', 'AV LITORANEA', 'JACARECICA                    ');
INSERT INTO cd_cep_br VALUES ('57.051-440', '54       ', 'R LIVRAMENTO, DO', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.020-030', '54       ', 'R LIVRAMENTO, DO', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.073-330', '54       ', 'R LIZETE TEIXEIRA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.084-740', '54       ', 'LOT LOTEAMENTO CELI LOUREIRO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.035-360', '54       ', 'R LOURENCO MOREIRA DA SILVA', 'P VERDE                       ');
INSERT INTO cd_cep_br VALUES ('57.046-770', '54       ', 'R LOURIVAL DE AGUIAR PESSOA', 'SERRARIA                      ');
INSERT INTO cd_cep_br VALUES ('57.060-140', '54       ', 'R LOURIVAL DE SOUZA BARROS', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.072-000', '54       ', 'AV LOURIVAL MELO MOTA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.011-150', '54       ', 'R LOURIVAL VIEIRA COSTA(ANTIGA RUA SAO DOMINGOS)', 'PRADO                         ');
INSERT INTO cd_cep_br VALUES ('57.045-180', '54       ', 'R LUCIA MARIA FLAMARION DA CUNHA MOREIRA', 'SERRARIA                      ');
INSERT INTO cd_cep_br VALUES ('57.045-280', '54       ', 'R LUCILO SIMOES DE SOUZA', 'B DURO                        ');
INSERT INTO cd_cep_br VALUES ('57.080-580', '54       ', 'R LUIS CARLOS BASTOS', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.046-580', '54       ', 'R LUIS DE MOURAQD E RUA F LOT JD STA ANA', 'SERRARIA                      ');
INSERT INTO cd_cep_br VALUES ('57.075-350', '54       ', 'R LUIS DIONISIO COSTA(RUA 15 CJ OSMAN LOUREIRO)', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.073-390', '54       ', 'R LUIZ ALAPENHA AMARAL', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.031-190', '54       ', 'R LUIZ ALBERTO BARREIROS', 'POCO                          ');
INSERT INTO cd_cep_br VALUES ('57.060-500', '54       ', 'R LUIZ ALVES DA SILVA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.082-370', '54       ', 'R LUIZ BINA XAVIER', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.030-360', '54       ', 'R LUIZ CAMPOS TEIXEIRA- ATE 762/763', 'P TERRA                       ');
INSERT INTO cd_cep_br VALUES ('57.031-540', '54       ', 'R LUIZ CAMPOS TEIXEIRA- DE 764/765 AO FIM', 'P VERDE                       ');
INSERT INTO cd_cep_br VALUES ('57.038-550', '54       ', 'R LUIZ CARLOS BRAGA NETO', 'C ALMAS                       ');
INSERT INTO cd_cep_br VALUES ('57.083-490', '54       ', 'R LUIZ CARLOS CALAZANS PACHECO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.043-290', '54       ', 'R LUIZ CARLOS PONTES', 'FEITOSA                       ');
INSERT INTO cd_cep_br VALUES ('57.072-580', '54       ', 'R LUIZ CERQUEIRA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.071-040', '54       ', 'R LUIZ CLEMENTE VASCONCELOS', 'A S DUMONT                    ');
INSERT INTO cd_cep_br VALUES ('57.084-550', '54       ', 'R JUCARA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.061-650', '54       ', 'R JUDSON ROOSEVELT CABRAL', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.073-090', '54       ', 'R JUIZ ALAPENHA AMARAL', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.073-370', '54       ', 'AV JULIA CAMELO DE FREITAS', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.072-200', '54       ', 'R JULIA TENORIO DE OLIVEIRA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.076-030', '54       ', 'R JULIA VIEIRA SANDES', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.040-340', '54       ', 'R JULIO AUTO', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.040-345', '54       ', 'TV JULIO AUTO', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.036-260', '54       ', 'R JULIO DE ALMEIDA BRAGA', 'JATIUCA                       ');
INSERT INTO cd_cep_br VALUES ('57.072-590', '54       ', 'R JULIO FERREIRA DE MELO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.062-330', '54       ', 'AL JULIO LEITE', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.061-300', '54       ', 'R JULIO LIMA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.035-420', '54       ', 'AV JULIO MARQUES LUZ', 'JATIUCA                       ');
INSERT INTO cd_cep_br VALUES ('57.051-430', '54       ', 'R JULIO MENDES', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.062-070', '54       ', 'AL JULIO PEREIRA DOS SANTOS', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.030-250', '54       ', 'R JULIO PLECH FILHO', 'P TERRA                       ');
INSERT INTO cd_cep_br VALUES ('57.072-470', '54       ', 'R JULIO VIEIRA SANDES', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.080-050', '54       ', 'R JUNDIA', 'CANAA                         ');
INSERT INTO cd_cep_br VALUES ('57.041-560', '54       ', 'R JURANDIR GOMES', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.081-070', '54       ', 'R JUREMA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.040-485', '54       ', 'LOT JUSSARA', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.072-230', '54       ', 'R LADISLAU VIEIRA SARMENTO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.045-080', '54       ', 'R LAERTE LEAO', 'B DURO                        ');
INSERT INTO cd_cep_br VALUES ('57.030-355', '54       ', 'TV LAFAIETE PACHECO', 'PAJUCARA                      ');
INSERT INTO cd_cep_br VALUES ('57.030-350', '54       ', 'R LAFAIETE PACHECO', 'PAJUCARA                      ');
INSERT INTO cd_cep_br VALUES ('57.061-310', '54       ', 'R LAGOA SECA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.071-705', '54       ', 'R LAJEDO SILVA', 'A S DUMONT                    ');
INSERT INTO cd_cep_br VALUES ('57.070-060', '54       ', 'R LAPINHA, DA', 'F VELHO                       ');
INSERT INTO cd_cep_br VALUES ('57.015-320', '54       ', 'R LARGO DA PAZ', 'V LAGO                        ');
INSERT INTO cd_cep_br VALUES ('57.015-325', '54       ', 'TV LARGO DA PAZ', 'V LAGO                        ');
INSERT INTO cd_cep_br VALUES ('13.040-060', '4802     ', 'R CORONEL JOB DE FIGUEIREDO', 'JD N EUROPA                   ');
INSERT INTO cd_cep_br VALUES ('57.073-140', '54       ', 'R LAURA MORAES GUEDES NOGUEIRA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.071-300', '54       ', 'R LAURO BRANDAO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.030-300', '54       ', 'R LAURO LEITE MARTINS', 'POCO                          ');
INSERT INTO cd_cep_br VALUES ('57.018-210', '54       ', 'R MAJOR JOSE ARESTIDES BARROS', 'BEBEDOURO                     ');
INSERT INTO cd_cep_br VALUES ('57.041-580', '54       ', 'R MAJOR JOSE JOAQUIM CALHEIROS', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.037-420', '54       ', 'R MAJOR LOURENCO DE ALENCAR', 'MANGABEIRAS                   ');
INSERT INTO cd_cep_br VALUES ('57.076-020', '54       ', 'R MAJOR NELSON CIPRIANO DOS SANTOS', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.070-030', '54       ', 'R MAJOR PRADO', 'F VELHO                       ');
INSERT INTO cd_cep_br VALUES ('57.061-520', '54       ', 'R MAJOR RAUL DA CUNHA PINTO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.045-520', '54       ', 'R MAJOR TENORIO LINS', 'B DURO                        ');
INSERT INTO cd_cep_br VALUES ('57.050-460', '54       ', 'R MAJOR VICENTE SABINO', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.011-410', '54       ', 'R MANAUS- ATE 605/616', 'PRADO                         ');
INSERT INTO cd_cep_br VALUES ('57.010-160', '54       ', 'R MANAUS- DE 607/618 AO FIM', 'PRADO                         ');
INSERT INTO cd_cep_br VALUES ('57.055-870', '54       ', 'PC MANGUABA', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.074-090', '54       ', 'R MANGUEIRA (LOT PARQUE DAS ARVORES)', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.015-330', '54       ', 'R MANGUEIRA, DA', 'V LAGO                        ');
INSERT INTO cd_cep_br VALUES ('57.052-180', '54       ', 'AL MANHAES', 'G LOURDES                     ');
INSERT INTO cd_cep_br VALUES ('57.081-280', '54       ', 'R MANOEL AFONSO DE MELO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.018-490', '54       ', 'R MANOEL ALMEIDA', 'BEBEDOURO                     ');
INSERT INTO cd_cep_br VALUES ('57.082-130', '54       ', 'R MANOEL ALVES DA SILVA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.046-290', '54       ', 'R MANOEL AMERICO DA SILVA', 'B DURO                        ');
INSERT INTO cd_cep_br VALUES ('57.060-670', '54       ', 'R MANOEL ANTONIO DA SILVA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.041-600', '54       ', 'R MANOEL BANDEIRA', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.051-460', '54       ', 'R MANOEL BARBOSA CALHEIROS', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.055-240', '54       ', 'R MANOEL CASADO DE MELO', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.060-510', '54       ', 'R MANOEL CELESTINO SOBRAL', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.041-740', '54       ', 'R MANOEL COELHO NETO', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.082-190', '54       ', 'R MANOEL CORREIA DA COSTA NETO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.010-550', '54       ', 'R MANOEL CORREIA DE CERQUEIRA', 'T BARRA                       ');
INSERT INTO cd_cep_br VALUES ('57.046-300', '54       ', 'R MANOEL CORREIA DE OLIVEIRA', 'SERRARIA                      ');
INSERT INTO cd_cep_br VALUES ('57.081-440', '54       ', 'R MANOEL DE ARAUJO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.030-105', '54       ', 'PC MANOEL DUARTE', 'PAJUCARA                      ');
INSERT INTO cd_cep_br VALUES ('57.040-810', '54       ', 'R MANOEL ERIBERTO', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.057-380', '54       ', 'R MANOEL FLORENTINO DA SILVA', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.601-010', '40       ', 'R JOSE PINTO DE BARROS', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.062-230', '54       ', 'AL NAIR DE VASCONCELOS CAVALCANTI', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.072-670', '54       ', 'R NAPOLEAO LOPES ARROXELAS', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.035-440', '54       ', 'R NAPOLEAO VIANA DE OLIVEIRA', 'JATIUCA                       ');
INSERT INTO cd_cep_br VALUES ('57.071-430', '54       ', 'R NARCISO SEBASTIAO DA SILVA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.060-850', '54       ', 'R NASCENCA, DA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.084-460', '54       ', 'R NEDDA RAMALHO DE CASTRO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.081-020', '54       ', 'R ITARARE', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.082-810', '54       ', 'R NEDSON CORREIA DE SOUZA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.037-100', '54       ', 'R NELSON DE AZEVEDO SOUZA', 'MANGABEIRAS                   ');
INSERT INTO cd_cep_br VALUES ('57.045-570', '54       ', 'AV NELSON MARINHO DE ARAUJO', 'B DURO                        ');
INSERT INTO cd_cep_br VALUES ('57.082-170', '54       ', 'R NEWTON ALVES COELHO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.050-640', '54       ', 'R NILO PECANHA TORRES', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.050-820', '54       ', 'R NILO TORRES', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.043-320', '54       ', 'R NITEROI', 'FEITOSA                       ');
INSERT INTO cd_cep_br VALUES ('57.043-325', '54       ', 'TV NITEROI', 'FEITOSA                       ');
INSERT INTO cd_cep_br VALUES ('57.045-815', '54       ', 'R NITEROI', 'B DURO                        ');
INSERT INTO cd_cep_br VALUES ('57.042-560', '54       ', 'R NOEMIA CAMPOS', 'B VISTA                       ');
INSERT INTO cd_cep_br VALUES ('57.072-430', '54       ', 'R MIGUEL PEREIRA OMENA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.061-600', '54       ', 'AV MIGUEL TORRES', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.037-210', '54       ', 'PC MIGUEL TORRES FILHO', 'JATIUCA                       ');
INSERT INTO cd_cep_br VALUES ('57.035-165', '54       ', 'PC MILTON BUARQUE WANDERLEY', 'P VERDE                       ');
INSERT INTO cd_cep_br VALUES ('57.072-140', '54       ', 'R MINERVINA CORREIA DA SILVA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.037-220', '54       ', 'R MINERVO PIMENTEL', 'JATIUCA                       ');
INSERT INTO cd_cep_br VALUES ('57.039-790', '54       ', 'R MINISTRO LINDOLFO COLLOR', 'F PEIXOTO                     ');
INSERT INTO cd_cep_br VALUES ('57.014-550', '54       ', 'AV MINISTRO MARIO ANDREAZZA', 'V LAGO                        ');
INSERT INTO cd_cep_br VALUES ('57.050-140', '54       ', 'R MINISTRO SALGADO FILHO', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.041-710', '54       ', 'R MIRA MAR', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.010-180', '54       ', 'R MIRAMAR', 'PRADO                         ');
INSERT INTO cd_cep_br VALUES ('57.045-100', '54       ', 'PRQ MIRAMAR', 'B DURO                        ');
INSERT INTO cd_cep_br VALUES ('57.060-270', '54       ', 'R MIRIAN FERNANDES LIMA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.039-630', '54       ', 'R MIRIM, DO', 'SAUDE                         ');
INSERT INTO cd_cep_br VALUES ('57.055-460', '54       ', 'R MISSIONARIO JOHN MEIN', 'PINHEIRO                      ');
INSERT INTO cd_cep_br VALUES ('57.020-600', '54       ', 'R MIZAEL DOMINGUES', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.085-020', '54       ', 'CJ MOACIR ANDRADE', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.014-020', '54       ', 'R MOACIR MIRANDA', 'P GROSSA                      ');
INSERT INTO cd_cep_br VALUES ('57.071-495', '54       ', 'R MOACY DE ALENCAR BARRETO FILHO', 'A S DUMONT                    ');
INSERT INTO cd_cep_br VALUES ('57.052-470', '54       ', 'R MOGNO', 'G LOURDES                     ');
INSERT INTO cd_cep_br VALUES ('57.014-330', '54       ', 'PC MOLEQUE NAMORADOR', 'P GROSSA                      ');
INSERT INTO cd_cep_br VALUES ('57.060-700', '54       ', 'R MONITOR ANTONIO SANTANA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.071-100', '54       ', 'R MONITOR WALTER GOMES COSTA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.020-610', '54       ', 'PC MONSENHOR ANTONIO VALENTE', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.011-110', '54       ', 'R MONSENHOR LUIZ BARBOSA', 'T BARRA                       ');
INSERT INTO cd_cep_br VALUES ('57.018-430', '54       ', 'LOT MONSENHOR TOBIAS', 'BEBEDOURO                     ');
INSERT INTO cd_cep_br VALUES ('57.017-800', '54       ', 'LOT MONSENHOR TOBIAS COSTA', 'BEBEDOURO                     ');
INSERT INTO cd_cep_br VALUES ('57.082-290', '54       ', 'R MONSENHOR VIEIRA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.043-130', '54       ', 'R MONSENHOR WANILO GALVAO', 'FEITOSA                       ');
INSERT INTO cd_cep_br VALUES ('57.018-675', '54       ', 'R MONTE AZUL', 'C JAQUEIRA                    ');
INSERT INTO cd_cep_br VALUES ('57.018-580', '54       ', 'R MONTE CASTELO', 'C JAQUEIRA                    ');
INSERT INTO cd_cep_br VALUES ('57.015-130', '54       ', 'AV MONTE CASTELO', 'V LAGO                        ');
INSERT INTO cd_cep_br VALUES ('57.015-135', '54       ', 'TV MONTE CASTELO', 'V LAGO                        ');
INSERT INTO cd_cep_br VALUES ('57.018-575', '54       ', 'TV MONTE CASTELO', 'C JAQUEIRA                    ');
INSERT INTO cd_cep_br VALUES ('57.018-570', '54       ', 'AV MONTE CASTELO', 'C JAQUEIRA                    ');
INSERT INTO cd_cep_br VALUES ('57.020-350', '54       ', 'PC MONTEPIO DOS ARTISTAS', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.061-330', '54       ', 'CJ MORADA DO BOSQUE', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.061-610', '54       ', 'CJ MORADA DOS PALMARES', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.055-100', '54       ', 'R MARQUES DO HERVAL', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.055-105', '54       ', 'TV MARQUES DO HERVAL', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.039-480', '54       ', 'R MARTINS', 'R DOCE                        ');
INSERT INTO cd_cep_br VALUES ('57.050-290', '54       ', 'R MARTINS MURTA', 'PITANGUINHA                   ');
INSERT INTO cd_cep_br VALUES ('57.051-480', '54       ', 'LD MARTIRIOS, DOS', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.017-750', '54       ', 'AV MARTYRIO ATHAYDE DE OLIVEIRA', 'B PARTO                       ');
INSERT INTO cd_cep_br VALUES ('57.070-400', '54       ', 'R MATA, DA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.038-390', '54       ', 'R OLHO D AGUA DAS FLORES', 'C ALMAS                       ');
INSERT INTO cd_cep_br VALUES ('57.042-070', '54       ', 'R OLIMPIO FAUSTINO', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.015-740', '54       ', 'R OLIMPIO GALVAO', 'P GROSSA                      ');
INSERT INTO cd_cep_br VALUES ('57.036-690', '54       ', 'R OLINDINA CAMPOS TEIXEIRA', 'JATIUCA                       ');
INSERT INTO cd_cep_br VALUES ('57.020-190', '54       ', 'R OLIVEIRA E SILVA', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.062-510', '54       ', 'AL OLIVIA DA SILVA ARAUJO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.072-700', '54       ', 'R OLIVIA FERRO DE MOEMA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.031-420', '54       ', 'R OLIVIA MIRANDA', 'MANGABEIRAS                   ');
INSERT INTO cd_cep_br VALUES ('57.071-720', '54       ', 'R ONELIA CAMPELO DA PAZ', 'A S DUMONT                    ');
INSERT INTO cd_cep_br VALUES ('57.014-180', '54       ', 'PC ONZE NACIONAL', 'P GROSSA                      ');
INSERT INTO cd_cep_br VALUES ('57.025-540', '54       ', 'R OPERARIOS, DOS', 'POCO                          ');
INSERT INTO cd_cep_br VALUES ('57.055-250', '54       ', 'R ORIENTE, DO', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.073-110', '54       ', 'R ORLANDO GALDINO LOPES', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.046-310', '54       ', 'R ORTIGIA ARTUR JUCA ARBAGE', 'B DURO                        ');
INSERT INTO cd_cep_br VALUES ('57.015-270', '54       ', 'R OSCALINA MARIA DA SILVA', 'V LAGO                        ');
INSERT INTO cd_cep_br VALUES ('57.060-300', '54       ', 'R OSCAR CARNEIRO SIMOES', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.061-500', '54       ', 'R OSEAS SANTOS', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.071-330', '54       ', 'CJ OSMAN LOUREIRO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.050-320', '54       ', 'PC OSORIO CALHEIROS GATO', 'PITANGUINHA                   ');
INSERT INTO cd_cep_br VALUES ('57.018-810', '54       ', 'TV OSVALDO CRUZ', 'BEBEDOURO                     ');
INSERT INTO cd_cep_br VALUES ('57.082-820', '54       ', 'AV OSVALDO RAMOS', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.051-510', '54       ', 'R OSVALDO SARMENTO', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.080-490', '54       ', 'R OSWALDO VELOSO ROSA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.073-520', '54       ', 'AV OTACILIO HOLANDA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.041-180', '54       ', 'R OTACILIO PEREIRA WANDERLEY', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.039-390', '54       ', 'R NOEMIA GAMA RAMALHO', 'JACARECICA                    ');
INSERT INTO cd_cep_br VALUES ('57.043-560', '54       ', 'R NOEMIA MAGALHAES DE OLIVEIRA', 'FEITOSA                       ');
INSERT INTO cd_cep_br VALUES ('57.084-650', '54       ', 'AV NORMA PIMENTEL DA COSTA (RES BENEDITO BENTES I', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.081-480', '54       ', 'R NOSSA SENHORA APARECIDA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.071-565', '54       ', 'R NOSSA SENHORA APARECIDA', 'A S DUMONT                    ');
INSERT INTO cd_cep_br VALUES ('57.042-510', '54       ', 'R NOSSA SENHORA APARECIDA', 'FEITOSA                       ');
INSERT INTO cd_cep_br VALUES ('57.082-490', '54       ', 'CJ NOSSA SENHORA DA APARECIDA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.018-250', '54       ', 'R NOSSA SENHORA DA CONCEICAO', 'BEBEDOURO                     ');
INSERT INTO cd_cep_br VALUES ('57.018-255', '54       ', 'TV NOSSA SENHORA DA CONCEICAO', 'BEBEDOURO                     ');
INSERT INTO cd_cep_br VALUES ('57.055-110', '54       ', 'R NOSSA SENHORA DA CONCEICAO', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.081-470', '54       ', 'R NOSSA SENHORA DA CONCEICAO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.052-130', '54       ', 'R JOAO PAULO I', 'G LOURDES                     ');
INSERT INTO cd_cep_br VALUES ('69.098-500', '156      ', 'R 237 (NUCLEO 24)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.098-510', '156      ', 'R 238 (NUCLEO 24)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.098-520', '156      ', 'R 239 (NUCLEO 24)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('57.018-560', '54       ', 'R MANOEL INACIO', 'C JAQUEIRA                    ');
INSERT INTO cd_cep_br VALUES ('57.018-565', '54       ', 'TV MANOEL INACIO', 'C JAQUEIRA                    ');
INSERT INTO cd_cep_br VALUES ('57.055-090', '54       ', 'R MANOEL LEAL', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.057-200', '54       ', 'R LUIZ COSTA MEDEIROS', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.014-460', '54       ', 'AV LUIZ DE ALMEIDA FARIAS', 'V LAGO                        ');
INSERT INTO cd_cep_br VALUES ('57.045-500', '54       ', 'R LUIZ DE FRANCA VERGETTI', 'B DURO                        ');
INSERT INTO cd_cep_br VALUES ('57.062-110', '54       ', 'AL LUIZ DE SOUZA ASSIS', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.038-100', '54       ', 'R LUIZ FRANCISCO CEDRIM', 'MANGABEIRAS                   ');
INSERT INTO cd_cep_br VALUES ('57.046-150', '54       ', 'R LUIZ GONZAGA DA SILVA', 'B DURO                        ');
INSERT INTO cd_cep_br VALUES ('57.062-120', '54       ', 'AL LUIZ GONZAGA DA SILVA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.080-170', '54       ', 'R LUIZ GONZAGA DE SA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.080-390', '54       ', 'R LUIZ GONZAGA SILVEIRA DE CARVALHO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.036-650', '54       ', 'R LUIZ LOPES AGRA', 'JATIUCA                       ');
INSERT INTO cd_cep_br VALUES ('57.072-730', '54       ', 'R LUIZ LOPES PONTES', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.084-400', '54       ', 'R LUIZ PEREIRA LIMA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.036-380', '54       ', 'AV LUIZ RAMALHO DE CASTRO', 'JATIUCA                       ');
INSERT INTO cd_cep_br VALUES ('57.040-660', '54       ', 'R LUIZ REGO BARROS', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.057-540', '54       ', 'R LUIZ RIZZO', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.081-080', '54       ', 'R LUIZ SANTOS DE CARVALHO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.062-460', '54       ', 'AL LUIZ XAVIER DE CARVALHO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.036-270', '54       ', 'R LUIZA MEDEIROS', 'JATIUCA                       ');
INSERT INTO cd_cep_br VALUES ('57.062-560', '54       ', 'AL LUIZA SURUAGY', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.080-250', '54       ', 'PC LUMAR FONSECA MACHADO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.062-600', '54       ', 'AL LUZIA DE SOUZA ASSIS', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.017-200', '54       ', 'R LUZIA SURUAGY', 'LEVADA                        ');
INSERT INTO cd_cep_br VALUES ('57.017-205', '54       ', 'TV LUZIA SURUAGY', 'LEVADA                        ');
INSERT INTO cd_cep_br VALUES ('57.083-210', '54       ', 'R LUZINETE UCHOA FRAGOSO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.052-460', '54       ', 'R MACARANDUBA', 'G LOURDES                     ');
INSERT INTO cd_cep_br VALUES ('57.022-080', '54       ', 'AV MACEIO', 'JARAGUA                       ');
INSERT INTO cd_cep_br VALUES ('57.061-110', '54       ', 'AV MACEIO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.041-690', '54       ', 'R MACHADO DE ASSIS', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.035-120', '54       ', 'R MACHADO LEMOS', 'P VERDE                       ');
INSERT INTO cd_cep_br VALUES ('57.060-690', '54       ', 'R MACINO COSTA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.014-540', '54       ', 'PC MAESTRO ANTONIO PAURILIO', 'P GROSSA                      ');
INSERT INTO cd_cep_br VALUES ('57.081-600', '54       ', 'R MAGDA DANIELLE', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.060-760', '54       ', 'TV MAIAS, DOS', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.057-590', '54       ', 'R MAJOR ALFREDO TENORIO LINS', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.042-380', '54       ', 'R MAJOR ALVARO EUSTORGIO DE OLIVEIRA E SILVA', 'FEITOSA                       ');
INSERT INTO cd_cep_br VALUES ('57.017-320', '54       ', 'AV MAJOR CICERO DE GOES MONTEIRO', 'MUTANGE                       ');
INSERT INTO cd_cep_br VALUES ('57.036-670', '54       ', 'R MARECHAL ANTONIO GUEDES MUNIZ', 'JATIUCA                       ');
INSERT INTO cd_cep_br VALUES ('57.036-660', '54       ', 'R MARECHAL ARTHUR ALVIN CAMARA', 'JATIUCA                       ');
INSERT INTO cd_cep_br VALUES ('57.038-350', '54       ', 'R MARECHAL DEODORO', 'C ALMAS                       ');
INSERT INTO cd_cep_br VALUES ('57.020-040', '54       ', 'PC MARECHAL DEODORO', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.020-090', '54       ', 'PC MARECHAL FLORIANO PEIXOTO', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.062-620', '54       ', 'AL MARECHAL HENRIQUE DUFLES BATISTA TEIXEIRA LOTT', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.038-120', '54       ', 'R MARECHAL MASCARENHAS DE MORAES', 'C ALMAS                       ');
INSERT INTO cd_cep_br VALUES ('57.038-125', '54       ', 'TV MARECHAL MASCARENHAS DE MORAES', 'C ALMAS                       ');
INSERT INTO cd_cep_br VALUES ('57.020-590', '54       ', 'R MARECHAL ROBERTO FERREIRA', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.051-380', '54       ', 'R ITATIAIA', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.075-010', '54       ', 'CJ MARGARIDA PROCOPIO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.048-040', '54       ', 'R MARIA ALBANIRA GONDIM LAMENHA', 'SERRARIA                      ');
INSERT INTO cd_cep_br VALUES ('12.919-591', '4897     ', 'R PROJETADA', 'REC AMAPOLA                   ');
INSERT INTO cd_cep_br VALUES ('57.039-340', '54       ', 'R MARIA AMANDA DE MEDEIROS CARLOS', 'JACARECICA                    ');
INSERT INTO cd_cep_br VALUES ('57.072-410', '54       ', 'R MARIA ANGELICA DA CONCEICAO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.038-620', '54       ', 'R MARIA ANTONIETA TEIXEIRA LEITE', 'C ALMAS                       ');
INSERT INTO cd_cep_br VALUES ('57.062-210', '54       ', 'AL MARIA APARECIDA FERRO GONCALVES', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.036-280', '54       ', 'R MARIA BREDA', 'JATIUCA                       ');
INSERT INTO cd_cep_br VALUES ('57.048-250', '54       ', 'AV MARIA CAROLINA MOREIRA SAMPAIO', 'SERRARIA                      ');
INSERT INTO cd_cep_br VALUES ('57.042-100', '54       ', 'R MARIA CECILIA DA ROCHA', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.071-190', '54       ', 'R MARIA CELESTE DA ROCHA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.062-430', '54       ', 'AL MARIA DAS DORES DANTAS', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.045-540', '54       ', 'R MARIA DAS DORES DO ESPIRITO SANTO', 'B DURO                        ');
INSERT INTO cd_cep_br VALUES ('57.062-160', '54       ', 'AL MARIA DAS GRACAS NOVAES BRANDAO VILELA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.071-725', '54       ', 'R MARIA DAS NEVES GOMES', 'A S DUMONT                    ');
INSERT INTO cd_cep_br VALUES ('57.073-150', '54       ', 'R MARIA DE CARVALHO GUIMARAES', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.043-310', '54       ', 'R MARIA DE FATIMA', 'FEITOSA                       ');
INSERT INTO cd_cep_br VALUES ('57.083-350', '54       ', 'R MARIA DE FATIMA AMORIM FRANCA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.083-080', '54       ', 'R MARIA DE FATIMA NOBRE SOARES', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.030-750', '54       ', 'TV MARIA DE LOURDES ALVES PINTO', 'POCO                          ');
INSERT INTO cd_cep_br VALUES ('57.041-830', '54       ', 'PC MARIA DE LOURDES CANCIO BULHOES DE MELO', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.037-370', '54       ', 'R MARIA DE LOURDES CHAGAS', 'MANGABEIRAS                   ');
INSERT INTO cd_cep_br VALUES ('57.062-400', '54       ', 'AL MARIA DE LOURDES MOREIRA SANTOS', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.041-160', '54       ', 'R MARIA DE LOURDES MOURA TEIXEIRA', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.076-090', '54       ', 'R MARIA DE LOURDES SILVA GALVAO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.062-410', '54       ', 'AL MARIA DIRCE GOMES DA SILVA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.031-200', '54       ', 'R MANOEL LEITE BRANDAO', 'POCO                          ');
INSERT INTO cd_cep_br VALUES ('57.050-610', '54       ', 'R MANOEL LINS CALHEIROS', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.039-260', '54       ', 'R MANOEL LISBOA DE MOURA', 'R DOCE                        ');
INSERT INTO cd_cep_br VALUES ('57.039-620', '54       ', 'LD MANOEL LOPES DOS SANTOS', 'F PEIXOTO                     ');
INSERT INTO cd_cep_br VALUES ('57.015-540', '54       ', 'R MANOEL LOURENCO', 'P GROSSA                      ');
INSERT INTO cd_cep_br VALUES ('57.045-810', '54       ', 'R MANOEL MACENA', 'O PRETO                       ');
INSERT INTO cd_cep_br VALUES ('57.050-120', '54       ', 'R MANOEL MAIA NOBRE', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.048-010', '54       ', 'R MANOEL MENESES FERREIRA', 'SERRARIA                      ');
INSERT INTO cd_cep_br VALUES ('57.055-450', '54       ', 'R MANOEL MENEZES', 'PINHEIRO                      ');
INSERT INTO cd_cep_br VALUES ('57.055-455', '54       ', 'TV MANOEL MENEZES', 'PINHEIRO                      ');
INSERT INTO cd_cep_br VALUES ('57.072-490', '54       ', 'R MANOEL MIGUEL DA SILVA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.073-100', '54       ', 'R MANOEL MODESTO DE LIMA GASTAO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.011-100', '54       ', 'R MANOEL MOURA', 'T BARRA                       ');
INSERT INTO cd_cep_br VALUES ('57.057-210', '54       ', 'R MANOEL OMENA FIREMAN', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.018-110', '54       ', 'R MANOEL PARENTES', 'BEBEDOURO                     ');
INSERT INTO cd_cep_br VALUES ('57.018-115', '54       ', 'TV MANOEL PARENTES', 'BEBEDOURO                     ');
INSERT INTO cd_cep_br VALUES ('57.084-380', '54       ', 'R MANOEL PEDRO DE OLIVEIRA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.081-320', '54       ', 'AV MANOEL PEREIRA CAVALCANTE', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.040-100', '54       ', 'R MANOEL PORCIUNCULA', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.020-180', '54       ', 'LD MANOEL RAMALHO DE AZEVEDO', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.035-550', '54       ', 'R MANOEL RIBEIRO DA ROCHA', 'P VERDE                       ');
INSERT INTO cd_cep_br VALUES ('57.607-130', '40       ', 'R BAHIA', 'JD BRASIL                     ');
INSERT INTO cd_cep_br VALUES ('57.600-370', '40       ', 'AT BELA VISTA', 'AT CRUZEIRO                   ');
INSERT INTO cd_cep_br VALUES ('57.017-100', '54       ', 'R JONAS MONTENEGRO', 'B PARTO                       ');
INSERT INTO cd_cep_br VALUES ('57.036-230', '54       ', 'R JONATHAN MELO', 'JATIUCA                       ');
INSERT INTO cd_cep_br VALUES ('57.071-485', '54       ', 'R JORDAO', 'A S DUMONT                    ');
INSERT INTO cd_cep_br VALUES ('57.075-330', '54       ', 'R JORGE DE ARAUJO VASCONCELOS(RUA I CJ OSMAN LOU', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.080-270', '54       ', 'R JORGE DE MELO E SILVA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.039-800', '54       ', 'R JORN JOSE NILTON DE OLIVEIRA CORREIA(CJ RESIDE', 'JACARECICA                    ');
INSERT INTO cd_cep_br VALUES ('57.051-420', '54       ', 'R JORNAL DE ALAGOAS', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.041-530', '54       ', 'R JORNAL DE HOJE', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.050-830', '54       ', 'R JORNALISTA ALZIRO ZARUR', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.050-620', '54       ', 'R JORNALISTA ARNOBIO VALENTE FILHO', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.057-150', '54       ', 'R JORNALISTA AUGUSTO VAZ FILHO', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.057-610', '54       ', 'R JORNALISTA CARLOS DE CARVALHO LINS', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.030-850', '54       ', 'PC JORNALISTA DENIS AGRA', 'POCO                          ');
INSERT INTO cd_cep_br VALUES ('57.045-560', '54       ', 'R JORNALISTA HAMILTON BRANXISKY(ANTIGA TRAVESSA', 'B DURO                        ');
INSERT INTO cd_cep_br VALUES ('57.061-260', '54       ', 'R JOAO DOCA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.061-270', '54       ', 'R JOAO DOMINGOS', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.083-120', '54       ', 'R JOAO FARIAS FILHO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.041-520', '54       ', 'R JOAO FARIAS LOBO', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.073-210', '54       ', 'R JOAO FRANCELINO DA SILVA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.050-850', '54       ', 'R JOAO FRANCISCO DE ATAIDE', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.015-695', '54       ', 'VL JOAO GATO', 'LEVADA                        ');
INSERT INTO cd_cep_br VALUES ('57.035-270', '54       ', 'R JOAO GUALBERTO PEREIRA DO CARMO', 'P VERDE                       ');
INSERT INTO cd_cep_br VALUES ('57.083-360', '54       ', 'R JOAO HERMENEGILDO DA ROCHA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.083-320', '54       ', 'R JOAO HONORIO DE ARAUJO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.014-500', '54       ', 'R JOAO JOSE FERREIRA', 'P GROSSA                      ');
INSERT INTO cd_cep_br VALUES ('57.031-460', '54       ', 'R JOAO JOSE PEREIRA DE LIMA FILHO', 'POCO                          ');
INSERT INTO cd_cep_br VALUES ('57.051-390', '54       ', 'R JOAO JUCA', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.017-610', '54       ', 'R JOAO LEITE SOBRINHO', 'BEBEDOURO                     ');
INSERT INTO cd_cep_br VALUES ('57.040-630', '54       ', 'R JOAO LICIO MARQUES', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.010-150', '54       ', 'R JOAO LICIO MARQUES', 'PRADO                         ');
INSERT INTO cd_cep_br VALUES ('57.011-090', '54       ', 'R JOAO LINS CEDRIM', 'T BARRA                       ');
INSERT INTO cd_cep_br VALUES ('57.037-060', '54       ', 'R JOAO LOPES DO CARMO', 'MANGABEIRAS                   ');
INSERT INTO cd_cep_br VALUES ('57.025-670', '54       ', 'R JOAO MALAQUIAS', 'POCO                          ');
INSERT INTO cd_cep_br VALUES ('57.025-675', '54       ', 'TV JOAO MALAQUIAS', 'POCO                          ');
INSERT INTO cd_cep_br VALUES ('57.061-070', '54       ', 'PC JOAO MARTINS', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.060-110', '54       ', 'R JOAO MARTINS', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.082-760', '54       ', 'R JOAO MONTEIRO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.052-120', '54       ', 'R JOAO NOBERTO DE LIMA', 'G LOURDES                     ');
INSERT INTO cd_cep_br VALUES ('57.075-410', '54       ', 'PC JOSE MACARIO LESSA BELTRAO(CONJUNTO OSMAN LOUR', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.036-240', '54       ', 'R JOSE MAIA GOMES', 'JATIUCA                       ');
INSERT INTO cd_cep_br VALUES ('57.052-160', '54       ', 'R JOSE MALTA DE ALENCAR', 'G LOURDES                     ');
INSERT INTO cd_cep_br VALUES ('57.075-160', '54       ', 'AV JOSE MANHAES', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.070-360', '54       ', 'TV JOSE MARCELINO', 'F VELHO                       ');
INSERT INTO cd_cep_br VALUES ('57.072-290', '54       ', 'R JOSE MARIA BARRETO GALVAO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.083-400', '54       ', 'PRQ JOSE MARIA DE MELO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.057-370', '54       ', 'R JOSE MARIA DOS SANTOS', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.073-360', '54       ', 'AV JOSE CAMELO DE FREITAS', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.017-110', '54       ', 'LD JOSE CARDOSO DA SILVA', 'B PARTO                       ');
INSERT INTO cd_cep_br VALUES ('57.046-820', '54       ', 'R JOSE CARLOS CALHEIROS (CJ SAMAMBAIA)', 'SERRARIA                      ');
INSERT INTO cd_cep_br VALUES ('57.061-090', '54       ', 'TV JOSE CARNAUBA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.036-630', '54       ', 'R JOSE CARNEIRO DA CUNHA SARMENTO', 'JATIUCA                       ');
INSERT INTO cd_cep_br VALUES ('57.080-150', '54       ', 'R JOSE CASADO DA CUNHA LIMA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.014-610', '54       ', 'R JOSE CAVALCANTE', 'P GROSSA                      ');
INSERT INTO cd_cep_br VALUES ('57.014-615', '54       ', 'TV JOSE CAVALCANTE', 'P GROSSA                      ');
INSERT INTO cd_cep_br VALUES ('57.042-370', '54       ', 'R JOSE CLARIMUNDO CAMPOS', 'B VISTA                       ');
INSERT INTO cd_cep_br VALUES ('57.014-160', '54       ', 'R JOSE CORREIA DE MELO', 'P GROSSA                      ');
INSERT INTO cd_cep_br VALUES ('57.062-320', '54       ', 'AL JOSE CORREIA DE MELO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.031-520', '54       ', 'R JOSE CORREIA FILHO', 'P VERDE                       ');
INSERT INTO cd_cep_br VALUES ('57.082-060', '54       ', 'R JOSE CORREIA TORRES', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.055-730', '54       ', 'R JOSE DA COSTA TENORIO', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.041-120', '54       ', 'CJ JOSE DA SILVA PEIXOTO', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.055-070', '54       ', 'R JOSE DE ALENCAR', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.080-510', '54       ', 'R JOSE DE CARVALHO MARTINS', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.038-080', '54       ', 'R JOSE DE MELO', 'MANGABEIRAS                   ');
INSERT INTO cd_cep_br VALUES ('57.018-780', '54       ', 'R JOSE DE MELO ARGOLO', 'C JAQUEIRA                    ');
INSERT INTO cd_cep_br VALUES ('57.083-150', '54       ', 'R JOSE DE MOURA TEIXEIRA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.057-180', '54       ', 'R JOSE DIONISIO SOBRINHO', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.048-130', '54       ', 'R JOSE EMETERIO DE LIMA', 'SERRARIA                      ');
INSERT INTO cd_cep_br VALUES ('57.039-250', '54       ', 'PC JOSE EMIDIO DE CARVALHO', 'R DOCE                        ');
INSERT INTO cd_cep_br VALUES ('57.057-330', '54       ', 'R JOSE EZEQUIEL DA SILVA', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.071-710', '54       ', 'R JOSE FELIX DE ALMEIDA', 'A S DUMONT                    ');
INSERT INTO cd_cep_br VALUES ('57.072-050', '54       ', 'R JOSE FERNANDES BARRETO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.083-440', '54       ', 'R JOSE FERNANDES DE ALBUQUERQUE', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.057-190', '54       ', 'R JOSE FERRAZ DE CAMARGO', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.011-270', '54       ', 'R JOSE FERREIRA', 'T BARRA                       ');
INSERT INTO cd_cep_br VALUES ('57.046-140', '54       ', 'R JOSE FERREIRA DE ALMEIDA', 'SERRARIA                      ');
INSERT INTO cd_cep_br VALUES ('57.014-170', '54       ', 'R JOSE FERREIRA DE ARAUJO', 'P GROSSA                      ');
INSERT INTO cd_cep_br VALUES ('57.046-210', '54       ', 'R JOSE FERREIRA DE MACEDO', 'SERRARIA                      ');
INSERT INTO cd_cep_br VALUES ('57.083-040', '54       ', 'R JOSE FERREIRA DE MESSIAS', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.041-130', '54       ', 'R JOSE FERREIRA DOS SANTOS', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.073-240', '54       ', 'R JOSE FIRMINO DA SILVA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.040-310', '54       ', 'R JOSE FONTES LIMA', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.057-340', '54       ', 'R JOSE FRANCISCO DE OLIVEIRA', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.083-170', '54       ', 'R JOSE FRANCISCO DOS SANTOS', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.025-610', '54       ', 'R JORNALISTA JAIME DE AMORIM MIRANDA', 'POCO                          ');
INSERT INTO cd_cep_br VALUES ('57.037-080', '54       ', 'R JORNALISTA JOSE ANTONIO DA SILVA', 'JATIUCA                       ');
INSERT INTO cd_cep_br VALUES ('57.052-140', '54       ', 'AV JORNALISTA JOSE BATISTA DOS SANTOS', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.018-740', '54       ', 'R JORNALISTA JOSE CABRAL IRMAO', 'C JAQUEIRA                    ');
INSERT INTO cd_cep_br VALUES ('57.042-360', '54       ', 'R JORNALISTA JOSE RENATO DA SILVA', 'B VISTA                       ');
INSERT INTO cd_cep_br VALUES ('57.061-280', '54       ', 'R JORNALISTA JUAREZ CARNAUBA DE OLIVEIRA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.014-520', '54       ', 'PC JORNALISTA JUAREZ OLIVEIRA', 'P GROSSA                      ');
INSERT INTO cd_cep_br VALUES ('57.030-615', '54       ', 'PC JORNALISTA JURANDIR TOBIAS', 'P TERRA                       ');
INSERT INTO cd_cep_br VALUES ('57.025-690', '54       ', 'R JORNALISTA LAFAIETE BELO', 'POCO                          ');
INSERT INTO cd_cep_br VALUES ('57.602-250', '40       ', 'R ANTERO AMORIM', 'S FRANCISCO                   ');
INSERT INTO cd_cep_br VALUES ('57.607-320', '40       ', 'R ANTONIO AUGUSTO DE BARROS', 'S CRISTOVAO                   ');
INSERT INTO cd_cep_br VALUES ('57.602-300', '40       ', 'R ANTONIO AUGUSTO DOS SANTOS', 'S FRANCISCO                   ');
INSERT INTO cd_cep_br VALUES ('57.075-090', '54       ', 'CJ HELIO VASCONCELOS', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.084-030', '54       ', 'CJ HENRIQUE EQUELMAN', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.081-360', '54       ', 'R HERMES ERNESTO DAMASCENO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.080-520', '54       ', 'R HERMES MARTINS DE MELO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.075-320', '54       ', 'R HERMINIO CARDOSO(RUA 16 CJ OSMAN LOUREIRO)', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.072-210', '54       ', 'R HERMITON DO AMARAL', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.040-110', '54       ', 'R HIGINO VITAL DA SILVA', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.020-575', '54       ', 'TV GODOFREDO FERRO', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.071-390', '54       ', 'R GOES MONTEIRO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.081-630', '54       ', 'LOT GOIABEIRA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.070-440', '54       ', 'VL GOIABEIRA', 'F VELHO                       ');
INSERT INTO cd_cep_br VALUES ('57.081-590', '54       ', 'R GOIABEIRAS', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.050-090', '54       ', 'R GOIAS- ATE 146/179', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.055-320', '54       ', 'R GOIAS- DE 148/181 AO FIM', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.051-330', '54       ', 'R GONCALVES DIAS', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.051-340', '54       ', 'PRQ GONCALVES LEDO', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.020-005', '54       ', 'PC GOVERNADOR ADEMAR DE BARROS', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.017-015', '54       ', 'AV GOVERNADOR AFRANIO LAGES- ATE 190/191', 'B PARTO                       ');
INSERT INTO cd_cep_br VALUES ('57.050-015', '54       ', 'AV GOVERNADOR AFRANIO LAGES- DE 192/193 A 398/399', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.040-480', '54       ', 'AV GOVERNADOR AFRANIO LAGES- DE 400/401 AO FIM', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.037-050', '54       ', 'R GOVERNADOR CARLOS LACERDA', 'MANGABEIRAS                   ');
INSERT INTO cd_cep_br VALUES ('57.084-430', '54       ', 'R GOVERNADOR FRANCISCO MELLO(RUA 5 CJ RESIDENCIA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.061-250', '54       ', 'CJ JARDIM GLORIA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.039-730', '54       ', 'LOT JARDIM IPIOPOLIS', 'F PEIXOTO                     ');
INSERT INTO cd_cep_br VALUES ('57.043-280', '54       ', 'R JARDIM MANGUABA', 'FEITOSA                       ');
INSERT INTO cd_cep_br VALUES ('57.025-720', '54       ', 'CJ JARDIM ORIENTAL', 'POCO                          ');
INSERT INTO cd_cep_br VALUES ('57.084-520', '54       ', 'CJ JARDIM PARAISO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.080-460', '54       ', 'LOT JARDIM PETROPOLIS I', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.062-640', '54       ', 'LOT JARDIM PETROPOLIS II', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.071-290', '54       ', 'CJ JARDIM PLANALTO', 'A S DUMONT                    ');
INSERT INTO cd_cep_br VALUES ('57.046-800', '54       ', 'LOT JARDIM SANTA ANA', 'SERRARIA                      ');
INSERT INTO cd_cep_br VALUES ('57.017-810', '54       ', 'VL JARDIM SAO FRANCISCO(ANTIGA VILA BREJAL)', 'LEVADA                        ');
INSERT INTO cd_cep_br VALUES ('57.076-070', '54       ', 'CJ JARDIM SAUDE', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.035-530', '54       ', 'CJ JARDIM TROPICAL', 'P VERDE                       ');
INSERT INTO cd_cep_br VALUES ('57.038-570', '54       ', 'CJ JARDIM VATICANO', 'MANGABEIRAS                   ');
INSERT INTO cd_cep_br VALUES ('57.040-120', '54       ', 'R JARDINEIRA', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.040-125', '54       ', 'TV JARDINEIRA', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.043-480', '54       ', 'R JARI', 'FEITOSA                       ');
INSERT INTO cd_cep_br VALUES ('57.039-090', '54       ', 'R JARSEN COSTA', 'R DOCE                        ');
INSERT INTO cd_cep_br VALUES ('57.084-350', '54       ', 'R INDUSTRIAL JARBAS MAIA DE OMENA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('13.075-020', '4802     ', 'R CORONEL MANUEL DE MORAES', 'VL R BORGHI                   ');
INSERT INTO cd_cep_br VALUES ('57.042-330', '54       ', 'R INDUSTRIAL JOSE FERNANDES FERREIRA', 'FEITOSA                       ');
INSERT INTO cd_cep_br VALUES ('57.036-600', '54       ', 'R INDUSTRIAL JOSE OTAVIO MOREIRA', 'JATIUCA                       ');
INSERT INTO cd_cep_br VALUES ('57.055-230', '54       ', 'R INDUSTRIAL LUIZ CALHEIROS JUNIOR', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.052-110', '54       ', 'R INDUSTRIAL MARIO LEAO', 'G LOURDES                     ');
INSERT INTO cd_cep_br VALUES ('57.038-070', '54       ', 'R INDUSTRIAL MOACIR DUARTE', 'MANGABEIRAS                   ');
INSERT INTO cd_cep_br VALUES ('57.072-010', '54       ', 'CJ INOCOOP', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.041-680', '54       ', 'R INSPETOR PAULO PEIXOTO', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.042-600', '54       ', 'R INSPETOR ROSALVO MARTINS DE CARVALHO', 'FEITOSA                       ');
INSERT INTO cd_cep_br VALUES ('57.061-450', '54       ', 'TV IOLANDA FERNANDES', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.060-460', '54       ', 'R IOLANDA FONTAN', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.073-260', '54       ', 'R IOLANDA GOMES DE MOURA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.052-590', '54       ', 'R IPE ROXO', 'G LOURDES                     ');
INSERT INTO cd_cep_br VALUES ('57.018-070', '54       ', 'R IPIRANGA', 'BEBEDOURO                     ');
INSERT INTO cd_cep_br VALUES ('57.042-120', '54       ', 'R IPIRANGA', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.073-320', '54       ', 'R IRACEMA FRAGOSO DE ARAUJO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.010-570', '54       ', 'R IRACEMA LESSA DE ANDRADE', 'P BARRA                       ');
INSERT INTO cd_cep_br VALUES ('57.051-370', '54       ', 'R IRIS ALAGOENSE', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.051-375', '54       ', 'TV IRIS ALAGOENSE', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.030-530', '54       ', 'R ISAIAS FRANCISCO DE ANDRADE', 'POCO                          ');
INSERT INTO cd_cep_br VALUES ('57.082-390', '54       ', 'R ISMAEL ACIOLY', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.080-500', '54       ', 'R ISMAEL ARAUJO AMORIM', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.071-080', '54       ', 'R ISRAEL', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.010-510', '54       ', 'R ITAMARATI', 'T BARRA                       ');
INSERT INTO cd_cep_br VALUES ('57.042-035', '54       ', 'R ITAPUA', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.051-385', '54       ', 'TV ITATIAIA', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.071-700', '54       ', 'R IVALDO FERINO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.042-080', '54       ', 'R IVALDO MARINHO', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.042-085', '54       ', 'TV IVALDO MARINHO', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.043-100', '54       ', 'R IVAN VASCONCELOS DE BRITO', 'FEITOSA                       ');
INSERT INTO cd_cep_br VALUES ('57.057-140', '54       ', 'R IVAN WOLFF', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.071-690', '54       ', 'R IZABELA CLARINDO', 'A S DUMONT                    ');
INSERT INTO cd_cep_br VALUES ('57.071-170', '54       ', 'R IZAURA BUARQUE QUINTILIANO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.074-040', '54       ', 'R JABORANDI (LOT PARQUE DAS ARVORES)', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.052-430', '54       ', 'R JACARANDA', 'G LOURDES                     ');
INSERT INTO cd_cep_br VALUES ('57.039-070', '54       ', 'CJ JACARECICA', 'JACARECICA                    ');
INSERT INTO cd_cep_br VALUES ('57.039-690', '54       ', 'R HILDA DE MELO ACIOLE', 'F PEIXOTO                     ');
INSERT INTO cd_cep_br VALUES ('57.060-450', '54       ', 'R HILDA DE MENEZES BARROS', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.061-240', '54       ', 'R HILDA DE PEREIRA MONTE', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.082-590', '54       ', 'AV HILDA FELIX OLIVEIRA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.061-580', '54       ', 'R HILDO DE PEREIRA MONTE', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.045-470', '54       ', 'R HORACIO DE SOUZA LIMA', 'B DURO                        ');
INSERT INTO cd_cep_br VALUES ('57.039-610', '54       ', 'R HOTEL, DO', 'SAUDE                         ');
INSERT INTO cd_cep_br VALUES ('57.050-730', '54       ', 'R HUGO CORREA PAES', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.083-270', '54       ', 'R HUGO DA COSTA MENEZES', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.050-100', '54       ', 'R HUGO JOBIM', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.051-360', '54       ', 'R HUMAITA', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.071-005', '54       ', 'R HUMBERTO MELO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.020-585', '54       ', 'TV HUMBERTO MENDES', 'JARAGUA                       ');
INSERT INTO cd_cep_br VALUES ('57.020-580', '54       ', 'AV HUMBERTO MENDES- LADO IMPAR', 'POCO                          ');
INSERT INTO cd_cep_br VALUES ('57.022-060', '54       ', 'AV HUMBERTO MENDES- LADO PAR', 'JARAGUA                       ');
INSERT INTO cd_cep_br VALUES ('57.015-090', '54       ', 'R HUMBERTO SANTA CRUZ', 'P GROSSA                      ');
INSERT INTO cd_cep_br VALUES ('57.052-400', '54       ', 'R IBIRIBA', 'G LOURDES                     ');
INSERT INTO cd_cep_br VALUES ('57.045-030', '54       ', 'LOT ICARAI', 'B DURO                        ');
INSERT INTO cd_cep_br VALUES ('57.051-400', '54       ', 'R JOAO NOGUEIRA', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.025-500', '54       ', 'R JOAO OMENA DE ANDRADE', 'POCO                          ');
INSERT INTO cd_cep_br VALUES ('57.039-720', '54       ', 'AV JOAO OMENA DE ANDRADE(LOT SAO JUDAS TADEU)', 'F PEIXOTO                     ');
INSERT INTO cd_cep_br VALUES ('57.081-170', '54       ', 'R NOSSA SENHORA DE FATIMA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.040-820', '54       ', 'R NOSSA SENHORA DE FATIMA', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.042-540', '54       ', 'R PROMOTOR CICERO DE MEDEIROS TORRES LEITE', 'B VISTA                       ');
INSERT INTO cd_cep_br VALUES ('57.018-230', '54       ', 'R PROMOTOR HEITOR MONTENEGRO BARROS', 'BEBEDOURO                     ');
INSERT INTO cd_cep_br VALUES ('12.914-610', '4897     ', 'AL PAU FERRO', 'JD PALMEIRAS                  ');
INSERT INTO cd_cep_br VALUES ('57.043-150', '54       ', 'R PROMOTOR MANOEL DE CARVALHO', 'FEITOSA                       ');
INSERT INTO cd_cep_br VALUES ('57.041-640', '54       ', 'R PROTOGENES MOURA', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.038-140', '54       ', 'TV PROFESSOR DERVAL MACARIO DOS SANTOS', 'C ALMAS                       ');
INSERT INTO cd_cep_br VALUES ('57.041-250', '54       ', 'R PROFESSOR DIVALDO FRANCO', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.020-100', '54       ', 'R PROFESSOR DOMINGOS MOEDA', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.072-810', '54       ', 'R PROFESSOR EDUARDO ALMEIDA DA SILVA(JARDIM PLAN', 'A S DUMONT                    ');
INSERT INTO cd_cep_br VALUES ('57.037-260', '54       ', 'R PROFESSOR EDUARDO DA MOTA TRIGUEIRO', 'JATIUCA                       ');
INSERT INTO cd_cep_br VALUES ('57.070-350', '54       ', 'R PROFESSOR ENEIAS ROCHA WANDERLEY', 'F VELHO                       ');
INSERT INTO cd_cep_br VALUES ('57.038-150', '54       ', 'R PROFESSOR ERNANI DE FIGUEREDO MAGALHAES', 'C ALMAS                       ');
INSERT INTO cd_cep_br VALUES ('57.075-370', '54       ', 'R PROFESSOR FELIX LIMA JUNIOR(RUA 25 CJ OSMAN LO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.050-760', '54       ', 'R PROFESSOR FRANCISCO CANDIDO DE MENDONCA', 'G LOURDES                     ');
INSERT INTO cd_cep_br VALUES ('57.030-380', '54       ', 'R PROFESSOR FRANCISCO FERNANDES LINS', 'PAJUCARA                      ');
INSERT INTO cd_cep_br VALUES ('57.081-200', '54       ', 'R PROFESSOR GILSON LUCAS', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.052-520', '54       ', 'R PROFESSOR GRACA LEITE', 'G LOURDES                     ');
INSERT INTO cd_cep_br VALUES ('57.022-070', '54       ', 'R PROFESSOR GRACILIANO RAMOS', 'JARAGUA                       ');
INSERT INTO cd_cep_br VALUES ('57.055-220', '54       ', 'R PROFESSOR GUEDES DE MIRANDA', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.055-225', '54       ', 'TV PROFESSOR GUEDES DE MIRANDA', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.071-140', '54       ', 'R PROFESSOR HUMBERTO VILELA(ANTIGA RUA SANTA FE)', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.052-190', '54       ', 'R PROFESSOR JAIR GASPAR DE MENDONCA', 'G LOURDES                     ');
INSERT INTO cd_cep_br VALUES ('57.042-480', '54       ', 'PC PROFESSOR JONAS CALHEIROS', 'B VISTA                       ');
INSERT INTO cd_cep_br VALUES ('57.030-790', '54       ', 'R PROFESSOR JONAS CALHEIROS', 'POCO                          ');
INSERT INTO cd_cep_br VALUES ('57.084-010', '54       ', 'R PROFESSOR JOSE CAVALCANTE MANSO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.055-630', '54       ', 'R PROFESSOR JOSE DA SILVEIRA CAMERINO- ATE 707/7', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.057-250', '54       ', 'R PROFESSOR JOSE DA SILVEIRA CAMERINO- DE 709/71', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.051-580', '54       ', 'R SALDANHA DA GAMA', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.017-120', '54       ', 'R SALDANHA MARINHO', 'B PARTO                       ');
INSERT INTO cd_cep_br VALUES ('57.081-460', '54       ', 'R SALVADOR', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.025-550', '54       ', 'R SALVADOR CALMON', 'POCO                          ');
INSERT INTO cd_cep_br VALUES ('57.042-500', '54       ', 'R SALVADOR COSTA', 'B VISTA                       ');
INSERT INTO cd_cep_br VALUES ('57.072-320', '54       ', 'AV SALVADOR VERISSIMO DA SILVA(ANTIGA AVENIDA OLI', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.046-180', '54       ', 'CJ SAMAMBAIA', 'SERRARIA                      ');
INSERT INTO cd_cep_br VALUES ('57.047-050', '54       ', 'LOT SAMBAIBA', 'SERRARIA                      ');
INSERT INTO cd_cep_br VALUES ('57.063-040', '54       ', 'LOT SAMBURA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.015-840', '54       ', 'R SAMPAIO DORIA', 'P GROSSA                      ');
INSERT INTO cd_cep_br VALUES ('57.073-340', '54       ', 'CJ RESIDENCIAL GRACILIANO RAMOS', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.046-120', '54       ', 'CJ RESIDENCIAL JARDIM DA SERRARIA', 'SERRARIA                      ');
INSERT INTO cd_cep_br VALUES ('57.050-600', '54       ', 'PRQ RESIDENCIAL JARDIM TROPICAL', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.037-190', '54       ', 'PRQ RESIDENCIAL JATIUCA', 'JATIUCA                       ');
INSERT INTO cd_cep_br VALUES ('57.082-580', '54       ', 'CJ RESIDENCIAL JOSE DUBEAUX LEAO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.083-510', '54       ', 'CJ RESIDENCIAL JOSE MARIA DE MELO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.037-280', '54       ', 'PRQ RESIDENCIAL MANGABEIRAS', 'MANGABEIRAS                   ');
INSERT INTO cd_cep_br VALUES ('57.030-700', '54       ', 'CJ RESIDENCIAL PAJUCARA', 'POCO                          ');
INSERT INTO cd_cep_br VALUES ('57.037-290', '54       ', 'CJ RESIDENCIAL PRAIA MAR', 'MANGABEIRAS                   ');
INSERT INTO cd_cep_br VALUES ('57.083-520', '54       ', 'CJ RESIDENCIAL SALVADOR LYRA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.073-460', '54       ', 'CJ RESIDENCIAL TABULEIRO DOS MARTINS I', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.055-150', '54       ', 'R RETIRO SAUDOSO', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.055-155', '54       ', 'TV RETIRO SAUDOSO', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.030-075', '54       ', 'PC REX, DO', 'PAJUCARA                      ');
INSERT INTO cd_cep_br VALUES ('57.010-440', '54       ', 'R RIACHUELO', 'T BARRA                       ');
INSERT INTO cd_cep_br VALUES ('57.055-670', '54       ', 'R RICARDO LESSA DE MELO', 'PINHEIRO                      ');
INSERT INTO cd_cep_br VALUES ('57.055-540', '54       ', 'AL RIO BRANCO', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.015-770', '54       ', 'PRQ RIO BRANCO- LADO IMPAR', 'LEVADA                        ');
INSERT INTO cd_cep_br VALUES ('57.020-280', '54       ', 'PRQ RIO BRANCO- LADO PAR', 'LEVADA                        ');
INSERT INTO cd_cep_br VALUES ('57.060-170', '54       ', 'R RIO DA SILVA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.060-175', '54       ', 'TV RIO DA SILVA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.083-560', '54       ', 'R RIO DO MEIO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.038-470', '54       ', 'R RIO LARGO', 'C ALMAS                       ');
INSERT INTO cd_cep_br VALUES ('57.062-710', '54       ', 'R RIO VERDE', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.070-270', '54       ', 'R RIO VERDE', 'R NOVO                        ');
INSERT INTO cd_cep_br VALUES ('57.035-610', '54       ', 'PC RIOS', 'P VERDE                       ');
INSERT INTO cd_cep_br VALUES ('57.052-530', '54       ', 'R RITA DE CASSIA', 'G LOURDES                     ');
INSERT INTO cd_cep_br VALUES ('57.046-640', '54       ', 'R RITA DE OLIVEIRA COSTA', 'SERRARIA                      ');
INSERT INTO cd_cep_br VALUES ('57.073-420', '54       ', 'R RITA MENDES DA SILVA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.057-260', '54       ', 'R RIVADAVIA CARNAUBA', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.045-800', '54       ', 'R ROBERTO ACYOLY', 'O PRETO                       ');
INSERT INTO cd_cep_br VALUES ('57.037-240', '54       ', 'AV ROBERTO MASCARENHAS DE BRITO', 'JATIUCA                       ');
INSERT INTO cd_cep_br VALUES ('57.010-330', '54       ', 'AV ROBERTO PONTES LIMA', 'T BARRA                       ');
INSERT INTO cd_cep_br VALUES ('57.052-220', '54       ', 'R ROBERTO SIMONSEN', 'G LOURDES                     ');
INSERT INTO cd_cep_br VALUES ('57.052-225', '54       ', 'TV ROBERTO SIMONSEN', 'G LOURDES                     ');
INSERT INTO cd_cep_br VALUES ('57.014-230', '54       ', 'CJ ROBSON DANTAS', 'P GROSSA                      ');
INSERT INTO cd_cep_br VALUES ('57.084-470', '54       ', 'R ROCALHE ALMEIDA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.022-290', '54       ', 'R ROCHA CAVALCANTE', 'JARAGUA                       ');
INSERT INTO cd_cep_br VALUES ('57.070-260', '54       ', 'R PRUDENTES, DOS', 'R NOVO                        ');
INSERT INTO cd_cep_br VALUES ('57.061-120', '54       ', 'R QUADRO, DO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.025-360', '54       ', 'R QUATORZE DE JULHO', 'POCO                          ');
INSERT INTO cd_cep_br VALUES ('57.041-730', '54       ', 'R QUATRO DE DEZEMBRO', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.038-460', '54       ', 'R QUEBRANGULO', 'C ALMAS                       ');
INSERT INTO cd_cep_br VALUES ('57.025-370', '54       ', 'R QUEBRANGULO', 'POCO                          ');
INSERT INTO cd_cep_br VALUES ('57.030-320', '54       ', 'R QUINTINO BOCAIUVA', 'P TERRA                       ');
INSERT INTO cd_cep_br VALUES ('57.081-610', '54       ', 'R QUINZE DE DEZEMBRO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.015-300', '54       ', 'R RADIALISTA DJALMA VALENCA', 'V LAGO                        ');
INSERT INTO cd_cep_br VALUES ('57.073-080', '54       ', 'R RADIALISTA HAROLDO AMORIM MIRANDA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.010-560', '54       ', 'R RADIALISTA HAROLDO MIRANDA', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.015-520', '54       ', 'R RADIALISTA HUMBERTO WANDERLEY', 'V LAGO                        ');
INSERT INTO cd_cep_br VALUES ('57.062-260', '54       ', 'AL RADIALISTA LUIZ JATOBA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.072-610', '54       ', 'R RADIALISTA NASCIMENTO SUASSUNA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.051-560', '54       ', 'R RADIALISTA ODETE PACHECO', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.046-330', '54       ', 'R RADIALISTA OSMAR LEITE', 'SERRARIA                      ');
INSERT INTO cd_cep_br VALUES ('57.072-240', '54       ', 'R RADIALISTA WALDOMIRO MACARIO BARBOSA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.015-120', '54       ', 'R RADIALISTA WILMA CAMPOS', 'V LAGO                        ');
INSERT INTO cd_cep_br VALUES ('57.048-220', '54       ', 'AV RALPHO PESSOA BRAGA', 'SERRARIA                      ');
INSERT INTO cd_cep_br VALUES ('57.042-670', '54       ', 'R RAMIRES MATIAS', 'B VISTA                       ');
INSERT INTO cd_cep_br VALUES ('57.052-200', '54       ', 'R RANILDO CAVALCANTE', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('69.068-380', '156      ', 'R 10 (CJ COSTA E SILVA)', 'RAIZ                          ');
INSERT INTO cd_cep_br VALUES ('57.601-450', '40       ', 'R BENEDITA LEITE', 'P FORA                        ');
INSERT INTO cd_cep_br VALUES ('57.600-360', '40       ', 'R BOA VISTA', 'AT CRUZEIRO                   ');
INSERT INTO cd_cep_br VALUES ('57.600-365', '40       ', 'TV BOA VISTA', 'AT CRUZEIRO                   ');
INSERT INTO cd_cep_br VALUES ('57.607-220', '40       ', 'R BOM JESUS DOS PASSOS', 'VL MARIA                      ');
INSERT INTO cd_cep_br VALUES ('57.607-510', '40       ', 'R BRASIL NOVO', 'S CRISTOVAO                   ');
INSERT INTO cd_cep_br VALUES ('57.601-460', '40       ', 'AV BRASILIA', 'S CRISTOVAO                   ');
INSERT INTO cd_cep_br VALUES ('57.601-060', '40       ', 'R BRAULIO CAVALCANTE', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.607-000', '40       ', 'R BRAULIO MONTENEGRO', 'S CRISTOVAO                   ');
INSERT INTO cd_cep_br VALUES ('57.607-005', '40       ', 'TV BRAULIO MONTENEGRO', 'S CRISTOVAO                   ');
INSERT INTO cd_cep_br VALUES ('57.603-180', '40       ', 'R CACILDA SAMPAIO', 'S CRISTOVAO                   ');
INSERT INTO cd_cep_br VALUES ('57.601-310', '40       ', 'R CACIQUE FRANCELINO', 'S CRISTOVAO                   ');
INSERT INTO cd_cep_br VALUES ('57.602-340', '40       ', 'R CAPITAO ANIBAL MODESTO', 'PARAISO                       ');
INSERT INTO cd_cep_br VALUES ('57.605-210', '40       ', 'R CARACIOLY SOARES', 'S FRANCISCO                   ');
INSERT INTO cd_cep_br VALUES ('57.607-250', '40       ', 'R CASTELO BRANCO', 'VL MARIA                      ');
INSERT INTO cd_cep_br VALUES ('57.606-005', '40       ', 'TV CASTELO BRANCO', 'EUCALIPTOS                    ');
INSERT INTO cd_cep_br VALUES ('57.606-010', '40       ', 'R CASTELO BRANCO', 'EUCALIPTOS                    ');
INSERT INTO cd_cep_br VALUES ('57.607-080', '40       ', 'R CEARA', 'S CRISTOVAO                   ');
INSERT INTO cd_cep_br VALUES ('57.605-140', '40       ', 'R CHICO GINO', 'S FRANCISCO                   ');
INSERT INTO cd_cep_br VALUES ('57.600-310', '40       ', 'R CHICO NUNES', 'AT CRUZEIRO                   ');
INSERT INTO cd_cep_br VALUES ('57.600-150', '40       ', 'R CHICO PINTO', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.605-150', '40       ', 'R CICERO PEREIRA', 'S FRANCISCO                   ');
INSERT INTO cd_cep_br VALUES ('57.602-150', '40       ', 'R CLARINDO AMORIM', 'PARAISO                       ');
INSERT INTO cd_cep_br VALUES ('57.607-360', '40       ', 'R CLAUDIO BARBOSA DE LIMA', 'S CRISTOVAO                   ');
INSERT INTO cd_cep_br VALUES ('57.607-420', '40       ', 'R CLETO MARQUES LUZ', 'S CRISTOVAO                   ');
INSERT INTO cd_cep_br VALUES ('57.602-010', '40       ', 'R CLODOALDO DA FONSECA', 'PARAISO                       ');
INSERT INTO cd_cep_br VALUES ('57.602-080', '40       ', 'R CONSELHEIRO SEBASTIAO LIMA', 'PARAISO                       ');
INSERT INTO cd_cep_br VALUES ('57.600-490', '40       ', 'R CORONEL ANTONIO PANTALEAO', 'T CAVALCANTE                  ');
INSERT INTO cd_cep_br VALUES ('57.600-090', '40       ', 'R CORREIA PAZ', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.600-130', '40       ', 'R COSTA REGO', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.606-011', '40       ', 'R DA PAZ', 'EUCALIPTOS                    ');
INSERT INTO cd_cep_br VALUES ('57.603-080', '40       ', 'R DEPUTADO FRANCISCO PIMENTEL', 'S CRISTOVAO                   ');
INSERT INTO cd_cep_br VALUES ('57.601-000', '40       ', 'AV DEPUTADO MEDEIROS NETO', 'S CRISTOVAO                   ');
INSERT INTO cd_cep_br VALUES ('57.600-660', '40       ', 'R DEPUTADO TENORIO CAVALCANTE', 'T CAVALCANTE                  ');
INSERT INTO cd_cep_br VALUES ('57.062-750', '54       ', 'R WILSON PRAXEDES', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.043-470', '54       ', 'R XAPURI', 'FEITOSA                       ');
INSERT INTO cd_cep_br VALUES ('57.039-410', '54       ', 'R XAVIER DE ARAUJO', 'R DOCE                        ');
INSERT INTO cd_cep_br VALUES ('57.011-430', '54       ', 'R XAVIER DE BRITO', 'PRADO                         ');
INSERT INTO cd_cep_br VALUES ('57.043-460', '54       ', 'R XINGU', 'FEITOSA                       ');
INSERT INTO cd_cep_br VALUES ('57.082-845', '54       ', 'TV ZACARIA FONTAN', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.082-840', '54       ', 'AV ZACARIA FONTAN', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.082-850', '54       ', 'R ZACARIAS', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.020-470', '54       ', 'R ZACARIAS DE AZEVEDO', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.010-590', '54       ', 'R ZACARIAS DE AZEVEDO', 'PRADO                         ');
INSERT INTO cd_cep_br VALUES ('57.020-480', '54       ', 'R ZADIR INDIO', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.072-460', '54       ', 'R ZAFIRA ATAIDE CERQUEIRA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.075-390', '54       ', 'R ZEQUITO PORTO(AV B CJ OSMAN LOUREIRO)', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.070-300', '54       ', 'R ZORAIDE MALTA', 'R NOVO                        ');
INSERT INTO cd_cep_br VALUES ('69.077-370', '156      ', 'R 36 (CJ 31 DE MARCO I)', 'JAPIIM                        ');
INSERT INTO cd_cep_br VALUES ('69.094-360', '156      ', 'R 36 (NUCLEO 3)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.038-640', '156      ', 'R 37 (CJ A MONTENEGRO)', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('69.055-550', '156      ', 'R 37 (CJ C BRANCO)', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.044-340', '156      ', 'R 37 (CJ JD VERSALLES)', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('69.093-760', '156      ', 'R 37 (CJ MANOA)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.097-742', '156      ', 'R 37 (CJ O FROTA II)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.077-380', '156      ', 'R 37 (CJ 31 DE MARCO I)', 'JAPIIM                        ');
INSERT INTO cd_cep_br VALUES ('69.095-250', '156      ', 'R 37 (NUCLEO 5)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.077-390', '156      ', 'R 38 ( CJ 31 DE MARCO I)', 'JAPIIM                        ');
INSERT INTO cd_cep_br VALUES ('69.099-170', '156      ', 'R 38 (A MENDES)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.038-650', '156      ', 'R 38 (CJ A MONTENEGRO)', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('69.055-560', '156      ', 'R 38 (CJ C BRANCO)', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.095-260', '156      ', 'R 38 (NUCLEO 5)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.099-180', '156      ', 'R 39 (A MENDES)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.038-660', '156      ', 'R 39 (CJ A MONTENEGRO)', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('69.055-570', '156      ', 'R 39 (CJ C BRANCO)', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.097-743', '156      ', 'R 39 (CJ O FROTA II)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.077-400', '156      ', 'R 39 (CJ 31 DE MARCO I)', 'JAPIIM                        ');
INSERT INTO cd_cep_br VALUES ('69.095-270', '156      ', 'R 39 (NUCLEO 5)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.098-620', '156      ', 'R 4 (A MENDES)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.086-051', '156      ', 'R 4 A', 'S J OPERARIO                  ');
INSERT INTO cd_cep_br VALUES ('69.099-190', '156      ', 'R 40 (A MENDES)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.038-670', '156      ', 'R 40 (CJ A MONTENEGRO)', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('69.055-580', '156      ', 'R 40 (CJ C BRANCO)', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.077-410', '156      ', 'R 40 (CJ 31 DE MARCO I)', 'JAPIIM                        ');
INSERT INTO cd_cep_br VALUES ('69.095-280', '156      ', 'R 40 (NUCLEO 5)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.099-500', '156      ', 'R 41 (A MENDES)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.038-680', '156      ', 'R 41 (CJ A MONTENEGRO)', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('69.044-770', '156      ', 'R 30 (CJ JD VERSALLES)', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('69.093-690', '156      ', 'R 30 (CJ MANOA)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.077-310', '156      ', 'R 30 (CJ 31 DE MARCO I)', 'JAPIIM                        ');
INSERT INTO cd_cep_br VALUES ('69.094-300', '156      ', 'R 30 (NUCLEO 3)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.099-130', '156      ', 'R 31 (A MENDES)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.097-758', '156      ', 'R 31 (CJ A MEDEIROS)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.038-580', '156      ', 'R 31 (CJ A MONTENEGRO)', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('69.055-490', '156      ', 'R 31 (CJ C BRANCO)', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.044-170', '156      ', 'R 31 (CJ JD VERSALLES)', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('69.093-700', '156      ', 'R 31 (CJ MANOA)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.077-320', '156      ', 'R 31 (CJ 31 DE MARCO I)', 'JAPIIM                        ');
INSERT INTO cd_cep_br VALUES ('69.094-310', '156      ', 'R 31 (NUCLEO 3)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.099-480', '156      ', 'R 32 (A MENDES)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.038-590', '156      ', 'R 32 (CJ A MONTENEGRO)', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('69.055-500', '156      ', 'R 32 (CJ C BRANCO)', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.044-210', '156      ', 'R 32 (CJ JD VERSALLES)', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('69.093-710', '156      ', 'R 32 (CJ MANOA)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.077-350', '156      ', 'R 32 (CJ 31 DE MARCO I)', 'JAPIIM                        ');
INSERT INTO cd_cep_br VALUES ('69.094-320', '156      ', 'R 32 (NUCLEO 3)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.099-140', '156      ', 'R 33', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.038-600', '156      ', 'R 33 (CJ A MONTENEGRO)', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('69.055-510', '156      ', 'R 33 (CJ C BRANCO)', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.044-230', '156      ', 'R 33 (CJ JD VERSALLES)', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('69.093-720', '156      ', 'R 33 (CJ MANOA)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.077-340', '156      ', 'R 33 (CJ 31 DE MARCO I)', 'JAPIIM                        ');
INSERT INTO cd_cep_br VALUES ('69.094-330', '156      ', 'R 33 (NUCLEO 3)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.093-455', '156      ', 'R SETE DE SETEMBRO II(T. NOVA I)', 'COL T NOVA                    ');
INSERT INTO cd_cep_br VALUES ('69.093-449', '156      ', 'R SETE SETEMBRO(T. NOVA I)', 'COL T NOVA                    ');
INSERT INTO cd_cep_br VALUES ('57.055-120', '54       ', 'R NOSSA SENHORA DE LOURDES', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.081-180', '54       ', 'R NOSSA SENHORA DE LOURDES', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.052-480', '54       ', 'PRQ NOSSA SENHORA DE LOURDES', 'G LOURDES                     ');
INSERT INTO cd_cep_br VALUES ('57.018-790', '54       ', 'CJ NOSSA SENHORA DO AMPARO', 'BEBEDOURO                     ');
INSERT INTO cd_cep_br VALUES ('57.025-330', '54       ', 'VL NOSSA SENHORA DO CARMO', 'POCO                          ');
INSERT INTO cd_cep_br VALUES ('57.081-210', '54       ', 'R NOSSA SENHORA DO CARMO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.039-700', '54       ', 'R NOSSA SENHORA DO O(LOT JD IPIOPOLIS)', 'F PEIXOTO                     ');
INSERT INTO cd_cep_br VALUES ('57.015-138', '54       ', 'PC NOSSA SENHORA DO PERPETUO SOCORRO', 'V LAGO                        ');
INSERT INTO cd_cep_br VALUES ('57.018-120', '54       ', 'R NOVA', 'BEBEDOURO                     ');
INSERT INTO cd_cep_br VALUES ('57.018-125', '54       ', 'TV NOVA', 'BEBEDOURO                     ');
INSERT INTO cd_cep_br VALUES ('57.040-670', '54       ', 'R NOVA', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.040-675', '54       ', 'TV NOVA', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.070-240', '54       ', 'R NOVA', 'R NOVO                        ');
INSERT INTO cd_cep_br VALUES ('57.060-540', '54       ', 'R NOVA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.018-590', '54       ', 'R NOVA', 'C JAQUEIRA                    ');
INSERT INTO cd_cep_br VALUES ('57.071-735', '54       ', 'R NOVA', 'A S DUMONT                    ');
INSERT INTO cd_cep_br VALUES ('57.038-380', '54       ', 'R NOVA BRASILIA', 'C ALMAS                       ');
INSERT INTO cd_cep_br VALUES ('57.060-160', '54       ', 'R NOVA BRASILIA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.060-165', '54       ', 'TV NOVA BRASILIA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.014-620', '54       ', 'R NOVA ESPERANCA', 'P GROSSA                      ');
INSERT INTO cd_cep_br VALUES ('57.045-110', '54       ', 'CJ NOVA ESPERANCA', 'B DURO                        ');
INSERT INTO cd_cep_br VALUES ('57.060-860', '54       ', 'R NOVA NASCENCA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.017-210', '54       ', 'R NOVA VILA', 'B PARTO                       ');
INSERT INTO cd_cep_br VALUES ('57.084-600', '54       ', 'CJ NOVO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.051-500', '54       ', 'AV MOREIRA E SILVA', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.020-220', '54       ', 'AV MOREIRA LIMA', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.082-500', '54       ', 'CJ MOURA CASTRO I', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.082-510', '54       ', 'CJ MOURA CASTRO II', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.081-290', '54       ', 'AV MUCAMBO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.055-530', '54       ', 'AL MUNDAU', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.010-020', '54       ', 'PRQ MUNICIPAL DOUTOR AFRANIO JORGE', 'PRADO                         ');
INSERT INTO cd_cep_br VALUES ('57.045-000', '54       ', 'R MUNIZ FALCAO', 'B DURO                        ');
INSERT INTO cd_cep_br VALUES ('57.045-005', '54       ', 'TV MUNIZ FALCAO', 'B DURO                        ');
INSERT INTO cd_cep_br VALUES ('57.040-740', '54       ', 'R MUNIZ FALCAO', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.043-330', '54       ', 'R PAU D ARCO', 'FEITOSA                       ');
INSERT INTO cd_cep_br VALUES ('57.040-360', '54       ', 'R PAU D ARCO', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.040-365', '54       ', 'TV PAU D ARCO', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.052-500', '54       ', 'R PAU D ARCO', 'G LOURDES                     ');
INSERT INTO cd_cep_br VALUES ('57.043-340', '54       ', 'CJ PAU D ARCO', 'FEITOSA                       ');
INSERT INTO cd_cep_br VALUES ('57.070-390', '54       ', 'LOT PAU MAR', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.074-050', '54       ', 'R PAU-BRASIL (LOT PARQUE DAS ARVORES)', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.037-110', '54       ', 'R PAULINA MARIA MENDONCA', 'MANGABEIRAS                   ');
INSERT INTO cd_cep_br VALUES ('57.055-760', '54       ', 'R PAULO AFONSO', 'PINHEIRO                      ');
INSERT INTO cd_cep_br VALUES ('57.041-630', '54       ', 'R PAULO ANANIAS', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.061-340', '54       ', 'R PAULO AUGUSTO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.057-230', '54       ', 'R PAULO AUTO DE OLIVEIRA', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.030-590', '54       ', 'R PAULO CEZAR BELLO', 'POCO                          ');
INSERT INTO cd_cep_br VALUES ('57.057-400', '54       ', 'R PAULO DE ANDRADE JOAZEIRO', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.036-390', '54       ', 'AV PAULO FALCAO', 'JATIUCA                       ');
INSERT INTO cd_cep_br VALUES ('57.042-440', '54       ', 'R PAULO FEIJO DA SILVEIRA', 'B VISTA                       ');
INSERT INTO cd_cep_br VALUES ('57.080-585', '54       ', 'PC PAULO JACINTO TENORIO NETO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.046-550', '54       ', 'R PAULO JOSE FALCAO ARAGAO(RUA EM PROJETO 1 LOT', 'SERRARIA                      ');
INSERT INTO cd_cep_br VALUES ('57.046-710', '54       ', 'R PAULO LOBO ASSUMPCAO', 'B DURO                        ');
INSERT INTO cd_cep_br VALUES ('57.040-830', '54       ', 'R PAULO NETO', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.060-820', '54       ', 'R PAULO RIBEIRO DOS SANTOS', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.020-740', '54       ', 'R PAULO ROBERTO SANTOS', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.042-430', '54       ', 'AV OTONIEL PIMENTEL SANTOS', 'B VISTA                       ');
INSERT INTO cd_cep_br VALUES ('57.045-595', '54       ', 'TV OURO PRETO', 'O PRETO                       ');
INSERT INTO cd_cep_br VALUES ('57.045-590', '54       ', 'R OURO PRETO', 'O PRETO                       ');
INSERT INTO cd_cep_br VALUES ('57.030-130', '54       ', 'R OUVIDOR BATALHA', 'PAJUCARA                      ');
INSERT INTO cd_cep_br VALUES ('57.072-690', '54       ', 'R OVERLAC ROCHA BUENOS AYRES', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.083-230', '54       ', 'R PADRE ANTONIO CABRAL GOMES', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.070-330', '54       ', 'R PADRE CABRAL', 'F VELHO                       ');
INSERT INTO cd_cep_br VALUES ('57.043-140', '54       ', 'R PADRE CICERO', 'FEITOSA                       ');
INSERT INTO cd_cep_br VALUES ('57.040-350', '54       ', 'R PADRE CICERO', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.040-355', '54       ', 'TV PADRE CICERO', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.045-600', '54       ', 'R PADRE CICERO', 'O PRETO                       ');
INSERT INTO cd_cep_br VALUES ('57.050-330', '54       ', 'R PADRE CICERO', 'PITANGUINHA                   ');
INSERT INTO cd_cep_br VALUES ('57.071-220', '54       ', 'AV PADRE CICERO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.081-190', '54       ', 'R PADRE CICERO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.015-140', '54       ', 'PC PADRE CICERO', 'P GROSSA                      ');
INSERT INTO cd_cep_br VALUES ('57.017-220', '54       ', 'R PADRE CICERO', 'B PARTO                       ');
INSERT INTO cd_cep_br VALUES ('57.018-480', '54       ', 'R PADRE CICERO', 'C JAQUEIRA                    ');
INSERT INTO cd_cep_br VALUES ('57.045-605', '54       ', 'TV PADRE CICERO', 'O PRETO                       ');
INSERT INTO cd_cep_br VALUES ('57.071-625', '54       ', 'TV PADRE CICERO', 'A S DUMONT                    ');
INSERT INTO cd_cep_br VALUES ('57.011-310', '54       ', 'R PADRE JOSE DE ANCHIETA', 'T BARRA                       ');
INSERT INTO cd_cep_br VALUES ('57.038-130', '54       ', 'R PADRE LUIZ AMERICO GALVAO', 'MANGABEIRAS                   ');
INSERT INTO cd_cep_br VALUES ('57.039-140', '54       ', 'R PADRE ODILON LOBO', 'R DOCE                        ');
INSERT INTO cd_cep_br VALUES ('57.018-280', '54       ', 'CJ PADRE PINHO', 'BEBEDOURO                     ');
INSERT INTO cd_cep_br VALUES ('57.010-490', '54       ', 'R PADRE SILVESTRE VEDREGOOR(ANTIGA RUA DO CANTO)', 'T BARRA                       ');
INSERT INTO cd_cep_br VALUES ('57.041-610', '54       ', 'R PADRE SIZENANDO SILVA', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.073-490', '54       ', 'AV PAJUSSARA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.071-555', '54       ', 'R PALHA, DA', 'A S DUMONT                    ');
INSERT INTO cd_cep_br VALUES ('57.076-060', '54       ', 'LOT PALMARES', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.020-150', '54       ', 'PC PALMARES, DOS', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.055-470', '54       ', 'R PALMARES, DOS', 'PINHEIRO                      ');
INSERT INTO cd_cep_br VALUES ('57.074-110', '54       ', 'R PALMEIRA (LOT PARQUE DAS ARVORES)', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.045-610', '54       ', 'R PALMEIRA DOS INDIOS', 'SERRARIA                      ');
INSERT INTO cd_cep_br VALUES ('57.038-400', '54       ', 'R PALMEIRA DOS INDIOS', 'C ALMAS                       ');
INSERT INTO cd_cep_br VALUES ('57.045-615', '54       ', 'TV PALMEIRA DOS INDIOS', 'SERRARIA                      ');
INSERT INTO cd_cep_br VALUES ('57.018-130', '54       ', 'R PALMEIRAS, DAS', 'BEBEDOURO                     ');
INSERT INTO cd_cep_br VALUES ('57.015-350', '54       ', 'TV PANAIR', 'V LAGO                        ');
INSERT INTO cd_cep_br VALUES ('57.038-410', '54       ', 'R PAO DE ACUCAR', 'C ALMAS                       ');
INSERT INTO cd_cep_br VALUES ('57.080-100', '54       ', 'R PAO DE ACUCAR', 'CANAA                         ');
INSERT INTO cd_cep_br VALUES ('57.082-660', '54       ', 'LOT NOVO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.075-060', '54       ', 'LOT NOVO HORIZONTE', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.040-575', '54       ', 'R NOVO HORIZONTE', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.045-580', '54       ', 'CJ NOVO MUNDO', 'B DURO                        ');
INSERT INTO cd_cep_br VALUES ('57.042-770', '54       ', 'LOT NOVO MUNDO', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.073-050', '54       ', 'R ODILON CUPERTINO DE GOUVEIA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.082-640', '54       ', 'R ODILON FRANCISCO DE ASSIS', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.040-140', '54       ', 'R ODILON PROTASIO', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.057-390', '54       ', 'R ODILON TENORIO CAVALCANTE', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('69.098-190', '156      ', 'R 188 (NUCLEO 16)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.098-200', '156      ', 'R 189 (NUCLEO 16)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('57.601-360', '40       ', 'R ANTONIO CAPITULINO VASCONCELOS', 'S CRISTOVAO                   ');
INSERT INTO cd_cep_br VALUES ('57.607-390', '40       ', 'R ANTONIO ELIZIARIO', 'S CRISTOVAO                   ');
INSERT INTO cd_cep_br VALUES ('57.606-017', '40       ', 'R ANTONIO GALDINO DOS SANTOS', 'EUCALIPTOS                    ');
INSERT INTO cd_cep_br VALUES ('57.601-170', '40       ', 'R ANTONIO JOAQUIM DUARTE', 'S CRISTOVAO                   ');
INSERT INTO cd_cep_br VALUES ('57.607-310', '40       ', 'R ANTONIO LIMA', 'S CRISTOVAO                   ');
INSERT INTO cd_cep_br VALUES ('57.602-190', '40       ', 'R ANTONIO MARQUES AMORIM', 'S FRANCISCO                   ');
INSERT INTO cd_cep_br VALUES ('57.601-040', '40       ', 'R ANTONIO MATIAS', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.607-400', '40       ', 'R ARMANDO BARBOSA', 'S CRISTOVAO                   ');
INSERT INTO cd_cep_br VALUES ('57.607-410', '40       ', 'R ARMANDO SOARES VILARINS', 'S CRISTOVAO                   ');
INSERT INTO cd_cep_br VALUES ('57.015-410', '54       ', 'R VILA ALMEIDA', 'V LAGO                        ');
INSERT INTO cd_cep_br VALUES ('57.017-540', '54       ', 'R VILA BRASILIA', 'BEBEDOURO                     ');
INSERT INTO cd_cep_br VALUES ('57.014-630', '54       ', 'R VILA KENNEDY', 'P GROSSA                      ');
INSERT INTO cd_cep_br VALUES ('57.070-150', '54       ', 'R VILA OPERARIA', 'F VELHO                       ');
INSERT INTO cd_cep_br VALUES ('57.051-650', '54       ', 'R VILA REDENCAO', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.060-220', '54       ', 'R VILA RICA NOVA BRASILIA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.061-430', '54       ', 'CJ VILAGE DO FAROL', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.061-290', '54       ', 'CJ VILAGE DO PLANALTO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.073-020', '54       ', 'CJ VILLAGE CAMPESTRE I', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.073-450', '54       ', 'CJ VILLAGE CAMPESTRE II', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.015-420', '54       ', 'CJ VINICIUS CANSANCAO', 'V LAGO                        ');
INSERT INTO cd_cep_br VALUES ('57.036-330', '54       ', 'R VINICIUS DE MORAIS', 'JATIUCA                       ');
INSERT INTO cd_cep_br VALUES ('57.011-380', '54       ', 'R VINTE E OITO DE SETEMBRO', 'T BARRA                       ');
INSERT INTO cd_cep_br VALUES ('57.015-020', '54       ', 'R VINTE E QUATRO DE OUTUBRO', 'V LAGO                        ');
INSERT INTO cd_cep_br VALUES ('57.025-570', '54       ', 'R VINTE E SEIS DE ABRIL', 'POCO                          ');
INSERT INTO cd_cep_br VALUES ('57.011-420', '54       ', 'R VINTE E UM DE ABRIL- ATE 394/401', 'PRADO                         ');
INSERT INTO cd_cep_br VALUES ('57.010-220', '54       ', 'R VINTE E UM DE ABRIL- DE 396/403 AO FIM', 'PRADO                         ');
INSERT INTO cd_cep_br VALUES ('57.014-650', '54       ', 'CJ VIRGEM DOS POBRES I', 'V LAGO                        ');
INSERT INTO cd_cep_br VALUES ('57.014-670', '54       ', 'CJ VIRGEM DOS POBRES II', 'V LAGO                        ');
INSERT INTO cd_cep_br VALUES ('57.018-200', '54       ', 'R VIRGILIO MAURICIO DA ROCHA', 'BEBEDOURO                     ');
INSERT INTO cd_cep_br VALUES ('57.055-710', '54       ', 'R VIRGINIO DE CAMPOS', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.020-720', '54       ', 'PC VISCONDE DE SINIMBU', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.020-730', '54       ', 'LD VISTA ALEGRE', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.042-820', '54       ', 'R VISTA ATLANTICA', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.040-530', '54       ', 'R VITORIA', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.022-130', '54       ', 'R VITORIA', 'JARAGUA                       ');
INSERT INTO cd_cep_br VALUES ('57.057-670', '54       ', 'R VITORIA, DA', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.020-460', '54       ', 'R VOLUNTARIO DA PATRIA', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.072-180', '54       ', 'R WALDEMAR ANDRADE SOBRINHO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.073-270', '54       ', 'R WALDEMAR COSTA OLIVEIRA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.042-150', '54       ', 'R WALDEMIRO NUNES DE ALENCAR BARROS', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.071-320', '54       ', 'AV WALFRIDO GERONIMO DA ROCHA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.071-325', '54       ', 'TV WALFRIDO GERONIMO DA ROCHA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.036-800', '54       ', 'R WALFRIDO ROCHA', 'JATIUCA                       ');
INSERT INTO cd_cep_br VALUES ('57.055-750', '54       ', 'PC WALTER DE CASTRO SOUZA', 'PINHEIRO                      ');
INSERT INTO cd_cep_br VALUES ('57.071-265', '54       ', 'R WELTON ALVES CANDIDO', 'A S DUMONT                    ');
INSERT INTO cd_cep_br VALUES ('57.072-330', '54       ', 'R WILSON GAMA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.015-820', '54       ', 'TV WILSON NOGUEIRA', 'V LAGO                        ');
INSERT INTO cd_cep_br VALUES ('57.070-470', '54       ', 'AV VALDEMAR RUFINO DOS SANTOSESTRADA DA VILA PEDR', 'F VELHO                       ');
INSERT INTO cd_cep_br VALUES ('57.020-620', '54       ', 'R VALDIMIR DE MIRANDA', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.014-580', '54       ', 'R VALDO ARAUJO DE AZEVEDO', 'V LAGO                        ');
INSERT INTO cd_cep_br VALUES ('57.035-170', '54       ', 'R VALDO OMENA', 'P VERDE                       ');
INSERT INTO cd_cep_br VALUES ('57.046-480', '54       ', 'CJ VALE DA SERRARIA', 'SERRARIA                      ');
INSERT INTO cd_cep_br VALUES ('57.042-520', '54       ', 'CJ VALE DO FEITOSA', 'FEITOSA                       ');
INSERT INTO cd_cep_br VALUES ('57.055-700', '54       ', 'R VALMERI DOS SANTOS COSTA', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.071-785', '54       ', 'R VANILDO BARROS', 'A S DUMONT                    ');
INSERT INTO cd_cep_br VALUES ('57.082-120', '54       ', 'R VASCONCELOS DUARTE', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.037-310', '54       ', 'R VENERAVEL JOAO VIEIRA CHAGAS', 'MANGABEIRAS                   ');
INSERT INTO cd_cep_br VALUES ('57.038-520', '54       ', 'PC VERA CRUZ', 'C ALMAS                       ');
INSERT INTO cd_cep_br VALUES ('57.607-110', '40       ', 'R PERNAMBUCO', 'JD BRASIL                     ');
INSERT INTO cd_cep_br VALUES ('57.607-070', '40       ', 'R PIAUI', 'JD BRASIL                     ');
INSERT INTO cd_cep_br VALUES ('57.600-430', '40       ', 'R PIO DOZE', 'AT CRUZEIRO                   ');
INSERT INTO cd_cep_br VALUES ('57.600-435', '40       ', 'TV PIO DOZE', 'AT CRUZEIRO                   ');
INSERT INTO cd_cep_br VALUES ('57.607-240', '40       ', 'R PONCIANO LIMA E SILVA', 'VL MARIA                      ');
INSERT INTO cd_cep_br VALUES ('57.605-170', '40       ', 'PC PREFEITO JOSE ARAUJO', 'S FRANCISCO                   ');
INSERT INTO cd_cep_br VALUES ('57.602-030', '40       ', 'R PREFEITO MIGUEL LOPES', 'PARAISO                       ');
INSERT INTO cd_cep_br VALUES ('57.601-520', '40       ', 'R PREFEITO MINERVO PIMENTEL', 'P FORA                        ');
INSERT INTO cd_cep_br VALUES ('57.600-500', '40       ', 'AV PROFESSOR FELINTO', 'T CAVALCANTE                  ');
INSERT INTO cd_cep_br VALUES ('57.600-440', '40       ', 'R PROFESSOR GUEDES DE MIRANDA', 'AT CRUZEIRO                   ');
INSERT INTO cd_cep_br VALUES ('57.600-445', '40       ', 'TV PROFESSOR GUEDES DE MIRANDA', 'AT CRUZEIRO                   ');
INSERT INTO cd_cep_br VALUES ('57.601-480', '40       ', 'R PROFESSOR JOSE BRANCO', 'S CRISTOVAO                   ');
INSERT INTO cd_cep_br VALUES ('57.602-110', '40       ', 'R PROFESSOR JOSE LIMEIRA', 'PARAISO                       ');
INSERT INTO cd_cep_br VALUES ('57.606-014', '40       ', 'AV VIEIRA DE BRITO', 'EUCALIPTOS                    ');
INSERT INTO cd_cep_br VALUES ('57.601-100', '40       ', 'AV VIEIRA DE BRITO- ATE 668/675', 'S CRISTOVAO                   ');
INSERT INTO cd_cep_br VALUES ('57.607-010', '40       ', 'AV VIEIRA DE BRITO- DE 669/676 AO FIM', 'VL MARIA                      ');
INSERT INTO cd_cep_br VALUES ('57.605-070', '40       ', 'R VIGARIO LESSA', 'S FRANCISCO                   ');
INSERT INTO cd_cep_br VALUES ('57.600-140', '40       ', 'R VIGARIO MAIA', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.600-640', '40       ', 'R VILA NOVA', 'VL NOVA                       ');
INSERT INTO cd_cep_br VALUES ('57.601-150', '40       ', 'R VINTE DE AGOSTO', 'S CRISTOVAO                   ');
INSERT INTO cd_cep_br VALUES ('57.600-340', '40       ', 'R VINTE DE JULHO', 'AT CRUZEIRO                   ');
INSERT INTO cd_cep_br VALUES ('57.601-330', '40       ', 'R VINTE E SETE DE JULHO', 'S CRISTOVAO                   ');
INSERT INTO cd_cep_br VALUES ('57.607-490', '40       ', 'R ZE BARBOSA', 'S CRISTOVAO                   ');
INSERT INTO cd_cep_br VALUES ('57.600-680', '40       ', 'PC ZECA LEONCIO', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.607-580', '40       ', 'R ZEZINHO QUEIROZ', 'VL MARIA                      ');
INSERT INTO cd_cep_br VALUES ('57.600-400', '40       ', 'R SANTA ISABEL', 'AT CRUZEIRO                   ');
INSERT INTO cd_cep_br VALUES ('57.607-380', '40       ', 'R SANTINA ROQUE', 'S CRISTOVAO                   ');
INSERT INTO cd_cep_br VALUES ('57.600-410', '40       ', 'R SANTO ANTONIO', 'AT CRUZEIRO                   ');
INSERT INTO cd_cep_br VALUES ('57.601-390', '40       ', 'LOT SAO CARLOS', 'S CRISTOVAO                   ');
INSERT INTO cd_cep_br VALUES ('57.601-120', '40       ', 'LRG SAO CRISTOVAO', 'S CRISTOVAO                   ');
INSERT INTO cd_cep_br VALUES ('57.600-420', '40       ', 'R SAO GERALDO', 'AT CRUZEIRO                   ');
INSERT INTO cd_cep_br VALUES ('57.600-580', '40       ', 'R SAO JOAO', 'RIBEIRA                       ');
INSERT INTO cd_cep_br VALUES ('57.607-530', '40       ', 'R SAO JORGE', 'S CRISTOVAO                   ');
INSERT INTO cd_cep_br VALUES ('57.606-002', '40       ', 'R SAO JOSE', 'EUCALIPTOS                    ');
INSERT INTO cd_cep_br VALUES ('57.600-380', '40       ', 'R SAO MIGUEL', 'AT CRUZEIRO                   ');
INSERT INTO cd_cep_br VALUES ('57.601-190', '40       ', 'PC SAO PEDRO', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.600-110', '40       ', 'R SAO VICENTE', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.603-040', '40       ', 'R SEBASTIAO BARBOSA', 'S CRISTOVAO                   ');
INSERT INTO cd_cep_br VALUES ('57.602-280', '40       ', 'R SEBASTIAO MEDEIROS', 'S FRANCISCO                   ');
INSERT INTO cd_cep_br VALUES ('57.601-200', '40       ', 'R SEBASTIAO RAMOS', 'S CRISTOVAO                   ');
INSERT INTO cd_cep_br VALUES ('57.607-120', '40       ', 'R SERGIPE', 'JD BRASIL                     ');
INSERT INTO cd_cep_br VALUES ('69.151-280', '161      ', 'R SILVA MEIRELES', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('69.153-130', '161      ', 'R SILVES', 'PALMARES                      ');
INSERT INTO cd_cep_br VALUES ('69.152-610', '161      ', 'R SOUZA FILHO (CJ SHAM)', 'S F ASSIS                     ');
INSERT INTO cd_cep_br VALUES ('57.303-050', '23       ', 'R MANOEL DO NASCIMENTO ABREU', 'S LUIZ                        ');
INSERT INTO cd_cep_br VALUES ('57.313-140', '23       ', 'R MANOEL DOMINGOS DE FARIAS', 'BRASILIA                      ');
INSERT INTO cd_cep_br VALUES ('57.303-180', '23       ', 'R MANOEL FERNANDES DA SILVA', 'B VISTA                       ');
INSERT INTO cd_cep_br VALUES ('57.306-370', '23       ', 'R MANOEL FERREIRA BRITO', 'CAVACO                        ');
INSERT INTO cd_cep_br VALUES ('57.302-410', '23       ', 'R MANOEL FERREIRA DE ALBUQUERQUE', 'N ESPERANCA                   ');
INSERT INTO cd_cep_br VALUES ('57.313-120', '23       ', 'R MANOEL FIRMINO LEITE', 'BRASILIA                      ');
INSERT INTO cd_cep_br VALUES ('57.312-350', '23       ', 'R MANOEL FRANCELINO DE ALBUQUERQUE', 'AT CRUZEIRO                   ');
INSERT INTO cd_cep_br VALUES ('57.310-260', '23       ', 'R MANOEL FRANCISCO CAZUZA', 'R CRUZ                        ');
INSERT INTO cd_cep_br VALUES ('57.305-630', '23       ', 'R MANOEL FRANCISCO DE LIMA', 'M TELES                       ');
INSERT INTO cd_cep_br VALUES ('57.302-240', '23       ', 'R MANOEL GAMA FARIAS', 'S LUIZ                        ');
INSERT INTO cd_cep_br VALUES ('57.302-470', '23       ', 'R MANOEL J. OLIVEIRA', 'N ESPERANCA                   ');
INSERT INTO cd_cep_br VALUES ('57.302-140', '23       ', 'R MANOEL JOAO', 'CANAFISTULA                   ');
INSERT INTO cd_cep_br VALUES ('57.304-840', '23       ', 'R JOSEFA ROSA DE OLIVEIRA', 'O D CAZUZINHOS                ');
INSERT INTO cd_cep_br VALUES ('57.308-700', '23       ', 'R JOSEFA UMBELINA DE BARROS', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('57.304-260', '23       ', 'R JUCA MAGALHAES', 'PRIMAVERA                     ');
INSERT INTO cd_cep_br VALUES ('57.300-490', '23       ', 'R JULIA ALVES FREIRE', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.308-040', '23       ', 'R JULIA LIMA DA SILVA', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('57.314-030', '23       ', 'R JULIA PEREIRA VIANA DE MELO', 'ITAPOA                        ');
INSERT INTO cd_cep_br VALUES ('57.307-090', '23       ', 'R JULIO FERREIRA MENDONCA', 'BX GRANDE                     ');
INSERT INTO cd_cep_br VALUES ('57.308-020', '23       ', 'R JULIO HONORATO DA SILVA', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('57.307-010', '23       ', 'R JULIO PAIXAO DA SILVA', 'BX GRANDE                     ');
INSERT INTO cd_cep_br VALUES ('57.307-360', '23       ', 'R JULIO PEREIRA BARBOSA', 'JD ESPERANCA                  ');
INSERT INTO cd_cep_br VALUES ('57.302-190', '23       ', 'R JULIO RAFAEL', 'CANAFISTULA                   ');
INSERT INTO cd_cep_br VALUES ('57.312-660', '23       ', 'R JULITA LEMOS PALMEIRA', 'N HORIZONTE                   ');
INSERT INTO cd_cep_br VALUES ('57.308-500', '23       ', 'R JUNQUEIRO', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('57.303-590', '23       ', 'PC JURACY CAMELO DOS SANTOS', 'GUARIBAS                      ');
INSERT INTO cd_cep_br VALUES ('57.313-220', '23       ', 'R JURACY CAMELO SANTOS', 'BRASILIA                      ');
INSERT INTO cd_cep_br VALUES ('57.301-310', '23       ', 'R JURANDIR ANDRE', 'S LUIZ                        ');
INSERT INTO cd_cep_br VALUES ('57.306-160', '23       ', 'R JUSCELINO KUBITSCHEK DE OLIVEIRA', 'ELDORADO                      ');
INSERT INTO cd_cep_br VALUES ('57.306-430', '23       ', 'R JUSTINO FAUSTO DE OLIVEIRA', 'CAVACO                        ');
INSERT INTO cd_cep_br VALUES ('57.312-070', '23       ', 'R JUSTINO SEBASTIAO DA SILVA', 'S ESMERALDA                   ');
INSERT INTO cd_cep_br VALUES ('57.310-210', '23       ', 'R NATALICIO CAVALCANTE LIMA', 'CAPIATA                       ');
INSERT INTO cd_cep_br VALUES ('57.308-090', '23       ', 'R NE FIRMINO', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('57.303-080', '23       ', 'R NEIDE BARBOSA ROCHA', 'S LUIZ                        ');
INSERT INTO cd_cep_br VALUES ('57.304-770', '23       ', 'R NELMA MACEDO TEIXEIRA', 'PRIMAVERA                     ');
INSERT INTO cd_cep_br VALUES ('57.303-480', '23       ', 'R NELSON ALBUQUERQUE', 'GUARIBAS                      ');
INSERT INTO cd_cep_br VALUES ('57.307-080', '23       ', 'R NOEL FREIRE', 'BX GRANDE                     ');
INSERT INTO cd_cep_br VALUES ('57.300-020', '23       ', 'R NOSSA SENHORA APARECIDA', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.311-210', '23       ', 'R NOSSA SENHORA DA PENHA', 'CAITITUS                      ');
INSERT INTO cd_cep_br VALUES ('57.312-590', '23       ', 'R NOSSA SENHORA DA SALETE- ATE 494/517', 'AT CRUZEIRO                   ');
INSERT INTO cd_cep_br VALUES ('57.314-010', '23       ', 'R NOSSA SENHORA DA SALETE- DE 496/519 AO FIM', 'AT CRUZEIRO                   ');
INSERT INTO cd_cep_br VALUES ('57.311-130', '23       ', 'R NOSSA SENHORA DAS DORES', 'S T VILELA                    ');
INSERT INTO cd_cep_br VALUES ('57.313-040', '23       ', 'R NOSSA SENHORA DE FATIMA', 'BRASILIA                      ');
INSERT INTO cd_cep_br VALUES ('57.313-310', '23       ', 'R NOSSA SENHORA DO O', 'BRASILIA                      ');
INSERT INTO cd_cep_br VALUES ('57.306-700', '23       ', 'R MARIA CLEONICE DOS SANTOS', 'CAVACO                        ');
INSERT INTO cd_cep_br VALUES ('57.306-330', '23       ', 'R MARIA DA GLORIA DOS SANTOS RIBEIRO', 'CAVACO                        ');
INSERT INTO cd_cep_br VALUES ('57.307-370', '23       ', 'PC MARIA DAS DORES CARVALHO LIMA', 'JD ESPERANCA                  ');
INSERT INTO cd_cep_br VALUES ('57.312-060', '23       ', 'R MARIA DE BRITO MELO', 'S ESMERALDA                   ');
INSERT INTO cd_cep_br VALUES ('57.307-460', '23       ', 'R MARIA DE CASTRO TAVARES', 'JD ESPERANCA                  ');
INSERT INTO cd_cep_br VALUES ('57.312-390', '23       ', 'R MARIA DE LOURDES ALMEIDA', 'N HORIZONTE                   ');
INSERT INTO cd_cep_br VALUES ('57.312-290', '23       ', 'R MARIA DE LOURDES DE OLIVEIRA', 'S A MELO                      ');
INSERT INTO cd_cep_br VALUES ('57.307-510', '23       ', 'R MARIA DE LOURDES VENTURA MANOELA', 'JD ESPERANCA                  ');
INSERT INTO cd_cep_br VALUES ('57.301-080', '23       ', 'R MARIA DE NAZARE', 'O PRETO                       ');
INSERT INTO cd_cep_br VALUES ('57.313-720', '23       ', 'R MARIA DE OLIVEIRA LIMA', 'BRASILIA                      ');
INSERT INTO cd_cep_br VALUES ('57.310-150', '23       ', 'R MARIA DO AMPARO RIBEIRO', 'CAPIATA                       ');
INSERT INTO cd_cep_br VALUES ('57.310-360', '23       ', 'R MARIA DOS ANJOS', 'CAPIATA                       ');
INSERT INTO cd_cep_br VALUES ('57.306-580', '23       ', 'R MARIA DUDU', 'CAVACO                        ');
INSERT INTO cd_cep_br VALUES ('57.302-100', '23       ', 'R MARIA ESPOSORIA OLIVEIRA', 'CANAFISTULA                   ');
INSERT INTO cd_cep_br VALUES ('57.305-450', '23       ', 'R MARIA ESTELINA DOS SANTOS', 'BAIXAO                        ');
INSERT INTO cd_cep_br VALUES ('57.312-690', '23       ', 'R MARIA GOMES EVANGELISTA', 'S ESMERALDA                   ');
INSERT INTO cd_cep_br VALUES ('57.306-260', '23       ', 'R MARIA GUILHERMINA BARBOSA', 'ELDORADO                      ');
INSERT INTO cd_cep_br VALUES ('57.303-270', '23       ', 'R MARIA ISABEL DE ALMEIDA', 'B VISTA                       ');
INSERT INTO cd_cep_br VALUES ('57.305-640', '23       ', 'R MARIA JOANA', 'M TELES                       ');
INSERT INTO cd_cep_br VALUES ('57.312-720', '23       ', 'R MARIA JOSE DA SILVA', 'AT CRUZEIRO                   ');
INSERT INTO cd_cep_br VALUES ('57.313-510', '23       ', 'R MARIA JULIA FERREIRA ALBURQUERQUE', 'JD TROPICAL                   ');
INSERT INTO cd_cep_br VALUES ('57.306-550', '23       ', 'R MARIA LIMA', 'CAVACO                        ');
INSERT INTO cd_cep_br VALUES ('57.302-310', '23       ', 'R MARIA LOPES', 'S LUIZ                        ');
INSERT INTO cd_cep_br VALUES ('57.313-280', '23       ', 'R MARIA MORENA GOMES', 'BRASILIA                      ');
INSERT INTO cd_cep_br VALUES ('57.313-520', '23       ', 'R MARIA NOBRE', 'JD TROPICAL                   ');
INSERT INTO cd_cep_br VALUES ('57.313-650', '23       ', 'R MARIA ROGERIA BRITO', 'JD TROPICAL                   ');
INSERT INTO cd_cep_br VALUES ('57.313-540', '23       ', 'R MARIA TERTO DA SILVA', 'JD TROPICAL                   ');
INSERT INTO cd_cep_br VALUES ('57.310-180', '23       ', 'R MARIA VICENIA DE ALBUQUERQUE', 'CAPIATA                       ');
INSERT INTO cd_cep_br VALUES ('57.306-410', '23       ', 'R MARIA XAVIER DE MELO', 'CAVACO                        ');
INSERT INTO cd_cep_br VALUES ('57.310-280', '23       ', 'R MARINES NUNES DOS SANTOS', 'CAPIATA                       ');
INSERT INTO cd_cep_br VALUES ('57.303-570', '23       ', 'R MARINETE LOPES DE OLIVEIRA', 'GUARIBAS                      ');
INSERT INTO cd_cep_br VALUES ('57.301-330', '23       ', 'R MARIO LUIZ SALUSTIANO', 'S LUIZ                        ');
INSERT INTO cd_cep_br VALUES ('57.304-790', '23       ', 'R MARLUCE GUIMARAES', 'CACIMBAS                      ');
INSERT INTO cd_cep_br VALUES ('57.302-110', '23       ', 'R MATIAS VIEIRA', 'CANAFISTULA                   ');
INSERT INTO cd_cep_br VALUES ('57.308-610', '23       ', 'R MATRIZ DE CAMARAGIBE', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('57.310-200', '23       ', 'R MAURICESAR BERNARDE DOS SANTOS', 'CAPIATA                       ');
INSERT INTO cd_cep_br VALUES ('57.305-010', '23       ', 'R MAURICIO PEREIRA- ATE 0869/0920', 'BAIXAO                        ');
INSERT INTO cd_cep_br VALUES ('57.306-440', '23       ', 'R MAURICIO PEREIRA- DE 0871/0922 A 1667/1668', 'BAIXAO                        ');
INSERT INTO cd_cep_br VALUES ('57.307-410', '23       ', 'R MANOEL JOAO DA SILVA', 'JD ESPERANCA                  ');
INSERT INTO cd_cep_br VALUES ('57.304-710', '23       ', 'R MANOEL LEAL', 'CACIMBAS                      ');
INSERT INTO cd_cep_br VALUES ('57.300-160', '23       ', 'R MANOEL LEAO', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.305-180', '23       ', 'R MANOEL LUCINDO DA SILVA', 'M TELES                       ');
INSERT INTO cd_cep_br VALUES ('57.304-350', '23       ', 'R MANOEL LUCIO DA SILVA', 'PRIMAVERA                     ');
INSERT INTO cd_cep_br VALUES ('57.312-360', '23       ', 'R MANOEL LUCIO GOMES', 'AT CRUZEIRO                   ');
INSERT INTO cd_cep_br VALUES ('57.301-180', '23       ', 'R MANOEL LUIZ GOMES', 'S LUIZ                        ');
INSERT INTO cd_cep_br VALUES ('57.300-350', '23       ', 'PC MANOEL LUIZ GOMES', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.314-120', '23       ', 'R MANOEL MARCELINO', 'ITAPOA                        ');
INSERT INTO cd_cep_br VALUES ('57.304-150', '23       ', 'R MANOEL MARTINS LEMOS', 'PRIMAVERA                     ');
INSERT INTO cd_cep_br VALUES ('57.312-600', '23       ', 'R MANOEL NEMEZIO BARBOSA', 'N HORIZONTE                   ');
INSERT INTO cd_cep_br VALUES ('57.310-130', '23       ', 'R MANOEL NUNES NETO', 'CAPIATA                       ');
INSERT INTO cd_cep_br VALUES ('57.306-740', '23       ', 'R MANOEL PEDRO DA SILVA', 'CAVACO                        ');
INSERT INTO cd_cep_br VALUES ('57.312-510', '23       ', 'R MANOEL PEREIRA CORREIA', 'AT CRUZEIRO                   ');
INSERT INTO cd_cep_br VALUES ('57.062-240', '54       ', 'AL ELIZABETH CAVALCANTI GUIMARAES', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('69.047-161', '156      ', 'R SUCUPIRAS', 'REDENCAO                      ');
INSERT INTO cd_cep_br VALUES ('69.040-350', '156      ', 'R SUCUPIRAS, DAS(CJ KYSSIA)', 'D PEDRO                       ');
INSERT INTO cd_cep_br VALUES ('69.063-521', '156      ', 'BC SUCURI', 'PETROPOLIS                    ');
INSERT INTO cd_cep_br VALUES ('69.073-120', '156      ', 'R SUFRAMA, DA', 'CRESPO                        ');
INSERT INTO cd_cep_br VALUES ('69.027-501', '156      ', 'BC SUL AMERICA', 'GLORIA                        ');
INSERT INTO cd_cep_br VALUES ('69.027-500', '156      ', 'R SUL AMERICA', 'GLORIA                        ');
INSERT INTO cd_cep_br VALUES ('69.057-230', '156      ', 'R SULAMITA', 'ADRIANOPOLIS                  ');
INSERT INTO cd_cep_br VALUES ('69.096-041', '156      ', 'R SURI (CJ C NOVA)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.037-260', '156      ', 'AL SURINAM (CJ JD AMERICA)', 'P NEGRA                       ');
INSERT INTO cd_cep_br VALUES ('69.045-830', '156      ', 'R SURINAME (CJ C ELISEOS)', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('69.088-430', '156      ', 'R SURUBIM', 'J TEIXEIRA                    ');
INSERT INTO cd_cep_br VALUES ('69.089-270', '156      ', 'R T', 'A MENDES                      ');
INSERT INTO cd_cep_br VALUES ('69.042-300', '156      ', 'AV T', 'ALVORADA                      ');
INSERT INTO cd_cep_br VALUES ('69.043-490', '156      ', 'R T (CJ DE FLORES II)', 'ALVORADA                      ');
INSERT INTO cd_cep_br VALUES ('69.050-350', '156      ', 'R T (CJ ELDORADO)', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.095-800', '156      ', 'R T (CJ R S PINTO II)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.060-511', '156      ', 'Q T (PRQ ADRIANOPOLIS)', 'ADRIANOPOLIS                  ');
INSERT INTO cd_cep_br VALUES ('69.035-361', '156      ', 'R T-1 (CJ PROMORAR)', 'COMPENSA                      ');
INSERT INTO cd_cep_br VALUES ('69.035-362', '156      ', 'R T-2 (CJ PROMORAR)', 'COMPENSA                      ');
INSERT INTO cd_cep_br VALUES ('69.035-363', '156      ', 'R T-3 (CJ PROMORAR)', 'COMPENSA                      ');
INSERT INTO cd_cep_br VALUES ('69.035-364', '156      ', 'R T-4 (CJ PROMORAR)', 'COMPENSA                      ');
INSERT INTO cd_cep_br VALUES ('69.035-365', '156      ', 'R T-5 (CJ PROMORAR)', 'COMPENSA                      ');
INSERT INTO cd_cep_br VALUES ('69.035-366', '156      ', 'R T-6 (CJ PROMORAR)', 'COMPENSA                      ');
INSERT INTO cd_cep_br VALUES ('69.035-367', '156      ', 'R T-7 (CJ PROMORAR)', 'COMPENSA                      ');
INSERT INTO cd_cep_br VALUES ('69.035-368', '156      ', 'R T-8 (CJ PROMORAR)', 'COMPENSA                      ');
INSERT INTO cd_cep_br VALUES ('69.060-094', '156      ', 'R T/R (CJ M DO SOL)', 'ALEIXO                        ');
INSERT INTO cd_cep_br VALUES ('69.047-650', '156      ', 'R TABA', 'REDENCAO                      ');
INSERT INTO cd_cep_br VALUES ('69.076-463', '156      ', 'R TABATINGA', 'JAPIIM                        ');
INSERT INTO cd_cep_br VALUES ('69.005-170', '156      ', 'TV TABELIAO LESSA', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('69.090-193', '156      ', 'TV TACIARA', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.028-191', '156      ', 'R TAILANDIA (PRQ NACOES)', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('69.047-011', '156      ', 'BC SIAO', 'REDENCAO                      ');
INSERT INTO cd_cep_br VALUES ('69.067-746', '156      ', 'BC SIAO (N JERUSALEM)', 'PETROPOLIS                    ');
INSERT INTO cd_cep_br VALUES ('69.036-330', '156      ', 'R SIDNEY MARTINS (CJ R XINGU)', 'COMPENSA                      ');
INSERT INTO cd_cep_br VALUES ('69.075-341', '156      ', 'BC SILENCIO, DO', 'MAUAZINHO                     ');
INSERT INTO cd_cep_br VALUES ('69.010-180', '156      ', 'R SILVA RAMOS- ATE 344/379', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('69.025-030', '156      ', 'R SILVA RAMOS- DE 346/381 AO FIM', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('69.068-250', '156      ', 'BC SILVES', 'RAIZ                          ');
INSERT INTO cd_cep_br VALUES ('69.087-639', '156      ', 'R SILVIA (N REINO)', 'T NEVES                       ');
INSERT INTO cd_cep_br VALUES ('69.010-130', '156      ', 'R SIMAO BOLIVAR', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('69.063-470', '156      ', 'R SIMPLICIO RUBIM DE PINHO', 'PETROPOLIS                    ');
INSERT INTO cd_cep_br VALUES ('69.067-744', '156      ', 'BC SINFONIA (N JERUSALEM)', 'PETROPOLIS                    ');
INSERT INTO cd_cep_br VALUES ('69.045-790', '156      ', 'R SINGAPURA (CJ C ELISIOS)', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('69.063-660', '156      ', 'R SINVAL DE MOURA', 'PETROPOLIS                    ');
INSERT INTO cd_cep_br VALUES ('69.095-180', '156      ', 'R SIRIANO (CJ C NOVA)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.020-700', '156      ', 'VL SOARES', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('69.073-281', '156      ', 'BC SOARES', 'S LAZARO                      ');
INSERT INTO cd_cep_br VALUES ('69.063-050', '156      ', 'R SOBRINHO MARANHAO', 'S FRANCISCO                   ');
INSERT INTO cd_cep_br VALUES ('69.089-066', '156      ', 'R SOCORRO DE CASTRO', 'Z PALMARES                    ');
INSERT INTO cd_cep_br VALUES ('69.029-360', '156      ', 'R SOCORRO DUTRA', 'S ANTONIO                     ');
INSERT INTO cd_cep_br VALUES ('69.060-770', '156      ', 'CJ SOL NASCENTE', 'ALEIXO                        ');
INSERT INTO cd_cep_br VALUES ('69.078-170', '156      ', 'AL SOL NASCENTE, DO', 'JAPIIM                        ');
INSERT INTO cd_cep_br VALUES ('69.078-160', '156      ', 'CJ SOL NASCENTE, DO', 'JAPIIM                        ');
INSERT INTO cd_cep_br VALUES ('69.060-084', '156      ', 'AV SOL, DO(CJ M DO SOL)', 'ALEIXO                        ');
INSERT INTO cd_cep_br VALUES ('69.060-631', '156      ', 'BC SOLIMOES', 'ALEIXO                        ');
INSERT INTO cd_cep_br VALUES ('69.075-200', '156      ', 'AV SOLIMOES', 'DT INDUSTRIAL                 ');
INSERT INTO cd_cep_br VALUES ('69.068-640', '156      ', 'PRQ SOLIMOES', 'RAIZ                          ');
INSERT INTO cd_cep_br VALUES ('69.036-710', '156      ', 'R SOLIMOES', 'S AGOSTINHO                   ');
INSERT INTO cd_cep_br VALUES ('69.029-190', '156      ', 'R SOLIMOES', 'S ANTONIO                     ');
INSERT INTO cd_cep_br VALUES ('69.075-490', '156      ', 'R SOLIMOES', 'MAUAZINHO                     ');
INSERT INTO cd_cep_br VALUES ('69.029-191', '156      ', 'TV SOLIMOES', 'S ANTONIO                     ');
INSERT INTO cd_cep_br VALUES ('69.084-181', '156      ', 'AV SOLIMOES', 'Z PALMARES                    ');
INSERT INTO cd_cep_br VALUES ('69.077-730', '156      ', 'R SOLIMOES (CJ A ANDREAZA)', 'JAPIIM                        ');
INSERT INTO cd_cep_br VALUES ('69.074-310', '156      ', 'R SOLIMOES (VL MILITAR PONTA PELADA)', 'S LAZARO                      ');
INSERT INTO cd_cep_br VALUES ('69.033-241', '156      ', 'BC SOLON DE LUCENA', 'S JORGE                       ');
INSERT INTO cd_cep_br VALUES ('69.029-041', '156      ', 'BC SOLTUR', 'S ANTONIO                     ');
INSERT INTO cd_cep_br VALUES ('69.093-190', '156      ', 'R SORRISO, DO', 'COL S ANTONIO                 ');
INSERT INTO cd_cep_br VALUES ('69.070-190', '156      ', 'BC SORTE, DA', 'EDUCANDOS                     ');
INSERT INTO cd_cep_br VALUES ('69.086-561', '156      ', 'BC SORTE, DA', 'S J OPERARIO                  ');
INSERT INTO cd_cep_br VALUES ('69.079-170', '156      ', 'R SENADOR LEITAO DA CUNHA', 'S FRANCISCO                   ');
INSERT INTO cd_cep_br VALUES ('69.058-530', '156      ', 'R SERGIPE (PRQ LARANJEIRAS)', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('69.075-710', '156      ', 'R SERINGAL', 'MAUAZINHO                     ');
INSERT INTO cd_cep_br VALUES ('69.085-420', '156      ', 'R SERINGAS, DAS(PRQ ACARIQUARA)', 'COROADO                       ');
INSERT INTO cd_cep_br VALUES ('69.047-721', '156      ', 'R SERRA DOURADA', 'REDENCAO                      ');
INSERT INTO cd_cep_br VALUES ('69.029-610', '156      ', 'BC SERRAO DAS NEVES', 'S ANTONIO                     ');
INSERT INTO cd_cep_br VALUES ('69.070-480', '156      ', 'BC SERRARIA AMAZONAS, DA', 'EDUCANDOS                     ');
INSERT INTO cd_cep_br VALUES ('69.070-750', '156      ', 'R SERRARIA, DA', 'COL O MACHADO                 ');
INSERT INTO cd_cep_br VALUES ('69.025-270', '156      ', 'R SERRARIA, DA', 'P VARGAS                      ');
INSERT INTO cd_cep_br VALUES ('69.025-440', '156      ', 'BC SERRARIA, DA', 'P VARGAS                      ');
INSERT INTO cd_cep_br VALUES ('69.045-780', '156      ', 'R SERTA (CJ C ELISIOS)', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('69.043-840', '156      ', 'EST SESC, DO', 'ALVORADA                      ');
INSERT INTO cd_cep_br VALUES ('69.097-793', '156      ', 'R SESSENTA E CINCO(O. FROTA II)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.097-794', '156      ', 'R SESSENTA E CINCO - A(O. FROTA II)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.099-351', '156      ', 'R SESSENTA E QUATRO - A(A. MENDES)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.097-795', '156      ', 'R SESSENTA E SETE(O. FROTA II)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.097-796', '156      ', 'R SESSENTA E SETE - A(O. FROTA II)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.073-160', '156      ', 'BC SETE', 'S LAZARO                      ');
INSERT INTO cd_cep_br VALUES ('69.098-765', '156      ', 'TV SETE(A. MENDES)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.085-647', '156      ', 'R SETE (ASTECA)', 'S J OPERARIO                  ');
INSERT INTO cd_cep_br VALUES ('69.042-400', '156      ', 'R SETE DE ABRIL', 'ALVORADA                      ');
INSERT INTO cd_cep_br VALUES ('69.084-480', '156      ', 'R SETE DE ABRIL', 'Z PALMARES                    ');
INSERT INTO cd_cep_br VALUES ('69.042-401', '156      ', 'TV SETE DE ABRIL', 'ALVORADA                      ');
INSERT INTO cd_cep_br VALUES ('69.084-490', '156      ', 'R SETE DE DEZEMBRO', 'Z PALMARES                    ');
INSERT INTO cd_cep_br VALUES ('69.059-140', '156      ', 'R SETE DE MAIO', 'S ETELVINA                    ');
INSERT INTO cd_cep_br VALUES ('69.008-270', '156      ', 'R SETE DE MAIO', 'COL A ALEIXO                  ');
INSERT INTO cd_cep_br VALUES ('69.035-390', '156      ', 'R SETE DE SETEMBRO', 'COMPENSA                      ');
INSERT INTO cd_cep_br VALUES ('69.005-140', '156      ', 'AV SETE DE SETEMBRO- ATE 0888/1001', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('69.005-141', '156      ', 'AV SETE DE SETEMBRO- DE 0900/1003 A 1736/1737', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('69.020-120', '156      ', 'AV SETE DE SETEMBRO- DE 1738/1739 AO 2198/2199', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('69.065-170', '156      ', 'AV SETE DE SETEMBRO- DE 2200/2201 AO FIM', 'CACHOEIRINHA                  ');
INSERT INTO cd_cep_br VALUES ('57.045-265', '54       ', 'TV BOM DESTINO', 'B DURO                        ');
INSERT INTO cd_cep_br VALUES ('57.014-660', '54       ', 'R BOM DESTINO', 'P GROSSA                      ');
INSERT INTO cd_cep_br VALUES ('69.099-540', '156      ', 'R 53 (A MENDES)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.097-787', '156      ', 'R 53 (CJ S PESSOA)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.077-540', '156      ', 'R 53 (CJ 31 DE MARCO I)', 'JAPIIM                        ');
INSERT INTO cd_cep_br VALUES ('69.095-410', '156      ', 'R 53 (NUCLEO 5)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.099-280', '156      ', 'R 54 (A MENDES)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.097-763', '156      ', 'R 54 (CJ F MENDES II)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.077-550', '156      ', 'R 54 (CJ 31 DE MARCO I)', 'JAPIIM                        ');
INSERT INTO cd_cep_br VALUES ('69.095-420', '156      ', 'R 54 (NUCLEO 5)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.099-290', '156      ', 'R 55 (A MENDES)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.097-786', '156      ', 'R 55 (CJ S PESSOA)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.077-560', '156      ', 'R 55 (CJ 31 DE MARCO I)', 'JAPIIM                        ');
INSERT INTO cd_cep_br VALUES ('69.095-430', '156      ', 'R 55 (NUCLEO 5)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.099-300', '156      ', 'R 56 (A MENDES)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.097-764', '156      ', 'R 56 (CJ S PESSOA)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.077-570', '156      ', 'R 56 (CJ 31 DE MARCO I)', 'JAPIIM                        ');
INSERT INTO cd_cep_br VALUES ('69.094-370', '156      ', 'R 56 (NUCLEO 4)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.099-550', '156      ', 'R 57 (A MENDES)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.097-785', '156      ', 'R 57 (CJ S PESSOA)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.094-380', '156      ', 'R 57 (NUCLEO 4)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.099-310', '156      ', 'R 58 (A MENDES)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.097-765', '156      ', 'R 58 (CJ S PESSOA)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.094-390', '156      ', 'R 58 (NUCLEO 4)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.055-590', '156      ', 'R 41 (CJ C BRANCO)', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.097-744', '156      ', 'R 41 (CJ O FROTA II)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.077-420', '156      ', 'R 41 (CJ 31 DE MARCO I)', 'JAPIIM                        ');
INSERT INTO cd_cep_br VALUES ('69.095-290', '156      ', 'R 41 (NUCLEO 5)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.099-200', '156      ', 'R 42 (A MENDES)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.038-690', '156      ', 'R 42 (CJ A MONTENEGRO)', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('69.055-600', '156      ', 'R 42 (CJ C BRANCO)', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.097-769', '156      ', 'R 42 (CJ S PESSOA)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.077-430', '156      ', 'R 42 (CJ 31 DE MARCO I)', 'JAPIIM                        ');
INSERT INTO cd_cep_br VALUES ('69.095-300', '156      ', 'R 42 (NUCLEO 5)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.099-210', '156      ', 'R 43 (A MENDES)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.038-700', '156      ', 'R 43 (CJ A MONTENEGRO)', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('69.055-610', '156      ', 'R 43 (CJ C BRANCO)', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.097-745', '156      ', 'R 43 (CJ O FROTA II)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.077-440', '156      ', 'R 43 (CJ 31 DE MARCO I)', 'JAPIIM                        ');
INSERT INTO cd_cep_br VALUES ('69.095-310', '156      ', 'R 43 (NUCLEO 5)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.099-220', '156      ', 'R 44 (A MENDES)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.055-620', '156      ', 'R 44 (CJ C BRANCO)', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.097-781', '156      ', 'R 44 (CJ S PESSOA)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.077-450', '156      ', 'R 44 (CJ 31 DE MARCO I)', 'JAPIIM                        ');
INSERT INTO cd_cep_br VALUES ('69.095-320', '156      ', 'R 44 (NUCLEO 5)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.099-510', '156      ', 'R 45 (A MENDES)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.055-630', '156      ', 'R 45 (CJ C BRANCO)', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.097-746', '156      ', 'R 45 (CJ O FROTA II)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.077-460', '156      ', 'R 45 (CJ 31 DE MARCO I)', 'JAPIIM                        ');
INSERT INTO cd_cep_br VALUES ('69.095-330', '156      ', 'R 45 (NUCLEO 5)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.099-230', '156      ', 'R 46 (A MENDES)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.055-640', '156      ', 'R 46 (CJ C BRANCO)', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.077-470', '156      ', 'R 46 (CJ 31 DE MARCO I)', 'JAPIIM                        ');
INSERT INTO cd_cep_br VALUES ('69.095-340', '156      ', 'R 46 (NUCLEO 5)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.099-520', '156      ', 'R 47 (A MENDES)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.055-650', '156      ', 'R 47 (CJ C BRANCO)', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.097-747', '156      ', 'R 47 (CJ O FROTA II)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.077-480', '156      ', 'R 47 (CJ 31 DE MARCO I)', 'JAPIIM                        ');
INSERT INTO cd_cep_br VALUES ('69.095-350', '156      ', 'R 47 (NUCLEO 5)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.099-240', '156      ', 'R 48 (A MENDES)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.077-490', '156      ', 'R 48 (CJ 31 DE MARCO I)', 'JAPIIM                        ');
INSERT INTO cd_cep_br VALUES ('69.095-360', '156      ', 'R 48 (NUCLEO 5)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.093-740', '156      ', 'R 35 (CJ MANOA)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.097-741', '156      ', 'R 35 (CJ O FROTA II)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.077-360', '156      ', 'R 35 (CJ 31 DE MARCO I)', 'JAPIIM                        ');
INSERT INTO cd_cep_br VALUES ('69.094-350', '156      ', 'R 35 (NUCLEO 3)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.099-490', '156      ', 'R 36 (A MENDES)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.038-630', '156      ', 'R 36 (CJ A MONTENEGRO)', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('69.055-540', '156      ', 'R 36 (CJ C BRANCO)', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.044-330', '156      ', 'R 36 (CJ JD VERSALLES)', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('69.093-750', '156      ', 'R 36 (CJ MANOA)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.099-670', '156      ', 'R 78 (A MENDES)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.094-610', '156      ', 'R 78 (NUCLEO 14)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.098-720', '156      ', 'R 79 (A MENDES)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.097-768', '156      ', 'R 79 (CJ S PESSOA)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.094-620', '156      ', 'R 79 (NUCLEO 14)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.098-640', '156      ', 'R 8(A MENDES)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.099-680', '156      ', 'R 80 (A MENDES)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.094-630', '156      ', 'R 80 (NUCLEO 14)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.099-690', '156      ', 'R 81 (A MENDES)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.097-127', '156      ', 'R 81 (CJ F MENDES II)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.094-640', '156      ', 'R 81 (NUCLEO 14', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.099-700', '156      ', 'R 82 (A MENDES)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.094-650', '156      ', 'R 82 (NUCLEO 14)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.098-730', '156      ', 'R 83 (A MENDES)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.097-126', '156      ', 'R 83 (CJ F MENDES II)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.094-660', '156      ', 'R 83 (NUCLEO 14)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.099-710', '156      ', 'R 84 (A MENDES)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.094-670', '156      ', 'R 84 (NUCLEO 14)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.098-740', '156      ', 'R 85 (A MENDES)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.097-125', '156      ', 'R 85 (CJ F MENDES II)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.094-680', '156      ', 'R 85 (NUCLEO 14)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.099-320', '156      ', 'R 59 (A MENDES)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.097-784', '156      ', 'R 59 (CJ S PESSOA)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.094-400', '156      ', 'R 59 (NUCLEO 4)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.089-076', '156      ', 'R 6', 'A MENDES                      ');
INSERT INTO cd_cep_br VALUES ('69.098-630', '156      ', 'R 6 (A MENDES)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.067-143', '156      ', 'R 6 (CJ JD PETROPOLIS)', 'PETROPOLIS                    ');
INSERT INTO cd_cep_br VALUES ('69.099-330', '156      ', 'R 60 (A MENDES)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.097-129', '156      ', 'R 60 (CJ F MENDES II)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.094-410', '156      ', 'R 60 (NUCLEO 4)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.099-560', '156      ', 'R 61 (A MENDES)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.094-420', '156      ', 'R 61 (NUCLEO 4)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('57.081-120', '54       ', 'R ALFREDO PITOMBEIRA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.036-030', '54       ', 'R ALFREDO SANTA RITA', 'JATIUCA                       ');
INSERT INTO cd_cep_br VALUES ('57.041-310', '54       ', 'R ALICE MONTE', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('69.087-251', '156      ', 'R VITORIA REGIA', 'T NEVES                       ');
INSERT INTO cd_cep_br VALUES ('69.059-570', '156      ', 'R VITORIA REGIA', 'S ETELVINA                    ');
INSERT INTO cd_cep_br VALUES ('69.084-600', '156      ', 'R VITORIA REGIA', 'Z PALMARES                    ');
INSERT INTO cd_cep_br VALUES ('69.093-443', '156      ', 'R VITORIA REGIA(T. NOVA I)', 'COL T NOVA                    ');
INSERT INTO cd_cep_br VALUES ('69.088-630', '156      ', 'R VITORIA-REGIA', 'J TEIXEIRA                    ');
INSERT INTO cd_cep_br VALUES ('69.093-701', '156      ', 'BC VITORIA, DA(T NOVA I)', 'COL T NOVA                    ');
INSERT INTO cd_cep_br VALUES ('69.029-291', '156      ', 'R VIVALDO DAS NEVES', 'S ANTONIO                     ');
INSERT INTO cd_cep_br VALUES ('69.043-660', '156      ', 'R VIVALDO LIMA', 'ALVORADA                      ');
INSERT INTO cd_cep_br VALUES ('69.005-440', '156      ', 'BVD VIVALDO LIMA', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('69.047-162', '156      ', 'BC VLADISLAU', 'REDENCAO                      ');
INSERT INTO cd_cep_br VALUES ('69.030-520', '156      ', 'R VOLUNTARIOS DA PATRIA', 'VL PRATA                      ');
INSERT INTO cd_cep_br VALUES ('69.050-078', '156      ', 'R VOLUNTARIOS DA PATRIA (VL BAFURURU)', 'CHAPADA                       ');
INSERT INTO cd_cep_br VALUES ('69.074-800', '156      ', 'BC VOVO, DA', 'MRO LIBERDADE                 ');
INSERT INTO cd_cep_br VALUES ('69.089-300', '156      ', 'R W', 'A MENDES                      ');
INSERT INTO cd_cep_br VALUES ('69.093-188', '156      ', 'R WAIAPI(T.NOVA II)', 'COL T NOVA                    ');
INSERT INTO cd_cep_br VALUES ('69.025-050', '156      ', 'AV WALDEMAR PEDROSA (AYRAO)', 'P VARGAS                      ');
INSERT INTO cd_cep_br VALUES ('69.044-460', '156      ', 'R WALDEMAR PEREIRA DE SOUZA (CJ BELVEDERE)', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('69.044-470', '156      ', 'R WALDIR P. NETO (CJ BELVEDERE)', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('69.036-350', '156      ', 'R WALLACE SPENER (CJ R XINGU)', 'COMPENSA                      ');
INSERT INTO cd_cep_br VALUES ('69.025-380', '156      ', 'BC WALTER RAYOL', 'P VARGAS                      ');
INSERT INTO cd_cep_br VALUES ('69.035-812', '156      ', 'R VIRGILHO RAMOS', 'COMPENSA                      ');
INSERT INTO cd_cep_br VALUES ('69.067-020', '156      ', 'R VIRGILIO DE BARROS', 'PETROPOLIS                    ');
INSERT INTO cd_cep_br VALUES ('69.035-804', '156      ', 'R VIRGILIO MARINHO (VL MARINHO)', 'COMPENSA                      ');
INSERT INTO cd_cep_br VALUES ('69.027-061', '156      ', 'BC VIRGILIO RAMOS', 'S RAIMUNDO                    ');
INSERT INTO cd_cep_br VALUES ('69.070-780', '156      ', 'R VIRIATO CORREA', 'COL O MACHADO                 ');
INSERT INTO cd_cep_br VALUES ('69.040-360', '156      ', 'R VIROLAS, DAS(CJ KYSSIA)', 'D PEDRO                       ');
INSERT INTO cd_cep_br VALUES ('69.058-660', '156      ', 'R VISCONDE DA PEDRA BRANCA (PRQ LARANJEIRAS)', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('69.058-670', '156      ', 'AV VISCONDE DA TORRE DE GARCIA D AVILA (PRQ LARAN', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('69.058-680', '156      ', 'R VISCONDE DE ABAETE (PRQ LARANJEIRAS)', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('69.058-690', '156      ', 'R VISCONDE DE CAETE (PRQ LARANJEIRAS)', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('69.058-070', '156      ', 'R VISCONDE DE CAIRU (PRQ LARANJEIRAS)', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('69.058-700', '156      ', 'AV VISCONDE DE CAMARAGIBE (PRQ LARANJEIRAS)', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('69.058-710', '156      ', 'R VISCONDE DE ITABAIANA (PRQ LARANJEIRAS)', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('69.058-720', '156      ', 'R VISCONDE DE ITABORAI (PRQ LARANJEIRAS)', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('69.058-730', '156      ', 'R VISCONDE DE ITANHAEM (PRQ LARANJEIRAS)', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('69.058-740', '156      ', 'AV VISCONDE DE JEQUITINHONHA (PRQ LARANJEIRAS)', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('69.058-750', '156      ', 'R VISCONDE DE LAGUNA (PRQ LARANJEIRAS)', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('69.058-760', '156      ', 'R VISCONDE DE MAGE (PRQ LARANJEIRAS)', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('69.005-430', '156      ', 'R VISCONDE DE MAUA', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('69.058-080', '156      ', 'R VISCONDE DE OURO PRETO (PRQ LARANJEIRAS)', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('69.058-770', '156      ', 'R VISCONDE DE PIRASSUNUNGA (PRQ LARANJEIRAS)', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('69.020-130', '156      ', 'R VISCONDE DE PORTO ALEGRE', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('69.058-090', '156      ', 'AV VISCONDE DE PORTO SEGURO (PRQ LARANJEIRAS)', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('69.058-101', '156      ', 'TV VISCONDE DE PORTO SEGURO (PRQ LARANJEIRAS)', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('69.058-120', '156      ', 'R VISCONDE DE SEPETIBA (PRQ LARANJEIRAS)', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('69.058-790', '156      ', 'R VISCONDE DE SINIMBU (PRQ LARANJEIRAS)', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('69.058-800', '156      ', 'R VISCONDE DE SUASSUNA (PRQ LARANJEIRAS)', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('69.058-782', '156      ', 'R VISCONDE DE TAUNAY (PRQ LARANJEIRAS)', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('69.058-783', '156      ', 'R VISCONDE DE TOCANTINS (PRQ LARANJEIRAS)', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('69.058-810', '156      ', 'R VISCONDE DE UTINGA (PRQ LARANJEIRAS)', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('69.040-600', '156      ', 'R VISEU (CJ DEBORAH)', 'D PEDRO                       ');
INSERT INTO cd_cep_br VALUES ('69.082-391', '156      ', 'R VISTA ALEGRE', 'COROADO                       ');
INSERT INTO cd_cep_br VALUES ('69.070-570', '156      ', 'BC VISTA ALEGRE', 'EDUCANDOS                     ');
INSERT INTO cd_cep_br VALUES ('69.027-590', '156      ', 'R VISTA ALEGRE', 'S RAIMUNDO                    ');
INSERT INTO cd_cep_br VALUES ('69.054-630', '156      ', 'R VISTA ALEGRE', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('69.030-631', '156      ', 'BC VISTA ALEGRE', 'VL PRATA                      ');
INSERT INTO cd_cep_br VALUES ('69.089-106', '156      ', 'TV VISTA BELA', 'A MENDES                      ');
INSERT INTO cd_cep_br VALUES ('69.028-380', '156      ', 'R VITORIA', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('69.038-561', '156      ', 'R VINTE E NOVE - A', 'L VALE                        ');
INSERT INTO cd_cep_br VALUES ('69.038-562', '156      ', 'R VINTE E NOVE - B', 'L VALE                        ');
INSERT INTO cd_cep_br VALUES ('69.038-563', '156      ', 'R VINTE E NOVE - C', 'L VALE                        ');
INSERT INTO cd_cep_br VALUES ('69.008-430', '156      ', 'R VINTE E NOVE DE JULHO', 'COL A ALEIXO                  ');
INSERT INTO cd_cep_br VALUES ('69.035-355', '156      ', 'R VINTE E OITO DE AGOSTO', 'COMPENSA                      ');
INSERT INTO cd_cep_br VALUES ('69.035-357', '156      ', 'BC VINTE E OITO DE AGOSTO', 'COMPENSA                      ');
INSERT INTO cd_cep_br VALUES ('69.057-400', '156      ', 'R VINTE E OITO DE MARCO', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.054-335', '156      ', 'R VINTE E QUATRO (VL REI)', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.060-150', '156      ', 'R VINTE E QUATRO DE AGOSTO', 'ALEIXO                        ');
INSERT INTO cd_cep_br VALUES ('69.074-750', '156      ', 'R VINTE E QUATRO DE AGOSTO', 'MRO LIBERDADE                 ');
INSERT INTO cd_cep_br VALUES ('69.093-433', '156      ', 'R VINTE E QUATRO DE JUNHO(T. NOVA I)', 'COL T NOVA                    ');
INSERT INTO cd_cep_br VALUES ('69.010-080', '156      ', 'R VINTE E QUATRO DE MAIO', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('69.035-580', '156      ', 'R VINTE E QUATRO DE MAIO', 'COMPENSA                      ');
INSERT INTO cd_cep_br VALUES ('69.095-187', '156      ', 'R VINTE E SEIS DE AGOSTO (RIACHO DOCE)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.035-816', '156      ', 'R VINTE E SETE DE NOVEMBRO', 'COMPENSA                      ');
INSERT INTO cd_cep_br VALUES ('69.048-310', '156      ', 'R VINTE E SETE DE OUTUBRO', 'PAZ                           ');
INSERT INTO cd_cep_br VALUES ('69.048-311', '156      ', 'TV VINTE E SETE DE OUTUBRO', 'PAZ                           ');
INSERT INTO cd_cep_br VALUES ('69.027-192', '156      ', 'BC VINTE E SETE DE SETEMBRO', 'S RAIMUNDO                    ');
INSERT INTO cd_cep_br VALUES ('69.027-190', '156      ', 'R VINTE E SETE DE SETEMBRO', 'S RAIMUNDO                    ');
INSERT INTO cd_cep_br VALUES ('69.095-091', '156      ', 'TV VINTE E TRES', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.054-334', '156      ', 'R VINTE E TRES (VL REI)', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.035-550', '156      ', 'R VINTE E TRES DE DEZEMBRO', 'COMPENSA                      ');
INSERT INTO cd_cep_br VALUES ('69.035-551', '156      ', 'BC VINTE E TRES DE DEZEMBRO', 'COMPENSA                      ');
INSERT INTO cd_cep_br VALUES ('69.027-670', '156      ', 'R VINTE E TRES DE JULHO', 'GLORIA                        ');
INSERT INTO cd_cep_br VALUES ('69.054-331', '156      ', 'R VINTE E UM (VL REI)', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.074-100', '156      ', 'R VINTE E UM DE ABRIL', 'COL O MACHADO                 ');
INSERT INTO cd_cep_br VALUES ('69.033-560', '156      ', 'R VINTE E UM DE ABRIL', 'S JORGE                       ');
INSERT INTO cd_cep_br VALUES ('69.042-590', '156      ', 'R VINTE E UM DE AGOSTO', 'ALVORADA                      ');
INSERT INTO cd_cep_br VALUES ('69.042-591', '156      ', 'TV VINTE E UM DE AGOSTO', 'ALVORADA                      ');
INSERT INTO cd_cep_br VALUES ('69.035-560', '156      ', 'BC VINTE E UM DE JUNHO', 'COMPENSA                      ');
INSERT INTO cd_cep_br VALUES ('69.035-570', '156      ', 'R VINTE E UM DE JUNHO', 'COMPENSA                      ');
INSERT INTO cd_cep_br VALUES ('69.087-241', '156      ', 'R VIOLETA', 'T NEVES                       ');
INSERT INTO cd_cep_br VALUES ('69.098-180', '156      ', 'R 187 (NUCLEO 16)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('57.308-420', '23       ', 'R COLONIA DE LEOPOLDINA', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('57.307-270', '23       ', 'PC CORDEIRO LIMA', 'JD ESPERANCA                  ');
INSERT INTO cd_cep_br VALUES ('57.080-410', '54       ', 'AL EDUARDO SARAIVA DE MOURA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.062-420', '54       ', 'AL EDUARDO SILVEIRA PIMENTEL', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.041-420', '54       ', 'R EDVAL SENA', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.037-170', '54       ', 'AV DOUTOR MARIO NUNES VIEIRA', 'MANGABEIRAS                   ');
INSERT INTO cd_cep_br VALUES ('57.080-330', '54       ', 'PC DOUTOR MELCHIADES DA ROCHA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.030-760', '54       ', 'R DOUTOR MESSIAS DE GUSMAO', 'PAJUCARA                      ');
INSERT INTO cd_cep_br VALUES ('57.011-220', '54       ', 'AV DOUTOR MIGUEL OMENA', 'PRADO                         ');
INSERT INTO cd_cep_br VALUES ('57.010-430', '54       ', 'R DOUTOR MILTON RAMIRES', 'T BARRA                       ');
INSERT INTO cd_cep_br VALUES ('57.055-300', '54       ', 'AV DOUTOR MUNIZ FALCAO', 'PINHEIRO                      ');
INSERT INTO cd_cep_br VALUES ('57.055-305', '54       ', 'TV DOUTOR MUNIZ FALCAO', 'PINHEIRO                      ');
INSERT INTO cd_cep_br VALUES ('57.071-150', '54       ', 'R DOUTOR MURILO CARDOSO SANTANA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.035-450', '54       ', 'R DOUTOR NOEL NUTELS', 'P VERDE                       ');
INSERT INTO cd_cep_br VALUES ('57.035-350', '54       ', 'R DOUTOR ODILON VASCONCELOS', 'JATIUCA                       ');
INSERT INTO cd_cep_br VALUES ('57.082-410', '54       ', 'R DOUTOR ODORICO MACIEL', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.050-710', '54       ', 'R DOUTOR OSEAS TENORIO', 'G LOURDES                     ');
INSERT INTO cd_cep_br VALUES ('57.018-000', '54       ', 'R DOUTOR OSVALDO CRUZ', 'BEBEDOURO                     ');
INSERT INTO cd_cep_br VALUES ('57.018-005', '54       ', 'TV DOUTOR OSVALDO CRUZ', 'BEBEDOURO                     ');
INSERT INTO cd_cep_br VALUES ('57.017-500', '54       ', 'R DOUTOR PASSOS DE MIRANDA', 'BEBEDOURO                     ');
INSERT INTO cd_cep_br VALUES ('57.060-310', '54       ', 'R DOUTOR PAULO IZIDORO DA ROCHA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.010-380', '54       ', 'R DOUTOR PAULO NETO', 'T BARRA                       ');
INSERT INTO cd_cep_br VALUES ('57.080-430', '54       ', 'R DOUTOR PEDRO CAVALCANTE', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.015-670', '54       ', 'R DOUTOR PEDRO MARCELO DE OLIVEIRA', 'LEVADA                        ');
INSERT INTO cd_cep_br VALUES ('57.020-380', '54       ', 'R DOUTOR PEDRO MONTEIRO', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.035-050', '54       ', 'R DOUTOR POMPEU SARMENTO', 'P VERDE                       ');
INSERT INTO cd_cep_br VALUES ('57.020-160', '54       ', 'R DOUTOR PONTES DE MIRANDA', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.070-310', '54       ', 'R DOUTOR PONTES DE MIRANDA', 'F VELHO                       ');
INSERT INTO cd_cep_br VALUES ('57.084-300', '54       ', 'R DOUTOR POTIGUARA PEREIRA DE MIRANDA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.036-150', '54       ', 'R DOUTOR PROCOPIO JUNIOR', 'JATIUCA                       ');
INSERT INTO cd_cep_br VALUES ('57.015-280', '54       ', 'R DOUTOR ROCHA CAVALCANTE', 'V LAGO                        ');
INSERT INTO cd_cep_br VALUES ('57.060-780', '54       ', 'R DOUTOR RODRIGO DE ARAUJO RAMALHO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.037-090', '54       ', 'R DOUTOR ROLAND SIMONS', 'MANGABEIRAS                   ');
INSERT INTO cd_cep_br VALUES ('57.083-340', '54       ', 'R DOUTOR RONALDO DE OLIVEIRA CALDAS', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.084-090', '54       ', 'R DOUTOR ROSALVO RODRIGUES DE ARAUJO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.080-160', '54       ', 'R DOUTOR RUBENS LOUREIRO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.036-160', '54       ', 'R DOUTOR SADI CARVALHO', 'JATIUCA                       ');
INSERT INTO cd_cep_br VALUES ('57.062-470', '54       ', 'R DOUTOR SADY SEVERIEN', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.062-580', '54       ', 'AL DOUTOR TEOGENES AUGUSTO DE BARROS', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.018-720', '54       ', 'R DOUTOR ULISSES LOPES MOREIRA', 'C JAQUEIRA                    ');
INSERT INTO cd_cep_br VALUES ('57.037-180', '54       ', 'R DOUTOR WALDEMIRO ALENCAR JUNIOR', 'MANGABEIRAS                   ');
INSERT INTO cd_cep_br VALUES ('57.062-250', '54       ', 'AL DOUTOR WALDEMIRO DE ALENCAR JUNIOR', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.063-120', '54       ', 'R DOUTOR WALTER ANANIAS BARROS(LOT CIPESA)', 'S AMELIA                      ');
INSERT INTO cd_cep_br VALUES ('57.061-560', '54       ', 'R EMPRESARIO JOSE PEREIRA DA ROCHA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.062-550', '54       ', 'AL EMPRESARIO JUVENAL LOPES FERREIRA DE OMENA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.062-530', '54       ', 'AV EMPRESARIO LOURIVAL LOBO FERREIRA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.045-410', '54       ', 'R EMPRESARIO MARIO LEHAY', 'B DURO                        ');
INSERT INTO cd_cep_br VALUES ('57.037-320', '54       ', 'R EMPRESARIO MAYR AMARAL', 'JATIUCA                       ');
INSERT INTO cd_cep_br VALUES ('57.073-000', '54       ', 'R EMPRESARIO NELSON OLIVEIRA MENEZES', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.080-300', '54       ', 'R EMPRESARIO PAULO JACINTO TENORIO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.045-420', '54       ', 'R EMPRESARIO SEBASTIAO FERREIRA SANTOS', 'B DURO                        ');
INSERT INTO cd_cep_br VALUES ('57.050-250', '54       ', 'R EMPRESARIO WALDOMIRO BREDA', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.080-230', '54       ', 'PC EMPRESARIO WALDOMIRO BREDA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.047-130', '54       ', 'R ENAURA DA ROCHA FERNANDES(CJ RESIDENCIAL CARAJ', 'SERRARIA                      ');
INSERT INTO cd_cep_br VALUES ('57.041-210', '54       ', 'R ENCANTO, DO', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.047-000', '54       ', 'R ENEDINA AUGUSTA DOS SANTOS ROCHA', 'SERRARIA                      ');
INSERT INTO cd_cep_br VALUES ('57.084-060', '54       ', 'AV ENFERMEIRA NORACI PEDROSA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.072-660', '54       ', 'R ENFERMEIRA ODETE MEDEIROS DE OLIVEIRA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.041-430', '54       ', 'R ENFERMEIRO MARIANO', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.062-610', '54       ', 'AL ENGENHEIRO ALZIR FURTADO MACHADO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.020-060', '54       ', 'LD ENGENHEIRO ANTONIO GUEDES NOGUEIRA', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.041-820', '54       ', 'R ENGENHEIRO BRENO JATOBA AGRA', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.030-190', '54       ', 'R ENGENHEIRO DEMOCRITO SARMENTO BARROCA', 'P TERRA                       ');
INSERT INTO cd_cep_br VALUES ('57.048-180', '54       ', 'PC ENGENHEIRO DURVAL DA ROCHA CORTEZ', 'SERRARIA                      ');
INSERT INTO cd_cep_br VALUES ('57.035-600', '54       ', 'R ENGENHEIRO EDSON LOBAO BARRETO', 'JATIUCA                       ');
INSERT INTO cd_cep_br VALUES ('57.084-320', '54       ', 'R ENGENHEIRO ERIVAN SILVA SANTOS', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.046-590', '54       ', 'R ENGENHEIRO HELIO MAGALHAES', 'SERRARIA                      ');
INSERT INTO cd_cep_br VALUES ('57.080-140', '54       ', 'R ENGENHEIRO ISAAC GONDIM', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.035-000', '54       ', 'R ENGENHEIRO MARIO DE GUSMAO', 'P VERDE                       ');
INSERT INTO cd_cep_br VALUES ('57.050-430', '54       ', 'R ENGENHEIRO OTAVIO CABRAL', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.036-550', '54       ', 'AV ENGENHEIRO PAULO BRANDAO NOGUEIRA', 'JATIUCA                       ');
INSERT INTO cd_cep_br VALUES ('57.057-550', '54       ', 'R ENGENHEIRO PAULO ROBERTO WANDERLEY', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.051-690', '54       ', 'PC ENGENHEIRO RENALDO MALTA XAVIER', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.017-640', '54       ', 'R ENGENHEIRO SANTIVES CURTINAM SIMON', 'BEBEDOURO                     ');
INSERT INTO cd_cep_br VALUES ('57.062-140', '54       ', 'AL EOLO ALENCAR', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.060-710', '54       ', 'R EDVALDO SILVA FILHO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.073-190', '54       ', 'R EDWARDS COSTA CABRAL', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.046-570', '54       ', 'R EFIGENIA PEREIRA DE LIMA', 'SERRARIA                      ');
INSERT INTO cd_cep_br VALUES ('57.050-720', '54       ', 'R EFIGENIO FERREIRA DE LIMA', 'G LOURDES                     ');
INSERT INTO cd_cep_br VALUES ('57.052-700', '54       ', 'R ELAINE LIMA', 'G LOURDES                     ');
INSERT INTO cd_cep_br VALUES ('57.043-060', '54       ', 'CJ ELDORADO', 'FEITOSA                       ');
INSERT INTO cd_cep_br VALUES ('57.071-615', '54       ', 'R ELENILSON SANTOS', 'A S DUMONT                    ');
INSERT INTO cd_cep_br VALUES ('57.039-400', '54       ', 'CJ ELIAS DA SILVA BOMFIM', 'GUAXUMA                       ');
INSERT INTO cd_cep_br VALUES ('57.038-280', '54       ', 'R ELIAS RAMOS DE ARAUJO', 'C ALMAS                       ');
INSERT INTO cd_cep_br VALUES ('57.082-720', '54       ', 'R ELIEL RUFINO DE CASTRO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.071-000', '54       ', 'R ELIETE ROLEMBERG DE FIGUEIREDO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.083-550', '54       ', 'R ELIEZER RUFINO DE CASTRO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.081-520', '54       ', 'R ELINELMA OLIVEIRA SANTOS', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.071-850', '54       ', 'TV ELINELSON OLIVEIRA SANTOS', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.071-715', '54       ', 'TV ELINELSON SANTOS', 'A S DUMONT                    ');
INSERT INTO cd_cep_br VALUES ('57.030-090', '54       ', 'R ELISIO DE CARVALHO', 'PAJUCARA                      ');
INSERT INTO cd_cep_br VALUES ('57.082-600', '54       ', 'R ELISSALMA OLIVEIRA SANTOS', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.073-180', '54       ', 'R ELITA PINTO QUINTELA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.076-100', '54       ', 'R ELIZABETE GUIMARAES', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.071-795', '54       ', 'TV BOM JESUS', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.071-790', '54       ', 'R BOM JESUS', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.071-765', '54       ', 'CON BOM JESUS', 'A S DUMONT                    ');
INSERT INTO cd_cep_br VALUES ('57.071-825', '54       ', 'R BOM JESUS', 'A S DUMONT                    ');
INSERT INTO cd_cep_br VALUES ('57.071-835', '54       ', 'R BOM JESUS DO HORTO', 'A S DUMONT                    ');
INSERT INTO cd_cep_br VALUES ('57.011-210', '54       ', 'R BOM JESUS DOS NAVEGANTES', 'T BARRA                       ');
INSERT INTO cd_cep_br VALUES ('57.015-230', '54       ', 'R BOM RETIRO', 'V LAGO                        ');
INSERT INTO cd_cep_br VALUES ('57.015-235', '54       ', 'TV BOM RETIRO', 'V LAGO                        ');
INSERT INTO cd_cep_br VALUES ('57.062-740', '54       ', 'R BELA VISTA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.055-295', '54       ', 'TV BELA VISTA', 'PINHEIRO                      ');
INSERT INTO cd_cep_br VALUES ('57.071-530', '54       ', 'R BELA VISTA', 'A S DUMONT                    ');
INSERT INTO cd_cep_br VALUES ('57.085-050', '54       ', 'LOT BELA VISTA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.017-155', '54       ', 'TV BELA VISTA', 'B PARTO                       ');
INSERT INTO cd_cep_br VALUES ('57.040-020', '54       ', 'R BELEM', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.040-025', '54       ', 'TV BELEM', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.045-250', '54       ', 'R BELEM', 'B DURO                        ');
INSERT INTO cd_cep_br VALUES ('57.040-570', '54       ', 'R BELMIRA FERREIRA', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.081-000', '54       ', 'R BELMIRO AMORIM', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.081-005', '54       ', 'TV BELMIRO AMORIM', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.017-360', '54       ', 'TV BELO ALVES', 'BEBEDOURO                     ');
INSERT INTO cd_cep_br VALUES ('57.040-580', '54       ', 'R BELO MONTE', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.040-585', '54       ', 'TV BELO MONTE', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.085-080', '54       ', 'R BELO MONTE', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.046-250', '54       ', 'R BENEDITA LOPES DA ROCHA', 'SERRARIA                      ');
INSERT INTO cd_cep_br VALUES ('57.036-090', '54       ', 'R BENEDITO BASTO SILVA', 'JATIUCA                       ');
INSERT INTO cd_cep_br VALUES ('57.071-540', '54       ', 'AV BENEDITO BATISTA', 'A S DUMONT                    ');
INSERT INTO cd_cep_br VALUES ('57.071-545', '54       ', 'TV BENEDITO BATISTA', 'A S DUMONT                    ');
INSERT INTO cd_cep_br VALUES ('57.084-040', '54       ', 'CJ BENEDITO BENTES I', 'BENEDITO BENTES               ');
INSERT INTO cd_cep_br VALUES ('57.084-050', '54       ', 'CJ BENEDITO BENTES II', 'BENEDITO BENTES               ');
INSERT INTO cd_cep_br VALUES ('57.031-040', '54       ', 'R BENEDITO CUNEGUNDES', 'POCO                          ');
INSERT INTO cd_cep_br VALUES ('57.062-190', '54       ', 'AL BENEDITO DA COSTA DORIA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.082-160', '54       ', 'R BENEDITO DE GUSMAO BARBOSA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.018-020', '54       ', 'R BENEDITO LINS DA TRINDADE', 'BEBEDOURO                     ');
INSERT INTO cd_cep_br VALUES ('57.073-510', '54       ', 'AV BENEDITO LOUREIRO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.039-550', '54       ', 'PC BENEDITO PACHECO', 'F PEIXOTO                     ');
INSERT INTO cd_cep_br VALUES ('57.014-065', '54       ', 'VL BENFICA', 'LEVADA                        ');
INSERT INTO cd_cep_br VALUES ('57.085-010', '54       ', 'CJ BENICIO MENDES BARROS', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.010-530', '54       ', 'R BENIGNO BEZERRA', 'T BARRA                       ');
INSERT INTO cd_cep_br VALUES ('57.014-430', '54       ', 'R BENJAMIM MEDEIROS', 'V LAGO                        ');
INSERT INTO cd_cep_br VALUES ('57.040-800', '54       ', 'R BENJAMIM MOREIRA', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.010-470', '54       ', 'R BENJAMIN CONSTANT', 'T BARRA                       ');
INSERT INTO cd_cep_br VALUES ('57.010-080', '54       ', 'R BENTO CRAVEIRO BARBOSA', 'PRADO                         ');
INSERT INTO cd_cep_br VALUES ('57.082-090', '54       ', 'R BERNADINO DE SOUZA FERREIRA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.025-430', '54       ', 'R BERNARDES GUIMARAES', 'POCO                          ');
INSERT INTO cd_cep_br VALUES ('57.057-030', '54       ', 'R BERNARDO LOPES', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.052-670', '54       ', 'TV BETANIA', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.042-570', '54       ', 'R BACHAREL CAUBY PONTES', 'B VISTA                       ');
INSERT INTO cd_cep_br VALUES ('57.031-030', '54       ', 'R BACHAREL GENIVAL LUCIO DA SILVA', 'POCO                          ');
INSERT INTO cd_cep_br VALUES ('57.031-340', '54       ', 'R BACHAREL JACINTO BUARQUE DE HOLANDA', 'POCO                          ');
INSERT INTO cd_cep_br VALUES ('57.031-345', '54       ', 'TV BACHAREL JACINTO BUARQUE DE HOLANDA', 'POCO                          ');
INSERT INTO cd_cep_br VALUES ('57.038-530', '54       ', 'R BACHAREL VIRGILIO DA ROCHA MARQUES', 'C ALMAS                       ');
INSERT INTO cd_cep_br VALUES ('57.035-520', '54       ', 'R BACHAREL WALTER MOREIRA DA SILVA', 'P VERDE                       ');
INSERT INTO cd_cep_br VALUES ('57.046-240', '54       ', 'R BADEN POWELL', 'SERRARIA                      ');
INSERT INTO cd_cep_br VALUES ('57.038-210', '54       ', 'R BAHIA', 'C ALMAS                       ');
INSERT INTO cd_cep_br VALUES ('57.015-440', '54       ', 'R BALBINO LOPES', 'V LAGO                        ');
INSERT INTO cd_cep_br VALUES ('57.061-170', '54       ', 'R BANCARIO ANTENOR BITTENCOURT', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.042-210', '54       ', 'R BANCARIO FRANCISCO VICENTE SOUZA', 'FEITOSA                       ');
INSERT INTO cd_cep_br VALUES ('57.010-500', '54       ', 'R CAMPO, DO', 'T BARRA                       ');
INSERT INTO cd_cep_br VALUES ('57.061-030', '54       ', 'TV CAMPO, DO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.022-020', '54       ', 'R CAMPOS SALES', 'JARAGUA                       ');
INSERT INTO cd_cep_br VALUES ('57.030-370', '54       ', 'TV CAMPOS TEIXEIRA', 'P TERRA                       ');
INSERT INTO cd_cep_br VALUES ('57.010-350', '54       ', 'R CAMPUS TAMANDARE', 'P BARRA                       ');
INSERT INTO cd_cep_br VALUES ('57.040-240', '54       ', 'R CANADA', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.040-250', '54       ', 'R CANDIDO MONTEIRO LEITE', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.038-250', '54       ', 'R CAPELA', 'C ALMAS                       ');
INSERT INTO cd_cep_br VALUES ('57.060-630', '54       ', 'R CAPIM, DO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.071-830', '54       ', 'R CAPITAO ATAIDE', 'A S DUMONT                    ');
INSERT INTO cd_cep_br VALUES ('57.010-260', '54       ', 'R CAPITAO CANTUARIO', 'T BARRA                       ');
INSERT INTO cd_cep_br VALUES ('57.010-270', '54       ', 'TV CAPITAO CANTUARIO', 'T BARRA                       ');
INSERT INTO cd_cep_br VALUES ('57.045-050', '54       ', 'R CAPITAO CORREIA', 'B DURO                        ');
INSERT INTO cd_cep_br VALUES ('57.084-230', '54       ', 'R CAPITAO JOSE DE OLIVEIRA LIMA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.031-000', '54       ', 'R CAPITAO MARINHO FALCAO', 'POCO                          ');
INSERT INTO cd_cep_br VALUES ('57.051-130', '54       ', 'R CAPITAO SAMUEL LINS', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.046-380', '54       ', 'R CAPIXABAS, DOS', 'SERRARIA                      ');
INSERT INTO cd_cep_br VALUES ('57.046-390', '54       ', 'CJ CARAJAS I', 'SERRARIA                      ');
INSERT INTO cd_cep_br VALUES ('57.046-700', '54       ', 'CJ CARAJAS II', 'SERRARIA                      ');
INSERT INTO cd_cep_br VALUES ('57.011-300', '54       ', 'R CARAMURUS- ATE 466/477', 'PRADO                         ');
INSERT INTO cd_cep_br VALUES ('57.010-090', '54       ', 'R CARAMURUS- DE 468/479 AO FIM', 'PRADO                         ');
INSERT INTO cd_cep_br VALUES ('57.040-220', '54       ', 'R BONFIM', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.040-225', '54       ', 'TV BONFIM', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.025-600', '54       ', 'TV BONFIM', 'POCO                          ');
INSERT INTO cd_cep_br VALUES ('57.015-240', '54       ', 'R BONSUCESSO', 'V LAGO                        ');
INSERT INTO cd_cep_br VALUES ('57.015-245', '54       ', 'TV BONSUCESSO', 'V LAGO                        ');
INSERT INTO cd_cep_br VALUES ('57.047-060', '54       ', 'CJ BOSQUE DA SERRARIA', 'SERRARIA                      ');
INSERT INTO cd_cep_br VALUES ('57.017-370', '54       ', 'CJ BOSQUE FREIRE RIBEIRO', 'BEBEDOURO                     ');
INSERT INTO cd_cep_br VALUES ('57.017-380', '54       ', 'CJ BOSQUE MUNDAU', 'BEBEDOURO                     ');
INSERT INTO cd_cep_br VALUES ('57.060-040', '54       ', 'R BOTAFOGO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.062-220', '54       ', 'AL BRANCILDES OLIMPIO DO ESPIRITO SANTO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.018-040', '54       ', 'VL BRASIL', 'BEBEDOURO                     ');
INSERT INTO cd_cep_br VALUES ('57.030-660', '54       ', 'AV BRASIL', 'POCO                          ');
INSERT INTO cd_cep_br VALUES ('57.030-665', '54       ', 'TV BRASIL', 'POCO                          ');
INSERT INTO cd_cep_br VALUES ('57.042-750', '54       ', 'LOT BRASIL', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.075-080', '54       ', 'CJ BRASIL NOVO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.018-800', '54       ', 'R BRASILIA', 'BEBEDOURO                     ');
INSERT INTO cd_cep_br VALUES ('57.071-810', '54       ', 'R BRAULIO CAVALCANTE', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.052-280', '54       ', 'R BRAUNA', 'G LOURDES                     ');
INSERT INTO cd_cep_br VALUES ('57.017-300', '54       ', 'R BREJAL', 'B PARTO                       ');
INSERT INTO cd_cep_br VALUES ('57.041-330', '54       ', 'R BRENO CANSANCAO', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.038-230', '54       ', 'AV BRIGADEIRO EDUARDO GOMES', 'C ALMAS                       ');
INSERT INTO cd_cep_br VALUES ('57.042-840', '54       ', 'R BRISA DO MAR', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.051-310', '54       ', 'LD BRITO, DO', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.020-520', '54       ', 'R BUARQUE DE MACEDO', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.080-200', '54       ', 'R CABO GASTON LIMA E SILVA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('12.924-520', '4897     ', 'R PAVAO', 'COND JD PALMEIRAS             ');
INSERT INTO cd_cep_br VALUES ('57.040-525', '54       ', 'R MANOEL FORTES FONTAN', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.043-300', '54       ', 'R MANOEL GETIRANA', 'FEITOSA                       ');
INSERT INTO cd_cep_br VALUES ('57.084-160', '54       ', 'R ALICE UCHOA BOTELHO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.010-340', '54       ', 'AV ALIPIO BARBOSA DA SILVA', 'P BARRA                       ');
INSERT INTO cd_cep_br VALUES ('57.048-270', '54       ', 'R ALLAN KARDEC(LOT TERRA DE ANTARES I)', 'ANTARES                       ');
INSERT INTO cd_cep_br VALUES ('57.037-020', '54       ', 'AV ALMIRANTE ALVARO CALHEIROS', 'MANGABEIRAS                   ');
INSERT INTO cd_cep_br VALUES ('57.055-280', '54       ', 'R ALMIRANTE BARROSO', 'PINHEIRO                      ');
INSERT INTO cd_cep_br VALUES ('57.055-285', '54       ', 'TV ALMIRANTE BARROSO', 'PINHEIRO                      ');
INSERT INTO cd_cep_br VALUES ('57.062-270', '54       ', 'AL ALMIRANTE MANOEL MENDES', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.030-010', '54       ', 'R ALMIRANTE MASCARENHAS', 'PAJUCARA                      ');
INSERT INTO cd_cep_br VALUES ('57.010-030', '54       ', 'R ALMIRANTE TAMANDARE', 'PRADO                         ');
INSERT INTO cd_cep_br VALUES ('57.081-570', '54       ', 'R ALMIRANTE, DO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.071-020', '54       ', 'R ALOISIO BEZERRA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.025-580', '54       ', 'PC ALOISIO BRANCO', 'POCO                          ');
INSERT INTO cd_cep_br VALUES ('57.040-540', '54       ', 'R ALOISIO REGO BARROS', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.063-060', '54       ', 'LOT ALTO DA COLINA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.070-170', '54       ', 'R ALTO REDENTOR', 'R NOVO                        ');
INSERT INTO cd_cep_br VALUES ('57.010-040', '54       ', 'R ALVARES CABRAL', 'PRADO                         ');
INSERT INTO cd_cep_br VALUES ('57.050-380', '54       ', 'R ALVARO CORREIA DE ARAUJO', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.031-010', '54       ', 'R ALVARO DE OLIVEIRA', 'POCO                          ');
INSERT INTO cd_cep_br VALUES ('57.082-420', '54       ', 'R ALVARO LEITE', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.010-050', '54       ', 'R ALVARO MARINHO', 'PRADO                         ');
INSERT INTO cd_cep_br VALUES ('57.082-430', '54       ', 'R ALVARO MELO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.035-180', '54       ', 'AV ALVARO OTACILIO- ATE 3597 - LADO IMPAR', 'P VERDE                       ');
INSERT INTO cd_cep_br VALUES ('57.037-270', '54       ', 'AV ALVARO OTACILIO- DE 6641 AO FIM', 'JATIUCA                       ');
INSERT INTO cd_cep_br VALUES ('57.036-850', '54       ', 'AV ALVARO OTACILIO-DE 3599 A 6639', 'P VERDE                       ');
INSERT INTO cd_cep_br VALUES ('57.057-010', '54       ', 'R ALVARO QUINTILIANO', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.084-620', '54       ', 'LOT ALVORADA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.062-280', '54       ', 'AL ALZIR FURTADO MACHADO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.039-030', '54       ', 'R ALZIRA DE ALMEIDA SILVA', 'JACARECICA                    ');
INSERT INTO cd_cep_br VALUES ('57.083-280', '54       ', 'R AMALIA FERREIRA MOURA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.080-320', '54       ', 'R AMALIA MOURA DE SOUZA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.083-380', '54       ', 'R ADRIANO VIANA DE CASTRO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.072-300', '54       ', 'R ADRIAO JOSE DA SILVA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.047-110', '54       ', 'R ADVOGADO NELSON DE SOUZA(LOTEAMENTO MURILOPOLI', 'SERRARIA                      ');
INSERT INTO cd_cep_br VALUES ('57.051-040', '54       ', 'R AFONSO PENA', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.050-520', '54       ', 'R AFONSO VIANA', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.084-290', '54       ', 'R AFRA MEDEIROS PINTO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.084-140', '54       ', 'R AFRA PEREIRA LIMA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('69.086-080', '156      ', 'R 07', 'S J OPERARIO                  ');
INSERT INTO cd_cep_br VALUES ('57.018-220', '54       ', 'R AGAMENON SOUZA SANTOS', 'BEBEDOURO                     ');
INSERT INTO cd_cep_br VALUES ('57.039-010', '54       ', 'R AGENOR RODRIGUES DORIA', 'JACARECICA                    ');
INSERT INTO cd_cep_br VALUES ('57.020-310', '54       ', 'R AGERSON DANTAS', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.045-220', '54       ', 'R AGLIBERTO BARBOSA', 'B DURO                        ');
INSERT INTO cd_cep_br VALUES ('57.011-390', '54       ', 'R AGNELO BARBOSA', 'PRADO                         ');
INSERT INTO cd_cep_br VALUES ('57.083-250', '54       ', 'R AGNELO GONCALVES VIEIRA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.048-070', '54       ', 'R AGRONOMO MARCOS AUGUSTO WANDERLEY CAVALCANTI', 'SERRARIA                      ');
INSERT INTO cd_cep_br VALUES ('57.080-010', '54       ', 'R AGUA BRANCA', 'CANAA                         ');
INSERT INTO cd_cep_br VALUES ('57.030-220', '54       ', 'TV AGUIAR', 'P TERRA                       ');
INSERT INTO cd_cep_br VALUES ('57.081-230', '54       ', 'R AGUIDALINA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.084-150', '54       ', 'R AIDA FERRARIO DE CARVALHO LOBO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.039-370', '54       ', 'ROD AL-101 NORTE', 'JACARECICA                    ');
INSERT INTO cd_cep_br VALUES ('57.045-230', '54       ', 'R ALBA MENDES FALCAO', 'B DURO                        ');
INSERT INTO cd_cep_br VALUES ('57.045-235', '54       ', 'TV ALBA MENDES FALCAO', 'B DURO                        ');
INSERT INTO cd_cep_br VALUES ('57.080-570', '54       ', 'R ALBANIRA GONDIM LAMENHA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.060-180', '54       ', 'R ALBERICO GOMES', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.083-220', '54       ', 'AV ALBERTO ALVES DA CAMARA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.055-270', '54       ', 'R ALBUQUERQUE LINS', 'PINHEIRO                      ');
INSERT INTO cd_cep_br VALUES ('57.055-275', '54       ', 'TV ALBUQUERQUE LINS', 'PINHEIRO                      ');
INSERT INTO cd_cep_br VALUES ('57.051-050', '54       ', 'R ALCEBIADES VALENTE', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.041-010', '54       ', 'R ALCIDES CORREIA', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.083-190', '54       ', 'R ALCIDES GOMES MOURA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.041-020', '54       ', 'R ALCIDES RAMOS DE LIMA', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.039-160', '54       ', 'R ALCINDO MONTEIRO', 'R DOCE                        ');
INSERT INTO cd_cep_br VALUES ('57.020-490', '54       ', 'R ALCINO CASADO', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.070-160', '54       ', 'R ALECRIM, DO', 'R NOVO                        ');
INSERT INTO cd_cep_br VALUES ('57.020-320', '54       ', 'R ALEGRIA, DA', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.051-060', '54       ', 'R ALEXANDRE NOBRE', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.022-190', '54       ', 'R ALEXANDRE PASSOS', 'JARAGUA                       ');
INSERT INTO cd_cep_br VALUES ('57.046-220', '54       ', 'CJ ALFAVILLE', 'SERRARIA                      ');
INSERT INTO cd_cep_br VALUES ('57.076-040', '54       ', 'R ANTONIO AUGUSTO LOPES BARBOSA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.052-010', '54       ', 'R ANTONIO BARBOSA', 'G LOURDES                     ');
INSERT INTO cd_cep_br VALUES ('57.071-535', '54       ', 'R ANTONIO BRITO', 'A S DUMONT                    ');
INSERT INTO cd_cep_br VALUES ('57.061-010', '54       ', 'PC ANTONIO CALHEIROS DE MELO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.040-550', '54       ', 'R ANTONIO CAMELO LINS', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.014-410', '54       ', 'R ANTONIO CARVALHO DE VASCONCELOS', 'V LAGO                        ');
INSERT INTO cd_cep_br VALUES ('57.061-550', '54       ', 'R ANTONIO CASADO DE AMORIM', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.018-470', '54       ', 'R ANTONIO CLAUDINO', 'C JAQUEIRA                    ');
INSERT INTO cd_cep_br VALUES ('57.040-190', '54       ', 'R ANTONIO CORREIA', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.080-360', '54       ', 'R ANTONIO CORREIA DA SILVA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.048-020', '54       ', 'R ANTONIO DA PURIFICACAO', 'SERRARIA                      ');
INSERT INTO cd_cep_br VALUES ('57.083-100', '54       ', 'R ANTONIO DAVI LINS', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.083-330', '54       ', 'R ANTONIO DE SOUZA BRAGA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.082-280', '54       ', 'R ANTONIO FAUSTINO SANTOS', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.039-520', '54       ', 'R ANTONIO FELINTO', 'R DOCE                        ');
INSERT INTO cd_cep_br VALUES ('57.018-260', '54       ', 'R ANTONIO FELISDORO(ANTIGA VILA ALMEIDA)', 'BEBEDOURO                     ');
INSERT INTO cd_cep_br VALUES ('57.050-010', '54       ', 'R ANTONIO FELIX', 'PITANGUINHA                   ');
INSERT INTO cd_cep_br VALUES ('57.039-460', '54       ', 'R ANTONIO FELIX', 'R DOCE                        ');
INSERT INTO cd_cep_br VALUES ('57.030-020', '54       ', 'R ANTONIO FERREIRA RODRIGUES', 'PAJUCARA                      ');
INSERT INTO cd_cep_br VALUES ('57.072-310', '54       ', 'R ANTONIO FLORENCIO DE ARAUJO LIMA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.080-340', '54       ', 'R ANTONIO FRANCISCO ANTUNES', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.050-160', '54       ', 'R ANTONIO GERBASE', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.030-780', '54       ', 'R ANTONIO GOMES DA SILVA', 'POCO                          ');
INSERT INTO cd_cep_br VALUES ('57.017-340', '54       ', 'R ANTONIO GONZAGA FILHO', 'MUTANGE                       ');
INSERT INTO cd_cep_br VALUES ('57.050-020', '54       ', 'R ANTONIO GUEDES NOGUEIRA', 'PITANGUINHA                   ');
INSERT INTO cd_cep_br VALUES ('57.071-750', '54       ', 'R ANTONIO HONORATO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.041-040', '54       ', 'R ANTONIO JOAQUIM DE OLIVEIRA', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.083-310', '54       ', 'R ANTONIO LEONCIO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.042-720', '54       ', 'R ANTONIO LEONCIO DA SILVA', 'B VISTA                       ');
INSERT INTO cd_cep_br VALUES ('57.042-620', '54       ', 'AV JOHN RICHARDSON CORDEIRO', 'B DURO                        ');
INSERT INTO cd_cep_br VALUES ('57.030-840', '54       ', 'R JONAS CALHEIROS', 'POCO                          ');
INSERT INTO cd_cep_br VALUES ('57.062-060', '54       ', 'AL JONAS MELO MATOS', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.305-480', '23       ', 'PC CORONEL JOSE DE FARIAS', 'BAIXAO                        ');
INSERT INTO cd_cep_br VALUES ('57.304-270', '23       ', 'R CORONEL VICENTE RAMOS', 'CACIMBAS                      ');
INSERT INTO cd_cep_br VALUES ('57.314-000', '23       ', 'AV CORONEL WILSON SANTA CRUZ', 'AT CRUZEIRO                   ');
INSERT INTO cd_cep_br VALUES ('57.305-690', '23       ', 'R CORURIPE', 'M TELES                       ');
INSERT INTO cd_cep_br VALUES ('57.306-420', '23       ', 'R COSTA CAVALCANTE- ATE 764/765', 'CAVACO                        ');
INSERT INTO cd_cep_br VALUES ('57.305-620', '23       ', 'R COSTA CAVALCANTE- DE 766/767 AO FIM', 'P FRIO                        ');
INSERT INTO cd_cep_br VALUES ('57.304-250', '23       ', 'R COSTA GAMA', 'PRIMAVERA                     ');
INSERT INTO cd_cep_br VALUES ('57.312-700', '23       ', 'R COSTA REGO', 'AT CRUZEIRO                   ');
INSERT INTO cd_cep_br VALUES ('57.313-500', '23       ', 'R COSTA RICA', 'JD TROPICAL                   ');
INSERT INTO cd_cep_br VALUES ('69.040-140', '156      ', 'R 07', 'D PEDRO                       ');
INSERT INTO cd_cep_br VALUES ('57.302-440', '23       ', 'R CRISANTINA DA CUNHA LIMA', 'N ESPERANCA                   ');
INSERT INTO cd_cep_br VALUES ('57.312-150', '23       ', 'R CRISTO REDENTOR', 'S ESMERALDA                   ');
INSERT INTO cd_cep_br VALUES ('57.300-430', '23       ', 'R CURITIBA', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.314-080', '23       ', 'R CUSTODIO JOSE DE MELO', 'ITAPOA                        ');
INSERT INTO cd_cep_br VALUES ('57.313-100', '23       ', 'R DACIA BEZERRA CAVALCANTE', 'BRASILIA                      ');
INSERT INTO cd_cep_br VALUES ('57.307-670', '23       ', 'R DEDE VIGARIO', 'JD ESPERANCA                  ');
INSERT INTO cd_cep_br VALUES ('57.311-020', '23       ', 'R DELMIRO GOUVEIA', 'AT CRUZEIRO                   ');
INSERT INTO cd_cep_br VALUES ('57.300-330', '23       ', 'PC DEPUTADO MARQUES DA SILVA', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.301-010', '23       ', 'R DEZESSEIS DE SETEMBRO', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.305-540', '23       ', 'R DIOCLECIO LUCINDO', 'BAIXAO                        ');
INSERT INTO cd_cep_br VALUES ('57.307-180', '23       ', 'R DIONISIO PEDRO DOS SANTOS', 'BX GRANDE                     ');
INSERT INTO cd_cep_br VALUES ('57.313-250', '23       ', 'R AURELIO LIMA PIMENTEL', 'BRASILIA                      ');
INSERT INTO cd_cep_br VALUES ('57.304-700', '23       ', 'R AUTA NOBRE DE MAGALHAES', 'CACIMBAS                      ');
INSERT INTO cd_cep_br VALUES ('57.312-330', '23       ', 'R BARAO DE ALAGOAS', 'AT CRUZEIRO                   ');
INSERT INTO cd_cep_br VALUES ('57.308-250', '23       ', 'R BATALHA', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('57.313-180', '23       ', 'R BELA VISTA', 'BRASILIA                      ');
INSERT INTO cd_cep_br VALUES ('57.308-260', '23       ', 'R BELEM', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('57.313-570', '23       ', 'R BELO MONTE', 'JD TROPICAL                   ');
INSERT INTO cd_cep_br VALUES ('57.313-530', '23       ', 'R BENEDITO TERTO DA SILVA', 'JD TROPICAL                   ');
INSERT INTO cd_cep_br VALUES ('57.304-410', '23       ', 'R BENEVIDES MONTES', 'PRIMAVERA                     ');
INSERT INTO cd_cep_br VALUES ('57.307-620', '23       ', 'R BENJAMIM FREIRE DE AMORIM', 'BRASILIANA                    ');
INSERT INTO cd_cep_br VALUES ('57.305-350', '23       ', 'R BENVINDA LEAO', 'BAIXAO                        ');
INSERT INTO cd_cep_br VALUES ('57.312-140', '23       ', 'PC BIBLIA, DA', 'S ESMERALDA                   ');
INSERT INTO cd_cep_br VALUES ('57.313-470', '23       ', 'R BOA ESPERANCA', 'JD TROPICAL                   ');
INSERT INTO cd_cep_br VALUES ('57.304-200', '23       ', 'R BOA SORTE', 'PRIMAVERA                     ');
INSERT INTO cd_cep_br VALUES ('57.300-030', '23       ', 'R BOA VISTA', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.308-550', '23       ', 'R BOCA DA MATA', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('57.300-280', '23       ', 'PC BOM CONSELHO', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.305-130', '23       ', 'R BOM CONSELHO', 'M TELES                       ');
INSERT INTO cd_cep_br VALUES ('57.308-380', '23       ', 'AV BRANQUINHA', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('57.303-170', '23       ', 'R BRASIL', 'V CAMPOS                      ');
INSERT INTO cd_cep_br VALUES ('57.313-130', '23       ', 'R BRASILIA', 'BRASILIA                      ');
INSERT INTO cd_cep_br VALUES ('57.304-430', '23       ', 'R BRAZ VIEIRA DE SANTANA', 'PRIMAVERA                     ');
INSERT INTO cd_cep_br VALUES ('57.311-030', '23       ', 'R BRIVALDO JOAQUIM', 'S T VILELA                    ');
INSERT INTO cd_cep_br VALUES ('57.308-490', '23       ', 'R CAJUEIRO', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('57.306-180', '23       ', 'PC CAMARA JUNIOR', 'ELDORADO                      ');
INSERT INTO cd_cep_br VALUES ('57.308-430', '23       ', 'R CAMPO GRANDE', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('57.313-560', '23       ', 'R CANAPI', 'JD TROPICAL                   ');
INSERT INTO cd_cep_br VALUES ('57.306-520', '23       ', 'R CANDIDO JOSE DOS SANTOS', 'CAVACO                        ');
INSERT INTO cd_cep_br VALUES ('57.303-600', '23       ', 'R CARLINDO OLINDINO PEREIRA', 'GUARIBAS                      ');
INSERT INTO cd_cep_br VALUES ('57.314-100', '23       ', 'R CARLOS ALBERTO ALBUQUERQUE MELO', 'ITAPOA                        ');
INSERT INTO cd_cep_br VALUES ('57.302-430', '23       ', 'R CARLOS ALBERTO VITAL', 'N ESPERANCA                   ');
INSERT INTO cd_cep_br VALUES ('57.307-190', '23       ', 'R CARLOS CESAR ARAUJO', 'BX GRANDE                     ');
INSERT INTO cd_cep_br VALUES ('57.302-270', '23       ', 'PC CARLOS GOMES', 'S LUIZ                        ');
INSERT INTO cd_cep_br VALUES ('57.310-370', '23       ', 'R CARMELITA NUNES DE ALBURQUE', 'R CRUZ                        ');
INSERT INTO cd_cep_br VALUES ('57.303-440', '23       ', 'R CASSIMIRO DIAS', 'GUARIBAS                      ');
INSERT INTO cd_cep_br VALUES ('57.310-330', '23       ', 'R CECILIA PEREIRA AMORIM', 'R CRUZ                        ');
INSERT INTO cd_cep_br VALUES ('57.310-250', '23       ', 'R CELESTINO MARIO DO NASCIMENTO', 'R CRUZ                        ');
INSERT INTO cd_cep_br VALUES ('57.304-750', '23       ', 'R CHIQUINHA MACEDO', 'CACIMBAS                      ');
INSERT INTO cd_cep_br VALUES ('57.304-800', '23       ', 'R ANTONIO JOSE DOS SANTOS', 'O D CAZUZINHOS                ');
INSERT INTO cd_cep_br VALUES ('57.311-310', '23       ', 'PC ANTONIO LAURINDO', 'CAITITUS                      ');
INSERT INTO cd_cep_br VALUES ('57.305-300', '23       ', 'R ANTONIO LEAO DA SILVA', 'M TELES                       ');
INSERT INTO cd_cep_br VALUES ('57.307-660', '23       ', 'R ANTONIO LEAO DE MELO', 'JD ESPERANCA                  ');
INSERT INTO cd_cep_br VALUES ('57.306-660', '23       ', 'R ESTUDANTE JOSE ADEMIR GONCALVES GOES', 'CAVACO                        ');
INSERT INTO cd_cep_br VALUES ('57.300-310', '23       ', 'R ESTUDANTE JOSE DE OLIVEIRA LEITE- ATE 385/362', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.301-060', '23       ', 'R ESTUDANTE JOSE DE OLIVEIRA LEITE- DE 387/364 A', 'O PRETO                       ');
INSERT INTO cd_cep_br VALUES ('57.303-430', '23       ', 'PC ESTUDANTE JOSE VANILDO CARDOSO', 'V CAMPOS                      ');
INSERT INTO cd_cep_br VALUES ('57.306-150', '23       ', 'R ESTUDANTE LUIZ CARLOS DE AGUIAR BARBOSA', 'ELDORADO                      ');
INSERT INTO cd_cep_br VALUES ('57.311-450', '23       ', 'R ESTUDANTE MARIA NIEDJA DE ALMEIDA ARAUJO', 'CAITITUS                      ');
INSERT INTO cd_cep_br VALUES ('57.306-190', '23       ', 'R ESTUDANTE MARTHA REGIA BISPO', 'ELDORADO                      ');
INSERT INTO cd_cep_br VALUES ('57.304-780', '23       ', 'R ESTUDANTE RODRIGO ALVES DA SILVA SANTOS', 'O D CAZUZINHOS                ');
INSERT INTO cd_cep_br VALUES ('57.306-630', '23       ', 'R EUCLIDES DE OLIVEIRA SANTOS', 'CAVACO                        ');
INSERT INTO cd_cep_br VALUES ('57.303-530', '23       ', 'R EUCLIDES MARQUES DE SA', 'GUARIBAS                      ');
INSERT INTO cd_cep_br VALUES ('57.305-600', '23       ', 'R EUZEBIO BERNADINO', 'BAIXAO                        ');
INSERT INTO cd_cep_br VALUES ('57.300-590', '23       ', 'R EXPEDICIONARIO BRASILEIRO- ATE 351/370', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.306-000', '23       ', 'R EXPEDICIONARIO BRASILEIRO- DE 353/372 AO FIM', 'ELDORADO                      ');
INSERT INTO cd_cep_br VALUES ('57.306-340', '23       ', 'R EZEQUIEL ALEXANDRE DOS SANTOS', 'CAVACO                        ');
INSERT INTO cd_cep_br VALUES ('57.300-320', '23       ', 'R FAUSTO JOAQUIM LUCIANO', 'S T VILELA                    ');
INSERT INTO cd_cep_br VALUES ('57.307-100', '23       ', 'R FELIZARDO JONAS LEAL ARAUJO', 'BX GRANDE                     ');
INSERT INTO cd_cep_br VALUES ('57.300-070', '23       ', 'R FERNANDES LIMA', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.308-060', '23       ', 'R FILADELFO MACEDO', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('57.313-210', '23       ', 'R FIRMINO LEITE', 'BRASILIA                      ');
INSERT INTO cd_cep_br VALUES ('57.304-670', '23       ', 'R FLORA FRANCA BEZERRA', 'CACIMBAS                      ');
INSERT INTO cd_cep_br VALUES ('57.312-500', '23       ', 'R FLORACY DA SILVA BARROS', 'AT CRUZEIRO                   ');
INSERT INTO cd_cep_br VALUES ('57.312-440', '23       ', 'R FLORENCIO APOLINARIO', 'AT CRUZEIRO                   ');
INSERT INTO cd_cep_br VALUES ('12.912-290', '4897     ', 'PC PAZ, DA', 'VL MUNICIPAL                  ');
INSERT INTO cd_cep_br VALUES ('57.303-410', '23       ', 'R FLORENCIO BARBOSA', 'GUARIBAS                      ');
INSERT INTO cd_cep_br VALUES ('57.313-440', '23       ', 'R FLORES, DAS', 'JD TROPICAL                   ');
INSERT INTO cd_cep_br VALUES ('57.306-640', '23       ', 'R FLORIANO DE OLIVEIRA FRANCA', 'CAVACO                        ');
INSERT INTO cd_cep_br VALUES ('57.312-100', '23       ', 'R FLORO GOMES NOVAES', 'S ESMERALDA                   ');
INSERT INTO cd_cep_br VALUES ('57.313-460', '23       ', 'R FORMOSA', 'JD TROPICAL                   ');
INSERT INTO cd_cep_br VALUES ('57.311-160', '23       ', 'R FORTALEZA', 'S T VILELA                    ');
INSERT INTO cd_cep_br VALUES ('57.302-400', '23       ', 'R DJALMA MATHEUS SANTANA', 'N ESPERANCA                   ');
INSERT INTO cd_cep_br VALUES ('57.313-060', '23       ', 'R DOIS DE FEVEREIRO', 'BRASILIA                      ');
INSERT INTO cd_cep_br VALUES ('57.302-040', '23       ', 'PC DOM ADELMO MACHADO', 'CANAFISTULA                   ');
INSERT INTO cd_cep_br VALUES ('57.300-580', '23       ', 'R DOM FELICIO VASCONCELOS', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.300-290', '23       ', 'LRG DOM FERNANDO GOMES', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.310-110', '23       ', 'R DOM JOAO VI', 'CAPIATA                       ');
INSERT INTO cd_cep_br VALUES ('57.301-130', '23       ', 'R DOM JONAS BATINGA', 'O PRETO                       ');
INSERT INTO cd_cep_br VALUES ('57.046-110', '54       ', 'R HELIO GOMES PEIXOTO', 'SERRARIA                      ');
INSERT INTO cd_cep_br VALUES ('57.017-005', '54       ', 'PC HELIO LEMOS', 'B PARTO                       ');
INSERT INTO cd_cep_br VALUES ('57.035-220', '54       ', 'R HELIO PRADINES', 'P VERDE                       ');
INSERT INTO cd_cep_br VALUES ('69.049-440', '156      ', 'R 10 (CJ HILEIA II)', 'REDENCAO                      ');
INSERT INTO cd_cep_br VALUES ('69.049-260', '156      ', 'R 10 (CJ HILEIAI )', 'REDENCAO                      ');
INSERT INTO cd_cep_br VALUES ('69.067-191', '156      ', 'R 10 (CJ JD PETROPOLIS)', 'PETROPOLIS                    ');
INSERT INTO cd_cep_br VALUES ('69.044-570', '156      ', 'R 10 (CJ JD VERSALLES)', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('69.093-490', '156      ', 'R 10 (CJ MANOA)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.090-440', '156      ', 'R 10 (CJ MUNDO NOVO)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.028-311', '156      ', 'R 10 (CJ R MARACANA)', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('69.090-690', '156      ', 'R 10 (CJ R S PINTO I)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.036-450', '156      ', 'R 10 (CJ R XINGU)', 'COMPENSA                      ');
INSERT INTO cd_cep_br VALUES ('69.028-409', '156      ', 'R 10 (CJ SUBTEN SRG P MILITAR)', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('69.055-755', '156      ', 'R 10 (CJ TROPICAL)', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.057-780', '156      ', 'R 10 (CJ V MUNICIPAL)', 'ADRIANOPOLIS                  ');
INSERT INTO cd_cep_br VALUES ('69.093-273', '156      ', 'R 10 (M SINAI)', 'COL S ANTONIO                 ');
INSERT INTO cd_cep_br VALUES ('69.094-100', '156      ', 'R 10 (NUCLEO 2)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.040-617', '156      ', 'R 10 (PRQ ARIPUANA)', 'D PEDRO                       ');
INSERT INTO cd_cep_br VALUES ('69.086-111', '156      ', 'R 10 A', 'S J OPERARIO                  ');
INSERT INTO cd_cep_br VALUES ('69.043-190', '156      ', 'R 10 ATE 851/114', 'ALVORADA                      ');
INSERT INTO cd_cep_br VALUES ('69.086-112', '156      ', 'R 10 K', 'S J OPERARIO                  ');
INSERT INTO cd_cep_br VALUES ('69.096-310', '156      ', 'R 100 (NUCLEO 12)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.096-320', '156      ', 'R 101 (NUCLEO 12)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.057-760', '156      ', 'R 08 (CJ V MUNICIPAL)', 'ADRIANOPOLIS                  ');
INSERT INTO cd_cep_br VALUES ('69.077-090', '156      ', 'R 08 (CJ 31 DE MARCO I)', 'JAPIIM                        ');
INSERT INTO cd_cep_br VALUES ('69.093-272', '156      ', 'R 08 (M SINAI)', 'COL S ANTONIO                 ');
INSERT INTO cd_cep_br VALUES ('69.094-080', '156      ', 'R 08 (NUCLEO 2)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.040-616', '156      ', 'R 08 (PRQ ARIPUANA)', 'D PEDRO                       ');
INSERT INTO cd_cep_br VALUES ('69.054-739', '156      ', 'R 08 (SHANGRILA IV)', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.035-798', '156      ', 'R 08 (VL MARINHO)', 'COMPENSA                      ');
INSERT INTO cd_cep_br VALUES ('69.043-140', '156      ', 'R 08 ATE 166/167', 'ALVORADA                      ');
INSERT INTO cd_cep_br VALUES ('69.086-100', '156      ', 'R 09', 'S J OPERARIO                  ');
INSERT INTO cd_cep_br VALUES ('69.038-279', '156      ', 'R 09', 'L VALE                        ');
INSERT INTO cd_cep_br VALUES ('69.042-040', '156      ', 'R 09- DE 118/127 AO FIM', 'ALVORADA                      ');
INSERT INTO cd_cep_br VALUES ('69.038-360', '156      ', 'R 09 (CJ A MONTENEGRO)', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('69.028-335', '156      ', 'R 09 (CJ B FLOR II)', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('69.055-270', '156      ', 'R 09 (CJ C BRANCO)', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.083-520', '156      ', 'R 09 (CJ C DO ALEIXO)', 'S J OPERARIO                  ');
INSERT INTO cd_cep_br VALUES ('69.097-050', '156      ', 'R 09 (CJ CANARANAS)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.086-480', '156      ', 'R 09 (CJ CASTANHEIRA)', 'S J OPERARIO                  ');
INSERT INTO cd_cep_br VALUES ('69.068-370', '156      ', 'R 09 (CJ COSTA E SILVA)', 'RAIZ                          ');
INSERT INTO cd_cep_br VALUES ('69.049-250', '156      ', 'R 09 (CJ HILEIA I )', 'REDENCAO                      ');
INSERT INTO cd_cep_br VALUES ('69.049-430', '156      ', 'R 09 (CJ HILEIA II)', 'REDENCAO                      ');
INSERT INTO cd_cep_br VALUES ('69.067-190', '156      ', 'R 09 (CJ JD PETROPOLIS)', 'PETROPOLIS                    ');
INSERT INTO cd_cep_br VALUES ('69.054-300', '156      ', 'R 09 (CJ JD PRIMAVERA)', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.044-560', '156      ', 'R 09 (CJ JD VERSALLES)', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('69.093-480', '156      ', 'R 09 (CJ MANOA)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.090-430', '156      ', 'R 09 (CJ MUNDO NOVO)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.054-100', '156      ', 'R 09 (CJ N FRIBURGO)', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.028-309', '156      ', 'R 09 (CJ R MARACANA)', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('12.906-641', '4897     ', 'R PROJETADA A', 'CRUZEIRO                      ');
INSERT INTO cd_cep_br VALUES ('69.090-680', '156      ', 'R 09 (CJ R S PINTO I)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.036-440', '156      ', 'R 09 (CJ R XINGU)', 'COMPENSA                      ');
INSERT INTO cd_cep_br VALUES ('69.028-408', '156      ', 'R 09 (CJ SUBTEN SRG P MILITAR)', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('69.055-748', '156      ', 'R 09 (CJ TROPICAL)', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.038-810', '156      ', 'R 09 (CJ V BELA)', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('69.083-430', '156      ', 'R 09 (CJ V CAMARA )', 'ALEIXO                        ');
INSERT INTO cd_cep_br VALUES ('69.057-770', '156      ', 'R 09 (CJ V MUNICIPAL)', 'ADRIANOPOLIS                  ');
INSERT INTO cd_cep_br VALUES ('69.077-100', '156      ', 'R 09 (CJ 31 DE MARCO I)', 'JAPIIM                        ');
INSERT INTO cd_cep_br VALUES ('69.093-267', '156      ', 'R 09 (M SINAI)', 'COL S ANTONIO                 ');
INSERT INTO cd_cep_br VALUES ('69.094-090', '156      ', 'R 09 (NUCLEO 2)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.040-621', '156      ', 'R 09 (PRQ ARIPUANA)', 'D PEDRO                       ');
INSERT INTO cd_cep_br VALUES ('69.036-420', '156      ', 'R 07 (CJ R XINGU)', 'COMPENSA                      ');
INSERT INTO cd_cep_br VALUES ('69.028-406', '156      ', 'R 07 (CJ SUBTEN SRG P MILITAR)', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('69.055-746', '156      ', 'R 07 (CJ TROPICAL)', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.038-790', '156      ', 'R 07 (CJ V BELA)', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('69.083-410', '156      ', 'R 07 (CJ V CAMARA)', 'ALEIXO                        ');
INSERT INTO cd_cep_br VALUES ('69.057-750', '156      ', 'R 07 (CJ V MUNICIPAL)', 'ADRIANOPOLIS                  ');
INSERT INTO cd_cep_br VALUES ('69.077-080', '156      ', 'R 07 (CJ 31 DE MARCO I)', 'JAPIIM                        ');
INSERT INTO cd_cep_br VALUES ('69.093-266', '156      ', 'R 07 (M SINAI)', 'COL S ANTONIO                 ');
INSERT INTO cd_cep_br VALUES ('69.094-070', '156      ', 'R 07 (NUCLEO 2)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.040-620', '156      ', 'R 07 (PRQ ARIPUANA)', 'D PEDRO                       ');
INSERT INTO cd_cep_br VALUES ('69.054-738', '156      ', 'R 07 (SHANGRILA IV)', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.035-797', '156      ', 'R 07 (VL MARINHO)', 'COMPENSA                      ');
INSERT INTO cd_cep_br VALUES ('69.043-170', '156      ', 'R 07 ATE 131/132', 'ALVORADA                      ');
INSERT INTO cd_cep_br VALUES ('69.086-090', '156      ', 'R 08', 'S J OPERARIO                  ');
INSERT INTO cd_cep_br VALUES ('69.028-346', '156      ', 'TV 08', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('69.038-278', '156      ', 'R 08', 'L VALE                        ');
INSERT INTO cd_cep_br VALUES ('69.042-050', '156      ', 'R 08- DE 168/169 AO FIM', 'ALVORADA                      ');
INSERT INTO cd_cep_br VALUES ('69.038-350', '156      ', 'R 08 (CJ A MONTENEGRO)', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('69.028-334', '156      ', 'R 08 (CJ B FLOR II)', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('69.055-260', '156      ', 'R 08 (CJ C BRANCO)', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.083-510', '156      ', 'R 08 (CJ C DO ALEIXO)', 'S J OPERARIO                  ');
INSERT INTO cd_cep_br VALUES ('69.086-470', '156      ', 'R 08 (CJ CASTANHEIRA)', 'S J OPERARIO                  ');
INSERT INTO cd_cep_br VALUES ('69.068-360', '156      ', 'R 08 (CJ COSTA E SILVA)', 'RAIZ                          ');
INSERT INTO cd_cep_br VALUES ('69.097-773', '156      ', 'R 08 (CJ F MENDES I)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.049-240', '156      ', 'R 08 (CJ HILEIA I)', 'REDENCAO                      ');
INSERT INTO cd_cep_br VALUES ('69.049-420', '156      ', 'R 08 (CJ HILEIA II)', 'REDENCAO                      ');
INSERT INTO cd_cep_br VALUES ('69.054-290', '156      ', 'R 08 (CJ JD PRIMAVERA)', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.044-550', '156      ', 'R 08 (CJ JD VERSALLES)', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('69.093-470', '156      ', 'R 08 (CJ MANOA)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.090-420', '156      ', 'R 08 (CJ MUNDO NOVO)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.054-090', '156      ', 'R 08 (CJ N FRIBURGO)', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.028-308', '156      ', 'R 08 (CJ R MARACANA)', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('69.090-670', '156      ', 'R 08 (CJ R S PINTO I)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.036-430', '156      ', 'R 08 (CJ R XINGU)', 'COMPENSA                      ');
INSERT INTO cd_cep_br VALUES ('69.028-407', '156      ', 'R 08 (CJ SUBTEN SRG P MILITAR)', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('69.055-747', '156      ', 'R 08 (CJ TROPICAL)', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.038-800', '156      ', 'R 08 (CJ V BELA)', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('69.083-420', '156      ', 'R 08 (CJ V CAMARA)', 'ALEIXO                        ');
INSERT INTO cd_cep_br VALUES ('69.054-070', '156      ', 'R 06 (CJ N FRIBURGO)', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.028-306', '156      ', 'R 06 (CJ R MARACANA)', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('69.090-650', '156      ', 'R 06 (CJ R S PINTO I)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.036-410', '156      ', 'R 06 (CJ R XINGU)', 'COMPENSA                      ');
INSERT INTO cd_cep_br VALUES ('69.028-405', '156      ', 'R 06 (CJ SUBTEN SRG P MILITAR)', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('57.305-200', '23       ', 'R MANOEL CORREIA DE MACEDO', 'M TELES                       ');
INSERT INTO cd_cep_br VALUES ('57.050-740', '54       ', 'R MANOEL GONCALVES FERREIRA', 'G LOURDES                     ');
INSERT INTO cd_cep_br VALUES ('57.046-830', '54       ', 'R MANOEL TENORIO (LOT MURILOPOLIS)', 'SERRARIA                      ');
INSERT INTO cd_cep_br VALUES ('57.040-490', '54       ', 'R MANOEL VIANA DE OLIVEIRA', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.050-470', '54       ', 'R MANUEL MONTEIRO DA SILVA', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.038-340', '54       ', 'R MARAGOGI', 'C ALMAS                       ');
INSERT INTO cd_cep_br VALUES ('57.080-110', '54       ', 'R MARAGOGI', 'CANAA                         ');
INSERT INTO cd_cep_br VALUES ('57.075-140', '54       ', 'R MARAJO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.071-775', '54       ', 'CJ MARAJO', 'A S DUMONT                    ');
INSERT INTO cd_cep_br VALUES ('57.075-150', '54       ', 'R MARANATA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.045-530', '54       ', 'R MARANHAO', 'O PRETO                       ');
INSERT INTO cd_cep_br VALUES ('57.010-170', '54       ', 'R MARANHAO', 'PRADO                         ');
INSERT INTO cd_cep_br VALUES ('57.045-535', '54       ', 'TV MARANHAO', 'O PRETO                       ');
INSERT INTO cd_cep_br VALUES ('57.030-540', '54       ', 'PC MARAVILHA, DA', 'POCO                          ');
INSERT INTO cd_cep_br VALUES ('57.015-110', '54       ', 'R MARCELO DOS SANTOS GUIMARAES', 'V LAGO                        ');
INSERT INTO cd_cep_br VALUES ('57.048-080', '54       ', 'R MARCELO OLIVEIRA RESENDE', 'SERRARIA                      ');
INSERT INTO cd_cep_br VALUES ('57.061-510', '54       ', 'R MARCIO AMERICO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.045-510', '54       ', 'R MAJOR JOAO MEDEIROS', 'SERRARIA                      ');
INSERT INTO cd_cep_br VALUES ('57.051-490', '54       ', 'R MATHEUS DE ALBUQUERQUE', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.022-090', '54       ', 'R MATO GROSSO', 'JARAGUA                       ');
INSERT INTO cd_cep_br VALUES ('57.071-655', '54       ', 'R MAURICIO DE MELO E MOTTA', 'A S DUMONT                    ');
INSERT INTO cd_cep_br VALUES ('57.041-590', '54       ', 'R MAURO VASCONCELOS', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.084-690', '54       ', 'R MAX DOUGLAS', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.084-590', '54       ', 'R MAXIMILIANO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.060-640', '54       ', 'CJ MEDEIROS NETO I', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.060-830', '54       ', 'CJ MEDEIROS NETO II', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.060-840', '54       ', 'CJ MEDEIROS NETO III', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.043-120', '54       ', 'R MEIO, DO', 'FEITOSA                       ');
INSERT INTO cd_cep_br VALUES ('57.070-410', '54       ', 'R MEIO, DO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.084-700', '54       ', 'AV MEIRIM', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.041-750', '54       ', 'R MELO MAIA', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.020-330', '54       ', 'R MELO MORAIS', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.022-230', '54       ', 'R MELO POVOAS', 'JARAGUA                       ');
INSERT INTO cd_cep_br VALUES ('57.017-440', '54       ', 'R MEM DE SA', 'BEBEDOURO                     ');
INSERT INTO cd_cep_br VALUES ('57.039-120', '54       ', 'R MENDONCA BRAGA', 'R DOCE                        ');
INSERT INTO cd_cep_br VALUES ('57.039-130', '54       ', 'R MENESTREL DAS ALAGOAS', 'JACARECICA                    ');
INSERT INTO cd_cep_br VALUES ('57.046-000', '54       ', 'AV MENINO MARCELO- ATE 5360/5361', 'B DURO                        ');
INSERT INTO cd_cep_br VALUES ('57.083-410', '54       ', 'AV MENINO MARCELO- DE 5362/5363 AO FIM', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.081-410', '54       ', 'R MENSAGEIRO JOAO SARMENTO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.082-620', '54       ', 'R MENSAGEIRO JOSE RAIMUNDO DOS SANTOS', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.015-550', '54       ', 'R MESSIAS DE GUSMAO', 'P GROSSA                      ');
INSERT INTO cd_cep_br VALUES ('57.084-710', '54       ', 'R MESTRE JOSE CARLOS DE ATAIDE(RUA 4 CJ RESIDENC', 'BENEDITO BENTES               ');
INSERT INTO cd_cep_br VALUES ('57.084-720', '54       ', 'R MESTRE MANOEL SOARES DA SILVA(RUA 01 CJ RESIDE', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.036-680', '54       ', 'R MIGUEL ALCIDES DE CASTRO', 'JATIUCA                       ');
INSERT INTO cd_cep_br VALUES ('57.036-290', '54       ', 'R MIGUEL ALCIDES NETO', 'JATIUCA                       ');
INSERT INTO cd_cep_br VALUES ('57.017-310', '54       ', 'R MIGUEL BATISTA', 'B PARTO                       ');
INSERT INTO cd_cep_br VALUES ('57.050-300', '54       ', 'R MIGUEL GUEDES NOGUEIRA', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.050-310', '54       ', 'R MIGUEL PALMEIRA- ATE 613/662', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.055-330', '54       ', 'R MIGUEL PALMEIRA- DE 615/664 AO FIM', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.042-730', '54       ', 'R MARIA DOLORES PONTES LIMA', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.082-790', '54       ', 'R MARIA ERIVANIA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.048-030', '54       ', 'R MARIA EULINA QUINTELA', 'SERRARIA                      ');
INSERT INTO cd_cep_br VALUES ('57.048-190', '54       ', 'R MARIA GAMA DE CARVALHO', 'SERRARIA                      ');
INSERT INTO cd_cep_br VALUES ('57.060-250', '54       ', 'R MARIA GUEDES DE OMENA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.051-470', '54       ', 'R MARIA HELENA SALDANHA', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.072-400', '54       ', 'R MARIA JOSE DAS CHAGAS CAMELO SILVA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.035-580', '54       ', 'R MARIA JULIA DOS SANTOS', 'JATIUCA                       ');
INSERT INTO cd_cep_br VALUES ('57.051-670', '54       ', 'R MARIA LAURINDA GOMES', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.060-520', '54       ', 'R MARIA LUIZA GOMES BERNARDES', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.060-240', '54       ', 'R MARIA NAZARETH DE ARAUJO SILVA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.062-390', '54       ', 'AL MARIA NAZARETH PEREIRA DA SILVA DORIA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.041-170', '54       ', 'R MARIA PINHEIRO DOS SANTOS', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.042-390', '54       ', 'R MARIA RAMIRES MARTINS', 'B VISTA                       ');
INSERT INTO cd_cep_br VALUES ('57.073-600', '54       ', 'AV MARIA RUFINO DOS SANTOS', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.071-085', '54       ', 'R MARIA SALVELINA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.018-710', '54       ', 'R MARIA VIOLETA CAVALCANTI', 'C JAQUEIRA                    ');
INSERT INTO cd_cep_br VALUES ('57.073-120', '54       ', 'R MARIA VITORIA CALHEIROS GATTO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.030-550', '54       ', 'R MARIA VITORIA DE FRANCA CHAVES', 'POCO                          ');
INSERT INTO cd_cep_br VALUES ('57.071-450', '54       ', 'R MARIETA QUINTELA CAMPOS TEIXEIRA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.042-400', '54       ', 'R MARINALVA LINS DE OLIVEIRA', 'FEITOSA                       ');
INSERT INTO cd_cep_br VALUES ('57.037-380', '54       ', 'AL MARIO DA SILVA JAMBO', 'MANGABEIRAS                   ');
INSERT INTO cd_cep_br VALUES ('57.017-780', '54       ', 'PRQ MARIO DUBEAUX LEAO', 'BEBEDOURO                     ');
INSERT INTO cd_cep_br VALUES ('57.039-270', '54       ', 'R MARIO GUIMARAES', 'R DOCE                        ');
INSERT INTO cd_cep_br VALUES ('57.050-280', '54       ', 'R MARIO LOBO', 'PITANGUINHA                   ');
INSERT INTO cd_cep_br VALUES ('57.075-040', '54       ', 'CJ MARIO MAFRA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.060-290', '54       ', 'R MARIO MARROQUIM', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.037-360', '54       ', 'R MARIO PALMEIRA JUNIOR', 'POCO                          ');
INSERT INTO cd_cep_br VALUES ('57.035-370', '54       ', 'R MARIO PRADINES', 'P VERDE                       ');
INSERT INTO cd_cep_br VALUES ('57.039-110', '54       ', 'R MARIO SARAIVA', 'R DOCE                        ');
INSERT INTO cd_cep_br VALUES ('57.030-560', '54       ', 'R MARIONTINA MORAIS CAVALCANTI', 'PAJUCARA                      ');
INSERT INTO cd_cep_br VALUES ('57.051-680', '54       ', 'LD MARISTA, DO', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.045-290', '54       ', 'R MARNE LOPES PIMENTEL', 'B DURO                        ');
INSERT INTO cd_cep_br VALUES ('57.018-330', '54       ', 'R MARQUES DE ABRANTES', 'BEBEDOURO                     ');
INSERT INTO cd_cep_br VALUES ('57.057-630', '54       ', 'R MARQUES DE JOANNIS', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.082-800', '54       ', 'R MARQUES DE OLIVEIRA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.025-530', '54       ', 'R MARQUES DE TAMANDARE', 'POCO                          ');
INSERT INTO cd_cep_br VALUES ('57.081-090', '54       ', 'R MARQUES DE TAMANDARE', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.039-490', '54       ', 'R MARCOS ANTONIO CAVALCANTE SILVA', 'JACARECICA                    ');
INSERT INTO cd_cep_br VALUES ('57.061-320', '54       ', 'R MARCOS AURELIO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.036-310', '54       ', 'R MARCOS LISBOA DE ALMEIDA', 'JATIUCA                       ');
INSERT INTO cd_cep_br VALUES ('57.082-780', '54       ', 'R MARCOS MACHADO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.071-130', '54       ', 'AV MUNIZ FALCAO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.038-370', '54       ', 'R MURICI', 'C ALMAS                       ');
INSERT INTO cd_cep_br VALUES ('57.085-040', '54       ', 'CJ MURILO  MENDES', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.045-300', '54       ', 'LD MURILO MONTEIRO VALENTE', 'B DURO                        ');
INSERT INTO cd_cep_br VALUES ('57.045-720', '54       ', 'CJ MURILOPOLIS', 'B DURO                        ');
INSERT INTO cd_cep_br VALUES ('57.084-750', '54       ', 'R MUSICA ,DA', 'BENEDITO BENTES               ');
INSERT INTO cd_cep_br VALUES ('57.085-190', '54       ', 'CJ MUTIRAO SELMA BANDEIRA', 'BENEDITO BENTES               ');
INSERT INTO cd_cep_br VALUES ('57.045-550', '54       ', 'R NABAL', 'B DURO                        ');
INSERT INTO cd_cep_br VALUES ('57.081-300', '54       ', 'AV NACOES UNIDAS', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('69.099-150', '156      ', 'R 34 (A MENDES)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.038-610', '156      ', 'R 34 (CJ A MONTENEGRO)', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('57.071-350', '54       ', 'AV JORNALISTA TEOFILO ALVES LINS', 'A S DUMONT                    ');
INSERT INTO cd_cep_br VALUES ('57.084-000', '54       ', 'AV JORNALISTA TOBIAS GRANJA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.083-060', '54       ', 'R JOSE ABILIO LEAO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.073-250', '54       ', 'R JOSE ALBERTO CORREIA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.048-210', '54       ', 'R JOSE ALBUQUERQUE MATOS', 'SERRARIA                      ');
INSERT INTO cd_cep_br VALUES ('57.047-120', '54       ', 'R JOSE ALFREDO MARQUES', 'SERRARIA                      ');
INSERT INTO cd_cep_br VALUES ('57.010-420', '54       ', 'R JOSE ALVES BARBOSA', 'T BARRA                       ');
INSERT INTO cd_cep_br VALUES ('57.062-150', '54       ', 'R JOSE ALVES DINIZ', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.036-620', '54       ', 'R JOSE ALVES MORGADO', 'JATIUCA                       ');
INSERT INTO cd_cep_br VALUES ('57.082-240', '54       ', 'R JOSE ALVES PINTO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.017-350', '54       ', 'R JOSE AUGUSTO BEZERRA', 'BEBEDOURO                     ');
INSERT INTO cd_cep_br VALUES ('57.072-800', '54       ', 'R JOSE AUGUSTO LESSA (CJ CIDADE UNIVERSITARIA)', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.042-790', '54       ', 'R JOSE BANDEIRA', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.082-040', '54       ', 'R JOSE BANDEIRA BASTOS', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.042-690', '54       ', 'R JOSE BARBOSA', 'B VISTA                       ');
INSERT INTO cd_cep_br VALUES ('57.081-620', '54       ', 'R JOSE BARBOSA DA SILVA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.015-100', '54       ', 'R LAVANDERIA, DA', 'V LAGO                        ');
INSERT INTO cd_cep_br VALUES ('57.045-090', '54       ', 'R LEAO', 'B DURO                        ');
INSERT INTO cd_cep_br VALUES ('57.060-130', '54       ', 'R LEAO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.042-800', '54       ', 'R LEAO', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.031-180', '54       ', 'R LEONCIO NOVAES DE CASTRO', 'POCO                          ');
INSERT INTO cd_cep_br VALUES ('57.072-110', '54       ', 'R JOSE MARIA MENDES DA SILVA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.011-280', '54       ', 'R JOSE MARQUES RIBEIRO', 'T BARRA                       ');
INSERT INTO cd_cep_br VALUES ('57.073-230', '54       ', 'R JOSE MARTINS DE OLVEIRA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.018-310', '54       ', 'R JOSE MELO ARGOLO', 'C JAQUEIRA                    ');
INSERT INTO cd_cep_br VALUES ('57.073-160', '54       ', 'R JOSE MENDONCA DE ALMEIDA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.025-520', '54       ', 'R JOSE MERCULES DOS SANTOS', 'POCO                          ');
INSERT INTO cd_cep_br VALUES ('57.017-620', '54       ', 'R JOSE MOREIRA', 'BEBEDOURO                     ');
INSERT INTO cd_cep_br VALUES ('57.083-300', '54       ', 'R JOSE OMENA BARBOSA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.057-580', '54       ', 'R JOSE OMENA DE ANDRADE', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.018-100', '54       ', 'R JOSE OVIDIO DA COSTA BRAGA', 'BEBEDOURO                     ');
INSERT INTO cd_cep_br VALUES ('57.080-530', '54       ', 'R JOSE PAIZINHO DA SILVA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.060-470', '54       ', 'R JOSE PIMENTEL DE VASCONCELOS', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.011-290', '54       ', 'R JOSE PIMENTEL LEITE PASSOS', 'T BARRA                       ');
INSERT INTO cd_cep_br VALUES ('57.031-150', '54       ', 'R JOSE PINTO DE BARROS', 'POCO                          ');
INSERT INTO cd_cep_br VALUES ('57.036-250', '54       ', 'R JOSE PONTES MAGALHAES', 'JATIUCA                       ');
INSERT INTO cd_cep_br VALUES ('57.061-750', '54       ', 'R JOSE PONTES SOBRINHO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.041-230', '54       ', 'R JOSE PREZADO', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.060-480', '54       ', 'R JOSE RAIMUNDO DA SILVA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.041-810', '54       ', 'TV JOSE REGO BARROS', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.041-800', '54       ', 'R JOSE REGO BARROS', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.041-540', '54       ', 'R JOSE REIS DE CAMPOS', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.042-580', '54       ', 'PC JOSE RESENDE FILHO', 'B VISTA                       ');
INSERT INTO cd_cep_br VALUES ('57.062-660', '54       ', 'R JOSE ROCHA LIMA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.063-170', '54       ', 'R JOSE RUBENS UCHOA LINS(LOT CIPESA)', 'S AMELIA                      ');
INSERT INTO cd_cep_br VALUES ('57.041-550', '54       ', 'R JOSE SABINO DE OLIVEIRA FILHO', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.082-050', '54       ', 'R JOSE SALES PITOMBEIRA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.036-640', '54       ', 'R JOSE SOARES SOBRINHO', 'JATIUCA                       ');
INSERT INTO cd_cep_br VALUES ('57.071-595', '54       ', 'R JOSE TENORIO', 'A S DUMONT                    ');
INSERT INTO cd_cep_br VALUES ('57.046-350', '54       ', 'CJ JOSE TENORIO LINS', 'SERRARIA                      ');
INSERT INTO cd_cep_br VALUES ('57.075-130', '54       ', 'R JOSE VANILDO BARROS', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.017-630', '54       ', 'R JOSE VIANA DE SOUZA', 'BEBEDOURO                     ');
INSERT INTO cd_cep_br VALUES ('57.082-340', '54       ', 'R JOSE VIEIRA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.031-160', '54       ', 'R JOSEFA CAVALCANTE SURUAGY', 'POCO                          ');
INSERT INTO cd_cep_br VALUES ('57.073-300', '54       ', 'R JOSEFA HOLANDA CARVALHO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.082-770', '54       ', 'AV JOSUE ALVES MARQUES', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.060-490', '54       ', 'R JOVELINA SALDANHA DA CUNHA LIMA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.040-600', '54       ', 'AV JUCA SAMPAIO', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.038-600', '54       ', 'AV JUCA SAMPAIO', 'C ALMAS                       ');
INSERT INTO cd_cep_br VALUES ('57.017-730', '54       ', 'R JOSE FRANKLIN SARMENTO FERREIRA', 'BEBEDOURO                     ');
INSERT INTO cd_cep_br VALUES ('57.035-110', '54       ', 'R JOSE FREIRE MOURA', 'P VERDE                       ');
INSERT INTO cd_cep_br VALUES ('57.057-350', '54       ', 'R JOSE GOMES PEIXOTO', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.070-450', '54       ', 'R JOSE GONZAGA DE ALMEIDA(ANTIGA RUA DO ARAME)', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.071-770', '54       ', 'TV JOSE GONZAGA DE ALMEIDA(ANTIGA TRAVESSA DO ARA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.018-090', '54       ', 'TV JOSE GUEDES', 'BEBEDOURO                     ');
INSERT INTO cd_cep_br VALUES ('57.072-130', '54       ', 'R JOSE GUIMARAES SOBRINHO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.073-480', '54       ', 'AV JOSE HAILTON DOS SANTOS(ANTIGA AV UNIVERSITARI', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.060-720', '54       ', 'R JOSE HENRIQUE DO NASCIMENTO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.081-010', '54       ', 'R JOSE HERMES DAMASCENO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.048-090', '54       ', 'R JOSE IVONILTON MOREIRA FERNANDES', 'SERRARIA                      ');
INSERT INTO cd_cep_br VALUES ('57.083-390', '54       ', 'R JOSE JACINTO DE MELO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.050-630', '54       ', 'R JOSE JAERSON FRAGOSO DE MELO', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.041-140', '54       ', 'R JOSE JORGE DE MELO GONCALVES', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.035-540', '54       ', 'R JOSE JULIO SAWER', 'P VERDE                       ');
INSERT INTO cd_cep_br VALUES ('57.040-650', '54       ', 'R JOSE LARANJEIRAS', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.040-655', '54       ', 'TV JOSE LARANJEIRAS', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.057-360', '54       ', 'R JOSE LEAO REGO FILHO', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.061-100', '54       ', 'R JOSE LOBO DE MEDEIROS', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.062-010', '54       ', 'AL JOSE LOPES DE ALBUQUERQUE', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.048-280', '54       ', 'R JOSE LOPES DE CARVALHO(LOT TERRA DE ANTARES I)', 'ANTARES                       ');
INSERT INTO cd_cep_br VALUES ('57.037-200', '54       ', 'R JOSE LOURENCO DE ALBUQUERQUE', 'JATIUCA                       ');
INSERT INTO cd_cep_br VALUES ('57.037-400', '54       ', 'R JOSE LOURENCO PEIXOTO', 'JATIUCA                       ');
INSERT INTO cd_cep_br VALUES ('57.037-350', '54       ', 'R JOSE LUIZ CALAZANS', 'JATIUCA                       ');
INSERT INTO cd_cep_br VALUES ('57.031-140', '54       ', 'R JOSE LUIZ FERREIRA DOS SANTOS', 'POCO                          ');
INSERT INTO cd_cep_br VALUES ('57.046-305', '54       ', 'R JOSE LUIZ MENDONCA', 'B DURO                        ');
INSERT INTO cd_cep_br VALUES ('57.060-120', '54       ', 'R JOSE LUIZ ROCHA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.055-440', '54       ', 'R JOSE LUIZ SOARES NETO', 'PINHEIRO                      ');
INSERT INTO cd_cep_br VALUES ('57.041-150', '54       ', 'R JOSE MACARIO', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.075-340', '54       ', 'R JOSE MACARIO LESSA BELTRAO(CONJUNTO OSMAN LOUR', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.055-080', '54       ', 'R MAJOR FRANCISCO DE BARROS REGO', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.039-100', '54       ', 'R MAJOR IZIDORO JERONIMO DA ROCHA', 'JACARECICA                    ');
INSERT INTO cd_cep_br VALUES ('57.070-230', '54       ', 'PC LEONILDO CARDOSO', 'R NOVO                        ');
INSERT INTO cd_cep_br VALUES ('57.073-010', '54       ', 'R LEONOR LOPES PIMENTEL', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.015-375', '54       ', 'TV SAO BENTO', 'V LAGO                        ');
INSERT INTO cd_cep_br VALUES ('57.043-410', '54       ', 'R SAO BRAS', 'FEITOSA                       ');
INSERT INTO cd_cep_br VALUES ('57.601-140', '40       ', 'AV SETE DE SETEMBRO', 'S CRISTOVAO                   ');
INSERT INTO cd_cep_br VALUES ('57.607-460', '40       ', 'R SEVERINO CORDEIRO DE SOUZA', 'S CRISTOVAO                   ');
INSERT INTO cd_cep_br VALUES ('57.010-110', '54       ', 'PC CUSTODIO DE MELO', 'PRADO                         ');
INSERT INTO cd_cep_br VALUES ('57.018-555', '54       ', 'R DALMO LINS(ANTIGA RUA DA FLORESTA)', 'C JAQUEIRA                    ');
INSERT INTO cd_cep_br VALUES ('57.084-370', '54       ', 'R DALVA COSTA ALCANTARA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.057-620', '54       ', 'R DANUSIA DE MENESES BRANDAO AYRES', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.052-620', '54       ', 'R DANUZIA MELO BUENO AYRES', 'G LOURDES                     ');
INSERT INTO cd_cep_br VALUES ('57.082-200', '54       ', 'R DAYSE TALBERG MITCHELL', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.031-480', '54       ', 'R DELFINO CAVALCANTE', 'MANGABEIRAS                   ');
INSERT INTO cd_cep_br VALUES ('57.038-260', '54       ', 'R DELMIRO GOUVEIA', 'C ALMAS                       ');
INSERT INTO cd_cep_br VALUES ('57.017-410', '54       ', 'R DELMIRO GOUVEIA', 'MUTANGE                       ');
INSERT INTO cd_cep_br VALUES ('57.052-650', '54       ', 'LRG DELMIRO GOUVEIA', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.041-070', '54       ', 'R DEMERVAL MACARIO', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.015-710', '54       ', 'TV DEMOCRATA', 'P GROSSA                      ');
INSERT INTO cd_cep_br VALUES ('57.015-610', '54       ', 'R DEMOCRITO GRACINDO- ATE 92/97', 'P GROSSA                      ');
INSERT INTO cd_cep_br VALUES ('57.014-290', '54       ', 'R DEMOCRITO GRACINDO- DE 94/99 AO FIM', 'P GROSSA                      ');
INSERT INTO cd_cep_br VALUES ('57.060-390', '54       ', 'R DENDE, DO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.063-070', '54       ', 'CJ DENILMA BULHOES', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.036-100', '54       ', 'R DEOCLECIO BARRETO', 'JATIUCA                       ');
INSERT INTO cd_cep_br VALUES ('57.084-630', '54       ', 'AV DEPUTADA SELMA BANDEIRA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.031-080', '54       ', 'R DEPUTADO ABELARDO LOPES', 'POCO                          ');
INSERT INTO cd_cep_br VALUES ('57.071-380', '54       ', 'R DEPUTADO ADEMARIO DANTAS', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.072-540', '54       ', 'R DEPUTADO ADHEMAR MEDEIROS', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.071-740', '54       ', 'R DEPUTADO AMARO DANTAS', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.081-310', '54       ', 'R DEPUTADO ANTENOR CLAUDINO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.036-120', '54       ', 'R DOUTOR ARISTEU LOPES', 'JATIUCA                       ');
INSERT INTO cd_cep_br VALUES ('57.039-220', '54       ', 'R DOUTOR ARTUR CLAUDIO DOS SANTOS NETO', 'R DOCE                        ');
INSERT INTO cd_cep_br VALUES ('57.057-070', '54       ', 'R DOUTOR ARTUR LOPES FERREIRA', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.070-040', '54       ', 'R DOUTOR ARTUR MACHADO', 'F VELHO                       ');
INSERT INTO cd_cep_br VALUES ('57.035-590', '54       ', 'R DOUTOR AUGUSTO CARDOSO', 'JATIUCA                       ');
INSERT INTO cd_cep_br VALUES ('57.014-140', '54       ', 'R DOUTOR BALTAZAR DE MENDONCA', 'P GROSSA                      ');
INSERT INTO cd_cep_br VALUES ('57.071-840', '54       ', 'R DOIS DE MAIO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.071-730', '54       ', 'R DOIS IRMAOS', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.022-160', '54       ', 'PC DOIS LEOES', 'JARAGUA                       ');
INSERT INTO cd_cep_br VALUES ('57.045-360', '54       ', 'R DOM ADELMO MACHADO', 'B DURO                        ');
INSERT INTO cd_cep_br VALUES ('57.038-050', '54       ', 'CJ DOM ADELMO MACHADO', 'C ALMAS                       ');
INSERT INTO cd_cep_br VALUES ('57.014-070', '54       ', 'R DOM ADELMO MACHADO', 'P GROSSA                      ');
INSERT INTO cd_cep_br VALUES ('57.051-190', '54       ', 'AV DOM ANTONIO BRANDAO', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.042-410', '54       ', 'R DOM AVELAR BRANDAO VILELA', 'B DURO                        ');
INSERT INTO cd_cep_br VALUES ('57.020-130', '54       ', 'PC DOM PEDRO II', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.041-390', '54       ', 'R DOM RANULFO DE FARIAS', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.050-070', '54       ', 'R DOM SANTINO COUTINHO', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.051-200', '54       ', 'R DOM VITAL', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.030-260', '54       ', 'R DOMINGOS LORDSLEEN', 'PAJUCARA                      ');
INSERT INTO cd_cep_br VALUES ('57.072-720', '54       ', 'R DONA AFRA CAMELO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.030-270', '54       ', 'R DONA ALZIRA AGUIAR', 'PAJUCARA                      ');
INSERT INTO cd_cep_br VALUES ('57.052-330', '54       ', 'R DONA ANTONIA', 'G LOURDES                     ');
INSERT INTO cd_cep_br VALUES ('57.014-440', '54       ', 'R DONA AUREA CARVALHO', 'V LAGO                        ');
INSERT INTO cd_cep_br VALUES ('57.031-370', '54       ', 'R DONA CONSTANCA DE GOES MONTEIRO- ATE 672/673', 'POCO                          ');
INSERT INTO cd_cep_br VALUES ('57.036-370', '54       ', 'R DONA CONSTANCA DE GOES MONTEIRO- DE 674/675 AO', 'JATIUCA                       ');
INSERT INTO cd_cep_br VALUES ('57.025-605', '54       ', 'PC DONA CONSTANCIA DE GOES MONTEIRO', 'POCO                          ');
INSERT INTO cd_cep_br VALUES ('57.062-480', '54       ', 'R DONA CORALIA MOURA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.060-320', '54       ', 'R DONA CORDELIA VIANA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.060-050', '54       ', 'R DONA DONATTILA AYRES MOURA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.018-060', '54       ', 'R DONA ELZA MIRANDA VIANA', 'BEBEDOURO                     ');
INSERT INTO cd_cep_br VALUES ('57.075-240', '54       ', 'R DONA ISAURA SOUZA MARSIGLIA(RUA 24 CJ OSMAN LO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.075-250', '54       ', 'R DONA LOURDES BREDA(RUA A7 CJ OSMAN LOUREIRO)', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.060-280', '54       ', 'R DONA MARIA ADALGISA BASTOS', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.042-250', '54       ', 'R DONA MARIA ALVES DE MELO', 'FEITOSA                       ');
INSERT INTO cd_cep_br VALUES ('57.031-170', '54       ', 'R DONA MARIA AMELIA', 'POCO                          ');
INSERT INTO cd_cep_br VALUES ('57.042-280', '54       ', 'R DONA MARIA DE ARAUJO SANTOS', 'FEITOSA                       ');
INSERT INTO cd_cep_br VALUES ('57.061-210', '54       ', 'R DONA MARIA DE LOURDES BRANDAO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.080-540', '54       ', 'R DONA MARIA DO SOCORRO PONTES LIMA BOMFIM', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.071-250', '54       ', 'R DONA MARIA LUIZA ANDRE DA SILVA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.042-260', '54       ', 'R DONA MARIA LUIZA LYRA DURVAL', 'B VISTA                       ');
INSERT INTO cd_cep_br VALUES ('57.070-130', '54       ', 'R DONA MARIA MACHADO', 'F VELHO                       ');
INSERT INTO cd_cep_br VALUES ('57.050-130', '54       ', 'R DONA MARIETA LAGES', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.071-370', '54       ', 'R DONA MARIETA QUINTELA CAMPOS TEIXEIRA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.043-260', '54       ', 'R DONA MORENA', 'FEITOSA                       ');
INSERT INTO cd_cep_br VALUES ('57.036-500', '54       ', 'R DESPORTISTA CARLOS GONZAGA BREDA JUNIOR', 'JATIUCA                       ');
INSERT INTO cd_cep_br VALUES ('57.050-570', '54       ', 'PC DESPORTISTA CLAUDIO COUTINHO', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.072-090', '54       ', 'R DESPORTISTA CLAUDIO DA ROCHA LIMA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.035-620', '54       ', 'R DESPORTISTA CLAUDIO DA ROCHA LIMA', 'JATIUCA                       ');
INSERT INTO cd_cep_br VALUES ('57.072-250', '54       ', 'R DESPORTISTA FERNANDO LAMENHA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.072-770', '54       ', 'R DESPORTISTA HELIO MIRANDA (CJ EUSTAQUIO GOMES', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.035-030', '54       ', 'R DESPORTISTA HUMBERTO GUIMARAES', 'P VERDE                       ');
INSERT INTO cd_cep_br VALUES ('57.050-260', '54       ', 'R DESPORTISTA ORLANDO GOMES DE BARROS', 'PITANGUINHA                   ');
INSERT INTO cd_cep_br VALUES ('57.050-220', '54       ', 'R DEZ DE NOVEMBRO', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.039-590', '54       ', 'AV DEZENOVE DE SETEMBRO', 'F PEIXOTO                     ');
INSERT INTO cd_cep_br VALUES ('57.014-060', '54       ', 'R DEZESSEIS DE SETEMBRO', 'LEVADA                        ');
INSERT INTO cd_cep_br VALUES ('57.022-170', '54       ', 'PC DEZOITO DE COPACABANA', 'JARAGUA                       ');
INSERT INTO cd_cep_br VALUES ('57.030-770', '54       ', 'R DIAMANTINA MARQUES LUZ', 'POCO                          ');
INSERT INTO cd_cep_br VALUES ('57.040-270', '54       ', 'R DIANA', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.020-250', '54       ', 'R DIAS CABRAL', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.020-255', '54       ', 'TV DIAS CABRAL', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.043-255', '54       ', 'TV DIEGUES JUNIOR', 'FEITOSA                       ');
INSERT INTO cd_cep_br VALUES ('57.025-655', '54       ', 'TV DIEGUES JUNIOR', 'POCO                          ');
INSERT INTO cd_cep_br VALUES ('57.025-650', '54       ', 'R DIEGUES JUNIOR- ATE 941/942', 'POCO                          ');
INSERT INTO cd_cep_br VALUES ('57.043-250', '54       ', 'R DIEGUES JUNIOR- DE 943/944 AO FIM', 'FEITOSA                       ');
INSERT INTO cd_cep_br VALUES ('57.014-120', '54       ', 'R DIJORA SOARES DE OLIVEIRA(ANTIGA RUA VINTE E Q', 'P GROSSA                      ');
INSERT INTO cd_cep_br VALUES ('57.037-120', '54       ', 'R DILERMANDO REIS', 'MANGABEIRAS                   ');
INSERT INTO cd_cep_br VALUES ('57.081-420', '54       ', 'R DILERMANDO REIS', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.072-570', '54       ', 'R DIOCLECIO XAVIER ACCIOLY', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.083-260', '54       ', 'R DIONISIO ALVES PEIXOTO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.083-050', '54       ', 'R DIONISIO SILVA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.060-550', '54       ', 'R OITO DE ABRIL', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.020-650', '54       ', 'PC OLAVO BILAC', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.036-770', '54       ', 'R RAPHAEL PERRELLI', 'JATIUCA                       ');
INSERT INTO cd_cep_br VALUES ('57.061-360', '54       ', 'R RAUL AGUIAR', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.035-460', '54       ', 'R RAUL BARBOSA', 'JATIUCA                       ');
INSERT INTO cd_cep_br VALUES ('57.070-280', '54       ', 'TV SANTA QUITERIA', 'R NOVO                        ');
INSERT INTO cd_cep_br VALUES ('57.055-260', '54       ', 'R SANTA RITA', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.071-120', '54       ', 'R SANTA RITA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.042-530', '54       ', 'LOT SANTA RITA', 'B DURO                        ');
INSERT INTO cd_cep_br VALUES ('57.018-390', '54       ', 'R SANTA RITA', 'C JAQUEIRA                    ');
INSERT INTO cd_cep_br VALUES ('57.051-605', '54       ', 'PC SANTA RITA DE CASSIA', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.051-600', '54       ', 'AV SANTA RITA DE CASSIA', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.030-200', '54       ', 'R SAMPAIO MARQUES', 'PAJUCARA                      ');
INSERT INTO cd_cep_br VALUES ('57.045-160', '54       ', 'R SANTA AMALIA', 'B DURO                        ');
INSERT INTO cd_cep_br VALUES ('57.035-470', '54       ', 'TV SANTA AMALIA', 'JATIUCA                       ');
INSERT INTO cd_cep_br VALUES ('57.060-230', '54       ', 'R SANTA AMALIA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.015-360', '54       ', 'R SANTA AMELIA', 'V LAGO                        ');
INSERT INTO cd_cep_br VALUES ('57.063-030', '54       ', 'LOT SANTA AMELIA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.018-335', '54       ', 'VL SANTA ANA', 'BEBEDOURO                     ');
INSERT INTO cd_cep_br VALUES ('57.040-280', '54       ', 'R SANTA ANA', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.040-285', '54       ', 'TV SANTA ANA', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.025-390', '54       ', 'R SANTA ANA', 'POCO                          ');
INSERT INTO cd_cep_br VALUES ('57.046-430', '54       ', 'LOT SANTA ANA', 'B DURO                        ');
INSERT INTO cd_cep_br VALUES ('57.046-730', '54       ', 'R SANTA ANA', 'B DURO                        ');
INSERT INTO cd_cep_br VALUES ('57.031-510', '54       ', 'R SANTA ANA', 'MANGABEIRAS                   ');
INSERT INTO cd_cep_br VALUES ('57.043-550', '54       ', 'R SANTA APARECIDA', 'FEITOSA                       ');
INSERT INTO cd_cep_br VALUES ('57.014-370', '54       ', 'R SANTA CATARINA', 'P GROSSA                      ');
INSERT INTO cd_cep_br VALUES ('57.060-600', '54       ', 'R SANTA CATARINA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.060-605', '54       ', 'TV SANTA CATARINA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.030-410', '54       ', 'R SANTA CECILIA', 'P TERRA                       ');
INSERT INTO cd_cep_br VALUES ('57.037-130', '54       ', 'CJ SANTA CECILIA', 'JATIUCA                       ');
INSERT INTO cd_cep_br VALUES ('57.018-445', '54       ', 'R SANTA CLARA', 'C JAQUEIRA                    ');
INSERT INTO cd_cep_br VALUES ('57.010-190', '54       ', 'LRG SANTA CRUZ', 'T BARRA                       ');
INSERT INTO cd_cep_br VALUES ('57.051-590', '54       ', 'R SANTA CRUZ', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.015-580', '54       ', 'R SANTA FE', 'P GROSSA                      ');
INSERT INTO cd_cep_br VALUES ('57.040-850', '54       ', 'R SANTA FE', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.035-390', '54       ', 'R SANTA FERNANDA', 'JATIUCA                       ');
INSERT INTO cd_cep_br VALUES ('57.035-395', '54       ', 'TV SANTA FERNANDA', 'JATIUCA                       ');
INSERT INTO cd_cep_br VALUES ('57.018-600', '54       ', 'R SANTA HELENA', 'C JAQUEIRA                    ');
INSERT INTO cd_cep_br VALUES ('57.010-450', '54       ', 'R SANTA HELENA', 'P BARRA                       ');
INSERT INTO cd_cep_br VALUES ('57.045-310', '54       ', 'R SANTA ISABEL', 'B DURO                        ');
INSERT INTO cd_cep_br VALUES ('57.045-315', '54       ', 'TV SANTA ISABEL', 'B DURO                        ');
INSERT INTO cd_cep_br VALUES ('57.040-390', '54       ', 'R SANTA ISABEL', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.015-160', '54       ', 'R SANTA ISABEL', 'P GROSSA                      ');
INSERT INTO cd_cep_br VALUES ('57.030-330', '54       ', 'R SANTA ISABEL', 'PAJUCARA                      ');
INSERT INTO cd_cep_br VALUES ('57.071-310', '54       ', 'R SANTA ISABEL', 'A S DUMONT                    ');
INSERT INTO cd_cep_br VALUES ('57.030-335', '54       ', 'TV SANTA ISABEL', 'PAJUCARA                      ');
INSERT INTO cd_cep_br VALUES ('57.039-290', '54       ', 'R SANTA JOANA', 'R DOCE                        ');
INSERT INTO cd_cep_br VALUES ('57.055-560', '54       ', 'R SANTA JULIA', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.022-260', '54       ', 'R SANTA LEOPOLDINA', 'JARAGUA                       ');
INSERT INTO cd_cep_br VALUES ('57.038-160', '54       ', 'R RODOLFO ABREU', 'C ALMAS                       ');
INSERT INTO cd_cep_br VALUES ('57.050-650', '54       ', 'R RODRIGO ACIOLE MOTA', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.022-250', '54       ', 'TV RODRIGUES ALVES', 'JARAGUA                       ');
INSERT INTO cd_cep_br VALUES ('57.011-140', '54       ', 'R RODRIGUES ALVES', 'PRADO                         ');
INSERT INTO cd_cep_br VALUES ('57.042-420', '54       ', 'R ROGERIO MACHADO FERRO', 'B VISTA                       ');
INSERT INTO cd_cep_br VALUES ('57.072-630', '54       ', 'R ROLDAO DE SIQUEIRA FONTES', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.042-490', '54       ', 'R ROMEU COSTA LIMA', 'B VISTA                       ');
INSERT INTO cd_cep_br VALUES ('57.082-070', '54       ', 'R ROMEU DE AVELAR', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.052-540', '54       ', 'R ROMEU DE AVELAR', 'G LOURDES                     ');
INSERT INTO cd_cep_br VALUES ('57.060-680', '54       ', 'R RONALDO BARBOSA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.071-585', '54       ', 'R ROSA CRUZ', 'A S DUMONT                    ');
INSERT INTO cd_cep_br VALUES ('57.018-750', '54       ', 'R ROSA RAMALHO FONTES LIMA', 'C JAQUEIRA                    ');
INSERT INTO cd_cep_br VALUES ('57.073-590', '54       ', 'R ROSA VITERBIANA DE LIMA(LOTEAMENTO SIMOL)', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.043-360', '54       ', 'R ROSALIA SANDOVAL', 'FEITOSA                       ');
INSERT INTO cd_cep_br VALUES ('57.045-015', '54       ', 'R ROSALVA LESSA CABRAL(LOT IGUACU)', 'B DURO                        ');
INSERT INTO cd_cep_br VALUES ('57.071-260', '54       ', 'AV ROSALVO BORGES DA SILVA', 'A S DUMONT                    ');
INSERT INTO cd_cep_br VALUES ('57.072-020', '54       ', 'R ROSALVO LIMA DOS SANTOS', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.055-550', '54       ', 'R ROSALVO PRATA', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.051-570', '54       ', 'PC ROSALVO RIBEIRO', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.071-470', '54       ', 'CJ ROSANE COLLOR', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.050-480', '54       ', 'AV ROTARY', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.010-120', '54       ', 'R RUBELINA ALVES DE LIMA', 'T BARRA                       ');
INSERT INTO cd_cep_br VALUES ('57.017-230', '54       ', 'R RUI PALMEIRA', 'B PARTO                       ');
INSERT INTO cd_cep_br VALUES ('57.030-620', '54       ', 'R RUTHE REIS', 'PAJUCARA                      ');
INSERT INTO cd_cep_br VALUES ('57.060-580', '54       ', 'R RUY BINAS', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.022-180', '54       ', 'R SA E ALBUQUERQUE', 'JARAGUA                       ');
INSERT INTO cd_cep_br VALUES ('57.060-590', '54       ', 'R SABINO CARDOSO DE ARAUJO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.017-480', '54       ', 'R SABINO ROMARIZ', 'BEBEDOURO                     ');
INSERT INTO cd_cep_br VALUES ('57.040-690', '54       ', 'R SAO DOMINGOS', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.040-695', '54       ', 'TV SAO DOMINGOS', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.050-350', '54       ', 'R SAO DOMINGOS', 'PITANGUINHA                   ');
INSERT INTO cd_cep_br VALUES ('57.071-620', '54       ', 'R SAO DOMINGOS', 'A S DUMONT                    ');
INSERT INTO cd_cep_br VALUES ('57.015-180', '54       ', 'R SANTA ROSA', 'P GROSSA                      ');
INSERT INTO cd_cep_br VALUES ('57.071-045', '54       ', 'R SANTA ROSA', 'A S DUMONT                    ');
INSERT INTO cd_cep_br VALUES ('57.035-480', '54       ', 'R SANTA SOFIA', 'JATIUCA                       ');
INSERT INTO cd_cep_br VALUES ('57.035-485', '54       ', 'TV SANTA SOFIA', 'JATIUCA                       ');
INSERT INTO cd_cep_br VALUES ('57.030-440', '54       ', 'R SANTA SOFIA', 'PAJUCARA                      ');
INSERT INTO cd_cep_br VALUES ('57.045-320', '54       ', 'R SANTA TEREZINHA', 'B DURO                        ');
INSERT INTO cd_cep_br VALUES ('57.043-430', '54       ', 'R SANTA TEREZINHA', 'FEITOSA                       ');
INSERT INTO cd_cep_br VALUES ('57.040-680', '54       ', 'R SANTA TEREZINHA', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.071-420', '54       ', 'R SANTA TEREZINHA', 'A S DUMONT                    ');
INSERT INTO cd_cep_br VALUES ('57.047-100', '54       ', 'LOT SANTA TEREZINHA', 'SERRARIA                      ');
INSERT INTO cd_cep_br VALUES ('57.082-020', '54       ', 'R SANTANA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.038-480', '54       ', 'AV SANTANA DO IPANEMA', 'C ALMAS                       ');
INSERT INTO cd_cep_br VALUES ('57.018-170', '54       ', 'R SANTO AMARO', 'BEBEDOURO                     ');
INSERT INTO cd_cep_br VALUES ('57.061-370', '54       ', 'R SANTO AMARO', 'CANAA                         ');
INSERT INTO cd_cep_br VALUES ('57.061-375', '54       ', 'TV SANTO AMARO', 'CANAA                         ');
INSERT INTO cd_cep_br VALUES ('57.055-570', '54       ', 'R SANTO AMARO', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.040-760', '54       ', 'R SANTO AMARO', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.035-490', '54       ', 'TV SANTO AMARO', 'JATIUCA                       ');
INSERT INTO cd_cep_br VALUES ('57.071-180', '54       ', 'R SANTO AMARO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.018-175', '54       ', 'TV SANTO AMARO', 'BEBEDOURO                     ');
INSERT INTO cd_cep_br VALUES ('57.061-460', '54       ', 'AV SANTO AMARO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.039-450', '54       ', 'R SANTO AMARO', 'R DOCE                        ');
INSERT INTO cd_cep_br VALUES ('57.017-525', '54       ', 'R SANTO AMARO', 'B PARTO                       ');
INSERT INTO cd_cep_br VALUES ('57.018-400', '54       ', 'R SANTO ANDRE', 'C JAQUEIRA                    ');
INSERT INTO cd_cep_br VALUES ('57.040-790', '54       ', 'R SANTO ANDRE', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.040-795', '54       ', 'TV SANTO ANDRE', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.045-190', '54       ', 'R SANTO ANTONIO', 'B DURO                        ');
INSERT INTO cd_cep_br VALUES ('69.055-745', '156      ', 'R 06 (CJ TROPICAL)', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.055-520', '156      ', 'R 34 (CJ C BRANCO)', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.097-777', '156      ', 'R 34 (CJ F MENDES I)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.044-250', '156      ', 'R 34 (CJ JD VERSALLES)', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('69.093-730', '156      ', 'R 34 (CJ MANOA)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.077-330', '156      ', 'R 34 (CJ 31 DE MARCO I)', 'JAPIIM                        ');
INSERT INTO cd_cep_br VALUES ('69.094-340', '156      ', 'R 34 (NUCLEO 3)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.099-160', '156      ', 'R 35 (A MENDES)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.038-620', '156      ', 'R 35 (CJ A MONTENEGRO)', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('69.055-530', '156      ', 'R 35 (CJ C BRANCO)', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.044-270', '156      ', 'R 35 (CJ JD VERSALLES)', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('69.097-680', '156      ', 'R 266 (NUCLEO 23)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.097-690', '156      ', 'R 267 (NUCLEO 23)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.097-700', '156      ', 'R 268 (NUCLEO 23)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.097-710', '156      ', 'R 269 (NUCLEO 23)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.086-280', '156      ', 'R 27', 'S J OPERARIO                  ');
INSERT INTO cd_cep_br VALUES ('69.099-110', '156      ', 'R 27 (A MENDES)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.097-756', '156      ', 'R 27 (CJ A MEDEIROS)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.038-540', '156      ', 'R 27 (CJ A MONTENEGRO)', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('69.055-450', '156      ', 'R 27 (CJ C BRANCO)', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.044-740', '156      ', 'R 27 (CJ JD VERSALLES)', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('69.093-660', '156      ', 'R 27 (CJ MANOA)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.077-280', '156      ', 'R 27 (CJ 31 DE MARCO I)', 'JAPIIM                        ');
INSERT INTO cd_cep_br VALUES ('69.094-270', '156      ', 'R 27 (NUCLEO 3)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.086-290', '156      ', 'R 28', 'S J OPERARIO                  ');
INSERT INTO cd_cep_br VALUES ('69.099-460', '156      ', 'R 28 (A MENDES)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.038-550', '156      ', 'R 28 (CJ A MONTENEGRO)', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('69.055-460', '156      ', 'R 28 (CJ C BRANCO)', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.097-101', '156      ', 'R 28 (CJ CANARANAS)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.044-750', '156      ', 'R 28 (CJ JD VERSALLES)', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('69.093-670', '156      ', 'R 28 (CJ MANOA)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.095-509', '156      ', 'R 28 (CJ O FROTA I)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.077-290', '156      ', 'R 28 (CJ 31 DE MARCO I)', 'JAPIIM                        ');
INSERT INTO cd_cep_br VALUES ('69.094-280', '156      ', 'R 28 (NUCLEO 3)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.086-291', '156      ', 'R 28 A', 'S J OPERARIO                  ');
INSERT INTO cd_cep_br VALUES ('69.086-281', '156      ', 'R 29', 'S J OPERARIO                  ');
INSERT INTO cd_cep_br VALUES ('69.099-120', '156      ', 'R 29 (A MENDES)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.097-757', '156      ', 'R 29 (CJ A MEDEIROS)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.038-560', '156      ', 'R 29 (CJ A MONTENEGRO)', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('69.055-470', '156      ', 'R 29 (CJ C BRANCO)', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.044-760', '156      ', 'R 29 (CJ JD VERSALLES)', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('69.093-680', '156      ', 'R 29 (CJ MANOA)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.077-300', '156      ', 'R 29 (CJ 31 DE MARCO I)', 'JAPIIM                        ');
INSERT INTO cd_cep_br VALUES ('69.094-290', '156      ', 'R 29 (NUCLEO 3)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.099-020', '156      ', 'R 3 (A MENDES)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.099-470', '156      ', 'R 30 (A MENDES)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.038-570', '156      ', 'R 30 (CJ A MONTENEGRO)', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('69.055-480', '156      ', 'R 30 (CJ C BRANCO)', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.097-776', '156      ', 'R 30 (CJ F MENDES I)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.097-500', '156      ', 'R 248 (NUCLEO 23)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.097-510', '156      ', 'R 249 (NUCLEO 23)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.086-260', '156      ', 'R 25', 'S J OPERARIO                  ');
INSERT INTO cd_cep_br VALUES ('69.099-440', '156      ', 'R 25 (A MENDES)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.097-755', '156      ', 'R 25 (CJ A MEDEIROS)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.038-520', '156      ', 'R 25 (CJ A MONTENEGRO)', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('69.055-430', '156      ', 'R 25 (CJ C BRANCO)', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.049-590', '156      ', 'R 25 (CJ HILEIA II)', 'REDENCAO                      ');
INSERT INTO cd_cep_br VALUES ('69.044-720', '156      ', 'R 25 (CJ JD VERSALLES', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('69.093-640', '156      ', 'R 25 (CJ MANOA)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.077-260', '156      ', 'R 25 (CJ 31 DE MARCO I)', 'JAPIIM                        ');
INSERT INTO cd_cep_br VALUES ('69.094-250', '156      ', 'R 25 (NUCLEO 3)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.097-520', '156      ', 'R 250 (NUCLEO 23)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.097-530', '156      ', 'R 251 (NUCLEO 23)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.097-540', '156      ', 'R 252 (NUCLEO 23)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.097-550', '156      ', 'R 253 (NUCLEO 23)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.097-560', '156      ', 'R 254 (NUCLEO 23)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.097-570', '156      ', 'R 255 (NUCLEO 23)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.097-580', '156      ', 'R 256 (NUCLEO 23)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.097-590', '156      ', 'R 257 (NUCLEO 23)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.033-142', '156      ', 'BC 258', 'S JORGE                       ');
INSERT INTO cd_cep_br VALUES ('69.097-600', '156      ', 'R 258 (NUCLEO 23)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.097-610', '156      ', 'R 259 (NUCLEO 23)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.086-270', '156      ', 'R 26', 'S J OPERARIO                  ');
INSERT INTO cd_cep_br VALUES ('69.099-450', '156      ', 'R 26 (A MENDES)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.038-530', '156      ', 'R 26 (CJ A MONTENEGRO)', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('69.055-440', '156      ', 'R 26 (CJ C BRANCO)', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.044-730', '156      ', 'R 26 (CJ JD VERSALLES)', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('69.093-650', '156      ', 'R 26 (CJ MANOA)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.095-508', '156      ', 'R 26 (CJ O FROTA I)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.077-270', '156      ', 'R 26 (CJ 31 DE MARCO I)', 'JAPIIM                        ');
INSERT INTO cd_cep_br VALUES ('69.094-260', '156      ', 'R 26 (NUCLEO 3)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.097-620', '156      ', 'R 260 (NUCLEO 23)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.097-630', '156      ', 'R 261 (NUCLEO 23)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.097-640', '156      ', 'R 262 (NUCLEO 23)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.097-650', '156      ', 'R 263 (NUCLEO 23)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.097-660', '156      ', 'R 264 (NUCLEO 23)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.097-670', '156      ', 'R 265 (NUCLEO 23)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.097-754', '156      ', 'R 23 (CJ A MEDEIROS)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.038-500', '156      ', 'R 23 (CJ A MONTENEGRO)', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('69.055-410', '156      ', 'R 23 (CJ C BRANCO)', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.083-660', '156      ', 'R 23 (CJ C DO ALEIXO)', 'S J OPERARIO                  ');
INSERT INTO cd_cep_br VALUES ('69.049-570', '156      ', 'R 23 (CJ HILEIA II)', 'REDENCAO                      ');
INSERT INTO cd_cep_br VALUES ('69.044-700', '156      ', 'R 23 (CJ JD VERSALLES)', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('69.093-620', '156      ', 'R 23 (CJ MANOA)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.077-240', '156      ', 'R 23 (CJ 31 DE MARCO I)', 'JAPIIM                        ');
INSERT INTO cd_cep_br VALUES ('69.094-230', '156      ', 'R 23 (NUCLEO 3)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.096-750', '156      ', 'R 230 (NUCLEO 21)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.096-760', '156      ', 'R 231 (NUCLEO 21)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.096-770', '156      ', 'R 232 (NUCLEO 21)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.096-780', '156      ', 'R 233 (NUCLEO 21)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.096-790', '156      ', 'R 234 (NUCLEO 21)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.096-800', '156      ', 'R 235 (NUCLEO 21)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.096-810', '156      ', 'R 236 (NUCLEO 21)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.097-766', '156      ', 'R 75 (CJ S PESSOA)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.094-570', '156      ', 'R 75 (NUCLEO 4)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.099-650', '156      ', 'R 76', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('57.607-470', '40       ', 'R SILVANO ARAUJO', 'S CRISTOVAO                   ');
INSERT INTO cd_cep_br VALUES ('57.606-013', '40       ', 'R SONHO VERDE', 'EUCALIPTOS                    ');
INSERT INTO cd_cep_br VALUES ('57.606-004', '40       ', 'TV SONHO VERDE', 'EUCALIPTOS                    ');
INSERT INTO cd_cep_br VALUES ('57.603-220', '40       ', 'R TABELIAO LUIZ DE BARROS', 'J SAMPAIO                     ');
INSERT INTO cd_cep_br VALUES ('57.603-090', '40       ', 'R TABELIAO LUIZ VIEIRA DE BARROS', 'S CRISTOVAO                   ');
INSERT INTO cd_cep_br VALUES ('57.606-015', '40       ', 'R TAXISTA JOAO FERREIRA DA COSTA', 'EUCALIPTOS                    ');
INSERT INTO cd_cep_br VALUES ('57.607-230', '40       ', 'R TENENTE JULIO AMORIM', 'VL MARIA                      ');
INSERT INTO cd_cep_br VALUES ('57.606-009', '40       ', 'R TENENTE JULIO AMORIM', 'EUCALIPTOS                    ');
INSERT INTO cd_cep_br VALUES ('57.600-590', '40       ', 'R TENORIO CAVALCANTE', 'VL NOVA                       ');
INSERT INTO cd_cep_br VALUES ('57.605-180', '40       ', 'R TEODORICO COSTA', 'S FRANCISCO                   ');
INSERT INTO cd_cep_br VALUES ('57.602-240', '40       ', 'R TERTULIANO CANUTO', 'S FRANCISCO                   ');
INSERT INTO cd_cep_br VALUES ('57.600-020', '40       ', 'R TOBIAS COSTA', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.600-320', '40       ', 'R TREZE DE MAIO', 'AT CRUZEIRO                   ');
INSERT INTO cd_cep_br VALUES ('57.600-630', '40       ', 'R ULISSES TENORIO CAVALCANTE', 'VL NOVA                       ');
INSERT INTO cd_cep_br VALUES ('57.602-370', '40       ', 'R VALDEMAR HOLANDA CAVALCANTERUA PROJETADA LOT J', 'S FRANCISCO                   ');
INSERT INTO cd_cep_br VALUES ('57.606-016', '40       ', 'R VASCONCELOS', 'EUCALIPTOS                    ');
INSERT INTO cd_cep_br VALUES ('57.605-100', '40       ', 'R VEREADOR ELOI BARBOSA', 'S FRANCISCO                   ');
INSERT INTO cd_cep_br VALUES ('69.028-345', '156      ', 'TV 07', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('57.600-450', '40       ', 'R VEREADOR MARIO LEITE', 'T CAVALCANTE                  ');
INSERT INTO cd_cep_br VALUES ('57.600-080', '40       ', 'R VEREADOR NILO BARROS', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.602-330', '40       ', 'R VEREADOR ZECA PAULO', 'S FRANCISCO                   ');
INSERT INTO cd_cep_br VALUES ('57.607-040', '40       ', 'R PARA', 'JD BRASIL                     ');
INSERT INTO cd_cep_br VALUES ('57.607-100', '40       ', 'R PARAIBA', 'JD BRASIL                     ');
INSERT INTO cd_cep_br VALUES ('57.607-270', '40       ', 'R PAZ, DA', 'VL MARIA                      ');
INSERT INTO cd_cep_br VALUES ('57.601-080', '40       ', 'R PEDRO BARBOSA', 'S CRISTOVAO                   ');
INSERT INTO cd_cep_br VALUES ('57.601-085', '40       ', 'TV PEDRO BARBOSA', 'S CRISTOVAO                   ');
INSERT INTO cd_cep_br VALUES ('57.602-060', '40       ', 'R PEDRO CARNAUBA', 'PARAISO                       ');
INSERT INTO cd_cep_br VALUES ('57.605-110', '40       ', 'R PEDRO GAIA', 'S FRANCISCO                   ');
INSERT INTO cd_cep_br VALUES ('57.601-270', '40       ', 'R PEDRO SOARES DA MOTA', 'S CRISTOVAO                   ');
INSERT INTO cd_cep_br VALUES ('57.601-440', '40       ', 'CJ PEDRO SURUAGY', 'P FORA                        ');
INSERT INTO cd_cep_br VALUES ('57.607-600', '40       ', 'R PEDRO TARGINO', 'VL MARIA                      ');
INSERT INTO cd_cep_br VALUES ('57.601-130', '40       ', 'R PROFESSORA LOURDES BARRETO', 'S CRISTOVAO                   ');
INSERT INTO cd_cep_br VALUES ('57.601-090', '40       ', 'R QUINZE DE NOVEMBRO', 'S CRISTOVAO                   ');
INSERT INTO cd_cep_br VALUES ('57.603-200', '40       ', 'R RADIALISTA ANTONIO MARTINS', 'J SAMPAIO                     ');
INSERT INTO cd_cep_br VALUES ('57.607-370', '40       ', 'R RAIMUNDO DE ASSIS MAIA', 'S CRISTOVAO                   ');
INSERT INTO cd_cep_br VALUES ('57.602-320', '40       ', 'R RAIMUNDO ROQUE', 'S FRANCISCO                   ');
INSERT INTO cd_cep_br VALUES ('57.607-150', '40       ', 'R RIO DE JANEIRO', 'JD BRASIL                     ');
INSERT INTO cd_cep_br VALUES ('57.607-090', '40       ', 'R RIO GRANDE DO NORTE', 'JD BRASIL                     ');
INSERT INTO cd_cep_br VALUES ('57.607-190', '40       ', 'R RIO GRANDE DO SUL', 'JD BRASIL                     ');
INSERT INTO cd_cep_br VALUES ('57.602-090', '40       ', 'R ROSALVO DAMIAO', 'PARAISO                       ');
INSERT INTO cd_cep_br VALUES ('57.600-540', '40       ', 'PC ROSARIO', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.607-330', '40       ', 'R ROSENDO RODRIGUES', 'S CRISTOVAO                   ');
INSERT INTO cd_cep_br VALUES ('57.606-001', '40       ', 'R ROSIVAN DAS NEVES', 'EUCALIPTOS                    ');
INSERT INTO cd_cep_br VALUES ('57.607-620', '40       ', 'PC ROZENDO DE OLIVEIRA', 'VL MARIA                      ');
INSERT INTO cd_cep_br VALUES ('57.601-350', '40       ', 'AV SALU BRANCO', 'S CRISTOVAO                   ');
INSERT INTO cd_cep_br VALUES ('57.607-160', '40       ', 'R SANTA CATARINA', 'JD BRASIL                     ');
INSERT INTO cd_cep_br VALUES ('57.600-240', '40       ', 'R MANOEL GOMES DA SILVA', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.605-020', '40       ', 'R MANOEL HIGINO DA COSTA', 'S FRANCISCO                   ');
INSERT INTO cd_cep_br VALUES ('57.607-590', '40       ', 'R MANOEL LEANDRO DA SILVA', 'VL MARIA                      ');
INSERT INTO cd_cep_br VALUES ('57.602-050', '40       ', 'R MANOEL ORIGENES DE OLIVEIRA', 'PARAISO                       ');
INSERT INTO cd_cep_br VALUES ('57.601-550', '40       ', 'PC MANOEL PEREIRA DA SILVA (RUFINO)', 'P FORA                        ');
INSERT INTO cd_cep_br VALUES ('57.601-340', '40       ', 'R MANOEL RODRIGUES DE QUEIROZ', 'S CRISTOVAO                   ');
INSERT INTO cd_cep_br VALUES ('57.607-060', '40       ', 'R MARANHAO', 'JD BRASIL                     ');
INSERT INTO cd_cep_br VALUES ('57.600-260', '40       ', 'R MARCAL DE OLIVEIRA', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.600-060', '40       ', 'R MARECHAL DEODORO DA FONSECA', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.601-110', '40       ', 'R MARIA AUXILIADORA', 'S CRISTOVAO                   ');
INSERT INTO cd_cep_br VALUES ('57.601-070', '40       ', 'R MARIANO DE FREITAS', 'S CRISTOVAO                   ');
INSERT INTO cd_cep_br VALUES ('57.600-510', '40       ', 'R MARUJO FERREIRA DE CASTRO', 'VL NOVA                       ');
INSERT INTO cd_cep_br VALUES ('57.607-180', '40       ', 'R MATO GROSSO', 'JD BRASIL                     ');
INSERT INTO cd_cep_br VALUES ('57.602-210', '40       ', 'R MESTRE ANTONIO DOS SANTOS', 'S FRANCISCO                   ');
INSERT INTO cd_cep_br VALUES ('57.602-220', '40       ', 'R MESTRE JAU', 'S FRANCISCO                   ');
INSERT INTO cd_cep_br VALUES ('57.601-050', '40       ', 'R MIGUEL MONTEIRO', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.603-150', '40       ', 'PC MOISES PEREIRA DO NASCIMENTO', 'PARAISO                       ');
INSERT INTO cd_cep_br VALUES ('57.601-530', '40       ', 'AV MONSENHOR FERREIRA', 'P FORA                        ');
INSERT INTO cd_cep_br VALUES ('57.600-520', '40       ', 'PC MONSENHOR MACEDO', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.600-100', '40       ', 'R MOREIRA E SILVA', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.601-240', '40       ', 'PC MORENO BRANDAO', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.603-190', '40       ', 'EST MULUNGU', 'S FRANCISCO                   ');
INSERT INTO cd_cep_br VALUES ('57.603-000', '40       ', 'AV MUNIZ FALCAO- ATE 1000/1119', 'S FRANCISCO                   ');
INSERT INTO cd_cep_br VALUES ('57.605-000', '40       ', 'AV MUNIZ FALCAO- DE 1001/1120 AO FIM', 'S FRANCISCO                   ');
INSERT INTO cd_cep_br VALUES ('57.607-350', '40       ', 'R NAIR RODRIGUES', 'S CRISTOVAO                   ');
INSERT INTO cd_cep_br VALUES ('57.601-540', '40       ', 'R NARCISO FERREIRA FRANCA', 'P FORA                        ');
INSERT INTO cd_cep_br VALUES ('57.601-420', '40       ', 'R NECO BARBOSA', 'S CRISTOVAO                   ');
INSERT INTO cd_cep_br VALUES ('57.601-210', '40       ', 'PC NILO TORRES', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.607-570', '40       ', 'R NOSSA SENHORA DO AMPARO', 'VL MARIA                      ');
INSERT INTO cd_cep_br VALUES ('57.607-560', '40       ', 'R NOVA JERUZALEM', 'S CRISTOVAO                   ');
INSERT INTO cd_cep_br VALUES ('57.602-100', '40       ', 'R OSEAS LINS', 'PARAISO                       ');
INSERT INTO cd_cep_br VALUES ('57.605-010', '40       ', 'R OSORIO HORACIO', 'S FRANCISCO                   ');
INSERT INTO cd_cep_br VALUES ('57.607-540', '40       ', 'R OTAVIO BARBOSA', 'S CRISTOVAO                   ');
INSERT INTO cd_cep_br VALUES ('57.600-070', '40       ', 'R OTAVIO CAVALCANTE', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.607-450', '40       ', 'R PADRE ANTONIO LIMA', 'S CRISTOVAO                   ');
INSERT INTO cd_cep_br VALUES ('57.607-260', '40       ', 'R PADRE CICERO', 'VL MARIA                      ');
INSERT INTO cd_cep_br VALUES ('57.606-012', '40       ', 'R PADRE CICERO', 'EUCALIPTOS                    ');
INSERT INTO cd_cep_br VALUES ('57.600-250', '40       ', 'R PADRE DIMAS', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.602-140', '40       ', 'R JOSE AMARAL', 'PARAISO                       ');
INSERT INTO cd_cep_br VALUES ('57.600-600', '40       ', 'R JOSE BALBINO', 'VL NOVA                       ');
INSERT INTO cd_cep_br VALUES ('57.600-300', '40       ', 'R JOSE CAETANO DE MORAIS', 'AT CRUZEIRO                   ');
INSERT INTO cd_cep_br VALUES ('57.600-650', '40       ', 'TV JOSE CAETANO DE MORAIS', 'AT CRUZEIRO                   ');
INSERT INTO cd_cep_br VALUES ('57.603-160', '40       ', 'R JOSE CANUTO DA GAMA', 'S CRISTOVAO                   ');
INSERT INTO cd_cep_br VALUES ('57.600-230', '40       ', 'R JOSE DE FREITAS SILVA', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('69.038-277', '156      ', 'R 07', 'L VALE                        ');
INSERT INTO cd_cep_br VALUES ('57.600-530', '40       ', 'TV JOSE DIAS DE OLIVEIRA', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.602-290', '40       ', 'R JOSE HONORIO', 'S FRANCISCO                   ');
INSERT INTO cd_cep_br VALUES ('57.601-510', '40       ', 'R JOSE JOAQUIM DE OLIVEIRA', 'S CRISTOVAO                   ');
INSERT INTO cd_cep_br VALUES ('57.602-260', '40       ', 'R JOSE JULIAO MELO', 'S FRANCISCO                   ');
INSERT INTO cd_cep_br VALUES ('57.605-090', '40       ', 'R JOSE LEITE COSTA', 'S FRANCISCO                   ');
INSERT INTO cd_cep_br VALUES ('57.602-070', '40       ', 'R JOSE MAIA', 'PARAISO                       ');
INSERT INTO cd_cep_br VALUES ('57.600-030', '40       ', 'R JOSE MARIA PASSOS', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.600-610', '40       ', 'R JOSE MARQUES', 'VL NOVA                       ');
INSERT INTO cd_cep_br VALUES ('57.600-290', '40       ', 'R JOSE MENDES FERREIRA', 'AT CRUZEIRO                   ');
INSERT INTO cd_cep_br VALUES ('57.601-280', '40       ', 'R JOSE MIGUEL PEREIRA', 'S CRISTOVAO                   ');
INSERT INTO cd_cep_br VALUES ('69.044-490', '156      ', 'R 02 (CJ JD VERSALLES)', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('69.099-340', '156      ', 'R 62 (A MENDES)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.097-128', '156      ', 'R 62 (CJ F MENDES II)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('57.036-830', '54       ', 'R OLAVO MACEDO RIBEIRO', 'JATIUCA                       ');
INSERT INTO cd_cep_br VALUES ('57.031-210', '54       ', 'PC OLGA BENARIO PRESTES', 'POCO                          ');
INSERT INTO cd_cep_br VALUES ('57.035-560', '54       ', 'AV PIO XII', 'JATIUCA                       ');
INSERT INTO cd_cep_br VALUES ('57.011-120', '54       ', 'R PIO XII', 'T BARRA                       ');
INSERT INTO cd_cep_br VALUES ('57.035-310', '54       ', 'CJ PIO XII', 'JATIUCA                       ');
INSERT INTO cd_cep_br VALUES ('57.020-270', '54       ', 'PC PIRULITO, DO', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.085-110', '54       ', 'R PLANALTO SANTA MARTA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.075-360', '54       ', 'R PLINIUS AYRIS(RUA 19 CJ OSMAN LOUREIRO)', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.039-640', '54       ', 'R POCO, DO', 'F PEIXOTO                     ');
INSERT INTO cd_cep_br VALUES ('57.080-310', '54       ', 'R POETA ALVES DE AMORIM', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.031-230', '54       ', 'R POETA LOURIVAL PASSOS', 'POCO                          ');
INSERT INTO cd_cep_br VALUES ('57.071-010', '54       ', 'AV POETA LUIZ GONZAGA BARROSO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.037-230', '54       ', 'R POMPILIO BRANDAO', 'JATIUCA                       ');
INSERT INTO cd_cep_br VALUES ('57.082-400', '54       ', 'LOT POR DO SOL', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.082-540', '54       ', 'CJ POR DO SOL', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.055-130', '54       ', 'R PORTO ALEGRE', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.038-450', '54       ', 'R PORTO CALVO', 'C ALMAS                       ');
INSERT INTO cd_cep_br VALUES ('57.080-090', '54       ', 'R PORTO CALVO', 'CANAA                         ');
INSERT INTO cd_cep_br VALUES ('57.014-200', '54       ', 'R PORTO CALVO', 'P GROSSA                      ');
INSERT INTO cd_cep_br VALUES ('57.030-600', '54       ', 'R POTIGUAR', 'POCO                          ');
INSERT INTO cd_cep_br VALUES ('57.020-680', '54       ', 'R PRAIA, DA', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.060-330', '54       ', 'R PAULO ROBERTO SANTOS', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.014-340', '54       ', 'R PAYSSANDU', 'P GROSSA                      ');
INSERT INTO cd_cep_br VALUES ('57.071-295', '54       ', 'R PAZ BRASILEIRO', 'A S DUMONT                    ');
INSERT INTO cd_cep_br VALUES ('57.047-070', '54       ', 'AL PAZ DA(LOTEAMENTO MORADA NOVA)', 'B DURO                        ');
INSERT INTO cd_cep_br VALUES ('57.070-250', '54       ', 'TV PAZ, DA', 'R NOVO                        ');
INSERT INTO cd_cep_br VALUES ('57.060-560', '54       ', 'R PAZ, DA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.062-690', '54       ', 'R PAZ, DA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.085-140', '54       ', 'R PAZ, DA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.071-695', '54       ', 'R PAZ, DA', 'A S DUMONT                    ');
INSERT INTO cd_cep_br VALUES ('57.062-700', '54       ', 'TV PAZ, DA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.022-050', '54       ', 'AV PAZ, DA- ATE 1250', 'JARAGUA                       ');
INSERT INTO cd_cep_br VALUES ('57.020-440', '54       ', 'AV PAZ, DA- DE 1252 AO FIM', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.031-220', '54       ', 'R PEDRO ALCANTARA MARANHAO', 'POCO                          ');
INSERT INTO cd_cep_br VALUES ('57.071-515', '54       ', 'R PEDRO ALVARES CABRAL', 'A S DUMONT                    ');
INSERT INTO cd_cep_br VALUES ('57.060-570', '54       ', 'R PEDRO ALVES FERNANDES', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.030-580', '54       ', 'R PEDRO AMERICO', 'POCO                          ');
INSERT INTO cd_cep_br VALUES ('57.030-585', '54       ', 'TV PEDRO AMERICO', 'POCO                          ');
INSERT INTO cd_cep_br VALUES ('57.060-880', '54       ', 'R PEDRO BARBOZA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.017-510', '54       ', 'R PEDRO BELTRAO', 'BEBEDOURO                     ');
INSERT INTO cd_cep_br VALUES ('57.015-150', '54       ', 'R PEDRO BEZERRA CAVALCANTE', 'V LAGO                        ');
INSERT INTO cd_cep_br VALUES ('57.030-570', '54       ', 'R PEDRO BONIFACIO DE OLIVEIRA', 'POCO                          ');
INSERT INTO cd_cep_br VALUES ('57.046-160', '54       ', 'R PEDRO CAMELO DE FREITAS', 'B DURO                        ');
INSERT INTO cd_cep_br VALUES ('57.014-190', '54       ', 'R PEDRO CARDEAL FARIAS', 'P GROSSA                      ');
INSERT INTO cd_cep_br VALUES ('57.046-320', '54       ', 'R PEDRO DE MELO MOTA', 'SERRARIA                      ');
INSERT INTO cd_cep_br VALUES ('57.083-110', '54       ', 'R PEDRO DOMINGOS DA SILVA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.045-120', '54       ', 'R PEDRO GOMIDE FILHO', 'B DURO                        ');
INSERT INTO cd_cep_br VALUES ('57.046-650', '54       ', 'R PEDRO LOBO ASSUMPCAO', 'SERRARIA                      ');
INSERT INTO cd_cep_br VALUES ('57.061-530', '54       ', 'R PEDRO LOPES CARVALHO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.042-450', '54       ', 'R PEDRO LOUREIRO FARIAS', 'FEITOSA                       ');
INSERT INTO cd_cep_br VALUES ('57.042-460', '54       ', 'R PEDRO MAIA NOBRE', 'FEITOSA                       ');
INSERT INTO cd_cep_br VALUES ('57.083-160', '54       ', 'R PEDRO MANOEL MENDES', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.017-450', '54       ', 'R PEDRO MARINHO FILHO', 'BEBEDOURO                     ');
INSERT INTO cd_cep_br VALUES ('57.036-870', '54       ', 'R PEDRO MOURA', 'JATIUCA                       ');
INSERT INTO cd_cep_br VALUES ('57.073-280', '54       ', 'R PEDRO NEPOMUCENO DA SILVA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.057-560', '54       ', 'R PEDRO OLIVEIRA ROCHA', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.025-340', '54       ', 'R PEDRO PAULINO', 'POCO                          ');
INSERT INTO cd_cep_br VALUES ('57.025-345', '54       ', 'TV PEDRO PAULINO', 'POCO                          ');
INSERT INTO cd_cep_br VALUES ('57.042-470', '54       ', 'R PEDRO PEDROSA', 'B VISTA                       ');
INSERT INTO cd_cep_br VALUES ('57.081-030', '54       ', 'AV PARAGUASSU', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.057-240', '54       ', 'R PARAISO, DO', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.045-275', '54       ', 'TV PARANA', 'B DURO                        ');
INSERT INTO cd_cep_br VALUES ('57.055-480', '54       ', 'R PARANANGUE', 'PINHEIRO                      ');
INSERT INTO cd_cep_br VALUES ('57.082-830', '54       ', 'R PARANHOS', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.031-500', '54       ', 'R PARDAIS, DOS', 'MANGABEIRAS                   ');
INSERT INTO cd_cep_br VALUES ('57.074-010', '54       ', 'LOT PARQUE DAS ARVORES I', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.074-020', '54       ', 'LOT PARQUE DAS ARVORES II', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.074-030', '54       ', 'LOT PARQUE DAS ARVORES III', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.061-620', '54       ', 'LOT PARQUE DOS EUCALIPTOS', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.060-530', '54       ', 'CON PARQUE RESIDENCIAL MORADA NOVA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.041-620', '54       ', 'R PASTOR EURICO CALHEIROS', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.072-480', '54       ', 'R PASTOR MANOEL PEREIRA LIMA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.061-710', '54       ', 'R PASTOR NELSON BONAPARTE(LOT LAGOA AZUL)', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.082-010', '54       ', 'R PASTOR TAVARES', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.052-490', '54       ', 'R PAU BRASIL', 'G LOURDES                     ');
INSERT INTO cd_cep_br VALUES ('57.061-350', '54       ', 'R PROFESSOR JOSE NOBRE RIBEIRO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.051-550', '54       ', 'R PROFESSOR JOSE PAULINO', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.015-560', '54       ', 'R PROFESSOR JOSE SARAIVA', 'P GROSSA                      ');
INSERT INTO cd_cep_br VALUES ('57.014-210', '54       ', 'R PROFESSOR LOUREIRO', 'P GROSSA                      ');
INSERT INTO cd_cep_br VALUES ('57.062-020', '54       ', 'AL PROFESSOR LOUREIRO PEIXOTO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.035-130', '54       ', 'R PROFESSOR LOURENCO PEIXOTO', 'JATIUCA                       ');
INSERT INTO cd_cep_br VALUES ('57.014-350', '54       ', 'R PROFESSOR LUIZ CARLOS DE SOUZA NETO', 'P GROSSA                      ');
INSERT INTO cd_cep_br VALUES ('57.010-310', '54       ', 'R PROFESSOR LUIZ LAVENERE MACHADO', 'T BARRA                       ');
INSERT INTO cd_cep_br VALUES ('57.043-420', '54       ', 'R PROFESSOR MACARIO', 'FEITOSA                       ');
INSERT INTO cd_cep_br VALUES ('57.036-710', '54       ', 'R PROFESSOR MANOEL COELHO NETO', 'JATIUCA                       ');
INSERT INTO cd_cep_br VALUES ('57.015-570', '54       ', 'R PROFESSOR MARIO BROAD', 'P GROSSA                      ');
INSERT INTO cd_cep_br VALUES ('57.055-610', '54       ', 'R PROFESSOR MARIO MARROQUIM', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.036-720', '54       ', 'R PROFESSOR MEDEIROS NETTO', 'JATIUCA                       ');
INSERT INTO cd_cep_br VALUES ('57.073-070', '54       ', 'R PROFESSOR MOACIR J. DOS SANTOS', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.031-250', '54       ', 'R PROFESSOR MORENO BRANDAO', 'POCO                          ');
INSERT INTO cd_cep_br VALUES ('57.036-730', '54       ', 'R PROFESSOR NABUCO LOPES', 'JATIUCA                       ');
INSERT INTO cd_cep_br VALUES ('57.070-090', '54       ', 'R PRAIA, DA', 'F VELHO                       ');
INSERT INTO cd_cep_br VALUES ('57.039-280', '54       ', 'R PRAIA, DA', 'R DOCE                        ');
INSERT INTO cd_cep_br VALUES ('57.084-080', '54       ', 'AV PRATAGY', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.072-390', '54       ', 'EST PRATAGY, DO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.018-140', '54       ', 'R PRAZERES, DOS', 'BEBEDOURO                     ');
INSERT INTO cd_cep_br VALUES ('57.018-145', '54       ', 'TV PRAZERES, DOS', 'BEBEDOURO                     ');
INSERT INTO cd_cep_br VALUES ('57.035-380', '54       ', 'R PREFEITO ABDON ARROXELAS', 'P VERDE                       ');
INSERT INTO cd_cep_br VALUES ('57.057-410', '54       ', 'R PREFEITO EDVAL LEMOS', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.050-750', '54       ', 'R PREFEITO JOAQUIM LEAO', 'G LOURDES                     ');
INSERT INTO cd_cep_br VALUES ('69.049-330', '156      ', 'R 17 (CJ HILEIA I)', 'REDENCAO                      ');
INSERT INTO cd_cep_br VALUES ('69.049-510', '156      ', 'R 17 (CJ HILEIA II)', 'REDENCAO                      ');
INSERT INTO cd_cep_br VALUES ('57.306-670', '23       ', 'R LOURENCO FERREIRA DE ALBUQUERQUE', 'CAVACO                        ');
INSERT INTO cd_cep_br VALUES ('57.310-350', '23       ', 'R LUCIO FLAVIO DA SILVA', 'R CRUZ                        ');
INSERT INTO cd_cep_br VALUES ('57.300-360', '23       ', 'R LUCIO ROBERTO', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.300-130', '23       ', 'R JOSE LOPES DA SILVA', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.307-430', '23       ', 'AV JOSE LUCIO DA SILVA', 'JD ESPERANCA                  ');
INSERT INTO cd_cep_br VALUES ('57.301-420', '23       ', 'R JOSE LUCIO DE MELO', 'JD TROPICAL                   ');
INSERT INTO cd_cep_br VALUES ('57.306-450', '23       ', 'R JOSE LUIZ DE ALMEIDA', 'CAVACO                        ');
INSERT INTO cd_cep_br VALUES ('57.305-220', '23       ', 'R JOSE MARIA DE LIMA', 'M TELES                       ');
INSERT INTO cd_cep_br VALUES ('57.302-510', '23       ', 'R JOSE MARIO DE BARROS', 'CANAFISTULA                   ');
INSERT INTO cd_cep_br VALUES ('57.312-670', '23       ', 'R JOSE MARQUES FREIRE', 'N HORIZONTE                   ');
INSERT INTO cd_cep_br VALUES ('57.312-400', '23       ', 'R JOSE MATHEUS DO NASCIMENTO', 'N HORIZONTE                   ');
INSERT INTO cd_cep_br VALUES ('57.313-680', '23       ', 'R JOSE MATHEUS SOBRINHO', 'BRASILIA                      ');
INSERT INTO cd_cep_br VALUES ('57.306-460', '23       ', 'R JOSE MONTEIRO DA SILVA', 'CAVACO                        ');
INSERT INTO cd_cep_br VALUES ('57.306-050', '23       ', 'R JOSE MONTEIRO DE MAIA', 'ELDORADO                      ');
INSERT INTO cd_cep_br VALUES ('57.312-030', '23       ', 'R JOSE NETO TOTO', 'AT CRUZEIRO                   ');
INSERT INTO cd_cep_br VALUES ('57.304-130', '23       ', 'PC JOSE NUNES BARBOSA', 'PRIMAVERA                     ');
INSERT INTO cd_cep_br VALUES ('57.312-200', '23       ', 'R JOSE NUNES CARNAUBA', 'AT CRUZEIRO                   ');
INSERT INTO cd_cep_br VALUES ('57.314-250', '23       ', 'R JOSE PEDRO DA SILVA', 'BRASILIA                      ');
INSERT INTO cd_cep_br VALUES ('57.300-140', '23       ', 'PC JOSE PEREIRA LEAO', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.314-180', '23       ', 'R JOSE PROCOPIO FILHO', 'ITAPOA                        ');
INSERT INTO cd_cep_br VALUES ('57.307-560', '23       ', 'R JOSE RAIMUNDO', 'JD ESPERANCA                  ');
INSERT INTO cd_cep_br VALUES ('57.304-590', '23       ', 'R JOSE RIBEIRO', 'CACIMBAS                      ');
INSERT INTO cd_cep_br VALUES ('57.302-180', '23       ', 'R JOSE ROBERTO TAVARES DE SOUZA', 'CANAFISTULA                   ');
INSERT INTO cd_cep_br VALUES ('57.300-600', '23       ', 'R JOSE RODRIGUES DE LIMA', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.304-640', '23       ', 'R JOSE RODRIGUES LIMA', 'CACIMBAS                      ');
INSERT INTO cd_cep_br VALUES ('57.307-700', '23       ', 'R JOSE SABINO SAMPAIO', 'JD ESPERANCA                  ');
INSERT INTO cd_cep_br VALUES ('57.303-630', '23       ', 'R JOSE SALU', 'GUARIBAS                      ');
INSERT INTO cd_cep_br VALUES ('57.302-170', '23       ', 'R JOSE SATURNINO', 'CANAFISTULA                   ');
INSERT INTO cd_cep_br VALUES ('57.302-020', '23       ', 'R JOSE SILVERIO', 'CANAFISTULA                   ');
INSERT INTO cd_cep_br VALUES ('57.311-290', '23       ', 'R JOSE SOARES NUNES', 'CAITITUS                      ');
INSERT INTO cd_cep_br VALUES ('57.305-580', '23       ', 'R JOSE TEODORO DOS SANTOS', 'BAIXAO                        ');
INSERT INTO cd_cep_br VALUES ('57.301-400', '23       ', 'R JOSE TERTO', 'JD TROPICAL                   ');
INSERT INTO cd_cep_br VALUES ('57.302-520', '23       ', 'R JOSE TIBURCIO DA SILVA', 'CANAFISTULA                   ');
INSERT INTO cd_cep_br VALUES ('57.306-620', '23       ', 'R JOSE VENTURA DE OLIVEIRA', 'CAVACO                        ');
INSERT INTO cd_cep_br VALUES ('57.313-330', '23       ', 'R JOSE VENTURA OLIVEIRA', 'BRASILIA                      ');
INSERT INTO cd_cep_br VALUES ('57.306-500', '23       ', 'R JOSE VIEIRA DA SILVA', 'CAVACO                        ');
INSERT INTO cd_cep_br VALUES ('57.310-160', '23       ', 'R JOSE VIEIRA DA SILVA', 'CAPIATA                       ');
INSERT INTO cd_cep_br VALUES ('57.302-080', '23       ', 'PC JOSEFA BERNARDINA', 'CANAFISTULA                   ');
INSERT INTO cd_cep_br VALUES ('57.304-290', '23       ', 'R JOSEFA CARTAXO', 'O D CAZUZINHOS                ');
INSERT INTO cd_cep_br VALUES ('57.304-810', '23       ', 'R JOSEFA CLARETE SANTOS', 'O D CAZUZINHOS                ');
INSERT INTO cd_cep_br VALUES ('57.302-460', '23       ', 'R JOSEFA DE CARVALHO E SILVA', 'N ESPERANCA                   ');
INSERT INTO cd_cep_br VALUES ('57.306-610', '23       ', 'R JOSE BERNARDINO', 'ELDORADO                      ');
INSERT INTO cd_cep_br VALUES ('57.311-100', '23       ', 'R JOSE BERNARDINO DA SILVA', 'AT CRUZEIRO                   ');
INSERT INTO cd_cep_br VALUES ('57.300-110', '23       ', 'PC JOSE BERNARDINO DOS SANTOS', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.306-140', '23       ', 'R JOSE BEZERRA SANTOS', 'ELDORADO                      ');
INSERT INTO cd_cep_br VALUES ('57.304-030', '23       ', 'R JOSE BONIFACIO DE ANDRADE E SILVA', 'PRIMAVERA                     ');
INSERT INTO cd_cep_br VALUES ('57.314-220', '23       ', 'R JOSE CARDOSO DA SILVA', 'BRASILIA                      ');
INSERT INTO cd_cep_br VALUES ('57.311-350', '23       ', 'R JOSE CARLOS VALENTINO', 'CAITITUS                      ');
INSERT INTO cd_cep_br VALUES ('57.312-540', '23       ', 'R JOSE CAVALCANTE BEZERRA DE BARROS', 'N HORIZONTE                   ');
INSERT INTO cd_cep_br VALUES ('57.312-240', '23       ', 'R JOSE CICERO DE QUEIROZ', 'S ESMERALDA                   ');
INSERT INTO cd_cep_br VALUES ('57.314-040', '23       ', 'R JOSE CICERO FERREIRA', 'ITAPOA                        ');
INSERT INTO cd_cep_br VALUES ('57.301-300', '23       ', 'R JOSE CICERO SILVA', 'S LUIZ                        ');
INSERT INTO cd_cep_br VALUES ('57.312-430', '23       ', 'R JOSE CLOVIS RESENDE DE BARROS', 'N HORIZONTE                   ');
INSERT INTO cd_cep_br VALUES ('57.302-220', '23       ', 'R JOSE DIAS', 'CANAFISTULA                   ');
INSERT INTO cd_cep_br VALUES ('57.307-020', '23       ', 'R JOSE DOMINGOS DOS SANTOS', 'BX GRANDE                     ');
INSERT INTO cd_cep_br VALUES ('57.301-350', '23       ', 'R JOSE DORGIVAL ALMEIDA', 'S LUIZ                        ');
INSERT INTO cd_cep_br VALUES ('57.303-560', '23       ', 'R JOSE DUDA DA SILVA', 'GUARIBAS                      ');
INSERT INTO cd_cep_br VALUES ('57.313-590', '23       ', 'R MARAGOGI', 'JD TROPICAL                   ');
INSERT INTO cd_cep_br VALUES ('57.313-550', '23       ', 'R MARAVILHA', 'JD TROPICAL                   ');
INSERT INTO cd_cep_br VALUES ('57.312-420', '23       ', 'R MARCELINO MAGALHAES', 'AT CRUZEIRO                   ');
INSERT INTO cd_cep_br VALUES ('57.311-470', '23       ', 'R MARCIA HOULY', 'CAITITUS                      ');
INSERT INTO cd_cep_br VALUES ('57.311-390', '23       ', 'R MARCINO NUNES FERREIRA', 'CAITITUS                      ');
INSERT INTO cd_cep_br VALUES ('57.304-830', '23       ', 'R MARCIONILO IZIDORO DOS SANTOS', 'CACIMBAS                      ');
INSERT INTO cd_cep_br VALUES ('57.301-380', '23       ', 'R MARCOLINO JUVENCIO BISPO', 'O PRETO                       ');
INSERT INTO cd_cep_br VALUES ('57.304-100', '23       ', 'R MARECHAL COSTA E SILVA', 'PRIMAVERA                     ');
INSERT INTO cd_cep_br VALUES ('57.313-010', '23       ', 'R MARECHAL DEODORO DA FONSECA', 'O PRETO                       ');
INSERT INTO cd_cep_br VALUES ('57.306-010', '23       ', 'R MARECHAL FLORIANO PEIXOTO', 'BAIXAO                        ');
INSERT INTO cd_cep_br VALUES ('57.306-100', '23       ', 'R MARECHAL HERMES DA FONSECA', 'BAIXAO                        ');
INSERT INTO cd_cep_br VALUES ('57.312-160', '23       ', 'R MARECHAL RONDON', 'S ESMERALDA                   ');
INSERT INTO cd_cep_br VALUES ('57.303-390', '23       ', 'R MARGARIDA NUNES MAGALHAES', 'V CAMPOS                      ');
INSERT INTO cd_cep_br VALUES ('57.307-160', '23       ', 'R MARGARITA PALMERINA DE ALMEIDA', 'BX GRANDE                     ');
INSERT INTO cd_cep_br VALUES ('57.306-690', '23       ', 'R MARIA BALBINA DE OLIVEIRA', 'CAVACO                        ');
INSERT INTO cd_cep_br VALUES ('57.303-490', '23       ', 'R MARIA CAROLINA DONATO', 'GUARIBAS                      ');
INSERT INTO cd_cep_br VALUES ('57.302-210', '23       ', 'R LUCIO VITAL', 'CANAFISTULA                   ');
INSERT INTO cd_cep_br VALUES ('57.303-450', '23       ', 'R LUIS FERREIRA PESSOA', 'GUARIBAS                      ');
INSERT INTO cd_cep_br VALUES ('57.305-140', '23       ', 'R LUIZ DE SALES BRASIL', 'M TELES                       ');
INSERT INTO cd_cep_br VALUES ('57.313-380', '23       ', 'R LUIZ DUARTE', 'BRASILIA                      ');
INSERT INTO cd_cep_br VALUES ('57.306-090', '23       ', 'R LUIZ JOSE DE ALBUQUERQUE', 'ELDORADO                      ');
INSERT INTO cd_cep_br VALUES ('57.300-010', '23       ', 'PC LUIZ PEREIRA LIMA', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.312-710', '23       ', 'R LUIZ SIMOES', 'S ESMERALDA                   ');
INSERT INTO cd_cep_br VALUES ('57.307-710', '23       ', 'R LUIZ VIGARIO', 'JD ESPERANCA                  ');
INSERT INTO cd_cep_br VALUES ('57.310-220', '23       ', 'R LUIZA PEREIRA SANTOS', 'CAPIATA                       ');
INSERT INTO cd_cep_br VALUES ('57.312-280', '23       ', 'PC LUZIA SURUAGY', 'S A MELO                      ');
INSERT INTO cd_cep_br VALUES ('57.301-250', '23       ', 'R LUZIVALDO BARBOSA MARQUES', 'S LUIZ                        ');
INSERT INTO cd_cep_br VALUES ('57.313-300', '23       ', 'R MACIONILO MIGUEL SILVA', 'BRASILIA                      ');
INSERT INTO cd_cep_br VALUES ('57.308-680', '23       ', 'R MADRE HELENA', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('57.308-130', '23       ', 'R MAESTRO ANTONIO BARROS ARAUJO', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('57.303-130', '23       ', 'R MANAUS', 'V CAMPOS                      ');
INSERT INTO cd_cep_br VALUES ('57.305-060', '23       ', 'R MANE GARRINCHA', 'M TELES                       ');
INSERT INTO cd_cep_br VALUES ('57.302-530', '23       ', 'R MANGUEIRA, DA', 'CANAFISTULA                   ');
INSERT INTO cd_cep_br VALUES ('57.312-410', '23       ', 'R MANOEL ABREU', 'AT CRUZEIRO                   ');
INSERT INTO cd_cep_br VALUES ('57.307-250', '23       ', 'R MANOEL AFONSO MARANHAO', 'JD ESPERANCA                  ');
INSERT INTO cd_cep_br VALUES ('57.300-005', '23       ', 'PC MANOEL ANDRE', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.305-360', '23       ', 'R MANOEL ANGELO TAVARES', 'BAIXAO                        ');
INSERT INTO cd_cep_br VALUES ('57.313-270', '23       ', 'R MANOEL BARBOSA MEDEIROS', 'BRASILIA                      ');
INSERT INTO cd_cep_br VALUES ('57.306-200', '23       ', 'R MANOEL BERNADINO DOS SANTOS', 'ELDORADO                      ');
INSERT INTO cd_cep_br VALUES ('57.301-160', '23       ', 'R MANOEL CAETANO DE SOUZA', 'O PRETO                       ');
INSERT INTO cd_cep_br VALUES ('57.314-230', '23       ', 'R MANOEL CAVALCANTE MALTA', 'BRASILIA                      ');
INSERT INTO cd_cep_br VALUES ('57.045-400', '54       ', 'R EMPRESARIO JOSE GOMES DE BARROS', 'B DURO                        ');
INSERT INTO cd_cep_br VALUES ('69.020-590', '156      ', 'BC SETENTA', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('69.060-662', '156      ', 'BC SEVERIANO NUNES', 'ALEIXO                        ');
INSERT INTO cd_cep_br VALUES ('69.060-660', '156      ', 'R SEVERIANO NUNES', 'ALEIXO                        ');
INSERT INTO cd_cep_br VALUES ('69.070-351', '156      ', 'TV SEVERINO PALMEIRA', 'EDUCANDOS                     ');
INSERT INTO cd_cep_br VALUES ('69.093-200', '156      ', 'R SHALON', 'COL S ANTONIO                 ');
INSERT INTO cd_cep_br VALUES ('69.088-661', '156      ', 'R SARAPO', 'J TEIXEIRA                    ');
INSERT INTO cd_cep_br VALUES ('69.037-813', '156      ', 'BC SARAPO', 'L VALE                        ');
INSERT INTO cd_cep_br VALUES ('69.081-390', '156      ', 'R SARDINHA', 'J TEIXEIRA                    ');
INSERT INTO cd_cep_br VALUES ('69.033-480', '156      ', 'R SARGENTO MANOEL CHAGAS', 'S JORGE                       ');
INSERT INTO cd_cep_br VALUES ('69.039-290', '156      ', 'R SATERE MAUE', 'N ISRAEL                      ');
INSERT INTO cd_cep_br VALUES ('12.910-011', '4897     ', 'R PERU', 'MATADOURO                     ');
INSERT INTO cd_cep_br VALUES ('69.067-802', '156      ', 'R SATIRO BARBOSA', 'PETROPOLIS                    ');
INSERT INTO cd_cep_br VALUES ('69.079-060', '156      ', 'R SATIRO DIAS', 'S FRANCISCO                   ');
INSERT INTO cd_cep_br VALUES ('69.054-320', '156      ', 'CJ SAU SALITO', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.074-130', '156      ', 'BC SAUDADE', 'COL O MACHADO                 ');
INSERT INTO cd_cep_br VALUES ('69.082-320', '156      ', 'BC SAUDADE', 'COROADO                       ');
INSERT INTO cd_cep_br VALUES ('69.075-730', '156      ', 'BC SAUDADE, DA', 'MAUAZINHO                     ');
INSERT INTO cd_cep_br VALUES ('69.073-640', '156      ', 'R SAUDADE, DA', 'BETANIA                       ');
INSERT INTO cd_cep_br VALUES ('69.033-830', '156      ', 'R SAUDADE, DA', 'S JORGE                       ');
INSERT INTO cd_cep_br VALUES ('69.093-386', '156      ', 'R SAUDADE, DA', 'COL S ANTONIO                 ');
INSERT INTO cd_cep_br VALUES ('69.087-560', '156      ', 'R SAUDADE, DA', 'T NEVES                       ');
INSERT INTO cd_cep_br VALUES ('69.088-550', '156      ', 'R SAUVIAS, DAS', 'J TEIXEIRA                    ');
INSERT INTO cd_cep_br VALUES ('69.054-621', '156      ', 'R SEBASTIAO REIS', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('69.036-340', '156      ', 'R SEBASTIAO ROMANO (CJ R XINGU)', 'COMPENSA                      ');
INSERT INTO cd_cep_br VALUES ('69.086-591', '156      ', 'R SEFAZ', 'S J OPERARIO                  ');
INSERT INTO cd_cep_br VALUES ('69.098-764', '156      ', 'TV SEIS(A. MENDES)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.097-171', '156      ', 'TV SEIS(NUCLEO 23)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.085-646', '156      ', 'R SEIS (ASTECA)', 'S J OPERARIO                  ');
INSERT INTO cd_cep_br VALUES ('69.055-051', '156      ', 'R SEIS (CJ BELO HORIZONTE)', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.075-254', '156      ', 'BC SEMENTINHA', 'MAUAZINHO                     ');
INSERT INTO cd_cep_br VALUES ('69.008-330', '156      ', 'R SENADOR ALVARO MAIA', 'COL A ALEIXO                  ');
INSERT INTO cd_cep_br VALUES ('69.025-070', '156      ', 'BVD SENADOR ALVARO MAIA- ATE 418/455', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('69.020-210', '156      ', 'BVD SENADOR ALVARO MAIA- DE 420/457 AO FIM', 'PC 14 JANEIRO                 ');
INSERT INTO cd_cep_br VALUES ('69.033-610', '156      ', 'R SENADOR CUNHA MELO', 'S JORGE                       ');
INSERT INTO cd_cep_br VALUES ('69.087-210', '156      ', 'R SENADOR FABIO LUCENA', 'T NEVES                       ');
INSERT INTO cd_cep_br VALUES ('69.039-100', '156      ', 'R SENADOR FABIO LUCENA', 'N ISRAEL                      ');
INSERT INTO cd_cep_br VALUES ('69.075-312', '156      ', 'R SENADOR FABIO LUCENA', 'MAUAZINHO                     ');
INSERT INTO cd_cep_br VALUES ('69.082-620', '156      ', 'R SENADOR FABIO LUCENA (O VERDE)', 'COROADO                       ');
INSERT INTO cd_cep_br VALUES ('69.042-750', '156      ', 'R SENADOR FABIO LUCENA (PRQ R JERUSALEM)', 'D PEDRO                       ');
INSERT INTO cd_cep_br VALUES ('69.087-220', '156      ', 'R SENADOR JOAO BOSCO', 'T NEVES                       ');
INSERT INTO cd_cep_br VALUES ('69.008-340', '156      ', 'R SENADOR JOAO BOSCO', 'COL A ALEIXO                  ');
INSERT INTO cd_cep_br VALUES ('69.048-040', '156      ', 'CJ SENADOR JOAO BOSCO RAMOS DE LIMA', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('69.035-710', '156      ', 'BC SENADOR JOSE ESTEVES', 'COMPENSA                      ');
INSERT INTO cd_cep_br VALUES ('69.035-720', '156      ', 'R SENADOR JOSE ESTEVES', 'COMPENSA                      ');
INSERT INTO cd_cep_br VALUES ('69.039-105', '156      ', 'BC SAO SEBASTIAO', 'N ISRAEL                      ');
INSERT INTO cd_cep_br VALUES ('69.039-104', '156      ', 'R SAO SEBASTIAO', 'N ISRAEL                      ');
INSERT INTO cd_cep_br VALUES ('69.059-425', '156      ', 'R SAO SEBASTIAO', 'S ETELVINA                    ');
INSERT INTO cd_cep_br VALUES ('69.067-560', '156      ', 'R SAO SEBASTIAO (S SEBASTIAO)', 'PETROPOLIS                    ');
INSERT INTO cd_cep_br VALUES ('69.067-561', '156      ', 'BC SAO SEBASTIAO (S SEBASTIAO)', 'PETROPOLIS                    ');
INSERT INTO cd_cep_br VALUES ('69.059-426', '156      ', 'R SAO SEVERINO', 'S ETELVINA                    ');
INSERT INTO cd_cep_br VALUES ('69.039-310', '156      ', 'R SAO THOME', 'N ISRAEL                      ');
INSERT INTO cd_cep_br VALUES ('69.027-051', '156      ', 'BC SAO THOME', 'S RAIMUNDO                    ');
INSERT INTO cd_cep_br VALUES ('69.037-564', '156      ', 'R SAO TIMOTEO(L.M.NOGUEIRA)', 'N ESPERANCA                   ');
INSERT INTO cd_cep_br VALUES ('69.030-190', '156      ', 'BC SAO TOME', 'COMPENSA                      ');
INSERT INTO cd_cep_br VALUES ('69.037-690', '156      ', 'R SAO TOME', 'L VALE                        ');
INSERT INTO cd_cep_br VALUES ('69.036-690', '156      ', 'R SAO TOME', 'S AGOSTINHO                   ');
INSERT INTO cd_cep_br VALUES ('69.029-030', '156      ', 'R SAO TOME', 'S ANTONIO                     ');
INSERT INTO cd_cep_br VALUES ('69.027-050', '156      ', 'R SAO TOME', 'S RAIMUNDO                    ');
INSERT INTO cd_cep_br VALUES ('69.093-370', '156      ', 'R SAO TOME', 'COL S ANTONIO                 ');
INSERT INTO cd_cep_br VALUES ('69.093-036', '156      ', 'TV SAO TOME', 'COL S ANTONIO                 ');
INSERT INTO cd_cep_br VALUES ('69.075-760', '156      ', 'BC SAO VICENTE', 'MAUAZINHO                     ');
INSERT INTO cd_cep_br VALUES ('69.060-140', '156      ', 'BC SAO VICENTE', 'ALEIXO                        ');
INSERT INTO cd_cep_br VALUES ('69.074-090', '156      ', 'R SAO VICENTE', 'COL O MACHADO                 ');
INSERT INTO cd_cep_br VALUES ('69.063-360', '156      ', 'BC SAO VICENTE', 'PETROPOLIS                    ');
INSERT INTO cd_cep_br VALUES ('69.033-551', '156      ', 'R SAO VICENTE', 'S JORGE                       ');
INSERT INTO cd_cep_br VALUES ('69.030-620', '156      ', 'TV SAO VICENTE', 'VL PRATA                      ');
INSERT INTO cd_cep_br VALUES ('69.073-200', '156      ', 'BC SAO VICENTE', 'S LAZARO                      ');
INSERT INTO cd_cep_br VALUES ('69.073-010', '156      ', 'R SAO VICENTE', 'S LAZARO                      ');
INSERT INTO cd_cep_br VALUES ('69.073-630', '156      ', 'TV SAO VICENTE', 'S LAZARO                      ');
INSERT INTO cd_cep_br VALUES ('69.027-580', '156      ', 'R SAO VICENTE', 'S RAIMUNDO                    ');
INSERT INTO cd_cep_br VALUES ('69.035-291', '156      ', 'BC SAO VICENTE', 'COMPENSA                      ');
INSERT INTO cd_cep_br VALUES ('69.048-280', '156      ', 'R SAO VICENTE', 'PAZ                           ');
INSERT INTO cd_cep_br VALUES ('69.035-290', '156      ', 'R SAO VICENTE', 'COMPENSA                      ');
INSERT INTO cd_cep_br VALUES ('69.075-761', '156      ', 'R SAO VICENTE', 'MAUAZINHO                     ');
INSERT INTO cd_cep_br VALUES ('69.093-774', '156      ', 'BC SAO VICENTE', 'COL S ANTONIO                 ');
INSERT INTO cd_cep_br VALUES ('69.035-150', '156      ', 'BC SAO VICENTE DE PAULA', 'COMPENSA                      ');
INSERT INTO cd_cep_br VALUES ('69.035-151', '156      ', 'R SAO VICENTE DE PAULA', 'COMPENSA                      ');
INSERT INTO cd_cep_br VALUES ('69.070-471', '156      ', 'TV SAO VICENTE DE PAULA', 'EDUCANDOS                     ');
INSERT INTO cd_cep_br VALUES ('69.027-220', '156      ', 'R SAO VICENTE DE PAULA', 'S RAIMUNDO                    ');
INSERT INTO cd_cep_br VALUES ('69.070-470', '156      ', 'R SAO VICENTE DE PAULA', 'EDUCANDOS                     ');
INSERT INTO cd_cep_br VALUES ('69.093-418', '156      ', 'R SAO VICENTE DE PAULA(T. NOVA I)', 'COL T NOVA                    ');
INSERT INTO cd_cep_br VALUES ('69.090-300', '156      ', 'R SAPOTI (CJ C NOVA)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.079-421', '156      ', 'BC SAO PEDRO', 'PETROPOLIS                    ');
INSERT INTO cd_cep_br VALUES ('69.093-441', '156      ', 'R SAO PEDRO(T. NOVA I)', 'COL T NOVA                    ');
INSERT INTO cd_cep_br VALUES ('69.043-831', '156      ', 'BC SAO RAIMUNDO', 'ALVORADA                      ');
INSERT INTO cd_cep_br VALUES ('69.027-770', '156      ', 'R SAO RAIMUNDO', 'GLORIA                        ');
INSERT INTO cd_cep_br VALUES ('69.029-180', '156      ', 'R SAO RAIMUNDO', 'S ANTONIO                     ');
INSERT INTO cd_cep_br VALUES ('69.037-510', '156      ', 'R SAO RAIMUNDO', 'N ESPERANCA                   ');
INSERT INTO cd_cep_br VALUES ('69.080-730', '156      ', 'TV SAO RAIMUNDO', 'COROADO                       ');
INSERT INTO cd_cep_br VALUES ('69.059-620', '156      ', 'R SAO RAIMUNDO', 'S ETELVINA                    ');
INSERT INTO cd_cep_br VALUES ('69.073-331', '156      ', 'BC SAO RAIMUNDO', 'BETANIA                       ');
INSERT INTO cd_cep_br VALUES ('69.059-152', '156      ', 'BC SAO RAIMUNDO', 'S ETELVINA                    ');
INSERT INTO cd_cep_br VALUES ('69.075-274', '156      ', 'BC SAO RAIMUNDO', 'MAUAZINHO                     ');
INSERT INTO cd_cep_br VALUES ('69.043-630', '156      ', 'R SAO ROQUE', 'ALVORADA                      ');
INSERT INTO cd_cep_br VALUES ('69.043-640', '156      ', 'TV SAO ROQUE', 'ALVORADA                      ');
INSERT INTO cd_cep_br VALUES ('69.043-641', '156      ', 'BC SAO ROQUE', 'ALVORADA                      ');
INSERT INTO cd_cep_br VALUES ('69.095-176', '156      ', 'BC SAO ROQUE (RIACHO DOCE)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.060-130', '156      ', 'BC SAO SEBASTIAO', 'ALEIXO                        ');
INSERT INTO cd_cep_br VALUES ('69.010-240', '156      ', 'PC SAO SEBASTIAO', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('69.035-070', '156      ', 'R SAO SEBASTIAO', 'COMPENSA                      ');
INSERT INTO cd_cep_br VALUES ('69.082-310', '156      ', 'BC SAO SEBASTIAO', 'COROADO                       ');
INSERT INTO cd_cep_br VALUES ('69.082-300', '156      ', 'R SAO SEBASTIAO', 'COROADO                       ');
INSERT INTO cd_cep_br VALUES ('69.078-330', '156      ', 'BC SAO SEBASTIAO', 'JAPIIM                        ');
INSERT INTO cd_cep_br VALUES ('69.078-340', '156      ', 'R SAO SEBASTIAO', 'JAPIIM                        ');
INSERT INTO cd_cep_br VALUES ('57.017-010', '54       ', 'R CABO OLIVAL BARBOSA', 'B PARTO                       ');
INSERT INTO cd_cep_br VALUES ('57.031-050', '54       ', 'R CABO OLIVALDO VILANOVA', 'POCO                          ');
INSERT INTO cd_cep_br VALUES ('69.151-480', '161      ', 'BC SUBMARINO', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('69.152-530', '161      ', 'R TAPAJOS', 'S F ASSIS                     ');
INSERT INTO cd_cep_br VALUES ('69.151-240', '161      ', 'R TENENTE MEIRELES FILHO', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('69.152-590', '161      ', 'AV TEREZA B. RIBEIRO (CJ SHAM)', 'S F ASSIS                     ');
INSERT INTO cd_cep_br VALUES ('69.153-180', '161      ', 'R TERRA SANTA', 'PALMARES                      ');
INSERT INTO cd_cep_br VALUES ('69.152-060', '161      ', 'BC TOGO MEIRELES', 'S BENEDITO                    ');
INSERT INTO cd_cep_br VALUES ('69.151-440', '161      ', 'BC TOMAS MEIRELES', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('69.152-680', '161      ', 'R TUCUMA (CJ MACURANI)', 'S F ASSIS                     ');
INSERT INTO cd_cep_br VALUES ('69.151-061', '161      ', 'PC TUKASA', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('69.152-540', '161      ', 'R UAICURAPA', 'S F ASSIS                     ');
INSERT INTO cd_cep_br VALUES ('69.152-700', '161      ', 'R UIXI (CJ MACURANI)', 'S F ASSIS                     ');
INSERT INTO cd_cep_br VALUES ('69.151-420', '161      ', 'R UMIRI (CJ MACURANI)', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('69.153-070', '161      ', 'R URUCARA', 'PALMARES                      ');
INSERT INTO cd_cep_br VALUES ('69.153-100', '161      ', 'R URUCURITUBA', 'PALMARES                      ');
INSERT INTO cd_cep_br VALUES ('69.152-580', '161      ', 'R VALDEMAR QUEIROZ ( CJ SHAM)', 'S F ASSIS                     ');
INSERT INTO cd_cep_br VALUES ('57.304-540', '23       ', 'R ANTONIO LEITE', 'CACIMBAS                      ');
INSERT INTO cd_cep_br VALUES ('57.308-530', '23       ', 'AV ANTONIO LEMOS PALMEIRA', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('57.300-570', '23       ', 'R ANTONIO LIMA SOBRINHO', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.311-330', '23       ', 'R ANTONIO MAGALHAES BARBOSA', 'CAITITUS                      ');
INSERT INTO cd_cep_br VALUES ('57.305-430', '23       ', 'R ANTONIO MARROQUIM', 'BAIXAO                        ');
INSERT INTO cd_cep_br VALUES ('57.305-570', '23       ', 'R ANTONIO MENEZES NETO', 'BAIXAO                        ');
INSERT INTO cd_cep_br VALUES ('57.307-340', '23       ', 'R ANTONIO MESSIAS', 'JD ESPERANCA                  ');
INSERT INTO cd_cep_br VALUES ('57.303-310', '23       ', 'R ANTONIO MIZAEL', 'B VISTA                       ');
INSERT INTO cd_cep_br VALUES ('57.313-050', '23       ', 'R ANTONIO OLIVEIRA MELO', 'BRASILIA                      ');
INSERT INTO cd_cep_br VALUES ('57.306-040', '23       ', 'R ANTONIO PEREIRA DE ALBUQUERQUE', 'ELDORADO                      ');
INSERT INTO cd_cep_br VALUES ('57.307-350', '23       ', 'R ANTONIO PEREIRA DE LIMA', 'JD ESPERANCA                  ');
INSERT INTO cd_cep_br VALUES ('57.308-140', '23       ', 'R ANTONIO PEREIRA DOS SANTOS', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('57.301-370', '23       ', 'R ANTONIO PETUBA', 'O PRETO                       ');
INSERT INTO cd_cep_br VALUES ('57.300-510', '23       ', 'PC ANTONIO RIBEIRO', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.306-060', '23       ', 'R ANTONIO ROCHERY DE LIMA', 'ELDORADO                      ');
INSERT INTO cd_cep_br VALUES ('57.307-280', '23       ', 'R ANTONIO RODRIGUES DE CARVALHO', 'JD ESPERANCA                  ');
INSERT INTO cd_cep_br VALUES ('57.307-290', '23       ', 'R ANTONIO ROMUALDO OLIVEIRA', 'JD ESPERANCA                  ');
INSERT INTO cd_cep_br VALUES ('57.303-610', '23       ', 'R ANTONIO SALU', 'GUARIBAS                      ');
INSERT INTO cd_cep_br VALUES ('57.303-290', '23       ', 'R ANTONIO SIMAO', 'B VISTA                       ');
INSERT INTO cd_cep_br VALUES ('57.313-240', '23       ', 'R ANTONIO TORRES', 'BRASILIA                      ');
INSERT INTO cd_cep_br VALUES ('57.305-670', '23       ', 'PC ANTONIO VENTURA DE OLIVEIRA', 'CAVACO                        ');
INSERT INTO cd_cep_br VALUES ('57.306-360', '23       ', 'PC ANTONIO VENTURA FILHO', 'CAVACO                        ');
INSERT INTO cd_cep_br VALUES ('57.303-460', '23       ', 'R ANTONIO VIEIRA NETO', 'GUARIBAS                      ');
INSERT INTO cd_cep_br VALUES ('57.301-390', '23       ', 'R ANTONIO VITAL DA SILVA', 'S LUIZ                        ');
INSERT INTO cd_cep_br VALUES ('57.311-060', '23       ', 'R APRIGIO JACINTO', 'AT CRUZEIRO                   ');
INSERT INTO cd_cep_br VALUES ('57.311-500', '23       ', 'R ARESTIDES CATU DA SILVA', 'CAITITUS                      ');
INSERT INTO cd_cep_br VALUES ('69.050-100', '156      ', 'R PENSADOR', 'CHAPADA                       ');
INSERT INTO cd_cep_br VALUES ('57.314-020', '23       ', 'R ARISTEU FERREIRA QUEIROZ', 'ITAPOA                        ');
INSERT INTO cd_cep_br VALUES ('57.311-370', '23       ', 'R ARISTIDES FELIX DA SILVA', 'CAITITUS                      ');
INSERT INTO cd_cep_br VALUES ('57.313-730', '23       ', 'R ARIZIO LOPES MARINHO', 'BRASILIA                      ');
INSERT INTO cd_cep_br VALUES ('57.305-170', '23       ', 'R ARIZONA', 'M TELES                       ');
INSERT INTO cd_cep_br VALUES ('57.308-540', '23       ', 'R AROLDO JULIO DA SILVA', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('57.303-640', '23       ', 'R ARTHUR CORREIA DA SILVA', 'N ESPERANCA                   ');
INSERT INTO cd_cep_br VALUES ('57.305-100', '23       ', 'R ATALAIA', 'M TELES                       ');
INSERT INTO cd_cep_br VALUES ('57.305-120', '23       ', 'R AUGUSTO PEREIRA', 'M TELES                       ');
INSERT INTO cd_cep_br VALUES ('57.306-130', '23       ', 'R ANA NERY', 'BAIXAO                        ');
INSERT INTO cd_cep_br VALUES ('57.303-520', '23       ', 'R ANA ROSA DE OLIVEIRA', 'GUARIBAS                      ');
INSERT INTO cd_cep_br VALUES ('57.308-190', '23       ', 'R ANADIA', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('57.302-480', '23       ', 'R ANANIAS BARROS DA SILVA', 'CANAFISTULA                   ');
INSERT INTO cd_cep_br VALUES ('57.307-330', '23       ', 'AV ANDRE AVELINO DA SILVA', 'JD ESPERANCA                  ');
INSERT INTO cd_cep_br VALUES ('57.312-650', '23       ', 'R ANDRE FELIX DA SILVA', 'N HORIZONTE                   ');
INSERT INTO cd_cep_br VALUES ('57.313-160', '23       ', 'R ANDRE LEAO', 'BRASILIA                      ');
INSERT INTO cd_cep_br VALUES ('57.306-530', '23       ', 'R ANGELO SOBRINHO', 'CAVACO                        ');
INSERT INTO cd_cep_br VALUES ('57.305-390', '23       ', 'R ANGELO TAVARES', 'BAIXAO                        ');
INSERT INTO cd_cep_br VALUES ('57.300-270', '23       ', 'R ANIBAL LIMA', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.311-380', '23       ', 'R ANITA ARISTIDES DA SILVA', 'CAITITUS                      ');
INSERT INTO cd_cep_br VALUES ('57.300-250', '23       ', 'LRG ANPHILOFIO C. SOUZA GUERRA', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.307-650', '23       ', 'R ANTENOR PEREIRA NUNES', 'JD ESPERANCA                  ');
INSERT INTO cd_cep_br VALUES ('57.307-040', '23       ', 'R ANTONIA ANGELINA DA SILVA', 'BX GRANDE                     ');
INSERT INTO cd_cep_br VALUES ('57.304-280', '23       ', 'R ANTONIA BARBOSA', 'O D CAZUZINHOS                ');
INSERT INTO cd_cep_br VALUES ('57.307-760', '23       ', 'R ANTONIA JOVELINA DOS SANTOS', 'BX GRANDE                     ');
INSERT INTO cd_cep_br VALUES ('57.305-680', '23       ', 'R ANTONIA LEITE', 'M TELES                       ');
INSERT INTO cd_cep_br VALUES ('57.304-560', '23       ', 'R ANTONIA LEITE LEANDRO', 'CACIMBAS                      ');
INSERT INTO cd_cep_br VALUES ('57.312-470', '23       ', 'R ANTONIO APOLINARIO DA SILVA', 'AT CRUZEIRO                   ');
INSERT INTO cd_cep_br VALUES ('57.303-400', '23       ', 'AV ANTONIO BARBOSA', 'GUARIBAS                      ');
INSERT INTO cd_cep_br VALUES ('57.312-610', '23       ', 'PC ANTONIO BARBOSA', 'N HORIZONTE                   ');
INSERT INTO cd_cep_br VALUES ('57.302-070', '23       ', 'R ANTONIO BARBOSA DA SILVA', 'CANAFISTULA                   ');
INSERT INTO cd_cep_br VALUES ('57.314-240', '23       ', 'R ANTONIO BARBOSA DA SILVA', 'ITAPOA                        ');
INSERT INTO cd_cep_br VALUES ('57.306-250', '23       ', 'R ANTONIO BERNADINO DE SENA', 'ELDORADO                      ');
INSERT INTO cd_cep_br VALUES ('57.311-110', '23       ', 'R ANTONIO CAETANO', 'AT CRUZEIRO                   ');
INSERT INTO cd_cep_br VALUES ('57.302-300', '23       ', 'R ANTONIO CAVALCANTE DE MAGALHAES', 'S LUIZ                        ');
INSERT INTO cd_cep_br VALUES ('57.305-190', '23       ', 'R ANTONIO CAVALCANTE GAMA', 'M TELES                       ');
INSERT INTO cd_cep_br VALUES ('57.305-230', '23       ', 'R ANTONIO CLARINDO', 'M TELES                       ');
INSERT INTO cd_cep_br VALUES ('57.307-450', '23       ', 'PC ANTONIO DE OLIVEIRA SILVA', 'JD ESPERANCA                  ');
INSERT INTO cd_cep_br VALUES ('57.307-600', '23       ', 'R ANTONIO ESTEVAO DA SILVA', 'JD ESPERANCA                  ');
INSERT INTO cd_cep_br VALUES ('57.305-080', '23       ', 'R ANTONIO ESTEVAO SOBRINHO', 'M TELES                       ');
INSERT INTO cd_cep_br VALUES ('57.313-600', '23       ', 'R ANTONIO EVANGELISTA DA SILVA', 'JD TROPICAL                   ');
INSERT INTO cd_cep_br VALUES ('57.305-040', '23       ', 'R ANTONIO FARIAS LEAL', 'M TELES                       ');
INSERT INTO cd_cep_br VALUES ('57.302-200', '23       ', 'R ANTONIO FELICIANO', 'CANAFISTULA                   ');
INSERT INTO cd_cep_br VALUES ('57.304-570', '23       ', 'R ANTONIO FELIZ SILVA', 'CACIMBAS                      ');
INSERT INTO cd_cep_br VALUES ('57.302-340', '23       ', 'R ANTONIO FERNANDES', 'N ESPERANCA                   ');
INSERT INTO cd_cep_br VALUES ('57.305-070', '23       ', 'R ANTONIO FERREIRA BARBOSA', 'M TELES                       ');
INSERT INTO cd_cep_br VALUES ('57.305-490', '23       ', 'R ANTONIO FERREIRA SAMPAIO', 'BAIXAO                        ');
INSERT INTO cd_cep_br VALUES ('57.308-520', '23       ', 'R ALOISIO TORRES DE OLIVEIRA', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('57.303-620', '23       ', 'R CIZINO DA COSTA GAMA', 'B VISTA                       ');
INSERT INTO cd_cep_br VALUES ('57.314-160', '23       ', 'R CLAUDENIA MARIA DE MELO LIMA', 'ITAPOA                        ');
INSERT INTO cd_cep_br VALUES ('57.314-150', '23       ', 'R CLAUDETE MARIA DE MELO', 'ITAPOA                        ');
INSERT INTO cd_cep_br VALUES ('57.301-220', '23       ', 'R CLAUDIO DE ALBUQUERQUE LIMA', 'O PRETO                       ');
INSERT INTO cd_cep_br VALUES ('57.303-060', '23       ', 'R CLETO MARQUES SILVA', 'S LUIZ                        ');
INSERT INTO cd_cep_br VALUES ('12.929-351', '4897     ', 'R PROJETADA A', 'JD PATURI                     ');
INSERT INTO cd_cep_br VALUES ('57.312-560', '23       ', 'R CLOVIS DE BARROS CORREIA', 'N HORIZONTE                   ');
INSERT INTO cd_cep_br VALUES ('57.313-340', '23       ', 'R COARACY DA MATA FONSECA', 'BRASILIA                      ');
INSERT INTO cd_cep_br VALUES ('57.308-160', '23       ', 'R COITE DO NOIA', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('57.313-710', '23       ', 'R COLETOR ATAIDE DE OLIVEIRA', 'BRASILIA                      ');
INSERT INTO cd_cep_br VALUES ('57.014-420', '54       ', 'R ANTONIO LINS FERREIRA LOPES', 'V LAGO                        ');
INSERT INTO cd_cep_br VALUES ('57.015-830', '54       ', 'R ANTONIO LISBOA DA SILVA', 'LEVADA                        ');
INSERT INTO cd_cep_br VALUES ('69.086-200', '156      ', 'R 19', 'S J OPERARIO                  ');
INSERT INTO cd_cep_br VALUES ('69.099-400', '156      ', 'R 19', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.043-181', '156      ', 'R 19', 'ALVORADA                      ');
INSERT INTO cd_cep_br VALUES ('69.038-291', '156      ', 'R 19', 'L VALE                        ');
INSERT INTO cd_cep_br VALUES ('69.097-752', '156      ', 'R 19 (CJ A MEDEIROS)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.038-460', '156      ', 'R 19 (CJ A MONTENEGRO)', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('69.055-370', '156      ', 'R 19 (CJ C BRANCO)', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.083-620', '156      ', 'R 19 (CJ C DO ALEIXO)', 'S J OPERARIO                  ');
INSERT INTO cd_cep_br VALUES ('69.097-100', '156      ', 'R 19 (CJ CANARANAS)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.068-470', '156      ', 'R 19 (CJ COSTA E SILVA)', 'RAIZ                          ');
INSERT INTO cd_cep_br VALUES ('69.049-530', '156      ', 'R 19 (CJ HILEIA II)', 'REDENCAO                      ');
INSERT INTO cd_cep_br VALUES ('69.044-660', '156      ', 'R 19 (CJ JD VERSALLES)', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('69.093-580', '156      ', 'R 19 (CJ MANOA)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.090-530', '156      ', 'R 19 (CJ MUNDO NOVO)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.077-200', '156      ', 'R 19 (CJ 31 DE MARCO I)', 'JAPIIM                        ');
INSERT INTO cd_cep_br VALUES ('69.094-190', '156      ', 'R 19 (NUCLEO 3)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.095-162', '156      ', 'TV 19 (RIACHO DOCE)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.098-210', '156      ', 'R 190 (NUCLEO 16)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.098-220', '156      ', 'R 191 (NUCLEO 16)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.098-000', '156      ', 'R 192 (NUCLEO 16)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.098-230', '156      ', 'R 193 (NUCLEO 16)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.098-240', '156      ', 'R 194 (NUCLEO 16)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.098-250', '156      ', 'R 195 (NUCLEO 16)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.098-261', '156      ', 'R 196 (NUCLEO 16)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.098-270', '156      ', 'R 197 (NUCLEO 16)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.098-280', '156      ', 'R 198 (NUCLEO 16)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.098-290', '156      ', 'R 199 (NUCLEO 16)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.067-051', '156      ', 'BC 2', 'PETROPOLIS                    ');
INSERT INTO cd_cep_br VALUES ('69.060-097', '156      ', 'BC 2', 'ALEIXO                        ');
INSERT INTO cd_cep_br VALUES ('69.067-180', '156      ', 'R 17 (CJ JD PETROPOLIS)', 'PETROPOLIS                    ');
INSERT INTO cd_cep_br VALUES ('69.044-640', '156      ', 'R 17 (CJ JD VERSALLES)', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('69.093-560', '156      ', 'R 17 (CJ MANOA)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.090-510', '156      ', 'R 17 (CJ MUNDO NOVO)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.028-416', '156      ', 'R 17 (CJ SUBTEN SRG P MILITAR)', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('69.077-180', '156      ', 'R 17 (CJ 31 DE MARCO I)', 'JAPIIM                        ');
INSERT INTO cd_cep_br VALUES ('69.094-170', '156      ', 'R 17 (NUCLEO 3)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.095-161', '156      ', 'TV 17 (RIACHO DOCE)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.098-010', '156      ', 'R 170 (NUCLEO 15)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.098-020', '156      ', 'R 171 (NUCLEO 15)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.098-030', '156      ', 'R 172 (NUCLEO 15)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.098-040', '156      ', 'R 173 (NUCLEO 15)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.098-050', '156      ', 'R 174 (NUCLEO 15)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.098-060', '156      ', 'R 175 (NUCLEO 15)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.098-070', '156      ', 'R 176 (NUCLEO 15)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.098-080', '156      ', 'R 177 (NUCLEO 15)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.098-090', '156      ', 'R 178 (NUCLEO 15)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.098-100', '156      ', 'R 179 (NUCLEO 15)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.086-190', '156      ', 'R 18', 'S J OPERARIO                  ');
INSERT INTO cd_cep_br VALUES ('69.099-390', '156      ', 'R 18', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.042-180', '156      ', 'R 18', 'ALVORADA                      ');
INSERT INTO cd_cep_br VALUES ('69.038-289', '156      ', 'R 18', 'L VALE                        ');
INSERT INTO cd_cep_br VALUES ('69.038-450', '156      ', 'R 18 (CJ A MONTENEGRO)', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('69.055-360', '156      ', 'R 18 (CJ C BRANCO)', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.083-610', '156      ', 'R 18 (CJ C DO ALEIXO)', 'S J OPERARIO                  ');
INSERT INTO cd_cep_br VALUES ('69.086-541', '156      ', 'R 18 (CJ CASTANHEIRA)', 'S J OPERARIO                  ');
INSERT INTO cd_cep_br VALUES ('69.068-460', '156      ', 'R 18 (CJ COSTA E SILVA)', 'RAIZ                          ');
INSERT INTO cd_cep_br VALUES ('69.049-340', '156      ', 'R 18 (CJ HILEIA I)', 'REDENCAO                      ');
INSERT INTO cd_cep_br VALUES ('69.049-520', '156      ', 'R 18 (CJ HILEIA II)', 'REDENCAO                      ');
INSERT INTO cd_cep_br VALUES ('69.067-181', '156      ', 'R 18 (CJ JD PETROPOLIS)', 'PETROPOLIS                    ');
INSERT INTO cd_cep_br VALUES ('69.044-650', '156      ', 'R 18 (CJ JD VERSALLES)', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('69.093-570', '156      ', 'R 18 (CJ MANOA)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.090-520', '156      ', 'R 18 (CJ MUNDO NOVO)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.095-813', '156      ', 'R 18 (CJ O FROTA I)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.028-417', '156      ', 'R 18 (CJ SUBTEN SRG P MILITAR)', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('69.077-190', '156      ', 'R 18 (CJ 31 DE MARCO I)', 'JAPIIM                        ');
INSERT INTO cd_cep_br VALUES ('69.094-180', '156      ', 'R 18 (NUCLEO 3)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.098-110', '156      ', 'R 180 (NUCLEO 15)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.099-380', '156      ', 'R 16 (A MENDES)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.038-430', '156      ', 'R 16 (CJ A MONTENEGRO)', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('69.055-340', '156      ', 'R 16 (CJ C BRANCO)', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.083-590', '156      ', 'R 16 (CJ C DO ALEIXO)', 'S J OPERARIO                  ');
INSERT INTO cd_cep_br VALUES ('69.086-531', '156      ', 'R 16 (CJ CASTANHEIRAS)', 'S J OPERARIO                  ');
INSERT INTO cd_cep_br VALUES ('69.068-440', '156      ', 'R 16 (CJ COSTA E SILVA)', 'RAIZ                          ');
INSERT INTO cd_cep_br VALUES ('69.049-500', '156      ', 'R 16 (CJ HILEIA II)', 'REDENCAO                      ');
INSERT INTO cd_cep_br VALUES ('69.067-170', '156      ', 'R 16 (CJ JD PETROPOLIS)', 'PETROPOLIS                    ');
INSERT INTO cd_cep_br VALUES ('69.044-630', '156      ', 'R 16 (CJ JD VERSALLES)', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('69.093-550', '156      ', 'R 16 (CJ MANOA)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.090-500', '156      ', 'R 16 (CJ MUNDO NOVO)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.028-415', '156      ', 'R 16 (CJ SUBTEN SRG P MILITAR)', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('69.083-231', '156      ', 'R 16 (CJ V CAMARA)', 'ALEIXO                        ');
INSERT INTO cd_cep_br VALUES ('69.077-170', '156      ', 'R 16 (CJ 31 DE MARCO I)', 'JAPIIM                        ');
INSERT INTO cd_cep_br VALUES ('69.090-561', '156      ', 'TV 16 (NUCLEO 1)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.094-160', '156      ', 'R 16 (NUCLEO 3)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.096-160', '156      ', 'R 160 (NUCLEO 7)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.096-170', '156      ', 'R 161 (NUCLEO 7)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.096-180', '156      ', 'R 162 (NUCLEO 7)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.096-070', '156      ', 'R 163 (NUCLEO 8)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.096-080', '156      ', 'R 164 (NUCLEO 8)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.096-090', '156      ', 'R 165 (NUCLEO 8)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.096-100', '156      ', 'R 166 (NUCLEO 8)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.096-110', '156      ', 'R 167 (NUCLEO 8)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.096-120', '156      ', 'R 168 (NUCLEO 8)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.096-130', '156      ', 'R 169 (NUCLEO 8)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.086-180', '156      ', 'R 17', 'S J OPERARIO                  ');
INSERT INTO cd_cep_br VALUES ('69.099-080', '156      ', 'R 17', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.042-170', '156      ', 'R 17', 'ALVORADA                      ');
INSERT INTO cd_cep_br VALUES ('69.038-288', '156      ', 'R 17', 'L VALE                        ');
INSERT INTO cd_cep_br VALUES ('69.038-440', '156      ', 'R 17 (CJ A MONTENEGRO)', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('69.055-350', '156      ', 'R 17 (CJ C BRANCO)', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.083-600', '156      ', 'R 17 (CJ C DO ALEIXO)', 'S J OPERARIO                  ');
INSERT INTO cd_cep_br VALUES ('69.097-090', '156      ', 'R 17 (CJ CANARANAS)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.086-540', '156      ', 'R 17 (CJ CASTANHEIRA)', 'S J OPERARIO                  ');
INSERT INTO cd_cep_br VALUES ('69.068-450', '156      ', 'R 17 (CJ COSTA E SILVA)', 'RAIZ                          ');
INSERT INTO cd_cep_br VALUES ('57.302-060', '23       ', 'R SANTA ISABEL', 'CANAFISTULA                   ');
INSERT INTO cd_cep_br VALUES ('57.311-140', '23       ', 'R SANTA LUZIA', 'S T VILELA                    ');
INSERT INTO cd_cep_br VALUES ('57.071-635', '54       ', 'TV ELIZEU GOMES DE SENA', 'A S DUMONT                    ');
INSERT INTO cd_cep_br VALUES ('57.071-630', '54       ', 'R ELIZEU GOMES DE SENA', 'A S DUMONT                    ');
INSERT INTO cd_cep_br VALUES ('57.071-805', '54       ', 'R ELMO NUNES DE CARVALHO', 'A S DUMONT                    ');
INSERT INTO cd_cep_br VALUES ('57.043-270', '54       ', 'R ELOI GOMES', 'FEITOSA                       ');
INSERT INTO cd_cep_br VALUES ('57.052-350', '54       ', 'R ELOI LEMOS DE FRANCA', 'G LOURDES                     ');
INSERT INTO cd_cep_br VALUES ('57.017-070', '54       ', 'R EMANOEL PEDRO DE FARIAS COSTA', 'B PARTO                       ');
INSERT INTO cd_cep_br VALUES ('57.042-310', '54       ', 'R EMERENTINO COSTA', 'FEITOSA                       ');
INSERT INTO cd_cep_br VALUES ('57.083-370', '54       ', 'R EMILIA NOVAES DE CASTRO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.022-055', '54       ', 'TV EMILIO CARDOSO FILHO', 'JARAGUA                       ');
INSERT INTO cd_cep_br VALUES ('57.015-720', '54       ', 'PC EMILIO DE MAIA', 'LEVADA                        ');
INSERT INTO cd_cep_br VALUES ('57.035-070', '54       ', 'PC EMILIO DE MAIA', 'P VERDE                       ');
INSERT INTO cd_cep_br VALUES ('57.042-290', '54       ', 'R EMPRESARIO ALOISIO BEZERRA', 'FEITOSA                       ');
INSERT INTO cd_cep_br VALUES ('57.043-070', '54       ', 'R EMPRESARIO ANTONIO LIMA MORAIS', 'FEITOSA                       ');
INSERT INTO cd_cep_br VALUES ('57.080-190', '54       ', 'R EMPRESARIO CARLOS CANSANCAO GUIMARAES', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.084-480', '54       ', 'R EMPRESARIO CARLOS CAVALCANTE BARBOSA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.036-540', '54       ', 'R EMPRESARIO CARLOS DA SILVA NOGUEIRA', 'JATIUCA                       ');
INSERT INTO cd_cep_br VALUES ('57.084-190', '54       ', 'R EMPRESARIO FLAVIO DE SOUZA LUZ', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.062-540', '54       ', 'AL EMPRESARIO JARSEN COSTA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.080-550', '54       ', 'R DOUTOR WENCESLAU LINDOSO DE ASSIS', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.051-280', '54       ', 'R DOUTOR ZAMENHOF', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.030-080', '54       ', 'R DOUTOR ZEFERINO RODRIGUES', 'PAJUCARA                      ');
INSERT INTO cd_cep_br VALUES ('57.031-110', '54       ', 'R EUCLIDES MEDEIROS GONCALVES', 'POCO                          ');
INSERT INTO cd_cep_br VALUES ('57.060-750', '54       ', 'R EUCLIDES PINAUD', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.018-300', '54       ', 'R EUCLIDES SANTOS', 'C JAQUEIRA                    ');
INSERT INTO cd_cep_br VALUES ('57.018-305', '54       ', 'TV EUCLIDES SANTOS', 'C JAQUEIRA                    ');
INSERT INTO cd_cep_br VALUES ('57.062-170', '54       ', 'AL EUCLIDES TAVARES', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.082-450', '54       ', 'R EUNICE LAVENERE', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.052-090', '54       ', 'R EURICO ACYOLE WANDERLEY', 'G LOURDES                     ');
INSERT INTO cd_cep_br VALUES ('57.045-440', '54       ', 'R EURICO MACIEL', 'B DURO                        ');
INSERT INTO cd_cep_br VALUES ('57.084-070', '54       ', 'R EURIDICE IVO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.062-090', '54       ', 'AL EURIDICE PLACIDO DE ARAUJO IVO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.072-360', '54       ', 'CJ EUSTAQUIO GOMES DE MELO I', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.072-370', '54       ', 'CJ EUSTAQUIO GOMES DE MELO II', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.036-170', '54       ', 'R EUTIMIO BERTOLO BRANDAO', 'JATIUCA                       ');
INSERT INTO cd_cep_br VALUES ('57.061-700', '54       ', 'R EUTIQUIO MEDEIROS(LOT CIPESA)', 'S AMELIA                      ');
INSERT INTO cd_cep_br VALUES ('57.075-100', '54       ', 'R EVERALDO CABRAL', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.072-500', '54       ', 'R EVERALDO CODA DOS SANTOS', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.071-745', '54       ', 'R EVERTON ESTEVAN', 'A S DUMONT                    ');
INSERT INTO cd_cep_br VALUES ('57.047-080', '54       ', 'R EVILASIO CANUTO MARQUES', 'SERRARIA                      ');
INSERT INTO cd_cep_br VALUES ('57.071-440', '54       ', 'R EX-COMBATENTE PHILADELPHO COUTINHO DE ARAUJO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.015-290', '54       ', 'R EXPEDICIONARIO BRASILEIRO', 'V LAGO                        ');
INSERT INTO cd_cep_br VALUES ('57.046-530', '54       ', 'R EXPEDICIONARIO JULIO GOMES DE SOUZA', 'B DURO                        ');
INSERT INTO cd_cep_br VALUES ('57.057-690', '54       ', 'R EZEQUIEL DA SILVA (CJ LIMA JUNIOR)', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.071-070', '54       ', 'R EZEQUIEL VALERIANO ROCHA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.014-150', '54       ', 'R FARMACEUTICO JOSE RODRIGUES DE OLIVEIRA', 'P GROSSA                      ');
INSERT INTO cd_cep_br VALUES ('57.071-760', '54       ', 'R FARMACEUTICO RUI CAMARA', 'A S DUMONT                    ');
INSERT INTO cd_cep_br VALUES ('57.017-740', '54       ', 'R FAUSTINO SILVEIRA', 'BEBEDOURO                     ');
INSERT INTO cd_cep_br VALUES ('57.050-790', '54       ', 'TV FAUSTINO SILVEIRA', 'PITANGUINHA                   ');
INSERT INTO cd_cep_br VALUES ('57.017-660', '54       ', 'R FAUSTO CALHEIROS WANDERLEY', 'B PARTO                       ');
INSERT INTO cd_cep_br VALUES ('57.055-420', '54       ', 'R FAUSTO CORREIA WANDERLEY', 'PINHEIRO                      ');
INSERT INTO cd_cep_br VALUES ('57.030-100', '54       ', 'R EPAMINONDAS GRACINDO', 'PAJUCARA                      ');
INSERT INTO cd_cep_br VALUES ('57.018-730', '54       ', 'R EPONINA GATTO FALCAO', 'C JAQUEIRA                    ');
INSERT INTO cd_cep_br VALUES ('69.057-810', '156      ', 'BC PENSADOR', 'ADRIANOPOLIS                  ');
INSERT INTO cd_cep_br VALUES ('57.039-500', '54       ', 'R ERALDO DUARTE CONSTANT', 'R DOCE                        ');
INSERT INTO cd_cep_br VALUES ('57.045-430', '54       ', 'AV ERALDO LINS CAVALCANTE', 'B DURO                        ');
INSERT INTO cd_cep_br VALUES ('57.057-090', '54       ', 'R ERASMO DE ALMEIDA PORANGABA', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.082-480', '54       ', 'AV ERASMO GOMES PORANGABA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.084-390', '54       ', 'AV ERASMO PEREIRA DA ROCHA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.083-530', '54       ', 'R ERIVAL RUFINO DE CASTRO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.010-390', '54       ', 'R ERNANDES BASTOS', 'P BARRA                       ');
INSERT INTO cd_cep_br VALUES ('57.062-490', '54       ', 'R ERNANDI DE ALBUQUERQUE SANTOS', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.046-630', '54       ', 'R ERNANI JONAS GOMES', 'SERRARIA                      ');
INSERT INTO cd_cep_br VALUES ('57.036-860', '54       ', 'R ERNESTO GOMES MARANHAO', 'JATIUCA                       ');
INSERT INTO cd_cep_br VALUES ('57.014-450', '54       ', 'R ERONILDES MEDEIROS BANDEIRA', 'V LAGO                        ');
INSERT INTO cd_cep_br VALUES ('57.071-340', '54       ', 'R ERONIR OLIVEIRA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.060-420', '54       ', 'R ERVANI DA ROCHA CAVALCANTI PASSOS', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.036-420', '54       ', 'R ESCRITOR ANTONIO SATURNINO DE MENDONCA JUNIOR', 'JATIUCA                       ');
INSERT INTO cd_cep_br VALUES ('57.081-430', '54       ', 'R ESCRITOR JAYME DE ALTAVILA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.030-490', '54       ', 'R ESCRITOR PAULINO SANTIAGO', 'POCO                          ');
INSERT INTO cd_cep_br VALUES ('57.030-495', '54       ', 'TV ESCRITOR PAULINO SANTIAGO', 'POCO                          ');
INSERT INTO cd_cep_br VALUES ('57.062-300', '54       ', 'AL ESCRITOR WALDEMAR CAVALCANTE', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.030-500', '54       ', 'R ESCRIVAO JOSE DE SOUZA', 'POCO                          ');
INSERT INTO cd_cep_br VALUES ('57.025-300', '54       ', 'R ESMERALDINO MARINHO SPINDOLA SOBRINHO', 'POCO                          ');
INSERT INTO cd_cep_br VALUES ('57.040-750', '54       ', 'R ESPERANCA', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.071-650', '54       ', 'R ESPERANCA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.039-600', '54       ', 'R ESPORTE, DO', 'SAUDE                         ');
INSERT INTO cd_cep_br VALUES ('57.072-420', '54       ', 'R ESTATISTICO JOSE MILTON B. MELO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.055-660', '54       ', 'R ESTATISTICO TEIXEIRA DE FREITAS', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.041-080', '54       ', 'R ESTER CAPARICA DA SILVA', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.051-290', '54       ', 'R ESTER SILVEIRA COSTA', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.015-080', '54       ', 'R ESTUDANTE AILSON DA ROCHA NOGUEIRA', 'V LAGO                        ');
INSERT INTO cd_cep_br VALUES ('57.036-560', '54       ', 'R ESTUDANTE ALEXANDRE GONCALVES SARMENTO', 'JATIUCA                       ');
INSERT INTO cd_cep_br VALUES ('57.060-060', '54       ', 'R ESTUDANTE ANA RUBIA COSTA ALMEIDA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.036-820', '54       ', 'R ESTUDANTE ANTONIO CARLOS DE MOURA GAMA', 'JATIUCA                       ');
INSERT INTO cd_cep_br VALUES ('57.060-430', '54       ', 'R ESTUDANTE ARNOUMAR CHAGAS', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.057-110', '54       ', 'R ESTUDANTE CARLOS ALBERTO ESTEVAO DE ARAUJO', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.081-150', '54       ', 'R ESTUDANTE DENINHO DAMASO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.060-070', '54       ', 'R ESTUDANTE JOSE DINIZ BINA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.072-350', '54       ', 'R ESTUDANTE JOSE MILTON BUARQUE DE MELO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.060-410', '54       ', 'R EMPRESARIO JOAO GOMES', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.084-120', '54       ', 'R EMPRESARIO JONAS NUTELS FILHO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.060-000', '54       ', 'AV EMPRESARIO JORGE DE BARROS', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.046-080', '54       ', 'R EMPRESARIO JORGE MONTENEGRO BARROS', 'B DURO                        ');
INSERT INTO cd_cep_br VALUES ('57.061-570', '54       ', 'R RAPHAEL PEREIRA DE AGUIAR', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.015-600', '54       ', 'R CABO REIS- ATE 107/108', 'P GROSSA                      ');
INSERT INTO cd_cep_br VALUES ('57.014-260', '54       ', 'R CABO REIS- DE 109/110 AO FIM', 'P GROSSA                      ');
INSERT INTO cd_cep_br VALUES ('57.040-230', '54       ', 'R CAETES', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.046-360', '54       ', 'R CAETES, DOS', 'SERRARIA                      ');
INSERT INTO cd_cep_br VALUES ('57.046-370', '54       ', 'R CAIAPOS, DOS', 'SERRARIA                      ');
INSERT INTO cd_cep_br VALUES ('57.084-560', '54       ', 'R CAINHA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.061-020', '54       ', 'R CAIO PORTO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.074-080', '54       ', 'R CAJUEIRO (LOT PARQUE DAS ARVORES)', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.015-030', '54       ', 'R CAJUEIRO, DO', 'V LAGO                        ');
INSERT INTO cd_cep_br VALUES ('57.045-820', '54       ', 'R CAJUEIRO, DO', 'O PRETO                       ');
INSERT INTO cd_cep_br VALUES ('57.045-825', '54       ', 'TV CAJUEIRO, DO', 'O PRETO                       ');
INSERT INTO cd_cep_br VALUES ('57.046-260', '54       ', 'CJ BETAVILLE', 'SERRARIA                      ');
INSERT INTO cd_cep_br VALUES ('57.045-040', '54       ', 'R BETEL', 'B DURO                        ');
INSERT INTO cd_cep_br VALUES ('57.082-650', '54       ', 'AV BETEL', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.025-440', '54       ', 'R BEZERRA DE MENEZES', 'POCO                          ');
INSERT INTO cd_cep_br VALUES ('57.075-210', '54       ', 'R BIANOR CAVALCANTE DE LIMA(RUA A4/A5 CJ OSMAN L', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.045-240', '54       ', 'R BOA ESPERANCA', 'B DURO                        ');
INSERT INTO cd_cep_br VALUES ('57.045-245', '54       ', 'TV BOA ESPERANCA', 'B DURO                        ');
INSERT INTO cd_cep_br VALUES ('57.014-270', '54       ', 'TV BOA ESPERANCA', 'P GROSSA                      ');
INSERT INTO cd_cep_br VALUES ('57.071-560', '54       ', 'R BOA ESPERANCA', 'A S DUMONT                    ');
INSERT INTO cd_cep_br VALUES ('57.043-570', '54       ', 'TV BOA ESPERANCA', 'FEITOSA                       ');
INSERT INTO cd_cep_br VALUES ('57.060-370', '54       ', 'R BOA SORTE', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.045-750', '54       ', 'R BOA SORTE', 'B DURO                        ');
INSERT INTO cd_cep_br VALUES ('57.011-200', '54       ', 'R BOA VIAGEM', 'T BARRA                       ');
INSERT INTO cd_cep_br VALUES ('57.018-030', '54       ', 'R BOA VISTA', 'BEBEDOURO                     ');
INSERT INTO cd_cep_br VALUES ('57.045-760', '54       ', 'R CICERO LEITE(ANTIGA RUA BOA VISTA)', 'B DURO                        ');
INSERT INTO cd_cep_br VALUES ('57.022-150', '54       ', 'AV CICERO TOLEDO', 'JARAGUA                       ');
INSERT INTO cd_cep_br VALUES ('57.015-760', '54       ', 'R CICERO TORRES', 'LEVADA                        ');
INSERT INTO cd_cep_br VALUES ('57.055-620', '54       ', 'R CICERO VASCONCELOS TORRES', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.025-620', '54       ', 'AV CID SCALA', 'POCO                          ');
INSERT INTO cd_cep_br VALUES ('57.046-780', '54       ', 'CJ CIDADE JARDIM', 'SERRARIA                      ');
INSERT INTO cd_cep_br VALUES ('57.072-340', '54       ', 'CJ CIDADE UNIVERSITARIA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.075-120', '54       ', 'R CIDADE UNIVERSITARIA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.020-050', '54       ', 'R CINCINATO PINTO', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.039-210', '54       ', 'R CINCO IRMAOS', 'R DOCE                        ');
INSERT INTO cd_cep_br VALUES ('57.031-350', '54       ', 'PC CIPRIANO JUCA', 'MANGABEIRAS                   ');
INSERT INTO cd_cep_br VALUES ('57.025-630', '54       ', 'TV CIPRIANO JUCA', 'POCO                          ');
INSERT INTO cd_cep_br VALUES ('57.015-650', '54       ', 'R CIRILO DE CASTRO', 'LEVADA                        ');
INSERT INTO cd_cep_br VALUES ('57.015-450', '54       ', 'PC CIRO ACYOLE', 'P GROSSA                      ');
INSERT INTO cd_cep_br VALUES ('57.057-490', '54       ', 'R CLARENCIO JUCA', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.040-590', '54       ', 'CJ CLAUDENOR SAMPAIO', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.040-260', '54       ', 'R CLAUDIA', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.061-640', '54       ', 'AV CLAUDIO BATINGA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.014-040', '54       ', 'CJ CARDOSO DA SILVA', 'P GROSSA                      ');
INSERT INTO cd_cep_br VALUES ('57.046-400', '54       ', 'R CARIJOS, DOS', 'SERRARIA                      ');
INSERT INTO cd_cep_br VALUES ('57.041-340', '54       ', 'R CARLINDO DE MIRANDA', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.041-670', '54       ', 'R CARLOMANO DE MIRANDA', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.082-690', '54       ', 'R CARLOS ALBERTO CHAGAS', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.075-220', '54       ', 'R CARLOS ALBERTO PITOMBO LARANJEIRAS(RUA 13 CJ O', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.020-760', '54       ', 'R CARLOS BASTOS DE OLIVEIRA', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.082-705', '54       ', 'TV CARLOS BUARQUE', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.082-700', '54       ', 'R CARLOS BUARQUE', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.082-320', '54       ', 'R CARLOS FRANCISCO DE FARIAS', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.025-450', '54       ', 'R CARLOS GOMES', 'POCO                          ');
INSERT INTO cd_cep_br VALUES ('57.036-450', '54       ', 'R CARLOS GOMES DA SILVA', 'JATIUCA                       ');
INSERT INTO cd_cep_br VALUES ('57.083-000', '54       ', 'AV CARLOS GOMES DE BARROS', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.075-230', '54       ', 'R CARLOS GUIDO FERRARIO LOBO(AV A CJ OSMAN LOURE', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.071-580', '54       ', 'R CARLOS HENRIQUE LINS', 'A S DUMONT                    ');
INSERT INTO cd_cep_br VALUES ('57.046-050', '54       ', 'R CARLOS JORGE CALHEIROS', 'SERRARIA                      ');
INSERT INTO cd_cep_br VALUES ('57.047-010', '54       ', 'R CARLOS JORGE VALENTE FERRO', 'SERRARIA                      ');
INSERT INTO cd_cep_br VALUES ('57.062-670', '54       ', 'R CARLOS LOBO MOREIRA BREDA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.082-210', '54       ', 'R CARLOS MILITO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.015-630', '54       ', 'LRG CARLOS PAURILIO', 'P GROSSA                      ');
INSERT INTO cd_cep_br VALUES ('57.036-460', '54       ', 'R CARLOS POVINA CAVALCANTE', 'JATIUCA                       ');
INSERT INTO cd_cep_br VALUES ('57.035-010', '54       ', 'R CARLOS TENORIO', 'P VERDE                       ');
INSERT INTO cd_cep_br VALUES ('57.046-690', '54       ', 'R CARLOS TENORIO DAS NEVES', 'SERRARIA                      ');
INSERT INTO cd_cep_br VALUES ('57.071-590', '54       ', 'R CARLOS VERISSIMO', 'A S DUMONT                    ');
INSERT INTO cd_cep_br VALUES ('57.062-180', '54       ', 'AL CARMELITA OMENA DE FARIAS', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.030-810', '54       ', 'LOT CARMINA TEIXEIRA', 'POCO                          ');
INSERT INTO cd_cep_br VALUES ('57.082-470', '54       ', 'LOT CARNAUBA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.071-510', '54       ', 'AV CARNAVALESCO JOSE TEOFANES', 'A S DUMONT                    ');
INSERT INTO cd_cep_br VALUES ('57.042-220', '54       ', 'R CAROLINA CALDAS NUNES', 'B VISTA                       ');
INSERT INTO cd_cep_br VALUES ('57.017-400', '54       ', 'R CARTEIRO JOAO FIRMINO', 'BEBEDOURO                     ');
INSERT INTO cd_cep_br VALUES ('57.081-510', '54       ', 'R CARTEIRO JOSE BARBOSA DA SILVA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.081-500', '54       ', 'R CARTEIRO JOSE LAURENTINO SILVA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.060-870', '54       ', 'R CARTEIRO ORSON LUIZ', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.030-470', '54       ', 'R CASSIANO DE ALBUQUERQUE', 'POCO                          ');
INSERT INTO cd_cep_br VALUES ('57.036-320', '54       ', 'CJ CASTELO BRANCO', 'JATIUCA                       ');
INSERT INTO cd_cep_br VALUES ('57.041-780', '54       ', 'CJ CASTELO BRANCO', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.025-460', '54       ', 'R CASTRO ALVES', 'POCO                          ');
INSERT INTO cd_cep_br VALUES ('57.081-490', '54       ', 'R CASTRO ALVES', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.011-330', '54       ', 'TV CALABAR', 'PRADO                         ');
INSERT INTO cd_cep_br VALUES ('57.017-390', '54       ', 'R CAMARAGIBE', 'BEBEDOURO                     ');
INSERT INTO cd_cep_br VALUES ('57.017-395', '54       ', 'TV CAMARAGIBE', 'BEBEDOURO                     ');
INSERT INTO cd_cep_br VALUES ('57.038-240', '54       ', 'R CAMARAGIBE', 'C ALMAS                       ');
INSERT INTO cd_cep_br VALUES ('57.045-660', '54       ', 'R CAMARAGIBE', 'O PRETO                       ');
INSERT INTO cd_cep_br VALUES ('57.080-650', '54       ', 'R CAMARAGIBE', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.048-140', '54       ', 'CJ CAMBUCI', 'SERRARIA                      ');
INSERT INTO cd_cep_br VALUES ('57.040-060', '54       ', 'R CAMPO ALEGRE', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.076-080', '54       ', 'LOT CAMPO DOS PALMARES', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.040-070', '54       ', 'R CAMPO VERDE', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.015-250', '54       ', 'R CAMPO VERDE', 'V LAGO                        ');
INSERT INTO cd_cep_br VALUES ('57.015-255', '54       ', 'TV CAMPO VERDE', 'V LAGO                        ');
INSERT INTO cd_cep_br VALUES ('57.071-570', '54       ', 'R CAMPO VERDE', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.018-290', '54       ', 'R CAMPO, DO', 'C JAQUEIRA                    ');
INSERT INTO cd_cep_br VALUES ('57.018-295', '54       ', 'TV CAMPO, DO', 'C JAQUEIRA                    ');
INSERT INTO cd_cep_br VALUES ('57.017-020', '54       ', 'R CAMPO, DO', 'B PARTO                       ');
INSERT INTO cd_cep_br VALUES ('57.057-040', '54       ', 'R CAMPO, DO', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.051-170', '54       ', 'TV CONSTITUICAO, DA', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.084-660', '54       ', 'AV CONTORNO PRF AURELIO BUARQUE DE HOLANDA(RES T', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.052-310', '54       ', 'R COQUEIROS, DOS', 'G LOURDES                     ');
INSERT INTO cd_cep_br VALUES ('57.039-420', '54       ', 'R COREIA, DA', 'R DOCE                        ');
INSERT INTO cd_cep_br VALUES ('57.017-430', '54       ', 'R MANOEL SAMPAIO', 'BEBEDOURO                     ');
INSERT INTO cd_cep_br VALUES ('57.017-435', '54       ', 'TV MANOEL SAMPAIO', 'BEBEDOURO                     ');
INSERT INTO cd_cep_br VALUES ('57.085-160', '54       ', 'AV ANTONIO LISBOA DE AMORIM(ANTIGA AVENIDA CACHOE', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.035-510', '54       ', 'TV ANTONIO MACIEL DE OLIVEIRA', 'P VERDE                       ');
INSERT INTO cd_cep_br VALUES ('57.057-450', '54       ', 'AL AMAPA', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('12.929-352', '4897     ', 'R PROJETADA B', 'JD PATURI                     ');
INSERT INTO cd_cep_br VALUES ('57.072-080', '54       ', 'R AMARILIO DE PAULA NOBLAT', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.041-320', '54       ', 'R AMARO FEITOSA', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.081-350', '54       ', 'R AMARO SALVADOR', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.010-060', '54       ', 'AV AMAZONAS', 'PRADO                         ');
INSERT INTO cd_cep_br VALUES ('57.043-450', '54       ', 'R AMAZONAS', 'FEITOSA                       ');
INSERT INTO cd_cep_br VALUES ('57.051-070', '54       ', 'R AMBROSIO LYRA', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.020-230', '54       ', 'R AMENDOEIRAS, DAS', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.039-170', '54       ', 'R AMERICO VASCO', 'R DOCE                        ');
INSERT INTO cd_cep_br VALUES ('57.010-230', '54       ', 'R AMINADAB VALENTE', 'T BARRA                       ');
INSERT INTO cd_cep_br VALUES ('57.045-010', '54       ', 'R AMIZADE, DA', 'B DURO                        ');
INSERT INTO cd_cep_br VALUES ('57.041-200', '54       ', 'R ANA DUARTE', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.061-150', '54       ', 'R ANA EMILIA DE ALENCAR', 'CANAA                         ');
INSERT INTO cd_cep_br VALUES ('57.061-155', '54       ', 'TV ANA EMILIA DE ALENCAR', 'CANAA                         ');
INSERT INTO cd_cep_br VALUES ('57.042-010', '54       ', 'R ANA LOPES CAHET', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.046-230', '54       ', 'R ANA LUCIA MOREIRA', 'B DURO                        ');
INSERT INTO cd_cep_br VALUES ('57.030-340', '54       ', 'R ANA NERI', 'PAJUCARA                      ');
INSERT INTO cd_cep_br VALUES ('57.018-270', '54       ', 'R ANA PAULA', 'BEBEDOURO                     ');
INSERT INTO cd_cep_br VALUES ('57.060-010', '54       ', 'R ANA SAMPAIO LINS', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.080-120', '54       ', 'R ANADIA', 'CANAA                         ');
INSERT INTO cd_cep_br VALUES ('57.017-330', '54       ', 'R ANAHY', 'BEBEDOURO                     ');
INSERT INTO cd_cep_br VALUES ('57.073-130', '54       ', 'AV ANDRE PAPINO GOIS', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.084-730', '54       ', 'R ANDRE TEIXEIRA DE MELO BRANDAO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.041-030', '54       ', 'R ANESIO PEREIRA BASTOS', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.042-160', '54       ', 'R ANGELINO FRANCISCO DA COSTA', 'B VISTA                       ');
INSERT INTO cd_cep_br VALUES ('57.030-230', '54       ', 'R ANGELO MARTINS', 'POCO                          ');
INSERT INTO cd_cep_br VALUES ('57.030-235', '54       ', 'TV ANGELO MARTINS', 'POCO                          ');
INSERT INTO cd_cep_br VALUES ('57.031-320', '54       ', 'R ANGELO MARTINS', 'PAJUCARA                      ');
INSERT INTO cd_cep_br VALUES ('57.070-460', '54       ', 'R ANIBAL CAVALCANTE PLACIDO', 'A S DUMONT                    ');
INSERT INTO cd_cep_br VALUES ('57.080-370', '54       ', 'R ANIBAL TORRES', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.018-240', '54       ', 'R ANISIO FREITAS COSTA', 'BEBEDOURO                     ');
INSERT INTO cd_cep_br VALUES ('57.039-180', '54       ', 'R ANIVALDO MONTEIRO DE CARVALHO', 'R DOCE                        ');
INSERT INTO cd_cep_br VALUES ('57.055-265', '54       ', 'R ANTENOR GOMES DE OLIVEIRA(ANTIGA TRAVESSA SANT', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.050-390', '54       ', 'R ANTENOR MARINHO DE MELO', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.011-010', '54       ', 'R ANTERO MEDEIROS', 'T BARRA                       ');
INSERT INTO cd_cep_br VALUES ('57.036-040', '54       ', 'R ANTONIA ALVES CARVALHO LEITE', 'JATIUCA                       ');
INSERT INTO cd_cep_br VALUES ('57.048-200', '54       ', 'R ANTONIA AUGUSTA ACIOLI', 'SERRARIA                      ');
INSERT INTO cd_cep_br VALUES ('57.030-240', '54       ', 'R ANTONIO AGUIAR', 'P TERRA                       ');
INSERT INTO cd_cep_br VALUES ('57.072-120', '54       ', 'R ALFREDO CAVALCANTI LIMA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.046-540', '54       ', 'R ALFREDO CORTEZ DE LUCENA', 'SERRARIA                      ');
INSERT INTO cd_cep_br VALUES ('57.075-400', '54       ', 'PC ARI ALVES DE OLIVEIRA(CONJUNTO OSMAN LOUREIRO)', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.062-290', '54       ', 'R ARIOSVALDO LOQUES DE MELO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.051-090', '54       ', 'AV ARISTEU DE ANDRADE', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.061-160', '54       ', 'R ARMANDO DE ARAUJO VASCONCELOS', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.055-810', '54       ', 'CJ ARMANDO LOBO', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.040-010', '54       ', 'R ARMANDO WUCHERER', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.039-540', '54       ', 'R ARMAZEM, DO', 'SAUDE                         ');
INSERT INTO cd_cep_br VALUES ('57.057-290', '54       ', 'R ARMINDO PEREIRA LEITE', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.038-590', '54       ', 'R ARNALDO BRAGA(RUA B LOT VILA RICA)', 'C ALMAS                       ');
INSERT INTO cd_cep_br VALUES ('57.073-570', '54       ', 'AV ARNON DE MELO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.080-660', '54       ', 'R ARNON DE MELO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.052-250', '54       ', 'R AROEIRA', 'G LOURDES                     ');
INSERT INTO cd_cep_br VALUES ('57.074-100', '54       ', 'R AROEIRA (LOT PARQUE DAS ARVORES)', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.052-020', '54       ', 'R ARQUITETO ASDRUBAL SARMENTO', 'G LOURDES                     ');
INSERT INTO cd_cep_br VALUES ('57.057-300', '54       ', 'R ARSENIO FORTES', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.057-305', '54       ', 'TV ARSENIO FORTES', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.036-050', '54       ', 'R ARTAGNAN MARTINS REIS', 'JATIUCA                       ');
INSERT INTO cd_cep_br VALUES ('57.039-040', '54       ', 'R ARTHUR BENIGNO LISBOA FERRAZ', 'JACARECICA                    ');
INSERT INTO cd_cep_br VALUES ('57.046-030', '54       ', 'R ARTHUR CASADO', 'SERRARIA                      ');
INSERT INTO cd_cep_br VALUES ('57.022-200', '54       ', 'TV ARTISTAS, DOS', 'JARAGUA                       ');
INSERT INTO cd_cep_br VALUES ('57.060-030', '54       ', 'TV ARTISTAS, DOS', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.057-020', '54       ', 'R ARTUR ACIOLY', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.036-060', '54       ', 'R ARTUR BULHOES', 'MANGABEIRAS                   ');
INSERT INTO cd_cep_br VALUES ('12.929-353', '4897     ', 'R PROJETADA C', 'JD PATURI                     ');
INSERT INTO cd_cep_br VALUES ('57.036-070', '54       ', 'R ARTUR CHARLES DORVILLE', 'JATIUCA                       ');
INSERT INTO cd_cep_br VALUES ('57.031-330', '54       ', 'LD ARTUR LOPES FERREIRA', 'MANGABEIRAS                   ');
INSERT INTO cd_cep_br VALUES ('57.052-030', '54       ', 'R ARTUR LOPES FERREIRA', 'G LOURDES                     ');
INSERT INTO cd_cep_br VALUES ('57.072-550', '54       ', 'R ARTUR MACEDO FRANCA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.042-200', '54       ', 'R ARTUR MAYER LEITE', 'FEITOSA                       ');
INSERT INTO cd_cep_br VALUES ('57.041-660', '54       ', 'R ARTUR SILVA PEIXOTO', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.052-260', '54       ', 'R ARTUR VITAL DA SILVA', 'G LOURDES                     ');
INSERT INTO cd_cep_br VALUES ('57.036-410', '54       ', 'R ANTONIO MAGALHAES', 'JATIUCA                       ');
INSERT INTO cd_cep_br VALUES ('57.083-020', '54       ', 'R ANTONIO MAURICIO COSTA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.050-670', '54       ', 'R ANTONIO MENEZES DE ARAUJO LEMOS', 'G LOURDES                     ');
INSERT INTO cd_cep_br VALUES ('57.060-020', '54       ', 'R ANTONIO MONTEIRO DE CARVALHO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.042-180', '54       ', 'R ANTONIO MORAES COSTA', 'B VISTA                       ');
INSERT INTO cd_cep_br VALUES ('57.055-370', '54       ', 'R ANTONIO MURTA', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.051-080', '54       ', 'R ANTONIO NETO', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.084-170', '54       ', 'R ANTONIO PALMARY SORIANO DE MELO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.071-285', '54       ', 'R ANTONIO PIMENTEL SANTOS (CJ JARDIM DO PLANALTO', 'A S DUMONT                    ');
INSERT INTO cd_cep_br VALUES ('57.060-810', '54       ', 'R ANTONIO PINTO PIMENTEL', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.038-180', '54       ', 'R ANTONIO PROCOPIO', 'C ALMAS                       ');
INSERT INTO cd_cep_br VALUES ('57.057-460', '54       ', 'R ANTONIO PROCOPIO', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.042-020', '54       ', 'R ANTONIO REGINALDO PONTES LIMA', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.083-180', '54       ', 'R ANTONIO RIBEIRO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.011-170', '54       ', 'PC ANTONIO RODRIGUES RAMALHO', 'T BARRA                       ');
INSERT INTO cd_cep_br VALUES ('57.082-260', '54       ', 'R ANTONIO SEBASTIAO DA SILVA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.075-170', '54       ', 'R ANTONIO SILVA(RUA A-9 CJ OSMAN LOUREIRO)', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.062-030', '54       ', 'AL ANTONIO VIEIRA COSTA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.083-450', '54       ', 'R ANTONIO VIEIRA FILHO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.042-030', '54       ', 'R ANTONIO ZEFERINO DOS SANTOS', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.030-460', '54       ', 'R ANTOZANO VICENTE DA SILVA', 'P TERRA                       ');
INSERT INTO cd_cep_br VALUES ('57.042-040', '54       ', 'R APOLONIO ROCHA DOS SANTOS', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.081-240', '54       ', 'R APORE', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.031-020', '54       ', 'R APRIGIO FRANCISCO DE SOUZA', 'POCO                          ');
INSERT INTO cd_cep_br VALUES ('57.081-330', '54       ', 'R AQUIDAUANA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.010-410', '54       ', 'R JORNALISTA OSEAS ROSAS', 'T BARRA                       ');
INSERT INTO cd_cep_br VALUES ('57.080-070', '54       ', 'R JORNALISTA PEDRO AFFONSO COLLOR DE MELLO', 'CANAA                         ');
INSERT INTO cd_cep_br VALUES ('57.310-380', '23       ', 'R SANTA LUZIA', 'CANAFISTULA                   ');
INSERT INTO cd_cep_br VALUES ('57.308-240', '23       ', 'R SANTA LUZIA DO NORTE', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('57.310-080', '23       ', 'R SANTA MADALENA', 'BRASILIANA                    ');
INSERT INTO cd_cep_br VALUES ('57.312-460', '23       ', 'R SANTA MARIA', 'AT CRUZEIRO                   ');
INSERT INTO cd_cep_br VALUES ('57.306-240', '23       ', 'R SANTA MONICA', 'ELDORADO                      ');
INSERT INTO cd_cep_br VALUES ('57.313-000', '23       ', 'R SANTA RITA', 'AT CRUZEIRO                   ');
INSERT INTO cd_cep_br VALUES ('57.301-360', '23       ', 'PC SANTA ROSA', 'O PRETO                       ');
INSERT INTO cd_cep_br VALUES ('57.307-730', '23       ', 'R SANTA TEREZA', 'BX GRANDE                     ');
INSERT INTO cd_cep_br VALUES ('57.300-460', '23       ', 'R SANTA TEREZINHA', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.311-190', '23       ', 'R SANTO AMARO', 'AT CRUZEIRO                   ');
INSERT INTO cd_cep_br VALUES ('57.301-100', '23       ', 'R SANTO ANTONIO', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.305-420', '23       ', 'R SANTOS DUMONT', 'BAIXAO                        ');
INSERT INTO cd_cep_br VALUES ('57.308-150', '23       ', 'R SAO BRAS', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('57.304-400', '23       ', 'R SAO CRISTOVAO', 'PRIMAVERA                     ');
INSERT INTO cd_cep_br VALUES ('57.300-240', '23       ', 'R SAO DOMINGOS', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.306-470', '23       ', 'R SAO DOMINGOS', 'CAVACO                        ');
INSERT INTO cd_cep_br VALUES ('57.300-080', '23       ', 'R SAO FRANCISCO- ATE 781/826', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.301-110', '23       ', 'R SAO FRANCISCO- DE 783/828 AO FIM', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.311-150', '23       ', 'R SAO GERALDO', 'S T VILELA                    ');
INSERT INTO cd_cep_br VALUES ('57.311-000', '23       ', 'R SAO JOAO', 'AT CRUZEIRO                   ');
INSERT INTO cd_cep_br VALUES ('57.311-170', '23       ', 'R SAO JORGE', 'AT CRUZEIRO                   ');
INSERT INTO cd_cep_br VALUES ('57.311-050', '23       ', 'R SAO JOSE', 'AT CRUZEIRO                   ');
INSERT INTO cd_cep_br VALUES ('57.073-560', '54       ', 'AV ALFREDO ABREU', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.310-090', '23       ', 'R VINTE E UM DE MAIO', 'BRASILIANA                    ');
INSERT INTO cd_cep_br VALUES ('57.303-100', '23       ', 'AV VIRGILIO VIEIRA DA ROCHA', 'S LUIZ                        ');
INSERT INTO cd_cep_br VALUES ('57.304-160', '23       ', 'R WALMIR NOVAES', 'PRIMAVERA                     ');
INSERT INTO cd_cep_br VALUES ('57.306-110', '23       ', 'R WALTER BEZERRA', 'ELDORADO                      ');
INSERT INTO cd_cep_br VALUES ('57.307-400', '23       ', 'R WOLFGANG AMADEUS MOZART', 'JD ESPERANCA                  ');
INSERT INTO cd_cep_br VALUES ('57.300-410', '23       ', 'R ZEFERINO MAGALHAES', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.310-070', '23       ', 'R ZEFERINO P. SILVA', 'BRASILIANA                    ');
INSERT INTO cd_cep_br VALUES ('57.036-010', '54       ', 'R ABDON ASSIS INOJOSA ANDRADE', 'JATIUCA                       ');
INSERT INTO cd_cep_br VALUES ('57.030-710', '54       ', 'R ABDON MONTEIRO', 'POCO                          ');
INSERT INTO cd_cep_br VALUES ('57.051-010', '54       ', 'R ABELARDO CARDOSO DA SILVA', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.036-020', '54       ', 'R ABELARDO PUGLIESE', 'JATIUCA                       ');
INSERT INTO cd_cep_br VALUES ('57.037-330', '54       ', 'R ABILIO VITORINO', 'JATIUCA                       ');
INSERT INTO cd_cep_br VALUES ('57.062-520', '54       ', 'AL ACADEMICO ALEXANDRE ELIAS DE ALBUQUERQUE', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.037-140', '54       ', 'PC ACADEMICO CRISTIANO OMENA CALHEIROS', 'JATIUCA                       ');
INSERT INTO cd_cep_br VALUES ('57.080-180', '54       ', 'PC ACADEMICO GUSTAVO DE ARAUJO AMORIM', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.062-100', '54       ', 'AL ACADEMICO JOAO MAURICIO MAURO SIMONS', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.037-300', '54       ', 'R ACADEMICO JOSE LUIZ COSTA LOBO', 'JATIUCA                       ');
INSERT INTO cd_cep_br VALUES ('57.010-010', '54       ', 'R ACADEMICO JOSE MACEDO DE FRANCA', 'PRADO                         ');
INSERT INTO cd_cep_br VALUES ('57.051-020', '54       ', 'PC ACADEMICO MAX DE ANDRADE LYRA', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.046-010', '54       ', 'R ACADEMICO MAX DE ANDRADE LYRA', 'SERRARIA                      ');
INSERT INTO cd_cep_br VALUES ('57.081-220', '54       ', 'R ACARAU', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.073-350', '54       ', 'LOT ACAUA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.043-230', '54       ', 'R ACRE', 'FEITOSA                       ');
INSERT INTO cd_cep_br VALUES ('57.043-235', '54       ', 'TV ACRE', 'FEITOSA                       ');
INSERT INTO cd_cep_br VALUES ('57.057-440', '54       ', 'AL ACRE', 'PINHEIRO                      ');
INSERT INTO cd_cep_br VALUES ('57.017-250', '54       ', 'R ADAO PEREIRA DE GUSMAO', 'B PARTO                       ');
INSERT INTO cd_cep_br VALUES ('57.045-670', '54       ', 'R ADEILDO NEPOMUCENO', 'B DURO                        ');
INSERT INTO cd_cep_br VALUES ('57.014-265', '54       ', 'VL ADELAIDE', 'P GROSSA                      ');
INSERT INTO cd_cep_br VALUES ('57.046-020', '54       ', 'R ADELAIDE DE MELO MOTA', 'B DURO                        ');
INSERT INTO cd_cep_br VALUES ('57.043-010', '54       ', 'R ADELMO DE MELO', 'FEITOSA                       ');
INSERT INTO cd_cep_br VALUES ('57.043-020', '54       ', 'R ADEMAR MEDEIROS', 'FEITOSA                       ');
INSERT INTO cd_cep_br VALUES ('57.057-280', '54       ', 'R ADOLFO CAMERINO', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.057-285', '54       ', 'TV ADOLFO CAMERINO', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.051-030', '54       ', 'LD ADOLFO GUIMARAES', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.045-340', '54       ', 'R ADOLFO GUSTAVO', 'B DURO                        ');
INSERT INTO cd_cep_br VALUES ('57.039-710', '54       ', 'R ADOLFO MARQUES', 'F PEIXOTO                     ');
INSERT INTO cd_cep_br VALUES ('57.018-815', '54       ', 'TV ADRIANA', 'C JAQUEIRA                    ');
INSERT INTO cd_cep_br VALUES ('57.082-220', '54       ', 'R ADRIANO MAGALHAES', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.310-300', '23       ', 'R TEREZA ALBUQUERQUE', 'R CRUZ                        ');
INSERT INTO cd_cep_br VALUES ('57.305-440', '23       ', 'R TEREZA ANGELINA DE ALBUQUERQUE', 'BAIXAO                        ');
INSERT INTO cd_cep_br VALUES ('57.303-210', '23       ', 'R TEREZINHA DE JESUS GOMES', 'JD ESPERANCA                  ');
INSERT INTO cd_cep_br VALUES ('57.301-430', '23       ', 'PC TERTULIANO BARBOSA', 'JD TROPICAL                   ');
INSERT INTO cd_cep_br VALUES ('57.302-160', '23       ', 'R TERTULIANO BARBOSA LEITE', 'CANAFISTULA                   ');
INSERT INTO cd_cep_br VALUES ('57.308-010', '23       ', 'R TERTULIANO BERNARDO DE OLIVEIRA', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('57.303-020', '23       ', 'R THEO BRANDAO VILELA', 'S LUIZ                        ');
INSERT INTO cd_cep_br VALUES ('57.301-120', '23       ', 'R TIBURCIO MAGALHAES', 'O PRETO                       ');
INSERT INTO cd_cep_br VALUES ('57.307-740', '23       ', 'R TIBURCIO VALERIANO', 'JD ESPERANCA                  ');
INSERT INTO cd_cep_br VALUES ('57.305-340', '23       ', 'R TIRADENTES', 'BAIXAO                        ');
INSERT INTO cd_cep_br VALUES ('57.308-660', '23       ', 'R TRAIPU', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('57.300-380', '23       ', 'R TRINTA DE OUTUBRO', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.304-370', '23       ', 'R TRINTA E UM DE MARCO', 'PRIMAVERA                     ');
INSERT INTO cd_cep_br VALUES ('57.304-650', '23       ', 'R ULISSES PEREIRA DE OLIVEIRA', 'CACIMBAS                      ');
INSERT INTO cd_cep_br VALUES ('57.308-210', '23       ', 'R UNIAO DOS PALMARES', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('57.305-460', '23       ', 'R UNIAO DOS PALMARES', 'BAIXAO                        ');
INSERT INTO cd_cep_br VALUES ('57.304-680', '23       ', 'R VALDIR OLIVEIRA', 'CACIMBAS                      ');
INSERT INTO cd_cep_br VALUES ('57.306-480', '23       ', 'R VALFREDO DE OLIVEIRA', 'CAVACO                        ');
INSERT INTO cd_cep_br VALUES ('57.313-690', '23       ', 'R VALFRIDO DE OLIVEIRA LIMA', 'BRASILIA                      ');
INSERT INTO cd_cep_br VALUES ('57.304-600', '23       ', 'R VANIA LIMA FRANCA', 'CACIMBAS                      ');
INSERT INTO cd_cep_br VALUES ('57.307-150', '23       ', 'R VENALDO ROBERTO PESSOA VEIGA', 'BX GRANDE                     ');
INSERT INTO cd_cep_br VALUES ('57.305-470', '23       ', 'R VENTURA DE FARIAS', 'BAIXAO                        ');
INSERT INTO cd_cep_br VALUES ('57.308-690', '23       ', 'R VERA MARIA DE OLIVEIRA REZENDE', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('57.308-450', '23       ', 'AV VEREADOR ALIPIO DE OLIVEIRA CALDAS', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('57.313-370', '23       ', 'R VEREADOR ANTONIO JUVINO', 'BRASILIA                      ');
INSERT INTO cd_cep_br VALUES ('57.304-510', '23       ', 'R VEREADOR BENICIO ALVES DE OLIVEIRA', 'CACIMBAS                      ');
INSERT INTO cd_cep_br VALUES ('57.311-410', '23       ', 'R VEREADOR DOMINGOS VITAL', 'AT CRUZEIRO                   ');
INSERT INTO cd_cep_br VALUES ('57.312-570', '23       ', 'R VEREADOR EVOLIDES FELICIANO DA SILVA', 'N HORIZONTE                   ');
INSERT INTO cd_cep_br VALUES ('12.910-003', '4897     ', 'R PROJETADA DOIS', 'JD LARANJEIRAS                ');
INSERT INTO cd_cep_br VALUES ('57.303-120', '23       ', 'AV VEREADOR JOAO SATURNINO DE ALMEIDA', 'B VISTA                       ');
INSERT INTO cd_cep_br VALUES ('57.308-590', '23       ', 'R VEREADOR JOSE OLIVEIRA E SILVA', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('57.313-230', '23       ', 'R VEREADOR JOSE PROTASIO NETO', 'BRASILIA                      ');
INSERT INTO cd_cep_br VALUES ('57.308-330', '23       ', 'R VEREADOR LOURENCO DE ALMEIDA', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('57.308-560', '23       ', 'R VICENTE FLOR FERREIRA', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('57.304-530', '23       ', 'R VICENTE LEITE DA SILVA', 'CACIMBAS                      ');
INSERT INTO cd_cep_br VALUES ('57.039-020', '54       ', 'CJ ALFREDO GASPAR DE MENDONCA', 'JACARECICA                    ');
INSERT INTO cd_cep_br VALUES ('57.041-300', '54       ', 'R ALFREDO MARSIGLIA', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.038-010', '54       ', 'R ALFREDO OITICICA', 'MANGABEIRAS                   ');
INSERT INTO cd_cep_br VALUES ('57.046-840', '54       ', 'R CRUZEIRO DO SUL', 'B DURO                        ');
INSERT INTO cd_cep_br VALUES ('57.015-060', '54       ', 'TV CRUZEIRO, DO', 'V LAGO                        ');
INSERT INTO cd_cep_br VALUES ('69.038-780', '156      ', 'R 06 (CJ V BELA)', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('69.083-400', '156      ', 'R 06 (CJ V CAMARA)', 'ALEIXO                        ');
INSERT INTO cd_cep_br VALUES ('69.057-740', '156      ', 'R 06 (CJ V MUNICIPAL)', 'ADRIANOPOLIS                  ');
INSERT INTO cd_cep_br VALUES ('69.077-071', '156      ', 'R 06 (CJ 31 DE MARCO I)', 'JAPIIM                        ');
INSERT INTO cd_cep_br VALUES ('69.090-720', '156      ', 'R 06 (NUCLEO 1)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.040-615', '156      ', 'R 06 (PRQ ARIPUANA)', 'D PEDRO                       ');
INSERT INTO cd_cep_br VALUES ('69.054-737', '156      ', 'R 06 (SHANGRILA IV)', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.035-796', '156      ', 'R 06 (VL MARINHO)', 'COMPENSA                      ');
INSERT INTO cd_cep_br VALUES ('69.043-160', '156      ', 'R 06 ATE 253/260', 'ALVORADA                      ');
INSERT INTO cd_cep_br VALUES ('69.042-060', '156      ', 'R 07- DE 133/134 AO FIM', 'ALVORADA                      ');
INSERT INTO cd_cep_br VALUES ('69.038-340', '156      ', 'R 07 (CJ A MONTENEGRO)', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('69.054-430', '156      ', 'R 07 (CJ B BELA)', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.028-333', '156      ', 'R 07 (CJ B FLOR II)', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('69.055-250', '156      ', 'R 07 (CJ C BRANCO)', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.083-500', '156      ', 'R 07 (CJ C DO ALEIXO)', 'S J OPERARIO                  ');
INSERT INTO cd_cep_br VALUES ('69.097-040', '156      ', 'R 07 (CJ CANARANAS)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.086-460', '156      ', 'R 07 (CJ CASTANHEIRA)', 'S J OPERARIO                  ');
INSERT INTO cd_cep_br VALUES ('69.068-350', '156      ', 'R 07 (CJ COSTA E SILVA)', 'RAIZ                          ');
INSERT INTO cd_cep_br VALUES ('69.060-180', '156      ', 'R 07 (CJ H ANGELIN)', 'ALEIXO                        ');
INSERT INTO cd_cep_br VALUES ('69.049-230', '156      ', 'R 07 (CJ HILEIA I)', 'REDENCAO                      ');
INSERT INTO cd_cep_br VALUES ('69.049-410', '156      ', 'R 07 (CJ HILEIA II)', 'REDENCAO                      ');
INSERT INTO cd_cep_br VALUES ('69.054-280', '156      ', 'R 07 (CJ JD PRIMAVERA)', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.044-540', '156      ', 'R 07 (CJ JD VERSALLES)', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('69.093-460', '156      ', 'R 07 (CJ MANOA)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.090-410', '156      ', 'R 07 (CJ MUNDO NOVO)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.054-080', '156      ', 'R 07 (CJ N FRIBURGO)', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.028-307', '156      ', 'R 07 (CJ R MARACANA)', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('69.090-660', '156      ', 'R 07 (CJ R S PINTO I)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.093-440', '156      ', 'R 05 (CJ MANOA)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.090-390', '156      ', 'R 05 (CJ MUNDO NOVO)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.054-060', '156      ', 'R 05 (CJ N FRIBURGO)', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.028-305', '156      ', 'R 05 (CJ R MARACANA)', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('69.090-640', '156      ', 'R 05 (CJ R S PINTO I)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.036-400', '156      ', 'R 05 (CJ R XINGU)', 'COMPENSA                      ');
INSERT INTO cd_cep_br VALUES ('69.028-404', '156      ', 'R 05 (CJ SUBTEN SRG P MILITAR)', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('69.055-744', '156      ', 'R 05 (CJ TROPICAL)', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.038-770', '156      ', 'R 05 (CJ V BELA)', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('69.083-390', '156      ', 'R 05 (CJ V CAMARA)', 'ALEIXO                        ');
INSERT INTO cd_cep_br VALUES ('69.057-730', '156      ', 'R 05 (CJ V MUNICIPAL)', 'ADRIANOPOLIS                  ');
INSERT INTO cd_cep_br VALUES ('69.077-060', '156      ', 'R 05 (CJ 31 DE MARCO I)', 'JAPIIM                        ');
INSERT INTO cd_cep_br VALUES ('69.093-265', '156      ', 'R 05 (M SINAI)', 'COL S ANTONIO                 ');
INSERT INTO cd_cep_br VALUES ('69.090-590', '156      ', 'R 05 (NUCLEO 1)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.040-614', '156      ', 'R 05 (PRQ ARIPUANA)', 'D PEDRO                       ');
INSERT INTO cd_cep_br VALUES ('69.054-736', '156      ', 'R 05 (SHANGRILA IV)', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.035-795', '156      ', 'R 05 (VL MARINHO)', 'COMPENSA                      ');
INSERT INTO cd_cep_br VALUES ('69.043-130', '156      ', 'R 05 ATE 299/312', 'ALVORADA                      ');
INSERT INTO cd_cep_br VALUES ('69.086-070', '156      ', 'R 06', 'S J OPERARIO                  ');
INSERT INTO cd_cep_br VALUES ('69.040-130', '156      ', 'R 06', 'D PEDRO                       ');
INSERT INTO cd_cep_br VALUES ('69.039-725', '156      ', 'R 06', 'N ISRAEL                      ');
INSERT INTO cd_cep_br VALUES ('69.028-344', '156      ', 'TV 06', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('69.038-276', '156      ', 'R 06', 'L VALE                        ');
INSERT INTO cd_cep_br VALUES ('69.042-070', '156      ', 'R 06- DE 255/262 AO FIM', 'ALVORADA                      ');
INSERT INTO cd_cep_br VALUES ('69.038-330', '156      ', 'R 06 (CJ A MONTENEGRO)', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('69.054-420', '156      ', 'R 06 (CJ B BELA)', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.055-240', '156      ', 'R 06 (CJ C BRANCO)', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.083-490', '156      ', 'R 06 (CJ C DO ALEIXO)', 'S J OPERARIO                  ');
INSERT INTO cd_cep_br VALUES ('69.086-450', '156      ', 'R 06 (CJ CASTANHEIRA)', 'S J OPERARIO                  ');
INSERT INTO cd_cep_br VALUES ('69.068-340', '156      ', 'R 06 (CJ COSTA E SILVA)', 'RAIZ                          ');
INSERT INTO cd_cep_br VALUES ('69.097-772', '156      ', 'R 06 (CJ F MENDES I)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.060-181', '156      ', 'R 06 (CJ H ANGELIN)', 'ALEIXO                        ');
INSERT INTO cd_cep_br VALUES ('69.049-220', '156      ', 'R 06 (CJ HILEIA I)', 'REDENCAO                      ');
INSERT INTO cd_cep_br VALUES ('69.049-400', '156      ', 'R 06 (CJ HILEIA II)', 'REDENCAO                      ');
INSERT INTO cd_cep_br VALUES ('69.054-270', '156      ', 'R 06 (CJ JD PRIMAVERA)', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.044-530', '156      ', 'R 06 (CJ JD VERSALLES)', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('69.093-450', '156      ', 'R 06 (CJ MANOA)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.090-400', '156      ', 'R 06 (CJ MUNDO NOVO)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.044-510', '156      ', 'R 04 (CJ JD VERSALLES)', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('69.093-430', '156      ', 'R 04 (CJ MANOA)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.090-380', '156      ', 'R 04 (CJ MUNDO NOVO)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.054-050', '156      ', 'R 04 (CJ N FRIBURGO)', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.028-304', '156      ', 'R 04 (CJ R MARACANA)', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('69.090-630', '156      ', 'R 04 (CJ R S PINTO I)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.036-390', '156      ', 'R 04 (CJ R XINGU)', 'COMPENSA                      ');
INSERT INTO cd_cep_br VALUES ('69.028-403', '156      ', 'R 04 (CJ SUBTEN SRG P MILITAR)', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('69.055-743', '156      ', 'R 04 (CJ TROPICAL)', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.038-760', '156      ', 'R 04 (CJ V BELA)', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('69.083-380', '156      ', 'R 04 (CJ V CAMARA)', 'ALEIXO                        ');
INSERT INTO cd_cep_br VALUES ('69.057-720', '156      ', 'R 04 (CJ V MUNICIPAL)', 'ADRIANOPOLIS                  ');
INSERT INTO cd_cep_br VALUES ('69.077-050', '156      ', 'R 04 (CJ 31 DE MARCO I)', 'JAPIIM                        ');
INSERT INTO cd_cep_br VALUES ('69.090-580', '156      ', 'R 04 (NUCLEO 1)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.040-613', '156      ', 'R 04 (PRQ ARIPUANA)', 'D PEDRO                       ');
INSERT INTO cd_cep_br VALUES ('69.054-735', '156      ', 'R 04 (SHANGRILA IV)', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.035-794', '156      ', 'R 04 (VL MARINHO)', 'COMPENSA                      ');
INSERT INTO cd_cep_br VALUES ('69.043-150', '156      ', 'R 04 ATE 419/420', 'ALVORADA                      ');
INSERT INTO cd_cep_br VALUES ('69.040-120', '156      ', 'R 05', 'D PEDRO                       ');
INSERT INTO cd_cep_br VALUES ('69.086-060', '156      ', 'R 05', 'S J OPERARIO                  ');
INSERT INTO cd_cep_br VALUES ('69.039-724', '156      ', 'R 05', 'N ISRAEL                      ');
INSERT INTO cd_cep_br VALUES ('69.093-385', '156      ', 'R 05', 'COL S ANTONIO                 ');
INSERT INTO cd_cep_br VALUES ('69.028-343', '156      ', 'TV 05', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('69.038-275', '156      ', 'R 05', 'L VALE                        ');
INSERT INTO cd_cep_br VALUES ('69.042-010', '156      ', 'R 05- DE 301/314 AO FIM', 'ALVORADA                      ');
INSERT INTO cd_cep_br VALUES ('69.038-320', '156      ', 'R 05 (CJ A MONTENEGRO)', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('69.054-410', '156      ', 'R 05 (CJ B BELA)', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.055-230', '156      ', 'R 05 (CJ C BRANCO)', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.083-480', '156      ', 'R 05 (CJ C DO ALEIXO)', 'S J OPERARIO                  ');
INSERT INTO cd_cep_br VALUES ('69.048-650', '156      ', 'R 05 (CJ CANAA)', 'ALVORADA                      ');
INSERT INTO cd_cep_br VALUES ('69.097-030', '156      ', 'R 05 (CJ CANARANAS)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.086-440', '156      ', 'R 05 (CJ CASTANHEIRA)', 'S J OPERARIO                  ');
INSERT INTO cd_cep_br VALUES ('69.068-330', '156      ', 'R 05 (CJ COSTA E SILVA)', 'RAIZ                          ');
INSERT INTO cd_cep_br VALUES ('57.307-500', '23       ', 'PC LIVINO NUNES DE ALBUQUERQUE', 'JD ESPERANCA                  ');
INSERT INTO cd_cep_br VALUES ('69.082-456', '156      ', 'R P (PRQ SUCUPIRAS)', 'COROADO                       ');
INSERT INTO cd_cep_br VALUES ('69.054-753', '156      ', 'R P (SHANGRILA VII)', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.060-069', '156      ', 'R P/O (CJ M DO SOL)', 'ALEIXO                        ');
INSERT INTO cd_cep_br VALUES ('69.067-371', '156      ', 'BC PACIENCIA', 'PETROPOLIS                    ');
INSERT INTO cd_cep_br VALUES ('69.070-440', '156      ', 'BC PACIENCIA, DA', 'EDUCANDOS                     ');
INSERT INTO cd_cep_br VALUES ('69.080-051', '156      ', 'BC PACIENCIA, DA', 'COROADO                       ');
INSERT INTO cd_cep_br VALUES ('69.063-582', '156      ', 'BC PACIENCIA, DA', 'PETROPOLIS                    ');
INSERT INTO cd_cep_br VALUES ('69.088-330', '156      ', 'R PACU', 'J TEIXEIRA                    ');
INSERT INTO cd_cep_br VALUES ('69.035-090', '156      ', 'EST PADRE AGOSTINHO CABALLERO MARTIN- ATE 810/861', 'COMPENSA                      ');
INSERT INTO cd_cep_br VALUES ('69.029-120', '156      ', 'EST PADRE AGOSTINHO CABALLERO MARTIN- DE 812/863 A', 'S ANTONIO                     ');
INSERT INTO cd_cep_br VALUES ('69.047-660', '156      ', 'R PADRE ANCHIETA', 'REDENCAO                      ');
INSERT INTO cd_cep_br VALUES ('69.040-370', '156      ', 'R PADRE ANTONIO VIEIRA', 'D PEDRO                       ');
INSERT INTO cd_cep_br VALUES ('69.082-220', '156      ', 'R PADRE CALERI', 'COROADO                       ');
INSERT INTO cd_cep_br VALUES ('69.048-410', '156      ', 'R PADRE CALERI', 'ALVORADA                      ');
INSERT INTO cd_cep_br VALUES ('69.035-430', '156      ', 'R PADRE CALERI', 'COMPENSA                      ');
INSERT INTO cd_cep_br VALUES ('69.068-600', '156      ', 'BC OLAVO BILAC', 'RAIZ                          ');
INSERT INTO cd_cep_br VALUES ('69.053-310', '156      ', 'BC OLAVO BILAC', 'S GERALDO                     ');
INSERT INTO cd_cep_br VALUES ('69.059-440', '156      ', 'R OLAVO BILAC', 'S ETELVINA                    ');
INSERT INTO cd_cep_br VALUES ('69.073-152', '156      ', 'BC OLAVO BILAC', 'CRESPO                        ');
INSERT INTO cd_cep_br VALUES ('69.065-060', '156      ', 'AV OLAVO BILAC (IPIXUNA)', 'CACHOEIRINHA                  ');
INSERT INTO cd_cep_br VALUES ('69.033-660', '156      ', 'R OLENKA DE MENEZES', 'S JORGE                       ');
INSERT INTO cd_cep_br VALUES ('69.027-790', '156      ', 'R OLIMPIO DE CARVALHO', 'GLORIA                        ');
INSERT INTO cd_cep_br VALUES ('69.047-501', '156      ', 'R OLINDA', 'REDENCAO                      ');
INSERT INTO cd_cep_br VALUES ('69.044-260', '156      ', 'R OLINTO CABRAL DE VASCONCELOS (CJ BELVEDERE)', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('69.085-030', '156      ', 'R OLINTO DE LIMA', 'S J OPERARIO                  ');
INSERT INTO cd_cep_br VALUES ('69.079-150', '156      ', 'R OLIVEIRA DIAS', 'S FRANCISCO                   ');
INSERT INTO cd_cep_br VALUES ('69.067-780', '156      ', 'R OMEGA (N JERUSALEM)', 'PETROPOLIS                    ');
INSERT INTO cd_cep_br VALUES ('69.049-627', '156      ', 'R ONORIO JANUARIO (PRQ E GOMES)', 'REDENCAO                      ');
INSERT INTO cd_cep_br VALUES ('69.098-763', '156      ', 'TV ONZE(A. MENDES)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.093-099', '156      ', 'R ONZE DE DEZEMBRO(T. NOVA II)', 'COL T NOVA                    ');
INSERT INTO cd_cep_br VALUES ('69.087-390', '156      ', 'R ONZE DE JULHO', 'T NEVES                       ');
INSERT INTO cd_cep_br VALUES ('69.065-220', '156      ', 'VL OPERARIA', 'CACHOEIRINHA                  ');
INSERT INTO cd_cep_br VALUES ('69.060-680', '156      ', 'BC ORIENTAL', 'ALEIXO                        ');
INSERT INTO cd_cep_br VALUES ('69.043-590', '156      ', 'R ORIENTAL', 'ALVORADA                      ');
INSERT INTO cd_cep_br VALUES ('69.043-581', '156      ', 'TV ORIENTAL', 'ALVORADA                      ');
INSERT INTO cd_cep_br VALUES ('69.078-040', '156      ', 'BC ORIENTAL', 'JAPIIM                        ');
INSERT INTO cd_cep_br VALUES ('69.078-230', '156      ', 'R ORIENTAL', 'JAPIIM                        ');
INSERT INTO cd_cep_br VALUES ('69.060-590', '156      ', 'R ORIENTAL', 'ALEIXO                        ');
INSERT INTO cd_cep_br VALUES ('69.054-680', '156      ', 'PRQ ORIENTAL', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.060-083', '156      ', 'R ORIENTE (CJ M DO SOL)', 'ALEIXO                        ');
INSERT INTO cd_cep_br VALUES ('69.057-800', '156      ', 'BC ORION', 'ADRIANOPOLIS                  ');
INSERT INTO cd_cep_br VALUES ('69.075-420', '156      ', 'R ORLEILSON', 'MAUAZINHO                     ');
INSERT INTO cd_cep_br VALUES ('69.050-420', '156      ', 'CJ ORQUIDEA', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.087-160', '156      ', 'R ORQUIDEA', 'T NEVES                       ');
INSERT INTO cd_cep_br VALUES ('69.044-028', '156      ', 'R ORQUIDEA (CJ FLAMANAL)', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('69.088-320', '156      ', 'R ORQUIDEAS, DAS', 'J TEIXEIRA                    ');
INSERT INTO cd_cep_br VALUES ('69.083-290', '156      ', 'R ORQUIDEAS, DAS(CJ TIRADENTES)', 'ALEIXO                        ');
INSERT INTO cd_cep_br VALUES ('69.083-130', '156      ', 'R OSCAR CORDEIRO (CJ PETRO)', 'ALEIXO                        ');
INSERT INTO cd_cep_br VALUES ('69.084-410', '156      ', 'R OSCAR ROMERO', 'Z PALMARES                    ');
INSERT INTO cd_cep_br VALUES ('69.093-475', '156      ', 'R OSCAR ROMERO(T. NOVA I)', 'COL T NOVA                    ');
INSERT INTO cd_cep_br VALUES ('69.099-041', '156      ', 'R OSEIAS(A. MENDES)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.045-730', '156      ', 'R OSLO (CJ C ELISIOS)', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('69.029-351', '156      ', 'TV OSVALDO ARANHA', 'S ANTONIO                     ');
INSERT INTO cd_cep_br VALUES ('69.089-190', '156      ', 'R O', 'A MENDES                      ');
INSERT INTO cd_cep_br VALUES ('69.042-250', '156      ', 'AV O', 'ALVORADA                      ');
INSERT INTO cd_cep_br VALUES ('69.097-240', '156      ', 'R O (CJ CANARANAS)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.043-440', '156      ', 'R O (CJ DE FLORES II)', 'ALVORADA                      ');
INSERT INTO cd_cep_br VALUES ('69.050-290', '156      ', 'R O (CJ ELDORADO)', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.030-380', '156      ', 'R O (CJ IPASE)', 'COMPENSA                      ');
INSERT INTO cd_cep_br VALUES ('69.053-760', '156      ', 'Q O (CJ MANAUENSE)', 'N S GRACAS                    ');
INSERT INTO cd_cep_br VALUES ('69.095-570', '156      ', 'R O (CJ R JUNIOR)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.095-750', '156      ', 'R O (CJ R S PINTO II)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.060-500', '156      ', 'Q O (PRQ ADRIANOPOLIS)', 'ADRIANOPOLIS                  ');
INSERT INTO cd_cep_br VALUES ('69.082-455', '156      ', 'R O (PRQ SUCUPIRAS)', 'COROADO                       ');
INSERT INTO cd_cep_br VALUES ('69.054-752', '156      ', 'R O (SHANGRILA VII)', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.060-068', '156      ', 'R O/N (CJ M DO SOL)', 'ALEIXO                        ');
INSERT INTO cd_cep_br VALUES ('69.078-240', '156      ', 'BC OCIDENTAL', 'JAPIIM                        ');
INSERT INTO cd_cep_br VALUES ('69.089-061', '156      ', 'R ODIMAR SANTANA', 'A MENDES                      ');
INSERT INTO cd_cep_br VALUES ('69.087-305', '156      ', 'R OFELIA (N REINO)', 'T NEVES                       ');
INSERT INTO cd_cep_br VALUES ('69.048-750', '156      ', 'EST OFICIAIS, DOS', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('69.090-100', '156      ', 'R OIAPI (CJ C NOVA)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.048-760', '156      ', 'R OIAPOQUE(CJ DUQUE DE CAXIAS)', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('69.097-791', '156      ', 'R OITENTA E TRES - A(O. FROTA II)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.098-731', '156      ', 'R OITENTA E TRES - A (A. MENDES)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.098-762', '156      ', 'TV OITO(A. MENDES)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.039-180', '156      ', 'R OITO DE ABRIL', 'N ISRAEL                      ');
INSERT INTO cd_cep_br VALUES ('69.039-181', '156      ', 'TV OITO DE ABRIL', 'N ISRAEL                      ');
INSERT INTO cd_cep_br VALUES ('69.039-182', '156      ', 'AV OITO DE ABRIL', 'N ISRAEL                      ');
INSERT INTO cd_cep_br VALUES ('69.054-550', '156      ', 'R OITO DE DEZEMBRO', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('69.059-600', '156      ', 'R OITO DE DEZEMBRO', 'S ETELVINA                    ');
INSERT INTO cd_cep_br VALUES ('69.049-626', '156      ', 'R OITO DE DEZEMBRO (PRQ E GOMES)', 'REDENCAO                      ');
INSERT INTO cd_cep_br VALUES ('69.065-370', '156      ', 'BC OITOCENTOS E VINTE', 'CACHOEIRINHA                  ');
INSERT INTO cd_cep_br VALUES ('69.082-770', '156      ', 'BC OLARIA', 'COROADO                       ');
INSERT INTO cd_cep_br VALUES ('69.078-402', '156      ', 'BC OLARIA', 'JAPIIM                        ');
INSERT INTO cd_cep_br VALUES ('69.043-740', '156      ', 'TV OLARIA, DA', 'ALVORADA                      ');
INSERT INTO cd_cep_br VALUES ('69.073-440', '156      ', 'BC OLARIA, DA', 'BETANIA                       ');
INSERT INTO cd_cep_br VALUES ('69.008-170', '156      ', 'R OLARIA, DA', 'COL A ALEIXO                  ');
INSERT INTO cd_cep_br VALUES ('69.036-081', '156      ', 'BC OLARIA, DA', 'COMPENSA                      ');
INSERT INTO cd_cep_br VALUES ('69.035-591', '156      ', 'BC OLAVO BILAC', 'COMPENSA                      ');
INSERT INTO cd_cep_br VALUES ('69.035-590', '156      ', 'R OLAVO BILAC', 'COMPENSA                      ');
INSERT INTO cd_cep_br VALUES ('69.025-200', '156      ', 'BC OLAVO BILAC', 'P VARGAS                      ');
INSERT INTO cd_cep_br VALUES ('69.093-425', '156      ', 'R NOVA ESPERANCA(T. NOVA I)', 'COL T NOVA                    ');
INSERT INTO cd_cep_br VALUES ('69.043-157', '156      ', 'BC NOVA ESPERANCA (N HORIZONTE)', 'ALVORADA                      ');
INSERT INTO cd_cep_br VALUES ('69.095-185', '156      ', 'R NOVA IPIRANGA (RIACHO DOCE)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.039-431', '156      ', 'TV NOVA JERUSALEM', 'N ISRAEL                      ');
INSERT INTO cd_cep_br VALUES ('69.039-430', '156      ', 'R NOVA JERUSALEM', 'N ISRAEL                      ');
INSERT INTO cd_cep_br VALUES ('69.084-122', '156      ', 'R NOVA LUZ', 'Z PALMARES                    ');
INSERT INTO cd_cep_br VALUES ('69.073-187', '156      ', 'R NOVA LUZITANIA', 'CRESPO                        ');
INSERT INTO cd_cep_br VALUES ('69.082-200', '156      ', 'BC NOVA OLINDA', 'COROADO                       ');
INSERT INTO cd_cep_br VALUES ('69.078-091', '156      ', 'R NOVA OLINDA', 'JAPIIM                        ');
INSERT INTO cd_cep_br VALUES ('69.078-080', '156      ', 'TV NOVA OLINDA', 'JAPIIM                        ');
INSERT INTO cd_cep_br VALUES ('69.068-070', '156      ', 'R NOVA OLINDA', 'RAIZ                          ');
INSERT INTO cd_cep_br VALUES ('69.036-540', '156      ', 'R NOVA OLINDA', 'S AGOSTINHO                   ');
INSERT INTO cd_cep_br VALUES ('69.005-250', '156      ', 'R DOUTOR MOREIRA', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('69.081-300', '156      ', 'R PIRANHAS, DAS', 'J TEIXEIRA                    ');
INSERT INTO cd_cep_br VALUES ('69.088-780', '156      ', 'R PIRARARA', 'J TEIXEIRA                    ');
INSERT INTO cd_cep_br VALUES ('69.088-410', '156      ', 'R PIRARUCUS', 'J TEIXEIRA                    ');
INSERT INTO cd_cep_br VALUES ('69.068-100', '156      ', 'R PIRATININGA', 'RAIZ                          ');
INSERT INTO cd_cep_br VALUES ('69.020-680', '156      ', 'VL PIRES', 'PC 14 JANEIRO                 ');
INSERT INTO cd_cep_br VALUES ('69.030-730', '156      ', 'CJ PLACIDO DE CASTRO', 'COMPENSA                      ');
INSERT INTO cd_cep_br VALUES ('69.030-740', '156      ', 'R PLACIDO DE CASTRO', 'COMPENSA                      ');
INSERT INTO cd_cep_br VALUES ('69.040-170', '156      ', 'R PLACIDO DE CASTRO (CJ D PEDRO I)', 'D PEDRO                       ');
INSERT INTO cd_cep_br VALUES ('69.055-150', '156      ', 'TV PLANALTO', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.063-516', '156      ', 'BC PLANALTO', 'PETROPOLIS                    ');
INSERT INTO cd_cep_br VALUES ('69.008-040', '156      ', 'R PLANALTO, DO', 'COL A ALEIXO                  ');
INSERT INTO cd_cep_br VALUES ('69.035-420', '156      ', 'R PLINIO COELHO', 'COMPENSA                      ');
INSERT INTO cd_cep_br VALUES ('69.047-200', '156      ', 'R PLINIO COELHO', 'REDENCAO                      ');
INSERT INTO cd_cep_br VALUES ('69.033-750', '156      ', 'TV PLINIO COELHO', 'S JORGE                       ');
INSERT INTO cd_cep_br VALUES ('69.027-470', '156      ', 'R PLINIO RAMOS COELHO', 'GLORIA                        ');
INSERT INTO cd_cep_br VALUES ('69.095-240', '156      ', 'R POLIANA (CJ C NOVA)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.078-100', '156      ', 'EST POLIVALENTE', 'JAPIIM                        ');
INSERT INTO cd_cep_br VALUES ('69.078-260', '156      ', 'R POLIVALENTE', 'JAPIIM                        ');
INSERT INTO cd_cep_br VALUES ('69.037-022', '156      ', 'AL POLONIA (CJ JD EUROPA)', 'P NEGRA                       ');
INSERT INTO cd_cep_br VALUES ('69.036-180', '156      ', 'BC PONCE DE LEON', 'COMPENSA                      ');
INSERT INTO cd_cep_br VALUES ('69.036-170', '156      ', 'R PONCE DE LEON', 'COMPENSA                      ');
INSERT INTO cd_cep_br VALUES ('69.075-401', '156      ', 'R PONTA DO VENTO', 'MAUAZINHO                     ');
INSERT INTO cd_cep_br VALUES ('69.074-190', '156      ', 'R PONTA GROSSA', 'COL O MACHADO                 ');
INSERT INTO cd_cep_br VALUES ('69.030-550', '156      ', 'TV PONTA NEGRA', 'COMPENSA                      ');
INSERT INTO cd_cep_br VALUES ('69.047-051', '156      ', 'R PONTAPORA', 'REDENCAO                      ');
INSERT INTO cd_cep_br VALUES ('69.087-648', '156      ', 'R PERDITA (N REINO)', 'T NEVES                       ');
INSERT INTO cd_cep_br VALUES ('69.073-240', '156      ', 'R PERICLES DE MORAES', 'S LAZARO                      ');
INSERT INTO cd_cep_br VALUES ('69.082-824', '156      ', 'R PERIMENTAL (MONTE SIAO)', 'ALEIXO                        ');
INSERT INTO cd_cep_br VALUES ('69.089-340', '156      ', 'AV PERIMETRAL', 'A MENDES                      ');
INSERT INTO cd_cep_br VALUES ('69.048-340', '156      ', 'AV PERIMETRAL (CJ CANAA)', 'ALVORADA                      ');
INSERT INTO cd_cep_br VALUES ('69.049-620', '156      ', 'AV PERIMETRAL (PRQ E GOMES)', 'REDENCAO                      ');
INSERT INTO cd_cep_br VALUES ('69.076-820', '156      ', 'R PERIMETRAL C', 'JAPIIM                        ');
INSERT INTO cd_cep_br VALUES ('69.076-830', '156      ', 'AV PERIMETRAL D', 'JAPIIM                        ');
INSERT INTO cd_cep_br VALUES ('69.028-000', '156      ', 'R PERIMETRAL ESPANHA (PRQ NACOES)', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('69.028-140', '156      ', 'R PERIMETRAL ESPANHA II (PRQ NACOES)', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('69.099-770', '156      ', 'R PERIMETRAL I (A MENDES)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.055-011', '156      ', 'AV PERIMETRAL I (CJ C BRANCO)', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.055-021', '156      ', 'AV PERIMETRAL II (CJ C BRANCO)', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.055-041', '156      ', 'AV PERIMETRAL III (CJ C BRANCO)', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.055-040', '156      ', 'AV PERIMETRAL LESTE', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.055-010', '156      ', 'AV PERIMETRAL NORTE', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.055-020', '156      ', 'AV PERIMETRAL SUL', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.055-732', '156      ', 'R PERIMETRAL XVI (CJ C BRANCO)', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.058-480', '156      ', 'R PERNAMBUCO (PRQ LARANJEIRAS)', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('69.093-128', '156      ', 'R PEROBA(M.OLIVEIRAS)', 'MTE OLIVEIRAS                 ');
INSERT INTO cd_cep_br VALUES ('69.088-380', '156      ', 'R PERPETUAS, DAS', 'J TEIXEIRA                    ');
INSERT INTO cd_cep_br VALUES ('69.050-500', '156      ', 'R PERU (CJ ELDORADO)', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.037-210', '156      ', 'AL PERU (CJ JD AMERICA)', 'P NEGRA                       ');
INSERT INTO cd_cep_br VALUES ('69.090-160', '156      ', 'R PERUIBE (CJ C NOVA)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.081-430', '156      ', 'R PESCADA', 'J TEIXEIRA                    ');
INSERT INTO cd_cep_br VALUES ('69.088-560', '156      ', 'R PETALAS', 'J TEIXEIRA                    ');
INSERT INTO cd_cep_br VALUES ('69.088-390', '156      ', 'R PETULIAS, DAS', 'J TEIXEIRA                    ');
INSERT INTO cd_cep_br VALUES ('69.088-391', '156      ', 'R PETUNIAS, DAS', 'J TEIXEIRA                    ');
INSERT INTO cd_cep_br VALUES ('69.081-320', '156      ', 'R PIABA', 'J TEIXEIRA                    ');
INSERT INTO cd_cep_br VALUES ('69.088-481', '156      ', 'R PIAU', 'J TEIXEIRA                    ');
INSERT INTO cd_cep_br VALUES ('69.033-580', '156      ', 'TV PIAUI', 'S JORGE                       ');
INSERT INTO cd_cep_br VALUES ('69.073-680', '156      ', 'BC PIAUI', 'S LAZARO                      ');
INSERT INTO cd_cep_br VALUES ('69.081-190', '156      ', 'R PIAUI', 'J TEIXEIRA                    ');
INSERT INTO cd_cep_br VALUES ('69.073-682', '156      ', 'R PIAUI', 'S LAZARO                      ');
INSERT INTO cd_cep_br VALUES ('69.050-076', '156      ', 'R PICO DA NEBLINA (VL BAFURURU)', 'CHAPADA                       ');
INSERT INTO cd_cep_br VALUES ('69.053-060', '156      ', 'R PICO DAS AGUAS', 'S GERALDO                     ');
INSERT INTO cd_cep_br VALUES ('69.033-390', '156      ', 'R PICO DAS AGUAS', 'S JORGE                       ');
INSERT INTO cd_cep_br VALUES ('69.053-062', '156      ', 'BC PICO DAS AGUAS', 'S GERALDO                     ');
INSERT INTO cd_cep_br VALUES ('69.082-740', '156      ', 'R PEDRO TEIXEIRA', 'COROADO                       ');
INSERT INTO cd_cep_br VALUES ('69.059-072', '156      ', 'R PEDRO TEIXEIRA', 'S ETELVINA                    ');
INSERT INTO cd_cep_br VALUES ('69.084-440', '156      ', 'R PEGO RARO', 'Z PALMARES                    ');
INSERT INTO cd_cep_br VALUES ('69.088-461', '156      ', 'R PEIXE AGULHA', 'J TEIXEIRA                    ');
INSERT INTO cd_cep_br VALUES ('69.088-360', '156      ', 'R PEIXE BOI', 'J TEIXEIRA                    ');
INSERT INTO cd_cep_br VALUES ('69.088-370', '156      ', 'R PEIXE CACHORRO', 'J TEIXEIRA                    ');
INSERT INTO cd_cep_br VALUES ('69.063-340', '156      ', 'BC PENAROL, DO', 'PETROPOLIS                    ');
INSERT INTO cd_cep_br VALUES ('69.063-350', '156      ', 'CPO PENAROL, DO', 'PETROPOLIS                    ');
INSERT INTO cd_cep_br VALUES ('69.082-230', '156      ', 'AV PENETRACAO', 'COROADO                       ');
INSERT INTO cd_cep_br VALUES ('69.057-101', '156      ', 'R PENETRACAO', 'ADRIANOPOLIS                  ');
INSERT INTO cd_cep_br VALUES ('69.046-010', '156      ', 'AV PENETRACAO (CJ AJURICABA)', 'ALVORADA                      ');
INSERT INTO cd_cep_br VALUES ('69.055-750', '156      ', 'AV PENETRACAO (CJ C BRANCO)', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.086-550', '156      ', 'R PENETRACAO (CJ CASTANHEIRA)', 'S J OPERARIO                  ');
INSERT INTO cd_cep_br VALUES ('69.028-314', '156      ', 'R PENETRACAO (CJ R MARACANA)', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('69.093-261', '156      ', 'R PENETRACAO EDIMILSON MAIA (M SINAI)', 'COL S ANTONIO                 ');
INSERT INTO cd_cep_br VALUES ('69.086-010', '156      ', 'R PENETRACAO I', 'S J OPERARIO                  ');
INSERT INTO cd_cep_br VALUES ('69.038-021', '156      ', 'R PENETRACAO I', 'N ESPERANCA                   ');
INSERT INTO cd_cep_br VALUES ('69.099-750', '156      ', 'R PENETRACAO I (A MENDES)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.097-280', '156      ', 'AV PENETRACAO I (CJ CANARANAS)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.076-790', '156      ', 'AV PENETRACAO I, DA', 'JAPIIM                        ');
INSERT INTO cd_cep_br VALUES ('69.086-011', '156      ', 'R PENETRACAO II', 'S J OPERARIO                  ');
INSERT INTO cd_cep_br VALUES ('69.038-022', '156      ', 'R PENETRACAO II', 'N ESPERANCA                   ');
INSERT INTO cd_cep_br VALUES ('69.099-760', '156      ', 'R PENETRACAO II (A MENDES)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.097-000', '156      ', 'AV PENETRACAO II (CJ CANARANAS)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.076-800', '156      ', 'AV PENETRACAO II, DA', 'JAPIIM                        ');
INSERT INTO cd_cep_br VALUES ('69.038-023', '156      ', 'R PENETRACAO III', 'N ESPERANCA                   ');
INSERT INTO cd_cep_br VALUES ('69.076-810', '156      ', 'AV PENETRACAO III, DA', 'JAPIIM                        ');
INSERT INTO cd_cep_br VALUES ('69.099-780', '156      ', 'AV PENETRACAO IV(A. MENDES)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.089-210', '156      ', 'AV PENETRACAO NORTE', 'A MENDES                      ');
INSERT INTO cd_cep_br VALUES ('69.089-220', '156      ', 'AV PENETRACAO SUL', 'A MENDES                      ');
INSERT INTO cd_cep_br VALUES ('69.099-000', '156      ', 'R PENETRACAO 3', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.083-140', '156      ', 'R PENETRACAO, DA', 'ALEIXO                        ');
INSERT INTO cd_cep_br VALUES ('69.038-020', '156      ', 'EST PENETRACAO, DA', 'N ESPERANCA                   ');
INSERT INTO cd_cep_br VALUES ('69.088-000', '156      ', 'R PENETRACAO, DA', 'J TEIXEIRA                    ');
INSERT INTO cd_cep_br VALUES ('69.085-001', '156      ', 'R PENETRACAO,DA', 'S J OPERARIO                  ');
INSERT INTO cd_cep_br VALUES ('69.050-101', '156      ', 'BC PENSADOR', 'CHAPADA                       ');
INSERT INTO cd_cep_br VALUES ('69.057-420', '156      ', 'R PAZ, DA', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.073-410', '156      ', 'R PAZ, DA', 'BETANIA                       ');
INSERT INTO cd_cep_br VALUES ('69.080-400', '156      ', 'BC IMPERATRIZ', 'COROADO                       ');
INSERT INTO cd_cep_br VALUES ('69.080-390', '156      ', 'R IMPERATRIZ', 'COROADO                       ');
INSERT INTO cd_cep_br VALUES ('69.054-190', '156      ', 'CJ IMPERIAL', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.070-210', '156      ', 'R INACIO GUIMARAES', 'EDUCANDOS                     ');
INSERT INTO cd_cep_br VALUES ('69.040-680', '156      ', 'R INACIO J. PEIXOTO (CJ. D. PEDRO II)', 'D PEDRO                       ');
INSERT INTO cd_cep_br VALUES ('69.090-120', '156      ', 'R INAJA (CJ C NOVA)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.093-076', '156      ', 'R INCA(T. NOVA II)', 'COL T NOVA                    ');
INSERT INTO cd_cep_br VALUES ('69.037-360', '156      ', 'R INCONFIDENCIA (PRQ RES P NEGRA)', 'P NEGRA                       ');
INSERT INTO cd_cep_br VALUES ('69.043-020', '156      ', 'R INDEPENDENCIA', 'ALVORADA                      ');
INSERT INTO cd_cep_br VALUES ('69.078-020', '156      ', 'R INDEPENDENCIA', 'JAPIIM                        ');
INSERT INTO cd_cep_br VALUES ('69.068-080', '156      ', 'R INDEPENDENCIA', 'RAIZ                          ');
INSERT INTO cd_cep_br VALUES ('69.047-150', '156      ', 'R INDEPENDENCIA', 'REDENCAO                      ');
INSERT INTO cd_cep_br VALUES ('69.047-151', '156      ', 'TV INDEPENDENCIA', 'REDENCAO                      ');
INSERT INTO cd_cep_br VALUES ('69.078-021', '156      ', 'BC INDEPENDENCIA', 'JAPIIM                        ');
INSERT INTO cd_cep_br VALUES ('69.048-190', '156      ', 'R INDEPENDENCIA', 'PAZ                           ');
INSERT INTO cd_cep_br VALUES ('69.047-160', '156      ', 'BC INDEPENDENCIA', 'REDENCAO                      ');
INSERT INTO cd_cep_br VALUES ('69.095-186', '156      ', 'R INDEPENDENCIA(R. DOCE)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.098-232', '156      ', 'R INDIARA', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.097-759', '156      ', 'AV I (CJ A MEDEIROS)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.038-258', '156      ', 'R I (CJ A MONTENEGRO)', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('69.057-670', '156      ', 'Q I (CJ A NERY)', 'ADRIANOPOLIS                  ');
INSERT INTO cd_cep_br VALUES ('69.097-190', '156      ', 'R I (CJ CANARANAS)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.043-280', '156      ', 'R I (CJ DE FLORES I)', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('69.050-240', '156      ', 'R I (CJ ELDORADO)', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.030-330', '156      ', 'R I (CJ IPASE)', 'COMPENSA                      ');
INSERT INTO cd_cep_br VALUES ('69.060-331', '156      ', 'BC I (CJ JD PAULISTA)', 'ALEIXO                        ');
INSERT INTO cd_cep_br VALUES ('69.053-720', '156      ', 'Q I (CJ MANAUENSE)', 'N S GRACAS                    ');
INSERT INTO cd_cep_br VALUES ('69.075-600', '156      ', 'R I (CJ NOVA REPUBLICA)', 'DT INDUSTRIAL                 ');
INSERT INTO cd_cep_br VALUES ('69.095-520', '156      ', 'R I (CJ R JUNIOR)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.095-690', '156      ', 'R I (CJ R S PINTO II)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.085-520', '156      ', 'R I (CJ SEN JOAO BOSCO I)', 'S J OPERARIO                  ');
INSERT INTO cd_cep_br VALUES ('69.085-620', '156      ', 'R I (CJ SEN JOAO BOSCO II)', 'S J OPERARIO                  ');
INSERT INTO cd_cep_br VALUES ('69.060-450', '156      ', 'Q I (PRQ ADRIANOPOLIS)', 'ADRIANOPOLIS                  ');
INSERT INTO cd_cep_br VALUES ('69.054-709', '156      ', 'PRQ I (PRQ SHANGRILA)', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.082-479', '156      ', 'R I (PRQ SUCUPIRAS)', 'COROADO                       ');
INSERT INTO cd_cep_br VALUES ('69.054-699', '156      ', 'R I (SHANGRILA I)', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.054-747', '156      ', 'TV I (SHANGRILA VII)', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.097-360', '156      ', 'R I 1 (CJ CANARANAS)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.089-131', '156      ', 'TV I 2', 'A MENDES                      ');
INSERT INTO cd_cep_br VALUES ('69.075-610', '156      ', 'R I 2 (CJ NOVA REPUBLICA)', 'DT INDUSTRIAL                 ');
INSERT INTO cd_cep_br VALUES ('69.089-132', '156      ', 'TV I 3', 'A MENDES                      ');
INSERT INTO cd_cep_br VALUES ('69.075-620', '156      ', 'R I 3 (CJ NOVA REPUBLICA)', 'DT INDUSTRIAL                 ');
INSERT INTO cd_cep_br VALUES ('69.086-135', '156      ', 'R I-2', 'A MENDES                      ');
INSERT INTO cd_cep_br VALUES ('69.060-063', '156      ', 'R I/J (CJ M DO SOL)', 'ALEIXO                        ');
INSERT INTO cd_cep_br VALUES ('69.090-210', '156      ', 'R IACI (CJ C NOVA)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.098-248', '156      ', 'R IACIARA', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.039-270', '156      ', 'R IANOMANI', 'N ISRAEL                      ');
INSERT INTO cd_cep_br VALUES ('69.059-193', '156      ', 'R IARA', 'S ETELVINA                    ');
INSERT INTO cd_cep_br VALUES ('69.099-029', '156      ', 'R IBICARE(A. MENDES)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.037-350', '156      ', 'R IBIRAPUERA (PRQ RES P NEGRA)', 'P NEGRA                       ');
INSERT INTO cd_cep_br VALUES ('69.075-090', '156      ', 'R ICA', 'DT INDUSTRIAL                 ');
INSERT INTO cd_cep_br VALUES ('69.053-170', '156      ', 'CJ ICA MACEIO', 'N S GRACAS                    ');
INSERT INTO cd_cep_br VALUES ('69.054-180', '156      ', 'CJ ICARAI', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.090-130', '156      ', 'R ICOARACI (CJ C NOVA)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.082-671', '156      ', 'BC IDA NELSON', 'COROADO                       ');
INSERT INTO cd_cep_br VALUES ('69.044-180', '156      ', 'R IDELFONSO PINHEIRO (CJ BELVEDERE)', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('69.050-074', '156      ', 'R HENRIQUES, DOS(VL BAFURURU)', 'CHAPADA                       ');
INSERT INTO cd_cep_br VALUES ('69.010-580', '156      ', 'BC HERCULANO', 'APARECIDA                     ');
INSERT INTO cd_cep_br VALUES ('69.099-027', '156      ', 'R HERCULANO DE SOUZA(A. MENDES)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.083-070', '156      ', 'R HERMAN WEISER (CJ PETRO)', 'ALEIXO                        ');
INSERT INTO cd_cep_br VALUES ('69.037-760', '156      ', 'TV HERMELINDA QUEIROS', 'N ESPERANCA                   ');
INSERT INTO cd_cep_br VALUES ('69.074-762', '156      ', 'R HERMINIO BARBOSA', 'MRO LIBERDADE                 ');
INSERT INTO cd_cep_br VALUES ('69.048-030', '156      ', 'R HIPICA, DA', 'PAZ                           ');
INSERT INTO cd_cep_br VALUES ('69.070-390', '156      ', 'BC HOLANDA', 'EDUCANDOS                     ');
INSERT INTO cd_cep_br VALUES ('69.020-490', '156      ', 'BC HOLANDA', 'PC 14 JANEIRO                 ');
INSERT INTO cd_cep_br VALUES ('69.037-050', '156      ', 'AL HOLANDA (CJ JD AMERICA)', 'P NEGRA                       ');
INSERT INTO cd_cep_br VALUES ('69.028-090', '156      ', 'R HOLANDA (PRQ NACOES)', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('69.078-580', '156      ', 'R HORIZONTE', 'JAPIIM                        ');
INSERT INTO cd_cep_br VALUES ('69.093-071', '156      ', 'BC HORTA, DA', 'COL S ANTONIO                 ');
INSERT INTO cd_cep_br VALUES ('69.044-024', '156      ', 'R HORTELA (CJ FLAMANAL)', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('69.088-581', '156      ', 'R HORTENCIAS', 'J TEIXEIRA                    ');
INSERT INTO cd_cep_br VALUES ('69.083-250', '156      ', 'R HORTENSIAS, DAS(CJ TIRADENTES)', 'ALEIXO                        ');
INSERT INTO cd_cep_br VALUES ('69.070-140', '156      ', 'EST HOSPEDARIA, DA', 'COL O MACHADO                 ');
INSERT INTO cd_cep_br VALUES ('69.060-840', '156      ', 'R HUASCAR ANGELIN', 'ALEIXO                        ');
INSERT INTO cd_cep_br VALUES ('69.060-200', '156      ', 'CJ HUASCAR ANGELIN', 'ALEIXO                        ');
INSERT INTO cd_cep_br VALUES ('69.020-220', '156      ', 'R HUASCAR DE FIGUEIREDO', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('69.082-110', '156      ', 'R HUGO DE ABREU', 'COROADO                       ');
INSERT INTO cd_cep_br VALUES ('69.038-260', '156      ', 'R HUGO E ABREU', 'L VALE                        ');
INSERT INTO cd_cep_br VALUES ('69.065-040', '156      ', 'AV HUMAITA', 'CACHOEIRINHA                  ');
INSERT INTO cd_cep_br VALUES ('69.065-310', '156      ', 'BC HUMAITA', 'CACHOEIRINHA                  ');
INSERT INTO cd_cep_br VALUES ('69.074-170', '156      ', 'VL HUMAITA', 'COL O MACHADO                 ');
INSERT INTO cd_cep_br VALUES ('69.093-078', '156      ', 'R HUMAITA(T. NOVA II)', 'COL T NOVA                    ');
INSERT INTO cd_cep_br VALUES ('69.093-097', '156      ', 'TV HUMAITA(T. NOVA II)', 'COL T NOVA                    ');
INSERT INTO cd_cep_br VALUES ('69.033-300', '156      ', 'BC HUMBERTO DE CAMPOS', 'S JORGE                       ');
INSERT INTO cd_cep_br VALUES ('69.033-140', '156      ', 'R HUMBERTO DE CAMPOS', 'S JORGE                       ');
INSERT INTO cd_cep_br VALUES ('69.033-310', '156      ', 'TV HUMBERTO DE CAMPOS', 'S JORGE                       ');
INSERT INTO cd_cep_br VALUES ('69.042-700', '156      ', 'R HUMBERTO MICHILES (PRQ R JERUSALEM)', 'D PEDRO                       ');
INSERT INTO cd_cep_br VALUES ('69.085-360', '156      ', 'AV HUMBOLDT (PRQ ACARIQUARA)', 'COROADO                       ');
INSERT INTO cd_cep_br VALUES ('69.037-017', '156      ', 'AL HUNGRIA (CJ JD EUROPA)', 'P NEGRA                       ');
INSERT INTO cd_cep_br VALUES ('69.075-592', '156      ', 'R H1(CJ. NOVA REPUBLICA)', 'JAPIIM                        ');
INSERT INTO cd_cep_br VALUES ('69.086-380', '156      ', 'R I', 'S J OPERARIO                  ');
INSERT INTO cd_cep_br VALUES ('69.089-130', '156      ', 'R I', 'A MENDES                      ');
INSERT INTO cd_cep_br VALUES ('69.042-200', '156      ', 'AV I', 'ALVORADA                      ');
INSERT INTO cd_cep_br VALUES ('69.081-112', '156      ', 'R I', 'J TEIXEIRA                    ');
INSERT INTO cd_cep_br VALUES ('69.097-180', '156      ', 'R H (CJ CANARANAS)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.043-270', '156      ', 'R H (CJ DE FLORES I)', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('69.050-230', '156      ', 'R H (CJ ELDORADO)', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.030-320', '156      ', 'R H (CJ IPASE)', 'COMPENSA                      ');
INSERT INTO cd_cep_br VALUES ('69.060-330', '156      ', 'R H (CJ JD PAULISTA)', 'ALEIXO                        ');
INSERT INTO cd_cep_br VALUES ('69.053-710', '156      ', 'Q H (CJ MANAUENSE)', 'N S GRACAS                    ');
INSERT INTO cd_cep_br VALUES ('69.075-590', '156      ', 'R H (CJ NOVA REPUBLICA)', 'DT INDUSTRIAL                 ');
INSERT INTO cd_cep_br VALUES ('69.095-510', '156      ', 'R H (CJ R JUNIOR)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.095-680', '156      ', 'R H (CJ R S PINTO II)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.085-510', '156      ', 'R H (CJ SEN JOAO BOSCO I)', 'S J OPERARIO                  ');
INSERT INTO cd_cep_br VALUES ('69.093-165', '156      ', 'R JURICY(M.OLIVEIRAS)', 'MTE OLIVEIRAS                 ');
INSERT INTO cd_cep_br VALUES ('69.096-040', '156      ', 'R JURITI (CJ C NOVA)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.095-182', '156      ', 'TV JURITI (RIACHO DOCE)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.075-120', '156      ', 'R JURUA', 'DT INDUSTRIAL                 ');
INSERT INTO cd_cep_br VALUES ('69.059-310', '156      ', 'AV JURUA', 'S ETELVINA                    ');
INSERT INTO cd_cep_br VALUES ('69.048-320', '156      ', 'CJ JURUA', 'ALVORADA                      ');
INSERT INTO cd_cep_br VALUES ('69.082-680', '156      ', 'R JURUA (COND O NEGRO)', 'COROADO                       ');
INSERT INTO cd_cep_br VALUES ('69.074-260', '156      ', 'R JURUA (VL MILITAR PONTA PELADA)', 'S LAZARO                      ');
INSERT INTO cd_cep_br VALUES ('69.048-730', '156      ', 'R JURUANA (CJ DQ CAXIAS)', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('69.058-403', '156      ', 'R JURUNA (PRQ LARANJEIRAS)', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('69.090-340', '156      ', 'AV JURUNAS (CJ C NOVA)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.039-120', '156      ', 'R JUSCELINO KUBITSCHECK', 'N ISRAEL                      ');
INSERT INTO cd_cep_br VALUES ('69.087-120', '156      ', 'R JUSCELINO KUBITSCHEK', 'T NEVES                       ');
INSERT INTO cd_cep_br VALUES ('69.049-623', '156      ', 'R JUSCELINO KUBITSCHEK (PRQ E GOMES)', 'REDENCAO                      ');
INSERT INTO cd_cep_br VALUES ('69.050-750', '156      ', 'CJ JUSSARA', 'CHAPADA                       ');
INSERT INTO cd_cep_br VALUES ('69.075-130', '156      ', 'R JUTAI', 'DT INDUSTRIAL                 ');
INSERT INTO cd_cep_br VALUES ('69.010-270', '156      ', 'R JOSE CASEMIRO', 'APARECIDA                     ');
INSERT INTO cd_cep_br VALUES ('69.074-810', '156      ', 'R JOSE CHEVALIER', 'MRO LIBERDADE                 ');
INSERT INTO cd_cep_br VALUES ('69.010-070', '156      ', 'R JOSE CLEMENTE', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('69.093-756', '156      ', 'R JOSE CORDEIRO(T. NOVA II)', 'COL T NOVA                    ');
INSERT INTO cd_cep_br VALUES ('69.067-380', '156      ', 'R JOSE DA GAMA E ABREU', 'PETROPOLIS                    ');
INSERT INTO cd_cep_br VALUES ('69.039-711', '156      ', 'R JOSE DANTAS', 'N ISRAEL                      ');
INSERT INTO cd_cep_br VALUES ('69.078-740', '156      ', 'R JOSE DE LIMA', 'JAPIIM                        ');
INSERT INTO cd_cep_br VALUES ('69.078-410', '156      ', 'R JOSE DE MACEDO', 'JAPIIM                        ');
INSERT INTO cd_cep_br VALUES ('69.075-450', '156      ', 'R JOSE DE RIBAMAR', 'MAUAZINHO                     ');
INSERT INTO cd_cep_br VALUES ('69.033-340', '156      ', 'R JOSE DE VASCONCELOS', 'S JORGE                       ');
INSERT INTO cd_cep_br VALUES ('69.060-051', '156      ', 'BC JOSE DO PATROCINIO', 'ALEIXO                        ');
INSERT INTO cd_cep_br VALUES ('69.060-050', '156      ', 'R JOSE DO PATROCINIO', 'ALEIXO                        ');
INSERT INTO cd_cep_br VALUES ('69.040-480', '156      ', 'R JOSE DO PATROCINIO (CJ D PEDRO II)', 'D PEDRO                       ');
INSERT INTO cd_cep_br VALUES ('69.082-520', '156      ', 'R JOSE DUTRA (O VERDE)', 'COROADO                       ');
INSERT INTO cd_cep_br VALUES ('69.068-690', '156      ', 'R JOSE ESTEVAO', 'RAIZ                          ');
INSERT INTO cd_cep_br VALUES ('69.093-120', '156      ', 'R JOSE FAUSTINO', 'COL S ANTONIO                 ');
INSERT INTO cd_cep_br VALUES ('69.037-720', '156      ', 'R JOSE FERNANDES', 'L VALE                        ');
INSERT INTO cd_cep_br VALUES ('69.042-720', '156      ', 'R JOSE FERNANDES (PRQ R JERUSALEM)', 'D PEDRO                       ');
INSERT INTO cd_cep_br VALUES ('69.063-380', '156      ', 'BC JOSE FLORENCIO', 'PETROPOLIS                    ');
INSERT INTO cd_cep_br VALUES ('69.063-390', '156      ', 'R JOSE FLORENCIO', 'PETROPOLIS                    ');
INSERT INTO cd_cep_br VALUES ('69.087-110', '156      ', 'R JOSE FRANCISCO', 'T NEVES                       ');
INSERT INTO cd_cep_br VALUES ('69.079-192', '156      ', 'R JOSE FURTADO', 'S FRANCISCO                   ');
INSERT INTO cd_cep_br VALUES ('69.059-071', '156      ', 'TV JOSE GABRIEL DA COSTA', 'S ETELVINA                    ');
INSERT INTO cd_cep_br VALUES ('69.067-800', '156      ', 'BC JOSE LINDOSO', 'PETROPOLIS                    ');
INSERT INTO cd_cep_br VALUES ('69.059-145', '156      ', 'R JOSE MARIA', 'S ETELVINA                    ');
INSERT INTO cd_cep_br VALUES ('69.078-400', '156      ', 'R JOSE MONTEIRO', 'JAPIIM                        ');
INSERT INTO cd_cep_br VALUES ('69.005-130', '156      ', 'R JOSE PARANAGUA', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('69.067-310', '156      ', 'R JOSE PEREIRA NETO (CJ JD PETROPOLIS)', 'PETROPOLIS                    ');
INSERT INTO cd_cep_br VALUES ('69.078-380', '156      ', 'R JOSE PRESTES', 'JAPIIM                        ');
INSERT INTO cd_cep_br VALUES ('69.068-700', '156      ', 'BC JOSE RAMOS', 'RAIZ                          ');
INSERT INTO cd_cep_br VALUES ('69.083-690', '156      ', 'R JOSE ROMAO', 'S J OPERARIO                  ');
INSERT INTO cd_cep_br VALUES ('69.086-620', '156      ', 'R JOSE ROMAO', 'S J OPERARIO                  ');
INSERT INTO cd_cep_br VALUES ('69.035-761', '156      ', 'BC JOSE SAO', 'COMPENSA                      ');
INSERT INTO cd_cep_br VALUES ('69.042-031', '156      ', 'TV JOSE SAO', 'ALVORADA                      ');
INSERT INTO cd_cep_br VALUES ('69.082-641', '156      ', 'R JOSE SARNEY (MONTE CASTELO)', 'COROADO                       ');
INSERT INTO cd_cep_br VALUES ('69.029-510', '156      ', 'R JOSE TADROS', 'S ANTONIO                     ');
INSERT INTO cd_cep_br VALUES ('69.035-490', '156      ', 'BC JOSENIAS', 'COMPENSA                      ');
INSERT INTO cd_cep_br VALUES ('69.078-030', '156      ', 'R JOSUE CLAUDIO DE SOUZA', 'JAPIIM                        ');
INSERT INTO cd_cep_br VALUES ('69.036-560', '156      ', 'R JOAQUIM GADELHA', 'S AGOSTINHO                   ');
INSERT INTO cd_cep_br VALUES ('69.053-410', '156      ', 'R JOAQUIM GONZAGA PINHEIRO', 'N S GRACAS                    ');
INSERT INTO cd_cep_br VALUES ('69.099-068', '156      ', 'R JOAQUIM MARTINS(A. MENDES)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.005-080', '156      ', 'AV JOAQUIM NABUCO- ATE 0784/0815', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('69.020-030', '156      ', 'AV JOAQUIM NABUCO- DE 0786/0817 A 1510/1791', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('69.020-031', '156      ', 'AV JOAQUIM NABUCO- DE 1512/1793 AO FIM', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('69.063-190', '156      ', 'R JOAQUIM RIBEIRO', 'S FRANCISCO                   ');
INSERT INTO cd_cep_br VALUES ('69.063-192', '156      ', 'BC JOAQUIM RIBEIRO', 'S FRANCISCO                   ');
INSERT INTO cd_cep_br VALUES ('69.010-020', '156      ', 'R JOAQUIM SARMENTO', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('69.079-050', '156      ', 'R JOAQUIM TANAJURA', 'S FRANCISCO                   ');
INSERT INTO cd_cep_br VALUES ('69.083-680', '156      ', 'R JOAQUIM UCHOA', 'ALEIXO                        ');
INSERT INTO cd_cep_br VALUES ('69.093-111', '156      ', 'R JOARA', 'COL S ANTONIO                 ');
INSERT INTO cd_cep_br VALUES ('69.053-200', '156      ', 'R JOFRE MAIA', 'S GERALDO                     ');
INSERT INTO cd_cep_br VALUES ('69.098-192', '156      ', 'R JOINVILLE(N. ALEIXO)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.073-571', '156      ', 'BC JONAS BARRETO', 'S LAZARO                      ');
INSERT INTO cd_cep_br VALUES ('69.073-570', '156      ', 'R JONAS BARRETO', 'S LAZARO                      ');
INSERT INTO cd_cep_br VALUES ('69.079-120', '156      ', 'R JONAS DA SILVA', 'S FRANCISCO                   ');
INSERT INTO cd_cep_br VALUES ('69.036-790', '156      ', 'EST JONASA, DA', 'S AGOSTINHO                   ');
INSERT INTO cd_cep_br VALUES ('69.020-110', '156      ', 'R JONATHAS PEDROSA', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('69.067-442', '156      ', 'R JORGE AMADO', 'PETROPOLIS                    ');
INSERT INTO cd_cep_br VALUES ('69.035-120', '156      ', 'TV JORGE ANTONIO', 'COMPENSA                      ');
INSERT INTO cd_cep_br VALUES ('69.057-141', '156      ', 'BC JORGE BAIRD', 'ADRIANOPOLIS                  ');
INSERT INTO cd_cep_br VALUES ('69.057-140', '156      ', 'R JORGE BAIRD', 'ADRIANOPOLIS                  ');
INSERT INTO cd_cep_br VALUES ('69.060-740', '156      ', 'BC JORGE TEIXEIRA', 'ALEIXO                        ');
INSERT INTO cd_cep_br VALUES ('69.078-600', '156      ', 'BC JORGE TEIXEIRA', 'JAPIIM                        ');
INSERT INTO cd_cep_br VALUES ('69.087-100', '156      ', 'R JORGE TEIXEIRA', 'T NEVES                       ');
INSERT INTO cd_cep_br VALUES ('69.059-300', '156      ', 'R JORGE TEIXEIRA', 'S ETELVINA                    ');
INSERT INTO cd_cep_br VALUES ('69.050-630', '156      ', 'CJ JORNALISTAS, DOS', 'CHAPADA                       ');
INSERT INTO cd_cep_br VALUES ('69.040-730', '156      ', 'R JOSE ALVARES MACIEL (CJ D PEDRO II)', 'D PEDRO                       ');
INSERT INTO cd_cep_br VALUES ('69.063-211', '156      ', 'R JOSE AMANCIO', 'S FRANCISCO                   ');
INSERT INTO cd_cep_br VALUES ('69.083-100', '156      ', 'R JOSE AMERICO (CJ PETRO)', 'ALEIXO                        ');
INSERT INTO cd_cep_br VALUES ('69.033-060', '156      ', 'R JOSE AUGUSTO BORBOREMA', 'S JORGE                       ');
INSERT INTO cd_cep_br VALUES ('69.074-580', '156      ', 'R JOSE BENTO', 'MRO LIBERDADE                 ');
INSERT INTO cd_cep_br VALUES ('69.074-010', '156      ', 'R JOSE BONIFACIO', 'COL O MACHADO                 ');
INSERT INTO cd_cep_br VALUES ('69.068-090', '156      ', 'TV JOSE BONIFACIO', 'RAIZ                          ');
INSERT INTO cd_cep_br VALUES ('69.029-330', '156      ', 'R JOSE BONIFACIO', 'S ANTONIO                     ');
INSERT INTO cd_cep_br VALUES ('69.040-030', '156      ', 'R JOSE BONIFACIO (CJ D PEDRO I)', 'D PEDRO                       ');
INSERT INTO cd_cep_br VALUES ('69.010-280', '156      ', 'BC JOSE CASEMIRO', 'APARECIDA                     ');
INSERT INTO cd_cep_br VALUES ('69.082-160', '156      ', 'BC JOANA D ARC', 'COROADO                       ');
INSERT INTO cd_cep_br VALUES ('69.080-410', '156      ', 'R JOANA DARC', 'COROADO                       ');
INSERT INTO cd_cep_br VALUES ('69.084-463', '156      ', 'R JOANA DARC', 'Z PALMARES                    ');
INSERT INTO cd_cep_br VALUES ('69.048-000', '156      ', 'R JOAO ALFREDO', 'PAZ                           ');
INSERT INTO cd_cep_br VALUES ('69.053-270', '156      ', 'R JOAO ALFREDO', 'S GERALDO                     ');
INSERT INTO cd_cep_br VALUES ('69.054-540', '156      ', 'TV JOAO ALFREDO', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('69.033-482', '156      ', 'TV JOAO AVELINO', 'S JORGE                       ');
INSERT INTO cd_cep_br VALUES ('69.033-481', '156      ', 'R JOAO AVELINO', 'S JORGE                       ');
INSERT INTO cd_cep_br VALUES ('69.053-441', '156      ', 'BC JOAO BATISTA', 'N S GRACAS                    ');
INSERT INTO cd_cep_br VALUES ('69.087-051', '156      ', 'R JOAO BOSCO', 'T NEVES                       ');
INSERT INTO cd_cep_br VALUES ('69.085-575', '156      ', 'BC JOAO BOSCO', 'S J OPERARIO                  ');
INSERT INTO cd_cep_br VALUES ('40.020-240', '435      ', 'R VINTE E OITO DE SETEMBRO', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('40.323-710', '435      ', 'R VINTE E OU OITO DE SETEMBRO', 'IAPI                          ');
INSERT INTO cd_cep_br VALUES ('40.385-150', '435      ', 'R VINTE E QUATRO', 'S CAETANO                     ');
INSERT INTO cd_cep_br VALUES ('40.731-210', '435      ', 'R VINTE E QUATRO', 'FAZ COUTOS I                  ');
INSERT INTO cd_cep_br VALUES ('41.295-000', '435      ', 'R VINTE E QUATRO DE AGOSTO', 'PIRAJA                        ');
INSERT INTO cd_cep_br VALUES ('41.200-330', '435      ', 'R VINTE E QUATRO DE AGOSTO', 'ENGOMADEIRA                   ');
INSERT INTO cd_cep_br VALUES ('41.295-170', '435      ', 'TV VINTE E QUATRO DE AGOSTO', 'PIRAJA                        ');
INSERT INTO cd_cep_br VALUES ('40.070-030', '435      ', 'R VINTE E QUATRO DE FEVEREIRO', 'LAPA                          ');
INSERT INTO cd_cep_br VALUES ('40.410-310', '435      ', 'R VINTE E QUATRO DE JANEIRO', 'ROMA                          ');
INSERT INTO cd_cep_br VALUES ('40.313-480', '435      ', 'LD VINTE E QUATRO DE JUNHO- ATE 59/82', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.080-090', '156      ', 'R BOM JESUS', 'COROADO                       ');
INSERT INTO cd_cep_br VALUES ('40.315-080', '435      ', 'LD VINTE E QUATRO DE JUNHO- DE 61/84 AO FIM', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('40.020-090', '435      ', 'R VINTE E QUATRO DE MAIO', 'BARROQUINHA                   ');
INSERT INTO cd_cep_br VALUES ('41.390-570', '435      ', 'R VINTE  E UM DE JUNHO', 'VL CANARIA                    ');
INSERT INTO cd_cep_br VALUES ('40.310-610', '435      ', 'R VINTE DE AGOSTO', 'P MIUDO                       ');
INSERT INTO cd_cep_br VALUES ('40.310-620', '435      ', 'TV VINTE DE AGOSTO', 'P MIUDO                       ');
INSERT INTO cd_cep_br VALUES ('41.130-110', '435      ', 'R VINTE DE AGOSTO', 'PERNAMBUES                    ');
INSERT INTO cd_cep_br VALUES ('41.270-720', '435      ', 'R VINTE DE AGOSTO', 'CAMPINAS                      ');
INSERT INTO cd_cep_br VALUES ('41.920-190', '435      ', 'VL VINTE DE JANEIRO', 'NORDESTE                      ');
INSERT INTO cd_cep_br VALUES ('41.920-180', '435      ', 'R VINTE DE JANEIRO', 'S CRUZ                        ');
INSERT INTO cd_cep_br VALUES ('40.280-420', '435      ', 'AV VINTE DE JULHO', 'BROTAS                        ');
INSERT INTO cd_cep_br VALUES ('40.283-110', '435      ', 'R VINTE DE JULHO', 'BROTAS                        ');
INSERT INTO cd_cep_br VALUES ('40.283-010', '435      ', 'R VINTE DE JULHO', 'CANDEAL                       ');
INSERT INTO cd_cep_br VALUES ('40.295-385', '435      ', 'R VINTE DE JULHO', 'CANDEAL                       ');
INSERT INTO cd_cep_br VALUES ('41.927-350', '435      ', 'TV VINTE DE JUNHO', 'NORDESTE                      ');
INSERT INTO cd_cep_br VALUES ('40.430-181', '435      ', 'TV VINTE DE JUNHO', 'VL R BARBOSA                  ');
INSERT INTO cd_cep_br VALUES ('41.927-340', '435      ', 'R VINTE DE JUNHO', 'NORDESTE                      ');
INSERT INTO cd_cep_br VALUES ('41.120-100', '435      ', 'R VINTE DE MAIO', 'PERNAMBUES                    ');
INSERT INTO cd_cep_br VALUES ('40.750-160', '435      ', 'R VINTE DE OUTUBRO', 'COUTOS                        ');
INSERT INTO cd_cep_br VALUES ('40.731-220', '435      ', 'R VINTE E CINCO', 'FAZ COUTOS I                  ');
INSERT INTO cd_cep_br VALUES ('40.280-250', '435      ', 'R VINTE E CINCO DE DEZEMBRO', 'C BROTAS                      ');
INSERT INTO cd_cep_br VALUES ('40.313-360', '435      ', 'R VINTE E CINCO DE DEZEMBRO', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('40.313-390', '435      ', 'TV VINTE E CINCO DE DEZEMBRO', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('40.240-590', '435      ', 'AV VINTE E CINCO DE DEZEMBRO', 'E V BROTAS                    ');
INSERT INTO cd_cep_br VALUES ('41.200-370', '435      ', 'TV VINTE E CINCO DE DEZEMBRO', 'ENGOMADEIRA                   ');
INSERT INTO cd_cep_br VALUES ('40.430-060', '435      ', 'R VINTE E CINCO DE DEZEMBRO', 'VL R BARBOSA                  ');
INSERT INTO cd_cep_br VALUES ('41.130-140', '435      ', 'R VINTE E CINCO DE DEZEMBRO', 'PERNAMBUES                    ');
INSERT INTO cd_cep_br VALUES ('40.420-060', '435      ', 'R VINTE E CINCO DE DEZEMBRO', 'RIBEIRA                       ');
INSERT INTO cd_cep_br VALUES ('40.424-270', '435      ', 'TV VINTE E CINCO DE DEZEMBRO', 'RIBEIRA                       ');
INSERT INTO cd_cep_br VALUES ('41.200-360', '435      ', 'R VINTE E CINCO DE DEZEMBRO', 'ENGOMADEIRA                   ');
INSERT INTO cd_cep_br VALUES ('40.760-530', '435      ', 'R VINTE E CINCO DE DEZEMBRO', 'COUTOS                        ');
INSERT INTO cd_cep_br VALUES ('40.760-540', '435      ', 'TV VINTE E CINCO DE DEZEMBRO', 'COUTOS                        ');
INSERT INTO cd_cep_br VALUES ('40.325-160', '435      ', 'AV VINTE E CINCO DE FEVEREIRO', 'LAPINHA                       ');
INSERT INTO cd_cep_br VALUES ('40.325-170', '435      ', 'R VINTE E CINCO DE FEVEREIRO', 'SOLEDADE                      ');
INSERT INTO cd_cep_br VALUES ('40.430-090', '435      ', 'R VINTE E CINCO DE JUNHO', 'VL R BARBOSA                  ');
INSERT INTO cd_cep_br VALUES ('40.450-815', '435      ', 'R VINTE E CINCO DE JUNHO', 'URUGUAI                       ');
INSERT INTO cd_cep_br VALUES ('40.323-340', '435      ', 'AV VINTE E CINCO DE MAIO', 'IAPI                          ');
INSERT INTO cd_cep_br VALUES ('40.220-220', '435      ', 'R VINTE E CINCO DE MARCO', 'E V FEDERACAO                 ');
INSERT INTO cd_cep_br VALUES ('40.470-280', '435      ', 'R VINTE E CINCO DE MARCO', 'LOBATO                        ');
INSERT INTO cd_cep_br VALUES ('40.283-480', '435      ', 'TV VINTE E CINCO DE NOVEMBRO', 'BROTAS                        ');
INSERT INTO cd_cep_br VALUES ('40.454-290', '435      ', 'TV VINTE E CINCO DE SETEMBRO', 'URUGUAI                       ');
INSERT INTO cd_cep_br VALUES ('41.150-510', '435      ', 'CJ VILA MILITAR', 'CABULA                        ');
INSERT INTO cd_cep_br VALUES ('41.635-060', '435      ', 'R VILA MONTE', 'ITAPUA                        ');
INSERT INTO cd_cep_br VALUES ('41.210-200', '435      ', 'R VILA NATAL', 'T NEVES                       ');
INSERT INTO cd_cep_br VALUES ('40.290-480', '435      ', 'R VILA NOVA', 'BROTAS                        ');
INSERT INTO cd_cep_br VALUES ('41.280-360', '435      ', 'R VILA ODETE', 'M RONDON                      ');
INSERT INTO cd_cep_br VALUES ('40.365-220', '435      ', 'TV VILA OPERARIA', 'CURUZU                        ');
INSERT INTO cd_cep_br VALUES ('40.393-120', '435      ', 'R VILA OPERARIA', 'CAPELINHA                     ');
INSERT INTO cd_cep_br VALUES ('40.243-165', '435      ', 'R VILA PARAISO', 'E V BROTAS                    ');
INSERT INTO cd_cep_br VALUES ('40.335-070', '435      ', '1a VILA PAULISTA, DA', 'P VAZ                         ');
INSERT INTO cd_cep_br VALUES ('40.335-080', '435      ', 'BX VILA PAULISTA, DA', 'P VAZ                         ');
INSERT INTO cd_cep_br VALUES ('40.840-130', '435      ', 'R VILA RESEQUE', 'PARIPE                        ');
INSERT INTO cd_cep_br VALUES ('41.635-030', '435      ', 'R VILA ROMANA', 'ITAPUA                        ');
INSERT INTO cd_cep_br VALUES ('41.635-100', '435      ', 'TV VILA ROMANA', 'ITAPUA                        ');
INSERT INTO cd_cep_br VALUES ('40.243-135', '435      ', 'TV VILA SOBRINHO', 'E V BROTAS                    ');
INSERT INTO cd_cep_br VALUES ('40.280-610', '435      ', 'TV VILA UBARANA', 'BROTAS                        ');
INSERT INTO cd_cep_br VALUES ('40.433-070', '435      ', 'R VILA UNIAO', 'RIBEIRA                       ');
INSERT INTO cd_cep_br VALUES ('40.433-090', '435      ', 'TV VILA UNIAO', 'RIBEIRA                       ');
INSERT INTO cd_cep_br VALUES ('40.221-050', '435      ', 'R VILA VALLE', 'E V FEDERACAO                 ');
INSERT INTO cd_cep_br VALUES ('40.221-100', '435      ', 'TV VILA VALLE', 'E V FEDERACAO                 ');
INSERT INTO cd_cep_br VALUES ('40.275-790', '435      ', 'R VILA VELHA', 'BROTAS                        ');
INSERT INTO cd_cep_br VALUES ('41.500-670', '435      ', 'JD VILA VERDE', 'S CRISTOVAO                   ');
INSERT INTO cd_cep_br VALUES ('40.270-130', '435      ', 'CJ VILA VERDE', 'VL LAURA                      ');
INSERT INTO cd_cep_br VALUES ('41.680-065', '435      ', 'CON VILAGE JAGUARIBE', 'ITAPUA                        ');
INSERT INTO cd_cep_br VALUES ('40.245-760', '435      ', 'LD VILANTINA', 'E V BROTAS                    ');
INSERT INTO cd_cep_br VALUES ('41.620-050', '435      ', 'CJ VILAREJO', 'ITAPUA                        ');
INSERT INTO cd_cep_br VALUES ('40.352-380', '435      ', 'VL VILARES', 'FAZ G RETIRO                  ');
INSERT INTO cd_cep_br VALUES ('40.318-170', '435      ', 'R VILAS DAS PEDRAS', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('40.415-370', '435      ', 'R VILETA', 'BONFIM                        ');
INSERT INTO cd_cep_br VALUES ('40.330-080', '435      ', 'R VILETA SELVA', 'IAPI                          ');
INSERT INTO cd_cep_br VALUES ('41.620-070', '435      ', 'CJ VILLAGE', 'ITAPUA                        ');
INSERT INTO cd_cep_br VALUES ('41.650-240', '435      ', 'PRQ VILLAGE PIATA', 'PIATA                         ');
INSERT INTO cd_cep_br VALUES ('41.620-400', '435      ', 'CJ VILLAGE RECANTO DO SOL', 'ITAPUA                        ');
INSERT INTO cd_cep_br VALUES ('40.210-570', '435      ', 'AV VILMA', 'FEDERACAO                     ');
INSERT INTO cd_cep_br VALUES ('41.305-095', '435      ', 'R VILMA MOREIRA', 'A CLARAS                      ');
INSERT INTO cd_cep_br VALUES ('41.390-220', '435      ', 'TV VILMA SANTOS', 'VL CANARIA                    ');
INSERT INTO cd_cep_br VALUES ('41.315-280', '435      ', 'R VINICIUS DE MORAIS', 'D AVELAR                      ');
INSERT INTO cd_cep_br VALUES ('41.620-300', '435      ', 'R VINICIUS DE MORAIS', 'ITAPUA                        ');
INSERT INTO cd_cep_br VALUES ('40.731-180', '435      ', 'R VINTE', 'FAZ COUTOS I                  ');
INSERT INTO cd_cep_br VALUES ('41.315-100', '435      ', 'R VICENTINOS', 'D AVELAR                      ');
INSERT INTO cd_cep_br VALUES ('40.100-110', '435      ', 'R VICTOR MEIRELES', 'GARCIA                        ');
INSERT INTO cd_cep_br VALUES ('40.301-270', '435      ', 'AV VIDAL', 'BARBALHO                      ');
INSERT INTO cd_cep_br VALUES ('40.325-020', '435      ', 'AV VIDAL', 'LAPINHA                       ');
INSERT INTO cd_cep_br VALUES ('40.020-040', '435      ', 'TV VIDAL DA CUNHA', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('40.015-470', '435      ', 'R VIDAL DE NEGREIROS', 'COMERCIO                      ');
INSERT INTO cd_cep_br VALUES ('40.454-280', '435      ', 'R VIDAL DE NEGREIROS', 'URUGUAI                       ');
INSERT INTO cd_cep_br VALUES ('40.450-080', '435      ', 'TV VIDAL DE NEGREIROS', 'CALCADA                       ');
INSERT INTO cd_cep_br VALUES ('41.600-097', '435      ', 'R VIDIGAL DE FREITAS GUIMARAES', 'S MARIS                       ');
INSERT INTO cd_cep_br VALUES ('41.940-560', '435      ', 'R VIEIRA LOPES', 'R VERMELHO                    ');
INSERT INTO cd_cep_br VALUES ('41.250-525', '435      ', '1a SANTO ANTONIO DE PADUA', 'P LIMA                        ');
INSERT INTO cd_cep_br VALUES ('40.330-670', '435      ', 'BX SANTO ANTONIO, DO', 'B REIS                        ');
INSERT INTO cd_cep_br VALUES ('69.095-760', '156      ', 'R P (CJ R S PINTO II)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.075-550', '156      ', 'R G   (CJ NOVA REPUBLICA)', 'DT INDUSTRIAL                 ');
INSERT INTO cd_cep_br VALUES ('69.038-256', '156      ', 'R G (CJ A MONTENEGRO)', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('69.057-650', '156      ', 'Q G (CJ A NERY)', 'ADRIANOPOLIS                  ');
INSERT INTO cd_cep_br VALUES ('69.097-170', '156      ', 'R G (CJ CANARANAS)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.043-260', '156      ', 'R G (CJ DE FLORES I)', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('69.029-481', '156      ', 'R G (CJ DOS BANCARIOS)', 'S ANTONIO                     ');
INSERT INTO cd_cep_br VALUES ('12.910-500', '4897     ', 'R PEDRO IZZO', 'JD LARANJEIRAS                ');
INSERT INTO cd_cep_br VALUES ('69.050-220', '156      ', 'R G (CJ ELDORADO)', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.030-310', '156      ', 'R G (CJ IPASE)', 'COMPENSA                      ');
INSERT INTO cd_cep_br VALUES ('69.060-320', '156      ', 'R G (CJ JD PAULISTA)', 'ALEIXO                        ');
INSERT INTO cd_cep_br VALUES ('69.053-700', '156      ', 'Q G (CJ MANAUENSE)', 'N S GRACAS                    ');
INSERT INTO cd_cep_br VALUES ('69.097-740', '156      ', 'AV G (CJ O FROTA II)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.095-500', '156      ', 'R G (CJ R JUNIOR)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.095-670', '156      ', 'R G (CJ R S PINTO II)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.035-190', '156      ', 'R FLORES, DAS', 'COMPENSA                      ');
INSERT INTO cd_cep_br VALUES ('69.070-060', '156      ', 'BC FLORES, DAS', 'EDUCANDOS                     ');
INSERT INTO cd_cep_br VALUES ('69.080-830', '156      ', 'BC FLORES, DAS', 'COROADO                       ');
INSERT INTO cd_cep_br VALUES ('69.086-580', '156      ', 'R FLORES, DAS', 'S J OPERARIO                  ');
INSERT INTO cd_cep_br VALUES ('69.087-260', '156      ', 'R FLORES, DAS', 'T NEVES                       ');
INSERT INTO cd_cep_br VALUES ('69.075-271', '156      ', 'BC FLORES, DAS', 'MAUAZINHO                     ');
INSERT INTO cd_cep_br VALUES ('69.037-600', '156      ', 'BC FLORES, DAS', 'P NEGRA                       ');
INSERT INTO cd_cep_br VALUES ('69.083-180', '156      ', 'AV FLORES, DAS(CJ TIRADENTES)', 'ALEIXO                        ');
INSERT INTO cd_cep_br VALUES ('69.093-759', '156      ', 'R FLORES, DAS(T.NOVA II)', 'COL T NOVA                    ');
INSERT INTO cd_cep_br VALUES ('69.093-762', '156      ', 'BC FLORES, DAS(T.NOVA II)', 'COL T NOVA                    ');
INSERT INTO cd_cep_br VALUES ('69.087-630', '156      ', 'AV FLORESTA (N REINO)', 'T NEVES                       ');
INSERT INTO cd_cep_br VALUES ('69.048-070', '156      ', 'EST FLORESTA, DA', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('69.038-140', '156      ', 'R FLORESTAL', 'L VALE                        ');
INSERT INTO cd_cep_br VALUES ('69.084-597', '156      ', 'R FLORESTAL', 'Z PALMARES                    ');
INSERT INTO cd_cep_br VALUES ('69.005-070', '156      ', 'R FLORIANO PEIXOTO', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('69.067-440', '156      ', 'R FLORIANOPOLIS', 'PETROPOLIS                    ');
INSERT INTO cd_cep_br VALUES ('69.059-441', '156      ', 'R FLORINDO GRANA', 'S ETELVINA                    ');
INSERT INTO cd_cep_br VALUES ('69.068-150', '156      ', 'BC FOGAS', 'RAIZ                          ');
INSERT INTO cd_cep_br VALUES ('69.076-456', '156      ', 'R FONTE BOA', 'JAPIIM                        ');
INSERT INTO cd_cep_br VALUES ('69.028-120', '156      ', 'R FORMOSA (PRQ NACOES)', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('69.057-080', '156      ', 'R FORTALEZA', 'ADRIANOPOLIS                  ');
INSERT INTO cd_cep_br VALUES ('69.043-560', '156      ', 'BC FORTALEZA', 'ALVORADA                      ');
INSERT INTO cd_cep_br VALUES ('69.035-130', '156      ', 'BC FORTALEZA', 'COMPENSA                      ');
INSERT INTO cd_cep_br VALUES ('69.035-131', '156      ', 'R FORTALEZA', 'COMPENSA                      ');
INSERT INTO cd_cep_br VALUES ('69.053-500', '156      ', 'BC FORTALEZA', 'N S GRACAS                    ');
INSERT INTO cd_cep_br VALUES ('69.053-510', '156      ', 'R FORTALEZA', 'N S GRACAS                    ');
INSERT INTO cd_cep_br VALUES ('69.039-600', '156      ', 'BC FORTALEZA', 'N ISRAEL                      ');
INSERT INTO cd_cep_br VALUES ('69.089-326', '156      ', 'R FORTALEZA', 'A MENDES                      ');
INSERT INTO cd_cep_br VALUES ('69.039-736', '156      ', 'R FORTALEZA', 'N ISRAEL                      ');
INSERT INTO cd_cep_br VALUES ('69.037-015', '156      ', 'AL FRANCA (CJ JD EUROPA)', 'P NEGRA                       ');
INSERT INTO cd_cep_br VALUES ('69.037-300', '156      ', 'AL FRANCESA (CJ JD AMERICA)', 'P NEGRA                       ');
INSERT INTO cd_cep_br VALUES ('69.043-330', '156      ', 'BC FRANCESES, DOS', 'ALVORADA                      ');
INSERT INTO cd_cep_br VALUES ('69.043-720', '156      ', 'R FRANCESES, DOS', 'ALVORADA                      ');
INSERT INTO cd_cep_br VALUES ('69.043-320', '156      ', 'TV FRANCESES, DOS', 'ALVORADA                      ');
INSERT INTO cd_cep_br VALUES ('69.038-010', '156      ', 'EST FRANCESES, DOS', 'L VALE                        ');
INSERT INTO cd_cep_br VALUES ('69.059-240', '156      ', 'R FRANCISCA MENDES', 'S ETELVINA                    ');
INSERT INTO cd_cep_br VALUES ('69.083-060', '156      ', 'R FRANCISCO ARRUDA (CJ PETRO)', 'ALEIXO                        ');
INSERT INTO cd_cep_br VALUES ('69.082-642', '156      ', 'R FRANCISCO BAMBOLE (PRQ M CASTELO)', 'COROADO                       ');
INSERT INTO cd_cep_br VALUES ('69.027-430', '156      ', 'BC FAVELA, DA', 'GLORIA                        ');
INSERT INTO cd_cep_br VALUES ('69.035-610', '156      ', 'R FE EM DEUS', 'COMPENSA                      ');
INSERT INTO cd_cep_br VALUES ('69.039-620', '156      ', 'R FE EM DEUS', 'N ISRAEL                      ');
INSERT INTO cd_cep_br VALUES ('69.075-380', '156      ', 'R FE EM DEUS', 'MAUAZINHO                     ');
INSERT INTO cd_cep_br VALUES ('69.048-270', '156      ', 'BC FE EM DEUS', 'PAZ                           ');
INSERT INTO cd_cep_br VALUES ('69.087-504', '156      ', 'R FE, DA', 'T NEVES                       ');
INSERT INTO cd_cep_br VALUES ('69.067-748', '156      ', 'BC FE, DA(II)', 'PETROPOLIS                    ');
INSERT INTO cd_cep_br VALUES ('69.067-745', '156      ', 'BC FE, DA(N JERUSALEM)', 'PETROPOLIS                    ');
INSERT INTO cd_cep_br VALUES ('69.059-462', '156      ', 'R FELICIDADE', 'S ETELVINA                    ');
INSERT INTO cd_cep_br VALUES ('69.075-410', '156      ', 'R FELICIDADE, DA', 'MAUAZINHO                     ');
INSERT INTO cd_cep_br VALUES ('69.075-390', '156      ', 'VL FELICIDADE, DA', 'MAUAZINHO                     ');
INSERT INTO cd_cep_br VALUES ('69.042-480', '156      ', 'R FELIPE CAMARAO (CJ D PEDRO II)', 'D PEDRO                       ');
INSERT INTO cd_cep_br VALUES ('69.044-430', '156      ', 'R FELISMINO CABRAL DE VASCONCELOS (CJ BELVEDERE)', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('69.070-620', '156      ', 'R FELISMINO SOARES', 'COL O MACHADO                 ');
INSERT INTO cd_cep_br VALUES ('69.082-510', '156      ', 'R FELIX VALOIS (O VERDE)', 'COROADO                       ');
INSERT INTO cd_cep_br VALUES ('69.029-580', '156      ', 'R FERNANDO DE SOUZA', 'S ANTONIO                     ');
INSERT INTO cd_cep_br VALUES ('69.042-490', '156      ', 'AV FERNAO DIAS PAES (CJ D PEDRO II)', 'D PEDRO                       ');
INSERT INTO cd_cep_br VALUES ('69.028-275', '156      ', 'R FERREIRA DIASBEIJA FLOR', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('69.010-140', '156      ', 'R FERREIRA PENA- ATE 670/691', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('69.025-010', '156      ', 'R FERREIRA PENA- DE 672/693 AO FIM', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('69.079-300', '156      ', 'R FERREIRA SOBRINHO', 'PETROPOLIS                    ');
INSERT INTO cd_cep_br VALUES ('69.084-601', '156      ', 'R FIGUEIREDO', 'Z PALMARES                    ');
INSERT INTO cd_cep_br VALUES ('69.067-750', '156      ', 'R FILEMON (N JERUSALEM)', 'PETROPOLIS                    ');
INSERT INTO cd_cep_br VALUES ('69.038-073', '156      ', 'BC FINAL 10', 'L VALE                        ');
INSERT INTO cd_cep_br VALUES ('69.020-600', '156      ', 'VL FLACY', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('69.075-400', '156      ', 'R FLAMENGO', 'MAUAZINHO                     ');
INSERT INTO cd_cep_br VALUES ('69.087-080', '156      ', 'R FLAVIO CAVALCANTE', 'T NEVES                       ');
INSERT INTO cd_cep_br VALUES ('69.080-710', '156      ', 'R FLAVIO COSTA', 'COROADO                       ');
INSERT INTO cd_cep_br VALUES ('69.080-720', '156      ', 'BC FLAVIO COSTA', 'COROADO                       ');
INSERT INTO cd_cep_br VALUES ('69.043-310', '156      ', 'R FLAVIO DE MOURA', 'ALVORADA                      ');
INSERT INTO cd_cep_br VALUES ('69.038-075', '156      ', 'BC FLOR DE LINS', 'L VALE                        ');
INSERT INTO cd_cep_br VALUES ('69.068-120', '156      ', 'BC FLORENCIO', 'RAIZ                          ');
INSERT INTO cd_cep_br VALUES ('69.073-151', '156      ', 'BC FLORENCIO', 'CRESPO                        ');
INSERT INTO cd_cep_br VALUES ('69.043-710', '156      ', 'BC FLORES', 'ALVORADA                      ');
INSERT INTO cd_cep_br VALUES ('69.048-292', '156      ', 'BC FLORES DAS', 'PAZ                           ');
INSERT INTO cd_cep_br VALUES ('69.010-370', '156      ', 'BC FLORES, DAS', 'APARECIDA                     ');
INSERT INTO cd_cep_br VALUES ('69.010-380', '156      ', 'R FLORES, DAS', 'APARECIDA                     ');
INSERT INTO cd_cep_br VALUES ('69.035-191', '156      ', 'BC FLORES, DAS', 'COMPENSA                      ');
INSERT INTO cd_cep_br VALUES ('69.054-530', '156      ', 'R EZIO FERREIRA', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('69.086-350', '156      ', 'R F', 'S J OPERARIO                  ');
INSERT INTO cd_cep_br VALUES ('69.043-090', '156      ', 'AV F', 'ALVORADA                      ');
INSERT INTO cd_cep_br VALUES ('69.089-100', '156      ', 'R F', 'A MENDES                      ');
INSERT INTO cd_cep_br VALUES ('69.055-692', '156      ', 'R F(CJ. JD. AMAZONAS)', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.038-255', '156      ', 'R F (CJ A MONTENEGRO)', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('69.057-640', '156      ', 'Q F (CJ A NERY)', 'ADRIANOPOLIS                  ');
INSERT INTO cd_cep_br VALUES ('69.097-160', '156      ', 'R F (CJ CANARANAS)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.043-250', '156      ', 'R F (CJ DE FLORES I)', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('69.029-480', '156      ', 'R F (CJ DOS BANCARIOS)', 'S ANTONIO                     ');
INSERT INTO cd_cep_br VALUES ('69.050-210', '156      ', 'R F (CJ ELDORADO)', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.030-390', '156      ', 'R F (CJ IPASE)', 'COMPENSA                      ');
INSERT INTO cd_cep_br VALUES ('69.060-310', '156      ', 'R F (CJ JD PAULISTA)', 'ALEIXO                        ');
INSERT INTO cd_cep_br VALUES ('69.053-660', '156      ', 'Q F (CJ MANAUENSE)', 'N S GRACAS                    ');
INSERT INTO cd_cep_br VALUES ('69.095-501', '156      ', 'AV F (CJ O FROTA I)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.095-490', '156      ', 'R F (CJ R JUNIOR)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.082-051', '156      ', 'R CORONEL PEDRO BARROS', 'COROADO                       ');
INSERT INTO cd_cep_br VALUES ('69.074-560', '156      ', 'R CORONEL PEDRO DE SOUZA', 'MRO LIBERDADE                 ');
INSERT INTO cd_cep_br VALUES ('69.010-490', '156      ', 'BC CORONEL SALGADO', 'APARECIDA                     ');
INSERT INTO cd_cep_br VALUES ('69.010-450', '156      ', 'R CORONEL SALGADO', 'APARECIDA                     ');
INSERT INTO cd_cep_br VALUES ('69.027-480', '156      ', 'BC CORONEL SALGADO', 'GLORIA                        ');
INSERT INTO cd_cep_br VALUES ('69.005-030', '156      ', 'R CORONEL SERGIO PESSOA', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('69.049-160', '156      ', 'R CORONEL SILVINO CAVALCANTE (CJ S DUMONT)', 'PAZ                           ');
INSERT INTO cd_cep_br VALUES ('69.044-150', '156      ', 'R CORONEL VALENTIM NORMANDO (CJ BELVEDERE)', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('69.059-170', '156      ', 'R COMERCIO DO', 'S ETELVINA                    ');
INSERT INTO cd_cep_br VALUES ('69.093-763', '156      ', 'R COMERCIO I, DO(T.NOVA II)', 'COL T NOVA                    ');
INSERT INTO cd_cep_br VALUES ('69.093-764', '156      ', 'R COMERCIO II, DO(T.NOVA II)', 'COL T NOVA                    ');
INSERT INTO cd_cep_br VALUES ('69.005-240', '156      ', 'BC COMERCIO, DO', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('69.077-010', '156      ', 'R COMERCIO, DO', 'JAPIIM                        ');
INSERT INTO cd_cep_br VALUES ('69.036-030', '156      ', 'R COMERCIO, DO', 'COMPENSA                      ');
INSERT INTO cd_cep_br VALUES ('69.055-000', '156      ', 'R COMERCIO, DO(CJ CASTELO BRANCO)', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.082-490', '156      ', 'R COMERCIO, DO(O VERDE)', 'COROADO                       ');
INSERT INTO cd_cep_br VALUES ('69.065-240', '156      ', 'BC CONCEICAO', 'CACHOEIRINHA                  ');
INSERT INTO cd_cep_br VALUES ('69.063-517', '156      ', 'BC CONCEICAO', 'PETROPOLIS                    ');
INSERT INTO cd_cep_br VALUES ('69.073-412', '156      ', 'TV CONCEICAO', 'BETANIA                       ');
INSERT INTO cd_cep_br VALUES ('69.042-790', '156      ', 'R CONCEICAO LINS', 'N ESPERANCA                   ');
INSERT INTO cd_cep_br VALUES ('69.027-120', '156      ', 'BC CONCORDIA, DA', 'S RAIMUNDO                    ');
INSERT INTO cd_cep_br VALUES ('90.58-781M', '156      ', 'CONDE DEU (PRQ LARANJEIRAS)', 'LORES                        6');
INSERT INTO cd_cep_br VALUES ('69.058-784', '156      ', 'R CONDE DE IRAJA (PRQ LARANJEIRAS)', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('69.058-582', '156      ', 'R CONDE DE ITAGUA (PRQ LARANJEIRAS)', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('69.058-410', '156      ', 'R CONDE DE SABARA (PRQ LARANJEIRAS)', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('69.058-780', '156      ', 'R CONDE DE SANTA CRUZ (PRQ LARANJEIRAS)', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('69.058-390', '156      ', 'R CONDE DE SAPUCAI (PRQ LARANJEIRAS)', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('69.058-402', '156      ', 'R CONDE DE SERGIMIRIM (PRQ LARANJEIRAS)', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('69.058-420', '156      ', 'R CONDE DE TONANTINS (PRQ LARANJEIRAS)', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('69.058-785', '156      ', 'R CONDE DE VERA CRUZ (PRQ LARANJEIRAS)', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('69.058-501', '156      ', 'R CONDE DO MARANHAO (PRQ LARANJEIRAS)', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('69.057-530', '156      ', 'CJ CONDOMINIO OURO PRETO', 'ADRIANOPOLIS                  ');
INSERT INTO cd_cep_br VALUES ('69.042-390', '156      ', 'BC CONGRESSO', 'ALVORADA                      ');
INSERT INTO cd_cep_br VALUES ('69.008-440', '156      ', 'PC CONGRESSO, DO', 'COL A ALEIXO                  ');
INSERT INTO cd_cep_br VALUES ('69.050-720', '156      ', 'TV CONQUISTA, DA', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('69.036-140', '156      ', 'BC CONSELHEIRO', 'COMPENSA                      ');
INSERT INTO cd_cep_br VALUES ('69.073-024', '156      ', 'BC CONSOLATA', 'BETANIA                       ');
INSERT INTO cd_cep_br VALUES ('69.073-820', '156      ', 'BC CONSOLATA, DA', 'BETANIA                       ');
INSERT INTO cd_cep_br VALUES ('69.010-160', '156      ', 'AV CONSTANTINO NERY- ATE 0956/1107', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('69.050-000', '156      ', 'AV CONSTANTINO NERY- DE 0958/1109 A 2086/2087', 'S GERALDO                     ');
INSERT INTO cd_cep_br VALUES ('69.050-001', '156      ', 'AV CONSTANTINO NERY- DE 2088/2089 A 2454/2455', 'CHAPADA                       ');
INSERT INTO cd_cep_br VALUES ('69.050-002', '156      ', 'AV CONSTANTINO NERY- DE 2456/2457 AO FIM', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('69.045-000', '156      ', 'AV CONSTANTINOPLA (CJ C ELISIOS)', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('69.060-081', '156      ', 'AV CONSTELACAO (CJ M DO SOL)', 'ALEIXO                        ');
INSERT INTO cd_cep_br VALUES ('69.073-780', '156      ', 'R CONSTITUICAO, DA', 'BETANIA                       ');
INSERT INTO cd_cep_br VALUES ('69.059-180', '156      ', 'R CONSTITUINTE', 'S ETELVINA                    ');
INSERT INTO cd_cep_br VALUES ('69.036-250', '156      ', 'R CLOVIS BARROSO BRAGA (CJ R XINGU)', 'COMPENSA                      ');
INSERT INTO cd_cep_br VALUES ('69.079-490', '156      ', 'PC COARI', 'S FRANCISCO                   ');
INSERT INTO cd_cep_br VALUES ('69.093-089', '156      ', 'R COARI(T. NOVA II)', 'COL T NOVA                    ');
INSERT INTO cd_cep_br VALUES ('69.074-240', '156      ', 'R COARI (VL MILITAR PONTA PELADA)', 'S LAZARO                      ');
INSERT INTO cd_cep_br VALUES ('69.045-330', '156      ', 'R COCHABAMBA (CJ C ELISIOS)', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('69.065-130', '156      ', 'AV CODAJAS', 'CACHOEIRINHA                  ');
INSERT INTO cd_cep_br VALUES ('69.079-000', '156      ', 'R CODAJAS', 'PETROPOLIS                    ');
INSERT INTO cd_cep_br VALUES ('69.079-001', '156      ', 'BC CODAJAS', 'PETROPOLIS                    ');
INSERT INTO cd_cep_br VALUES ('69.088-130', '156      ', 'AV COLETORA NORTE SUL', 'J TEIXEIRA                    ');
INSERT INTO cd_cep_br VALUES ('69.082-480', '156      ', 'AV COLIBRI (O VERDE)', 'COROADO                       ');
INSERT INTO cd_cep_br VALUES ('69.027-052', '156      ', 'TV COLINA', 'S RAIMUNDO                    ');
INSERT INTO cd_cep_br VALUES ('69.075-241', '156      ', 'TV COLLOR DE MELO', 'MAUAZINHO                     ');
INSERT INTO cd_cep_br VALUES ('69.050-480', '156      ', 'R COLOMBIA (CJ ELDORADO)', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.037-190', '156      ', 'AL COLOMBIA (CJ JD AMERICA)', 'P NEGRA                       ');
INSERT INTO cd_cep_br VALUES ('69.028-190', '156      ', 'R COLOMBIA (PRQ NACOES)', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('69.037-592', '156      ', 'BC COLOMBO', 'P NEGRA                       ');
INSERT INTO cd_cep_br VALUES ('69.049-010', '156      ', 'R COMANDANTE ATLAS CATANHEDE (CJ S DUMONT)', 'PAZ                           ');
INSERT INTO cd_cep_br VALUES ('69.049-030', '156      ', 'R COMANDANTE CARLOS NATROTT (CJ S DUMONT)', 'PAZ                           ');
INSERT INTO cd_cep_br VALUES ('69.049-040', '156      ', 'R COMANDANTE CESAR AGUIAR (CJ S DUMONT)', 'PAZ                           ');
INSERT INTO cd_cep_br VALUES ('69.049-050', '156      ', 'R COMANDANTE EDNO RIOS (CJ S DUMONT)', 'PAZ                           ');
INSERT INTO cd_cep_br VALUES ('69.049-060', '156      ', 'R COMANDANTE EYNER ENCARNACAO (CJ S DUMONT)', 'PAZ                           ');
INSERT INTO cd_cep_br VALUES ('69.073-060', '156      ', 'R COMANDANTE FERRAZ', 'BETANIA                       ');
INSERT INTO cd_cep_br VALUES ('69.049-070', '156      ', 'R COMANDANTE HENRIQUE BASTOS (CJ S DUMONT)', 'PAZ                           ');
INSERT INTO cd_cep_br VALUES ('69.049-080', '156      ', 'R COMANDANTE JOSE SIQUEIRA (CJ S DUMONT)', 'PAZ                           ');
INSERT INTO cd_cep_br VALUES ('69.049-090', '156      ', 'R COMANDANTE NATHANAEL ALBUQUERQUE (CJ S DUMONT)', 'PAZ                           ');
INSERT INTO cd_cep_br VALUES ('69.049-100', '156      ', 'R COMANDANTE NOBERTO VON GAL (CJ S DUMONT)', 'PAZ                           ');
INSERT INTO cd_cep_br VALUES ('69.049-110', '156      ', 'R COMANDANTE PAULO LASMAR (CJ S DUMONT)', 'PAZ                           ');
INSERT INTO cd_cep_br VALUES ('69.049-120', '156      ', 'R COMANDANTE PAULO VARELA (CJ S DUMONT)', 'PAZ                           ');
INSERT INTO cd_cep_br VALUES ('69.049-130', '156      ', 'R COMANDANTE RANGEL (CJ S DUMONT)', 'PAZ                           ');
INSERT INTO cd_cep_br VALUES ('69.068-230', '156      ', 'BC COMANDANTE REMEDIOS', 'RAIZ                          ');
INSERT INTO cd_cep_br VALUES ('69.049-140', '156      ', 'R COMANDANTE THEOPHILO MATOS (CJ S DUMONT)', 'PAZ                           ');
INSERT INTO cd_cep_br VALUES ('69.049-150', '156      ', 'R COMANDANTE WALDIR BASTOS (CJ S DUMONT)', 'PAZ                           ');
INSERT INTO cd_cep_br VALUES ('69.025-110', '156      ', 'BC COMENDADOR CLEMENTINO', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('69.025-000', '156      ', 'R COMENDADOR CLEMENTINO', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('69.025-100', '156      ', 'TV COMENDADOR CLEMENTINO', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('69.029-130', '156      ', 'R COMENDADOR J. G. ARAUJO', 'S ANTONIO                     ');
INSERT INTO cd_cep_br VALUES ('69.029-200', '156      ', 'R COMENDADOR MATOS AREOSA', 'S ANTONIO                     ');
INSERT INTO cd_cep_br VALUES ('69.054-390', '156      ', 'R COMERCIAL (CJ B BELA)', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.067-640', '156      ', 'R CHICO MENDES (VLE AMANHECER)', 'PETROPOLIS                    ');
INSERT INTO cd_cep_br VALUES ('69.037-561', '156      ', 'R CHICO MESDES(L.M.NOGUEIRA)', 'N ESPERANCA                   ');
INSERT INTO cd_cep_br VALUES ('69.093-461', '156      ', 'R CHICO XAVIERT. NOVA I)', 'COL T NOVA                    ');
INSERT INTO cd_cep_br VALUES ('69.068-540', '156      ', 'R CHILE', 'RAIZ                          ');
INSERT INTO cd_cep_br VALUES ('69.057-280', '156      ', 'PC CHILE', 'ADRIANOPOLIS                  ');
INSERT INTO cd_cep_br VALUES ('69.037-170', '156      ', 'AL CHILE (CJ JD AMERICA)', 'P NEGRA                       ');
INSERT INTO cd_cep_br VALUES ('69.050-620', '156      ', 'CJ CIDADE JARDIM', 'CHAPADA                       ');
INSERT INTO cd_cep_br VALUES ('69.085-645', '156      ', 'R CINCO (ASTECA)', 'S J OPERARIO                  ');
INSERT INTO cd_cep_br VALUES ('69.055-052', '156      ', 'R CINCO (CJ BELO HORIZONTE)', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.086-625', '156      ', 'R BRITO, SD', 'S J OPERARIO                  ');
INSERT INTO cd_cep_br VALUES ('69.088-100', '156      ', 'R BROMELIAS, DAS', 'J TEIXEIRA                    ');
INSERT INTO cd_cep_br VALUES ('69.045-260', '156      ', 'R BRUXELAS (CJ C ELISIOS)', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('69.045-650', '156      ', 'R BUCAREST (CJ C ELISIOS)', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('69.039-320', '156      ', 'TV BUENO', 'N ISRAEL                      ');
INSERT INTO cd_cep_br VALUES ('69.029-380', '156      ', 'R BUENOS AIRES', 'S ANTONIO                     ');
INSERT INTO cd_cep_br VALUES ('69.045-270', '156      ', 'R BUENOS AIRES (CJ C ELISIOS)', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('69.095-210', '156      ', 'AV BUIGANA (CJ C NOVA)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.088-580', '156      ', 'R BULGALIAS, DAS', 'J TEIXEIRA                    ');
INSERT INTO cd_cep_br VALUES ('69.088-090', '156      ', 'R BULGANVILEAS, DAS', 'J TEIXEIRA                    ');
INSERT INTO cd_cep_br VALUES ('69.075-000', '156      ', 'AV BURITI', 'DT INDUSTRIAL                 ');
INSERT INTO cd_cep_br VALUES ('69.082-750', '156      ', 'R BURITI', 'COROADO                       ');
INSERT INTO cd_cep_br VALUES ('69.037-540', '156      ', 'BC BURITI', 'N ESPERANCA                   ');
INSERT INTO cd_cep_br VALUES ('69.075-510', '156      ', 'VL BURITI', 'DT INDUSTRIAL                 ');
INSERT INTO cd_cep_br VALUES ('69.084-051', '156      ', 'R BURITI', 'Z PALMARES                    ');
INSERT INTO cd_cep_br VALUES ('69.054-720', '156      ', 'R BURITI', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.054-721', '156      ', 'BC BURITI', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.059-660', '156      ', 'AV BURITI', 'S ETELVINA                    ');
INSERT INTO cd_cep_br VALUES ('69.035-642', '156      ', 'BC BURITI', 'COMPENSA                      ');
INSERT INTO cd_cep_br VALUES ('69.095-090', '156      ', 'R BURITI (CJ C NOVA)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.082-645', '156      ', 'R BURITI (MONTE CASTELO)', 'COROADO                       ');
INSERT INTO cd_cep_br VALUES ('69.093-757', '156      ', 'R BURITIZAL(T. NOVA II)', 'COL T NOVA                    ');
INSERT INTO cd_cep_br VALUES ('69.086-320', '156      ', 'R C', 'S J OPERARIO                  ');
INSERT INTO cd_cep_br VALUES ('69.043-060', '156      ', 'AV C', 'ALVORADA                      ');
INSERT INTO cd_cep_br VALUES ('69.089-030', '156      ', 'R C', 'A MENDES                      ');
INSERT INTO cd_cep_br VALUES ('69.089-032', '156      ', 'TV C', 'A MENDES                      ');
INSERT INTO cd_cep_br VALUES ('69.028-213', '156      ', 'R CPARQUE CENTENARIO', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('69.038-252', '156      ', 'R C (CJ A MONTENEGRO)', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('69.065-030', '156      ', 'R BORBA', 'CACHOEIRINHA                  ');
INSERT INTO cd_cep_br VALUES ('69.081-180', '156      ', 'R BOTO-TUCUXI', 'J TEIXEIRA                    ');
INSERT INTO cd_cep_br VALUES ('69.098-054', '156      ', 'R BOTUROBI(A. CLARAS)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.020-460', '156      ', 'BC BOULEVARD', 'PC 14 JANEIRO                 ');
INSERT INTO cd_cep_br VALUES ('69.025-350', '156      ', 'BC BRAGANCA', 'P VARGAS                      ');
INSERT INTO cd_cep_br VALUES ('69.047-550', '156      ', 'R BRAGANCA', 'REDENCAO                      ');
INSERT INTO cd_cep_br VALUES ('69.040-390', '156      ', 'AV BRAGANCA (CJ DEBORAH)', 'D PEDRO                       ');
INSERT INTO cd_cep_br VALUES ('69.027-031', '156      ', 'R BRANCO', 'S RAIMUNDO                    ');
INSERT INTO cd_cep_br VALUES ('69.060-170', '156      ', 'R BRANCO E SILVA', 'ALEIXO                        ');
INSERT INTO cd_cep_br VALUES ('69.074-640', '156      ', 'R BRANCO E SILVA', 'S LUZIA                       ');
INSERT INTO cd_cep_br VALUES ('69.074-690', '156      ', 'BC BRANCO E SILVA', 'MRO LIBERDADE                 ');
INSERT INTO cd_cep_br VALUES ('69.088-831', '156      ', 'R BRANQUINHA', 'J TEIXEIRA                    ');
INSERT INTO cd_cep_br VALUES ('69.050-071', '156      ', 'R BRAS CUBAS (VL BAFURURU)', 'CHAPADA                       ');
INSERT INTO cd_cep_br VALUES ('69.010-440', '156      ', 'BC BRASIL', 'APARECIDA                     ');
INSERT INTO cd_cep_br VALUES ('69.030-020', '156      ', 'R BRASIL', 'COMPENSA                      ');
INSERT INTO cd_cep_br VALUES ('69.036-110', '156      ', 'AV BRASIL', 'COMPENSA                      ');
INSERT INTO cd_cep_br VALUES ('69.030-010', '156      ', 'BC BRASIL', 'COMPENSA                      ');
INSERT INTO cd_cep_br VALUES ('69.080-110', '156      ', 'BC BRASIL', 'COROADO                       ');
INSERT INTO cd_cep_br VALUES ('69.080-350', '156      ', 'R BRASIL', 'COROADO                       ');
INSERT INTO cd_cep_br VALUES ('69.070-360', '156      ', 'R BRASIL', 'EDUCANDOS                     ');
INSERT INTO cd_cep_br VALUES ('69.078-570', '156      ', 'R BRASIL', 'JAPIIM                        ');
INSERT INTO cd_cep_br VALUES ('69.074-767', '156      ', 'R BRASIL', 'MRO LIBERDADE                 ');
INSERT INTO cd_cep_br VALUES ('69.053-480', '156      ', 'R BRASIL', 'N S GRACAS                    ');
INSERT INTO cd_cep_br VALUES ('69.047-400', '156      ', 'R BRASIL', 'REDENCAO                      ');
INSERT INTO cd_cep_br VALUES ('69.036-650', '156      ', 'BC BRASIL', 'S AGOSTINHO                   ');
INSERT INTO cd_cep_br VALUES ('69.029-040', '156      ', 'AV BRASIL', 'S ANTONIO                     ');
INSERT INTO cd_cep_br VALUES ('69.033-070', '156      ', 'R BRASIL', 'S JORGE                       ');
INSERT INTO cd_cep_br VALUES ('69.073-110', '156      ', 'R BRASIL', 'S LAZARO                      ');
INSERT INTO cd_cep_br VALUES ('69.087-330', '156      ', 'R BRASIL', 'T NEVES                       ');
INSERT INTO cd_cep_br VALUES ('69.086-570', '156      ', 'R BRASIL', 'S J OPERARIO                  ');
INSERT INTO cd_cep_br VALUES ('69.039-220', '156      ', 'R BRASIL', 'N ISRAEL                      ');
INSERT INTO cd_cep_br VALUES ('69.073-111', '156      ', 'BC BRASIL', 'S LAZARO                      ');
INSERT INTO cd_cep_br VALUES ('69.047-410', '156      ', 'BC BRASIL', 'REDENCAO                      ');
INSERT INTO cd_cep_br VALUES ('69.063-431', '156      ', 'R BRASIL', 'PETROPOLIS                    ');
INSERT INTO cd_cep_br VALUES ('69.028-040', '156      ', 'AV BRASIL (PRQ NACOES)', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('69.028-221', '156      ', 'R BRASIL (PRQ NACOES)', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('69.036-090', '156      ', 'R BRASILEIA', 'COMPENSA                      ');
INSERT INTO cd_cep_br VALUES ('69.098-026', '156      ', 'R BRASILEIA(A. CLARAS)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.045-250', '156      ', 'R BOGOTA (CJ C ELISIOS)', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('69.081-360', '156      ', 'R BOIACU', 'J TEIXEIRA                    ');
INSERT INTO cd_cep_br VALUES ('69.037-280', '156      ', 'AL BOLIVIA ( CJ JD AMERICA)', 'P NEGRA                       ');
INSERT INTO cd_cep_br VALUES ('69.035-671', '156      ', 'BC BOM JARDIM', 'COMPENSA                      ');
INSERT INTO cd_cep_br VALUES ('69.035-670', '156      ', 'R BOM JARDIM', 'COMPENSA                      ');
INSERT INTO cd_cep_br VALUES ('69.059-501', '156      ', 'R BOM JARDIM', 'S ETELVINA                    ');
INSERT INTO cd_cep_br VALUES ('69.067-473', '156      ', 'R BOM JARDIM', 'PETROPOLIS                    ');
INSERT INTO cd_cep_br VALUES ('69.039-103', '156      ', 'BC BOM JARDIM', 'N ISRAEL                      ');
INSERT INTO cd_cep_br VALUES ('69.080-080', '156      ', 'BC BOM JESUS', 'COROADO                       ');
INSERT INTO cd_cep_br VALUES ('69.080-100', '156      ', 'TV BOM JESUS', 'COROADO                       ');
INSERT INTO cd_cep_br VALUES ('69.078-130', '156      ', 'R BOM JESUS', 'JAPIIM                        ');
INSERT INTO cd_cep_br VALUES ('69.047-101', '156      ', 'BC BOM JESUS', 'REDENCAO                      ');
INSERT INTO cd_cep_br VALUES ('69.047-100', '156      ', 'R BOM JESUS', 'REDENCAO                      ');
INSERT INTO cd_cep_br VALUES ('69.075-280', '156      ', 'R BOM JESUS', 'MAUAZINHO                     ');
INSERT INTO cd_cep_br VALUES ('69.075-770', '156      ', 'BC BOM JESUS', 'MAUAZINHO                     ');
INSERT INTO cd_cep_br VALUES ('69.084-040', '156      ', 'R BOM JESUS', 'Z PALMARES                    ');
INSERT INTO cd_cep_br VALUES ('69.039-540', '156      ', 'R BOM JESUS', 'N ISRAEL                      ');
INSERT INTO cd_cep_br VALUES ('69.067-361', '156      ', 'BC BOM JESUS', 'PETROPOLIS                    ');
INSERT INTO cd_cep_br VALUES ('69.089-330', '156      ', 'R BOM JESUS', 'A MENDES                      ');
INSERT INTO cd_cep_br VALUES ('69.089-331', '156      ', 'TV BOM JESUS', 'A MENDES                      ');
INSERT INTO cd_cep_br VALUES ('69.067-445', '156      ', 'R BOM JESUS', 'PETROPOLIS                    ');
INSERT INTO cd_cep_br VALUES ('69.035-321', '156      ', 'BC BOM JESUS', 'COMPENSA                      ');
INSERT INTO cd_cep_br VALUES ('69.067-302', '156      ', 'BC BOM JESUS (N JERUSALEM)', 'PETROPOLIS                    ');
INSERT INTO cd_cep_br VALUES ('69.028-340', '156      ', 'R BOM PASTOR', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('69.059-070', '156      ', 'R BOM PASTOR', 'S ETELVINA                    ');
INSERT INTO cd_cep_br VALUES ('69.073-790', '156      ', 'BC BOM PASTOR', 'BETANIA                       ');
INSERT INTO cd_cep_br VALUES ('69.087-453', '156      ', 'R BOM PASTOR', 'T NEVES                       ');
INSERT INTO cd_cep_br VALUES ('69.039-806', '156      ', 'R BOM PASTOR', 'N ISRAEL                      ');
INSERT INTO cd_cep_br VALUES ('69.070-370', '156      ', 'BC BOMBA, DA', 'EDUCANDOS                     ');
INSERT INTO cd_cep_br VALUES ('69.073-220', '156      ', 'R BOMBA, DA', 'S LAZARO                      ');
INSERT INTO cd_cep_br VALUES ('69.035-351', '156      ', 'EST BOMBEAMENTO, DO(VL MARINHO)', 'COMPENSA                      ');
INSERT INTO cd_cep_br VALUES ('69.093-051', '156      ', 'R BONIFACIO', 'COL S ANTONIO                 ');
INSERT INTO cd_cep_br VALUES ('69.088-080', '156      ', 'R BONINAS, DAS', 'J TEIXEIRA                    ');
INSERT INTO cd_cep_br VALUES ('69.045-050', '156      ', 'R BONN (CJ C ELISIOS)', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('69.060-820', '156      ', 'AL BONS AMIGOS', 'ALEIXO                        ');
INSERT INTO cd_cep_br VALUES ('69.060-030', '156      ', 'R BONSUCESSO', 'ALEIXO                        ');
INSERT INTO cd_cep_br VALUES ('69.060-031', '156      ', 'BC BONSUCESSO', 'ALEIXO                        ');
INSERT INTO cd_cep_br VALUES ('69.020-760', '156      ', 'R BOA ESPERANCA', 'PC 14 JANEIRO                 ');
INSERT INTO cd_cep_br VALUES ('69.073-150', '156      ', 'R BOA ESPERANCA', 'CRESPO                        ');
INSERT INTO cd_cep_br VALUES ('69.073-188', '156      ', 'BC BOA ESPERANCA', 'CRESPO                        ');
INSERT INTO cd_cep_br VALUES ('69.030-131', '156      ', 'BC BOA FE', 'S JORGE                       ');
INSERT INTO cd_cep_br VALUES ('69.033-808', '156      ', 'R BOA FE', 'S JORGE                       ');
INSERT INTO cd_cep_br VALUES ('69.065-290', '156      ', 'BC BOA NOVA', 'CACHOEIRINHA                  ');
INSERT INTO cd_cep_br VALUES ('69.082-010', '156      ', 'BC BOA SORTE', 'COROADO                       ');
INSERT INTO cd_cep_br VALUES ('69.094-580', '156      ', 'R 76 (NUCLEO 4)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.099-660', '156      ', 'R 77 (A MENDES)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.097-767', '156      ', 'R 77 (CJ S PESSOA)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.094-600', '156      ', 'R 77 (NUCLEO 14)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.153-170', '161      ', 'R MANICORE', 'PALMARES                      ');
INSERT INTO cd_cep_br VALUES ('69.152-460', '161      ', 'R MARAJO', 'D VIEIRA                      ');
INSERT INTO cd_cep_br VALUES ('69.153-290', '161      ', 'R MARCOS ZAGURY', 'S R CASSIA                    ');
INSERT INTO cd_cep_br VALUES ('69.151-570', '161      ', 'R MARECHAL CASTELO BRANCO- ATE 1210/1211', 'S CLARA                       ');
INSERT INTO cd_cep_br VALUES ('69.151-560', '161      ', 'R MARECHAL CASTELO BRANCO- DE 1212/1213 AO FIM', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('69.151-730', '161      ', 'R MARIMARI (CJ MACURANI)', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('69.152-170', '161      ', 'BC MATADOURO, DO', 'S JOSE                        ');
INSERT INTO cd_cep_br VALUES ('69.151-530', '161      ', 'BC MAU', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('69.153-210', '161      ', 'R MAUES', 'PALMARES                      ');
INSERT INTO cd_cep_br VALUES ('69.152-490', '161      ', 'R MOCAMBO', 'D VIEIRA                      ');
INSERT INTO cd_cep_br VALUES ('69.153-380', '161      ', 'R MOZART DE FREITAS', 'E MOREIRA                     ');
INSERT INTO cd_cep_br VALUES ('69.152-650', '161      ', 'R MURUCI (CJ MACURANI)', 'S F ASSIS                     ');
INSERT INTO cd_cep_br VALUES ('69.151-060', '161      ', 'AV NACOES UNIDAS- ATE 3150/3151', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('69.151-680', '161      ', 'R DESEMBARGADOR JOAO CORREA', 'S CLARA                       ');
INSERT INTO cd_cep_br VALUES ('69.153-460', '161      ', 'R DOM ARCANGELO CERQUA', 'S VICENTE                     ');
INSERT INTO cd_cep_br VALUES ('69.152-630', '161      ', 'R DOMINGOS PRESTES (CJ CHAM)', 'S F ASSIS                     ');
INSERT INTO cd_cep_br VALUES ('69.152-720', '161      ', 'R DOUTOR AFONSO MARANHAO- ATE 1178/1179', 'S F ASSIS                     ');
INSERT INTO cd_cep_br VALUES ('69.153-360', '161      ', 'R DOUTOR AFONSO MARANHAO- DE 1180/1181 AO FIM', 'E MOREIRA                     ');
INSERT INTO cd_cep_br VALUES ('69.152-330', '161      ', 'Q E (CJ J NOVO)', 'D VIEIRA                      ');
INSERT INTO cd_cep_br VALUES ('69.151-170', '161      ', 'R EDILCE BARANDA', 'S CLARA                       ');
INSERT INTO cd_cep_br VALUES ('69.151-271', '161      ', 'PC EDUARDO RIBEIRO', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('69.153-320', '161      ', 'R EULINA FARIAS', 'S R CASSIA                    ');
INSERT INTO cd_cep_br VALUES ('69.151-690', '161      ', 'R EURIPEDES PRADO', 'S CLARA                       ');
INSERT INTO cd_cep_br VALUES ('69.152-340', '161      ', 'Q F (CJ J NOVO)', 'D VIEIRA                      ');
INSERT INTO cd_cep_br VALUES ('69.152-080', '161      ', 'BC FARIA LOPES', 'S BENEDITO                    ');
INSERT INTO cd_cep_br VALUES ('69.151-320', '161      ', 'R FARIA NETO', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('69.153-020', '161      ', 'R FORTALEZA', 'PALMARES                      ');
INSERT INTO cd_cep_br VALUES ('69.151-640', '161      ', 'R FRANCISCO AUGUSTO BELEM', 'S CLARA                       ');
INSERT INTO cd_cep_br VALUES ('69.152-570', '161      ', 'R FRANCISCO XAVIER (CJ CHAM)', 'S F ASSIS                     ');
INSERT INTO cd_cep_br VALUES ('69.151-070', '161      ', 'AV FURTADO BELEM', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('69.151-540', '161      ', 'BC FURTADO BELEM', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('69.152-350', '161      ', 'Q G (CJ J NOVO)', 'D VIEIRA                      ');
INSERT INTO cd_cep_br VALUES ('69.151-641', '161      ', 'PC GENTIL BELEM', 'S CLARA                       ');
INSERT INTO cd_cep_br VALUES ('69.151-080', '161      ', 'R GETULIO VARGAS', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('69.151-460', '161      ', 'R GOVERNADOR LEOPOLDO NEVES', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('69.152-110', '161      ', 'BC GREGORIO', 'S BENEDITO                    ');
INSERT INTO cd_cep_br VALUES ('69.152-360', '161      ', 'Q H (CJ J NOVO)', 'D VIEIRA                      ');
INSERT INTO cd_cep_br VALUES ('69.151-160', '161      ', 'R HERBERT AZEVEDO- ATE 1170/1171', 'S CLARA                       ');
INSERT INTO cd_cep_br VALUES ('69.151-580', '161      ', 'R HERBERT AZEVEDO- DE 1172/1173 AO FIM', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('69.151-550', '161      ', 'BC HORTULANO', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('69.152-370', '161      ', 'Q I (CJ J NOVO)', 'D VIEIRA                      ');
INSERT INTO cd_cep_br VALUES ('69.151-380', '161      ', 'BC INDEPENDENCIA', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('69.151-400', '161      ', 'PSG INDEPENDENCIA', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('69.152-660', '161      ', 'R INGA (CJ MACURANI)', 'S F ASSIS                     ');
INSERT INTO cd_cep_br VALUES ('69.152-430', '161      ', 'R ITABORAI', 'D VIEIRA                      ');
INSERT INTO cd_cep_br VALUES ('69.153-080', '161      ', 'R ITACOATIARA', 'PALMARES                      ');
INSERT INTO cd_cep_br VALUES ('69.153-140', '161      ', 'R ITAPIRANGA', 'PALMARES                      ');
INSERT INTO cd_cep_br VALUES ('69.151-490', '161      ', 'BC ITAPIRANGA', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('69.151-660', '161      ', 'R IZABEL BELEM', 'S CLARA                       ');
INSERT INTO cd_cep_br VALUES ('69.152-380', '161      ', 'Q J (CJ J NOVO)', 'D VIEIRA                      ');
INSERT INTO cd_cep_br VALUES ('69.151-330', '161      ', 'R J TEIXEIRA', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('69.153-440', '161      ', 'R ANTONIO SANTIAGO', 'S VICENTE                     ');
INSERT INTO cd_cep_br VALUES ('69.153-410', '161      ', 'R ANTONIO SERGIO DA SILVA', 'S VICENTE                     ');
INSERT INTO cd_cep_br VALUES ('69.152-000', '161      ', 'R ARMANDO PRADO- DE 3082/3083 AO FIM', 'S BENEDITO                    ');
INSERT INTO cd_cep_br VALUES ('69.151-010', '161      ', 'R ARMANDO PRADO- 3080/3081', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('69.152-620', '161      ', 'R ARMINIO PRESTES (CJ SHAM)', 'S F ASSIS                     ');
INSERT INTO cd_cep_br VALUES ('69.153-480', '161      ', 'R ASSOCIACAO, DA', 'S VICENTE                     ');
INSERT INTO cd_cep_br VALUES ('69.152-300', '161      ', 'Q B (CJ J NOVO)', 'D VIEIRA                      ');
INSERT INTO cd_cep_br VALUES ('69.153-400', '161      ', 'R BALBINO NORONHA', 'E MOREIRA                     ');
INSERT INTO cd_cep_br VALUES ('69.152-090', '161      ', 'BC BARBOSA', 'S BENEDITO                    ');
INSERT INTO cd_cep_br VALUES ('69.153-030', '161      ', 'R BARREIRINHA', 'PALMARES                      ');
INSERT INTO cd_cep_br VALUES ('69.152-270', '161      ', 'BC BARRETO BATISTA', 'J ESTEVES                     ');
INSERT INTO cd_cep_br VALUES ('69.152-280', '161      ', 'PSG BARRETO BATISTA', 'J ESTEVES                     ');
INSERT INTO cd_cep_br VALUES ('69.153-310', '161      ', 'R BEIRA MAR', 'S R CASSIA                    ');
INSERT INTO cd_cep_br VALUES ('69.151-270', '161      ', 'R BENJAMIM DA SILVA', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('69.153-060', '161      ', 'R BENJAMIM RONDON', 'PALMARES                      ');
INSERT INTO cd_cep_br VALUES ('69.152-670', '161      ', 'R BURUTI (CJ MACURANI)', 'S F ASSIS                     ');
INSERT INTO cd_cep_br VALUES ('69.152-310', '161      ', 'Q C (CJ J NOVO)', 'D VIEIRA                      ');
INSERT INTO cd_cep_br VALUES ('69.152-480', '161      ', 'R CABURI', 'D VIEIRA                      ');
INSERT INTO cd_cep_br VALUES ('69.151-310', '161      ', 'R CAETANO PRESTES', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('69.152-120', '161      ', 'PSG CAMARAO', 'S BENEDITO                    ');
INSERT INTO cd_cep_br VALUES ('69.151-500', '161      ', 'R CAPITAO PEDRO FERREIRA', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('69.152-520', '161      ', 'R VALERIA', 'D VIEIRA                      ');
INSERT INTO cd_cep_br VALUES ('69.151-710', '161      ', 'R VENEZUELA', 'S CLARA                       ');
INSERT INTO cd_cep_br VALUES ('69.152-180', '161      ', 'RMP VICENTE REIS', 'S JOSE                        ');
INSERT INTO cd_cep_br VALUES ('12.924-510', '4897     ', 'R PELICANO', 'COND JD PALMEIRAS             ');
INSERT INTO cd_cep_br VALUES ('69.152-040', '161      ', 'AV VICENTE REIS- ATE 3450/3451', 'S BENEDITO                    ');
INSERT INTO cd_cep_br VALUES ('69.152-140', '161      ', 'AV VICENTE REIS- DE 3452/3453 AO FIM', 'S JOSE                        ');
INSERT INTO cd_cep_br VALUES ('69.151-290', '161      ', 'R VIEIRA JUNIOR', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('69.153-270', '161      ', 'R WALDEMAR M. FILHO', 'S R CASSIA                    ');
INSERT INTO cd_cep_br VALUES ('69.151-370', '161      ', 'PSG ZE MENEZES', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('69.153-490', '161      ', 'BC 1', 'S VICENTE                     ');
INSERT INTO cd_cep_br VALUES ('69.152-010', '161      ', 'AV NACOES UNIDAS- DE 3152/3153 AO FIM', 'S BENEDITO                    ');
INSERT INTO cd_cep_br VALUES ('69.151-670', '161      ', 'AV NAKAUTH', 'S CLARA                       ');
INSERT INTO cd_cep_br VALUES ('69.151-510', '161      ', 'R NEIL ARMSTRONG', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('69.153-050', '161      ', 'R NHAMUNDA', 'PALMARES                      ');
INSERT INTO cd_cep_br VALUES ('69.152-470', '161      ', 'EST ODOVALDO NOVO', 'D VIEIRA                      ');
INSERT INTO cd_cep_br VALUES ('69.152-240', '161      ', 'R ONELDES MARTINS', 'J ESTEVES                     ');
INSERT INTO cd_cep_br VALUES ('69.151-390', '161      ', 'BC ORIENTAL', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('69.152-200', '161      ', 'R PADRE COLOMBO', 'J ESTEVES                     ');
INSERT INTO cd_cep_br VALUES ('69.152-190', '161      ', 'R PADRE JORGE FREZZINE', 'J ESTEVES                     ');
INSERT INTO cd_cep_br VALUES ('69.151-650', '161      ', 'R PADRE MARTINS', 'S CLARA                       ');
INSERT INTO cd_cep_br VALUES ('69.153-110', '161      ', 'R PADRE TORQUATO', 'PALMARES                      ');
INSERT INTO cd_cep_br VALUES ('69.151-090', '161      ', 'AV PADRE VICTOR- ATE 814/815', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('69.153-160', '161      ', 'R PADRE VICTOR- DE 816/817 AO FIM', 'PALMARES                      ');
INSERT INTO cd_cep_br VALUES ('69.151-200', '161      ', 'AV PAES DE ANDRADE', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('69.151-720', '161      ', 'R PAJURA (CJ MACURANI)', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.071-280', '54       ', 'AV CORINTHO CAMPELO DA PAZ,ENGENHEIRO', 'A S DUMONT                    ');
INSERT INTO cd_cep_br VALUES ('57.014-560', '54       ', 'AV CORINTHO CAMPELO DA PAZ,PREFEITO', 'V LAGO                        ');
INSERT INTO cd_cep_br VALUES ('69.094-430', '156      ', 'R 62 (NUCLEO 4)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.098-680', '156      ', 'R 63 (A MENDES)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.094-450', '156      ', 'R 63 (NUCLEO 4)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.099-350', '156      ', 'R 64 (A MENDES)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.094-460', '156      ', 'R 64 (NUCLEO 4)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.099-570', '156      ', 'R 65 (A MENDES)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.094-470', '156      ', 'R 65 (NUCLEO 4)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.099-580', '156      ', 'R 66 (A MENDES)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.097-124', '156      ', 'R 66 (CJ F MENDES II)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.094-480', '156      ', 'R 66 (NUCLEO 4)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.098-690', '156      ', 'R 67 (A MENDES)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.094-490', '156      ', 'R 67 (NUCLEO 4)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.099-590', '156      ', 'R 68 (A MENDES)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.097-123', '156      ', 'R 68 (CJ F MENDES II)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.094-500', '156      ', 'R 68 (NUCLEO 4)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.099-600', '156      ', 'R 69 (A MENDES)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.097-782', '156      ', 'R 69 (CJ O FROTA II)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.094-510', '156      ', 'R 69 (NUCLEO 4)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.089-082', '156      ', 'R 7', 'A MENDES                      ');
INSERT INTO cd_cep_br VALUES ('69.099-040', '156      ', 'R 7 (A MENDES)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.086-081', '156      ', 'R 7 A', 'S J OPERARIO                  ');
INSERT INTO cd_cep_br VALUES ('69.086-083', '156      ', 'R 7-B', 'S J OPERARIO                  ');
INSERT INTO cd_cep_br VALUES ('69.099-610', '156      ', 'R 70 (A MENDES)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.097-122', '156      ', 'R 70 (CJ F MENDES II)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.094-520', '156      ', 'R 70 (NUCLEO 4)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.099-250', '156      ', 'R 49 (A MENDES)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.097-749', '156      ', 'R 49 (CJ O FROTA II)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.077-500', '156      ', 'R 49 (CJ 31 DE MARCO I)', 'JAPIIM                        ');
INSERT INTO cd_cep_br VALUES ('69.095-370', '156      ', 'R 49 (NUCLEO 5)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.099-030', '156      ', 'R 5 (A MENDES)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.099-260', '156      ', 'R 50 (A MENDES)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.077-510', '156      ', 'R 50 (CJ 31 DE MARCO I)', 'JAPIIM                        ');
INSERT INTO cd_cep_br VALUES ('69.095-380', '156      ', 'R 50 (NUCLEO 5)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.099-530', '156      ', 'R 51 (A MENDES)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.097-788', '156      ', 'R 51 (CJ S PESSOA)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.077-520', '156      ', 'R 51 (CJ 31 DE MARCO I)', 'JAPIIM                        ');
INSERT INTO cd_cep_br VALUES ('69.095-390', '156      ', 'R 51 (NUCLEO 5)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.099-270', '156      ', 'R 52 (A MENDES)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.151-740', '161      ', 'R CARAMBOLA (CJ MACURANI)', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('69.151-140', '161      ', 'R CARAMURI (CJ MACURANI)', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('69.152-100', '161      ', 'BC CARVALHO LEAL', 'S BENEDITO                    ');
INSERT INTO cd_cep_br VALUES ('69.151-130', '161      ', 'R CARVALHO LEAL- ATE 2992/2993', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('69.152-030', '161      ', 'R CARVALHO LEAL- DE 2994/2995 AO FIM', 'S BENEDITO                    ');
INSERT INTO cd_cep_br VALUES ('69.151-001', '161      ', 'PC CATEDRAL, DA', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('69.153-470', '161      ', 'R CHACARAS, DAS', 'S VICENTE                     ');
INSERT INTO cd_cep_br VALUES ('69.151-040', '161      ', 'AV CLARINDO CHAVES', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('69.151-120', '161      ', 'R CORDOVIL', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('69.151-050', '161      ', 'R CORONEL ARAUJO', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('69.152-710', '161      ', 'R CORONEL BARRETO BATISTA- ATE 3327/3328', 'S F ASSIS                     ');
INSERT INTO cd_cep_br VALUES ('69.152-260', '161      ', 'R CORONEL BARRETO BATISTA- DE 3329/3330 AO FIM', 'J ESTEVES                     ');
INSERT INTO cd_cep_br VALUES ('69.151-300', '161      ', 'R CORONEL JOSE AUGUSTO', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('69.151-520', '161      ', 'BC CORONEL JOSE HENRIQUE', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('69.151-301', '161      ', 'PC CRISTO REDENTOR', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('69.151-430', '161      ', 'R CUPUACU (CJ MACURANI)', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('69.152-320', '161      ', 'Q D (CJ J NOVO)', 'D VIEIRA                      ');
INSERT INTO cd_cep_br VALUES ('69.099-720', '156      ', 'R 86 (A MENDES)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.094-690', '156      ', 'R 86 (NUCLEO 14)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.098-750', '156      ', 'R 87 (A MENDES)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.097-121', '156      ', 'R 87 (CJ F MENDES II)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.094-700', '156      ', 'R 87 (NUCLEO 11)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.099-730', '156      ', 'R 88 (A MENDES)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.096-190', '156      ', 'R 88 (NUCLEO 11)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.098-760', '156      ', 'R 89 (A MENDES)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.097-761', '156      ', 'R 89 (CJ F MENDES II)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.096-200', '156      ', 'R 89 (NUCLEO 11)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.099-050', '156      ', 'R 9 (A MENDES)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.099-360', '156      ', 'R 90 (A MENDES)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.096-210', '156      ', 'R 90 (NUCLEO 11)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.096-220', '156      ', 'R 91 (NUCLEO 11)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.096-230', '156      ', 'R 92 (NUCLEO 11)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.096-240', '156      ', 'R 93 (NUCLEO 11)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.096-250', '156      ', 'R 94 (NUCLEO 11)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.096-260', '156      ', 'R 95 (NUCLEO 11)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.096-270', '156      ', 'R 96 (NUCLEO 11)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.096-280', '156      ', 'R 97 (NUCLEO 12)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.096-290', '156      ', 'R 98 (NUCLEO 12)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.096-300', '156      ', 'R 99 (NUCLEO 12)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.152-290', '161      ', 'Q A (CJ J NOVO)', 'D VIEIRA                      ');
INSERT INTO cd_cep_br VALUES ('69.152-730', '161      ', 'R ACAI', 'S F ASSIS                     ');
INSERT INTO cd_cep_br VALUES ('69.153-420', '161      ', 'R ACIOLY TEIXEIRA', 'S VICENTE                     ');
INSERT INTO cd_cep_br VALUES ('69.153-430', '161      ', 'R AGOSTINHO CUNHA', 'S VICENTE                     ');
INSERT INTO cd_cep_br VALUES ('69.151-750', '161      ', 'BC ALAN KARDEK', 'S CLARA                       ');
INSERT INTO cd_cep_br VALUES ('69.153-000', '161      ', 'R ALBERTO MENDES', 'PALMARES                      ');
INSERT INTO cd_cep_br VALUES ('69.153-340', '161      ', 'R ALBERTO SAUNIER ABECASSIS', 'S R CASSIA                    ');
INSERT INTO cd_cep_br VALUES ('69.152-550', '161      ', 'R ALCIDES SEIXAS ( CJ SHAM)', 'S F ASSIS                     ');
INSERT INTO cd_cep_br VALUES ('69.153-370', '161      ', 'R ALEXANDRE RIBEIRO', 'E MOREIRA                     ');
INSERT INTO cd_cep_br VALUES ('69.153-330', '161      ', 'R ALFREDO MONTEIRO LIMA', 'S R CASSIA                    ');
INSERT INTO cd_cep_br VALUES ('69.152-250', '161      ', 'R AMARO SILVA', 'J ESTEVES                     ');
INSERT INTO cd_cep_br VALUES ('69.151-000', '161      ', 'AV AMAZONAS', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('69.151-261', '161      ', 'PC AMIZADE, DA', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('69.152-420', '161      ', 'R ANINGA', 'D VIEIRA                      ');
INSERT INTO cd_cep_br VALUES ('69.153-240', '161      ', 'R ANTONIO CEZAR CARVALHO', 'S R CASSIA                    ');
INSERT INTO cd_cep_br VALUES ('69.153-390', '161      ', 'R ANTONIO MAIA', 'E MOREIRA                     ');
INSERT INTO cd_cep_br VALUES ('69.098-700', '156      ', 'R 71 (A MENDES)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.097-783', '156      ', 'R 71 (CJ O FROTA II)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.094-530', '156      ', 'R 71 (NUCLEO 4)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.099-620', '156      ', 'R 72 (A MENDES)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.094-540', '156      ', 'R 72 (NUCLEO 4)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.099-630', '156      ', 'R 73 (A MENDES)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.094-550', '156      ', 'R 73 (NUCLEO 4)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.099-640', '156      ', 'R 74 (A MENDES)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.094-560', '156      ', 'R 74 (NUCLEO 4)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.098-710', '156      ', 'R 75 (A MENDES)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('57.081-250', '54       ', 'R ARACATI', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.081-260', '54       ', 'R ARACATU', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('69.086-160', '156      ', 'R 15', 'S J OPERARIO                  ');
INSERT INTO cd_cep_br VALUES ('69.042-150', '156      ', 'R 15', 'ALVORADA                      ');
INSERT INTO cd_cep_br VALUES ('69.038-286', '156      ', 'R 15', 'L VALE                        ');
INSERT INTO cd_cep_br VALUES ('69.099-070', '156      ', 'R 15 (A MENDES)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.038-420', '156      ', 'R 15 (CJ A MONTENEGRO)', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('69.028-339', '156      ', 'R 15 (CJ B FLOR II)', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('69.055-330', '156      ', 'R 15 (CJ C BRANCO)', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.083-580', '156      ', 'R 15 (CJ C DO ALEIXO)', 'S J OPERARIO                  ');
INSERT INTO cd_cep_br VALUES ('69.097-080', '156      ', 'R 15 (CJ CANARANAS)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.086-530', '156      ', 'R 15 (CJ CASTANHEIRA)', 'S J OPERARIO                  ');
INSERT INTO cd_cep_br VALUES ('69.068-430', '156      ', 'R 15 (CJ COSTA E SILVA)', 'RAIZ                          ');
INSERT INTO cd_cep_br VALUES ('69.097-775', '156      ', 'R 15 (CJ F MENDES I)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.049-310', '156      ', 'R 15 (CJ HILEIA I )', 'REDENCAO                      ');
INSERT INTO cd_cep_br VALUES ('69.049-490', '156      ', 'R 15 (CJ HILEIA II)', 'REDENCAO                      ');
INSERT INTO cd_cep_br VALUES ('69.067-131', '156      ', 'R 15 (CJ JD PETROPOLIS)', 'PETROPOLIS                    ');
INSERT INTO cd_cep_br VALUES ('69.044-620', '156      ', 'R 15 (CJ JD VERSALLES)', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('69.093-540', '156      ', 'R 15 (CJ MANOA)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.090-490', '156      ', 'R 15 (CJ MUNDO NOVO)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.028-414', '156      ', 'R 15 (CJ SUBTEN SRG P MILITAR)', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('69.077-160', '156      ', 'R 15 (CJ 31 DE MARCO I)', 'JAPIIM                        ');
INSERT INTO cd_cep_br VALUES ('69.093-271', '156      ', 'R 15 (M SINAI)', 'COL S ANTONIO                 ');
INSERT INTO cd_cep_br VALUES ('69.094-150', '156      ', 'R 15 (NUCLEO 3)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.086-161', '156      ', 'R 15 A', 'S J OPERARIO                  ');
INSERT INTO cd_cep_br VALUES ('69.055-302', '156      ', 'R 15-A (CJ CASTELO BRANCO)', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.097-430', '156      ', 'R 150 (NUCLEO 9)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.097-440', '156      ', 'R 151 (NUCLEO 9)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.097-450', '156      ', 'R 152 (NUCLEO 9)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.097-460', '156      ', 'R 153 (NUCLEO 9)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.097-470', '156      ', 'R 154 (NUCLEO 9)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.097-480', '156      ', 'R 155 (NUCLEO 9)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.097-490', '156      ', 'R 156 (NUCLEO 9)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.096-640', '156      ', 'R 157 (NUCLEO 7)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.096-140', '156      ', 'R 158 (NUCLEO 7)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.096-150', '156      ', 'R 159 (NUCLEO 7)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.086-170', '156      ', 'R 16', 'S J OPERARIO                  ');
INSERT INTO cd_cep_br VALUES ('69.042-160', '156      ', 'R 16', 'ALVORADA                      ');
INSERT INTO cd_cep_br VALUES ('69.038-287', '156      ', 'R 16', 'L VALE                        ');
INSERT INTO cd_cep_br VALUES ('69.049-320', '156      ', 'R 16 ( CJ HILEIA I)', 'REDENCAO                      ');
INSERT INTO cd_cep_br VALUES ('69.096-630', '156      ', 'R 132 (NUCLEO 10)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.094-710', '156      ', 'R 133 (NUCLEO 13)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.094-720', '156      ', 'R 134 (NUCLEO 13)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.094-730', '156      ', 'R 135 (NUCLEO 13)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.094-740', '156      ', 'R 136 (NUCLEO 13)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.094-750', '156      ', 'R 137 (NUCLEO 13)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.094-760', '156      ', 'R 138 (NUCLEO 13)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.094-770', '156      ', 'R 139 (NUCLEO 13)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.086-150', '156      ', 'R 14', 'S J OPERARIO                  ');
INSERT INTO cd_cep_br VALUES ('69.042-140', '156      ', 'R 14', 'ALVORADA                      ');
INSERT INTO cd_cep_br VALUES ('69.038-285', '156      ', 'R 14', 'L VALE                        ');
INSERT INTO cd_cep_br VALUES ('69.098-670', '156      ', 'R 14 (A MENDES)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.097-751', '156      ', 'R 14 (CJ A MEDEIROS)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.038-410', '156      ', 'R 14 (CJ A MONTENEGRO)', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('69.028-338', '156      ', 'R 14 (CJ B FLOR II)', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('69.055-320', '156      ', 'R 14 (CJ C BRANCO)', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.083-570', '156      ', 'R 14 (CJ C DO ALEIXO)', 'S J OPERARIO                  ');
INSERT INTO cd_cep_br VALUES ('69.086-521', '156      ', 'R 14 (CJ CASTANHEIRA)', 'S J OPERARIO                  ');
INSERT INTO cd_cep_br VALUES ('69.068-420', '156      ', 'R 14 (CJ COSTA E SILVA)', 'RAIZ                          ');
INSERT INTO cd_cep_br VALUES ('69.049-300', '156      ', 'R 14 (CJ HILEIA I )', 'REDENCAO                      ');
INSERT INTO cd_cep_br VALUES ('69.049-480', '156      ', 'R 14 (CJ HILEIA II)', 'REDENCAO                      ');
INSERT INTO cd_cep_br VALUES ('69.044-610', '156      ', 'R 14 (CJ JD VERSALLES)', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('69.093-530', '156      ', 'R 14 (CJ MANOA)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.090-480', '156      ', 'R 14 (CJ MUNDO NOVO)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.036-490', '156      ', 'R 14 (CJ R XINGU)', 'COMPENSA                      ');
INSERT INTO cd_cep_br VALUES ('69.028-413', '156      ', 'R 14 (CJ SUBTEN SRG P MILITAR)', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('12.929-471', '4897     ', 'PC PENHA, DA', 'PENHA                         ');
INSERT INTO cd_cep_br VALUES ('69.077-150', '156      ', 'R 14 (CJ 31 DE MARCO I)', 'JAPIIM                        ');
INSERT INTO cd_cep_br VALUES ('69.094-140', '156      ', 'R 14 (NUCLEO 3)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.094-780', '156      ', 'R 140 (NUCLEO 13)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.094-790', '156      ', 'R 141 (NUCLEO 13)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.094-800', '156      ', 'R 142 (NUCLEO 13)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.097-720', '156      ', 'R 143 (NUCLEO 9)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.097-730', '156      ', 'R 144 (NUCLEO 9)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.097-380', '156      ', 'R 145 (NUCLEO 9)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.097-390', '156      ', 'R 146 (NUCLEO 9)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.097-400', '156      ', 'R 147 (NUCLEO 9)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.097-410', '156      ', 'R 148 (NUCLEO 9)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.097-420', '156      ', 'R 149 (NUCLEO 9)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.096-510', '156      ', 'R 120 (NUCLEO 11)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.096-520', '156      ', 'R 121 (NUCLEO 11)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.096-530', '156      ', 'R 122 (NUCLEO 11)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.096-540', '156      ', 'R 123 (NUCLEO 11)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.096-550', '156      ', 'R 124 (NUCLEO 11)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.096-560', '156      ', 'R 125 (NUCLEO 10)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.096-570', '156      ', 'R 126 (NUCLEO 10)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.096-580', '156      ', 'R 127 (NUCLEO 10)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.096-590', '156      ', 'R 128 (NUCLEO 10)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.096-600', '156      ', 'R 129 (NUCLEO 10)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.086-140', '156      ', 'R 13', 'S J OPERARIO                  ');
INSERT INTO cd_cep_br VALUES ('69.038-284', '156      ', 'R 13', 'L VALE                        ');
INSERT INTO cd_cep_br VALUES ('69.042-120', '156      ', 'R 13- DE 133/134 AO FIM', 'ALVORADA                      ');
INSERT INTO cd_cep_br VALUES ('69.038-400', '156      ', 'R 13 (CJ A MONTENEGRO)', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('69.028-337', '156      ', 'R 13 (CJ B FLOR II)', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('69.055-310', '156      ', 'R 13 (CJ C BRANCO)', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.083-560', '156      ', 'R 13 (CJ C DO ALEIXO)', 'S J OPERARIO                  ');
INSERT INTO cd_cep_br VALUES ('69.097-070', '156      ', 'R 13 (CJ CANARANAS)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.086-520', '156      ', 'R 13 (CJ CASTANHEIRA)', 'S J OPERARIO                  ');
INSERT INTO cd_cep_br VALUES ('69.068-410', '156      ', 'R 13 (CJ COSTA E SILVA)', 'RAIZ                          ');
INSERT INTO cd_cep_br VALUES ('69.097-774', '156      ', 'R 13 (CJ F MENDES I)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.049-290', '156      ', 'R 13 (CJ HILEIA I )', 'REDENCAO                      ');
INSERT INTO cd_cep_br VALUES ('69.049-470', '156      ', 'R 13 (CJ HILEIA II)', 'REDENCAO                      ');
INSERT INTO cd_cep_br VALUES ('69.067-192', '156      ', 'R 13 (CJ JD PETROPOLIS)', 'PETROPOLIS                    ');
INSERT INTO cd_cep_br VALUES ('69.044-600', '156      ', 'R 13 (CJ JD VERSALLES)', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('69.093-520', '156      ', 'R 13 (CJ MANOA)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.090-470', '156      ', 'R 13 (CJ MUNDO NOVO)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('57.302-390', '23       ', 'R DOM OSCAR ARNULFO HOMERO', 'N ESPERANCA                   ');
INSERT INTO cd_cep_br VALUES ('57.301-150', '23       ', 'R DOM PEDRO II', 'O PRETO                       ');
INSERT INTO cd_cep_br VALUES ('57.042-300', '54       ', 'R EMPRESARIO JOSE PEIXOTO ACIOLY', 'FEITOSA                       ');
INSERT INTO cd_cep_br VALUES ('57.017-080', '54       ', 'AV FRANCISCO DE MENEZES- DE 678/679 AO FIM', 'B PARTO                       ');
INSERT INTO cd_cep_br VALUES ('57.057-120', '54       ', 'AV FRANCISCO FREIRE RIBEIRO', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.057-125', '54       ', 'TV FRANCISCO FREIRE RIBEIRO', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.072-190', '54       ', 'R FRANCISCO HOLANDA CAVALCANTE FILHO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.041-790', '54       ', 'R FRANCISCO JOAQUIM DOS SANTOS', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.041-440', '54       ', 'R FRANCISCO JOSE DOS SANTOS', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.035-090', '54       ', 'R FRANCISCO LARANJEIRAS', 'P VERDE                       ');
INSERT INTO cd_cep_br VALUES ('57.075-300', '54       ', 'R FRANCISCO LARANJEIRAS FILHO(RUA 14 CJ OSMAN LO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.052-065', '54       ', 'TV FRANCISCO LEAO', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.046-100', '54       ', 'R FRANCISCO TIBURCIO DA SILVA RIZZO', 'B DURO                        ');
INSERT INTO cd_cep_br VALUES ('57.011-440', '54       ', 'R FRANCISCO VIEIRA', 'T BARRA                       ');
INSERT INTO cd_cep_br VALUES ('57.011-450', '54       ', 'TV FRANCISCO VIEIRA', 'T BARRA                       ');
INSERT INTO cd_cep_br VALUES ('57.041-090', '54       ', 'R FRANCISCO XAVIER', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.011-060', '54       ', 'R FRANCO JATOBA', 'PRADO                         ');
INSERT INTO cd_cep_br VALUES ('57.011-070', '54       ', 'TV FRANCO JATOBA', 'PRADO                         ');
INSERT INTO cd_cep_br VALUES ('57.025-730', '54       ', 'CJ FRATERNIDADE', 'POCO                          ');
INSERT INTO cd_cep_br VALUES ('57.073-220', '54       ', 'R FREDERICO OTTO KUMMER', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.060-440', '54       ', 'R FREDERICO VALENTE BITENCOURT', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.041-100', '54       ', 'R FREI DAMIAO', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.070-210', '54       ', 'R FREI DAMIAO', 'R NOVO                        ');
INSERT INTO cd_cep_br VALUES ('57.085-030', '54       ', 'CJ FREI DAMIAO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.036-570', '54       ', 'JD FREI DAMIAO DE BOZZANO', 'MANGABEIRAS                   ');
INSERT INTO cd_cep_br VALUES ('57.073-610', '54       ', 'AV FREI DAMIAO DE BOZZANO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.057-650', '54       ', 'CJ FREIRE RIBEIRO', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.046-500', '54       ', 'R FRUTUOSO ALVES DOS SANTOS', 'SERRARIA                      ');
INSERT INTO cd_cep_br VALUES ('57.020-390', '54       ', 'R GABINO BEZOURO', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.040-300', '54       ', 'R FEICAO', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.084-570', '54       ', 'R FEIRA, DA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.062-360', '54       ', 'AL FELISBERTO MUNIZ FALCAO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.015-490', '54       ', 'R FELIX BANDEIRA', 'V LAGO                        ');
INSERT INTO cd_cep_br VALUES ('57.030-800', '54       ', 'R FELIX LIMA JUNIOR', 'POCO                          ');
INSERT INTO cd_cep_br VALUES ('57.020-020', '54       ', 'R FERNANDES DE BARROS', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.057-700', '54       ', 'AV FERNANDES LIMA', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.055-000', '54       ', 'AV FERNANDES LIMA- ATE 1867 - LADO IMPAR', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.050-000', '54       ', 'AV FERNANDES LIMA- ATE 2468 - LADO PAR', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.057-000', '54       ', 'AV FERNANDES LIMA- DE 1869 AO FIM - LADO IMPAR', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.052-000', '54       ', 'AV FERNANDES LIMA- DE 2470 AO FIM - LADO PAR', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.061-630', '54       ', 'LOT FERNANDEZ', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.081-400', '54       ', 'R FERNANDO BARROS', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.052-370', '54       ', 'R FERNANDO JUNIOR', 'G LOURDES                     ');
INSERT INTO cd_cep_br VALUES ('57.073-310', '54       ', 'R FERNANDO LINS DE MEIRA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.057-530', '54       ', 'AL FERNANDO MAIA GOMES', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.046-090', '54       ', 'R FERNANDO MENDES PINTO', 'B DURO                        ');
INSERT INTO cd_cep_br VALUES ('57.052-380', '54       ', 'PC FERNANDO PEREZ', 'G LOURDES                     ');
INSERT INTO cd_cep_br VALUES ('57.082-550', '54       ', 'CJ FERNANDO RIBEIRO TOLEDO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.037-040', '54       ', 'R FERROVIARIO MANOEL GONCALVES FILHO', 'MANGABEIRAS                   ');
INSERT INTO cd_cep_br VALUES ('57.071-860', '54       ', 'R FILADELFIA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.015-500', '54       ', 'R FILOMENA ARGOLO', 'P GROSSA                      ');
INSERT INTO cd_cep_br VALUES ('57.061-060', '54       ', 'R FIRMO CORREIA DE ARAUJO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.039-510', '54       ', 'R FISCAL VERA DE MELLO QUEIROZ (CJ JACAREC', 'JACARECICA                    ');
INSERT INTO cd_cep_br VALUES ('57.046-270', '54       ', 'CJ FLAMBOYANT', 'SERRARIA                      ');
INSERT INTO cd_cep_br VALUES ('57.043-080', '54       ', 'R FLAVIANO LISBOA', 'FEITOSA                       ');
INSERT INTO cd_cep_br VALUES ('57.017-190', '54       ', 'R FLOR DO MANGUE', 'B PARTO                       ');
INSERT INTO cd_cep_br VALUES ('57.043-090', '54       ', 'R FLORES, DAS', 'FEITOSA                       ');
INSERT INTO cd_cep_br VALUES ('57.043-095', '54       ', 'TV FLORES, DAS', 'FEITOSA                       ');
INSERT INTO cd_cep_br VALUES ('57.014-600', '54       ', 'R FLORES, DAS', 'P GROSSA                      ');
INSERT INTO cd_cep_br VALUES ('57.060-080', '54       ', 'R FLORESTA, DA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.018-645', '54       ', 'TV FLORESTAL', 'C JAQUEIRA                    ');
INSERT INTO cd_cep_br VALUES ('57.039-750', '54       ', 'R FLORIANO PEIXOTO', 'F PEIXOTO                     ');
INSERT INTO cd_cep_br VALUES ('57.071-660', '54       ', 'R FORMOSA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.040-315', '54       ', 'TV FORMOSA', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.014-000', '54       ', 'R FORMOSA- ATE 1322/1329', 'LEVADA                        ');
INSERT INTO cd_cep_br VALUES ('57.014-001', '54       ', 'R FORMOSA- DE 1324/1331 AO FIM', 'P GROSSA                      ');
INSERT INTO cd_cep_br VALUES ('57.080-210', '54       ', 'R FOTOGRAFO BECKER', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.072-780', '54       ', 'R ESTUDANTE LISIANE GUIMARAES (CJ EUSTAQUIO GOME', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.084-130', '54       ', 'R ESTUDANTE LUIZ EDUARDO DE LIMA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.062-310', '54       ', 'AL ESTUDANTE MARCUS ANTONIO CAVALCANTE SILVA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.047-020', '54       ', 'R ESTUDANTE NABAL GIL SAMPAIO E SILVA NETO', 'SERRARIA                      ');
INSERT INTO cd_cep_br VALUES ('57.084-240', '54       ', 'R ESTUDANTE SANELVA ANTONIO PEDROSA PEREIRA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.035-080', '54       ', 'R ESTUDANTE ZENISSON PEDROSA DE OLIVEIRA', 'P VERDE                       ');
INSERT INTO cd_cep_br VALUES ('57.082-730', '54       ', 'R ETIENE CRISTINA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.052-360', '54       ', 'R EUCALIPTO', 'G LOURDES                     ');
INSERT INTO cd_cep_br VALUES ('57.031-450', '54       ', 'PC EUCLIDES MEDEIROS GONCALVES', 'P VERDE                       ');
INSERT INTO cd_cep_br VALUES ('57.045-070', '54       ', 'R GOVERNADOR LAMENHA FILHO', 'B DURO                        ');
INSERT INTO cd_cep_br VALUES ('57.018-550', '54       ', 'R GOVERNADOR LAMENHA FILHO', 'C JAQUEIRA                    ');
INSERT INTO cd_cep_br VALUES ('57.043-005', '54       ', 'TV GOVERNADOR LAMENHA FILHO', 'FEITOSA                       ');
INSERT INTO cd_cep_br VALUES ('57.043-000', '54       ', 'R GOVERNADOR LAMENHA FILHO- ATE 2054/2055', 'FEITOSA                       ');
INSERT INTO cd_cep_br VALUES ('57.042-000', '54       ', 'AV GOVERNADOR LAMENHA FILHO- DE 2056/2057 AO FIM', 'B VISTA                       ');
INSERT INTO cd_cep_br VALUES ('57.082-000', '54       ', 'AV GOVERNADOR LUIZ CAVALCANTE', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.020-660', '54       ', 'PC GOVERNADOR MUNIZ FALCAO', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.014-480', '54       ', 'AV GOVERNADOR THEOBALDO BARBOSA', 'V LAGO                        ');
INSERT INTO cd_cep_br VALUES ('12.906-053', '4897     ', 'R PROJETADA H', 'JD S CRISTOVAO                ');
INSERT INTO cd_cep_br VALUES ('57.048-230', '54       ', 'R GRAFICO JULIO CANUTO DOS SANTOS', 'SERRARIA                      ');
INSERT INTO cd_cep_br VALUES ('57.081-040', '54       ', 'R GRAJAU', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.036-200', '54       ', 'R GREGORIO FONTAN BRANCO', 'JATIUCA                       ');
INSERT INTO cd_cep_br VALUES ('57.085-180', '54       ', 'R GROTA DA ALEGRIA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.039-440', '54       ', 'R GROTA DO ARAUJO', 'R DOCE                        ');
INSERT INTO cd_cep_br VALUES ('57.084-670', '54       ', 'R GRUTA DA CAVEIRA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.046-720', '54       ', 'R GRUTA DO POCO AZUL', 'B DURO                        ');
INSERT INTO cd_cep_br VALUES ('57.017-090', '54       ', 'R GRUTA PADRE CICERO ROMAO BATISTA', 'MUTANGE                       ');
INSERT INTO cd_cep_br VALUES ('  . 57040-', '54       ', 'GRUTA PAU TESTEARCO', '   JACINTINHO                 ');
INSERT INTO cd_cep_br VALUES ('57.014-080', '54       ', 'R GUAICURUS', 'P GROSSA                      ');
INSERT INTO cd_cep_br VALUES ('57.015-510', '54       ', 'LOT GUAICURUS', 'P GROSSA                      ');
INSERT INTO cd_cep_br VALUES ('57.043-490', '54       ', 'R GUAPORE', 'FEITOSA                       ');
INSERT INTO cd_cep_br VALUES ('57.052-390', '54       ', 'R GUARABU', 'G LOURDES                     ');
INSERT INTO cd_cep_br VALUES ('57.011-080', '54       ', 'R GUARDA-CIVIL MANOEL LEANDRO', 'T BARRA                       ');
INSERT INTO cd_cep_br VALUES ('57.045-195', '54       ', 'TV SANTO ANTONIO', 'B DURO                        ');
INSERT INTO cd_cep_br VALUES ('57.031-060', '54       ', 'R CORONEL ADAUTO GOMES BARBOSA', 'POCO                          ');
INSERT INTO cd_cep_br VALUES ('57.010-240', '54       ', 'R CORONEL ADAUTO GOMES BARBOSA', 'T BARRA                       ');
INSERT INTO cd_cep_br VALUES ('57.036-480', '54       ', 'R CORONEL ALCIDES DE BARROS FERREIRA', 'JATIUCA                       ');
INSERT INTO cd_cep_br VALUES ('57.045-680', '54       ', 'LD CORONEL ALVES MATA', 'SERRARIA                      ');
INSERT INTO cd_cep_br VALUES ('57.041-060', '54       ', 'PC CORONEL ANTONIO MONTEIRO DE SOUZA', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.055-500', '54       ', 'AL CORONEL ANTONIO PANTALEAO DA SILVA', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.057-500', '54       ', 'R CORONEL AURELIO MOUSINHO', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.015-690', '54       ', 'R CORONEL CAHET', 'LEVADA                        ');
INSERT INTO cd_cep_br VALUES ('57.061-180', '54       ', 'R CORONEL FLORIANO PIMENTEL', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.082-110', '54       ', 'R CLAUDIO CARDOSO DE ALMEIDA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.039-380', '54       ', 'R CLAUDIO DOS SANTOS', 'R DOCE                        ');
INSERT INTO cd_cep_br VALUES ('57.055-180', '54       ', 'R CLAUDIO LIVIO', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.014-050', '54       ', 'R CLAUDIO MANOEL', 'P GROSSA                      ');
INSERT INTO cd_cep_br VALUES ('57.035-020', '54       ', 'R CLAUDIO RAMOS', 'P VERDE                       ');
INSERT INTO cd_cep_br VALUES ('57.052-680', '54       ', 'R CLAUDIO REGIS(RUA B LOT EVANDRO P MIRANDA)', 'G LOURDES                     ');
INSERT INTO cd_cep_br VALUES ('57.055-190', '54       ', 'R CLEMENTINO DO MONTE', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.041-000', '54       ', 'R CLETO CAMPELO', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.041-005', '54       ', 'TV CLETO CAMPELO', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.017-170', '54       ', 'R CLETO MARQUES LUZ', 'B PARTO                       ');
INSERT INTO cd_cep_br VALUES ('57.082-530', '54       ', 'CJ CLETO MARQUES LUZ', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.036-810', '54       ', 'CJ CLIMERIO SARMENTO', 'JATIUCA                       ');
INSERT INTO cd_cep_br VALUES ('57.020-530', '54       ', 'R CLISTENES DE MIRANDA PINTO', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.071-050', '54       ', 'R CLODOALDO ALVES DE CASTRO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.041-360', '54       ', 'R CLUBE DE REGATAS BRASIL', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.040-080', '54       ', 'R COARACY FONSECA', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.083-540', '54       ', 'EST CODEAL, DA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.041-370', '54       ', 'R COLEGIO BATISTA ALAGOANO', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.041-380', '54       ', 'R COLEGIO GUIDO DE FONTGALAND', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.017-720', '54       ', 'R COLEGIO NOSSA SENHORA DO BOM CONSELHO', 'BEBEDOURO                     ');
INSERT INTO cd_cep_br VALUES ('57.060-650', '54       ', 'CJ COLINA DOS EUCALIPTOS', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.052-040', '54       ', 'R COMENDADOR ALVARO PEIXOTO', 'G LOURDES                     ');
INSERT INTO cd_cep_br VALUES ('57.052-640', '54       ', 'R COMENDADOR ANTONIO FERREIRA', 'G LOURDES                     ');
INSERT INTO cd_cep_br VALUES ('57.052-050', '54       ', 'R COMENDADOR ANTONIO FRANCISCO FERREIRA', 'G LOURDES                     ');
INSERT INTO cd_cep_br VALUES ('57.042-170', '54       ', 'CJ COMENDADOR ANTONIO MAGALHAES', 'FEITOSA                       ');
INSERT INTO cd_cep_br VALUES ('57.025-640', '54       ', 'R COMENDADOR CALACA', 'POCO                          ');
INSERT INTO cd_cep_br VALUES ('57.050-030', '54       ', 'R COMENDADOR FIRMO LOPES', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.057-050', '54       ', 'AV COMENDADOR FRANCISCO AMORIM LEAO', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.052-060', '54       ', 'R COMENDADOR FRANCISCO LEAO', 'G LOURDES                     ');
INSERT INTO cd_cep_br VALUES ('57.038-365', '54       ', 'TV COMENDADOR GUSTAVO PAIVA', 'MANGABEIRAS                   ');
INSERT INTO cd_cep_br VALUES ('57.031-530', '54       ', 'AV COMENDADOR GUSTAVO PAIVA- ATE 2320/2321', 'MANGABEIRAS                   ');
INSERT INTO cd_cep_br VALUES ('57.038-000', '54       ', 'AV COMENDADOR GUSTAVO PAIVA- DE 2322/2323 AO FIM', 'C ALMAS                       ');
INSERT INTO cd_cep_br VALUES ('57.070-100', '54       ', 'R COMENDADOR JACINTO LEITE', 'F VELHO                       ');
INSERT INTO cd_cep_br VALUES ('57.025-000', '54       ', 'AV COMENDADOR LEAO', 'POCO                          ');
INSERT INTO cd_cep_br VALUES ('57.017-180', '54       ', 'R COMENDADOR LUIZ CALHEIROS', 'B PARTO                       ');
INSERT INTO cd_cep_br VALUES ('57.052-170', '54       ', 'R COMENDADOR LUIZ JARDIM', 'G LOURDES                     ');
INSERT INTO cd_cep_br VALUES ('57.051-150', '54       ', 'R COMENDADOR PALMEIRA', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.020-240', '54       ', 'R COMENDADOR TEIXEIRA BASTOS- ATE 149/150', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('57.051-300', '54       ', 'LD CATEDRAL, DA', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.084-580', '54       ', 'R CAXEU', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.045-270', '54       ', 'R CEARA', 'B DURO                        ');
INSERT INTO cd_cep_br VALUES ('57.011-320', '54       ', 'R CEARA, DO', 'PRADO                         ');
INSERT INTO cd_cep_br VALUES ('57.052-290', '54       ', 'R CEDRO', 'G LOURDES                     ');
INSERT INTO cd_cep_br VALUES ('57.015-640', '54       ', 'AV CELESTE BEZERRA', 'LEVADA                        ');
INSERT INTO cd_cep_br VALUES ('57.040-320', '54       ', 'R CELESTINO AGRIPINO DA HORA', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.071-755', '54       ', 'R CELESTINO CHAGAS', 'A S DUMONT                    ');
INSERT INTO cd_cep_br VALUES ('57.062-200', '54       ', 'AL CELIA DOS ANJOS', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.073-200', '54       ', 'R CELINA SACRAMETO SILVA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.022-210', '54       ', 'R CELSO PIATTI', 'JARAGUA                       ');
INSERT INTO cd_cep_br VALUES ('57.051-140', '54       ', 'PC CENTENARIO, DO', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.041-350', '54       ', 'R CENTRO SPORTIVO ALAGOANO', 'JACINTINHO                    ');
INSERT INTO cd_cep_br VALUES ('57.052-300', '54       ', 'R CEREJEIRA', 'G LOURDES                     ');
INSERT INTO cd_cep_br VALUES ('57.039-430', '54       ', 'R CHA DO CRUZEIRO', 'R DOCE                        ');
INSERT INTO cd_cep_br VALUES ('57.043-520', '54       ', 'AV CHICO MENDES', 'FEITOSA                       ');
INSERT INTO cd_cep_br VALUES ('57.075-050', '54       ', 'CJ CHICO MENDES', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.011-240', '54       ', 'R CHILE', 'T BARRA                       ');
INSERT INTO cd_cep_br VALUES ('57.055-170', '54       ', 'R CICERO CRAVO', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.082-460', '54       ', 'R CICERO FREITAS DA SILVA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.080-350', '54       ', 'R DEPUTADO ARMANDO LAGES', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.047-090', '54       ', 'R DEPUTADO ARMANDO MOREIRA SOARES', 'B DURO                        ');
INSERT INTO cd_cep_br VALUES ('57.084-270', '54       ', 'R DEPUTADO AUGUSTO DE FREITAS MACHADO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.018-510', '54       ', 'R DEPUTADO AUSTECLINIO LOPES', 'C JAQUEIRA                    ');
INSERT INTO cd_cep_br VALUES ('57.080-280', '54       ', 'R DEPUTADO CASTRO FILHO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.061-190', '54       ', 'R DEPUTADO DALMARIO SOUZA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.046-670', '54       ', 'AV DEPUTADO EDSON LINS', 'SERRARIA                      ');
INSERT INTO cd_cep_br VALUES ('57.035-240', '54       ', 'R DEPUTADO ELIZEU TEIXEIRA', 'P VERDE                       ');
INSERT INTO cd_cep_br VALUES ('57.042-240', '54       ', 'R DEPUTADO ERALDO MALTA BRANDAO', 'B VISTA                       ');
INSERT INTO cd_cep_br VALUES ('57.045-350', '54       ', 'R DEPUTADO GONCALO TAVARES', 'B DURO                        ');
INSERT INTO cd_cep_br VALUES ('57.081-340', '54       ', 'R DEPUTADO HERMES DE ALMEIDA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.018-690', '54       ', 'R DEPUTADO JOAO CABRAL TOLEDO', 'C JAQUEIRA                    ');
INSERT INTO cd_cep_br VALUES ('57.062-590', '54       ', 'AL CORONEL FRANCISCO FERREIRA DE MELO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.050-190', '54       ', 'R CORONEL FRANCISCO SILVA', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.042-230', '54       ', 'R CORONEL JOAO BEZERRA', 'B VISTA                       ');
INSERT INTO cd_cep_br VALUES ('57.070-140', '54       ', 'R CORONEL JOAO MACHADO', 'F VELHO                       ');
INSERT INTO cd_cep_br VALUES ('57.050-110', '54       ', 'R CORONEL JOSE AUGUSTO CABRAL', 'PITANGUINHA                   ');
INSERT INTO cd_cep_br VALUES ('57.080-220', '54       ', 'R CORONEL JOSE CAVALCANTE MARANHAO', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.031-070', '54       ', 'R CORONEL KLEBER RODRIGUES', 'POCO                          ');
INSERT INTO cd_cep_br VALUES ('57.050-200', '54       ', 'R CORONEL LIMA ROCHA- ATE 626/627', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.055-400', '54       ', 'R CORONEL LIMA ROCHA- DE 628/629 AO FIM', 'FAROL                         ');
INSERT INTO cd_cep_br VALUES ('57.017-570', '54       ', 'PC CORONEL LUCENA MARANHAO', 'BEBEDOURO                     ');
INSERT INTO cd_cep_br VALUES ('57.015-040', '54       ', 'R CORONEL LUCENA MARANHAO', 'V LAGO                        ');
INSERT INTO cd_cep_br VALUES ('57.039-360', '54       ', 'R CORONEL MARIO SERAFIM', 'R DOCE                        ');
INSERT INTO cd_cep_br VALUES ('57.015-700', '54       ', 'R CORONEL MEIRA', 'LEVADA                        ');
INSERT INTO cd_cep_br VALUES ('57.010-100', '54       ', 'R CORONEL MENDES DA FONSECA', 'PRADO                         ');
INSERT INTO cd_cep_br VALUES ('57.083-420', '54       ', 'R NAIR CAVALCANTE ROCHA', 'T MARTINS                     ');
INSERT INTO cd_cep_br VALUES ('57.046-510', '54       ', 'R NAIR DA CUNHA MOREIRA', 'SERRARIA                      ');
INSERT INTO cd_cep_br VALUES ('57.046-760', '54       ', 'R NAIR DA CUNHA SANTOS', 'B DURO                        ');
INSERT INTO cd_cep_br VALUES ('69.050-151', '156      ', 'R SAO LUIS', 'CHAPADA                       ');
INSERT INTO cd_cep_br VALUES ('69.036-070', '156      ', 'BC SAO LUIS', 'COMPENSA                      ');
INSERT INTO cd_cep_br VALUES ('69.080-321', '156      ', 'BC SAO LUIS', 'COROADO                       ');
INSERT INTO cd_cep_br VALUES ('69.082-280', '156      ', 'R SAO LUIS', 'COROADO                       ');
INSERT INTO cd_cep_br VALUES ('69.042-551', '156      ', 'BC SAO LUIS', 'D PEDRO                       ');
INSERT INTO cd_cep_br VALUES ('69.070-320', '156      ', 'BC SAO LUIS', 'EDUCANDOS                     ');
INSERT INTO cd_cep_br VALUES ('69.070-310', '156      ', 'R SAO LUIS', 'EDUCANDOS                     ');
INSERT INTO cd_cep_br VALUES ('69.078-200', '156      ', 'BC SAO LUIS', 'JAPIIM                        ');
INSERT INTO cd_cep_br VALUES ('69.074-765', '156      ', 'R SAO LUIS', 'MRO LIBERDADE                 ');
INSERT INTO cd_cep_br VALUES ('69.053-461', '156      ', 'BC SAO LUIS', 'N S GRACAS                    ');
INSERT INTO cd_cep_br VALUES ('69.053-470', '156      ', 'R SAO LUIS', 'N S GRACAS                    ');
INSERT INTO cd_cep_br VALUES ('69.068-630', '156      ', 'BC SAO LUIS', 'RAIZ                          ');
INSERT INTO cd_cep_br VALUES ('69.029-110', '156      ', 'R SAO LUIS', 'S ANTONIO                     ');
INSERT INTO cd_cep_br VALUES ('69.063-241', '156      ', 'BC SAO LUIS', 'S FRANCISCO                   ');
INSERT INTO cd_cep_br VALUES ('69.075-820', '156      ', 'BC SAO LUIS', 'MAUAZINHO                     ');
INSERT INTO cd_cep_br VALUES ('69.039-450', '156      ', 'R SAO LUIS', 'N ISRAEL                      ');
INSERT INTO cd_cep_br VALUES ('69.039-451', '156      ', 'TV SAO LUIS', 'N ISRAEL                      ');
INSERT INTO cd_cep_br VALUES ('69.053-460', '156      ', 'TV SAO LUIS', 'N S GRACAS                    ');
INSERT INTO cd_cep_br VALUES ('69.084-461', '156      ', 'BC SAO LUIS', 'Z PALMARES                    ');
INSERT INTO cd_cep_br VALUES ('69.075-272', '156      ', 'R SAO LUIS', 'MAUAZINHO                     ');
INSERT INTO cd_cep_br VALUES ('69.073-601', '156      ', 'BC SAO JOSE', 'S LAZARO                      ');
INSERT INTO cd_cep_br VALUES ('69.073-600', '156      ', 'R SAO JOSE', 'S LAZARO                      ');
INSERT INTO cd_cep_br VALUES ('69.027-211', '156      ', 'R SAO JOSE', 'S RAIMUNDO                    ');
INSERT INTO cd_cep_br VALUES ('69.075-440', '156      ', 'BC SAO JOSE', 'MAUAZINHO                     ');
INSERT INTO cd_cep_br VALUES ('69.075-451', '156      ', 'R SAO JOSE', 'MAUAZINHO                     ');
INSERT INTO cd_cep_br VALUES ('69.047-330', '156      ', 'BC SAO JOSE', 'REDENCAO                      ');
INSERT INTO cd_cep_br VALUES ('69.087-471', '156      ', 'R SAO JOSE', 'T NEVES                       ');
INSERT INTO cd_cep_br VALUES ('69.059-010', '156      ', 'R SAO JOSE', 'S ETELVINA                    ');
INSERT INTO cd_cep_br VALUES ('69.077-070', '156      ', 'BC SAO JOSE', 'JAPIIM                        ');
INSERT INTO cd_cep_br VALUES ('69.074-351', '156      ', 'BC SAO JOSE', 'S LUZIA                       ');
INSERT INTO cd_cep_br VALUES ('69.037-541', '156      ', 'R SAO JOSE', 'N ESPERANCA                   ');
INSERT INTO cd_cep_br VALUES ('69.035-271', '156      ', 'TV SAO JOSE', 'COMPENSA                      ');
INSERT INTO cd_cep_br VALUES ('69.027-212', '156      ', 'BC SAO JOSE', 'S RAIMUNDO                    ');
INSERT INTO cd_cep_br VALUES ('69.063-513', '156      ', 'BC SAO JOSE', 'S FRANCISCO                   ');
INSERT INTO cd_cep_br VALUES ('69.042-403', '156      ', 'BC SAO JOSE', 'ALVORADA                      ');
INSERT INTO cd_cep_br VALUES ('69.039-715', '156      ', 'BC SAO JOSE', 'N ISRAEL                      ');
INSERT INTO cd_cep_br VALUES ('69.039-714', '156      ', 'R SAO JOSE', 'N ISRAEL                      ');
INSERT INTO cd_cep_br VALUES ('69.063-432', '156      ', 'BC SAO JOSE', 'PETROPOLIS                    ');
INSERT INTO cd_cep_br VALUES ('69.063-151', '156      ', 'BC SAO JOSE', 'S FRANCISCO                   ');
INSERT INTO cd_cep_br VALUES ('69.083-011', '156      ', 'TV SAO JOSE', 'ALEIXO                        ');
INSERT INTO cd_cep_br VALUES ('69.078-052', '156      ', 'BC SAO JOSE', 'JAPIIM                        ');
INSERT INTO cd_cep_br VALUES ('69.093-406', '156      ', 'BC SAO JOSE(T. NOVA I)', 'COL T NOVA                    ');
INSERT INTO cd_cep_br VALUES ('69.093-768', '156      ', 'R SAO JOSE(T. NOVA II)', 'COL T NOVA                    ');
INSERT INTO cd_cep_br VALUES ('69.063-612', '156      ', 'R SAO JOSE (S SEBASTIAO)', 'PETROPOLIS                    ');
INSERT INTO cd_cep_br VALUES ('69.035-806', '156      ', 'TV SAO JOSE (VL MARINHO)', 'COMPENSA                      ');
INSERT INTO cd_cep_br VALUES ('69.035-805', '156      ', 'BC SAO JOSE (VL MARINHO)', 'COMPENSA                      ');
INSERT INTO cd_cep_br VALUES ('69.057-460', '156      ', 'PRQ SAO JOSE DO RIO NEGRO', 'ADRIANOPOLIS                  ');
INSERT INTO cd_cep_br VALUES ('69.074-790', '156      ', 'BC SAO JUDAS', 'MRO LIBERDADE                 ');
INSERT INTO cd_cep_br VALUES ('69.058-160', '156      ', 'CJ SAO JUDAS TADEU', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('69.028-360', '156      ', 'R SAO JUDAS TADEU', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('69.055-730', '156      ', 'BC SAO JUDAS TADEU', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.093-280', '156      ', 'R SAO JUDAS TADEU', 'COL S ANTONIO                 ');
INSERT INTO cd_cep_br VALUES ('69.060-710', '156      ', 'BC SAO LAZARO', 'ALEIXO                        ');
INSERT INTO cd_cep_br VALUES ('69.073-090', '156      ', 'R SAO LAZARO', 'BETANIA                       ');
INSERT INTO cd_cep_br VALUES ('69.029-250', '156      ', 'R SAO LAZARO', 'S ANTONIO                     ');
INSERT INTO cd_cep_br VALUES ('69.053-260', '156      ', 'R SAO LAZARO', 'S GERALDO                     ');
INSERT INTO cd_cep_br VALUES ('69.073-610', '156      ', 'BC SAO LAZARO', 'S LAZARO                      ');
INSERT INTO cd_cep_br VALUES ('69.075-461', '156      ', 'R SAO LAZARO', 'MAUAZINHO                     ');
INSERT INTO cd_cep_br VALUES ('69.070-741', '156      ', 'BC SAO JORGE', 'COL O MACHADO                 ');
INSERT INTO cd_cep_br VALUES ('69.035-750', '156      ', 'BC SAO JORGE', 'COMPENSA                      ');
INSERT INTO cd_cep_br VALUES ('69.082-270', '156      ', 'BC SAO JORGE', 'COROADO                       ');
INSERT INTO cd_cep_br VALUES ('69.070-290', '156      ', 'BC SAO JORGE', 'EDUCANDOS                     ');
INSERT INTO cd_cep_br VALUES ('69.033-720', '156      ', 'BC SAO JORGE', 'VL PRATA                      ');
INSERT INTO cd_cep_br VALUES ('69.074-490', '156      ', 'R SAO JORGE', 'S LUZIA                       ');
INSERT INTO cd_cep_br VALUES ('69.027-560', '156      ', 'BC SAO JORGE', 'S RAIMUNDO                    ');
INSERT INTO cd_cep_br VALUES ('69.047-171', '156      ', 'R SAO JORGE', 'REDENCAO                      ');
INSERT INTO cd_cep_br VALUES ('69.093-270', '156      ', 'R SAO JORGE', 'COL S ANTONIO                 ');
INSERT INTO cd_cep_br VALUES ('69.043-801', '156      ', 'BC SAO JORGE', 'ALVORADA                      ');
INSERT INTO cd_cep_br VALUES ('69.070-740', '156      ', 'R SAO JORGE', 'COL O MACHADO                 ');
INSERT INTO cd_cep_br VALUES ('69.033-000', '156      ', 'AV SAO JORGE- ATE 0773/0774', 'S JORGE                       ');
INSERT INTO cd_cep_br VALUES ('69.033-001', '156      ', 'AV SAO JORGE- DE 0775/0776 A 1009/1010', 'S JORGE                       ');
INSERT INTO cd_cep_br VALUES ('69.030-680', '156      ', 'AV SAO JORGE- DE 1011/1012 AO FIM', 'S JORGE                       ');
INSERT INTO cd_cep_br VALUES ('69.048-327', '156      ', 'BC SAO JORGE (CJ JURUA)', 'ALVORADA                      ');
INSERT INTO cd_cep_br VALUES ('69.083-010', '156      ', 'R SAO JOSE', 'ALEIXO                        ');
INSERT INTO cd_cep_br VALUES ('69.060-120', '156      ', 'BC SAO JOSE', 'ALEIXO                        ');
INSERT INTO cd_cep_br VALUES ('69.043-790', '156      ', 'BC SAO JOSE', 'ALVORADA                      ');
INSERT INTO cd_cep_br VALUES ('69.043-800', '156      ', 'R SAO JOSE', 'ALVORADA                      ');
INSERT INTO cd_cep_br VALUES ('69.073-591', '156      ', 'BC SAO JOSE', 'BETANIA                       ');
INSERT INTO cd_cep_br VALUES ('69.073-590', '156      ', 'R SAO JOSE', 'BETANIA                       ');
INSERT INTO cd_cep_br VALUES ('69.020-320', '156      ', 'BC SAO JOSE', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('69.070-720', '156      ', 'BC SAO JOSE', 'COL O MACHADO                 ');
INSERT INTO cd_cep_br VALUES ('69.070-730', '156      ', 'R SAO JOSE', 'COL O MACHADO                 ');
INSERT INTO cd_cep_br VALUES ('69.035-270', '156      ', 'BC SAO JOSE', 'COMPENSA                      ');
INSERT INTO cd_cep_br VALUES ('69.035-280', '156      ', 'R SAO JOSE', 'COMPENSA                      ');
INSERT INTO cd_cep_br VALUES ('69.080-311', '156      ', 'BC SAO JOSE', 'COROADO                       ');
INSERT INTO cd_cep_br VALUES ('69.070-300', '156      ', 'BC SAO JOSE', 'EDUCANDOS                     ');
INSERT INTO cd_cep_br VALUES ('69.027-710', '156      ', 'BC SAO JOSE', 'GLORIA                        ');
INSERT INTO cd_cep_br VALUES ('69.037-610', '156      ', 'BC SAO JOSE', 'L VALE                        ');
INSERT INTO cd_cep_br VALUES ('69.038-090', '156      ', 'R SAO JOSE', 'L VALE                        ');
INSERT INTO cd_cep_br VALUES ('69.074-680', '156      ', 'BC SAO JOSE', 'MRO LIBERDADE                 ');
INSERT INTO cd_cep_br VALUES ('69.025-260', '156      ', 'R SAO JOSE', 'P VARGAS                      ');
INSERT INTO cd_cep_br VALUES ('69.068-620', '156      ', 'R SAO JOSE', 'RAIZ                          ');
INSERT INTO cd_cep_br VALUES ('69.036-770', '156      ', 'BC SAO JOSE', 'S AGOSTINHO                   ');
INSERT INTO cd_cep_br VALUES ('69.053-240', '156      ', 'BC SAO JOSE', 'S GERALDO                     ');
INSERT INTO cd_cep_br VALUES ('69.033-280', '156      ', 'BC SAO JOSE', 'S JORGE                       ');
INSERT INTO cd_cep_br VALUES ('69.033-080', '156      ', 'R SAO JOSE', 'S JORGE                       ');
INSERT INTO cd_cep_br VALUES ('69.035-030', '156      ', 'R SAO JOAO', 'COMPENSA                      ');
INSERT INTO cd_cep_br VALUES ('69.080-300', '156      ', 'BC SAO JOAO', 'COROADO                       ');
INSERT INTO cd_cep_br VALUES ('69.082-260', '156      ', 'R SAO JOAO', 'COROADO                       ');
INSERT INTO cd_cep_br VALUES ('69.070-170', '156      ', 'BC SAO JOAO', 'EDUCANDOS                     ');
INSERT INTO cd_cep_br VALUES ('69.048-060', '156      ', 'BC SAO JOAO', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('69.038-160', '156      ', 'R SAO JOAO', 'L VALE                        ');
INSERT INTO cd_cep_br VALUES ('69.063-620', '156      ', 'BC SAO JOAO', 'PETROPOLIS                    ');
INSERT INTO cd_cep_br VALUES ('69.068-170', '156      ', 'BC SAO JOAO', 'RAIZ                          ');
INSERT INTO cd_cep_br VALUES ('69.068-180', '156      ', 'R SAO JOAO', 'RAIZ                          ');
INSERT INTO cd_cep_br VALUES ('69.036-730', '156      ', 'BC SAO JOAO', 'S AGOSTINHO                   ');
INSERT INTO cd_cep_br VALUES ('69.029-240', '156      ', 'R SAO JOAO', 'S ANTONIO                     ');
INSERT INTO cd_cep_br VALUES ('69.033-240', '156      ', 'R SAO JOAO', 'S JORGE                       ');
INSERT INTO cd_cep_br VALUES ('69.074-020', '156      ', 'AV SAO JOAO', 'S LUZIA                       ');
INSERT INTO cd_cep_br VALUES ('69.027-200', '156      ', 'R SAO JOAO', 'S RAIMUNDO                    ');
INSERT INTO cd_cep_br VALUES ('69.093-000', '156      ', 'AV SAO JOAO', 'COL S ANTONIO                 ');
INSERT INTO cd_cep_br VALUES ('69.093-260', '156      ', 'R SAO JOAO', 'COL S ANTONIO                 ');
INSERT INTO cd_cep_br VALUES ('69.097-790', '156      ', 'R QUARENTA(O. FROTA II)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.099-111', '156      ', 'R QUARENTA - A(A. MENDES)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.097-792', '156      ', 'R QUARENTA - A(O. FROTA II)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.099-113', '156      ', 'R QUARENTA - B(A. MENDES)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.099-115', '156      ', 'R QUARENTA - C(A. MENDES)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.077-354', '156      ', 'R QUARENTA E CINCO(JAPIINLANDIA)', 'JAPIIM                        ');
INSERT INTO cd_cep_br VALUES ('69.099-117', '156      ', 'R QUARENTA E DOIS - A(A. MENDES)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.077-352', '156      ', 'R QUARENTA E NOVE(JAPIINLANDIA)', 'JAPIIM                        ');
INSERT INTO cd_cep_br VALUES ('69.099-371', '156      ', 'R QUARENTA E NOVE - B(A. MENDES)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.077-358', '156      ', 'R QUARENTA E OITO(JAPIINLANDIA)', 'JAPIIM                        ');
INSERT INTO cd_cep_br VALUES ('69.099-373', '156      ', 'R QUARENTA E QUATRO - B(A. MENDES)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.099-375', '156      ', 'R QUARENTA E QUATRO - C(A. MENDES)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.099-377', '156      ', 'R QUARENTA E QUATRO - D(A. MENDES)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.077-356', '156      ', 'R QUARENTA E SEIS(JAPIINLANDIA)', 'JAPIIM                        ');
INSERT INTO cd_cep_br VALUES ('69.099-353', '156      ', 'R QUARENTA E TRES - A(A. MENDES)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.035-813', '156      ', 'R QUARENTAO, DO', 'COMPENSA                      ');
INSERT INTO cd_cep_br VALUES ('69.033-730', '156      ', 'TV QUATORZE DE ABRIL', 'S JORGE                       ');
INSERT INTO cd_cep_br VALUES ('69.067-477', '156      ', 'R QUATORZE DE JANEIRO', 'PETROPOLIS                    ');
INSERT INTO cd_cep_br VALUES ('69.074-440', '156      ', 'R QUATORZE DE JULHO', 'S LUZIA                       ');
INSERT INTO cd_cep_br VALUES ('69.033-731', '156      ', 'TV QUATORZE DE MARCO', 'S JORGE                       ');
INSERT INTO cd_cep_br VALUES ('69.067-444', '156      ', 'R QUATORZE DE NOVEMBRO', 'PETROPOLIS                    ');
INSERT INTO cd_cep_br VALUES ('69.037-772', '156      ', 'R QUATRO', 'L VALE                        ');
INSERT INTO cd_cep_br VALUES ('69.085-644', '156      ', 'R QUATRO (ASTECA)', 'S J OPERARIO                  ');
INSERT INTO cd_cep_br VALUES ('69.054-733', '156      ', 'R QUATRO (COL JAPONESA)', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.059-450', '156      ', 'R QUATRO DE ABRIL', 'S ETELVINA                    ');
INSERT INTO cd_cep_br VALUES ('69.057-190', '156      ', 'BC QUATRO DE JULHO', 'ADRIANOPOLIS                  ');
INSERT INTO cd_cep_br VALUES ('69.093-096', '156      ', 'R QUICHUA(T. NOVA II)', 'COL T NOVA                    ');
INSERT INTO cd_cep_br VALUES ('69.005-110', '156      ', 'R QUINTINO BOCAIUVA', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('69.042-522', '156      ', 'BC QUINZE', 'D PEDRO                       ');
INSERT INTO cd_cep_br VALUES ('69.055-162', '156      ', 'R QUINZE A (MERIDIONAL)', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.027-180', '156      ', 'BC QUINZE DE AGOSTO', 'S RAIMUNDO                    ');
INSERT INTO cd_cep_br VALUES ('69.068-740', '156      ', 'R QUINZE DE AGOSTO', 'RAIZ                          ');
INSERT INTO cd_cep_br VALUES ('69.035-817', '156      ', 'R QUINZE DE DEZEMBRO', 'COMPENSA                      ');
INSERT INTO cd_cep_br VALUES ('69.075-720', '156      ', 'R QUINZE DE JANEIRO', 'MAUAZINHO                     ');
INSERT INTO cd_cep_br VALUES ('69.059-460', '156      ', 'R QUINZE DE JULHO', 'S ETELVINA                    ');
INSERT INTO cd_cep_br VALUES ('69.037-700', '156      ', 'R QUINZE DE MAIO', 'L VALE                        ');
INSERT INTO cd_cep_br VALUES ('69.093-160', '156      ', 'R QUINZE DE MARCO', 'COL S ANTONIO                 ');
INSERT INTO cd_cep_br VALUES ('69.083-681', '156      ', 'R PROJETADA (CJ PETRO)', 'ALEIXO                        ');
INSERT INTO cd_cep_br VALUES ('69.039-730', '156      ', 'R PROJETADA I', 'N ISRAEL                      ');
INSERT INTO cd_cep_br VALUES ('69.047-291', '156      ', 'R PROJETADA I', 'REDENCAO                      ');
INSERT INTO cd_cep_br VALUES ('69.036-521', '156      ', 'BC PROJETADA I(S. AGOSTINHO)', 'S AGOSTINHO                   ');
INSERT INTO cd_cep_br VALUES ('69.093-183', '156      ', 'R PROJETADA I(T. NOVA II)', 'COL T NOVA                    ');
INSERT INTO cd_cep_br VALUES ('69.039-731', '156      ', 'R PROJETADA II', 'N ISRAEL                      ');
INSERT INTO cd_cep_br VALUES ('69.036-522', '156      ', 'R PROJETADA II(S. AGOSTINHO)', 'S AGOSTINHO                   ');
INSERT INTO cd_cep_br VALUES ('69.039-732', '156      ', 'R PROJETADA III', 'N ISRAEL                      ');
INSERT INTO cd_cep_br VALUES ('69.036-523', '156      ', 'R PROJETADA III(S. AGOSTINHO)', 'S AGOSTINHO                   ');
INSERT INTO cd_cep_br VALUES ('69.036-524', '156      ', 'R PROJETADA IV(S. AGOSTINHO)', 'S AGOSTINHO                   ');
INSERT INTO cd_cep_br VALUES ('69.036-525', '156      ', 'R PROJETADA V(S. AGOSTINHO)', 'S AGOSTINHO                   ');
INSERT INTO cd_cep_br VALUES ('69.076-446', '156      ', 'BC PROJETADO', 'JAPIIM                        ');
INSERT INTO cd_cep_br VALUES ('69.042-820', '156      ', 'CJ PROMORAR DOM BOSCO', 'ALVORADA                      ');
INSERT INTO cd_cep_br VALUES ('69.035-641', '156      ', 'BC PROSPERIDADE', 'COMPENSA                      ');
INSERT INTO cd_cep_br VALUES ('69.063-191', '156      ', 'BC PROSPERIDADE', 'S FRANCISCO                   ');
INSERT INTO cd_cep_br VALUES ('69.035-640', '156      ', 'R PROSPERIDADE, DA', 'COMPENSA                      ');
INSERT INTO cd_cep_br VALUES ('69.053-230', '156      ', 'BC PTB', 'S GERALDO                     ');
INSERT INTO cd_cep_br VALUES ('69.020-730', '156      ', 'VL PUDICO', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('69.045-520', '156      ', 'R PUEBLA (CJ C ELISIOS)', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('69.090-250', '156      ', 'R PUPUNHA (CJ C NOVA)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.088-490', '156      ', 'R PUPUNHEIRA, DAS', 'J TEIXEIRA                    ');
INSERT INTO cd_cep_br VALUES ('69.088-441', '156      ', 'R PUQUI', 'J TEIXEIRA                    ');
INSERT INTO cd_cep_br VALUES ('69.047-210', '156      ', 'R PURANGA', 'REDENCAO                      ');
INSERT INTO cd_cep_br VALUES ('69.090-080', '156      ', 'R PURANGA (CJ C NOVA)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.075-180', '156      ', 'R PURAQUE', 'DT INDUSTRIAL                 ');
INSERT INTO cd_cep_br VALUES ('69.081-030', '156      ', 'R PURAQUE', 'J TEIXEIRA                    ');
INSERT INTO cd_cep_br VALUES ('69.075-190', '156      ', 'R PURUS', 'DT INDUSTRIAL                 ');
INSERT INTO cd_cep_br VALUES ('69.074-300', '156      ', 'R PURUS (VL MILITAR PONTA PELADA)', 'S LAZARO                      ');
INSERT INTO cd_cep_br VALUES ('69.089-240', '156      ', 'R Q', 'A MENDES                      ');
INSERT INTO cd_cep_br VALUES ('69.042-270', '156      ', 'AV Q', 'ALVORADA                      ');
INSERT INTO cd_cep_br VALUES ('69.097-260', '156      ', 'R Q (CJ CANARANAS)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.043-460', '156      ', 'R Q (CJ DE FLORES II)', 'ALVORADA                      ');
INSERT INTO cd_cep_br VALUES ('69.050-310', '156      ', 'R Q (CJ ELDORADO)', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.095-590', '156      ', 'R Q (CJ R JUNIOR)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.095-770', '156      ', 'R Q (CJ R S PINTO II)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.060-520', '156      ', 'Q Q (PRQ ADRIANOPOLIS)', 'ADRIANOPOLIS                  ');
INSERT INTO cd_cep_br VALUES ('69.054-754', '156      ', 'R Q (SHANGRILA VII)', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.060-080', '156      ', 'R Q/T (CJ M DO SOL)', 'ALEIXO                        ');
INSERT INTO cd_cep_br VALUES ('69.095-191', '156      ', 'R PRIMEIRO DE MAIO (RIACHO DOCE)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.095-183', '156      ', 'BC PRIMEIRO DE MAIO (RIACHO DOCE)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.057-171', '156      ', 'BC PRIMEIRO DE MARCO', 'ADRIANOPOLIS                  ');
INSERT INTO cd_cep_br VALUES ('69.078-140', '156      ', 'R PRIMEIRO DE SETEMBRO', 'JAPIIM                        ');
INSERT INTO cd_cep_br VALUES ('69.042-402', '156      ', 'BC PRIMEIRO DE SETEMBRO', 'ALVORADA                      ');
INSERT INTO cd_cep_br VALUES ('69.070-450', '156      ', 'R PRIMO SABBA', 'EDUCANDOS                     ');
INSERT INTO cd_cep_br VALUES ('69.070-451', '156      ', 'BC PRIMO SABBA', 'EDUCANDOS                     ');
INSERT INTO cd_cep_br VALUES ('69.038-220', '156      ', 'R PRINCESA ISABEL', 'L VALE                        ');
INSERT INTO cd_cep_br VALUES ('69.073-282', '156      ', 'R PRINCESA ISABEL', 'S LAZARO                      ');
INSERT INTO cd_cep_br VALUES ('69.054-110', '156      ', 'R PRINCESA ISABEL (CJ VL REI)', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.054-120', '156      ', 'R PRINCESA LEOPOLDINA (CJ VL REI)', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.089-230', '156      ', 'R PRINCIPAL', 'A MENDES                      ');
INSERT INTO cd_cep_br VALUES ('69.073-180', '156      ', 'R PRINCIPAL', 'CRESPO                        ');
INSERT INTO cd_cep_br VALUES ('69.038-001', '156      ', 'Q PRINCIPAL', 'L VALE                        ');
INSERT INTO cd_cep_br VALUES ('69.063-401', '156      ', 'R PRINCIPAL', 'PETROPOLIS                    ');
INSERT INTO cd_cep_br VALUES ('69.085-441', '156      ', 'R PRINCIPAL (CJ SEN JOAO BOSCO I)', 'S J OPERARIO                  ');
INSERT INTO cd_cep_br VALUES ('69.060-650', '156      ', 'R PRINCIPAL (PRQ ADRIANOPOLIS)', 'ADRIANOPOLIS                  ');
INSERT INTO cd_cep_br VALUES ('69.008-050', '156      ', 'R PROFESSOR AZEVEDO', 'COL A ALEIXO                  ');
INSERT INTO cd_cep_br VALUES ('69.074-350', '156      ', 'R PROFESSOR CARLOS MESQUITA', 'S LUZIA                       ');
INSERT INTO cd_cep_br VALUES ('69.059-000', '156      ', 'R PROFESSOR ISAIAS FILHO', 'S ETELVINA                    ');
INSERT INTO cd_cep_br VALUES ('69.074-030', '156      ', 'R PROFESSOR JOAO LEDA', 'COL O MACHADO                 ');
INSERT INTO cd_cep_br VALUES ('69.074-600', '156      ', 'R PROFESSOR JOSE ESTEVES', 'MRO LIBERDADE                 ');
INSERT INTO cd_cep_br VALUES ('69.057-030', '156      ', 'R PROFESSOR MARCIANO ARMOND- ATE 602/759', 'ADRIANOPOLIS                  ');
INSERT INTO cd_cep_br VALUES ('69.065-120', '156      ', 'R PROFESSOR MARCIANO ARMOND- DE 604/761 AO FIM', 'CACHOEIRINHA                  ');
INSERT INTO cd_cep_br VALUES ('69.080-260', '156      ', 'BC SANTA MARIA', 'COROADO                       ');
INSERT INTO cd_cep_br VALUES ('69.068-270', '156      ', 'R SANTA MARIA', 'RAIZ                          ');
INSERT INTO cd_cep_br VALUES ('69.036-740', '156      ', 'BC SANTA MARIA', 'S AGOSTINHO                   ');
INSERT INTO cd_cep_br VALUES ('69.087-450', '156      ', 'BC SANTA MARIA', 'T NEVES                       ');
INSERT INTO cd_cep_br VALUES ('69.039-716', '156      ', 'R SANTA MARIA', 'N ISRAEL                      ');
INSERT INTO cd_cep_br VALUES ('69.084-452', '156      ', 'R SANTA MARTA', 'Z PALMARES                    ');
INSERT INTO cd_cep_br VALUES ('69.039-738', '156      ', 'R SANTA MARTA', 'N ISRAEL                      ');
INSERT INTO cd_cep_br VALUES ('69.039-800', '156      ', 'BC SANTA MARTA', 'N ISRAEL                      ');
INSERT INTO cd_cep_br VALUES ('69.093-469', '156      ', 'R SANTA MONICA(T. NOVA I)', 'COL T NOVA                    ');
INSERT INTO cd_cep_br VALUES ('69.093-753', '156      ', 'AV SANTA MONICA(T. NOVA II)', 'COL T NOVA                    ');
INSERT INTO cd_cep_br VALUES ('69.025-080', '156      ', 'R SANTA QUITERIA', 'P VARGAS                      ');
INSERT INTO cd_cep_br VALUES ('69.060-691', '156      ', 'BC SANTA RITA', 'ALEIXO                        ');
INSERT INTO cd_cep_br VALUES ('69.035-300', '156      ', 'R SANTA RITA', 'COMPENSA                      ');
INSERT INTO cd_cep_br VALUES ('69.080-480', '156      ', 'BC SANTA RITA', 'COROADO                       ');
INSERT INTO cd_cep_br VALUES ('69.080-490', '156      ', 'R SANTA RITA', 'COROADO                       ');
INSERT INTO cd_cep_br VALUES ('69.037-710', '156      ', 'R SANTA RITA', 'S AGOSTINHO                   ');
INSERT INTO cd_cep_br VALUES ('69.074-480', '156      ', 'BC SANTA RITA', 'S LUZIA                       ');
INSERT INTO cd_cep_br VALUES ('69.074-470', '156      ', 'R SANTA RITA', 'S LUZIA                       ');
INSERT INTO cd_cep_br VALUES ('69.087-451', '156      ', 'R SANTA RITA', 'T NEVES                       ');
INSERT INTO cd_cep_br VALUES ('69.079-441', '156      ', 'R SANTA RITA', 'S FRANCISCO                   ');
INSERT INTO cd_cep_br VALUES ('69.073-381', '156      ', 'BC SANTA RITA', 'BETANIA                       ');
INSERT INTO cd_cep_br VALUES ('69.037-711', '156      ', 'BC SANTA RITA', 'S AGOSTINHO                   ');
INSERT INTO cd_cep_br VALUES ('69.035-301', '156      ', 'BC SANTA RITA', 'COMPENSA                      ');
INSERT INTO cd_cep_br VALUES ('69.084-595', '156      ', 'R SANTA RITA', 'Z PALMARES                    ');
INSERT INTO cd_cep_br VALUES ('69.042-324', '156      ', 'BC SANTA RITA', 'ALVORADA                      ');
INSERT INTO cd_cep_br VALUES ('69.085-571', '156      ', 'BC SANTA RITA', 'S J OPERARIO                  ');
INSERT INTO cd_cep_br VALUES ('69.039-712', '156      ', 'R SANTA RITA', 'N ISRAEL                      ');
INSERT INTO cd_cep_br VALUES ('69.067-605', '156      ', 'BC SANTA RITA', 'PETROPOLIS                    ');
INSERT INTO cd_cep_br VALUES ('69.079-431', '156      ', 'BC SANTA RITA', 'S FRANCISCO                   ');
INSERT INTO cd_cep_br VALUES ('69.035-630', '156      ', 'TV SANTA ROSA', 'COMPENSA                      ');
INSERT INTO cd_cep_br VALUES ('69.074-840', '156      ', 'R SANTA ROSA', 'MRO LIBERDADE                 ');
INSERT INTO cd_cep_br VALUES ('69.036-750', '156      ', 'BC SANTA ROSA', 'S AGOSTINHO                   ');
INSERT INTO cd_cep_br VALUES ('69.039-611', '156      ', 'BC SANTA ROSA', 'N ISRAEL                      ');
INSERT INTO cd_cep_br VALUES ('69.093-034', '156      ', 'R SANTA ROSA', 'COL S ANTONIO                 ');
INSERT INTO cd_cep_br VALUES ('69.067-603', '156      ', 'BC SANTA ROSA (S SEBASTIAO)', 'PETROPOLIS                    ');
INSERT INTO cd_cep_br VALUES ('69.084-602', '156      ', 'R SANTA ROSA DE LIMA', 'Z PALMARES                    ');
INSERT INTO cd_cep_br VALUES ('69.074-620', '156      ', 'BC SANTA TEREZA', 'MRO LIBERDADE                 ');
INSERT INTO cd_cep_br VALUES ('69.085-625', '156      ', 'BC SANTA INES', 'ALEIXO                        ');
INSERT INTO cd_cep_br VALUES ('69.043-770', '156      ', 'BC SANTA ISABEL', 'ALVORADA                      ');
INSERT INTO cd_cep_br VALUES ('69.065-160', '156      ', 'R SANTA ISABEL', 'CACHOEIRINHA                  ');
INSERT INTO cd_cep_br VALUES ('69.020-360', '156      ', 'BC SANTA ISABEL', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('69.020-150', '156      ', 'R SANTA ISABEL', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('69.035-740', '156      ', 'BC SANTA ISABEL', 'COMPENSA                      ');
INSERT INTO cd_cep_br VALUES ('69.036-510', '156      ', 'R SANTA ISABEL', 'S AGOSTINHO                   ');
INSERT INTO cd_cep_br VALUES ('69.033-330', '156      ', 'BC SANTA ISABEL', 'S JORGE                       ');
INSERT INTO cd_cep_br VALUES ('69.033-170', '156      ', 'R SANTA ISABEL', 'VL PRATA                      ');
INSERT INTO cd_cep_br VALUES ('69.027-410', '156      ', 'R SANTA ISABEL', 'GLORIA                        ');
INSERT INTO cd_cep_br VALUES ('69.065-161', '156      ', 'BC SANTA ISABEL', 'CACHOEIRINHA                  ');
INSERT INTO cd_cep_br VALUES ('69.036-511', '156      ', 'BC SANTA ISABEL', 'S AGOSTINHO                   ');
INSERT INTO cd_cep_br VALUES ('69.084-626', '156      ', 'R SANTA ISABEL', 'Z PALMARES                    ');
INSERT INTO cd_cep_br VALUES ('69.039-610', '156      ', 'BC SANTA IZABEL', 'N ISRAEL                      ');
INSERT INTO cd_cep_br VALUES ('69.038-820', '156      ', 'R SANTA JULIA', 'L VALE                        ');
INSERT INTO cd_cep_br VALUES ('69.038-821', '156      ', 'TV SANTA JULIA', 'L VALE                        ');
INSERT INTO cd_cep_br VALUES ('69.073-250', '156      ', 'R SANTA LUCIA', 'S LAZARO                      ');
INSERT INTO cd_cep_br VALUES ('69.035-480', '156      ', 'R SANTA LUCILA', 'COMPENSA                      ');
INSERT INTO cd_cep_br VALUES ('69.035-481', '156      ', 'BC SANTA LUCILA', 'COMPENSA                      ');
INSERT INTO cd_cep_br VALUES ('69.035-241', '156      ', 'BC SANTA LUZIA', 'COMPENSA                      ');
INSERT INTO cd_cep_br VALUES ('69.035-240', '156      ', 'R SANTA LUZIA', 'COMPENSA                      ');
INSERT INTO cd_cep_br VALUES ('69.038-840', '156      ', 'R SANTA LUZIA', 'L VALE                        ');
INSERT INTO cd_cep_br VALUES ('69.025-240', '156      ', 'R SANTA LUZIA', 'P VARGAS                      ');
INSERT INTO cd_cep_br VALUES ('69.047-260', '156      ', 'R SANTA LUZIA', 'REDENCAO                      ');
INSERT INTO cd_cep_br VALUES ('69.036-520', '156      ', 'RER SANTA LUZIA', 'S AGOSTINHO                   ');
INSERT INTO cd_cep_br VALUES ('69.053-320', '156      ', 'BC SANTA LUZIA', 'S GERALDO                     ');
INSERT INTO cd_cep_br VALUES ('69.053-340', '156      ', 'R SANTA LUZIA', 'S GERALDO                     ');
INSERT INTO cd_cep_br VALUES ('69.053-330', '156      ', 'TV SANTA LUZIA', 'S GERALDO                     ');
INSERT INTO cd_cep_br VALUES ('69.033-470', '156      ', 'R SANTA LUZIA', 'S JORGE                       ');
INSERT INTO cd_cep_br VALUES ('69.074-460', '156      ', 'R SANTA LUZIA', 'S LUZIA                       ');
INSERT INTO cd_cep_br VALUES ('69.059-580', '156      ', 'R SANTA LUZIA', 'S ETELVINA                    ');
INSERT INTO cd_cep_br VALUES ('69.075-430', '156      ', 'R SANTA LUZIA', 'MAUAZINHO                     ');
INSERT INTO cd_cep_br VALUES ('69.074-461', '156      ', 'PC SANTA LUZIA', 'S LUZIA                       ');
INSERT INTO cd_cep_br VALUES ('69.074-462', '156      ', 'BC SANTA LUZIA', 'S LUZIA                       ');
INSERT INTO cd_cep_br VALUES ('69.089-107', '156      ', 'R SANTA LUZIA', 'A MENDES                      ');
INSERT INTO cd_cep_br VALUES ('69.054-591', '156      ', 'R SANTA MADALENA', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('69.048-840', '156      ', 'BC SANTA MARIA', 'ALVORADA                      ');
INSERT INTO cd_cep_br VALUES ('69.030-151', '156      ', 'BC SANTA MARIA', 'COMPENSA                      ');
INSERT INTO cd_cep_br VALUES ('69.078-000', '156      ', 'AV SANTA CRUZ MACHADO', 'JAPIIM                        ');
INSERT INTO cd_cep_br VALUES ('69.078-006', '156      ', 'BC SANTA CRUZ MACHADO', 'JAPIIM                        ');
INSERT INTO cd_cep_br VALUES ('69.093-408', '156      ', 'BC SANTA EDWIRGEM(T. NOVA I)', 'COL T NOVA                    ');
INSERT INTO cd_cep_br VALUES ('69.059-423', '156      ', 'R SANTA ELIANA', 'S ETELVINA                    ');
INSERT INTO cd_cep_br VALUES ('69.073-810', '156      ', 'BC SANTA ETELVINA', 'BETANIA                       ');
INSERT INTO cd_cep_br VALUES ('69.073-800', '156      ', 'R SANTA ETELVINA', 'BETANIA                       ');
INSERT INTO cd_cep_br VALUES ('69.042-541', '156      ', 'BC SANTA ETELVINA', 'D PEDRO                       ');
INSERT INTO cd_cep_br VALUES ('69.059-510', '156      ', 'R SANTA ETELVINA', 'S ETELVINA                    ');
INSERT INTO cd_cep_br VALUES ('69.080-820', '156      ', 'BC SANTA ETELVINA', 'COROADO                       ');
INSERT INTO cd_cep_br VALUES ('69.020-740', '156      ', 'VL SANTA EULALIA', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('69.078-210', '156      ', 'BC SANTA FE', 'JAPIIM                        ');
INSERT INTO cd_cep_br VALUES ('69.087-440', '156      ', 'R SANTA FE', 'T NEVES                       ');
INSERT INTO cd_cep_br VALUES ('69.060-630', '156      ', 'BC SANTA FE', 'ALEIXO                        ');
INSERT INTO cd_cep_br VALUES ('69.073-291', '156      ', 'R SANTA FE', 'BETANIA                       ');
INSERT INTO cd_cep_br VALUES ('69.060-361', '156      ', 'BC SANTA HELENA', 'ALEIXO                        ');
INSERT INTO cd_cep_br VALUES ('69.060-360', '156      ', 'R SANTA HELENA', 'ALEIXO                        ');
INSERT INTO cd_cep_br VALUES ('69.073-070', '156      ', 'R SANTA HELENA', 'BETANIA                       ');
INSERT INTO cd_cep_br VALUES ('69.080-460', '156      ', 'BC SANTA HELENA', 'COROADO                       ');
INSERT INTO cd_cep_br VALUES ('69.080-740', '156      ', 'R SANTA HELENA', 'COROADO                       ');
INSERT INTO cd_cep_br VALUES ('69.078-610', '156      ', 'BC SANTA HELENA', 'JAPIIM                        ');
INSERT INTO cd_cep_br VALUES ('69.053-450', '156      ', 'BC SANTA HELENA', 'N S GRACAS                    ');
INSERT INTO cd_cep_br VALUES ('69.047-250', '156      ', 'R SANTA HELENA', 'REDENCAO                      ');
INSERT INTO cd_cep_br VALUES ('69.033-650', '156      ', 'BC SANTA HELENA', 'S JORGE                       ');
INSERT INTO cd_cep_br VALUES ('69.033-620', '156      ', 'R SANTA HELENA', 'S JORGE                       ');
INSERT INTO cd_cep_br VALUES ('69.027-550', '156      ', 'R SANTA HELENA', 'S RAIMUNDO                    ');
INSERT INTO cd_cep_br VALUES ('69.048-230', '156      ', 'R SANTA HELENA', 'PAZ                           ');
INSERT INTO cd_cep_br VALUES ('69.054-590', '156      ', 'R SANTA HELENA', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('69.059-520', '156      ', 'R SANTA HELENA', 'S ETELVINA                    ');
INSERT INTO cd_cep_br VALUES ('69.075-290', '156      ', 'R SANTA HELENA', 'MAUAZINHO                     ');
INSERT INTO cd_cep_br VALUES ('69.084-472', '156      ', 'R SANTA HELENA', 'Z PALMARES                    ');
INSERT INTO cd_cep_br VALUES ('69.084-473', '156      ', 'BC SANTA HELENA', 'Z PALMARES                    ');
INSERT INTO cd_cep_br VALUES ('69.089-104', '156      ', 'R SANTA HELENA', 'A MENDES                      ');
INSERT INTO cd_cep_br VALUES ('69.042-323', '156      ', 'BC SANTA HELENA', 'ALVORADA                      ');
INSERT INTO cd_cep_br VALUES ('69.093-645', '156      ', 'R SANTA HELENA(T. NOVA I)', 'COL T NOVA                    ');
INSERT INTO cd_cep_br VALUES ('40.830-730', '435      ', 'R SANTO EDSON', 'PARIPE                        ');
INSERT INTO cd_cep_br VALUES ('41.215-320', '435      ', 'R SANTO ESTEVAO', 'SUSSUARANA                    ');
INSERT INTO cd_cep_br VALUES ('41.920-280', '435      ', 'R SANTO ESTEVAO', 'S CRUZ                        ');
INSERT INTO cd_cep_br VALUES ('40.290-535', '435      ', 'AV SANTO EUFRASIO', 'BROTAS                        ');
INSERT INTO cd_cep_br VALUES ('40.387-070', '435      ', 'TV SANTO INACIO', 'S CAETANO                     ');
INSERT INTO cd_cep_br VALUES ('41.927-510', '435      ', 'R SANTO INACIO', 'NORDESTE                      ');
INSERT INTO cd_cep_br VALUES ('41.230-580', '435      ', 'JD SANTO INACIO', 'M ESCURA                      ');
INSERT INTO cd_cep_br VALUES ('41.180-100', '435      ', 'LOT SANTO INACIO', 'SABOEIRO                      ');
INSERT INTO cd_cep_br VALUES ('40.750-670', '435      ', 'R SANTO INACIO', 'COUTOS                        ');
INSERT INTO cd_cep_br VALUES ('41.195-110', '435      ', 'TV SANTO INACIO DE LOIOLA', 'BARREIRAS                     ');
INSERT INTO cd_cep_br VALUES ('40.253-260', '435      ', 'R SANTO ONOFRE', 'C FARIAS                      ');
INSERT INTO cd_cep_br VALUES ('40.215-830', '435      ', 'TV SANTO ONOFRE', 'FEDERACAO                     ');
INSERT INTO cd_cep_br VALUES ('40.215-810', '435      ', 'BC SANTO ONOFRE', 'FEDERACAO                     ');
INSERT INTO cd_cep_br VALUES ('40.335-210', '435      ', 'R SANTO ONOFRE', 'P VAZ                         ');
INSERT INTO cd_cep_br VALUES ('41.185-080', '435      ', 'TV SANTO ONOFRE', 'S GONCALO                     ');
INSERT INTO cd_cep_br VALUES ('41.185-070', '435      ', 'R SANTO ONOFRE', 'S GONCALO                     ');
INSERT INTO cd_cep_br VALUES ('41.615-160', '435      ', 'R SANTO ONOFRE', 'AT COQUEIRINHO                ');
INSERT INTO cd_cep_br VALUES ('40.285-060', '435      ', 'TV SANTO SILVA', 'BROTAS                        ');
INSERT INTO cd_cep_br VALUES ('40.410-480', '435      ', 'AV SANTORO', 'CALCADA                       ');
INSERT INTO cd_cep_br VALUES ('40.350-190', '435      ', 'AV SANTOS', 'FAZ G RETIRO                  ');
INSERT INTO cd_cep_br VALUES ('40.260-590', '435      ', 'TV SANTOS', 'L ANSELMO                     ');
INSERT INTO cd_cep_br VALUES ('40.205-060', '435      ', 'AV SANTOS', 'FEDERACAO                     ');
INSERT INTO cd_cep_br VALUES ('40.313-200', '435      ', 'AV SANTOS', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('40.355-700', '435      ', 'TV SANTOS', 'S MARTIN                      ');
INSERT INTO cd_cep_br VALUES ('40.355-530', '435      ', 'AV SANTOS', 'S MARTIN                      ');
INSERT INTO cd_cep_br VALUES ('40.255-535', '435      ', 'VL SANTOS', 'E V BROTAS                    ');
INSERT INTO cd_cep_br VALUES ('41.215-480', '435      ', 'R SANTOS DUMONT', 'SUSSUARANA                    ');
INSERT INTO cd_cep_br VALUES ('40.410-130', '435      ', 'AV SANTO ANTONIO', 'B VIAGEM                      ');
INSERT INTO cd_cep_br VALUES ('40.389-100', '435      ', 'VL SANTO ANTONIO', 'S CAETANO                     ');
INSERT INTO cd_cep_br VALUES ('40.215-820', '435      ', 'TV SANTO ANTONIO', 'FEDERACAO                     ');
INSERT INTO cd_cep_br VALUES ('40.355-680', '435      ', 'AV SANTO ANTONIO', 'FAZ G RETIRO                  ');
INSERT INTO cd_cep_br VALUES ('41.500-220', '435      ', 'TV SANTO ANTONIO', 'S CRISTOVAO                   ');
INSERT INTO cd_cep_br VALUES ('40.280-446', '435      ', 'R SANTO ANTONIO', 'CANDEAL                       ');
INSERT INTO cd_cep_br VALUES ('41.120-360', '435      ', 'LD SANTO ANTONIO', 'PERNAMBUES                    ');
INSERT INTO cd_cep_br VALUES ('40.250-260', '435      ', 'AV SANTO ANTONIO', 'C FARIAS                      ');
INSERT INTO cd_cep_br VALUES ('41.715-370', '435      ', 'R SANTO ANTONIO', 'B RIO                         ');
INSERT INTO cd_cep_br VALUES ('41.810-540', '435      ', 'PRQ SANTO ANTONIO', 'CAM ARVORES                   ');
INSERT INTO cd_cep_br VALUES ('41.630-110', '435      ', 'AV SANTO ANTONIO', 'ITAPUA                        ');
INSERT INTO cd_cep_br VALUES ('41.204-040', '435      ', 'TV SANTO ANTONIO', 'A RETIRO                      ');
INSERT INTO cd_cep_br VALUES ('41.204-020', '435      ', 'R SANTO ANTONIO', 'A RETIRO                      ');
INSERT INTO cd_cep_br VALUES ('41.204-030', '435      ', 'VL SANTO ANTONIO', 'A RETIRO                      ');
INSERT INTO cd_cep_br VALUES ('41.350-170', '435      ', 'R SANTO ANTONIO', 'N BRASILIA                    ');
INSERT INTO cd_cep_br VALUES ('41.370-040', '435      ', 'LOT SANTO ANTONIO', 'JD N ESPERANCA                ');
INSERT INTO cd_cep_br VALUES ('41.130-050', '435      ', 'AV SANTO ANTONIO', 'PERNAMBUES                    ');
INSERT INTO cd_cep_br VALUES ('40.335-300', '435      ', 'AV SANTO ANTONIO', 'P VAZ                         ');
INSERT INTO cd_cep_br VALUES ('41.620-570', '435      ', 'TV SANTO ANTONIO', 'ITAPUA                        ');
INSERT INTO cd_cep_br VALUES ('40.315-160', '435      ', 'TV SANTO ANTONIO', 'B REIS                        ');
INSERT INTO cd_cep_br VALUES ('40.350-270', '435      ', 'TV SANTO ANTONIO', 'FAZ G RETIRO                  ');
INSERT INTO cd_cep_br VALUES ('40.323-380', '435      ', 'TV SANTO ANTONIO', 'IAPI                          ');
INSERT INTO cd_cep_br VALUES ('40.720-390', '435      ', 'AV SANTO ANTONIO', 'PERIPERI                      ');
INSERT INTO cd_cep_br VALUES ('40.760-190', '435      ', 'TV SANTO ANTONIO', 'COUTOS                        ');
INSERT INTO cd_cep_br VALUES ('40.710-740', '435      ', 'TV SANTO ANTONIO', 'PLATAFORMA                    ');
INSERT INTO cd_cep_br VALUES ('40.395-300', '435      ', 'AV SANTO ANTONIO', 'CAPELINHA                     ');
INSERT INTO cd_cep_br VALUES ('40.370-580', '435      ', 'AV SANTO ANTONIO', 'GUARANI                       ');
INSERT INTO cd_cep_br VALUES ('41.100-355', '435      ', 'R SANTO ANTONIO', 'SARAMANDAIA                   ');
INSERT INTO cd_cep_br VALUES ('41.615-490', '435      ', 'R SANTO ANTONIO', 'AT COQUEIRINHO                ');
INSERT INTO cd_cep_br VALUES ('41.615-500', '435      ', 'TV SANTO ANTONIO', 'AT COQUEIRINHO                ');
INSERT INTO cd_cep_br VALUES ('41.710-187', '435      ', 'TV SANTO ANTONIO', 'B RIO                         ');
INSERT INTO cd_cep_br VALUES ('41.181-030', '435      ', 'CH SANTO ANTONIO', 'CABULA VI                     ');
INSERT INTO cd_cep_br VALUES ('41.297-465', '435      ', 'AV SANTO ANTONIO', 'PIRAJA                        ');
INSERT INTO cd_cep_br VALUES ('40.830-170', '435      ', 'R SANTO ANTONIO', 'PARIPE                        ');
INSERT INTO cd_cep_br VALUES ('41.227-105', '435      ', 'TV SANTO ANTONIO', 'CALABETAO                     ');
INSERT INTO cd_cep_br VALUES ('41.270-665', '435      ', 'TV SANTO ANTONIO', 'CAMPINAS                      ');
INSERT INTO cd_cep_br VALUES ('40.301-330', '435      ', 'LRG SANTO ANTONIO ALEM DO CARMO', 'S ANTONIO                     ');
INSERT INTO cd_cep_br VALUES ('40.130-130', '435      ', 'LRG SANTO ANTONIO DA BARRA', 'BARRA                         ');
INSERT INTO cd_cep_br VALUES ('41.925-800', '435      ', 'AV SANTO ANDRE', 'NORDESTE                      ');
INSERT INTO cd_cep_br VALUES ('41.190-280', '435      ', 'R SANTO ANDRE', 'S GONCALO                     ');
INSERT INTO cd_cep_br VALUES ('41.615-120', '435      ', 'R SANTO ANDRE', 'AT COQUEIRINHO                ');
INSERT INTO cd_cep_br VALUES ('41.200-140', '435      ', 'R SANTO ANTONINO', 'ENGOMADEIRA                   ');
INSERT INTO cd_cep_br VALUES ('41.213-410', '435      ', 'R SANTO ANTONIO', 'SUSSUARANA                    ');
INSERT INTO cd_cep_br VALUES ('41.213-680', '435      ', 'TV SANTO ANTONIO', 'SUSSUARANA                    ');
INSERT INTO cd_cep_br VALUES ('41.250-210', '435      ', 'TV SANTO ANTONIO', 'S MARCOS                      ');
INSERT INTO cd_cep_br VALUES ('40.070-480', '435      ', 'AV SANTO ANTONIO', 'BARRIS                        ');
INSERT INTO cd_cep_br VALUES ('40.320-740', '435      ', 'AV SANTO ANTONIO', 'C D AGUA                      ');
INSERT INTO cd_cep_br VALUES ('40.315-150', '435      ', 'AV SANTO ANTONIO', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('40.317-730', '435      ', 'LD SANTO ANTONIO', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('40.393-380', '435      ', 'TV SANTO ANTONIO', 'CAPELINHA                     ');
INSERT INTO cd_cep_br VALUES ('41.200-340', '435      ', 'AV SANTO ANTONIO', 'ENGOMADEIRA                   ');
INSERT INTO cd_cep_br VALUES ('41.200-320', '435      ', 'LOT SANTO ANTONIO', 'ENGOMADEIRA                   ');
INSERT INTO cd_cep_br VALUES ('41.610-650', '435      ', 'R SANTO ANTONIO', 'ITAPUA                        ');
INSERT INTO cd_cep_br VALUES ('40.435-530', '435      ', 'AV SANTO ANTONIO', 'MASSARANDUBA                  ');
INSERT INTO cd_cep_br VALUES ('41.225-250', '435      ', 'AV SANTO ANTONIO', 'M ESCURA                      ');
INSERT INTO cd_cep_br VALUES ('40.430-080', '435      ', 'R SANTO ANTONIO', 'VL R BARBOSA                  ');
INSERT INTO cd_cep_br VALUES ('41.235-570', '435      ', 'R SANTO ANTONIO', 'P LIMA                        ');
INSERT INTO cd_cep_br VALUES ('40.310-580', '435      ', 'AV SANTO ANTONIO', 'P MIUDO                       ');
INSERT INTO cd_cep_br VALUES ('40.335-130', '435      ', 'VL SANTO ANTONIO', 'P VAZ                         ');
INSERT INTO cd_cep_br VALUES ('40.760-180', '435      ', 'R SANTO ANTONIO', 'COUTOS                        ');
INSERT INTO cd_cep_br VALUES ('41.120-350', '435      ', 'TV SANTO ANTONIO', 'PERNAMBUES                    ');
INSERT INTO cd_cep_br VALUES ('41.290-380', '435      ', 'TV SANTO ANTONIO', 'PIRAJA                        ');
INSERT INTO cd_cep_br VALUES ('40.710-300', '435      ', 'R SANTO ANTONIO', 'ESCADA                        ');
INSERT INTO cd_cep_br VALUES ('41.385-190', '435      ', 'R SANTO ANTONIO', 'S ABRIL                       ');
INSERT INTO cd_cep_br VALUES ('40.395-400', '435      ', 'AV SANTO ANTONIO', 'S CAETANO                     ');
INSERT INTO cd_cep_br VALUES ('41.500-210', '435      ', 'R SANTO ANTONIO', 'S CRISTOVAO                   ');
INSERT INTO cd_cep_br VALUES ('40.300-200', '435      ', 'AV SANTO ANTONIO', 'QUINTAS                       ');
INSERT INTO cd_cep_br VALUES ('69.010-260', '156      ', 'R MARCAL', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('41.927-390', '435      ', 'R SANTO ANTONIO', 'S CRUZ                        ');
INSERT INTO cd_cep_br VALUES ('40.301-420', '435      ', 'LD SANTO ANTONIO', 'S ANTONIO                     ');
INSERT INTO cd_cep_br VALUES ('40.454-060', '435      ', 'R SANTO ANTONIO', 'URUGUAI                       ');
INSERT INTO cd_cep_br VALUES ('40.454-050', '435      ', 'TV SANTO ANTONIO', 'URUGUAI                       ');
INSERT INTO cd_cep_br VALUES ('40.710-730', '435      ', 'R SANTO ANTONIO', 'PLATAFORMA                    ');
INSERT INTO cd_cep_br VALUES ('40.470-310', '435      ', 'AV SANTO ANTONIO', 'LOBATO                        ');
INSERT INTO cd_cep_br VALUES ('41.225-400', '435      ', 'R SANTO ANTONIO', 'M ESCURA                      ');
INSERT INTO cd_cep_br VALUES ('40.480-260', '435      ', 'TV SANTO ANTONIO', 'LOBATO                        ');
INSERT INTO cd_cep_br VALUES ('40.370-300', '435      ', 'AV SANTO ANTONIO', 'LIBERDADE                     ');
INSERT INTO cd_cep_br VALUES ('40.254-150', '435      ', 'TV SANTANA', 'C FARIAS                      ');
INSERT INTO cd_cep_br VALUES ('40.420-580', '435      ', 'TV PADRE CUPERTINO DE LACERDA', 'RIBEIRA                       ');
INSERT INTO cd_cep_br VALUES ('40.285-560', '435      ', 'R PADRE DANIEL LISBOA', 'BROTAS                        ');
INSERT INTO cd_cep_br VALUES ('69.078-081', '156      ', 'BC NOVA OLINDA', 'JAPIIM                        ');
INSERT INTO cd_cep_br VALUES ('69.050-090', '156      ', 'BC PAZ, DA', 'CHAPADA                       ');
INSERT INTO cd_cep_br VALUES ('69.030-111', '156      ', 'BC PAZ, DA', 'COMPENSA                      ');
INSERT INTO cd_cep_br VALUES ('69.030-110', '156      ', 'R PAZ, DA', 'COMPENSA                      ');
INSERT INTO cd_cep_br VALUES ('69.080-230', '156      ', 'BC PAZ, DA', 'COROADO                       ');
INSERT INTO cd_cep_br VALUES ('69.080-240', '156      ', 'R PAZ, DA', 'COROADO                       ');
INSERT INTO cd_cep_br VALUES ('69.037-680', '156      ', 'BC PAZ, DA', 'L VALE                        ');
INSERT INTO cd_cep_br VALUES ('69.037-580', '156      ', 'R PAZ, DA', 'N ESPERANCA                   ');
INSERT INTO cd_cep_br VALUES ('69.025-230', '156      ', 'BC PAZ, DA', 'P VARGAS                      ');
INSERT INTO cd_cep_br VALUES ('69.025-220', '156      ', 'R PAZ, DA', 'P VARGAS                      ');
INSERT INTO cd_cep_br VALUES ('69.036-620', '156      ', 'BC PAZ, DA', 'S AGOSTINHO                   ');
INSERT INTO cd_cep_br VALUES ('69.063-030', '156      ', 'BC PAZ, DA', 'S FRANCISCO                   ');
INSERT INTO cd_cep_br VALUES ('69.074-430', '156      ', 'BC PAZ, DA', 'S LUZIA                       ');
INSERT INTO cd_cep_br VALUES ('69.075-391', '156      ', 'R PAZ, DA', 'MAUAZINHO                     ');
INSERT INTO cd_cep_br VALUES ('69.093-140', '156      ', 'R PAZ, DA', 'COL S ANTONIO                 ');
INSERT INTO cd_cep_br VALUES ('69.036-621', '156      ', 'TV PAZ, DA', 'S AGOSTINHO                   ');
INSERT INTO cd_cep_br VALUES ('69.057-421', '156      ', 'BC PAZ, DA', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.073-121', '156      ', 'R PAZ, DA', 'CRESPO                        ');
INSERT INTO cd_cep_br VALUES ('69.084-521', '156      ', 'BC PAZ, DA', 'Z PALMARES                    ');
INSERT INTO cd_cep_br VALUES ('69.008-431', '156      ', 'R PAZ, DA', 'COL A ALEIXO                  ');
INSERT INTO cd_cep_br VALUES ('69.063-515', '156      ', 'BC PAZ, DA', 'PETROPOLIS                    ');
INSERT INTO cd_cep_br VALUES ('69.030-481', '156      ', 'BC PAZ, DA', 'COMPENSA                      ');
INSERT INTO cd_cep_br VALUES ('69.037-581', '156      ', 'BC PAZ, DA', 'N ESPERANCA                   ');
INSERT INTO cd_cep_br VALUES ('69.087-410', '156      ', 'R PAZ,DA', 'T NEVES                       ');
INSERT INTO cd_cep_br VALUES ('69.082-482', '156      ', 'R PEDESTRE', 'COROADO                       ');
INSERT INTO cd_cep_br VALUES ('69.088-365', '156      ', 'R PEDRA MINEIRA', 'J TEIXEIRA                    ');
INSERT INTO cd_cep_br VALUES ('69.093-489', '156      ', 'R PEDREIRAS DAS(T. NOVA I)', 'COL T NOVA                    ');
INSERT INTO cd_cep_br VALUES ('69.035-819', '156      ', 'R PEDREIRAS, DAS', 'COMPENSA                      ');
INSERT INTO cd_cep_br VALUES ('69.079-350', '156      ', 'BC PEDRO ALEXANDRE', 'PETROPOLIS                    ');
INSERT INTO cd_cep_br VALUES ('69.073-230', '156      ', 'R PEDRO ALVARES CABRAL', 'S LAZARO                      ');
INSERT INTO cd_cep_br VALUES ('69.040-550', '156      ', 'R PEDRO ALVARES CABRAL (CJ D PEDRO I)', 'D PEDRO                       ');
INSERT INTO cd_cep_br VALUES ('69.005-100', '156      ', 'R PEDRO BOTELHO', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('69.080-620', '156      ', 'TV PEDRO COSTA', 'COROADO                       ');
INSERT INTO cd_cep_br VALUES ('69.082-710', '156      ', 'R PEDRO MARQUES DE SOUZA (COND L MARIA)', 'COROADO                       ');
INSERT INTO cd_cep_br VALUES ('69.044-280', '156      ', 'R PEDRO NOBRE (CJ BELVEDERE)', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('69.040-000', '156      ', 'AV PEDRO TEIXEIRA', 'D PEDRO                       ');
INSERT INTO cd_cep_br VALUES ('69.040-160', '156      ', 'BC PEDRO TEIXEIRA', 'D PEDRO                       ');
INSERT INTO cd_cep_br VALUES ('69.060-760', '156      ', 'CJ PARQUE DOS RIOS II', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.060-021', '156      ', 'CON PARQUE DOS RIOS III', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.060-022', '156      ', 'CON PARQUE DOS RIOS IV', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.057-003', '156      ', 'CON PARQUE RESIDENCIAS', 'ADRIANOPOLIS                  ');
INSERT INTO cd_cep_br VALUES ('69.067-332', '156      ', 'R PASSAGEM, DA', 'PETROPOLIS                    ');
INSERT INTO cd_cep_br VALUES ('69.039-050', '156      ', 'R PASSEIO, DO', 'N ISRAEL                      ');
INSERT INTO cd_cep_br VALUES ('69.070-131', '156      ', 'BC PASSOS, DOS', 'EDUCANDOS                     ');
INSERT INTO cd_cep_br VALUES ('69.043-750', '156      ', 'R PASTEUR', 'ALVORADA                      ');
INSERT INTO cd_cep_br VALUES ('69.090-240', '156      ', 'R PATAUA (CJ C NOVA)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.096-020', '156      ', 'R PATAXO (CJ C NOVA)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.030-630', '156      ', 'BC PATRIA, DA', 'VL PRATA                      ');
INSERT INTO cd_cep_br VALUES ('69.033-812', '156      ', 'R PATRIA, DA', 'S JORGE                       ');
INSERT INTO cd_cep_br VALUES ('69.088-363', '156      ', 'R PAU BRASIL', 'J TEIXEIRA                    ');
INSERT INTO cd_cep_br VALUES ('69.093-117', '156      ', 'R PAU ROSA(M.OLIVEIRAS)', 'MTE OLIVEIRAS                 ');
INSERT INTO cd_cep_br VALUES ('69.081-250', '156      ', 'R PAU-BRASIL', 'J TEIXEIRA                    ');
INSERT INTO cd_cep_br VALUES ('69.081-080', '156      ', 'R PAU-ROSA', 'J TEIXEIRA                    ');
INSERT INTO cd_cep_br VALUES ('69.080-293', '156      ', 'R PAULA FRANCINETE', 'COROADO                       ');
INSERT INTO cd_cep_br VALUES ('69.079-360', '156      ', 'R PAULINO GOMES', 'PETROPOLIS                    ');
INSERT INTO cd_cep_br VALUES ('69.082-580', '156      ', 'R PAULO ALVES (O VERDE)', 'COROADO                       ');
INSERT INTO cd_cep_br VALUES ('69.044-100', '156      ', 'R PAULO ALVES DA SILVA', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('69.093-262', '156      ', 'R PAULO CESAR (M SINAI)', 'COL S ANTONIO                 ');
INSERT INTO cd_cep_br VALUES ('69.078-680', '156      ', 'R PAULO GILBERTO', 'JAPIIM                        ');
INSERT INTO cd_cep_br VALUES ('69.082-644', '156      ', 'R PAULO JACOB (PRQ M CASTELO)', 'COROADO                       ');
INSERT INTO cd_cep_br VALUES ('69.082-590', '156      ', 'R PAULO JACOB FILHO (O VERDE)', 'COROADO                       ');
INSERT INTO cd_cep_br VALUES ('69.049-101', '156      ', 'BC PAULO LASMAR', 'PAZ                           ');
INSERT INTO cd_cep_br VALUES ('69.063-500', '156      ', 'R PAULO MARINHO', 'PETROPOLIS                    ');
INSERT INTO cd_cep_br VALUES ('69.033-740', '156      ', 'TV PAULO MOURAO', 'S JORGE                       ');
INSERT INTO cd_cep_br VALUES ('69.042-740', '156      ', 'R PAULO PAIVA (PRQ R JERUSALEM)', 'D PEDRO                       ');
INSERT INTO cd_cep_br VALUES ('69.099-093', '156      ', 'R PAULO SARMENTO(A. MENDES)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.063-710', '156      ', 'CJ PAULO VI', 'PETROPOLIS                    ');
INSERT INTO cd_cep_br VALUES ('69.067-391', '156      ', 'BC PAULO VI', 'PETROPOLIS                    ');
INSERT INTO cd_cep_br VALUES ('69.067-390', '156      ', 'AV PAULO VI (CJ JD PETROPOLIS)', 'PETROPOLIS                    ');
INSERT INTO cd_cep_br VALUES ('69.040-320', '156      ', 'R PAUS ROSAS, DOS(CJ KYSSIA)', 'D PEDRO                       ');
INSERT INTO cd_cep_br VALUES ('69.067-621', '156      ', 'R PAVAO (VLE AMANHECER)', 'PETROPOLIS                    ');
INSERT INTO cd_cep_br VALUES ('69.008-200', '156      ', 'R PAVILHAO, DO', 'COL A ALEIXO                  ');
INSERT INTO cd_cep_br VALUES ('69.096-030', '156      ', 'R PAXIUBA (CJ C NOVA)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.040-330', '156      ', 'R PAXIUBAS, DAS(CJ KYSSIA)', 'D PEDRO                       ');
INSERT INTO cd_cep_br VALUES ('69.067-517', '156      ', 'BC PAZ DA(SAO SEBASTIAO)', 'PETROPOLIS                    ');
INSERT INTO cd_cep_br VALUES ('69.030-541', '156      ', 'TV PARAGUACU', 'VL PRATA                      ');
INSERT INTO cd_cep_br VALUES ('69.086-635', '156      ', 'R PARAGUACU', 'S J OPERARIO                  ');
INSERT INTO cd_cep_br VALUES ('69.067-629', '156      ', 'R PARAGUACU (VLE AMANHECER)', 'PETROPOLIS                    ');
INSERT INTO cd_cep_br VALUES ('69.037-200', '156      ', 'AL PARAGUAI (CJ JD AMERICA)', 'P NEGRA                       ');
INSERT INTO cd_cep_br VALUES ('69.080-610', '156      ', 'R PARAIBA', 'COROADO                       ');
INSERT INTO cd_cep_br VALUES ('69.086-631', '156      ', 'R PARAIBA', 'S J OPERARIO                  ');
INSERT INTO cd_cep_br VALUES ('69.057-020', '156      ', 'R PARAIBA- ATE 0848/0885', 'ADRIANOPOLIS                  ');
INSERT INTO cd_cep_br VALUES ('69.057-021', '156      ', 'R PARAIBA- DE 0850/0887 A 1312/2201', 'ADRIANOPOLIS                  ');
INSERT INTO cd_cep_br VALUES ('69.055-700', '156      ', 'R PARAIBA- DE 1314/2203 AO FIM', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.058-470', '156      ', 'R PARAIBA (PRQ LARANJEIRAS)', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('69.036-021', '156      ', 'BC PARAISO', 'COMPENSA                      ');
INSERT INTO cd_cep_br VALUES ('69.036-020', '156      ', 'R PARAISO', 'COMPENSA                      ');
INSERT INTO cd_cep_br VALUES ('69.036-022', '156      ', 'TV PARAISO', 'COMPENSA                      ');
INSERT INTO cd_cep_br VALUES ('69.074-764', '156      ', 'R PARAISO', 'MRO LIBERDADE                 ');
INSERT INTO cd_cep_br VALUES ('69.033-190', '156      ', 'R PARAISO', 'S JORGE                       ');
INSERT INTO cd_cep_br VALUES ('69.075-370', '156      ', 'R PARAISO', 'MAUAZINHO                     ');
INSERT INTO cd_cep_br VALUES ('69.037-550', '156      ', 'R PARAISO', 'N ESPERANCA                   ');
INSERT INTO cd_cep_br VALUES ('69.048-220', '156      ', 'R PARAISO', 'PAZ                           ');
INSERT INTO cd_cep_br VALUES ('69.087-401', '156      ', 'R PARAISO', 'T NEVES                       ');
INSERT INTO cd_cep_br VALUES ('69.075-372', '156      ', 'BC PARAISO', 'MAUAZINHO                     ');
INSERT INTO cd_cep_br VALUES ('69.087-631', '156      ', 'R PARAISO (N REINO)', 'T NEVES                       ');
INSERT INTO cd_cep_br VALUES ('69.075-381', '156      ', 'R PARAISO DO EDEM', 'MAUAZINHO                     ');
INSERT INTO cd_cep_br VALUES ('69.045-510', '156      ', 'R PARAMARIBO (CJ C ELISIOS)', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('69.053-161', '156      ', 'R PARANA', 'N S GRACAS                    ');
INSERT INTO cd_cep_br VALUES ('69.058-540', '156      ', 'R PARANA (PRQ LARANJEIRAS)', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('69.090-040', '156      ', 'R PARANA MIRIM (CJ C NOVA)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.038-200', '156      ', 'R PARANAPANEMA', 'L VALE                        ');
INSERT INTO cd_cep_br VALUES ('69.074-160', '156      ', 'EST PAREDAO', 'COL O MACHADO                 ');
INSERT INTO cd_cep_br VALUES ('69.060-700', '156      ', 'R PARINTINS', 'ALEIXO                        ');
INSERT INTO cd_cep_br VALUES ('69.065-050', '156      ', 'R PARINTINS', 'CACHOEIRINHA                  ');
INSERT INTO cd_cep_br VALUES ('69.060-701', '156      ', 'BC PARINTINS', 'ALEIXO                        ');
INSERT INTO cd_cep_br VALUES ('69.065-054', '156      ', 'BC PARINTINS', 'CACHOEIRINHA                  ');
INSERT INTO cd_cep_br VALUES ('69.029-400', '156      ', 'R MARISAL, DO', 'S ANTONIO                     ');
INSERT INTO cd_cep_br VALUES ('69.037-840', '156      ', 'R MARIVALDO PEREIRA', 'N ESPERANCA                   ');
INSERT INTO cd_cep_br VALUES ('69.063-518', '156      ', 'BC MARIZA MENDES', 'PETROPOLIS                    ');
INSERT INTO cd_cep_br VALUES ('69.050-150', '156      ', 'R MAROMBA', 'CHAPADA                       ');
INSERT INTO cd_cep_br VALUES ('69.058-031', '156      ', 'AV MARQUES DE ABRANTES', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('69.058-140', '156      ', 'R MARQUES DE AURITUBA (PRQ LARANJEIRAS)', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('69.058-130', '156      ', 'R MARQUES DE BAEPENDI (PRQ LARANJEIRAS)', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('69.058-010', '156      ', 'R MARQUES DE CARAVELAS (PRQ LARANJEIRAS)', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('69.058-020', '156      ', 'R MARQUES DE ERVAL (PRQ LARANJEIRAS)', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('69.058-030', '156      ', 'AV MARQUES DE INHAMBUPE (PRQ LARANJEIRAS)', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('69.058-040', '156      ', 'R MARQUES DE MONTE ALEGRE (PRQ LARANJEIRAS)', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('69.058-550', '156      ', 'R MARQUES DE PARANAGUA (PRQ LARANJEIRAS)', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('69.058-050', '156      ', 'R MARQUES DE QUIXERAMOBIM (PRQ LARANJEIRAS)', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('69.005-050', '156      ', 'R MARQUES DE SANTA CRUZ', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('69.058-560', '156      ', 'R MARQUES DE SANTO AMARO (PRQ LARANJEIRAS)', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('69.058-570', '156      ', 'R MARQUES DE SAPUCAIA (PRQ LARANJEIRAS)', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('69.058-150', '156      ', 'R MARQUES DE TAGUATIRA (PRQ LARANJEIRAS)', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('69.058-580', '156      ', 'AV MARQUES DE TAMANDARE (PRQ LARANJEIRAS)', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('69.047-481', '156      ', 'R MARACANA', 'REDENCAO                      ');
INSERT INTO cd_cep_br VALUES ('69.090-230', '156      ', 'R MARACUJA (CJ C NOVA)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.093-053', '156      ', 'R MARAJOARA(T. NOVA II)', 'COL T NOVA                    ');
INSERT INTO cd_cep_br VALUES ('69.081-240', '156      ', 'R MARAMBA', 'J TEIXEIRA                    ');
INSERT INTO cd_cep_br VALUES ('69.088-290', '156      ', 'R MARANATA', 'J TEIXEIRA                    ');
INSERT INTO cd_cep_br VALUES ('69.067-770', '156      ', 'R MARANATA (N JERUSALEM)', 'PETROPOLIS                    ');
INSERT INTO cd_cep_br VALUES ('69.058-500', '156      ', 'R MARANHAO (PRQ LARANJEIRAS)', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('69.040-510', '156      ', 'R MARAPANI (CJ DEBORAH)', 'D PEDRO                       ');
INSERT INTO cd_cep_br VALUES ('69.075-841', '156      ', 'R MARAPATA, DO', 'DT INDUSTRIAL                 ');
INSERT INTO cd_cep_br VALUES ('69.081-480', '156      ', 'R MARATINGA', 'J TEIXEIRA                    ');
INSERT INTO cd_cep_br VALUES ('69.068-660', '156      ', 'R MARCAL', 'RAIZ                          ');
INSERT INTO cd_cep_br VALUES ('69.082-511', '156      ', 'R MARCELO DIAS', 'COROADO                       ');
INSERT INTO cd_cep_br VALUES ('69.084-624', '156      ', 'R MARCELO SANTOS', 'Z PALMARES                    ');
INSERT INTO cd_cep_br VALUES ('69.084-628', '156      ', 'BC MARCELO SANTOS', 'Z PALMARES                    ');
INSERT INTO cd_cep_br VALUES ('69.059-120', '156      ', 'R MARCIA TAVARES', 'S ETELVINA                    ');
INSERT INTO cd_cep_br VALUES ('69.079-130', '156      ', 'R MARCIANO', 'S FRANCISCO                   ');
INSERT INTO cd_cep_br VALUES ('69.005-270', '156      ', 'R MARCILIO DIAS', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('69.082-540', '156      ', 'R MARCILIO DIAS (O VERDE)', 'COROADO                       ');
INSERT INTO cd_cep_br VALUES ('69.079-340', '156      ', 'R MARCOS DA SILVEIRA', 'S FRANCISCO                   ');
INSERT INTO cd_cep_br VALUES ('69.029-160', '156      ', 'R MARECHAL BITENCOURT', 'S ANTONIO                     ');
INSERT INTO cd_cep_br VALUES ('69.005-000', '156      ', 'R MARECHAL DEODORO', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('69.070-840', '156      ', 'R MARECHAL DEODORO', 'COL O MACHADO                 ');
INSERT INTO cd_cep_br VALUES ('69.080-640', '156      ', 'R MARECHAL DEODORO', 'COROADO                       ');
INSERT INTO cd_cep_br VALUES ('69.039-107', '156      ', 'R MARECHAL HERMES', 'N ISRAEL                      ');
INSERT INTO cd_cep_br VALUES ('69.040-050', '156      ', 'R MARECHAL HERMES DA FONSECA (CJ D PEDRO I)', 'D PEDRO                       ');
INSERT INTO cd_cep_br VALUES ('69.084-415', '156      ', 'R MARECHAL RODON', 'Z PALMARES                    ');
INSERT INTO cd_cep_br VALUES ('69.043-371', '156      ', 'BC MARECHAL RONDON', 'ALVORADA                      ');
INSERT INTO cd_cep_br VALUES ('69.033-490', '156      ', 'R MARECHAL RONDON', 'S JORGE                       ');
INSERT INTO cd_cep_br VALUES ('69.082-760', '156      ', 'R MARECHAL RONDON', 'COROADO                       ');
INSERT INTO cd_cep_br VALUES ('69.037-650', '156      ', 'BC MARGARIDA', 'L VALE                        ');
INSERT INTO cd_cep_br VALUES ('69.087-140', '156      ', 'R MARGARIDA', 'T NEVES                       ');
INSERT INTO cd_cep_br VALUES ('69.093-056', '156      ', 'TV MARGARIDA(T. NOVA II)', 'COL T NOVA                    ');
INSERT INTO cd_cep_br VALUES ('69.084-590', '156      ', 'R MARGARIDA ALVES', 'Z PALMARES                    ');
INSERT INTO cd_cep_br VALUES ('69.088-621', '156      ', 'R MARGARIDAS, DAS', 'J TEIXEIRA                    ');
INSERT INTO cd_cep_br VALUES ('69.083-280', '156      ', 'R MARGARIDAS, DAS(CJ TIRADENTES)', 'ALEIXO                        ');
INSERT INTO cd_cep_br VALUES ('69.086-000', '156      ', 'R MARGINAL', 'S J OPERARIO                  ');
INSERT INTO cd_cep_br VALUES ('69.067-350', '156      ', 'AV MARGINAL (CJ JD PETROPOLIS)', 'PETROPOLIS                    ');
INSERT INTO cd_cep_br VALUES ('69.054-310', '156      ', 'CJ MALIBU', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.088-280', '156      ', 'R MALVACEAS, DAS', 'J TEIXEIRA                    ');
INSERT INTO cd_cep_br VALUES ('69.080-581', '156      ', 'BC MALVINA', 'COROADO                       ');
INSERT INTO cd_cep_br VALUES ('69.074-280', '156      ', 'R MAMORI (VL MILITAR PONTA PELADA)', 'S LAZARO                      ');
INSERT INTO cd_cep_br VALUES ('69.093-495', '156      ', 'R MANACAPURU(T. NOVA I)', 'COL T NOVA                    ');
INSERT INTO cd_cep_br VALUES ('69.074-290', '156      ', 'R MANACAPURU (VL MILITAR PONTA PELADA)', 'S LAZARO                      ');
INSERT INTO cd_cep_br VALUES ('69.038-076', '156      ', 'BC MANAUARA', 'L VALE                        ');
INSERT INTO cd_cep_br VALUES ('69.036-160', '156      ', 'R MANAUS', 'COMPENSA                      ');
INSERT INTO cd_cep_br VALUES ('69.082-190', '156      ', 'R MANAUS', 'COROADO                       ');
INSERT INTO cd_cep_br VALUES ('69.037-790', '156      ', 'TV MANAUS', 'L VALE                        ');
INSERT INTO cd_cep_br VALUES ('69.036-161', '156      ', 'BC MANAUS', 'COMPENSA                      ');
INSERT INTO cd_cep_br VALUES ('69.093-493', '156      ', 'R MANAUS(T. NOVA I)', 'COL T NOVA                    ');
INSERT INTO cd_cep_br VALUES ('69.076-448', '156      ', 'AV MANAUS DOIS MIL', 'JAPIIM                        ');
INSERT INTO cd_cep_br VALUES ('69.081-380', '156      ', 'R MANDI I', 'J TEIXEIRA                    ');
INSERT INTO cd_cep_br VALUES ('69.075-140', '156      ', 'AV MANDII', 'DT INDUSTRIAL                 ');
INSERT INTO cd_cep_br VALUES ('69.088-500', '156      ', 'R MANGUEIRAS, DAS', 'J TEIXEIRA                    ');
INSERT INTO cd_cep_br VALUES ('69.065-100', '156      ', 'AV MANICORE', 'CACHOEIRINHA                  ');
INSERT INTO cd_cep_br VALUES ('69.065-210', '156      ', 'R MANICORE', 'CACHOEIRINHA                  ');
INSERT INTO cd_cep_br VALUES ('69.035-700', '156      ', 'R MANICORE', 'COMPENSA                      ');
INSERT INTO cd_cep_br VALUES ('69.045-460', '156      ', 'R MANILA (CJ C ELISIOS)', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('69.044-027', '156      ', 'R MANJIRONA (CJ FLAMANAL)', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('69.042-500', '156      ', 'AV MANOEL BORBA GATO (CJ D PEDRO I)', 'D PEDRO                       ');
INSERT INTO cd_cep_br VALUES ('69.010-540', '156      ', 'VL MANOEL CARVALHO', 'APARECIDA                     ');
INSERT INTO cd_cep_br VALUES ('69.042-730', '156      ', 'R MANOEL DIZ (PRQ R JERUSALEM)', 'D PEDRO                       ');
INSERT INTO cd_cep_br VALUES ('69.036-300', '156      ', 'R MANOEL JEFFERSON (CJ R XINGU)', 'COMPENSA                      ');
INSERT INTO cd_cep_br VALUES ('69.036-310', '156      ', 'R MANOEL ORTIZ (CJ R XINGU)', 'COMPENSA                      ');
INSERT INTO cd_cep_br VALUES ('69.075-352', '156      ', 'R MANOEL RIBEIRO', 'MAUAZINHO                     ');
INSERT INTO cd_cep_br VALUES ('69.087-590', '156      ', 'R MANOEL RIBEIRO', 'T NEVES                       ');
INSERT INTO cd_cep_br VALUES ('69.048-325', '156      ', 'R MANOEL SIMPLICIO DUARTE (CJ JURUA)', 'ALVORADA                      ');
INSERT INTO cd_cep_br VALUES ('69.082-491', '156      ', 'R MANOEL TAVARES(CJ O VERDE)', 'COROADO                       ');
INSERT INTO cd_cep_br VALUES ('69.070-110', '156      ', 'BC MANOEL URBANO', 'EDUCANDOS                     ');
INSERT INTO cd_cep_br VALUES ('69.070-120', '156      ', 'R MANOEL URBANO', 'EDUCANDOS                     ');
INSERT INTO cd_cep_br VALUES ('69.067-441', '156      ', 'R MANU (S SEBASTIAO)', 'PETROPOLIS                    ');
INSERT INTO cd_cep_br VALUES ('69.082-530', '156      ', 'R MANUEL MULCO (O VERDE)', 'COROADO                       ');
INSERT INTO cd_cep_br VALUES ('69.095-140', '156      ', 'R MAORUNA (CJ C NOVA)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.088-521', '156      ', 'R MAPARA', 'J TEIXEIRA                    ');
INSERT INTO cd_cep_br VALUES ('69.093-088', '156      ', 'R MAPUEIRA(T. NOVA II)', 'COL T NOVA                    ');
INSERT INTO cd_cep_br VALUES ('69.040-500', '156      ', 'R MARABA (CJ DEBORAH)', 'D PEDRO                       ');
INSERT INTO cd_cep_br VALUES ('69.043-420', '156      ', 'R M (CJ DE FLORES II)', 'ALVORADA                      ');
INSERT INTO cd_cep_br VALUES ('69.050-270', '156      ', 'R M (CJ ELDORADO)', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.030-360', '156      ', 'R M (CJ IPASE)', 'COMPENSA                      ');
INSERT INTO cd_cep_br VALUES ('69.053-741', '156      ', 'Q M (CJ MANAUENSE)', 'N S GRACAS                    ');
INSERT INTO cd_cep_br VALUES ('69.095-550', '156      ', 'R M (CJ R JUNIOR)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.040-280', '156      ', 'R JOAO BOSCO (CJ KYSSIA)', 'D PEDRO                       ');
INSERT INTO cd_cep_br VALUES ('69.095-174', '156      ', 'R JOAO BOSCO (RIACHO DOCE)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.084-390', '156      ', 'R JOAO BOSCO BURNIER', 'Z PALMARES                    ');
INSERT INTO cd_cep_br VALUES ('69.077-011', '156      ', 'EST JAPIIM', 'JAPIIM                        ');
INSERT INTO cd_cep_br VALUES ('69.068-280', '156      ', 'R JOAO CONRADO', 'RAIZ                          ');
INSERT INTO cd_cep_br VALUES ('69.079-110', '156      ', 'R JOAO DA MATA', 'S FRANCISCO                   ');
INSERT INTO cd_cep_br VALUES ('69.027-131', '156      ', 'BC JOAO DA MATA', 'S RAIMUNDO                    ');
INSERT INTO cd_cep_br VALUES ('69.027-130', '156      ', 'R JOAO DA MATA', 'S RAIMUNDO                    ');
INSERT INTO cd_cep_br VALUES ('69.008-230', '156      ', 'R JOAO DE PAULA', 'COL A ALEIXO                  ');
INSERT INTO cd_cep_br VALUES ('69.027-730', '156      ', 'R JOAO DE SOUZA CATUNDA', 'GLORIA                        ');
INSERT INTO cd_cep_br VALUES ('69.068-550', '156      ', 'R JOAO DIAS', 'RAIZ                          ');
INSERT INTO cd_cep_br VALUES ('69.085-130', '156      ', 'R JOAO DO NASCIMENTO MARQUES', 'S J OPERARIO                  ');
INSERT INTO cd_cep_br VALUES ('69.068-650', '156      ', 'R JOAO DO PULO', 'RAIZ                          ');
INSERT INTO cd_cep_br VALUES ('69.098-198', '156      ', 'R JOAO DOURADO(N. ALEIXO)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.082-780', '156      ', 'R JOAO MEIRELES', 'COROADO                       ');
INSERT INTO cd_cep_br VALUES ('69.063-490', '156      ', 'R JOAO MENDONCA', 'PETROPOLIS                    ');
INSERT INTO cd_cep_br VALUES ('69.054-551', '156      ', 'TV JOAO NILO MENEGUINI', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('69.073-550', '156      ', 'R JOAO PESSOA', 'BETANIA                       ');
INSERT INTO cd_cep_br VALUES ('69.073-551', '156      ', 'TV JOAO PESSOA', 'BETANIA                       ');
INSERT INTO cd_cep_br VALUES ('69.027-700', '156      ', 'R JOAO REBOUCAS', 'S RAIMUNDO                    ');
INSERT INTO cd_cep_br VALUES ('69.063-451', '156      ', 'BC JOAO SAMBA', 'PETROPOLIS                    ');
INSERT INTO cd_cep_br VALUES ('69.053-140', '156      ', 'R JOAO VALERIO', 'N S GRACAS                    ');
INSERT INTO cd_cep_br VALUES ('69.079-220', '156      ', 'BC JOAO VEIGA', 'S FRANCISCO                   ');
INSERT INTO cd_cep_br VALUES ('13.089-030', '4802     ', 'R BERLIM', 'PRQ S QUIRINO                 ');
INSERT INTO cd_cep_br VALUES ('69.027-330', '156      ', 'BC JOAO VEIGA', 'S RAIMUNDO                    ');
INSERT INTO cd_cep_br VALUES ('69.035-500', '156      ', 'R JOAO WALTER', 'COMPENSA                      ');
INSERT INTO cd_cep_br VALUES ('69.082-170', '156      ', 'R JOAO WALTER', 'COROADO                       ');
INSERT INTO cd_cep_br VALUES ('69.044-200', '156      ', 'R JOAQUIM CARNEIRO DA MOTA (CJ BELVEDERE)', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('69.044-190', '156      ', 'R JOAQUIM CRUZ PONTES (CJ BELVEDERE)', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('69.048-720', '156      ', 'R JARI (CJ DQ CAXIAS)', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('69.098-122', '156      ', 'TV JARINU(A. CLARAS)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.098-086', '156      ', 'R JARIRA(A. CLARAS)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.028-391', '156      ', 'R JARUPARIBEIJA FLOR', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('69.087-090', '156      ', 'R JASMIM', 'T NEVES                       ');
INSERT INTO cd_cep_br VALUES ('69.059-290', '156      ', 'R JASMIM', 'S ETELVINA                    ');
INSERT INTO cd_cep_br VALUES ('69.088-570', '156      ', 'R JASMIM', 'J TEIXEIRA                    ');
INSERT INTO cd_cep_br VALUES ('69.059-293', '156      ', 'BC JASMIM', 'S ETELVINA                    ');
INSERT INTO cd_cep_br VALUES ('69.044-026', '156      ', 'R JASMIM (CJ FLAMANAL)', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('69.083-260', '156      ', 'R JASMINS, DOS(CJ TIRADENTES)', 'ALEIXO                        ');
INSERT INTO cd_cep_br VALUES ('69.098-068', '156      ', 'TV JATAI(A. CLARAS)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.098-116', '156      ', 'R JATAIZINHO(A. CLARAS)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.093-157', '156      ', 'R JATAUBA BRANCA(M.OLIVEIRAS)', 'MTE OLIVEIRAS                 ');
INSERT INTO cd_cep_br VALUES ('69.098-104', '156      ', 'TV JATEI(A. CLARAS)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.053-272', '156      ', 'BC JATOBA', 'S GERALDO                     ');
INSERT INTO cd_cep_br VALUES ('69.085-380', '156      ', 'R JATOBAS, DOS(PRQ ACARIQUARA)', 'COROADO                       ');
INSERT INTO cd_cep_br VALUES ('69.098-222', '156      ', 'R JATUBA(N. ALEIXO)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.054-690', '156      ', 'CJ JAUAPERY', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.093-175', '156      ', 'R JAUARA', 'COL S ANTONIO                 ');
INSERT INTO cd_cep_br VALUES ('69.093-109', '156      ', 'R JAUARICI(M. OLIVEIRAS)', 'MTE OLIVEIRAS                 ');
INSERT INTO cd_cep_br VALUES ('69.075-110', '156      ', 'R JAVARI', 'DT INDUSTRIAL                 ');
INSERT INTO cd_cep_br VALUES ('69.048-330', '156      ', 'CON JAVARI', 'ALVORADA                      ');
INSERT INTO cd_cep_br VALUES ('69.057-511', '156      ', 'BC JAVARI', 'ADRIANOPOLIS                  ');
INSERT INTO cd_cep_br VALUES ('69.098-128', '156      ', 'R JEQUIA(A. CLARAS)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.039-470', '156      ', 'R JERICO', 'N ISRAEL                      ');
INSERT INTO cd_cep_br VALUES ('69.093-116', '156      ', 'R JERIVA(M.OLIVEIRAS)', 'MTE OLIVEIRAS                 ');
INSERT INTO cd_cep_br VALUES ('69.040-470', '156      ', 'R JERONIMO DE ALBUQUERQUE (CJ D PEDRO II)', 'D PEDRO                       ');
INSERT INTO cd_cep_br VALUES ('69.098-228', '156      ', 'R JERONIMO MONTEIRO(N. ALEIXO)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.027-100', '156      ', 'R JERONIMO RIBEIRO', 'S RAIMUNDO                    ');
INSERT INTO cd_cep_br VALUES ('69.082-140', '156      ', 'BC JERUSALEM', 'COROADO                       ');
INSERT INTO cd_cep_br VALUES ('69.082-150', '156      ', 'R JERUSALEM', 'COROADO                       ');
INSERT INTO cd_cep_br VALUES ('69.068-530', '156      ', 'R JERUSALEM', 'RAIZ                          ');
INSERT INTO cd_cep_br VALUES ('69.075-320', '156      ', 'R JERUSALEM', 'MAUAZINHO                     ');
INSERT INTO cd_cep_br VALUES ('69.039-710', '156      ', 'AV JERUSALEM', 'N ISRAEL                      ');
INSERT INTO cd_cep_br VALUES ('69.099-354', '156      ', 'R JERUSALEM(N. S. FATIMA)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.042-710', '156      ', 'R JERUSALEM (PRQ R JERUSALEM)', 'D PEDRO                       ');
INSERT INTO cd_cep_br VALUES ('69.039-030', '156      ', 'R JESUS DE NAZARE', 'N ISRAEL                      ');
INSERT INTO cd_cep_br VALUES ('69.074-830', '156      ', 'BC JOANA D ARC', 'MRO LIBERDADE                 ');
INSERT INTO cd_cep_br VALUES ('69.098-124', '156      ', 'TV JAIMES(A. CLARAS)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.098-136', '156      ', 'R JAMBEIROA(A. CLARAS)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.059-090', '156      ', 'R JAMBO', 'S ETELVINA                    ');
INSERT INTO cd_cep_br VALUES ('69.090-330', '156      ', 'R JAMBO (CJ C NOVA)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.087-633', '156      ', 'R JANAINA (N REINO)', 'T NEVES                       ');
INSERT INTO cd_cep_br VALUES ('69.085-240', '156      ', 'R JANAUACA, DO', 'S J OPERARIO                  ');
INSERT INTO cd_cep_br VALUES ('69.075-311', '156      ', 'R JANDAIA', 'MAUAZINHO                     ');
INSERT INTO cd_cep_br VALUES ('69.073-484', '156      ', 'R JANES SUELY', 'CRESPO                        ');
INSERT INTO cd_cep_br VALUES ('69.063-182', '156      ', 'VL JANIO', 'S FRANCISCO                   ');
INSERT INTO cd_cep_br VALUES ('69.098-118', '156      ', 'R JANIOPOLIS(A. CLARAS)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.028-150', '156      ', 'R JAPAO (PRQ NACOES)', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('69.025-020', '156      ', 'AV JAPURA- ATE 593/664', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('69.020-180', '156      ', 'AV JAPURA- DE 595/666 AO FIM', 'PC 14 JANEIRO                 ');
INSERT INTO cd_cep_br VALUES ('69.098-088', '156      ', 'TV JAQUARAO(A. CLARAS)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.093-125', '156      ', 'R JAQUETIBA(M.OLIVEIRAS)', 'MTE OLIVEIRAS                 ');
INSERT INTO cd_cep_br VALUES ('69.093-127', '156      ', 'R JARANA(M.OLIVEIRAS)', 'MTE OLIVEIRAS                 ');
INSERT INTO cd_cep_br VALUES ('69.085-370', '156      ', 'R JARANAS, DAS(PRQ ACARIQUARA)', 'COROADO                       ');
INSERT INTO cd_cep_br VALUES ('69.082-130', '156      ', 'TV JARAQUI', 'COROADO                       ');
INSERT INTO cd_cep_br VALUES ('69.088-260', '156      ', 'R JARAQUI', 'J TEIXEIRA                    ');
INSERT INTO cd_cep_br VALUES ('69.039-580', '156      ', 'R JARARACA', 'N ISRAEL                      ');
INSERT INTO cd_cep_br VALUES ('69.098-108', '156      ', 'R JARDIM ALEGRE(A. CLARAS)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.098-106', '156      ', 'R JARDIM AMERICA(A. CLARAS)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.033-100', '156      ', 'R JARDIM BOTANICO', 'S JORGE                       ');
INSERT INTO cd_cep_br VALUES ('69.068-060', '156      ', 'CJ JARDIM BRASIL', 'RAIZ                          ');
INSERT INTO cd_cep_br VALUES ('69.039-520', '156      ', 'R JARDIM DO EDEM', 'N ISRAEL                      ');
INSERT INTO cd_cep_br VALUES ('69.043-001', '156      ', 'CJ JARDIM DO EDEM', 'ALVORADA                      ');
INSERT INTO cd_cep_br VALUES ('69.033-570', '156      ', 'R JARDIM DOS BARES', 'S JORGE                       ');
INSERT INTO cd_cep_br VALUES ('69.060-530', '156      ', 'CJ JARDIM ESPANHA I', 'ADRIANOPOLIS                  ');
INSERT INTO cd_cep_br VALUES ('69.060-540', '156      ', 'CJ JARDIM ESPANHA II', 'ADRIANOPOLIS                  ');
INSERT INTO cd_cep_br VALUES ('69.060-550', '156      ', 'CJ JARDIM ESPANHA III', 'ADRIANOPOLIS                  ');
INSERT INTO cd_cep_br VALUES ('69.055-170', '156      ', 'CJ JARDIM ITALIA', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.057-370', '156      ', 'CJ JARDIM ITAOCA', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.098-112', '156      ', 'R JARDIM OLINDA(A. CLARAS)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.060-250', '156      ', 'R JARDIM PAULISTA', 'ALEIXO                        ');
INSERT INTO cd_cep_br VALUES ('69.060-790', '156      ', 'CJ JARDIM VENEZA', 'ALEIXO                        ');
INSERT INTO cd_cep_br VALUES ('69.060-580', '156      ', 'CJ JARDIM VILA RICA', 'ALEIXO                        ');
INSERT INTO cd_cep_br VALUES ('69.098-114', '156      ', 'R JARDINOPOLIS(A. CLARAS)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.036-571', '156      ', 'BC NOVA OLINDA', 'COMPENSA                      ');
INSERT INTO cd_cep_br VALUES ('69.067-360', '156      ', 'R NOVA OLINDA (CJ JD PETROPOLIS)', 'PETROPOLIS                    ');
INSERT INTO cd_cep_br VALUES ('69.082-700', '156      ', 'R NOVA OLINDA (COND O NEGRO)', 'COROADO                       ');
INSERT INTO cd_cep_br VALUES ('69.075-800', '156      ', 'R NOVA REPUBLICA', 'S LAZARO                      ');
INSERT INTO cd_cep_br VALUES ('69.068-661', '156      ', 'BC NOVA REPUBLICA', 'RAIZ                          ');
INSERT INTO cd_cep_br VALUES ('69.008-030', '156      ', 'R NOVA REPUBLICA', 'COL A ALEIXO                  ');
INSERT INTO cd_cep_br VALUES ('69.075-362', '156      ', 'BC NOVA REPUBLICA', 'MAUAZINHO                     ');
INSERT INTO cd_cep_br VALUES ('69.075-276', '156      ', 'R NOVA REPUBLICA', 'MAUAZINHO                     ');
INSERT INTO cd_cep_br VALUES ('69.082-210', '156      ', 'BC NOVA VIDA', 'COROADO                       ');
INSERT INTO cd_cep_br VALUES ('69.098-761', '156      ', 'TV NOVE(A. MENDES)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.028-147', '156      ', 'TV NOVESANTA CRUZ', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('69.033-821', '156      ', 'R NOVE DE ABRIL', 'S JORGE                       ');
INSERT INTO cd_cep_br VALUES ('69.073-132', '156      ', 'BC NOVE DE MAIO', 'S LAZARO                      ');
INSERT INTO cd_cep_br VALUES ('69.073-130', '156      ', 'R NOVE DE MAIO', 'S LAZARO                      ');
INSERT INTO cd_cep_br VALUES ('69.005-380', '156      ', 'PC NOVE DE NOVEMBRO', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('69.035-352', '156      ', 'BC NOVIDADE', 'COMPENSA                      ');
INSERT INTO cd_cep_br VALUES ('69.076-466', '156      ', 'TV NOVO ARIPUANA', 'JAPIIM                        ');
INSERT INTO cd_cep_br VALUES ('69.075-780', '156      ', 'BC NOVO BRASIL', 'MAUAZINHO                     ');
INSERT INTO cd_cep_br VALUES ('69.054-640', '156      ', 'CJ NOVO HORIZONTE', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('69.075-470', '156      ', 'R NOVO HORIZONTE', 'MAUAZINHO                     ');
INSERT INTO cd_cep_br VALUES ('69.099-005', '156      ', 'R NOVO ISRAEL(N. S. FATIMA)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.042-780', '156      ', 'R NOVO PARAISO', 'N ESPERANCA                   ');
INSERT INTO cd_cep_br VALUES ('69.089-184', '156      ', 'TV NP', 'A MENDES                      ');
INSERT INTO cd_cep_br VALUES ('69.079-250', '156      ', 'R NUNES CARDOSO', 'S FRANCISCO                   ');
INSERT INTO cd_cep_br VALUES ('69.063-101', '156      ', 'R NUNO CARDOSO', 'S FRANCISCO                   ');
INSERT INTO cd_cep_br VALUES ('69.059-430', '156      ', 'R NOSSA SENHORA DO PERPETUO SOCORRO', 'S ETELVINA                    ');
INSERT INTO cd_cep_br VALUES ('69.080-590', '156      ', 'BC NOSSA SENHORA MAE DE DEUS', 'COROADO                       ');
INSERT INTO cd_cep_br VALUES ('69.057-170', '156      ', 'R NOVA', 'ADRIANOPOLIS                  ');
INSERT INTO cd_cep_br VALUES ('69.043-350', '156      ', 'R NOVA', 'ALVORADA                      ');
INSERT INTO cd_cep_br VALUES ('69.035-381', '156      ', 'R NOVA', 'COMPENSA                      ');
INSERT INTO cd_cep_br VALUES ('69.080-600', '156      ', 'R NOVA', 'COROADO                       ');
INSERT INTO cd_cep_br VALUES ('69.070-200', '156      ', 'R NOVA', 'EDUCANDOS                     ');
INSERT INTO cd_cep_br VALUES ('69.067-060', '156      ', 'R NOVA', 'PETROPOLIS                    ');
INSERT INTO cd_cep_br VALUES ('69.067-071', '156      ', 'TV NOVA', 'PETROPOLIS                    ');
INSERT INTO cd_cep_br VALUES ('69.068-040', '156      ', 'R NOVA', 'RAIZ                          ');
INSERT INTO cd_cep_br VALUES ('69.073-140', '156      ', 'R NOVA', 'S LAZARO                      ');
INSERT INTO cd_cep_br VALUES ('69.027-141', '156      ', 'BC NOVA', 'S RAIMUNDO                    ');
INSERT INTO cd_cep_br VALUES ('69.027-140', '156      ', 'R NOVA', 'S RAIMUNDO                    ');
INSERT INTO cd_cep_br VALUES ('69.060-830', '156      ', 'R NOVA', 'ALEIXO                        ');
INSERT INTO cd_cep_br VALUES ('69.047-310', '156      ', 'R NOVA', 'REDENCAO                      ');
INSERT INTO cd_cep_br VALUES ('69.078-090', '156      ', 'R NOVA', 'JAPIIM                        ');
INSERT INTO cd_cep_br VALUES ('69.070-201', '156      ', 'BC NOVA', 'EDUCANDOS                     ');
INSERT INTO cd_cep_br VALUES ('69.035-380', '156      ', 'BC NOVA', 'COMPENSA                      ');
INSERT INTO cd_cep_br VALUES ('69.008-080', '156      ', 'R NOVA', 'COL A ALEIXO                  ');
INSERT INTO cd_cep_br VALUES ('69.036-532', '156      ', 'R NOVA', 'S AGOSTINHO                   ');
INSERT INTO cd_cep_br VALUES ('69.048-291', '156      ', 'R NOVA', 'PAZ                           ');
INSERT INTO cd_cep_br VALUES ('69.033-804', '156      ', 'R NOVA', 'S JORGE                       ');
INSERT INTO cd_cep_br VALUES ('69.068-042', '156      ', 'BC NOVA', 'RAIZ                          ');
INSERT INTO cd_cep_br VALUES ('12.903-650', '4897     ', 'R SETE', 'JD IGUATEMI                   ');
INSERT INTO cd_cep_br VALUES ('68.903-630', '131      ', 'R ARAXA, DO', 'JD EQUATORIAL                 ');
INSERT INTO cd_cep_br VALUES ('69.067-625', '156      ', 'R NOVA (VLE AMANHECER)', 'PETROPOLIS                    ');
INSERT INTO cd_cep_br VALUES ('69.078-360', '156      ', 'R NOVA AURORA', 'JAPIIM                        ');
INSERT INTO cd_cep_br VALUES ('69.037-560', '156      ', 'R NOVA AURORA', 'N ESPERANCA                   ');
INSERT INTO cd_cep_br VALUES ('69.078-721', '156      ', 'R NOVA BRASILIA', 'JAPIIM                        ');
INSERT INTO cd_cep_br VALUES ('69.045-720', '156      ', 'R NOVA DELHI (CJ C ELISIOS)', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('69.057-180', '156      ', 'BC NOVA ESPERANCA', 'ADRIANOPOLIS                  ');
INSERT INTO cd_cep_br VALUES ('69.042-510', '156      ', 'R NOVA ESPERANCA', 'D PEDRO                       ');
INSERT INTO cd_cep_br VALUES ('69.078-370', '156      ', 'R NOVA ESPERANCA', 'JAPIIM                        ');
INSERT INTO cd_cep_br VALUES ('69.074-761', '156      ', 'R NOVA ESPERANCA', 'MRO LIBERDADE                 ');
INSERT INTO cd_cep_br VALUES ('69.087-380', '156      ', 'R NOVA ESPERANCA', 'T NEVES                       ');
INSERT INTO cd_cep_br VALUES ('69.082-101', '156      ', 'BC NOVA ESPERANCA', 'COROADO                       ');
INSERT INTO cd_cep_br VALUES ('69.038-071', '156      ', 'TV NOVA ESPERANCA', 'N ESPERANCA                   ');
INSERT INTO cd_cep_br VALUES ('69.073-127', '156      ', 'R NOVA ESPERANCA', 'CRESPO                        ');
INSERT INTO cd_cep_br VALUES ('69.008-110', '156      ', 'R NOVA ESPERANCA', 'COL A ALEIXO                  ');
INSERT INTO cd_cep_br VALUES ('69.008-240', '156      ', 'BC NOVA ESPERANCA', 'COL A ALEIXO                  ');
INSERT INTO cd_cep_br VALUES ('69.090-000', '156      ', 'AV NOEL NUTELS-DE 0402/0403 A 0651/0652 (CJ C NOV', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.095-000', '156      ', 'AV NOEL NUTELS-DE 0653/0654 A 1000/1001 (CJ C NOV', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.096-000', '156      ', 'AV NOEL NUTELS-DE 1002/1003 AO FIM (CJ C NOVA)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.080-721', '156      ', 'BC NOEL ROSAS', 'COROADO                       ');
INSERT INTO cd_cep_br VALUES ('69.053-430', '156      ', 'BC NOGUEIRA', 'N S GRACAS                    ');
INSERT INTO cd_cep_br VALUES ('69.020-530', '156      ', 'BC NONATO', 'PC 14 JANEIRO                 ');
INSERT INTO cd_cep_br VALUES ('69.059-400', '156      ', 'R NONATO QUEIROS', 'S ETELVINA                    ');
INSERT INTO cd_cep_br VALUES ('69.082-570', '156      ', 'R NONATO TAVARES (O VERDE)', 'COROADO                       ');
INSERT INTO cd_cep_br VALUES ('69.078-110', '156      ', 'BC NORTE ELETRICA', 'JAPIIM                        ');
INSERT INTO cd_cep_br VALUES ('69.037-020', '156      ', 'AL NORUEGA (CJ JD EUROPA)', 'P NEGRA                       ');
INSERT INTO cd_cep_br VALUES ('69.028-050', '156      ', 'R NORUEGA (PRQ NACOES)', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('69.037-812', '156      ', 'BC NOSSA SENHORA APARECIDA', 'L VALE                        ');
INSERT INTO cd_cep_br VALUES ('69.025-090', '156      ', 'PC NOSSA SENHORA AUXILIADORA', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('69.070-830', '156      ', 'BC NOSSA SENHORA DA CONCEICAO', 'COL O MACHADO                 ');
INSERT INTO cd_cep_br VALUES ('69.074-150', '156      ', 'R NOSSA SENHORA DA CONCEICAO', 'COL O MACHADO                 ');
INSERT INTO cd_cep_br VALUES ('69.063-650', '156      ', 'R NOSSA SENHORA DA CONCEICAO', 'PETROPOLIS                    ');
INSERT INTO cd_cep_br VALUES ('69.087-370', '156      ', 'R NOSSA SENHORA DA CONCEICAO', 'T NEVES                       ');
INSERT INTO cd_cep_br VALUES ('69.067-460', '156      ', 'R NOSSA SENHORA DA CONCEICAO (S SEBASTIAO)', 'PETROPOLIS                    ');
INSERT INTO cd_cep_br VALUES ('69.057-520', '156      ', 'R NOSSA SENHORA DA CONSOLACAO', 'ADRIANOPOLIS                  ');
INSERT INTO cd_cep_br VALUES ('69.073-831', '156      ', 'R NOSSA SENHORA DAS GRACAS', 'BETANIA                       ');
INSERT INTO cd_cep_br VALUES ('69.038-210', '156      ', 'R NOSSA SENHORA DAS GRACAS', 'L VALE                        ');
INSERT INTO cd_cep_br VALUES ('69.068-590', '156      ', 'BC NOSSA SENHORA DAS GRACAS', 'RAIZ                          ');
INSERT INTO cd_cep_br VALUES ('69.048-170', '156      ', 'R NOSSA SENHORA DAS GRACAS', 'PAZ                           ');
INSERT INTO cd_cep_br VALUES ('69.073-123', '156      ', 'R NOSSA SENHORA DAS GRACAS', 'CRESPO                        ');
INSERT INTO cd_cep_br VALUES ('69.063-441', '156      ', 'BC NOSSA SENHORA DAS GRACAS', 'PETROPOLIS                    ');
INSERT INTO cd_cep_br VALUES ('69.093-483', '156      ', 'R NOSSA SENHORA DAS GRACAS(T. NOVA I)', 'COL T NOVA                    ');
INSERT INTO cd_cep_br VALUES ('69.078-250', '156      ', 'BC NOSSA SENHORA DE FATIMA', 'JAPIIM                        ');
INSERT INTO cd_cep_br VALUES ('69.033-440', '156      ', 'R NOSSA SENHORA DE FATIMA', 'S JORGE                       ');
INSERT INTO cd_cep_br VALUES ('69.037-500', '156      ', 'R NOSSA SENHORA DE FATIMA', 'N ESPERANCA                   ');
INSERT INTO cd_cep_br VALUES ('69.059-420', '156      ', 'R NOSSA SENHORA DE FATIMA', 'S ETELVINA                    ');
INSERT INTO cd_cep_br VALUES ('69.057-024', '156      ', 'CON NOSSA SENHORA DE FATIMA', 'ADRIANOPOLIS                  ');
INSERT INTO cd_cep_br VALUES ('69.093-421', '156      ', 'TV NOSSA SENHORA DE FATIMA(T. NOVA I)', 'COL T NOVA                    ');
INSERT INTO cd_cep_br VALUES ('69.093-427', '156      ', 'R NOSSA SENHORA DE FATIMA(T. NOVA I)', 'COL T NOVA                    ');
INSERT INTO cd_cep_br VALUES ('69.057-450', '156      ', 'PC NOSSA SENHORA DE NAZARE', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.036-120', '156      ', 'R NOSSA SENHORA DO CARMO', 'COMPENSA                      ');
INSERT INTO cd_cep_br VALUES ('69.028-280', '156      ', 'R NOSSA SENHORA DO CARMO', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('69.084-391', '156      ', 'R NOSSA SENHORA DO MONTE SERRAT', 'Z PALMARES                    ');
INSERT INTO cd_cep_br VALUES ('69.027-160', '156      ', 'BC NOSSA SENHORA DO PERPETUO SOCORRO', 'S RAIMUNDO                    ');
INSERT INTO cd_cep_br VALUES ('69.025-310', '156      ', 'R BOA SORTE', 'P VARGAS                      ');
INSERT INTO cd_cep_br VALUES ('69.075-270', '156      ', 'BC BOA SORTE', 'MAUAZINHO                     ');
INSERT INTO cd_cep_br VALUES ('69.088-070', '156      ', 'R BOA SORTE', 'J TEIXEIRA                    ');
INSERT INTO cd_cep_br VALUES ('69.087-310', '156      ', 'R BOA SORTE', 'T NEVES                       ');
INSERT INTO cd_cep_br VALUES ('69.067-602', '156      ', 'BC BOA SORTE', 'PETROPOLIS                    ');
INSERT INTO cd_cep_br VALUES ('69.093-423', '156      ', 'R BOA SORTE(T. NOVA I)', 'COL T NOVA                    ');
INSERT INTO cd_cep_br VALUES ('69.025-320', '156      ', 'BC BOA SORTE II', 'P VARGAS                      ');
INSERT INTO cd_cep_br VALUES ('69.025-330', '156      ', 'BC BOA SORTE III', 'P VARGAS                      ');
INSERT INTO cd_cep_br VALUES ('69.025-340', '156      ', 'BC BOA SORTE IV', 'P VARGAS                      ');
INSERT INTO cd_cep_br VALUES ('69.038-040', '156      ', 'BC BOA VENTURA', 'L VALE                        ');
INSERT INTO cd_cep_br VALUES ('69.080-060', '156      ', 'BC BOA VIDA', 'COROADO                       ');
INSERT INTO cd_cep_br VALUES ('69.080-070', '156      ', 'R BOA VIDA', 'COROADO                       ');
INSERT INTO cd_cep_br VALUES ('69.038-240', '156      ', 'R BOA VISTA', 'L VALE                        ');
INSERT INTO cd_cep_br VALUES ('69.038-241', '156      ', 'TV BOA VISTA', 'L VALE                        ');
INSERT INTO cd_cep_br VALUES ('69.027-251', '156      ', 'BC BOA VISTA', 'S RAIMUNDO                    ');
INSERT INTO cd_cep_br VALUES ('69.027-250', '156      ', 'R BOA VISTA', 'S RAIMUNDO                    ');
INSERT INTO cd_cep_br VALUES ('69.048-130', '156      ', 'R BOA VISTA', 'PAZ                           ');
INSERT INTO cd_cep_br VALUES ('69.087-320', '156      ', 'R BOA VISTA', 'T NEVES                       ');
INSERT INTO cd_cep_br VALUES ('69.068-651', '156      ', 'BC BOA VISTA', 'RAIZ                          ');
INSERT INTO cd_cep_br VALUES ('69.030-170', '156      ', 'R BOA VISTA', 'S JORGE                       ');
INSERT INTO cd_cep_br VALUES ('69.073-154', '156      ', 'BC BOA VISTA', 'CRESPO                        ');
INSERT INTO cd_cep_br VALUES ('69.075-336', '156      ', 'BC BOA VISTA', 'MAUAZINHO                     ');
INSERT INTO cd_cep_br VALUES ('69.076-468', '156      ', 'TV BOA VISTA', 'JAPIIM                        ');
INSERT INTO cd_cep_br VALUES ('69.078-312', '156      ', 'BC BOA VISTA', 'JAPIIM                        ');
INSERT INTO cd_cep_br VALUES ('69.098-138', '156      ', 'R BOA VISTA(A. CLARAS)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.037-127', '156      ', 'R BOA VISTA (VL MILITAR KM 5)', 'P NEGRA                       ');
INSERT INTO cd_cep_br VALUES ('69.098-132', '156      ', 'R BOACHA(A. CLARAS)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.081-841', '156      ', 'R BOARI', 'J TEIXEIRA                    ');
INSERT INTO cd_cep_br VALUES ('69.088-842', '156      ', 'R BOARY', 'J TEIXEIRA                    ');
INSERT INTO cd_cep_br VALUES ('69.076-646', '156      ', 'TV BOCA DO ACRE', 'JAPIIM                        ');
INSERT INTO cd_cep_br VALUES ('69.081-350', '156      ', 'R BODO', 'J TEIXEIRA                    ');
INSERT INTO cd_cep_br VALUES ('69.065-031', '156      ', 'PC BENJAMIN CONSTANT', 'CACHOEIRINHA                  ');
INSERT INTO cd_cep_br VALUES ('69.033-640', '156      ', 'R BENJAMIN LIMA', 'S JORGE                       ');
INSERT INTO cd_cep_br VALUES ('69.033-590', '156      ', 'TV BENJAMIN LIMA', 'S JORGE                       ');
INSERT INTO cd_cep_br VALUES ('69.044-040', '156      ', 'R BENJAMIN LIMA (CJ BELVEDERE)', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('69.010-480', '156      ', 'R BENJAMIN SILVA', 'APARECIDA                     ');
INSERT INTO cd_cep_br VALUES ('69.063-430', '156      ', 'R BENTO BRASIL', 'PETROPOLIS                    ');
INSERT INTO cd_cep_br VALUES ('69.070-530', '156      ', 'R BENTO JOSE DE LIMA', 'EDUCANDOS                     ');
INSERT INTO cd_cep_br VALUES ('69.084-030', '156      ', 'R BERIMBAL BAIANO', 'Z PALMARES                    ');
INSERT INTO cd_cep_br VALUES ('69.045-040', '156      ', 'R BERLIM (CJ C ELISIOS)', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('69.045-640', '156      ', 'R BERNA (CJ C ELISIOS)', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('69.087-290', '156      ', 'R BERNARDO CABRAL', 'T NEVES                       ');
INSERT INTO cd_cep_br VALUES ('69.087-030', '156      ', 'BC BERNARDO CABRAL', 'T NEVES                       ');
INSERT INTO cd_cep_br VALUES ('69.082-450', '156      ', 'R BERNARDO CABRAL (O VERDE)', 'COROADO                       ');
INSERT INTO cd_cep_br VALUES ('69.057-110', '156      ', 'BC BERNARDO GOMES', 'ALEIXO                        ');
INSERT INTO cd_cep_br VALUES ('69.067-000', '156      ', 'R BERNARDO MICHILES', 'PETROPOLIS                    ');
INSERT INTO cd_cep_br VALUES ('69.005-310', '156      ', 'R BERNARDO RAMOS', 'CENTRO                        ');
INSERT INTO cd_cep_br VALUES ('69.074-050', '156      ', 'BC BERTINO MIRANDA', 'COL O MACHADO                 ');
INSERT INTO cd_cep_br VALUES ('69.074-060', '156      ', 'R BERTINO MIRANDA', 'COL O MACHADO                 ');
INSERT INTO cd_cep_br VALUES ('69.098-094', '156      ', 'TV BERTOPOLIS(A. CLARAS)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.076-474', '156      ', 'TV BERURI', 'JAPIIM                        ');
INSERT INTO cd_cep_br VALUES ('69.029-100', '156      ', 'R BESSA', 'S ANTONIO                     ');
INSERT INTO cd_cep_br VALUES ('69.073-770', '156      ', 'TV BETANIA', 'BETANIA                       ');
INSERT INTO cd_cep_br VALUES ('69.039-490', '156      ', 'R BETANIA', 'N ISRAEL                      ');
INSERT INTO cd_cep_br VALUES ('69.098-260', '156      ', 'R BETANIA', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.098-078', '156      ', 'R BETUMIRIM(A. CLARAS)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.037-670', '156      ', 'BC BILLING', 'L VALE                        ');
INSERT INTO cd_cep_br VALUES ('69.095-080', '156      ', 'R BIRIBA (CJ C NOVA)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.095-160', '156      ', 'AV BISPO PEDRO MASSA (CJ C NOVA)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.095-184', '156      ', 'TV BISPO PEDRO MASSA (RIACHO DOCE)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.027-382', '156      ', 'BC BITTENCOURT', 'GLORIA                        ');
INSERT INTO cd_cep_br VALUES ('69.036-050', '156      ', 'R BOA ESPERANCA', 'COMPENSA                      ');
INSERT INTO cd_cep_br VALUES ('69.080-050', '156      ', 'BC BOA ESPERANCA', 'COROADO                       ');
INSERT INTO cd_cep_br VALUES ('69.038-070', '156      ', 'R BOA ESPERANCA', 'N ESPERANCA                   ');
INSERT INTO cd_cep_br VALUES ('69.047-090', '156      ', 'R BOA ESPERANCA', 'REDENCAO                      ');
INSERT INTO cd_cep_br VALUES ('69.078-770', '156      ', 'R BOA ESPERANCA', 'JAPIIM                        ');
INSERT INTO cd_cep_br VALUES ('69.048-120', '156      ', 'R BOA ESPERANCA', 'PAZ                           ');
INSERT INTO cd_cep_br VALUES ('69.087-300', '156      ', 'R BOA ESPERANCA', 'T NEVES                       ');
INSERT INTO cd_cep_br VALUES ('69.033-800', '156      ', 'R BOA ESPERANCA', 'VL PRATA                      ');
INSERT INTO cd_cep_br VALUES ('69.042-420', '156      ', 'R BELA VISTA', 'N ESPERANCA                   ');
INSERT INTO cd_cep_br VALUES ('69.047-080', '156      ', 'R BELA VISTA', 'REDENCAO                      ');
INSERT INTO cd_cep_br VALUES ('69.030-570', '156      ', 'R BELA VISTA', 'VL PRATA                      ');
INSERT INTO cd_cep_br VALUES ('69.030-571', '156      ', 'TV BELA VISTA', 'VL PRATA                      ');
INSERT INTO cd_cep_br VALUES ('69.074-630', '156      ', 'R BELA VISTA', 'S LUZIA                       ');
INSERT INTO cd_cep_br VALUES ('69.050-710', '156      ', 'R BELA VISTA', 'COROADO                       ');
INSERT INTO cd_cep_br VALUES ('69.039-230', '156      ', 'R BELA VISTA', 'N ISRAEL                      ');
INSERT INTO cd_cep_br VALUES ('69.008-300', '156      ', 'R BELA VISTA', 'COL A ALEIXO                  ');
INSERT INTO cd_cep_br VALUES ('69.087-620', '156      ', 'BC BELA VISTA', 'T NEVES                       ');
INSERT INTO cd_cep_br VALUES ('69.089-102', '156      ', 'TV BELA VISTA', 'A MENDES                      ');
INSERT INTO cd_cep_br VALUES ('69.067-622', '156      ', 'BC BELA VISTA (VLE AMANHECER)', 'PETROPOLIS                    ');
INSERT INTO cd_cep_br VALUES ('69.035-081', '156      ', 'BC BELEM', 'COMPENSA                      ');
INSERT INTO cd_cep_br VALUES ('69.035-000', '156      ', 'R BELEM', 'COMPENSA                      ');
INSERT INTO cd_cep_br VALUES ('69.053-380', '156      ', 'R BELEM', 'N S GRACAS                    ');
INSERT INTO cd_cep_br VALUES ('69.039-380', '156      ', 'R BELEM', 'N ISRAEL                      ');
INSERT INTO cd_cep_br VALUES ('69.035-080', '156      ', 'TV BELEM', 'COMPENSA                      ');
INSERT INTO cd_cep_br VALUES ('69.099-009', '156      ', 'R BELEM(N. S. FATIMA)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.037-012', '156      ', 'AL BELGICA (CJ JD EUROPA)', 'P NEGRA                       ');
INSERT INTO cd_cep_br VALUES ('69.028-250', '156      ', 'R BELGICA (PRQ NACOES)', 'FLORES                        ');
INSERT INTO cd_cep_br VALUES ('69.045-630', '156      ', 'R BELGRADO (CJ C ELISIOS)', 'PLANALTO                      ');
INSERT INTO cd_cep_br VALUES ('69.053-620', '156      ', 'R BELMIRA COSTA', 'N S GRACAS                    ');
INSERT INTO cd_cep_br VALUES ('69.027-600', '156      ', 'R BELMIRO COSTA', 'GLORIA                        ');
INSERT INTO cd_cep_br VALUES ('69.093-485', '156      ', 'TV BELMIRO COSTA(T. NOVA I)', 'COL T NOVA                    ');
INSERT INTO cd_cep_br VALUES ('69.074-400', '156      ', 'BC CUMARU', 'S LUZIA                       ');
INSERT INTO cd_cep_br VALUES ('69.057-061', '156      ', 'BC BELO HORIZONTE', 'ALEIXO                        ');
INSERT INTO cd_cep_br VALUES ('69.036-101', '156      ', 'BC BELO HORIZONTE', 'COMPENSA                      ');
INSERT INTO cd_cep_br VALUES ('69.036-100', '156      ', 'R BELO HORIZONTE', 'COMPENSA                      ');
INSERT INTO cd_cep_br VALUES ('69.055-050', '156      ', 'CJ BELO HORIZONTE', 'PRQ 10 NOVEMBRO               ');
INSERT INTO cd_cep_br VALUES ('69.057-060', '156      ', 'R BELO HORIZONTE', 'ADRIANOPOLIS                  ');
INSERT INTO cd_cep_br VALUES ('69.087-610', '156      ', 'R BELO HORIZONTE', 'T NEVES                       ');
INSERT INTO cd_cep_br VALUES ('69.060-621', '156      ', 'TV BELO HORIZONTE', 'ALEIXO                        ');
INSERT INTO cd_cep_br VALUES ('69.030-121', '156      ', 'R BEM-AHI', 'S JORGE                       ');
INSERT INTO cd_cep_br VALUES ('69.095-030', '156      ', 'R BEM-TE-VI (CJ C NOVA)', 'C NOVA                        ');
INSERT INTO cd_cep_br VALUES ('69.082-823', '156      ', 'R BEM-TI-VI(MONTE SIAO)', 'COROADO                       ');
INSERT INTO cd_cep_br VALUES ('69.067-001', '156      ', 'AV BEM-TI-VI (VLE AMANHECER)', 'PETROPOLIS                    ');
INSERT INTO cd_cep